---
title: Дополнительные рекомендации
description: Библиотеки и сервисы, которые мы рекомендуем для многих проектов
layout: ../../layouts/docs.astro
lang: ru
---

Мы понимаем, что библиотеки, включенные в `create-t3-app`, не решают каждую проблему. Хотя мы рекомендуем начать свой проект с того, что мы предоставляем, придет время, когда вам нужно будет установить другие пакеты. Только вы можете знать, в чем нуждается ваш проект, но вот некоторые решения, которые мы часто рекомендуем.

Это рекомендации отдельных участников create-t3-app и не должны рассматриваться как "официальные" одобрения команды create-t3-app или T3-OSS. _**Пожалуйста, проведите собственное исследование, особенно перед тем, как привязываться к платным услугам**_.

## Управление состоянием

_**Примечание редактора**_: Библиотеки управления состоянием могут быть отличными, но часто не требуются. Хуки React Query tRPC должны справиться с вашим серверным состоянием. Для клиентского состояния начните с `useState` React, и обратитесь к одному из этих вариантов, когда вам нужно больше.

### Zustand

**Для того, чтобы больше никогда не писать Redux**

"Современный простой Redux", который вы не знали, что вам нужен. [Poimandres](https://github.com/pmndrs) всегда можно доверять. Вы можете создавать все, от видеозвонков до игр и серверов с этой маленькой библиотекой.

- [Zustand Homepage](https://zustand-demo.pmnd.rs/)
- [Zustand GitHub](https://github.com/pmndrs/zustand)

### Jotai

**Для того, чтобы больше никогда не писать Context**

В атомарном подходе Jotai трудно превзойти. Также от [Poimandres](https://github.com/pmndrs), Jotai позволяет определять синглтоны, которые кажутся глобальными useState. Отличный вариант для состояний, которые не требуют машины состояний прямо сейчас.

- [Jotai Homepage](https://jotai.org/)
- [Jotai GitHub](https://github.com/pmndrs/jotai)

## Библиотеки компонентов

Большинство приложений нуждаются в некотором наборе компонентов: переключатели, выпадающие меню, модальные окна и т.д. Эти библиотеки предоставляют отличные, доступные компоненты, которые вы можете использовать и настраивать по своему усмотрению.

### Библиотеки компонентов без стилей

Также известны как headless библиотеки, они предоставляют отличные, нестилизованные и доступные компоненты, которые вы можете настроить по своему усмотрению. Вот несколько рекомендаций.

- [Radix UI](https://www.radix-ui.com/) предоставляет вам мощный набор удобных и доступных примитивов, которые вы можете стилизовать с помощью обычного CSS или Tailwind CSS.

- [Headless UI](https://headlessui.com/) от команды Tailwind CSS также предоставляет нестилизованные, доступные компоненты, которые интегрируются безупречно с Tailwind CSS.

- [React Aria](https://react-spectrum.adobe.com/react-aria/) предоставляет доступные примитивы UI для вашей системы дизайна. Их компонент выбора даты - это высший уровень.

### Библиотеки компонентов со стилями

**Когда вам просто нужно, чтобы ваше приложение выглядело неплохо**

Иногда вы создаете проект, где вам просто нужно, чтобы пользовательский интерфейс выглядел нормально из коробки. Для административных панелей управления и других подобных проектов любая из этих библиотек компонентов справится с этой задачей.

- [Chakra UI](https://chakra-ui.com)
- [Mantine](https://mantine.dev)
- [@shadcn/ui](https://ui.shadcn.com/)

### Class Variance Authority

**Для создания библиотек пользовательского интерфейса**

Декларативно создавайте библиотеку пользовательского интерфейса с различными цветовыми, размерными и т.д. вариантами. Когда ваш проект достигает масштаба, где вам нужен стандартизированный набор компонентов пользовательского интерфейса с несколькими вариантами с использованием Tailwind CSS, CVA - отличный инструмент.

- [Class Variance Authority GitHub](https://github.com/joe-bell/cva)

## Анимации

Наши рекомендации для создания анимаций в вашем приложении.

### AutoAnimate

**Для анимаций с одной строкой кода**

Большенство библиотек анимации пытаются удовлетворить каждый возможный случай использования и в результате становятся громоздкими. AutoAnimate - это инструмент без конфигурации, который даст вам значительное улучшение UX без дополнительных усилий разработчика.

- [Главная страница AutoAnimate](https://auto-animate.formkit.com/)
- [AutoAnimate GitHub](https://github.com/formkit/auto-animate)
- [Компонент для AutoAnimate](https://gist.github.com/hwkr/3fdea5d7f609b98c162e5325637cf3cb)

### Framer Motion

**Для сложных анимаций с декларативным кодом**

Framer Motion предоставляет простой, декларативный синтаксис и позволяет вам писать меньше кода для создания всего: от сложных анимаций и даже до жестов.

- [Framer Motion Homepage](https://framer.com/motion)
- [Framer Motion Documentation](https://www.framer.com/docs/)

## Развертывание, инфраструктура, базы данных и CI

### Vercel

**Для хостинга (размещения) вашего приложения**

Vercel убрал мучения из процесса развертывания веб-приложений и сделал его простой "установил-и-забыл" интеграцией GitHub. Мы масштабировались до сотен тысяч пользователей без проблем. Работает на базе AWS, но имеет простой и удобный интерфейс :)

- [Главная страница Vercel](https://vercel.com/)
- [Гайд по развертыванию T3 приложения на Vercel](/ru/deployment/vercel)

### PlanetScale

**Для баз данных без беспокойства**

PlanetScale - лучшая serverless платформа для баз данных, которую мы использовали до сих пор. Невероятная масштабируемость, отличный DX и фантастическая цена. Если вы используете SQL (и, надеюсь, Prisma), это трудно превзойти.

- [Главная страница PlanetScale](https://planetscale.com/)

### Railway

**Для размещения вашей инфраструктуры**

"Современный Heroku". Самый простой способ запустить реальный сервер. Если вам не хватает функционала Vercel и PlanetScale, то Railway, вероятно, вам подойдет. Укажите его на репозиторий GitHub и готово.

- [Главная страница Railway](https://railway.app/)

### Upstash

**Для безсерверного Redis**

Мы любим Prisma и PlanetScale, но некоторые проекты требуют более производительного решения. Upstash позволяет вам получить in-memory производительность Redis в вашем безсерверном проекте, не заботясь о самостоятельном управлении инфраструктурой и масштабированием.

- [Главная страница Upstash](https://upstash.com/)

### Pusher

**Для безсерверных WebSocket**

Если WebSocket является основным фокусом вашего проекта, вы можете рассмотреть более традиционный бэкенд, такой как [Fastify](https://www.fastify.io/) (который [также работает с tRPC!](https://trpc.io/docs/v10/fastify)). Но для быстрого добавления WebSocket в T3 App, Pusher - отличный выбор.

- [Главная страница Pusher](https://pusher.com/)

### Soketi

Soketi - это само-развертываемая, простая и быстрая альтернатива Pusher. Он полностью совместим с Pusher SDK, который вы можете использовать для подключения к серверу. Soketi serverless также находится в бета-версии.

- [Главная страница Soketi](https://soketi.app)
- [Soketi GitHub](https://github.com/soketi/soketi)

## Аналитика

Пользовательские данные очень ценны, когда вы создаете приложение. Вот несколько рекомендуемых провайдеров аналитики.

### Plausible

Нужна аналитика? Plausible - один из самых быстрых способов ее получить. Супер минималистичный. У него даже есть [простой плагин для Next.js](https://plausible.io/docs/proxy/guides/nextjs).

- [Главная страница Plausible](https://plausible.io/)

### Umami

Umami - это само-развертываемая, простая, быстрая и конфиденциальная альтернатива Google Analytics. Вы можете легко развернуть его на Vercel, Railway и т.д. с PlanetScale в качестве базы данных.

- [Главная страница Umami](https://umami.is/)
- [Umami GitHub](https://github.com/umami-software/umami)

## Другое

### Next Bundle Analyzer

Бывает сложно определить, что будет включено в сборку выходных данных для вашего приложения. Next Bundle Analyzer - это простой способ визуализировать и анализировать JavaScript-бандлы, которые генерируются.

- [@next/bundle-analyzer на npm](https://www.npmjs.com/package/@next/bundle-analyzer)
