---
title: Введение
description: Введение в T3 стек
layout: ../../layouts/docs.astro
lang: ru
---

<div class="embed">
<iframe width="560" height="315" src="https://www.youtube.com/embed/YkOSUVzOAA4" title="The best stack for your next project" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
</div>

## T3 Stack

_«T3 Stack»_ - это стек веб-разработки, созданный [Theo](https://twitter.com/t3dotgg), с упором на простоту, модульность и full-stack типизацию.

Основные части - [**Next.js**](https://nextjs.org/) и [**TypeScript**](https://typescriptlang.org/). [**Tailwind CSS**](https://tailwindcss.com/) почти всегда включен. Если вы делаете что-то напоминающее бэкенд, [**tRPC**](https://trpc.io/), [**Prisma**](https://prisma.io/), и [**NextAuth.js**](https://next-auth.js.org/) - отличные дополнения.

Вы могли заметить, что существует… много частей. Это сделано намеренно. Меняйте части в зависимости от ваших потребностей - этот стек является модульным по своей сути :)

## И... что такое create-t3-app? Шаблон?

Возможно? `create-t3-app` это CLI, созданный опытными разработчиками T3 стека, чтобы упростить настройку модульного приложения T3 стека. Это означает, что каждая часть является необязательной, и «шаблон» генерируется на основе ваших конкретных потребностей.

После множества проектов и многих лет с этой технологией у нас есть множество мнений и знаний. Мы постарались зафиксировать их в этом CLI.

Это **НЕ** всеобъемлющий шаблон. Мы **ожидаем**, что вы будете использовать свои собственные библиотеки, которые решают потребности **ВАШЕГО** приложения. Хотя мы не хотим назначать решения для более конкретных проблем, таких как управление состоянием и развертывание, мы [имеем некоторые рекомендации, перечисленные здесь](/ru/other-recs).

## Аксиомы T3

Будем честными - это _субъективный проект_. Мы поделились несколькими основными убеждениями вокруг создания и рассматриваем их как основу для наших решений.

### Решайте проблемы

Легко попасть в ловушку "добавления всего" - мы явно не хотим этого делать. Все, что добавляется в `create-t3-app`, должно решать конкретную проблему, которая существует в основных технологиях, включенных в него. Это означает, что мы не добавим библиотеки менеджмента состояния (`zustand`, `redux`), но мы добавим NextAuth.js и интегрируем Prisma и tRPC для вас.

### Ответственность к новинкам

Мы любим технологические новинки. Получаемые скорость и, честно говоря, веселье от новых фиговин, действительно круто. Мы считаем важным использовать их ответственно, используя более рискованные технологии в менее рискованных частях. Это означает, что мы не будем ⛔️ делать ставку на рискованную новую технологию базы данных (SQL - это здорово!). Но мы с удовольствием ✅ сделаем ставку на tRPC, поскольку это просто функции, которые легко перенести.

### Типобезопасность не является опциональной

Указаная цель `create-t3-app` - это предоставить самый быстрый способ начать новое полнофункциональное, **типобезопасное** веб-приложение. Мы серьезно относимся к типобезопасности в этих частях, поскольку она повышает нашу продуктивность и помогает нам отправлять меньше ошибок. Любое решение, которое снижает типобезопасность `create-t3-app`, должно быть принято в другом проекте.
