---
title: مقدمة
description: مقدمة إلى T3 Stack
layout: ../../layouts/docs.astro
lang: ar
dir: rtl
---

<div class="embed">
<iframe width="560" height="315" src="https://www.youtube.com/embed/YkOSUVzOAA4" title="The best stack for your next project" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
</div>

## T3 Stack

الـ T3 Stack هو Stack لتطوير تطبيقات الويب بُني علي فَلسفة البساطة، قابلية إعادة الاستخدام (فصل المركبات وإعادة استخدامها) و الحصول على typesafety في جميع أزكان التطبيق.

الأجزاء الأساسية هم [**Next.js**](https://nextjs.org/)، و [**TypeScript**](https://typescriptlang.org/)، و [**Tailwind CSS**](https://tailwindcss.com/) ودائما ما تَكون مُضافة، إذا كان مشروعك يتطلب Backend فَيُمكنك إضافة [**tRPC**](https://trpc.io/)، و [**Prisma**](https://prisma.io/)، و [**NextAuth.js**](https://next-auth.js.org/).

لعلك لاحظت أن هناك الكثير من... الأجزاء. هذا ما رغبنا بتصميمه, لك مُطلق الحرية أن تُضف جزء وتَحذف أُخرى كما تحتاج - يكون أساس Stack خاضع لاحتياجاتك.

## حسنا… ما هو create-t3-app؟ أهو قالب (template)؟

نوعا من. أُنشئ `create-t3-app` بواسطة مطورون متمرسون ليبسط CLI إعداد تطبيق T3 قَدر الإمكان. فَكُل جزء اختياري، هذا يعني أنك تنشئ قالبك حسب احتياجك.

بعد أنشاء العديد من المشروعات وممارسة تلك الأدوات لسنين، كسبنا العديد من الخبرات والآراء، وفعلنا قدر المستطاع لوضعهم داخل CLI.

**أنه ليس** بقالب شامل علي كل ما تحتاجة، نتوقع منك أن تُضيف مكتباتك الخاصة لحل ما سيواجهك من مشكلات **في تطبيقك**. علي الرغم من أننا نريد أن نترك لك مُطلق الحرية في حل المشاكل مثل state management ونشر التطبيق، [لكن لدينا بعض الترشيحات لك](/ar/other-recs).

## T3 Axioms

لنكون شفافون - هذا _مشروع متعدد الآراء_. نتشارك جميعاََ في عدد قليل من المعتقدات الأساسية حَول كيفية البناء ونتخذها كأساس قراراتنا.

### Solve Problems

من السهل أن تَقع في فخ فتُضيف "كل شيئ" - لكننا لا نريد ذَلك صراحتاً، يَجب أن يكون لكل شيئ مَغزي وهدف مُحدد كما هو الحال في ما أضفناه مُسبقا ويَترتب علي ذلك عدم إضافة مكتبات مِثل (`zustand`, `redux`)، لكننا نُضيف مكتبات أُخري مُثل NextAuth.js, و Prisma و tRPC.

### غامر، لكن علي مسؤوليتك

نحن نحب التقنيات الحديثة، تجرِبة الأشياء الجديدة تجلب السعادة، لكن عليك تَوخى الحذر فلا تَستخدام التقنيات الغير مستقرة في الأماكن الحساسة، فمثلا نحن لا نراهن ⛔️ على قواعد بيانات حديثة (فإن SQL رائعة)، لكننا نراهن ✅ علي tRPC لأنها مجرد Functions ومن السهل الاستغناء عنها.

### Typesafety ليس خياراََ

قد حددنا مُسبقاَ أن الهدف الأوحد من `create-t3-app` هو أن نوفر بِداية سَريعة لتطوير تطبيقات full-stack مع اتخاذ **typesafe** كأولوية, فهو أمر لابد منه لتحسين فاعليتك كمطور بواسطة تقليل عدد Bugs قدر الإمكان.
أي حل وسط يضر typesafe في `create-t3-app` يَجب اتخاذه في مشروع مختلف.
