{
  This file is a part of the Open Source Synopse mORMot framework 2,
  licensed under a MPL/GPL/LGPL three license - see LICENSE.md

  Declaration of the full OpenSSL 1.1 API, as used by mormot.lib.openssl11.pas
  Not included by default to reduce the unit size - set OPENSSLFULLAPI conditional

  WARNING:
    1. some declarations are either missing, or probably not fully
       cross-platform (e.g. integer instead of clong) - feedback needed!
    2. when OPENSSLFULLAPI conditional is set, no dynamic linking is possible
       any more so it is linked at startup or statically at compilation
}

{ ******************** OpenSSL Library Constants }

const
  OPENSSL_VER_1100 = $1010000f; // 1.1.0
  OPENSSL_VER_1101 = $10101000; // 1.1.1
  OPENSSL_VERSION_NUMBER = $1010107f;

  SHLIB_VERSION_HISTORY = '';
  SHLIB_VERSION_NUMBER = '1.1';
  
  OPENSSL_SYS_WIN32 = 1;
  OPENSSL_MIN_API = 0;
  OPENSSL_API_COMPAT = OPENSSL_MIN_API;
  
  _AES_ENCRYPT = 1;
  _AES_DECRYPT = 0;
  AES_MAXNR = 14;
  AES_BLOCK_SIZE = 16;
  
  _I64_MAX = 9223372036854775807; 
  OSSL_SSIZE_MAX = _I64_MAX;
  
  CRYPTO_F_CMAC_CTX_NEW = 120;
  CRYPTO_F_CRYPTO_DUP_EX_DATA = 110;
  CRYPTO_F_CRYPTO_FREE_EX_DATA = 111;
  CRYPTO_F_CRYPTO_GET_EX_NEW_INDEX = 100;
  CRYPTO_F_CRYPTO_MEMDUP = 115;
  CRYPTO_F_CRYPTO_NEW_EX_DATA = 112;
  CRYPTO_F_CRYPTO_OCB128_COPY_CTX = 121;
  CRYPTO_F_CRYPTO_OCB128_INIT = 122;
  CRYPTO_F_CRYPTO_SET_EX_DATA = 102;
  CRYPTO_F_FIPS_MODE_SET = 109;
  CRYPTO_F_GET_AND_LOCK = 113;
  CRYPTO_F_OPENSSL_ATEXIT = 114;
  CRYPTO_F_OPENSSL_BUF2HEXSTR = 117;
  CRYPTO_F_OPENSSL_FOPEN = 119;
  CRYPTO_F_OPENSSL_HEXSTR2BUF = 118;
  CRYPTO_F_OPENSSL_INIT_CRYPTO = 116;
  CRYPTO_F_OPENSSL_LH_NEW = 126;
  CRYPTO_F_OPENSSL_SK_DEEP_COPY = 127;
  CRYPTO_F_OPENSSL_SK_DUP = 128;
  CRYPTO_F_PKEY_HMAC_INIT = 123;
  CRYPTO_F_PKEY_POLY1305_INIT = 124;
  CRYPTO_F_PKEY_SIPHASH_INIT = 125;
  CRYPTO_F_SK_RESERVE = 129;
  CRYPTO_R_FIPS_MODE_NOT_SUPPORTED = 101;
  CRYPTO_R_ILLEGAL_HEX_DIGIT = 102;
  CRYPTO_R_ODD_NUMBER_OF_DIGITS = 103;
  
  SSLEAY_VERSION_NUMBER = OPENSSL_VERSION_NUMBER; 
  SSLEAY_CFLAGS = OPENSSL_CFLAGS;
  SSLEAY_BUILT_ON = OPENSSL_BUILT_ON;
  SSLEAY_PLATFORM = OPENSSL_PLATFORM;
  SSLEAY_DIR = OPENSSL_DIR;
  
  CRYPTO_MEM_CHECK_OFF = $0;
  CRYPTO_MEM_CHECK_ON = $1;
  CRYPTO_MEM_CHECK_ENABLE = $2;
  CRYPTO_MEM_CHECK_DISABLE = $3;
  OPENSSL_ENGINES_DIR = 5;
  CRYPTO_LOCK = 1;
  CRYPTO_UNLOCK = 2;
  CRYPTO_READ = 4;
  CRYPTO_WRITE = 8;
  
  OPENSSL_INIT_NO_LOAD_CRYPTO_STRINGS = $00000001;
  OPENSSL_INIT_LOAD_CRYPTO_STRINGS = $00000002;
  OPENSSL_INIT_ADD_ALL_CIPHERS = $00000004;
  OPENSSL_INIT_ADD_ALL_DIGESTS = $00000008;
  OPENSSL_INIT_NO_ADD_ALL_CIPHERS = $00000010;
  OPENSSL_INIT_NO_ADD_ALL_DIGESTS = $00000020;
  OPENSSL_INIT_LOAD_CONFIG = $00000040;
  OPENSSL_INIT_NO_LOAD_CONFIG = $00000080;
  OPENSSL_INIT_ASYNC = $00000100;
  OPENSSL_INIT_ENGINE_RDRAND = $00000200;
  OPENSSL_INIT_ENGINE_DYNAMIC = $00000400;
  OPENSSL_INIT_ENGINE_OPENSSL = $00000800;
  OPENSSL_INIT_ENGINE_CRYPTODEV = $00001000;
  OPENSSL_INIT_ENGINE_CAPI = $00002000;
  OPENSSL_INIT_ENGINE_PADLOCK = $00004000;
  OPENSSL_INIT_ENGINE_AFALG = $00008000;
  OPENSSL_INIT_ATFORK = $00020000;
  OPENSSL_INIT_NO_ATEXIT = $00080000;
  OPENSSL_INIT_ENGINE_ALL_BUILTIN = OPENSSL_INIT_ENGINE_RDRAND or
                                    OPENSSL_INIT_ENGINE_DYNAMIC or
                                    OPENSSL_INIT_ENGINE_CRYPTODEV or
                                    OPENSSL_INIT_ENGINE_CAPI or
                                    OPENSSL_INIT_ENGINE_PADLOCK;
  CRYPTO_ONCE_STATIC_INIT = 0;
  
  BIO_F_ACPT_STATE = 100;
  BIO_F_ADDRINFO_WRAP = 148;
  BIO_F_ADDR_STRINGS = 134;
  BIO_F_BIO_ACCEPT = 101;
  BIO_F_BIO_ACCEPT_EX = 137;
  BIO_F_BIO_ACCEPT_NEW = 152;
  BIO_F_BIO_ADDR_NEW = 144;
  BIO_F_BIO_BIND = 147;
  BIO_F_BIO_CALLBACK_CTRL = 131;
  BIO_F_BIO_CONNECT = 138;
  BIO_F_BIO_CONNECT_NEW = 153;
  BIO_F_BIO_CTRL = 103;
  BIO_F_BIO_GETS = 104;
  BIO_F_BIO_GET_HOST_IP = 106;
  BIO_F_BIO_GET_NEW_INDEX = 102;
  BIO_F_BIO_GET_PORT = 107;
  BIO_F_BIO_LISTEN = 139;
  BIO_F_BIO_LOOKUP = 135;
  BIO_F_BIO_LOOKUP_EX = 143;
  BIO_F_BIO_MAKE_PAIR = 121;
  BIO_F_BIO_METH_NEW = 146;
  BIO_F_BIO_NEW = 108;
  BIO_F_BIO_NEW_DGRAM_SCTP = 145;
  BIO_F_BIO_NEW_FILE = 109;
  BIO_F_BIO_NEW_MEM_BUF = 126;
  BIO_F_BIO_NREAD = 123;
  BIO_F_BIO_NREAD0 = 124;
  BIO_F_BIO_NWRITE = 125;
  BIO_F_BIO_NWRITE0 = 122;
  BIO_F_BIO_PARSE_HOSTSERV = 136;
  BIO_F_BIO_PUTS = 110;
  BIO_F_BIO_READ = 111;
  BIO_F_BIO_READ_EX = 105;
  BIO_F_BIO_READ_INTERN = 120;
  BIO_F_BIO_SOCKET = 140;
  BIO_F_BIO_SOCKET_NBIO = 142;
  BIO_F_BIO_SOCK_INFO = 141;
  BIO_F_BIO_SOCK_INIT = 112;
  BIO_F_BIO_WRITE = 113;
  BIO_F_BIO_WRITE_EX = 119;
  BIO_F_BIO_WRITE_INTERN = 128;
  BIO_F_BUFFER_CTRL = 114;
  BIO_F_CONN_CTRL = 127;
  BIO_F_CONN_STATE = 115;
  BIO_F_DGRAM_SCTP_NEW = 149;
  BIO_F_DGRAM_SCTP_READ = 132;
  BIO_F_DGRAM_SCTP_WRITE = 133;
  BIO_F_DOAPR_OUTCH = 150;
  BIO_F_FILE_CTRL = 116;
  BIO_F_FILE_READ = 130;
  BIO_F_LINEBUFFER_CTRL = 129;
  BIO_F_LINEBUFFER_NEW = 151;
  BIO_F_MEM_WRITE = 117;
  BIO_F_NBIOF_NEW = 154;
  BIO_F_SLG_WRITE = 155;
  BIO_F_SSL_NEW = 118;
  
  BIO_R_ACCEPT_ERROR = 100;
  BIO_R_ADDRINFO_ADDR_IS_NOT_AF_INET = 141;
  BIO_R_AMBIGUOUS_HOST_OR_SERVICE = 129;
  BIO_R_BAD_FOPEN_MODE = 101;
  BIO_R_BROKEN_PIPE = 124;
  BIO_R_CONNECT_ERROR = 103;
  BIO_R_GETHOSTBYNAME_ADDR_IS_NOT_AF_INET = 107;
  BIO_R_GETSOCKNAME_ERROR = 132;
  BIO_R_GETSOCKNAME_TRUNCATED_ADDRESS = 133;
  BIO_R_GETTING_SOCKTYPE = 134;
  BIO_R_INVALID_ARGUMENT = 125;
  BIO_R_INVALID_SOCKET = 135;
  BIO_R_IN_USE = 123;
  BIO_R_LENGTH_TOO_LONG = 102;
  BIO_R_LISTEN_V6_ONLY = 136;
  BIO_R_LOOKUP_RETURNED_NOTHING = 142;
  BIO_R_MALFORMED_HOST_OR_SERVICE = 130;
  BIO_R_NBIO_CONNECT_ERROR = 110;
  BIO_R_NO_ACCEPT_ADDR_OR_SERVICE_SPECIFIED = 143;
  BIO_R_NO_HOSTNAME_OR_SERVICE_SPECIFIED = 144;
  BIO_R_NO_PORT_DEFINED = 113;
  BIO_R_NO_SUCH_FILE = 128;
  BIO_R_NULL_PARAMETER = 115;
  BIO_R_UNABLE_TO_BIND_SOCKET = 117;
  BIO_R_UNABLE_TO_CREATE_SOCKET = 118;
  BIO_R_UNABLE_TO_KEEPALIVE = 137;
  BIO_R_UNABLE_TO_LISTEN_SOCKET = 119;
  BIO_R_UNABLE_TO_NODELAY = 138;
  BIO_R_UNABLE_TO_REUSEADDR = 139;
  BIO_R_UNAVAILABLE_IP_FAMILY = 145;
  BIO_R_UNINITIALIZED = 120;
  BIO_R_UNKNOWN_INFO_TYPE = 140;
  BIO_R_UNSUPPORTED_IP_FAMILY = 146;
  BIO_R_UNSUPPORTED_METHOD = 121;
  BIO_R_UNSUPPORTED_PROTOCOL_FAMILY = 131;
  BIO_R_WRITE_TO_READ_ONLY_BIO = 126;
  BIO_R_WSASTARTUP = 122;
  
  BIO_TYPE_DESCRIPTOR = $0100;
  BIO_TYPE_FILTER = $0200;
  BIO_TYPE_SOURCE_SINK = $0400;
  BIO_TYPE_NONE = 0;
  BIO_TYPE_MEM = 1 or BIO_TYPE_SOURCE_SINK;
  BIO_TYPE_FILE = 2 or BIO_TYPE_SOURCE_SINK;
  BIO_TYPE_FD = 4 or BIO_TYPE_SOURCE_SINK or BIO_TYPE_DESCRIPTOR;
  BIO_TYPE_SOCKET = 5 or BIO_TYPE_SOURCE_SINK or BIO_TYPE_DESCRIPTOR;
  BIO_TYPE_NULL = 6 or BIO_TYPE_SOURCE_SINK;
  BIO_TYPE_SSL = 7 or BIO_TYPE_FILTER;
  BIO_TYPE_MD = 8 or BIO_TYPE_FILTER;
  BIO_TYPE_BUFFER = 9 or BIO_TYPE_FILTER;
  BIO_TYPE_CIPHER = 10 or BIO_TYPE_FILTER;
  BIO_TYPE_BASE64 = 11 or BIO_TYPE_FILTER;
  BIO_TYPE_CONNECT = 12 or BIO_TYPE_SOURCE_SINK or BIO_TYPE_DESCRIPTOR;
  BIO_TYPE_ACCEPT = 13 or BIO_TYPE_SOURCE_SINK or BIO_TYPE_DESCRIPTOR;
  BIO_TYPE_NBIO_TEST = 16 or BIO_TYPE_FILTER;
  BIO_TYPE_NULL_FILTER = 17 or BIO_TYPE_FILTER;
  BIO_TYPE_BIO = 19 or BIO_TYPE_SOURCE_SINK;
  BIO_TYPE_LINEBUFFER = 20 or BIO_TYPE_FILTER;
  BIO_TYPE_DGRAM = 21 or BIO_TYPE_SOURCE_SINK or BIO_TYPE_DESCRIPTOR;
  BIO_TYPE_ASN1 = 22 or BIO_TYPE_FILTER;
  BIO_TYPE_COMP = 23 or BIO_TYPE_FILTER;
  BIO_TYPE_START = 128;
  
  BIO_NOCLOSE = $00;
  BIO_CLOSE = $01;

  BIO_FP_READ = $02;
  BIO_FP_WRITE = $04;
  BIO_FP_APPEND = $08;
  BIO_FP_TEXT = $10;
  
  BIO_FLAGS_UPLINK = 0;
  BIO_FLAGS_BASE64_NO_NL = $100;
  BIO_FLAGS_MEM_RDONLY = $200;
  BIO_FLAGS_NONCLEAR_RST = $400;
  BIO_FLAGS_IN_EOF = $800;
  
  BIO_RR_SSL_X509_LOOKUP = $01;
  BIO_RR_CONNECT = $02;
  BIO_RR_ACCEPT = $03;
  
  BIO_CB_FREE = $01;
  BIO_CB_READ = $02;
  BIO_CB_WRITE = $03;
  BIO_CB_PUTS = $04;
  BIO_CB_GETS = $05;
  BIO_CB_CTRL = $06;
  BIO_CB_RETURN = $80;
   
  BIO_FAMILY_IPV4 = 4;
  BIO_FAMILY_IPV6 = 6;
  BIO_FAMILY_IPANY = 256;
  
  BIO_SOCK_REUSEADDR = $01;
  BIO_SOCK_V6_ONLY = $02;
  BIO_SOCK_KEEPALIVE = $04;
  BIO_SOCK_NONBLOCK = $08;
  BIO_SOCK_NODELAY = $10;
  
  BIO_BIND_NORMAL = 0;
  BIO_BIND_REUSEADDR = BIO_SOCK_REUSEADDR;
  BIO_BIND_REUSEADDR_IF_UNUSED = BIO_SOCK_REUSEADDR;

  ASN1_F_A2D_ASN1_OBJECT = 100;
  ASN1_F_A2I_ASN1_INTEGER = 102;
  ASN1_F_A2I_ASN1_STRING = 103;
  ASN1_F_APPEND_EXP = 176;
  ASN1_F_ASN1_BIO_INIT = 113;
  ASN1_F_ASN1_BIT_STRING_SET_BIT = 183;
  ASN1_F_ASN1_CB = 177;
  ASN1_F_ASN1_CHECK_TLEN = 104;
  ASN1_F_ASN1_COLLECT = 106;
  ASN1_F_ASN1_D2I_EX_PRIMITIVE = 108;
  ASN1_F_ASN1_D2I_FP = 109;
  ASN1_F_ASN1_D2I_READ_BIO = 107;
  ASN1_F_ASN1_DIGEST = 184;
  ASN1_F_ASN1_DO_ADB = 110;
  ASN1_F_ASN1_DO_LOCK = 233;
  ASN1_F_ASN1_DUP = 111;
  ASN1_F_ASN1_ENC_SAVE = 115;
  ASN1_F_ASN1_EX_C2I = 204;
  ASN1_F_ASN1_FIND_END = 190;
  ASN1_F_ASN1_GENERALIZEDTIME_ADJ = 216;
  ASN1_F_ASN1_GENERATE_V3 = 178;
  ASN1_F_ASN1_GET_INT64 = 224;
  ASN1_F_ASN1_GET_OBJECT = 114;
  ASN1_F_ASN1_GET_UINT64 = 225;
  ASN1_F_ASN1_I2D_BIO = 116;
  ASN1_F_ASN1_I2D_FP = 117;
  ASN1_F_ASN1_ITEM_D2I_FP = 206;
  ASN1_F_ASN1_ITEM_DUP = 191;
  ASN1_F_ASN1_ITEM_EMBED_D2I = 120;
  ASN1_F_ASN1_ITEM_EMBED_NEW = 121;
  ASN1_F_ASN1_ITEM_FLAGS_I2D = 118;
  ASN1_F_ASN1_ITEM_I2D_BIO = 192;
  ASN1_F_ASN1_ITEM_I2D_FP = 193;
  ASN1_F_ASN1_ITEM_PACK = 198;
  ASN1_F_ASN1_ITEM_SIGN = 195;
  ASN1_F_ASN1_ITEM_SIGN_CTX = 220;
  ASN1_F_ASN1_ITEM_UNPACK = 199;
  ASN1_F_ASN1_ITEM_VERIFY = 197;
  ASN1_F_ASN1_MBSTRING_NCOPY = 122;
  ASN1_F_ASN1_OBJECT_NEW = 123;
  ASN1_F_ASN1_OUTPUT_DATA = 214;
  ASN1_F_ASN1_PCTX_NEW = 205;
  ASN1_F_ASN1_PRIMITIVE_NEW = 119;
  ASN1_F_ASN1_SCTX_NEW = 221;
  ASN1_F_ASN1_SIGN = 128;
  ASN1_F_ASN1_STR2TYPE = 179;
  ASN1_F_ASN1_STRING_GET_INT64 = 227;
  ASN1_F_ASN1_STRING_GET_UINT64 = 230;
  ASN1_F_ASN1_STRING_SET = 186;
  ASN1_F_ASN1_STRING_TABLE_ADD = 129;
  ASN1_F_ASN1_STRING_TO_BN = 228;
  ASN1_F_ASN1_STRING_TYPE_NEW = 130;
  ASN1_F_ASN1_TEMPLATE_EX_D2I = 132;
  ASN1_F_ASN1_TEMPLATE_NEW = 133;
  ASN1_F_ASN1_TEMPLATE_NOEXP_D2I = 131;
  ASN1_F_ASN1_TIME_ADJ = 217;
  ASN1_F_ASN1_TYPE_GET_INT_OCTETSTRING = 134;
  ASN1_F_ASN1_TYPE_GET_OCTETSTRING = 135;
  ASN1_F_ASN1_UTCTIME_ADJ = 218;
  ASN1_F_ASN1_VERIFY = 137;
  ASN1_F_B64_READ_ASN1 = 209;
  ASN1_F_B64_WRITE_ASN1 = 210;
  ASN1_F_BIO_NEW_NDEF = 208;
  ASN1_F_BITSTR_CB = 180;
  ASN1_F_BN_TO_ASN1_STRING = 229;
  ASN1_F_C2I_ASN1_BIT_STRING = 189;
  ASN1_F_C2I_ASN1_INTEGER = 194;
  ASN1_F_C2I_ASN1_OBJECT = 196;
  ASN1_F_C2I_IBUF = 226;
  ASN1_F_C2I_UINT64_INT = 101;
  ASN1_F_COLLECT_DATA = 140;
  ASN1_F_D2I_ASN1_OBJECT = 147;
  ASN1_F_D2I_ASN1_UINTEGER = 150;
  ASN1_F_D2I_AUTOPRIVATEKEY = 207;
  ASN1_F_D2I_PRIVATEKEY = 154;
  ASN1_F_D2I_PUBLICKEY = 155;
  ASN1_F_DO_BUF = 142;
  ASN1_F_DO_CREATE = 124;
  ASN1_F_DO_DUMP = 125;
  ASN1_F_DO_TCREATE = 222;
  ASN1_F_I2A_ASN1_OBJECT = 126;
  ASN1_F_I2D_ASN1_BIO_STREAM = 211;
  ASN1_F_I2D_ASN1_OBJECT = 143;
  ASN1_F_I2D_DSA_PUBKEY = 161;
  ASN1_F_I2D_EC_PUBKEY = 181;
  ASN1_F_I2D_PRIVATEKEY = 163;
  ASN1_F_I2D_PUBLICKEY = 164;
  ASN1_F_I2D_RSA_PUBKEY = 165;
  ASN1_F_LONG_C2I = 166;
  ASN1_F_NDEF_PREFIX = 127;
  ASN1_F_NDEF_SUFFIX = 136;
  ASN1_F_OID_MODULE_INIT = 174;
  ASN1_F_PARSE_TAGGING = 182;
  ASN1_F_PKCS5_PBE2_SET_IV = 167;
  ASN1_F_PKCS5_PBE2_SET_SCRYPT = 231;
  ASN1_F_PKCS5_PBE_SET = 202;
  ASN1_F_PKCS5_PBE_SET0_ALGOR = 215;
  ASN1_F_PKCS5_PBKDF2_SET = 219;
  ASN1_F_PKCS5_SCRYPT_SET = 232;
  ASN1_F_SMIME_READ_ASN1 = 212;
  ASN1_F_SMIME_TEXT = 213;
  ASN1_F_STABLE_GET = 138;
  ASN1_F_STBL_MODULE_INIT = 223;
  ASN1_F_UINT32_C2I = 105;
  ASN1_F_UINT32_NEW = 139;
  ASN1_F_UINT64_C2I = 112;
  ASN1_F_UINT64_NEW = 141;
  ASN1_F_X509_CRL_ADD0_REVOKED = 169;
  ASN1_F_X509_INFO_NEW = 170;
  ASN1_F_X509_NAME_ENCODE = 203;
  ASN1_F_X509_NAME_EX_D2I = 158;
  ASN1_F_X509_NAME_EX_NEW = 171;
  ASN1_F_X509_PKEY_NEW = 173;
  
  ASN1_R_ADDING_OBJECT = 171;
  ASN1_R_ASN1_PARSE_ERROR = 203;
  ASN1_R_ASN1_SIG_PARSE_ERROR = 204;
  ASN1_R_AUX_ERROR = 100;
  ASN1_R_BAD_OBJECT_HEADER = 102;
  ASN1_R_BMPSTRING_IS_WRONG_LENGTH = 214;
  ASN1_R_BN_LIB = 105;
  ASN1_R_BOOLEAN_IS_WRONG_LENGTH = 106;
  ASN1_R_BUFFER_TOO_SMALL = 107;
  ASN1_R_CIPHER_HAS_NO_OBJECT_IDENTIFIER = 108;
  ASN1_R_CONTEXT_NOT_INITIALISED = 217;
  ASN1_R_DATA_IS_WRONG = 109;
  ASN1_R_DECODE_ERROR = 110;
  ASN1_R_DEPTH_EXCEEDED = 174;
  ASN1_R_DIGEST_AND_KEY_TYPE_NOT_SUPPORTED = 198;
  ASN1_R_ENCODE_ERROR = 112;
  ASN1_R_ERROR_GETTING_TIME = 173;
  ASN1_R_ERROR_LOADING_SECTION = 172;
  ASN1_R_ERROR_SETTING_CIPHER_PARAMS = 114;
  ASN1_R_EXPECTING_AN_INTEGER = 115;
  ASN1_R_EXPECTING_AN_OBJECT = 116;
  ASN1_R_EXPLICIT_LENGTH_MISMATCH = 119;
  ASN1_R_EXPLICIT_TAG_NOT_CONSTRUCTED = 120;
  ASN1_R_FIELD_MISSING = 121;
  ASN1_R_FIRST_NUM_TOO_LARGE = 122;
  ASN1_R_HEADER_TOO_LONG = 123;
  ASN1_R_ILLEGAL_BITSTRING_FORMAT = 175;
  ASN1_R_ILLEGAL_BOOLEAN = 176;
  ASN1_R_ILLEGAL_CHARACTERS = 124;
  ASN1_R_ILLEGAL_FORMAT = 177;
  ASN1_R_ILLEGAL_HEX = 178;
  ASN1_R_ILLEGAL_IMPLICIT_TAG = 179;
  ASN1_R_ILLEGAL_INTEGER = 180;
  ASN1_R_ILLEGAL_NEGATIVE_VALUE = 226;
  ASN1_R_ILLEGAL_NESTED_TAGGING = 181;
  ASN1_R_ILLEGAL_NULL = 125;
  ASN1_R_ILLEGAL_NULL_VALUE = 182;
  ASN1_R_ILLEGAL_OBJECT = 183;
  ASN1_R_ILLEGAL_OPTIONAL_ANY = 126;
  ASN1_R_ILLEGAL_OPTIONS_ON_ITEM_TEMPLATE = 170;
  ASN1_R_ILLEGAL_PADDING = 221;
  ASN1_R_ILLEGAL_TAGGED_ANY = 127;
  ASN1_R_ILLEGAL_TIME_VALUE = 184;
  ASN1_R_ILLEGAL_ZERO_CONTENT = 222;
  ASN1_R_INTEGER_NOT_ASCII_FORMAT = 185;
  ASN1_R_INTEGER_TOO_LARGE_FOR_LONG = 128;
  ASN1_R_INVALID_BIT_STRING_BITS_LEFT = 220;
  ASN1_R_INVALID_BMPSTRING_LENGTH = 129;
  ASN1_R_INVALID_DIGIT = 130;
  ASN1_R_INVALID_MIME_TYPE = 205;
  ASN1_R_INVALID_MODIFIER = 186;
  ASN1_R_INVALID_NUMBER = 187;
  ASN1_R_INVALID_OBJECT_ENCODING = 216;
  ASN1_R_INVALID_SCRYPT_PARAMETERS = 227;
  ASN1_R_INVALID_SEPARATOR = 131;
  ASN1_R_INVALID_STRING_TABLE_VALUE = 218;
  ASN1_R_INVALID_UNIVERSALSTRING_LENGTH = 133;
  ASN1_R_INVALID_UTF8STRING = 134;
  ASN1_R_INVALID_VALUE = 219;
  ASN1_R_LIST_ERROR = 188;
  ASN1_R_MIME_NO_CONTENT_TYPE = 206;
  ASN1_R_MIME_PARSE_ERROR = 207;
  ASN1_R_MIME_SIG_PARSE_ERROR = 208;
  ASN1_R_MISSING_EOC = 137;
  ASN1_R_MISSING_SECOND_NUMBER = 138;
  ASN1_R_MISSING_VALUE = 189;
  ASN1_R_MSTRING_NOT_UNIVERSAL = 139;
  ASN1_R_MSTRING_WRONG_TAG = 140;
  ASN1_R_NESTED_ASN1_STRING = 197;
  ASN1_R_NESTED_TOO_DEEP = 201;
  ASN1_R_NON_HEX_CHARACTERS = 141;
  ASN1_R_NOT_ASCII_FORMAT = 190;
  ASN1_R_NOT_ENOUGH_DATA = 142;
  ASN1_R_NO_CONTENT_TYPE = 209;
  ASN1_R_NO_MATCHING_CHOICE_TYPE = 143;
  ASN1_R_NO_MULTIPART_BODY_FAILURE = 210;
  ASN1_R_NO_MULTIPART_BOUNDARY = 211;
  ASN1_R_NO_SIG_CONTENT_TYPE = 212;
  ASN1_R_NULL_IS_WRONG_LENGTH = 144;
  ASN1_R_OBJECT_NOT_ASCII_FORMAT = 191;
  ASN1_R_ODD_NUMBER_OF_CHARS = 145;
  ASN1_R_SECOND_NUMBER_TOO_LARGE = 147;
  ASN1_R_SEQUENCE_LENGTH_MISMATCH = 148;
  ASN1_R_SEQUENCE_NOT_CONSTRUCTED = 149;
  ASN1_R_SEQUENCE_OR_SET_NEEDS_CONFIG = 192;
  ASN1_R_SHORT_LINE = 150;
  ASN1_R_SIG_INVALID_MIME_TYPE = 213;
  ASN1_R_STREAMING_NOT_SUPPORTED = 202;
  ASN1_R_STRING_TOO_LONG = 151;
  ASN1_R_STRING_TOO_SHORT = 152;
  ASN1_R_THE_ASN1_OBJECT_IDENTIFIER_IS_NOT_KNOWN_FOR_THIS_MD = 154;
  ASN1_R_TIME_NOT_ASCII_FORMAT = 193;
  ASN1_R_TOO_LARGE = 223;
  ASN1_R_TOO_LONG = 155;
  ASN1_R_TOO_SMALL = 224;
  ASN1_R_TYPE_NOT_CONSTRUCTED = 156;
  ASN1_R_TYPE_NOT_PRIMITIVE = 195;
  ASN1_R_UNEXPECTED_EOC = 159;
  ASN1_R_UNIVERSALSTRING_IS_WRONG_LENGTH = 215;
  ASN1_R_UNKNOWN_FORMAT = 160;
  ASN1_R_UNKNOWN_MESSAGE_DIGEST_ALGORITHM = 161;
  ASN1_R_UNKNOWN_OBJECT_TYPE = 162;
  ASN1_R_UNKNOWN_PUBLIC_KEY_TYPE = 163;
  ASN1_R_UNKNOWN_SIGNATURE_ALGORITHM = 199;
  ASN1_R_UNKNOWN_TAG = 194;
  ASN1_R_UNSUPPORTED_ANY_DEFINED_BY_TYPE = 164;
  ASN1_R_UNSUPPORTED_CIPHER = 228;
  ASN1_R_UNSUPPORTED_PUBLIC_KEY_TYPE = 167;
  ASN1_R_UNSUPPORTED_TYPE = 196;
  ASN1_R_WRONG_INTEGER_TYPE = 225;
  ASN1_R_WRONG_PUBLIC_KEY_TYPE = 200;
  ASN1_R_WRONG_TAG = 168;
  
  BN_F_BNRAND = 127;
  BN_F_BNRAND_RANGE = 138;
  BN_F_BN_BLINDING_CONVERT_EX = 100;
  BN_F_BN_BLINDING_CREATE_PARAM = 128;
  BN_F_BN_BLINDING_INVERT_EX = 101;
  BN_F_BN_BLINDING_NEW = 102;
  BN_F_BN_BLINDING_UPDATE = 103;
  BN_F_BN_BN2DEC = 104;
  BN_F_BN_BN2HEX = 105;
  BN_F_BN_COMPUTE_WNAF = 142;
  BN_F_BN_CTX_GET = 116;
  BN_F_BN_CTX_NEW = 106;
  BN_F_BN_CTX_START = 129;
  BN_F_BN_DIV = 107;
  BN_F_BN_DIV_RECP = 130;
  BN_F_BN_EXP = 123;
  BN_F_BN_EXPAND_INTERNAL = 120;
  BN_F_BN_GENCB_NEW = 143;
  BN_F_BN_GENERATE_DSA_NONCE = 140;
  BN_F_BN_GENERATE_PRIME_EX = 141;
  BN_F_BN_GF2M_MOD = 131;
  BN_F_BN_GF2M_MOD_EXP = 132;
  BN_F_BN_GF2M_MOD_MUL = 133;
  BN_F_BN_GF2M_MOD_SOLVE_QUAD = 134;
  BN_F_BN_GF2M_MOD_SOLVE_QUAD_ARR = 135;
  BN_F_BN_GF2M_MOD_SQR = 136;
  BN_F_BN_GF2M_MOD_SQRT = 137;
  BN_F_BN_LSHIFT = 145;
  BN_F_BN_MOD_EXP2_MONT = 118;
  BN_F_BN_MOD_EXP_MONT = 109;
  BN_F_BN_MOD_EXP_MONT_CONSTTIME = 124;
  BN_F_BN_MOD_EXP_MONT_WORD = 117;
  BN_F_BN_MOD_EXP_RECP = 125;
  BN_F_BN_MOD_EXP_SIMPLE = 126;
  BN_F_BN_MOD_INVERSE = 110;
  BN_F_BN_MOD_INVERSE_NO_BRANCH = 139;
  BN_F_BN_MOD_LSHIFT_QUICK = 119;
  BN_F_BN_MOD_SQRT = 121;
  BN_F_BN_MONT_CTX_NEW = 149;
  BN_F_BN_MPI2BN = 112;
  BN_F_BN_NEW = 113;
  BN_F_BN_POOL_GET = 147;
  BN_F_BN_RAND = 114;
  BN_F_BN_RAND_RANGE = 122;
  BN_F_BN_RECP_CTX_NEW = 150;
  BN_F_BN_RSHIFT = 146;
  BN_F_BN_SET_WORDS = 144;
  BN_F_BN_STACK_PUSH = 148;
  BN_F_BN_USUB = 115;
  
  BN_R_ARG2_LT_ARG3 = 100;
  BN_R_BAD_RECIPROCAL = 101;
  BN_R_BIGNUM_TOO_LONG = 114;
  BN_R_BITS_TOO_SMALL = 118;
  BN_R_CALLED_WITH_EVEN_MODULUS = 102;
  BN_R_DIV_BY_ZERO = 103;
  BN_R_ENCODING_ERROR = 104;
  BN_R_EXPAND_ON_STATIC_BIGNUM_DATA = 105;
  BN_R_INPUT_NOT_REDUCED = 110;
  BN_R_INVALID_LENGTH = 106;
  BN_R_INVALID_RANGE = 115;
  BN_R_INVALID_SHIFT = 119;
  BN_R_NOT_A_SQUARE = 111;
  BN_R_NOT_INITIALIZED = 107;
  BN_R_NO_INVERSE = 108;
  BN_R_NO_SOLUTION = 116;
  BN_R_PRIVATE_KEY_TOO_LARGE = 117;
  BN_R_P_IS_NOT_PRIME = 112;
  BN_R_TOO_MANY_ITERATIONS = 113;
  BN_R_TOO_MANY_TEMPORARY_VARIABLES = 109;
  
  BN_BYTES = 4;
  BN_BITS2 = BN_BYTES*8;
  BN_BITS = BN_BITS2*2;
  
  BN_FLG_MALLOCED = $01;
  BN_FLG_STATIC_DATA = $02;
  BN_FLG_CONSTTIME = $04;
  BN_FLG_SECURE = $08;
  BN_FLG_EXP_CONSTTIME = BN_FLG_CONSTTIME;
  BN_FLG_FREE = $8000;
  
  BN_RAND_TOP_ANY = -1;
  BN_RAND_TOP_ONE = 0;
  BN_RAND_TOP_TWO = 1;
  BN_RAND_BOTTOM_ANY = 0;
  BN_RAND_BOTTOM_ODD = 1;
  
  BN_prime_checks = 0;
  
  BN_BLINDING_NO_UPDATE = $00000001;
  BN_BLINDING_NO_RECREATE = $00000002;
  
  V_ASN1_UNIVERSAL = $00;
  V_ASN1_APPLICATION = $40;
  V_ASN1_CONTEXT_SPECIFIC = $80;
  V_ASN1_PRIVATE = $c0;
  V_ASN1_CONSTRUCTED = $20;
  V_ASN1_PRIMITIVE_TAG = $1f;
  V_ASN1_PRIMATIVE_TAG = V_ASN1_PRIMITIVE_TAG; // *compat*
  
  V_ASN1_APP_CHOOSE = -2;
  V_ASN1_OTHER = -3;
  V_ASN1_ANY = -4;
  V_ASN1_UNDEF = -1;
  V_ASN1_EOC = 0;
  V_ASN1_BOOLEAN = 1;
  V_ASN1_INTEGER = 2;
  V_ASN1_BIT_STRING = 3;
  V_ASN1_OCTET_STRING = 4;
  V_ASN1_NULL = 5;
  V_ASN1_OBJECT = 6;
  V_ASN1_OBJECT_DESCRIPTOR = 7;
  V_ASN1_EXTERNAL = 8;
  V_ASN1_REAL = 9;
  V_ASN1_ENUMERATED = 10;
  V_ASN1_UTF8STRING = 12;
  V_ASN1_SEQUENCE = 16;
  V_ASN1_SET = 17;
  V_ASN1_NUMERICSTRING = 18;
  V_ASN1_PRINTABLESTRING = 19;
  V_ASN1_T61STRING = 20;
  V_ASN1_TELETEXSTRING = 20;
  V_ASN1_VIDEOTEXSTRING = 21;
  V_ASN1_IA5STRING = 22;
  V_ASN1_UTCTIME = 23;
  V_ASN1_GENERALIZEDTIME = 24;
  V_ASN1_GRAPHICSTRING = 25;
  V_ASN1_ISO64STRING = 26;
  V_ASN1_VISIBLESTRING = 26;
  V_ASN1_GENERALSTRING = 27;
  V_ASN1_UNIVERSALSTRING = 28;
  V_ASN1_BMPSTRING = 30;
  V_ASN1_NEG = $100;
  V_ASN1_NEG_INTEGER = 2 or V_ASN1_NEG;
  V_ASN1_NEG_ENUMERATED = 10 or V_ASN1_NEG;
  
  B_ASN1_NUMERICSTRING = $0001;
  B_ASN1_PRINTABLESTRING = $0002;
  B_ASN1_T61STRING = $0004;
  B_ASN1_TELETEXSTRING = $0004;
  B_ASN1_VIDEOTEXSTRING = $0008;
  B_ASN1_IA5STRING = $0010;
  B_ASN1_GRAPHICSTRING = $0020;
  B_ASN1_ISO64STRING = $0040;
  B_ASN1_VISIBLESTRING = $0040;
  B_ASN1_GENERALSTRING = $0080;
  B_ASN1_UNIVERSALSTRING = $0100;
  B_ASN1_OCTET_STRING = $0200;
  B_ASN1_BIT_STRING = $0400;
  B_ASN1_BMPSTRING = $0800;
  B_ASN1_UNKNOWN = $1000;
  B_ASN1_UTF8STRING = $2000;
  B_ASN1_UTCTIME = $4000;
  B_ASN1_GENERALIZEDTIME = $8000;
  B_ASN1_SEQUENCE = $10000;
  
  SMIME_OLDMIME = $400;
  SMIME_CRLFEOL = $800;
  SMIME_STREAM = $1000;
  
  ASN1_STRING_FLAG_BITS_LEFT = $08;
  ASN1_STRING_FLAG_NDEF = $010;
  ASN1_STRING_FLAG_CONT = $020;
  ASN1_STRING_FLAG_MSTRING = $040;
  ASN1_STRING_FLAG_EMBED = $080;
  ASN1_STRING_FLAG_X509_TIME = $100;
  ASN1_LONG_UNDEF = $7fffffff;
  
  STABLE_FLAGS_MALLOC = $01;
  STABLE_FLAGS_CLEAR = STABLE_FLAGS_MALLOC;
  STABLE_NO_MASK = $02;
  
  DIRSTRING_TYPE = B_ASN1_PRINTABLESTRING or
                   B_ASN1_T61STRING or
                   B_ASN1_BMPSTRING or
                   B_ASN1_UTF8STRING;
  
  PKCS9STRING_TYPE = DIRSTRING_TYPE or
                     B_ASN1_IA5STRING;
  
  B_ASN1_TIME = B_ASN1_UTCTIME or
                B_ASN1_GENERALIZEDTIME;
  B_ASN1_PRINTABLE = B_ASN1_NUMERICSTRING or
                     B_ASN1_PRINTABLESTRING or
                     B_ASN1_T61STRING or
                     B_ASN1_IA5STRING or
                     B_ASN1_BIT_STRING or
                     B_ASN1_UNIVERSALSTRING or
                     B_ASN1_BMPSTRING or
                     B_ASN1_UTF8STRING or
                     B_ASN1_SEQUENCE or
                     B_ASN1_UNKNOWN;
  B_ASN1_DIRECTORYSTRING = B_ASN1_PRINTABLESTRING or
                           B_ASN1_TELETEXSTRING or
                           B_ASN1_BMPSTRING or
                           B_ASN1_UNIVERSALSTRING or
                           B_ASN1_UTF8STRING;
  B_ASN1_DISPLAYTEXT = B_ASN1_IA5STRING or
                       B_ASN1_VISIBLESTRING or
                       B_ASN1_BMPSTRING or
                       B_ASN1_UTF8STRING;
  
  ASN1_PCTX_FLAGS_SHOW_ABSENT = $001;
  ASN1_PCTX_FLAGS_SHOW_SEQUENCE = $002;
  ASN1_PCTX_FLAGS_SHOW_SSOF = $004;
  ASN1_PCTX_FLAGS_SHOW_TYPE = $008;
  ASN1_PCTX_FLAGS_NO_ANY_TYPE = $010;
  ASN1_PCTX_FLAGS_NO_MSTRING_TYPE = $020;
  ASN1_PCTX_FLAGS_NO_FIELD_NAME = $040;
  ASN1_PCTX_FLAGS_SHOW_FIELD_STRUCT_NAME = $080;
  ASN1_PCTX_FLAGS_NO_STRUCT_NAME = $100;
  
  ASN1_TFLG_OPTIONAL = $1;
  ASN1_TFLG_SET_OF = $1 shl 1;
  ASN1_TFLG_SEQUENCE_OF = $2 shl 1;
  ASN1_TFLG_SET_ORDER = $3 shl 1;
  ASN1_TFLG_SK_MASK = $3 shl 1;
  ASN1_TFLG_IMPTAG = $1 shl 3;
  ASN1_TFLG_EXPTAG = $2 shl 3;
  ASN1_TFLG_TAG_MASK = $3 shl 3;
  ASN1_TFLG_CONTEXT = $2 shl 6;
  ASN1_TFLG_IMPLICIT = ASN1_TFLG_IMPTAG or ASN1_TFLG_CONTEXT;
  ASN1_TFLG_EXPLICIT = ASN1_TFLG_EXPTAG or ASN1_TFLG_CONTEXT;
  ASN1_TFLG_UNIVERSAL = $0 shl 6;
  ASN1_TFLG_APPLICATION = $1 shl 6;
  ASN1_TFLG_PRIVATE = $3 shl 6;
  ASN1_TFLG_TAG_CLASS = $3 shl 6;
  ASN1_TFLG_ADB_MASK = $3 shl 8;
  ASN1_TFLG_ADB_OID = $1 shl 8;
  ASN1_TFLG_ADB_INT = $1 shl 9;
  ASN1_TFLG_NDEF = $1 shl 11;
  ASN1_TFLG_EMBED = $1 shl 12;
  
  ASN1_ITYPE_PRIMITIVE = $0;
  ASN1_ITYPE_SEQUENCE = $1;
  ASN1_ITYPE_CHOICE = $2;
  ASN1_ITYPE_EXTERN = $4;
  ASN1_ITYPE_MSTRING = $5;
  ASN1_ITYPE_NDEF_SEQUENCE = $6;
  
  ASN1_AFLG_REFCOUNT = 1;
  ASN1_AFLG_ENCODING = 2;
  ASN1_AFLG_BROKEN = 4;
  
  ASN1_OP_NEW_PRE = 0;
  ASN1_OP_NEW_POST = 1;
  ASN1_OP_FREE_PRE = 2;
  ASN1_OP_FREE_POST = 3;
  ASN1_OP_D2I_PRE = 4;
  ASN1_OP_D2I_POST = 5;
  ASN1_OP_I2D_PRE = 6;
  ASN1_OP_I2D_POST = 7;
  ASN1_OP_PRINT_PRE = 8;
  ASN1_OP_PRINT_POST = 9;
  ASN1_OP_STREAM_PRE = 10;
  ASN1_OP_STREAM_POST = 11;
  ASN1_OP_DETACHED_PRE = 12;
  ASN1_OP_DETACHED_POST = 13;
  
  ASYNC_F_ASYNC_CTX_NEW = 100;
  ASYNC_F_ASYNC_INIT_THREAD = 101;
  ASYNC_F_ASYNC_JOB_NEW = 102;
  ASYNC_F_ASYNC_PAUSE_JOB = 103;
  ASYNC_F_ASYNC_START_FUNC = 104;
  ASYNC_F_ASYNC_START_JOB = 105;
  ASYNC_F_ASYNC_WAIT_CTX_SET_WAIT_FD = 106;
  
  ASYNC_R_FAILED_TO_SET_POOL = 101;
  ASYNC_R_FAILED_TO_SWAP_CONTEXT = 102;
  ASYNC_R_INIT_FAILED = 105;
  ASYNC_R_INVALID_POOL_SIZE = 103;
  
  ASYNC_ERR = 0;
  ASYNC_NO_JOBS = 1;
  ASYNC_PAUSE = 2;
  ASYNC_FINISH = 3;
  
  _BF_ENCRYPT = 1;
  _BF_DECRYPT = 0;
  BF_ROUNDS = 16;
  BF_BLOCK = 8;
  
  BUF_F_BUF_MEM_GROW = 100;
  BUF_F_BUF_MEM_GROW_CLEAN = 105;
  BUF_F_BUF_MEM_NEW = 101;
  BUF_MEM_FLAG_SECURE = $01;
  
  _CAMELLIA_ENCRYPT = 1;
  _CAMELLIA_DECRYPT = 0;
  CAMELLIA_BLOCK_SIZE = 16;
  CAMELLIA_TABLE_BYTE_LEN = 272;
  CAMELLIA_TABLE_WORD_LEN = CAMELLIA_TABLE_BYTE_LEN div 4;
  
  _CAST_ENCRYPT = 1;
  _CAST_DECRYPT = 0;
  CAST_BLOCK = 8;
  CAST_KEY_LENGTH = 16;
  
  EVP_F_AESNI_INIT_KEY = 165;
  EVP_F_AESNI_XTS_INIT_KEY = 207;
  EVP_F_AES_GCM_CTRL = 196;
  EVP_F_AES_INIT_KEY = 133;
  EVP_F_AES_OCB_CIPHER = 169;
  EVP_F_AES_T4_INIT_KEY = 178;
  EVP_F_AES_T4_XTS_INIT_KEY = 208;
  EVP_F_AES_WRAP_CIPHER = 170;
  EVP_F_AES_XTS_INIT_KEY = 209;  
  
  EVP_F_ALG_MODULE_INIT = 177; 
  EVP_F_ARIA_CCM_INIT_KEY = 175;
  EVP_F_ARIA_GCM_CTRL = 197;
  EVP_F_ARIA_GCM_INIT_KEY = 176;
  EVP_F_ARIA_INIT_KEY = 185;
  EVP_F_B64_NEW = 198;
  EVP_F_CAMELLIA_INIT_KEY = 159;
  EVP_F_CHACHA20_POLY1305_CTRL = 182;
  EVP_F_CMLL_T4_INIT_KEY = 179;
  EVP_F_DES_EDE3_WRAP_CIPHER = 171;
  EVP_F_DO_SIGVER_INIT = 161;
  EVP_F_ENC_NEW = 199;
  
  EVP_F_EVP_CIPHERINIT_EX = 123;
  EVP_F_EVP_CIPHER_ASN1_TO_PARAM = 204;
  EVP_F_EVP_CIPHER_CTX_COPY = 163;
  EVP_F_EVP_CIPHER_CTX_CTRL = 124;
  EVP_F_EVP_CIPHER_CTX_SET_KEY_LENGTH = 122;
  EVP_F_EVP_CIPHER_PARAM_TO_ASN1 = 205;
  EVP_F_EVP_DECRYPTFINAL_EX = 101;
  EVP_F_EVP_DECRYPTUPDATE = 166;
  EVP_F_EVP_DIGESTFINALXOF = 174;
  EVP_F_EVP_DIGESTINIT_EX = 128;
  EVP_F_EVP_ENCRYPTDECRYPTUPDATE = 219;
  EVP_F_EVP_ENCRYPTFINAL_EX = 127;
  EVP_F_EVP_ENCRYPTUPDATE = 167;
  EVP_F_EVP_MD_CTX_COPY_EX = 110;
  EVP_F_EVP_MD_SIZE = 162;
  EVP_F_EVP_OPENINIT = 102;
  EVP_F_EVP_PBE_ALG_ADD = 115;
  EVP_F_EVP_PBE_ALG_ADD_TYPE = 160;
  EVP_F_EVP_PBE_CIPHERINIT = 116;
  EVP_F_EVP_PBE_SCRYPT = 181;
  EVP_F_EVP_PKCS82PKEY = 111;
  EVP_F_EVP_PKEY2PKCS8 = 113;
  EVP_F_EVP_PKEY_ASN1_ADD0 = 188;
  EVP_F_EVP_PKEY_CHECK = 186;
  EVP_F_EVP_PKEY_COPY_PARAMETERS = 103;
  EVP_F_EVP_PKEY_CTX_CTRL = 137;
  EVP_F_EVP_PKEY_CTX_CTRL_STR = 150;
  EVP_F_EVP_PKEY_CTX_DUP = 156;
  EVP_F_EVP_PKEY_CTX_MD = 168;
  EVP_F_EVP_PKEY_DECRYPT = 104;
  EVP_F_EVP_PKEY_DECRYPT_INIT = 138;
  EVP_F_EVP_PKEY_DECRYPT_OLD = 151;
  EVP_F_EVP_PKEY_ENCRYPT = 105;
  EVP_F_EVP_PKEY_ENCRYPT_INIT = 139;
  EVP_F_EVP_PKEY_ENCRYPT_OLD = 152;
  EVP_F_EVP_PKEY_GET0_DH = 119;
  EVP_F_EVP_PKEY_GET0_DSA = 120;
  EVP_F_EVP_PKEY_GET0_EC_KEY = 131;
  EVP_F_EVP_PKEY_GET0_HMAC = 183;
  EVP_F_EVP_PKEY_GET0_POLY1305 = 184;
  EVP_F_EVP_PKEY_GET0_RSA = 121;
  EVP_F_EVP_PKEY_GET0_SIPHASH = 172;
  EVP_F_EVP_PKEY_GET_RAW_PRIVATE_KEY = 202;
  EVP_F_EVP_PKEY_GET_RAW_PUBLIC_KEY = 203;
  EVP_F_EVP_PKEY_KEYGEN = 146;
  EVP_F_EVP_PKEY_KEYGEN_INIT = 147;
  EVP_F_EVP_PKEY_METH_ADD0 = 194;
  EVP_F_EVP_PKEY_METH_NEW = 195;
  EVP_F_EVP_PKEY_NEW = 106;
  EVP_F_EVP_PKEY_NEW_CMAC_KEY = 193;
  EVP_F_EVP_PKEY_NEW_RAW_PRIVATE_KEY = 191;
  EVP_F_EVP_PKEY_NEW_RAW_PUBLIC_KEY = 192;
  EVP_F_EVP_PKEY_PARAMGEN = 148;
  EVP_F_EVP_PKEY_PARAMGEN_INIT = 149;
  EVP_F_EVP_PKEY_PARAM_CHECK = 189;
  EVP_F_EVP_PKEY_PUBLIC_CHECK = 190;
  EVP_F_EVP_PKEY_SET1_ENGINE = 187;
  EVP_F_EVP_PKEY_SET_ALIAS_TYPE = 206;
  EVP_F_EVP_PKEY_SIGN = 140;
  EVP_F_EVP_PKEY_SIGN_INIT = 141;
  EVP_F_EVP_PKEY_VERIFY = 142;
  EVP_F_EVP_PKEY_VERIFY_INIT = 143;
  EVP_F_EVP_PKEY_VERIFY_RECOVER = 144;
  EVP_F_EVP_PKEY_VERIFY_RECOVER_INIT = 145;
  EVP_F_EVP_SIGNFINAL = 107;
  EVP_F_EVP_VERIFYFINAL = 108;
  
  EVP_F_INT_CTX_NEW = 157;
  EVP_F_OK_NEW = 200;
  
  EVP_F_PKCS5_PBE_KEYIVGEN = 117;
  EVP_F_PKCS5_V2_PBE_KEYIVGEN = 118;
  EVP_F_PKCS5_V2_PBKDF2_KEYIVGEN = 164;
  EVP_F_PKCS5_V2_SCRYPT_KEYIVGEN = 180;
  EVP_F_PKEY_SET_TYPE = 158;
  EVP_F_RC2_MAGIC_TO_METH = 109;
  EVP_F_RC5_CTRL = 125;
  EVP_F_R_32_12_16_INIT_KEY = 242;
  EVP_F_S390X_AES_GCM_CTRL = 201;
  EVP_F_UPDATE = 173;
  
  EVP_R_AES_KEY_SETUP_FAILED = 143;
  EVP_R_ARIA_KEY_SETUP_FAILED = 176;
  EVP_R_BAD_DECRYPT = 100;
  EVP_R_BAD_KEY_LENGTH = 195;
  EVP_R_BUFFER_TOO_SMALL = 155;
  EVP_R_CAMELLIA_KEY_SETUP_FAILED = 157;
  EVP_R_CIPHER_PARAMETER_ERROR = 122;
  EVP_R_COMMAND_NOT_SUPPORTED = 147;
  EVP_R_COPY_ERROR = 173;
  EVP_R_CTRL_NOT_IMPLEMENTED = 132;
  EVP_R_CTRL_OPERATION_NOT_IMPLEMENTED = 133;
  EVP_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH = 138;
  EVP_R_DECODE_ERROR = 114;
  EVP_R_DIFFERENT_KEY_TYPES = 101;
  EVP_R_DIFFERENT_PARAMETERS = 153;
  EVP_R_ERROR_LOADING_SECTION = 165;
  EVP_R_ERROR_SETTING_FIPS_MODE = 166;
  EVP_R_EXPECTING_AN_HMAC_KEY = 174;
  EVP_R_EXPECTING_AN_RSA_KEY = 127;
  EVP_R_EXPECTING_A_DH_KEY = 128;
  EVP_R_EXPECTING_A_DSA_KEY = 129;
  EVP_R_EXPECTING_A_EC_KEY = 142;
  EVP_R_EXPECTING_A_POLY1305_KEY = 164;
  EVP_R_EXPECTING_A_SIPHASH_KEY = 175;
  EVP_R_FIPS_MODE_NOT_SUPPORTED = 167;
  EVP_R_GET_RAW_KEY_FAILED = 182;
  EVP_R_ILLEGAL_SCRYPT_PARAMETERS = 171;
  EVP_R_INITIALIZATION_ERROR = 134;
  EVP_R_INPUT_NOT_INITIALIZED = 111;
  EVP_R_INVALID_DIGEST = 152;
  EVP_R_INVALID_FIPS_MODE = 168;
  EVP_R_INVALID_IV_LENGTH = 194;
  EVP_R_INVALID_KEY = 163;
  EVP_R_INVALID_KEY_LENGTH = 130;
  EVP_R_INVALID_OPERATION = 148;
  EVP_R_KEYGEN_FAILURE = 120;
  EVP_R_KEY_SETUP_FAILED = 180;
  EVP_R_MEMORY_LIMIT_EXCEEDED = 172;
  EVP_R_MESSAGE_DIGEST_IS_NULL = 159;
  EVP_R_METHOD_NOT_SUPPORTED = 144;
  EVP_R_MISSING_PARAMETERS = 103;
  EVP_R_NOT_XOF_OR_INVALID_LENGTH = 178;
  EVP_R_NO_CIPHER_SET = 131;
  EVP_R_NO_DEFAULT_DIGEST = 158;
  EVP_R_NO_DIGEST_SET = 139;
  EVP_R_NO_KEY_SET = 154;
  EVP_R_NO_OPERATION_SET = 149;
  EVP_R_ONLY_ONESHOT_SUPPORTED = 177;
  EVP_R_OPERATION_NOT_SUPPORTED_FOR_THIS_KEYTYPE = 150;
  EVP_R_OPERATON_NOT_INITIALIZED = 151;
  EVP_R_PARTIALLY_OVERLAPPING = 162;
  EVP_R_PBKDF2_ERROR = 181;
  EVP_R_PKEY_APPLICATION_ASN1_METHOD_ALREADY_REGISTERED = 179;
  EVP_R_PRIVATE_KEY_DECODE_ERROR = 145;
  EVP_R_PRIVATE_KEY_ENCODE_ERROR = 146;
  EVP_R_PUBLIC_KEY_NOT_RSA = 106;
  EVP_R_UNKNOWN_CIPHER = 160;
  EVP_R_UNKNOWN_DIGEST = 161;
  EVP_R_UNKNOWN_OPTION = 169;
  EVP_R_UNKNOWN_PBE_ALGORITHM = 121;
  EVP_R_UNSUPPORTED_ALGORITHM = 156;
  EVP_R_UNSUPPORTED_CIPHER = 107;
  EVP_R_UNSUPPORTED_KEYLENGTH = 123;
  EVP_R_UNSUPPORTED_KEY_DERIVATION_FUNCTION = 124;
  EVP_R_UNSUPPORTED_KEY_SIZE = 108;
  EVP_R_UNSUPPORTED_NUMBER_OF_ROUNDS = 135;
  EVP_R_UNSUPPORTED_PRF = 125;
  EVP_R_UNSUPPORTED_PRIVATE_KEY_ALGORITHM = 118;
  EVP_R_UNSUPPORTED_SALT_TYPE = 126;
  EVP_R_WRAP_MODE_NOT_ALLOWED = 170;
  EVP_R_WRONG_FINAL_BLOCK_LENGTH = 109;
  EVP_R_XTS_DUPLICATED_KEYS = 183;
  
  SN_undef = 'UNDEF';
  LN_undef = 'undefined';
  NID_undef = 0;
  OBJ_undef = 0;
  SN_itu_t = 'ITU-T';
  LN_itu_t = 'itu-t';
  NID_itu_t = 645;
  OBJ_itu_t = 0;
  NID_ccitt = 404;
  OBJ_ccitt = OBJ_itu_t;
  SN_iso = 'ISO';
  LN_iso = 'iso';
  NID_iso = 181;
  OBJ_iso = 1;
  SN_joint_iso_itu_t = 'JOINT-ISO-ITU-T';
  LN_joint_iso_itu_t = 'joint-iso-itu-t';
  NID_joint_iso_itu_t = 646;
  OBJ_joint_iso_itu_t = 2;
  NID_joint_iso_ccitt = 393;
  OBJ_joint_iso_ccitt = OBJ_joint_iso_itu_t;
  SN_member_body = 'member-body';
  LN_member_body = 'ISO Member Body';
  NID_member_body = 182;
  SN_identified_organization = 'identified-organization';
  NID_identified_organization = 676;
  SN_hmac_md5 = 'HMAC-MD5';
  LN_hmac_md5 = 'hmac-md5';
  NID_hmac_md5 = 780;
  SN_hmac_sha1 = 'HMAC-SHA1';
  LN_hmac_sha1 = 'hmac-sha1';
  NID_hmac_sha1 = 781;
  SN_x509ExtAdmission = 'x509ExtAdmission';
  LN_x509ExtAdmission = 'Professional Information or basis for Admission';
  NID_x509ExtAdmission = 1093;
  SN_certicom_arc = 'certicom-arc';
  NID_certicom_arc = 677;
  SN_ieee = 'ieee';
  NID_ieee = 1170;
  SN_ieee_siswg = 'ieee-siswg';
  LN_ieee_siswg = 'IEEE Security in Storage Working Group';
  NID_ieee_siswg = 1171;
  SN_international_organizations = 'international-organizations';
  LN_international_organizations = 'International Organizations';
  NID_international_organizations = 647;
  SN_wap = 'wap';
  NID_wap = 678;
  SN_wap_wsg = 'wap-wsg';
  NID_wap_wsg = 679;
  SN_selected_attribute_types = 'selected-attribute-types';
  LN_selected_attribute_types = 'Selected Attribute Types';
  NID_selected_attribute_types = 394;
  SN_clearance = 'clearance';
  NID_clearance = 395;
  SN_ISO_US = 'ISO-US';
  LN_ISO_US = 'ISO US Member Body';
  NID_ISO_US = 183;
  SN_X9_57 = 'X9-57';
  LN_X9_57 = 'X9.57';
  NID_X9_57 = 184;
  SN_X9cm = 'X9cm';
  LN_X9cm = 'X9.57 CM ?';
  NID_X9cm = 185;
  SN_ISO_CN = 'ISO-CN';
  LN_ISO_CN = 'ISO CN Member Body';
  NID_ISO_CN = 1140;
  SN_oscca = 'oscca';
  NID_oscca = 1141;
  SN_sm_scheme = 'sm-scheme';
  NID_sm_scheme = 1142;
  SN_dsa = 'DSA';
  SN_dsaWithSHA1 = 'DSA-SHA1';
  LN_dsaWithSHA1 = 'dsaWithSHA1';
  NID_dsaWithSHA1 = 113;
  SN_ansi_X9_62 = 'ansi-X9-62';
  LN_ansi_X9_62 = 'ANSI X9.62';
  NID_ansi_X9_62 = 405;
  SN_X9_62_prime_field = 'prime-field';
  NID_X9_62_prime_field = 406;
  SN_X9_62_characteristic_two_field = 'characteristic-two-field';
  NID_X9_62_characteristic_two_field = 407;
  SN_X9_62_id_characteristic_two_basis = 'id-characteristic-two-basis';
  NID_X9_62_id_characteristic_two_basis = 680;
  SN_X9_62_onBasis = 'onBasis';
  NID_X9_62_onBasis = 681;
  SN_X9_62_tpBasis = 'tpBasis';
  NID_X9_62_tpBasis = 682;
  SN_X9_62_ppBasis = 'ppBasis';
  NID_X9_62_ppBasis = 683;
  SN_X9_62_c2pnb163v1 = 'c2pnb163v1';
  NID_X9_62_c2pnb163v1 = 684;
  SN_X9_62_c2pnb163v2 = 'c2pnb163v2';
  NID_X9_62_c2pnb163v2 = 685;
  SN_X9_62_c2pnb163v3 = 'c2pnb163v3';
  NID_X9_62_c2pnb163v3 = 686;
  SN_X9_62_c2pnb176v1 = 'c2pnb176v1';
  NID_X9_62_c2pnb176v1 = 687;
  SN_X9_62_c2tnb191v1 = 'c2tnb191v1';
  NID_X9_62_c2tnb191v1 = 688;
  SN_X9_62_c2tnb191v2 = 'c2tnb191v2';
  NID_X9_62_c2tnb191v2 = 689;
  SN_X9_62_c2tnb191v3 = 'c2tnb191v3';
  NID_X9_62_c2tnb191v3 = 690;
  SN_X9_62_c2onb191v4 = 'c2onb191v4';
  NID_X9_62_c2onb191v4 = 691;
  SN_X9_62_c2onb191v5 = 'c2onb191v5';
  NID_X9_62_c2onb191v5 = 692;
  SN_X9_62_c2pnb208w1 = 'c2pnb208w1';
  NID_X9_62_c2pnb208w1 = 693;
  SN_X9_62_c2tnb239v1 = 'c2tnb239v1';
  NID_X9_62_c2tnb239v1 = 694;
  SN_X9_62_c2tnb239v2 = 'c2tnb239v2';
  NID_X9_62_c2tnb239v2 = 695;
  SN_X9_62_c2tnb239v3 = 'c2tnb239v3';
  NID_X9_62_c2tnb239v3 = 696;
  SN_X9_62_c2onb239v4 = 'c2onb239v4';
  NID_X9_62_c2onb239v4 = 697;
  SN_X9_62_c2onb239v5 = 'c2onb239v5';
  NID_X9_62_c2onb239v5 = 698;
  SN_X9_62_c2pnb272w1 = 'c2pnb272w1';
  NID_X9_62_c2pnb272w1 = 699;
  SN_X9_62_c2pnb304w1 = 'c2pnb304w1';
  NID_X9_62_c2pnb304w1 = 700;
  SN_X9_62_c2tnb359v1 = 'c2tnb359v1';
  NID_X9_62_c2tnb359v1 = 701;
  SN_X9_62_c2pnb368w1 = 'c2pnb368w1';
  NID_X9_62_c2pnb368w1 = 702;
  SN_X9_62_c2tnb431r1 = 'c2tnb431r1';
  NID_X9_62_c2tnb431r1 = 703;
  SN_ecdsa_with_SHA1 = 'ecdsa-with-SHA1';
  NID_ecdsa_with_SHA1 = 416;
  SN_ecdsa_with_Recommended = 'ecdsa-with-Recommended';
  NID_ecdsa_with_Recommended = 791;
  SN_ecdsa_with_Specified = 'ecdsa-with-Specified';
  NID_ecdsa_with_Specified = 792;
  SN_ecdsa_with_SHA224 = 'ecdsa-with-SHA224';
  NID_ecdsa_with_SHA224 = 793;
  SN_ecdsa_with_SHA256 = 'ecdsa-with-SHA256';
  SN_ecdsa_with_SHA384 = 'ecdsa-with-SHA384';
  SN_ecdsa_with_SHA512 = 'ecdsa-with-SHA512';
  SN_wap_wsg_idm_ecid_wtls1 = 'wap-wsg-idm-ecid-wtls1';
  NID_wap_wsg_idm_ecid_wtls1 = 735;
  SN_wap_wsg_idm_ecid_wtls3 = 'wap-wsg-idm-ecid-wtls3';
  NID_wap_wsg_idm_ecid_wtls3 = 736;
  SN_wap_wsg_idm_ecid_wtls4 = 'wap-wsg-idm-ecid-wtls4';
  NID_wap_wsg_idm_ecid_wtls4 = 737;
  SN_wap_wsg_idm_ecid_wtls5 = 'wap-wsg-idm-ecid-wtls5';
  NID_wap_wsg_idm_ecid_wtls5 = 738;
  SN_wap_wsg_idm_ecid_wtls6 = 'wap-wsg-idm-ecid-wtls6';
  NID_wap_wsg_idm_ecid_wtls6 = 739;
  SN_wap_wsg_idm_ecid_wtls7 = 'wap-wsg-idm-ecid-wtls7';
  NID_wap_wsg_idm_ecid_wtls7 = 740;
  SN_wap_wsg_idm_ecid_wtls8 = 'wap-wsg-idm-ecid-wtls8';
  NID_wap_wsg_idm_ecid_wtls8 = 741;
  SN_wap_wsg_idm_ecid_wtls9 = 'wap-wsg-idm-ecid-wtls9';
  NID_wap_wsg_idm_ecid_wtls9 = 742;
  SN_wap_wsg_idm_ecid_wtls10 = 'wap-wsg-idm-ecid-wtls10';
  NID_wap_wsg_idm_ecid_wtls10 = 743;
  SN_wap_wsg_idm_ecid_wtls11 = 'wap-wsg-idm-ecid-wtls11';
  NID_wap_wsg_idm_ecid_wtls11 = 744;
  SN_wap_wsg_idm_ecid_wtls12 = 'wap-wsg-idm-ecid-wtls12';
  NID_wap_wsg_idm_ecid_wtls12 = 745;
  SN_cast5_cbc = 'CAST5-CBC';
  LN_cast5_cbc = 'cast5-cbc';
  NID_cast5_cbc = 108;
  SN_cast5_ecb = 'CAST5-ECB';
  LN_cast5_ecb = 'cast5-ecb';
  NID_cast5_ecb = 109;
  SN_cast5_cfb64 = 'CAST5-CFB';
  LN_cast5_cfb64 = 'cast5-cfb';
  NID_cast5_cfb64 = 110;
  SN_cast5_ofb64 = 'CAST5-OFB';
  LN_cast5_ofb64 = 'cast5-ofb';
  NID_cast5_ofb64 = 111;
  LN_pbeWithMD5AndCast5_CBC = 'pbeWithMD5AndCast5CBC';
  NID_pbeWithMD5AndCast5_CBC = 112;
  SN_id_PasswordBasedMAC = 'id-PasswordBasedMAC';
  LN_id_PasswordBasedMAC = 'password based MAC';
  NID_id_PasswordBasedMAC = 782;
  SN_id_DHBasedMac = 'id-DHBasedMac';
  LN_id_DHBasedMac = 'Diffie-Hellman based MAC';
  NID_id_DHBasedMac = 783;
  SN_rsadsi = 'rsadsi';
  LN_rsadsi = 'RSA Data Security, Inc.';
  NID_rsadsi = 1;
  SN_pkcs = 'pkcs';
  LN_pkcs = 'RSA Data Security, Inc. PKCS';
  NID_pkcs = 2;
  SN_pkcs1 = 'pkcs1';
  NID_pkcs1 = 186;
  SN_md2WithRSAEncryption = 'RSA-MD2';
  LN_md2WithRSAEncryption = 'md2WithRSAEncryption';
  NID_md2WithRSAEncryption = 7;
  SN_md4WithRSAEncryption = 'RSA-MD4';
  LN_md4WithRSAEncryption = 'md4WithRSAEncryption';
  NID_md4WithRSAEncryption = 396;
  SN_md5WithRSAEncryption = 'RSA-MD5';
  LN_md5WithRSAEncryption = 'md5WithRSAEncryption';
  NID_md5WithRSAEncryption = 8;
  SN_sha1WithRSAEncryption = 'RSA-SHA1';
  LN_sha1WithRSAEncryption = 'sha1WithRSAEncryption';
  NID_sha1WithRSAEncryption = 65;
  SN_rsaesOaep = 'RSAES-OAEP';
  LN_rsaesOaep = 'rsaesOaep';
  NID_rsaesOaep = 919;
  SN_mgf1 = 'MGF1';
  LN_mgf1 = 'mgf1';
  NID_mgf1 = 911;
  SN_pSpecified = 'PSPECIFIED';
  LN_pSpecified = 'pSpecified';
  NID_pSpecified = 935;
  SN_rsassaPss = 'RSASSA-PSS';
  SN_sha256WithRSAEncryption = 'RSA-SHA256';
  LN_sha256WithRSAEncryption = 'sha256WithRSAEncryption';
  SN_sha384WithRSAEncryption = 'RSA-SHA384';
  LN_sha384WithRSAEncryption = 'sha384WithRSAEncryption';
  SN_sha512WithRSAEncryption = 'RSA-SHA512';
  LN_sha512WithRSAEncryption = 'sha512WithRSAEncryption';
  SN_sha224WithRSAEncryption = 'RSA-SHA224';
  LN_sha224WithRSAEncryption = 'sha224WithRSAEncryption';
  SN_sha512_224WithRSAEncryption = 'RSA-SHA512/224';
  LN_sha512_224WithRSAEncryption = 'sha512-224WithRSAEncryption';
  NID_sha512_224WithRSAEncryption = 1145;
  SN_sha512_256WithRSAEncryption = 'RSA-SHA512/256';
  LN_sha512_256WithRSAEncryption = 'sha512-256WithRSAEncryption';
  NID_sha512_256WithRSAEncryption = 1146;
  SN_pkcs3 = 'pkcs3';
  NID_pkcs3 = 27;
  SN_pkcs5 = 'pkcs5';
  NID_pkcs5 = 187;
  SN_pbeWithMD2AndDES_CBC = 'PBE-MD2-DES';
  LN_pbeWithMD2AndDES_CBC = 'pbeWithMD2AndDES-CBC';
  NID_pbeWithMD2AndDES_CBC = 9;
  SN_pbeWithMD5AndDES_CBC = 'PBE-MD5-DES';
  LN_pbeWithMD5AndDES_CBC = 'pbeWithMD5AndDES-CBC';
  NID_pbeWithMD5AndDES_CBC = 10;
  SN_pbeWithMD2AndRC2_CBC = 'PBE-MD2-RC2-64';
  LN_pbeWithMD2AndRC2_CBC = 'pbeWithMD2AndRC2-CBC';
  NID_pbeWithMD2AndRC2_CBC = 168;
  SN_pbeWithMD5AndRC2_CBC = 'PBE-MD5-RC2-64';
  LN_pbeWithMD5AndRC2_CBC = 'pbeWithMD5AndRC2-CBC';
  NID_pbeWithMD5AndRC2_CBC = 169;
  SN_pbeWithSHA1AndDES_CBC = 'PBE-SHA1-DES';
  LN_pbeWithSHA1AndDES_CBC = 'pbeWithSHA1AndDES-CBC';
  NID_pbeWithSHA1AndDES_CBC = 170;
  SN_pbeWithSHA1AndRC2_CBC = 'PBE-SHA1-RC2-64';
  LN_pbeWithSHA1AndRC2_CBC = 'pbeWithSHA1AndRC2-CBC';
  NID_pbeWithSHA1AndRC2_CBC = 68;
  LN_id_pbkdf2 = 'PBKDF2';
  NID_id_pbkdf2 = 69;
  LN_pbes2 = 'PBES2';
  NID_pbes2 = 161;
  LN_pbmac1 = 'PBMAC1';
  NID_pbmac1 = 162;
  SN_pkcs7 = 'pkcs7';
  NID_pkcs7 = 20;
  LN_pkcs7_data = 'pkcs7-data';
  NID_pkcs7_data = 21;
  LN_pkcs7_signed = 'pkcs7-signedData';
  NID_pkcs7_signed = 22;
  LN_pkcs7_enveloped = 'pkcs7-envelopedData';
  NID_pkcs7_enveloped = 23;
  LN_pkcs7_signedAndEnveloped = 'pkcs7-signedAndEnvelopedData';
  NID_pkcs7_signedAndEnveloped = 24;
  LN_pkcs7_digest = 'pkcs7-digestData';
  NID_pkcs7_digest = 25;
  LN_pkcs7_encrypted = 'pkcs7-encryptedData';
  NID_pkcs7_encrypted = 26;
  SN_pkcs9 = 'pkcs9';
  NID_pkcs9 = 47;
  LN_pkcs9_emailAddress = 'emailAddress';
  NID_pkcs9_emailAddress = 48;
  LN_pkcs9_unstructuredName = 'unstructuredName';
  NID_pkcs9_unstructuredName = 49;
  LN_pkcs9_contentType = 'contentType';
  NID_pkcs9_contentType = 50;
  LN_pkcs9_messageDigest = 'messageDigest';
  NID_pkcs9_messageDigest = 51;
  LN_pkcs9_signingTime = 'signingTime';
  NID_pkcs9_signingTime = 52;
  LN_pkcs9_countersignature = 'countersignature';
  NID_pkcs9_countersignature = 53;
  LN_pkcs9_challengePassword = 'challengePassword';
  NID_pkcs9_challengePassword = 54;
  LN_pkcs9_unstructuredAddress = 'unstructuredAddress';
  NID_pkcs9_unstructuredAddress = 55;
  LN_pkcs9_extCertAttributes = 'extendedCertificateAttributes';
  NID_pkcs9_extCertAttributes = 56;
  SN_ext_req = 'extReq';
  LN_ext_req = 'Extension Request';
  NID_ext_req = 172;
  SN_SMIMECapabilities = 'SMIME-CAPS';
  LN_SMIMECapabilities = 'S/MIME Capabilities';
  NID_SMIMECapabilities = 167;
  SN_SMIME = 'SMIME';
  LN_SMIME = 'S/MIME';
  NID_SMIME = 188;
  SN_id_smime_mod = 'id-smime-mod';
  NID_id_smime_mod = 189;
  SN_id_smime_ct = 'id-smime-ct';
  NID_id_smime_ct = 190;
  SN_id_smime_aa = 'id-smime-aa';
  NID_id_smime_aa = 191;
  SN_id_smime_alg = 'id-smime-alg';
  NID_id_smime_alg = 192;
  SN_id_smime_cd = 'id-smime-cd';
  NID_id_smime_cd = 193;
  SN_id_smime_spq = 'id-smime-spq';
  NID_id_smime_spq = 194;
  SN_id_smime_cti = 'id-smime-cti';
  NID_id_smime_cti = 195;
  SN_id_smime_mod_cms = 'id-smime-mod-cms';
  NID_id_smime_mod_cms = 196;
  SN_id_smime_mod_ess = 'id-smime-mod-ess';
  NID_id_smime_mod_ess = 197;
  SN_id_smime_mod_oid = 'id-smime-mod-oid';
  NID_id_smime_mod_oid = 198;
  SN_id_smime_mod_msg_v3 = 'id-smime-mod-msg-v3';
  NID_id_smime_mod_msg_v3 = 199;
  SN_id_smime_mod_ets_eSignature_88 = 'id-smime-mod-ets-eSignature-88';
  NID_id_smime_mod_ets_eSignature_88 = 200;
  SN_id_smime_mod_ets_eSignature_97 = 'id-smime-mod-ets-eSignature-97';
  NID_id_smime_mod_ets_eSignature_97 = 201;
  SN_id_smime_mod_ets_eSigPolicy_88 = 'id-smime-mod-ets-eSigPolicy-88';
  NID_id_smime_mod_ets_eSigPolicy_88 = 202;
  SN_id_smime_mod_ets_eSigPolicy_97 = 'id-smime-mod-ets-eSigPolicy-97';
  NID_id_smime_mod_ets_eSigPolicy_97 = 203;
  SN_id_smime_ct_receipt = 'id-smime-ct-receipt';
  NID_id_smime_ct_receipt = 204;
  SN_id_smime_ct_authData = 'id-smime-ct-authData';
  NID_id_smime_ct_authData = 205;
  SN_id_smime_ct_publishCert = 'id-smime-ct-publishCert';
  NID_id_smime_ct_publishCert = 206;
  SN_id_smime_ct_TSTInfo = 'id-smime-ct-TSTInfo';
  NID_id_smime_ct_TSTInfo = 207;
  SN_id_smime_ct_TDTInfo = 'id-smime-ct-TDTInfo';
  NID_id_smime_ct_TDTInfo = 208;
  SN_id_smime_ct_contentInfo = 'id-smime-ct-contentInfo';
  NID_id_smime_ct_contentInfo = 209;
  SN_id_smime_ct_DVCSRequestData = 'id-smime-ct-DVCSRequestData';
  NID_id_smime_ct_DVCSRequestData = 210;
  SN_id_smime_ct_DVCSResponseData = 'id-smime-ct-DVCSResponseData';
  NID_id_smime_ct_DVCSResponseData = 211;
  SN_id_smime_ct_compressedData = 'id-smime-ct-compressedData';
  NID_id_smime_ct_compressedData = 786;
  SN_id_smime_ct_contentCollection = 'id-smime-ct-contentCollection';
  NID_id_smime_ct_contentCollection = 1058;
  SN_id_smime_ct_authEnvelopedData = 'id-smime-ct-authEnvelopedData';
  NID_id_smime_ct_authEnvelopedData = 1059;
  SN_id_ct_asciiTextWithCRLF = 'id-ct-asciiTextWithCRLF';
  NID_id_ct_asciiTextWithCRLF = 787;
  SN_id_ct_xml = 'id-ct-xml';
  NID_id_ct_xml = 1060;
  SN_id_smime_aa_receiptRequest = 'id-smime-aa-receiptRequest';
  NID_id_smime_aa_receiptRequest = 212;
  SN_id_smime_aa_securityLabel = 'id-smime-aa-securityLabel';
  NID_id_smime_aa_securityLabel = 213;
  SN_id_smime_aa_mlExpandHistory = 'id-smime-aa-mlExpandHistory';
  NID_id_smime_aa_mlExpandHistory = 214;
  SN_id_smime_aa_contentHint = 'id-smime-aa-contentHint';
  NID_id_smime_aa_contentHint = 215;
  SN_id_smime_aa_msgSigDigest = 'id-smime-aa-msgSigDigest';
  NID_id_smime_aa_msgSigDigest = 216;
  SN_id_smime_aa_encapContentType = 'id-smime-aa-encapContentType';
  NID_id_smime_aa_encapContentType = 217;
  SN_id_smime_aa_contentIdentifier = 'id-smime-aa-contentIdentifier';
  NID_id_smime_aa_contentIdentifier = 218;
  SN_id_smime_aa_macValue = 'id-smime-aa-macValue';
  NID_id_smime_aa_macValue = 219;
  SN_id_smime_aa_equivalentLabels = 'id-smime-aa-equivalentLabels';
  NID_id_smime_aa_equivalentLabels = 220;
  SN_id_smime_aa_contentReference = 'id-smime-aa-contentReference';
  NID_id_smime_aa_contentReference = 221;
  SN_id_smime_aa_encrypKeyPref = 'id-smime-aa-encrypKeyPref';
  NID_id_smime_aa_encrypKeyPref = 222;
  SN_id_smime_aa_signingCertificate = 'id-smime-aa-signingCertificate';
  NID_id_smime_aa_signingCertificate = 223;
  SN_id_smime_aa_smimeEncryptCerts = 'id-smime-aa-smimeEncryptCerts';
  NID_id_smime_aa_smimeEncryptCerts = 224;
  SN_id_smime_aa_timeStampToken = 'id-smime-aa-timeStampToken';
  NID_id_smime_aa_timeStampToken = 225;
  SN_id_smime_aa_ets_sigPolicyId = 'id-smime-aa-ets-sigPolicyId';
  NID_id_smime_aa_ets_sigPolicyId = 226;
  SN_id_smime_aa_ets_commitmentType = 'id-smime-aa-ets-commitmentType';
  NID_id_smime_aa_ets_commitmentType = 227;
  SN_id_smime_aa_ets_signerLocation = 'id-smime-aa-ets-signerLocation';
  NID_id_smime_aa_ets_signerLocation = 228;
  SN_id_smime_aa_ets_signerAttr = 'id-smime-aa-ets-signerAttr';
  NID_id_smime_aa_ets_signerAttr = 229;
  SN_id_smime_aa_ets_otherSigCert = 'id-smime-aa-ets-otherSigCert';
  NID_id_smime_aa_ets_otherSigCert = 230;
  SN_id_smime_aa_ets_contentTimestamp = 'id-smime-aa-ets-contentTimestamp';
  NID_id_smime_aa_ets_contentTimestamp = 231;
  SN_id_smime_aa_ets_CertificateRefs = 'id-smime-aa-ets-CertificateRefs';
  NID_id_smime_aa_ets_CertificateRefs = 232;
  SN_id_smime_aa_ets_RevocationRefs = 'id-smime-aa-ets-RevocationRefs';
  NID_id_smime_aa_ets_RevocationRefs = 233;
  SN_id_smime_aa_ets_certValues = 'id-smime-aa-ets-certValues';
  NID_id_smime_aa_ets_certValues = 234;
  SN_id_smime_aa_ets_revocationValues = 'id-smime-aa-ets-revocationValues';
  NID_id_smime_aa_ets_revocationValues = 235;
  SN_id_smime_aa_ets_escTimeStamp = 'id-smime-aa-ets-escTimeStamp';
  NID_id_smime_aa_ets_escTimeStamp = 236;
  SN_id_smime_aa_ets_certCRLTimestamp = 'id-smime-aa-ets-certCRLTimestamp';
  NID_id_smime_aa_ets_certCRLTimestamp = 237;
  SN_id_smime_aa_ets_archiveTimeStamp = 'id-smime-aa-ets-archiveTimeStamp';
  NID_id_smime_aa_ets_archiveTimeStamp = 238;
  SN_id_smime_aa_signatureType = 'id-smime-aa-signatureType';
  NID_id_smime_aa_signatureType = 239;
  SN_id_smime_aa_dvcs_dvc = 'id-smime-aa-dvcs-dvc';
  NID_id_smime_aa_dvcs_dvc = 240;
  SN_id_smime_aa_signingCertificateV2 = 'id-smime-aa-signingCertificateV2';
  NID_id_smime_aa_signingCertificateV2 = 1086;
  SN_id_smime_alg_ESDHwith3DES = 'id-smime-alg-ESDHwith3DES';
  NID_id_smime_alg_ESDHwith3DES = 241;
  SN_id_smime_alg_ESDHwithRC2 = 'id-smime-alg-ESDHwithRC2';
  NID_id_smime_alg_ESDHwithRC2 = 242;
  SN_id_smime_alg_3DESwrap = 'id-smime-alg-3DESwrap';
  NID_id_smime_alg_3DESwrap = 243;
  SN_id_smime_alg_RC2wrap = 'id-smime-alg-RC2wrap';
  NID_id_smime_alg_RC2wrap = 244;
  SN_id_smime_alg_ESDH = 'id-smime-alg-ESDH';
  NID_id_smime_alg_ESDH = 245;
  SN_id_smime_alg_CMS3DESwrap = 'id-smime-alg-CMS3DESwrap';
  NID_id_smime_alg_CMS3DESwrap = 246;
  SN_id_smime_alg_CMSRC2wrap = 'id-smime-alg-CMSRC2wrap';
  NID_id_smime_alg_CMSRC2wrap = 247;
  SN_id_alg_PWRI_KEK = 'id-alg-PWRI-KEK';
  NID_id_alg_PWRI_KEK = 893;
  SN_id_smime_cd_ldap = 'id-smime-cd-ldap';
  NID_id_smime_cd_ldap = 248;
  SN_id_smime_spq_ets_sqt_uri = 'id-smime-spq-ets-sqt-uri';
  NID_id_smime_spq_ets_sqt_uri = 249;
  SN_id_smime_spq_ets_sqt_unotice = 'id-smime-spq-ets-sqt-unotice';
  NID_id_smime_spq_ets_sqt_unotice = 250;
  SN_id_smime_cti_ets_proofOfOrigin = 'id-smime-cti-ets-proofOfOrigin';
  NID_id_smime_cti_ets_proofOfOrigin = 251;
  SN_id_smime_cti_ets_proofOfReceipt = 'id-smime-cti-ets-proofOfReceipt';
  NID_id_smime_cti_ets_proofOfReceipt = 252;
  SN_id_smime_cti_ets_proofOfDelivery = 'id-smime-cti-ets-proofOfDelivery';
  NID_id_smime_cti_ets_proofOfDelivery = 253;
  SN_id_smime_cti_ets_proofOfSender = 'id-smime-cti-ets-proofOfSender';
  NID_id_smime_cti_ets_proofOfSender = 254;
  SN_id_smime_cti_ets_proofOfApproval = 'id-smime-cti-ets-proofOfApproval';
  NID_id_smime_cti_ets_proofOfApproval = 255;
  SN_id_smime_cti_ets_proofOfCreation = 'id-smime-cti-ets-proofOfCreation';
  NID_id_smime_cti_ets_proofOfCreation = 256;
  LN_friendlyName = 'friendlyName';
  NID_friendlyName = 156;
  LN_localKeyID = 'localKeyID';
  NID_localKeyID = 157;
  SN_ms_csp_name = 'CSPName';
  LN_ms_csp_name = 'Microsoft CSP Name';
  NID_ms_csp_name = 417;
  SN_LocalKeySet = 'LocalKeySet';
  LN_LocalKeySet = 'Microsoft Local Key set';
  NID_LocalKeySet = 856;
  LN_x509Certificate = 'x509Certificate';
  NID_x509Certificate = 158;
  LN_sdsiCertificate = 'sdsiCertificate';
  NID_sdsiCertificate = 159;
  LN_x509Crl = 'x509Crl';
  NID_x509Crl = 160;
  SN_pbe_WithSHA1And128BitRC4 = 'PBE-SHA1-RC4-128';
  LN_pbe_WithSHA1And128BitRC4 = 'pbeWithSHA1And128BitRC4';
  NID_pbe_WithSHA1And128BitRC4 = 144;
  SN_pbe_WithSHA1And40BitRC4 = 'PBE-SHA1-RC4-40';
  LN_pbe_WithSHA1And40BitRC4 = 'pbeWithSHA1And40BitRC4';
  NID_pbe_WithSHA1And40BitRC4 = 145;
  SN_pbe_WithSHA1And3_Key_TripleDES_CBC = 'PBE-SHA1-3DES';
  LN_pbe_WithSHA1And3_Key_TripleDES_CBC = 'pbeWithSHA1And3-KeyTripleDES-CBC';
  NID_pbe_WithSHA1And3_Key_TripleDES_CBC = 146;
  SN_pbe_WithSHA1And2_Key_TripleDES_CBC = 'PBE-SHA1-2DES';
  LN_pbe_WithSHA1And2_Key_TripleDES_CBC = 'pbeWithSHA1And2-KeyTripleDES-CBC';
  NID_pbe_WithSHA1And2_Key_TripleDES_CBC = 147;
  SN_pbe_WithSHA1And128BitRC2_CBC = 'PBE-SHA1-RC2-128';
  LN_pbe_WithSHA1And128BitRC2_CBC = 'pbeWithSHA1And128BitRC2-CBC';
  NID_pbe_WithSHA1And128BitRC2_CBC = 148;
  SN_pbe_WithSHA1And40BitRC2_CBC = 'PBE-SHA1-RC2-40';
  LN_pbe_WithSHA1And40BitRC2_CBC = 'pbeWithSHA1And40BitRC2-CBC';
  NID_pbe_WithSHA1And40BitRC2_CBC = 149;
  LN_keyBag = 'keyBag';
  NID_keyBag = 150;
  LN_pkcs8ShroudedKeyBag = 'pkcs8ShroudedKeyBag';
  NID_pkcs8ShroudedKeyBag = 151;
  LN_certBag = 'certBag';
  NID_certBag = 152;
  LN_crlBag = 'crlBag';
  NID_crlBag = 153;
  LN_secretBag = 'secretBag';
  NID_secretBag = 154;
  LN_safeContentsBag = 'safeContentsBag';
  NID_safeContentsBag = 155;
  SN_md2 = 'MD2';
  LN_md2 = 'md2';
  NID_md2 = 3;
  SN_md4 = 'MD4';
  LN_md4 = 'md4';
  NID_md4 = 257;
  SN_md5 = 'MD5';
  LN_md5 = 'md5';
  NID_md5 = 4;
  SN_md5_sha1 = 'MD5-SHA1';
  LN_md5_sha1 = 'md5-sha1';
  NID_md5_sha1 = 114;
  LN_hmacWithMD5 = 'hmacWithMD5';
  NID_hmacWithMD5 = 797;
  LN_hmacWithSHA1 = 'hmacWithSHA1';
  NID_hmacWithSHA1 = 163;
  SN_sm2 = 'SM2';
  LN_sm2 = 'sm2';
  NID_sm2 = 1172;
  SN_sm3 = 'SM3';
  LN_sm3 = 'sm3';
  NID_sm3 = 1143;
  SN_sm3WithRSAEncryption = 'RSA-SM3';
  LN_sm3WithRSAEncryption = 'sm3WithRSAEncryption';
  NID_sm3WithRSAEncryption = 1144;
  LN_hmacWithSHA224 = 'hmacWithSHA224';
  NID_hmacWithSHA224 = 798;
  LN_hmacWithSHA256 = 'hmacWithSHA256';
  NID_hmacWithSHA256 = 799;
  LN_hmacWithSHA384 = 'hmacWithSHA384';
  NID_hmacWithSHA384 = 800;
  LN_hmacWithSHA512 = 'hmacWithSHA512';
  NID_hmacWithSHA512 = 801;
  LN_hmacWithSHA512_224 = 'hmacWithSHA512-224';
  NID_hmacWithSHA512_224 = 1193;
  LN_hmacWithSHA512_256 = 'hmacWithSHA512-256';
  NID_hmacWithSHA512_256 = 1194;
  SN_rc2_cbc = 'RC2-CBC';
  LN_rc2_cbc = 'rc2-cbc';
  NID_rc2_cbc = 37;
  SN_rc2_ecb = 'RC2-ECB';
  LN_rc2_ecb = 'rc2-ecb';
  NID_rc2_ecb = 38;
  SN_rc2_cfb64 = 'RC2-CFB';
  LN_rc2_cfb64 = 'rc2-cfb';
  NID_rc2_cfb64 = 39;
  SN_rc2_ofb64 = 'RC2-OFB';
  LN_rc2_ofb64 = 'rc2-ofb';
  NID_rc2_ofb64 = 40;
  SN_rc2_40_cbc = 'RC2-40-CBC';
  LN_rc2_40_cbc = 'rc2-40-cbc';
  NID_rc2_40_cbc = 98;
  SN_rc2_64_cbc = 'RC2-64-CBC';
  LN_rc2_64_cbc = 'rc2-64-cbc';
  NID_rc2_64_cbc = 166;
  SN_rc4 = 'RC4';
  LN_rc4 = 'rc4';
  NID_rc4 = 5;
  SN_rc4_40 = 'RC4-40';
  LN_rc4_40 = 'rc4-40';
  NID_rc4_40 = 97;
  SN_des_ede3_cbc = 'DES-EDE3-CBC';
  LN_des_ede3_cbc = 'des-ede3-cbc';
  NID_des_ede3_cbc = 44;
  SN_rc5_cbc = 'RC5-CBC';
  LN_rc5_cbc = 'rc5-cbc';
  NID_rc5_cbc = 120;
  SN_rc5_ecb = 'RC5-ECB';
  LN_rc5_ecb = 'rc5-ecb';
  NID_rc5_ecb = 121;
  SN_rc5_cfb64 = 'RC5-CFB';
  LN_rc5_cfb64 = 'rc5-cfb';
  NID_rc5_cfb64 = 122;
  SN_rc5_ofb64 = 'RC5-OFB';
  LN_rc5_ofb64 = 'rc5-ofb';
  NID_rc5_ofb64 = 123;
  SN_ms_ext_req = 'msExtReq';
  LN_ms_ext_req = 'Microsoft Extension Request';
  NID_ms_ext_req = 171;
  SN_ms_code_ind = 'msCodeInd';
  LN_ms_code_ind = 'Microsoft Individual Code Signing';
  NID_ms_code_ind = 134;
  SN_ms_code_com = 'msCodeCom';
  LN_ms_code_com = 'Microsoft Commercial Code Signing';
  NID_ms_code_com = 135;
  SN_ms_ctl_sign = 'msCTLSign';
  LN_ms_ctl_sign = 'Microsoft Trust List Signing';
  NID_ms_ctl_sign = 136;
  SN_ms_sgc = 'msSGC';
  LN_ms_sgc = 'Microsoft Server Gated Crypto';
  NID_ms_sgc = 137;
  SN_ms_efs = 'msEFS';
  LN_ms_efs = 'Microsoft Encrypted File System';
  NID_ms_efs = 138;
  SN_ms_smartcard_login = 'msSmartcardLogin';
  LN_ms_smartcard_login = 'Microsoft Smartcard Login';
  NID_ms_smartcard_login = 648;
  SN_ms_upn = 'msUPN';
  LN_ms_upn = 'Microsoft User Principal Name';
  NID_ms_upn = 649;
  SN_idea_cbc = 'IDEA-CBC';
  LN_idea_cbc = 'idea-cbc';
  NID_idea_cbc = 34;
  SN_idea_ecb = 'IDEA-ECB';
  LN_idea_ecb = 'idea-ecb';
  NID_idea_ecb = 36;
  SN_idea_cfb64 = 'IDEA-CFB';
  LN_idea_cfb64 = 'idea-cfb';
  NID_idea_cfb64 = 35;
  SN_idea_ofb64 = 'IDEA-OFB';
  LN_idea_ofb64 = 'idea-ofb';
  NID_idea_ofb64 = 46;
  SN_bf_cbc = 'BF-CBC';
  LN_bf_cbc = 'bf-cbc';
  NID_bf_cbc = 91;
  SN_bf_ecb = 'BF-ECB';
  LN_bf_ecb = 'bf-ecb';
  NID_bf_ecb = 92;
  SN_bf_cfb64 = 'BF-CFB';
  LN_bf_cfb64 = 'bf-cfb';
  NID_bf_cfb64 = 93;
  SN_bf_ofb64 = 'BF-OFB';
  LN_bf_ofb64 = 'bf-ofb';
  NID_bf_ofb64 = 94;
  SN_id_pkix = 'PKIX';
  NID_id_pkix = 127;
  SN_id_pkix_mod = 'id-pkix-mod';
  NID_id_pkix_mod = 258;
  SN_id_pe = 'id-pe';
  NID_id_pe = 175;
  SN_id_qt = 'id-qt';
  NID_id_qt = 259;
  SN_id_kp = 'id-kp';
  NID_id_kp = 128;
  SN_id_it = 'id-it';
  NID_id_it = 260;
  SN_id_pkip = 'id-pkip';
  NID_id_pkip = 261;
  SN_id_alg = 'id-alg';
  NID_id_alg = 262;
  SN_id_cmc = 'id-cmc';
  NID_id_cmc = 263;
  SN_id_on = 'id-on';
  NID_id_on = 264;
  SN_id_pda = 'id-pda';
  NID_id_pda = 265;
  SN_id_aca = 'id-aca';
  NID_id_aca = 266;
  SN_id_qcs = 'id-qcs';
  NID_id_qcs = 267;
  SN_id_cct = 'id-cct';
  NID_id_cct = 268;
  SN_id_ppl = 'id-ppl';
  NID_id_ppl = 662;
  SN_id_ad = 'id-ad';
  NID_id_ad = 176;
  SN_id_pkix1_explicit_88 = 'id-pkix1-explicit-88';
  NID_id_pkix1_explicit_88 = 269;
  SN_id_pkix1_implicit_88 = 'id-pkix1-implicit-88';
  NID_id_pkix1_implicit_88 = 270;
  SN_id_pkix1_explicit_93 = 'id-pkix1-explicit-93';
  NID_id_pkix1_explicit_93 = 271;
  SN_id_pkix1_implicit_93 = 'id-pkix1-implicit-93';
  NID_id_pkix1_implicit_93 = 272;
  SN_id_mod_crmf = 'id-mod-crmf';
  NID_id_mod_crmf = 273;
  SN_id_mod_cmc = 'id-mod-cmc';
  NID_id_mod_cmc = 274;
  SN_id_mod_kea_profile_88 = 'id-mod-kea-profile-88';
  NID_id_mod_kea_profile_88 = 275;
  SN_id_mod_kea_profile_93 = 'id-mod-kea-profile-93';
  NID_id_mod_kea_profile_93 = 276;
  SN_id_mod_cmp = 'id-mod-cmp';
  NID_id_mod_cmp = 277;
  SN_id_mod_qualified_cert_88 = 'id-mod-qualified-cert-88';
  NID_id_mod_qualified_cert_88 = 278;
  SN_id_mod_qualified_cert_93 = 'id-mod-qualified-cert-93';
  NID_id_mod_qualified_cert_93 = 279;
  SN_id_mod_attribute_cert = 'id-mod-attribute-cert';
  NID_id_mod_attribute_cert = 280;
  SN_id_mod_timestamp_protocol = 'id-mod-timestamp-protocol';
  NID_id_mod_timestamp_protocol = 281;
  SN_id_mod_ocsp = 'id-mod-ocsp';
  NID_id_mod_ocsp = 282;
  SN_id_mod_dvcs = 'id-mod-dvcs';
  NID_id_mod_dvcs = 283;
  SN_id_mod_cmp2000 = 'id-mod-cmp2000';
  NID_id_mod_cmp2000 = 284;
  SN_info_access = 'authorityInfoAccess';
  LN_info_access = 'Authority Information Access';
  SN_biometricInfo = 'biometricInfo';
  LN_biometricInfo = 'Biometric Info';
  NID_biometricInfo = 285;
  SN_qcStatements = 'qcStatements';
  NID_qcStatements = 286;
  SN_ac_auditEntity = 'ac-auditEntity';
  NID_ac_auditEntity = 287;
  SN_ac_targeting = 'ac-targeting';
  NID_ac_targeting = 288;
  SN_aaControls = 'aaControls';
  NID_aaControls = 289;
  SN_sbgp_ipAddrBlock = 'sbgp-ipAddrBlock';
  NID_sbgp_ipAddrBlock = 290;
  SN_sbgp_autonomousSysNum = 'sbgp-autonomousSysNum';
  NID_sbgp_autonomousSysNum = 291;
  SN_sbgp_routerIdentifier = 'sbgp-routerIdentifier';
  NID_sbgp_routerIdentifier = 292;
  SN_ac_proxying = 'ac-proxying';
  NID_ac_proxying = 397;
  SN_sinfo_access = 'subjectInfoAccess';
  LN_sinfo_access = 'Subject Information Access';
  NID_sinfo_access = 398;
  SN_proxyCertInfo = 'proxyCertInfo';
  LN_proxyCertInfo = 'Proxy Certificate Information';
  NID_proxyCertInfo = 663;
  SN_tlsfeature = 'tlsfeature';
  LN_tlsfeature = 'TLS Feature';
  NID_tlsfeature = 1020;
  SN_id_qt_cps = 'id-qt-cps';
  LN_id_qt_cps = 'Policy Qualifier CPS';
  NID_id_qt_cps = 164;
  SN_id_qt_unotice = 'id-qt-unotice';
  LN_id_qt_unotice = 'Policy Qualifier User Notice';
  NID_id_qt_unotice = 165;
  SN_textNotice = 'textNotice';
  NID_textNotice = 293;
  SN_server_auth = 'serverAuth';
  LN_server_auth = 'TLS Web Server Authentication';
  NID_server_auth = 129;
  SN_client_auth = 'clientAuth';
  LN_client_auth = 'TLS Web Client Authentication';
  NID_client_auth = 130;
  SN_code_sign = 'codeSigning';
  LN_code_sign = 'Code Signing';
  NID_code_sign = 131;
  SN_email_protect = 'emailProtection';
  LN_email_protect = 'E-mail Protection';
  NID_email_protect = 132;
  SN_ipsecEndSystem = 'ipsecEndSystem';
  LN_ipsecEndSystem = 'IPSec End System';
  NID_ipsecEndSystem = 294;
  SN_ipsecTunnel = 'ipsecTunnel';
  LN_ipsecTunnel = 'IPSec Tunnel';
  NID_ipsecTunnel = 295;
  SN_ipsecUser = 'ipsecUser';
  LN_ipsecUser = 'IPSec User';
  NID_ipsecUser = 296;
  SN_time_stamp = 'timeStamping';
  LN_time_stamp = 'Time Stamping';
  NID_time_stamp = 133;
  SN_OCSP_sign = 'OCSPSigning';
  LN_OCSP_sign = 'OCSP Signing';
  NID_OCSP_sign = 180;
  SN_dvcs = 'DVCS';
  LN_dvcs = 'dvcs';
  NID_dvcs = 297;
  SN_ipsec_IKE = 'ipsecIKE';
  LN_ipsec_IKE = 'ipsec Internet Key Exchange';
  NID_ipsec_IKE = 1022;
  SN_capwapAC = 'capwapAC';
  LN_capwapAC = 'Ctrl/provision WAP Access';
  NID_capwapAC = 1023;
  SN_capwapWTP = 'capwapWTP';
  LN_capwapWTP = 'Ctrl/Provision WAP Termination';
  NID_capwapWTP = 1024;
  SN_sshClient = 'secureShellClient';
  LN_sshClient = 'SSH Client';
  NID_sshClient = 1025;
  SN_sshServer = 'secureShellServer';
  LN_sshServer = 'SSH Server';
  NID_sshServer = 1026;
  SN_sendRouter = 'sendRouter';
  LN_sendRouter = 'Send Router';
  NID_sendRouter = 1027;
  SN_sendProxiedRouter = 'sendProxiedRouter';
  LN_sendProxiedRouter = 'Send Proxied Router';
  NID_sendProxiedRouter = 1028;
  SN_sendOwner = 'sendOwner';
  LN_sendOwner = 'Send Owner';
  NID_sendOwner = 1029;
  SN_sendProxiedOwner = 'sendProxiedOwner';
  LN_sendProxiedOwner = 'Send Proxied Owner';
  NID_sendProxiedOwner = 1030;
  SN_cmcCA = 'cmcCA';
  LN_cmcCA = 'CMC Certificate Authority';
  NID_cmcCA = 1131;
  SN_cmcRA = 'cmcRA';
  LN_cmcRA = 'CMC Registration Authority';
  NID_cmcRA = 1132;
  SN_id_it_caProtEncCert = 'id-it-caProtEncCert';
  NID_id_it_caProtEncCert = 298;
  SN_id_it_signKeyPairTypes = 'id-it-signKeyPairTypes';
  NID_id_it_signKeyPairTypes = 299;
  SN_id_it_encKeyPairTypes = 'id-it-encKeyPairTypes';
  NID_id_it_encKeyPairTypes = 300;
  SN_id_it_preferredSymmAlg = 'id-it-preferredSymmAlg';
  NID_id_it_preferredSymmAlg = 301;
  SN_id_it_caKeyUpdateInfo = 'id-it-caKeyUpdateInfo';
  NID_id_it_caKeyUpdateInfo = 302;
  SN_id_it_currentCRL = 'id-it-currentCRL';
  NID_id_it_currentCRL = 303;
  SN_id_it_unsupportedOIDs = 'id-it-unsupportedOIDs';
  NID_id_it_unsupportedOIDs = 304;
  SN_id_it_subscriptionRequest = 'id-it-subscriptionRequest';
  NID_id_it_subscriptionRequest = 305;
  SN_id_it_subscriptionResponse = 'id-it-subscriptionResponse';
  NID_id_it_subscriptionResponse = 306;
  SN_id_it_keyPairParamReq = 'id-it-keyPairParamReq';
  NID_id_it_keyPairParamReq = 307;
  SN_id_it_keyPairParamRep = 'id-it-keyPairParamRep';
  NID_id_it_keyPairParamRep = 308;
  SN_id_it_revPassphrase = 'id-it-revPassphrase';
  NID_id_it_revPassphrase = 309;
  SN_id_it_implicitConfirm = 'id-it-implicitConfirm';
  NID_id_it_implicitConfirm = 310;
  SN_id_it_confirmWaitTime = 'id-it-confirmWaitTime';
  NID_id_it_confirmWaitTime = 311;
  SN_id_it_origPKIMessage = 'id-it-origPKIMessage';
  NID_id_it_origPKIMessage = 312;
  SN_id_it_suppLangTags = 'id-it-suppLangTags';
  NID_id_it_suppLangTags = 784;
  SN_id_regCtrl = 'id-regCtrl';
  NID_id_regCtrl = 313;
  SN_id_regInfo = 'id-regInfo';
  NID_id_regInfo = 314;
  SN_id_regCtrl_regToken = 'id-regCtrl-regToken';
  NID_id_regCtrl_regToken = 315;
  SN_id_regCtrl_authenticator = 'id-regCtrl-authenticator';
  NID_id_regCtrl_authenticator = 316;
  SN_id_regCtrl_pkiPublicationInfo = 'id-regCtrl-pkiPublicationInfo';
  NID_id_regCtrl_pkiPublicationInfo = 317;
  SN_id_regCtrl_pkiArchiveOptions = 'id-regCtrl-pkiArchiveOptions';
  NID_id_regCtrl_pkiArchiveOptions = 318;
  SN_id_regCtrl_oldCertID = 'id-regCtrl-oldCertID';
  NID_id_regCtrl_oldCertID = 319;
  SN_id_regCtrl_protocolEncrKey = 'id-regCtrl-protocolEncrKey';
  NID_id_regCtrl_protocolEncrKey = 320;
  SN_id_regInfo_utf8Pairs = 'id-regInfo-utf8Pairs';
  NID_id_regInfo_utf8Pairs = 321;
  SN_id_regInfo_certReq = 'id-regInfo-certReq';
  NID_id_regInfo_certReq = 322;
  SN_id_alg_des40 = 'id-alg-des40';
  NID_id_alg_des40 = 323;
  SN_id_alg_noSignature = 'id-alg-noSignature';
  NID_id_alg_noSignature = 324;
  SN_id_alg_dh_sig_hmac_sha1 = 'id-alg-dh-sig-hmac-sha1';
  NID_id_alg_dh_sig_hmac_sha1 = 325;
  SN_id_alg_dh_pop = 'id-alg-dh-pop';
  NID_id_alg_dh_pop = 326;
  SN_id_cmc_statusInfo = 'id-cmc-statusInfo';
  NID_id_cmc_statusInfo = 327;
  SN_id_cmc_identification = 'id-cmc-identification';
  NID_id_cmc_identification = 328;
  SN_id_cmc_identityProof = 'id-cmc-identityProof';
  NID_id_cmc_identityProof = 329;
  SN_id_cmc_dataReturn = 'id-cmc-dataReturn';
  NID_id_cmc_dataReturn = 330;
  SN_id_cmc_transactionId = 'id-cmc-transactionId';
  NID_id_cmc_transactionId = 331;
  SN_id_cmc_senderNonce = 'id-cmc-senderNonce';
  NID_id_cmc_senderNonce = 332;
  SN_id_cmc_recipientNonce = 'id-cmc-recipientNonce';
  NID_id_cmc_recipientNonce = 333;
  SN_id_cmc_addExtensions = 'id-cmc-addExtensions';
  NID_id_cmc_addExtensions = 334;
  SN_id_cmc_encryptedPOP = 'id-cmc-encryptedPOP';
  NID_id_cmc_encryptedPOP = 335;
  SN_id_cmc_decryptedPOP = 'id-cmc-decryptedPOP';
  NID_id_cmc_decryptedPOP = 336;
  SN_id_cmc_lraPOPWitness = 'id-cmc-lraPOPWitness';
  NID_id_cmc_lraPOPWitness = 337;
  SN_id_cmc_getCert = 'id-cmc-getCert';
  NID_id_cmc_getCert = 338;
  SN_id_cmc_getCRL = 'id-cmc-getCRL';
  NID_id_cmc_getCRL = 339;
  SN_id_cmc_revokeRequest = 'id-cmc-revokeRequest';
  NID_id_cmc_revokeRequest = 340;
  SN_id_cmc_regInfo = 'id-cmc-regInfo';
  NID_id_cmc_regInfo = 341;
  SN_id_cmc_responseInfo = 'id-cmc-responseInfo';
  NID_id_cmc_responseInfo = 342;
  SN_id_cmc_queryPending = 'id-cmc-queryPending';
  NID_id_cmc_queryPending = 343;
  SN_id_cmc_popLinkRandom = 'id-cmc-popLinkRandom';
  NID_id_cmc_popLinkRandom = 344;
  SN_id_cmc_popLinkWitness = 'id-cmc-popLinkWitness';
  NID_id_cmc_popLinkWitness = 345;
  SN_id_cmc_confirmCertAcceptance = 'id-cmc-confirmCertAcceptance';
  NID_id_cmc_confirmCertAcceptance = 346;
  SN_id_on_personalData = 'id-on-personalData';
  NID_id_on_personalData = 347;
  SN_id_on_permanentIdentifier = 'id-on-permanentIdentifier';
  LN_id_on_permanentIdentifier = 'Permanent Identifier';
  NID_id_on_permanentIdentifier = 858;
  SN_id_pda_dateOfBirth = 'id-pda-dateOfBirth';
  NID_id_pda_dateOfBirth = 348;
  SN_id_pda_placeOfBirth = 'id-pda-placeOfBirth';
  NID_id_pda_placeOfBirth = 349;
  SN_id_pda_gender = 'id-pda-gender';
  NID_id_pda_gender = 351;
  SN_id_pda_countryOfCitizenship = 'id-pda-countryOfCitizenship';
  NID_id_pda_countryOfCitizenship = 352;
  SN_id_pda_countryOfResidence = 'id-pda-countryOfResidence';
  NID_id_pda_countryOfResidence = 353;
  SN_id_aca_authenticationInfo = 'id-aca-authenticationInfo';
  NID_id_aca_authenticationInfo = 354;
  SN_id_aca_accessIdentity = 'id-aca-accessIdentity';
  NID_id_aca_accessIdentity = 355;
  SN_id_aca_chargingIdentity = 'id-aca-chargingIdentity';
  NID_id_aca_chargingIdentity = 356;
  SN_id_aca_group = 'id-aca-group';
  NID_id_aca_group = 357;
  SN_id_aca_role = 'id-aca-role';
  NID_id_aca_role = 358;
  SN_id_aca_encAttrs = 'id-aca-encAttrs';
  NID_id_aca_encAttrs = 399;
  SN_id_qcs_pkixQCSyntax_v1 = 'id-qcs-pkixQCSyntax-v1';
  NID_id_qcs_pkixQCSyntax_v1 = 359;
  SN_id_cct_crs = 'id-cct-crs';
  NID_id_cct_crs = 360;
  SN_id_cct_PKIData = 'id-cct-PKIData';
  NID_id_cct_PKIData = 361;
  SN_id_cct_PKIResponse = 'id-cct-PKIResponse';
  NID_id_cct_PKIResponse = 362;
  SN_id_ppl_anyLanguage = 'id-ppl-anyLanguage';
  LN_id_ppl_anyLanguage = 'Any language';
  NID_id_ppl_anyLanguage = 664;
  SN_id_ppl_inheritAll = 'id-ppl-inheritAll';
  LN_id_ppl_inheritAll = 'Inherit all';
  NID_id_ppl_inheritAll = 665;
  SN_Independent = 'id-ppl-independent';
  LN_Independent = 'Independent';
  NID_Independent = 667;
  SN_ad_OCSP = 'OCSP';
  LN_ad_OCSP = 'OCSP';
  NID_ad_OCSP = 178;
  SN_ad_ca_issuers = 'caIssuers';
  LN_ad_ca_issuers = 'CA Issuers';
  NID_ad_ca_issuers = 179;
  SN_ad_timeStamping = 'ad_timestamping';
  LN_ad_timeStamping = 'AD Time Stamping';
  NID_ad_timeStamping = 363;
  SN_ad_dvcs = 'AD_DVCS';
  LN_ad_dvcs = 'ad dvcs';
  NID_ad_dvcs = 364;
  SN_caRepository = 'caRepository';
  LN_caRepository = 'CA Repository';
  NID_caRepository = 785;
  SN_id_pkix_OCSP_basic = 'basicOCSPResponse';
  LN_id_pkix_OCSP_basic = 'Basic OCSP Response';
  NID_id_pkix_OCSP_basic = 365;
  SN_id_pkix_OCSP_Nonce = 'Nonce';
  LN_id_pkix_OCSP_Nonce = 'OCSP Nonce';
  NID_id_pkix_OCSP_Nonce = 366;
  SN_id_pkix_OCSP_CrlID = 'CrlID';
  LN_id_pkix_OCSP_CrlID = 'OCSP CRL ID';
  NID_id_pkix_OCSP_CrlID = 367;
  SN_id_pkix_OCSP_acceptableResponses = 'acceptableResponses';
  LN_id_pkix_OCSP_acceptableResponses = 'Acceptable OCSP Responses';
  NID_id_pkix_OCSP_acceptableResponses = 368;
  SN_id_pkix_OCSP_noCheck = 'noCheck';
  LN_id_pkix_OCSP_noCheck = 'OCSP No Check';
  NID_id_pkix_OCSP_noCheck = 369;
  SN_id_pkix_OCSP_archiveCutoff = 'archiveCutoff';
  LN_id_pkix_OCSP_archiveCutoff = 'OCSP Archive Cutoff';
  NID_id_pkix_OCSP_archiveCutoff = 370;
  SN_id_pkix_OCSP_serviceLocator = 'serviceLocator';
  LN_id_pkix_OCSP_serviceLocator = 'OCSP Service Locator';
  NID_id_pkix_OCSP_serviceLocator = 371;
  SN_id_pkix_OCSP_extendedStatus = 'extendedStatus';
  LN_id_pkix_OCSP_extendedStatus = 'Extended OCSP Status';
  NID_id_pkix_OCSP_extendedStatus = 372;
  SN_id_pkix_OCSP_valid = 'valid';
  NID_id_pkix_OCSP_valid = 373;
  SN_id_pkix_OCSP_path = 'path';
  NID_id_pkix_OCSP_path = 374;
  SN_id_pkix_OCSP_trustRoot = 'trustRoot';
  LN_id_pkix_OCSP_trustRoot = 'Trust Root';
  NID_id_pkix_OCSP_trustRoot = 375;
  SN_algorithm = 'algorithm';
  LN_algorithm = 'algorithm';
  NID_algorithm = 376;
  SN_md5WithRSA = 'RSA-NP-MD5';
  LN_md5WithRSA = 'md5WithRSA';
  NID_md5WithRSA = 104;
  SN_des_ecb = 'DES-ECB';
  LN_des_ecb = 'des-ecb';
  NID_des_ecb = 29;
  SN_des_cbc = 'DES-CBC';
  LN_des_cbc = 'des-cbc';
  NID_des_cbc = 31;
  SN_des_ofb64 = 'DES-OFB';
  LN_des_ofb64 = 'des-ofb';
  NID_des_ofb64 = 45;
  SN_des_cfb64 = 'DES-CFB';
  LN_des_cfb64 = 'des-cfb';
  NID_des_cfb64 = 30;
  SN_rsaSignature = 'rsaSignature';
  NID_rsaSignature = 377;
  SN_dsa_2 = 'DSA-old';
  LN_dsa_2 = 'dsaEncryption-old';
  NID_dsa_2 = 67;
  SN_dsaWithSHA = 'DSA-SHA';
  LN_dsaWithSHA = 'dsaWithSHA';
  NID_dsaWithSHA = 66;
  SN_shaWithRSAEncryption = 'RSA-SHA';
  LN_shaWithRSAEncryption = 'shaWithRSAEncryption';
  NID_shaWithRSAEncryption = 42;
  SN_des_ede_ecb = 'DES-EDE';
  LN_des_ede_ecb = 'des-ede';
  NID_des_ede_ecb = 32;
  SN_des_ede3_ecb = 'DES-EDE3';
  LN_des_ede3_ecb = 'des-ede3';
  NID_des_ede3_ecb = 33;
  SN_des_ede_cbc = 'DES-EDE-CBC';
  LN_des_ede_cbc = 'des-ede-cbc';
  NID_des_ede_cbc = 43;
  SN_des_ede_cfb64 = 'DES-EDE-CFB';
  LN_des_ede_cfb64 = 'des-ede-cfb';
  NID_des_ede_cfb64 = 60;
  SN_des_ede3_cfb64 = 'DES-EDE3-CFB';
  LN_des_ede3_cfb64 = 'des-ede3-cfb';
  NID_des_ede3_cfb64 = 61;
  SN_des_ede_ofb64 = 'DES-EDE-OFB';
  LN_des_ede_ofb64 = 'des-ede-ofb';
  NID_des_ede_ofb64 = 62;
  SN_des_ede3_ofb64 = 'DES-EDE3-OFB';
  LN_des_ede3_ofb64 = 'des-ede3-ofb';
  NID_des_ede3_ofb64 = 63;
  SN_desx_cbc = 'DESX-CBC';
  LN_desx_cbc = 'desx-cbc';
  NID_desx_cbc = 80;
  SN_sha = 'SHA';
  LN_sha = 'sha';
  NID_sha = 41;
  SN_sha1 = 'SHA1';
  LN_sha1 = 'sha1';
  NID_sha1 = 64;
  SN_dsaWithSHA1_2 = 'DSA-SHA1-old';
  LN_dsaWithSHA1_2 = 'dsaWithSHA1-old';
  NID_dsaWithSHA1_2 = 70;
  SN_sha1WithRSA = 'RSA-SHA1-2';
  LN_sha1WithRSA = 'sha1WithRSA';
  NID_sha1WithRSA = 115;
  SN_ripemd160 = 'RIPEMD160';
  LN_ripemd160 = 'ripemd160';
  NID_ripemd160 = 117;
  SN_ripemd160WithRSA = 'RSA-RIPEMD160';
  LN_ripemd160WithRSA = 'ripemd160WithRSA';
  NID_ripemd160WithRSA = 119;
  SN_blake2b512 = 'BLAKE2b512';
  LN_blake2b512 = 'blake2b512';
  NID_blake2b512 = 1056;
  SN_blake2s256 = 'BLAKE2s256';
  LN_blake2s256 = 'blake2s256';
  NID_blake2s256 = 1057;
  SN_sxnet = 'SXNetID';
  LN_sxnet = 'Strong Extranet ID';
  NID_sxnet = 143;
  SN_X500 = 'X500';
  LN_X500 = 'directory services X.500';
  NID_X500 = 11;
  SN_X509 = 'X509';
  NID_X509 = 12;
  SN_commonName = 'CN';
  LN_commonName = 'commonName';
  NID_commonName = 13;
  SN_surname = 'SN';
  LN_surname = 'surname';
  NID_surname = 100;
  LN_serialNumber = 'serialNumber';
  NID_serialNumber = 105;
  SN_countryName = 'C';
  LN_countryName = 'countryName';
  NID_countryName = 14;
  SN_localityName = 'L';
  LN_localityName = 'localityName';
  NID_localityName = 15;
  SN_stateOrProvinceName = 'ST';
  LN_stateOrProvinceName = 'stateOrProvinceName';
  NID_stateOrProvinceName = 16;
  SN_streetAddress = 'street';
  LN_streetAddress = 'streetAddress';
  NID_streetAddress = 660;
  SN_organizationName = 'O';
  LN_organizationName = 'organizationName';
  NID_organizationName = 17;
  SN_organizationalUnitName = 'OU';
  LN_organizationalUnitName = 'organizationalUnitName';
  NID_organizationalUnitName = 18;
  SN_title = 'title';
  LN_title = 'title';
  NID_title = 106;
  LN_description = 'description';
  NID_description = 107;
  LN_searchGuide = 'searchGuide';
  NID_searchGuide = 859;
  LN_businessCategory = 'businessCategory';
  NID_businessCategory = 860;
  LN_postalAddress = 'postalAddress';
  NID_postalAddress = 861;
  LN_postalCode = 'postalCode';
  NID_postalCode = 661;
  LN_postOfficeBox = 'postOfficeBox';
  NID_postOfficeBox = 862;
  LN_physicalDeliveryOfficeName = 'physicalDeliveryOfficeName';
  NID_physicalDeliveryOfficeName = 863;
  LN_telephoneNumber = 'telephoneNumber';
  NID_telephoneNumber = 864;
  LN_telexNumber = 'telexNumber';
  NID_telexNumber = 865;
  LN_teletexTerminalIdentifier = 'teletexTerminalIdentifier';
  NID_teletexTerminalIdentifier = 866;
  LN_facsimileTelephoneNumber = 'facsimileTelephoneNumber';
  NID_facsimileTelephoneNumber = 867;
  LN_x121Address = 'x121Address';
  NID_x121Address = 868;
  LN_internationaliSDNNumber = 'internationaliSDNNumber';
  NID_internationaliSDNNumber = 869;
  LN_registeredAddress = 'registeredAddress';
  NID_registeredAddress = 870;
  LN_destinationIndicator = 'destinationIndicator';
  NID_destinationIndicator = 871;
  LN_preferredDeliveryMethod = 'preferredDeliveryMethod';
  NID_preferredDeliveryMethod = 872;
  LN_presentationAddress = 'presentationAddress';
  NID_presentationAddress = 873;
  LN_supportedApplicationContext = 'supportedApplicationContext';
  NID_supportedApplicationContext = 874;
  SN_member = 'member';
  NID_member = 875;
  SN_owner = 'owner';
  NID_owner = 876;
  LN_roleOccupant = 'roleOccupant';
  NID_roleOccupant = 877;
  SN_seeAlso = 'seeAlso';
  NID_seeAlso = 878;
  LN_userPassword = 'userPassword';
  NID_userPassword = 879;
  LN_userCertificate = 'userCertificate';
  NID_userCertificate = 880;
  LN_cACertificate = 'cACertificate';
  NID_cACertificate = 881;
  LN_authorityRevocationList = 'authorityRevocationList';
  NID_authorityRevocationList = 882;
  LN_certificateRevocationList = 'certificateRevocationList';
  NID_certificateRevocationList = 883;
  LN_crossCertificatePair = 'crossCertificatePair';
  NID_crossCertificatePair = 884;
  SN_name = 'name';
  LN_name = 'name';
  NID_name = 173;
  SN_givenName = 'GN';
  LN_givenName = 'givenName';
  NID_givenName = 99;
  SN_initials = 'initials';
  LN_initials = 'initials';
  NID_initials = 101;
  LN_generationQualifier = 'generationQualifier';
  NID_generationQualifier = 509;
  LN_x500UniqueIdentifier = 'x500UniqueIdentifier';
  NID_x500UniqueIdentifier = 503;
  SN_dnQualifier = 'dnQualifier';
  LN_dnQualifier = 'dnQualifier';
  NID_dnQualifier = 174;
  LN_enhancedSearchGuide = 'enhancedSearchGuide';
  NID_enhancedSearchGuide = 885;
  LN_protocolInformation = 'protocolInformation';
  NID_protocolInformation = 886;
  LN_distinguishedName = 'distinguishedName';
  NID_distinguishedName = 887;
  LN_uniqueMember = 'uniqueMember';
  NID_uniqueMember = 888;
  LN_houseIdentifier = 'houseIdentifier';
  NID_houseIdentifier = 889;
  LN_supportedAlgorithms = 'supportedAlgorithms';
  NID_supportedAlgorithms = 890;
  LN_deltaRevocationList = 'deltaRevocationList';
  NID_deltaRevocationList = 891;
  SN_dmdName = 'dmdName';
  NID_dmdName = 892;
  LN_pseudonym = 'pseudonym';
  NID_pseudonym = 510;
  SN_role = 'role';
  LN_role = 'role';
  NID_role = 400;
  LN_organizationIdentifier = 'organizationIdentifier';
  NID_organizationIdentifier = 1089;
  SN_countryCode3c = 'c3';
  LN_countryCode3c = 'countryCode3c';
  NID_countryCode3c = 1090;
  SN_countryCode3n = 'n3';
  LN_countryCode3n = 'countryCode3n';
  NID_countryCode3n = 1091;
  LN_dnsName = 'dnsName';
  NID_dnsName = 1092;
  SN_X500algorithms = 'X500algorithms';
  LN_X500algorithms = 'directory services - algorithms';
  NID_X500algorithms = 378;
  SN_rsa = 'RSA';
  LN_rsa = 'rsa';
  NID_rsa = 19;
  SN_mdc2WithRSA = 'RSA-MDC2';
  LN_mdc2WithRSA = 'mdc2WithRSA';
  NID_mdc2WithRSA = 96;
  SN_mdc2 = 'MDC2';
  LN_mdc2 = 'mdc2';
  NID_mdc2 = 95;
  SN_id_ce = 'id-ce';
  NID_id_ce = 81;
  SN_subject_directory_attributes = 'subjectDirectoryAttributes';
  LN_subject_directory_attributes = 'X509v3 Subject Directory Attributes';
  NID_subject_directory_attributes = 769;
  SN_subject_key_identifier = 'subjectKeyIdentifier';
  LN_subject_key_identifier = 'X509v3 Subject Key Identifier';
  SN_key_usage = 'keyUsage';
  LN_key_usage = 'X509v3 Key Usage';
  SN_private_key_usage_period = 'privateKeyUsagePeriod';
  LN_private_key_usage_period = 'X509v3 Private Key Usage Period';
  NID_private_key_usage_period = 84;
  SN_subject_alt_name = 'subjectAltName';
  LN_subject_alt_name = 'X509v3 Subject Alternative Name';
  SN_issuer_alt_name = 'issuerAltName';
  LN_issuer_alt_name = 'X509v3 Issuer Alternative Name';
  SN_basic_constraints = 'basicConstraints';
  LN_basic_constraints = 'X509v3 Basic Constraints';
  SN_issuing_distribution_point = 'issuingDistributionPoint';
  LN_issuing_distribution_point = 'X509v3 Issuing Distribution Point';
  NID_issuing_distribution_point = 770;
  SN_certificate_issuer = 'certificateIssuer';
  LN_certificate_issuer = 'X509v3 Certificate Issuer';
  NID_certificate_issuer = 771;
  SN_name_constraints = 'nameConstraints';
  LN_name_constraints = 'X509v3 Name Constraints';
  NID_name_constraints = 666;
  SN_crl_distribution_points = 'crlDistributionPoints';
  LN_crl_distribution_points = 'X509v3 CRL Distribution Points';
  NID_crl_distribution_points = 103;
  SN_certificate_policies = 'certificatePolicies';
  LN_certificate_policies = 'X509v3 Certificate Policies';
  NID_certificate_policies = 89;
  SN_any_policy = 'anyPolicy';
  LN_any_policy = 'X509v3 Any Policy';
  NID_any_policy = 746;
  SN_policy_mappings = 'policyMappings';
  LN_policy_mappings = 'X509v3 Policy Mappings';
  NID_policy_mappings = 747;
  SN_authority_key_identifier = 'authorityKeyIdentifier';
  LN_authority_key_identifier = 'X509v3 Authority Key Identifier';
  SN_policy_constraints = 'policyConstraints';
  LN_policy_constraints = 'X509v3 Policy Constraints';
  NID_policy_constraints = 401;
  SN_ext_key_usage = 'extendedKeyUsage';
  LN_ext_key_usage = 'X509v3 Extended Key Usage';
  SN_freshest_crl = 'freshestCRL';
  LN_freshest_crl = 'X509v3 Freshest CRL';
  NID_freshest_crl = 857;
  SN_inhibit_any_policy = 'inhibitAnyPolicy';
  LN_inhibit_any_policy = 'X509v3 Inhibit Any Policy';
  NID_inhibit_any_policy = 748;
  SN_target_information = 'targetInformation';
  LN_target_information = 'X509v3 AC Targeting';
  NID_target_information = 402;
  SN_no_rev_avail = 'noRevAvail';
  LN_no_rev_avail = 'X509v3 No Revocation Available';
  NID_no_rev_avail = 403;
  SN_anyExtendedKeyUsage = 'anyExtendedKeyUsage';
  LN_anyExtendedKeyUsage = 'Any Extended Key Usage';
  NID_anyExtendedKeyUsage = 910;
  SN_netscape = 'Netscape';
  LN_netscape = 'Netscape Communications Corp.';
  NID_netscape = 57;
  SN_netscape_cert_extension = 'nsCertExt';
  LN_netscape_cert_extension = 'Netscape Certificate Extension';
  NID_netscape_cert_extension = 58;
  SN_netscape_data_type = 'nsDataType';
  LN_netscape_data_type = 'Netscape Data Type';
  NID_netscape_data_type = 59;
  SN_netscape_cert_type = 'nsCertType';
  LN_netscape_cert_type = 'Netscape Cert Type';
  NID_netscape_cert_type = 71;
  SN_netscape_base_url = 'nsBaseUrl';
  LN_netscape_base_url = 'Netscape Base Url';
  NID_netscape_base_url = 72;
  SN_netscape_revocation_url = 'nsRevocationUrl';
  LN_netscape_revocation_url = 'Netscape Revocation Url';
  NID_netscape_revocation_url = 73;
  SN_netscape_ca_revocation_url = 'nsCaRevocationUrl';
  LN_netscape_ca_revocation_url = 'Netscape CA Revocation Url';
  NID_netscape_ca_revocation_url = 74;
  SN_netscape_renewal_url = 'nsRenewalUrl';
  LN_netscape_renewal_url = 'Netscape Renewal Url';
  NID_netscape_renewal_url = 75;
  SN_netscape_ca_policy_url = 'nsCaPolicyUrl';
  LN_netscape_ca_policy_url = 'Netscape CA Policy Url';
  NID_netscape_ca_policy_url = 76;
  SN_netscape_ssl_server_name = 'nsSslServerName';
  LN_netscape_ssl_server_name = 'Netscape SSL Server Name';
  NID_netscape_ssl_server_name = 77;
  SN_netscape_comment = 'nsComment';
  LN_netscape_comment = 'Netscape Comment';
  SN_netscape_cert_sequence = 'nsCertSequence';
  LN_netscape_cert_sequence = 'Netscape Certificate Sequence';
  NID_netscape_cert_sequence = 79;
  SN_ns_sgc = 'nsSGC';
  LN_ns_sgc = 'Netscape Server Gated Crypto';
  NID_ns_sgc = 139;
  SN_org = 'ORG';
  LN_org = 'org';
  NID_org = 379;
  SN_dod = 'DOD';
  LN_dod = 'dod';
  NID_dod = 380;
  SN_iana = 'IANA';
  LN_iana = 'iana';
  NID_iana = 381;
  SN_Directory = 'directory';
  LN_Directory = 'Directory';
  NID_Directory = 382;
  SN_Management = 'mgmt';
  LN_Management = 'Management';
  NID_Management = 383;
  SN_Experimental = 'experimental';
  LN_Experimental = 'Experimental';
  NID_Experimental = 384;
  SN_Private = 'private';
  LN_Private = 'Private';
  NID_Private = 385;
  SN_Security = 'security';
  LN_Security = 'Security';
  NID_Security = 386;
  SN_SNMPv2 = 'snmpv2';
  LN_SNMPv2 = 'SNMPv2';
  NID_SNMPv2 = 387;
  LN_Mail = 'Mail';
  NID_Mail = 388;
  SN_Enterprises = 'enterprises';
  LN_Enterprises = 'Enterprises';
  NID_Enterprises = 389;
  SN_dcObject = 'dcobject';
  LN_dcObject = 'dcObject';
  NID_dcObject = 390;
  SN_mime_mhs = 'mime-mhs';
  LN_mime_mhs = 'MIME MHS';
  NID_mime_mhs = 504;
  SN_mime_mhs_headings = 'mime-mhs-headings';
  LN_mime_mhs_headings = 'mime-mhs-headings';
  NID_mime_mhs_headings = 505;
  SN_mime_mhs_bodies = 'mime-mhs-bodies';
  LN_mime_mhs_bodies = 'mime-mhs-bodies';
  NID_mime_mhs_bodies = 506;
  SN_id_hex_partial_message = 'id-hex-partial-message';
  LN_id_hex_partial_message = 'id-hex-partial-message';
  NID_id_hex_partial_message = 507;
  SN_id_hex_multipart_message = 'id-hex-multipart-message';
  LN_id_hex_multipart_message = 'id-hex-multipart-message';
  NID_id_hex_multipart_message = 508;
  SN_zlib_compression = 'ZLIB';
  LN_zlib_compression = 'zlib compression';
  NID_zlib_compression = 125;
  SN_aes_128_ecb = 'AES-128-ECB';
  LN_aes_128_ecb = 'aes-128-ecb';
  NID_aes_128_ecb = 418;
  SN_aes_128_cbc = 'AES-128-CBC';
  LN_aes_128_cbc = 'aes-128-cbc';
  NID_aes_128_cbc = 419;
  SN_aes_128_ofb128 = 'AES-128-OFB';
  LN_aes_128_ofb128 = 'aes-128-ofb';
  NID_aes_128_ofb128 = 420;
  SN_aes_128_cfb128 = 'AES-128-CFB';
  LN_aes_128_cfb128 = 'aes-128-cfb';
  NID_aes_128_cfb128 = 421;
  SN_id_aes128_wrap = 'id-aes128-wrap';
  NID_id_aes128_wrap = 788;
  SN_aes_128_gcm = 'id-aes128-GCM';
  LN_aes_128_gcm = 'aes-128-gcm';
  NID_aes_128_gcm = 895;
  SN_aes_128_ccm = 'id-aes128-CCM';
  LN_aes_128_ccm = 'aes-128-ccm';
  NID_aes_128_ccm = 896;
  SN_id_aes128_wrap_pad = 'id-aes128-wrap-pad';
  NID_id_aes128_wrap_pad = 897;
  SN_aes_192_ecb = 'AES-192-ECB';
  LN_aes_192_ecb = 'aes-192-ecb';
  NID_aes_192_ecb = 422;
  SN_aes_192_cbc = 'AES-192-CBC';
  LN_aes_192_cbc = 'aes-192-cbc';
  NID_aes_192_cbc = 423;
  SN_aes_192_ofb128 = 'AES-192-OFB';
  LN_aes_192_ofb128 = 'aes-192-ofb';
  NID_aes_192_ofb128 = 424;
  SN_aes_192_cfb128 = 'AES-192-CFB';
  LN_aes_192_cfb128 = 'aes-192-cfb';
  NID_aes_192_cfb128 = 425;
  SN_id_aes192_wrap = 'id-aes192-wrap';
  NID_id_aes192_wrap = 789;
  SN_aes_192_gcm = 'id-aes192-GCM';
  LN_aes_192_gcm = 'aes-192-gcm';
  NID_aes_192_gcm = 898;
  SN_aes_192_ccm = 'id-aes192-CCM';
  LN_aes_192_ccm = 'aes-192-ccm';
  NID_aes_192_ccm = 899;
  SN_id_aes192_wrap_pad = 'id-aes192-wrap-pad';
  NID_id_aes192_wrap_pad = 900;
  SN_aes_256_ecb = 'AES-256-ECB';
  LN_aes_256_ecb = 'aes-256-ecb';
  NID_aes_256_ecb = 426;
  SN_aes_256_cbc = 'AES-256-CBC';
  LN_aes_256_cbc = 'aes-256-cbc';
  NID_aes_256_cbc = 427;
  SN_aes_256_ofb128 = 'AES-256-OFB';
  LN_aes_256_ofb128 = 'aes-256-ofb';
  NID_aes_256_ofb128 = 428;
  SN_aes_256_cfb128 = 'AES-256-CFB';
  LN_aes_256_cfb128 = 'aes-256-cfb';
  NID_aes_256_cfb128 = 429;
  SN_id_aes256_wrap = 'id-aes256-wrap';
  NID_id_aes256_wrap = 790;
  SN_aes_256_gcm = 'id-aes256-GCM';
  LN_aes_256_gcm = 'aes-256-gcm';
  NID_aes_256_gcm = 901;
  SN_aes_256_ccm = 'id-aes256-CCM';
  LN_aes_256_ccm = 'aes-256-ccm';
  NID_aes_256_ccm = 902;
  SN_id_aes256_wrap_pad = 'id-aes256-wrap-pad';
  NID_id_aes256_wrap_pad = 903;
  SN_aes_128_xts = 'AES-128-XTS';
  LN_aes_128_xts = 'aes-128-xts';
  NID_aes_128_xts = 913;
  SN_aes_256_xts = 'AES-256-XTS';
  LN_aes_256_xts = 'aes-256-xts';
  NID_aes_256_xts = 914;
  SN_aes_128_cfb1 = 'AES-128-CFB1';
  LN_aes_128_cfb1 = 'aes-128-cfb1';
  NID_aes_128_cfb1 = 650;
  SN_aes_192_cfb1 = 'AES-192-CFB1';
  LN_aes_192_cfb1 = 'aes-192-cfb1';
  NID_aes_192_cfb1 = 651;
  SN_aes_256_cfb1 = 'AES-256-CFB1';
  LN_aes_256_cfb1 = 'aes-256-cfb1';
  NID_aes_256_cfb1 = 652;
  SN_aes_128_cfb8 = 'AES-128-CFB8';
  LN_aes_128_cfb8 = 'aes-128-cfb8';
  NID_aes_128_cfb8 = 653;
  SN_aes_192_cfb8 = 'AES-192-CFB8';
  LN_aes_192_cfb8 = 'aes-192-cfb8';
  NID_aes_192_cfb8 = 654;
  SN_aes_256_cfb8 = 'AES-256-CFB8';
  LN_aes_256_cfb8 = 'aes-256-cfb8';
  NID_aes_256_cfb8 = 655;
  SN_aes_128_ctr = 'AES-128-CTR';
  LN_aes_128_ctr = 'aes-128-ctr';
  NID_aes_128_ctr = 904;
  SN_aes_192_ctr = 'AES-192-CTR';
  LN_aes_192_ctr = 'aes-192-ctr';
  NID_aes_192_ctr = 905;
  SN_aes_256_ctr = 'AES-256-CTR';
  LN_aes_256_ctr = 'aes-256-ctr';
  NID_aes_256_ctr = 906;
  SN_aes_128_ocb = 'AES-128-OCB';
  LN_aes_128_ocb = 'aes-128-ocb';
  NID_aes_128_ocb = 958;
  SN_aes_192_ocb = 'AES-192-OCB';
  LN_aes_192_ocb = 'aes-192-ocb';
  NID_aes_192_ocb = 959;
  SN_aes_256_ocb = 'AES-256-OCB';
  LN_aes_256_ocb = 'aes-256-ocb';
  NID_aes_256_ocb = 960;
  SN_des_cfb1 = 'DES-CFB1';
  LN_des_cfb1 = 'des-cfb1';
  NID_des_cfb1 = 656;
  SN_des_cfb8 = 'DES-CFB8';
  LN_des_cfb8 = 'des-cfb8';
  NID_des_cfb8 = 657;
  SN_des_ede3_cfb1 = 'DES-EDE3-CFB1';
  LN_des_ede3_cfb1 = 'des-ede3-cfb1';
  NID_des_ede3_cfb1 = 658;
  SN_des_ede3_cfb8 = 'DES-EDE3-CFB8';
  LN_des_ede3_cfb8 = 'des-ede3-cfb8';
  NID_des_ede3_cfb8 = 659;
  SN_sha256 = 'SHA256';
  LN_sha256 = 'sha256';
  SN_sha384 = 'SHA384';
  LN_sha384 = 'sha384';
  SN_sha512 = 'SHA512';
  LN_sha512 = 'sha512';
  SN_sha224 = 'SHA224';
  LN_sha224 = 'sha224';
  SN_sha512_224 = 'SHA512-224';
  LN_sha512_224 = 'sha512-224';
  NID_sha512_224 = 1094;
  SN_sha512_256 = 'SHA512-256';
  LN_sha512_256 = 'sha512-256';
  NID_sha512_256 = 1095;
  SN_sha3_224 = 'SHA3-224';
  LN_sha3_224 = 'sha3-224';
  NID_sha3_224 = 1096;
  SN_sha3_256 = 'SHA3-256';
  LN_sha3_256 = 'sha3-256';
  NID_sha3_256 = 1097;
  SN_sha3_384 = 'SHA3-384';
  LN_sha3_384 = 'sha3-384';
  NID_sha3_384 = 1098;
  SN_sha3_512 = 'SHA3-512';
  LN_sha3_512 = 'sha3-512';
  NID_sha3_512 = 1099;
  SN_shake128 = 'SHAKE128';
  LN_shake128 = 'shake128';
  NID_shake128 = 1100;
  SN_shake256 = 'SHAKE256';
  LN_shake256 = 'shake256';
  NID_shake256 = 1101;
  SN_hmac_sha3_224 = 'id-hmacWithSHA3-224';
  LN_hmac_sha3_224 = 'hmac-sha3-224';
  NID_hmac_sha3_224 = 1102;
  SN_hmac_sha3_256 = 'id-hmacWithSHA3-256';
  LN_hmac_sha3_256 = 'hmac-sha3-256';
  NID_hmac_sha3_256 = 1103;
  SN_hmac_sha3_384 = 'id-hmacWithSHA3-384';
  LN_hmac_sha3_384 = 'hmac-sha3-384';
  NID_hmac_sha3_384 = 1104;
  SN_hmac_sha3_512 = 'id-hmacWithSHA3-512';
  LN_hmac_sha3_512 = 'hmac-sha3-512';
  NID_hmac_sha3_512 = 1105;
  SN_dsa_with_SHA224 = 'dsa_with_SHA224';
  NID_dsa_with_SHA224 = 802;
  SN_dsa_with_SHA256 = 'dsa_with_SHA256';
  NID_dsa_with_SHA256 = 803;
  SN_dsa_with_SHA384 = 'id-dsa-with-sha384';
  LN_dsa_with_SHA384 = 'dsa_with_SHA384';
  NID_dsa_with_SHA384 = 1106;
  SN_dsa_with_SHA512 = 'id-dsa-with-sha512';
  LN_dsa_with_SHA512 = 'dsa_with_SHA512';
  NID_dsa_with_SHA512 = 1107;
  SN_dsa_with_SHA3_224 = 'id-dsa-with-sha3-224';
  LN_dsa_with_SHA3_224 = 'dsa_with_SHA3-224';
  NID_dsa_with_SHA3_224 = 1108;
  SN_dsa_with_SHA3_256 = 'id-dsa-with-sha3-256';
  LN_dsa_with_SHA3_256 = 'dsa_with_SHA3-256';
  NID_dsa_with_SHA3_256 = 1109;
  SN_dsa_with_SHA3_384 = 'id-dsa-with-sha3-384';
  LN_dsa_with_SHA3_384 = 'dsa_with_SHA3-384';
  NID_dsa_with_SHA3_384 = 1110;
  SN_dsa_with_SHA3_512 = 'id-dsa-with-sha3-512';
  LN_dsa_with_SHA3_512 = 'dsa_with_SHA3-512';
  NID_dsa_with_SHA3_512 = 1111;
  SN_ecdsa_with_SHA3_224 = 'id-ecdsa-with-sha3-224';
  LN_ecdsa_with_SHA3_224 = 'ecdsa_with_SHA3-224';
  NID_ecdsa_with_SHA3_224 = 1112;
  SN_ecdsa_with_SHA3_256 = 'id-ecdsa-with-sha3-256';
  LN_ecdsa_with_SHA3_256 = 'ecdsa_with_SHA3-256';
  NID_ecdsa_with_SHA3_256 = 1113;
  SN_ecdsa_with_SHA3_384 = 'id-ecdsa-with-sha3-384';
  LN_ecdsa_with_SHA3_384 = 'ecdsa_with_SHA3-384';
  NID_ecdsa_with_SHA3_384 = 1114;
  SN_ecdsa_with_SHA3_512 = 'id-ecdsa-with-sha3-512';
  LN_ecdsa_with_SHA3_512 = 'ecdsa_with_SHA3-512';
  NID_ecdsa_with_SHA3_512 = 1115;
  SN_RSA_SHA3_224 = 'id-rsassa-pkcs1-v1_5-with-sha3-224';
  LN_RSA_SHA3_224 = 'RSA-SHA3-224';
  NID_RSA_SHA3_224 = 1116;
  SN_RSA_SHA3_256 = 'id-rsassa-pkcs1-v1_5-with-sha3-256';
  LN_RSA_SHA3_256 = 'RSA-SHA3-256';
  NID_RSA_SHA3_256 = 1117;
  SN_RSA_SHA3_384 = 'id-rsassa-pkcs1-v1_5-with-sha3-384';
  LN_RSA_SHA3_384 = 'RSA-SHA3-384';
  NID_RSA_SHA3_384 = 1118;
  SN_RSA_SHA3_512 = 'id-rsassa-pkcs1-v1_5-with-sha3-512';
  LN_RSA_SHA3_512 = 'RSA-SHA3-512';
  NID_RSA_SHA3_512 = 1119;
  SN_hold_instruction_code = 'holdInstructionCode';
  LN_hold_instruction_code = 'Hold Instruction Code';
  NID_hold_instruction_code = 430;
  SN_hold_instruction_none = 'holdInstructionNone';
  LN_hold_instruction_none = 'Hold Instruction None';
  NID_hold_instruction_none = 431;
  SN_hold_instruction_call_issuer = 'holdInstructionCallIssuer';
  LN_hold_instruction_call_issuer = 'Hold Instruction Call Issuer';
  NID_hold_instruction_call_issuer = 432;
  SN_hold_instruction_reject = 'holdInstructionReject';
  LN_hold_instruction_reject = 'Hold Instruction Reject';
  NID_hold_instruction_reject = 433;
  SN_data = 'data';
  NID_data = 434;
  SN_pss = 'pss';
  NID_pss = 435;
  SN_ucl = 'ucl';
  NID_ucl = 436;
  SN_pilot = 'pilot';
  NID_pilot = 437;
  LN_pilotAttributeType = 'pilotAttributeType';
  NID_pilotAttributeType = 438;
  LN_pilotAttributeSyntax = 'pilotAttributeSyntax';
  NID_pilotAttributeSyntax = 439;
  LN_pilotObjectClass = 'pilotObjectClass';
  NID_pilotObjectClass = 440;
  LN_pilotGroups = 'pilotGroups';
  NID_pilotGroups = 441;
  LN_iA5StringSyntax = 'iA5StringSyntax';
  NID_iA5StringSyntax = 442;
  LN_caseIgnoreIA5StringSyntax = 'caseIgnoreIA5StringSyntax';
  NID_caseIgnoreIA5StringSyntax = 443;
  LN_pilotObject = 'pilotObject';
  NID_pilotObject = 444;
  LN_pilotPerson = 'pilotPerson';
  NID_pilotPerson = 445;
  SN_account = 'account';
  NID_account = 446;
  SN_document = 'document';
  NID_document = 447;
  SN_room = 'room';
  NID_room = 448;
  LN_documentSeries = 'documentSeries';
  NID_documentSeries = 449;
  SN_Domain = 'domain';
  LN_Domain = 'Domain';
  NID_Domain = 392;
  LN_rFC822localPart = 'rFC822localPart';
  NID_rFC822localPart = 450;
  LN_dNSDomain = 'dNSDomain';
  NID_dNSDomain = 451;
  LN_domainRelatedObject = 'domainRelatedObject';
  NID_domainRelatedObject = 452;
  LN_friendlyCountry = 'friendlyCountry';
  NID_friendlyCountry = 453;
  LN_simpleSecurityObject = 'simpleSecurityObject';
  NID_simpleSecurityObject = 454;
  LN_pilotOrganization = 'pilotOrganization';
  NID_pilotOrganization = 455;
  LN_pilotDSA = 'pilotDSA';
  NID_pilotDSA = 456;
  LN_qualityLabelledData = 'qualityLabelledData';
  NID_qualityLabelledData = 457;
  SN_userId = 'UID';
  LN_userId = 'userId';
  NID_userId = 458;
  LN_textEncodedORAddress = 'textEncodedORAddress';
  NID_textEncodedORAddress = 459;
  SN_rfc822Mailbox = 'mail';
  LN_rfc822Mailbox = 'rfc822Mailbox';
  NID_rfc822Mailbox = 460;
  SN_info = 'info';
  NID_info = 461;
  LN_favouriteDrink = 'favouriteDrink';
  NID_favouriteDrink = 462;
  LN_roomNumber = 'roomNumber';
  NID_roomNumber = 463;
  SN_photo = 'photo';
  NID_photo = 464;
  LN_userClass = 'userClass';
  NID_userClass = 465;
  SN_host = 'host';
  NID_host = 466;
  SN_manager = 'manager';
  NID_manager = 467;
  LN_documentIdentifier = 'documentIdentifier';
  NID_documentIdentifier = 468;
  LN_documentTitle = 'documentTitle';
  NID_documentTitle = 469;
  LN_documentVersion = 'documentVersion';
  NID_documentVersion = 470;
  LN_documentAuthor = 'documentAuthor';
  NID_documentAuthor = 471;
  LN_documentLocation = 'documentLocation';
  NID_documentLocation = 472;
  LN_homeTelephoneNumber = 'homeTelephoneNumber';
  NID_homeTelephoneNumber = 473;
  SN_secretary = 'secretary';
  NID_secretary = 474;
  LN_otherMailbox = 'otherMailbox';
  NID_otherMailbox = 475;
  LN_lastModifiedTime = 'lastModifiedTime';
  NID_lastModifiedTime = 476;
  LN_lastModifiedBy = 'lastModifiedBy';
  NID_lastModifiedBy = 477;
  SN_domainComponent = 'DC';
  LN_domainComponent = 'domainComponent';
  NID_domainComponent = 391;
  LN_aRecord = 'aRecord';
  NID_aRecord = 478;
  LN_pilotAttributeType27 = 'pilotAttributeType27';
  NID_pilotAttributeType27 = 479;
  LN_mXRecord = 'mXRecord';
  NID_mXRecord = 480;
  LN_nSRecord = 'nSRecord';
  NID_nSRecord = 481;
  LN_sOARecord = 'sOARecord';
  NID_sOARecord = 482;
  LN_cNAMERecord = 'cNAMERecord';
  NID_cNAMERecord = 483;
  LN_associatedDomain = 'associatedDomain';
  NID_associatedDomain = 484;
  LN_associatedName = 'associatedName';
  NID_associatedName = 485;
  LN_homePostalAddress = 'homePostalAddress';
  NID_homePostalAddress = 486;
  LN_personalTitle = 'personalTitle';
  NID_personalTitle = 487;
  LN_mobileTelephoneNumber = 'mobileTelephoneNumber';
  NID_mobileTelephoneNumber = 488;
  LN_pagerTelephoneNumber = 'pagerTelephoneNumber';
  NID_pagerTelephoneNumber = 489;
  LN_friendlyCountryName = 'friendlyCountryName';
  NID_friendlyCountryName = 490;
  SN_uniqueIdentifier = 'uid';
  LN_uniqueIdentifier = 'uniqueIdentifier';
  NID_uniqueIdentifier = 102;
  LN_organizationalStatus = 'organizationalStatus';
  NID_organizationalStatus = 491;
  LN_janetMailbox = 'janetMailbox';
  NID_janetMailbox = 492;
  LN_mailPreferenceOption = 'mailPreferenceOption';
  NID_mailPreferenceOption = 493;
  LN_buildingName = 'buildingName';
  NID_buildingName = 494;
  LN_dSAQuality = 'dSAQuality';
  NID_dSAQuality = 495;
  LN_singleLevelQuality = 'singleLevelQuality';
  NID_singleLevelQuality = 496;
  LN_subtreeMinimumQuality = 'subtreeMinimumQuality';
  NID_subtreeMinimumQuality = 497;
  LN_subtreeMaximumQuality = 'subtreeMaximumQuality';
  NID_subtreeMaximumQuality = 498;
  LN_personalSignature = 'personalSignature';
  NID_personalSignature = 499;
  LN_dITRedirect = 'dITRedirect';
  NID_dITRedirect = 500;
  SN_audio = 'audio';
  NID_audio = 501;
  LN_documentPublisher = 'documentPublisher';
  NID_documentPublisher = 502;
  SN_id_set = 'id-set';
  LN_id_set = 'Secure Electronic Transactions';
  NID_id_set = 512;
  SN_set_ctype = 'set-ctype';
  LN_set_ctype = 'content types';
  NID_set_ctype = 513;
  SN_set_msgExt = 'set-msgExt';
  LN_set_msgExt = 'message extensions';
  NID_set_msgExt = 514;
  SN_set_attr = 'set-attr';
  NID_set_attr = 515;
  SN_set_policy = 'set-policy';
  NID_set_policy = 516;
  SN_set_certExt = 'set-certExt';
  LN_set_certExt = 'certificate extensions';
  NID_set_certExt = 517;
  SN_set_brand = 'set-brand';
  NID_set_brand = 518;
  SN_setct_PANData = 'setct-PANData';
  NID_setct_PANData = 519;
  SN_setct_PANToken = 'setct-PANToken';
  NID_setct_PANToken = 520;
  SN_setct_PANOnly = 'setct-PANOnly';
  NID_setct_PANOnly = 521;
  SN_setct_OIData = 'setct-OIData';
  NID_setct_OIData = 522;
  SN_setct_PI = 'setct-PI';
  NID_setct_PI = 523;
  SN_setct_PIData = 'setct-PIData';
  NID_setct_PIData = 524;
  SN_setct_PIDataUnsigned = 'setct-PIDataUnsigned';
  NID_setct_PIDataUnsigned = 525;
  SN_setct_HODInput = 'setct-HODInput';
  NID_setct_HODInput = 526;
  SN_setct_AuthResBaggage = 'setct-AuthResBaggage';
  NID_setct_AuthResBaggage = 527;
  SN_setct_AuthRevReqBaggage = 'setct-AuthRevReqBaggage';
  NID_setct_AuthRevReqBaggage = 528;
  SN_setct_AuthRevResBaggage = 'setct-AuthRevResBaggage';
  NID_setct_AuthRevResBaggage = 529;
  SN_setct_CapTokenSeq = 'setct-CapTokenSeq';
  NID_setct_CapTokenSeq = 530;
  SN_setct_PInitResData = 'setct-PInitResData';
  NID_setct_PInitResData = 531;
  SN_setct_PI_TBS = 'setct-PI-TBS';
  NID_setct_PI_TBS = 532;
  SN_setct_PResData = 'setct-PResData';
  NID_setct_PResData = 533;
  SN_setct_AuthReqTBS = 'setct-AuthReqTBS';
  NID_setct_AuthReqTBS = 534;
  SN_setct_AuthResTBS = 'setct-AuthResTBS';
  NID_setct_AuthResTBS = 535;
  SN_setct_AuthResTBSX = 'setct-AuthResTBSX';
  NID_setct_AuthResTBSX = 536;
  SN_setct_AuthTokenTBS = 'setct-AuthTokenTBS';
  NID_setct_AuthTokenTBS = 537;
  SN_setct_CapTokenData = 'setct-CapTokenData';
  NID_setct_CapTokenData = 538;
  SN_setct_CapTokenTBS = 'setct-CapTokenTBS';
  NID_setct_CapTokenTBS = 539;
  SN_setct_AcqCardCodeMsg = 'setct-AcqCardCodeMsg';
  NID_setct_AcqCardCodeMsg = 540;
  SN_setct_AuthRevReqTBS = 'setct-AuthRevReqTBS';
  NID_setct_AuthRevReqTBS = 541;
  SN_setct_AuthRevResData = 'setct-AuthRevResData';
  NID_setct_AuthRevResData = 542;
  SN_setct_AuthRevResTBS = 'setct-AuthRevResTBS';
  NID_setct_AuthRevResTBS = 543;
  SN_setct_CapReqTBS = 'setct-CapReqTBS';
  NID_setct_CapReqTBS = 544;
  SN_setct_CapReqTBSX = 'setct-CapReqTBSX';
  NID_setct_CapReqTBSX = 545;
  SN_setct_CapResData = 'setct-CapResData';
  NID_setct_CapResData = 546;
  SN_setct_CapRevReqTBS = 'setct-CapRevReqTBS';
  NID_setct_CapRevReqTBS = 547;
  SN_setct_CapRevReqTBSX = 'setct-CapRevReqTBSX';
  NID_setct_CapRevReqTBSX = 548;
  SN_setct_CapRevResData = 'setct-CapRevResData';
  NID_setct_CapRevResData = 549;
  SN_setct_CredReqTBS = 'setct-CredReqTBS';
  NID_setct_CredReqTBS = 550;
  SN_setct_CredReqTBSX = 'setct-CredReqTBSX';
  NID_setct_CredReqTBSX = 551;
  SN_setct_CredResData = 'setct-CredResData';
  NID_setct_CredResData = 552;
  SN_setct_CredRevReqTBS = 'setct-CredRevReqTBS';
  NID_setct_CredRevReqTBS = 553;
  SN_setct_CredRevReqTBSX = 'setct-CredRevReqTBSX';
  NID_setct_CredRevReqTBSX = 554;
  SN_setct_CredRevResData = 'setct-CredRevResData';
  NID_setct_CredRevResData = 555;
  SN_setct_PCertReqData = 'setct-PCertReqData';
  NID_setct_PCertReqData = 556;
  SN_setct_PCertResTBS = 'setct-PCertResTBS';
  NID_setct_PCertResTBS = 557;
  SN_setct_BatchAdminReqData = 'setct-BatchAdminReqData';
  NID_setct_BatchAdminReqData = 558;
  SN_setct_BatchAdminResData = 'setct-BatchAdminResData';
  NID_setct_BatchAdminResData = 559;
  SN_setct_CardCInitResTBS = 'setct-CardCInitResTBS';
  NID_setct_CardCInitResTBS = 560;
  SN_setct_MeAqCInitResTBS = 'setct-MeAqCInitResTBS';
  NID_setct_MeAqCInitResTBS = 561;
  SN_setct_RegFormResTBS = 'setct-RegFormResTBS';
  NID_setct_RegFormResTBS = 562;
  SN_setct_CertReqData = 'setct-CertReqData';
  NID_setct_CertReqData = 563;
  SN_setct_CertReqTBS = 'setct-CertReqTBS';
  NID_setct_CertReqTBS = 564;
  SN_setct_CertResData = 'setct-CertResData';
  NID_setct_CertResData = 565;
  SN_setct_CertInqReqTBS = 'setct-CertInqReqTBS';
  NID_setct_CertInqReqTBS = 566;
  SN_setct_ErrorTBS = 'setct-ErrorTBS';
  NID_setct_ErrorTBS = 567;
  SN_setct_PIDualSignedTBE = 'setct-PIDualSignedTBE';
  NID_setct_PIDualSignedTBE = 568;
  SN_setct_PIUnsignedTBE = 'setct-PIUnsignedTBE';
  NID_setct_PIUnsignedTBE = 569;
  SN_setct_AuthReqTBE = 'setct-AuthReqTBE';
  NID_setct_AuthReqTBE = 570;
  SN_setct_AuthResTBE = 'setct-AuthResTBE';
  NID_setct_AuthResTBE = 571;
  SN_setct_AuthResTBEX = 'setct-AuthResTBEX';
  NID_setct_AuthResTBEX = 572;
  SN_setct_AuthTokenTBE = 'setct-AuthTokenTBE';
  NID_setct_AuthTokenTBE = 573;
  SN_setct_CapTokenTBE = 'setct-CapTokenTBE';
  NID_setct_CapTokenTBE = 574;
  SN_setct_CapTokenTBEX = 'setct-CapTokenTBEX';
  NID_setct_CapTokenTBEX = 575;
  SN_setct_AcqCardCodeMsgTBE = 'setct-AcqCardCodeMsgTBE';
  NID_setct_AcqCardCodeMsgTBE = 576;
  SN_setct_AuthRevReqTBE = 'setct-AuthRevReqTBE';
  NID_setct_AuthRevReqTBE = 577;
  SN_setct_AuthRevResTBE = 'setct-AuthRevResTBE';
  NID_setct_AuthRevResTBE = 578;
  SN_setct_AuthRevResTBEB = 'setct-AuthRevResTBEB';
  NID_setct_AuthRevResTBEB = 579;
  SN_setct_CapReqTBE = 'setct-CapReqTBE';
  NID_setct_CapReqTBE = 580;
  SN_setct_CapReqTBEX = 'setct-CapReqTBEX';
  NID_setct_CapReqTBEX = 581;
  SN_setct_CapResTBE = 'setct-CapResTBE';
  NID_setct_CapResTBE = 582;
  SN_setct_CapRevReqTBE = 'setct-CapRevReqTBE';
  NID_setct_CapRevReqTBE = 583;
  SN_setct_CapRevReqTBEX = 'setct-CapRevReqTBEX';
  NID_setct_CapRevReqTBEX = 584;
  SN_setct_CapRevResTBE = 'setct-CapRevResTBE';
  NID_setct_CapRevResTBE = 585;
  SN_setct_CredReqTBE = 'setct-CredReqTBE';
  NID_setct_CredReqTBE = 586;
  SN_setct_CredReqTBEX = 'setct-CredReqTBEX';
  NID_setct_CredReqTBEX = 587;
  SN_setct_CredResTBE = 'setct-CredResTBE';
  NID_setct_CredResTBE = 588;
  SN_setct_CredRevReqTBE = 'setct-CredRevReqTBE';
  NID_setct_CredRevReqTBE = 589;
  SN_setct_CredRevReqTBEX = 'setct-CredRevReqTBEX';
  NID_setct_CredRevReqTBEX = 590;
  SN_setct_CredRevResTBE = 'setct-CredRevResTBE';
  NID_setct_CredRevResTBE = 591;
  SN_setct_BatchAdminReqTBE = 'setct-BatchAdminReqTBE';
  NID_setct_BatchAdminReqTBE = 592;
  SN_setct_BatchAdminResTBE = 'setct-BatchAdminResTBE';
  NID_setct_BatchAdminResTBE = 593;
  SN_setct_RegFormReqTBE = 'setct-RegFormReqTBE';
  NID_setct_RegFormReqTBE = 594;
  SN_setct_CertReqTBE = 'setct-CertReqTBE';
  NID_setct_CertReqTBE = 595;
  SN_setct_CertReqTBEX = 'setct-CertReqTBEX';
  NID_setct_CertReqTBEX = 596;
  SN_setct_CertResTBE = 'setct-CertResTBE';
  NID_setct_CertResTBE = 597;
  SN_setct_CRLNotificationTBS = 'setct-CRLNotificationTBS';
  NID_setct_CRLNotificationTBS = 598;
  SN_setct_CRLNotificationResTBS = 'setct-CRLNotificationResTBS';
  NID_setct_CRLNotificationResTBS = 599;
  SN_setct_BCIDistributionTBS = 'setct-BCIDistributionTBS';
  NID_setct_BCIDistributionTBS = 600;
  SN_setext_genCrypt = 'setext-genCrypt';
  LN_setext_genCrypt = 'generic cryptogram';
  NID_setext_genCrypt = 601;
  SN_setext_miAuth = 'setext-miAuth';
  LN_setext_miAuth = 'merchant initiated auth';
  NID_setext_miAuth = 602;
  SN_setext_pinSecure = 'setext-pinSecure';
  NID_setext_pinSecure = 603;
  SN_setext_pinAny = 'setext-pinAny';
  NID_setext_pinAny = 604;
  SN_setext_track2 = 'setext-track2';
  NID_setext_track2 = 605;
  SN_setext_cv = 'setext-cv';
  LN_setext_cv = 'additional verification';
  NID_setext_cv = 606;
  SN_set_policy_root = 'set-policy-root';
  NID_set_policy_root = 607;
  SN_setCext_hashedRoot = 'setCext-hashedRoot';
  NID_setCext_hashedRoot = 608;
  SN_setCext_certType = 'setCext-certType';
  NID_setCext_certType = 609;
  SN_setCext_merchData = 'setCext-merchData';
  NID_setCext_merchData = 610;
  SN_setCext_cCertRequired = 'setCext-cCertRequired';
  NID_setCext_cCertRequired = 611;
  SN_setCext_tunneling = 'setCext-tunneling';
  NID_setCext_tunneling = 612;
  SN_setCext_setExt = 'setCext-setExt';
  NID_setCext_setExt = 613;
  SN_setCext_setQualf = 'setCext-setQualf';
  NID_setCext_setQualf = 614;
  SN_setCext_PGWYcapabilities = 'setCext-PGWYcapabilities';
  NID_setCext_PGWYcapabilities = 615;
  SN_setCext_TokenIdentifier = 'setCext-TokenIdentifier';
  NID_setCext_TokenIdentifier = 616;
  SN_setCext_Track2Data = 'setCext-Track2Data';
  NID_setCext_Track2Data = 617;
  SN_setCext_TokenType = 'setCext-TokenType';
  NID_setCext_TokenType = 618;
  SN_setCext_IssuerCapabilities = 'setCext-IssuerCapabilities';
  NID_setCext_IssuerCapabilities = 619;
  SN_setAttr_Cert = 'setAttr-Cert';
  NID_setAttr_Cert = 620;
  SN_setAttr_PGWYcap = 'setAttr-PGWYcap';
  LN_setAttr_PGWYcap = 'payment gateway capabilities';
  NID_setAttr_PGWYcap = 621;
  SN_setAttr_TokenType = 'setAttr-TokenType';
  NID_setAttr_TokenType = 622;
  SN_setAttr_IssCap = 'setAttr-IssCap';
  LN_setAttr_IssCap = 'issuer capabilities';
  NID_setAttr_IssCap = 623;
  SN_set_rootKeyThumb = 'set-rootKeyThumb';
  NID_set_rootKeyThumb = 624;
  SN_set_addPolicy = 'set-addPolicy';
  NID_set_addPolicy = 625;
  SN_setAttr_Token_EMV = 'setAttr-Token-EMV';
  NID_setAttr_Token_EMV = 626;
  SN_setAttr_Token_B0Prime = 'setAttr-Token-B0Prime';
  NID_setAttr_Token_B0Prime = 627;
  SN_setAttr_IssCap_CVM = 'setAttr-IssCap-CVM';
  NID_setAttr_IssCap_CVM = 628;
  SN_setAttr_IssCap_T2 = 'setAttr-IssCap-T2';
  NID_setAttr_IssCap_T2 = 629;
  SN_setAttr_IssCap_Sig = 'setAttr-IssCap-Sig';
  NID_setAttr_IssCap_Sig = 630;
  SN_setAttr_GenCryptgrm = 'setAttr-GenCryptgrm';
  LN_setAttr_GenCryptgrm = 'generate cryptogram';
  NID_setAttr_GenCryptgrm = 631;
  SN_setAttr_T2Enc = 'setAttr-T2Enc';
  LN_setAttr_T2Enc = 'encrypted track 2';
  NID_setAttr_T2Enc = 632;
  SN_setAttr_T2cleartxt = 'setAttr-T2cleartxt';
  LN_setAttr_T2cleartxt = 'cleartext track 2';
  NID_setAttr_T2cleartxt = 633;
  SN_setAttr_TokICCsig = 'setAttr-TokICCsig';
  LN_setAttr_TokICCsig = 'ICC or token signature';
  NID_setAttr_TokICCsig = 634;
  SN_setAttr_SecDevSig = 'setAttr-SecDevSig';
  LN_setAttr_SecDevSig = 'secure device signature';
  NID_setAttr_SecDevSig = 635;
  SN_set_brand_IATA_ATA = 'set-brand-IATA-ATA';
  NID_set_brand_IATA_ATA = 636;
  SN_set_brand_Diners = 'set-brand-Diners';
  NID_set_brand_Diners = 637;
  SN_set_brand_AmericanExpress = 'set-brand-AmericanExpress';
  NID_set_brand_AmericanExpress = 638;
  SN_set_brand_JCB = 'set-brand-JCB';
  NID_set_brand_JCB = 639;
  SN_set_brand_Visa = 'set-brand-Visa';
  NID_set_brand_Visa = 640;
  SN_set_brand_MasterCard = 'set-brand-MasterCard';
  NID_set_brand_MasterCard = 641;
  SN_set_brand_Novus = 'set-brand-Novus';
  NID_set_brand_Novus = 642;
  SN_des_cdmf = 'DES-CDMF';
  LN_des_cdmf = 'des-cdmf';
  NID_des_cdmf = 643;
  SN_rsaOAEPEncryptionSET = 'rsaOAEPEncryptionSET';
  NID_rsaOAEPEncryptionSET = 644;
  SN_ipsec3 = 'Oakley-EC2N-3';
  LN_ipsec3 = 'ipsec3';
  NID_ipsec3 = 749;
  SN_ipsec4 = 'Oakley-EC2N-4';
  LN_ipsec4 = 'ipsec4';
  NID_ipsec4 = 750;
  SN_whirlpool = 'whirlpool';
  NID_whirlpool = 804;
  SN_cryptopro = 'cryptopro';
  NID_cryptopro = 805;
  SN_cryptocom = 'cryptocom';
  NID_cryptocom = 806;
  SN_id_tc26 = 'id-tc26';
  NID_id_tc26 = 974;
  SN_id_GostR3411_94_with_GostR3410_2001 = 'id-GostR3411-94-with-GostR3410-2001';
  LN_id_GostR3411_94_with_GostR3410_2001 = 'GOST R 34.11-94 with GOST R 34.10-2001';
  NID_id_GostR3411_94_with_GostR3410_2001 = 807;
  SN_id_GostR3411_94_with_GostR3410_94 = 'id-GostR3411-94-with-GostR3410-94';
  LN_id_GostR3411_94_with_GostR3410_94 = 'GOST R 34.11-94 with GOST R 34.10-94';
  NID_id_GostR3411_94_with_GostR3410_94 = 808;
  SN_id_GostR3411_94 = 'md_gost94';
  LN_id_GostR3411_94 = 'GOST R 34.11-94';
  NID_id_GostR3411_94 = 809;
  SN_id_HMACGostR3411_94 = 'id-HMACGostR3411-94';
  LN_id_HMACGostR3411_94 = 'HMAC GOST 34.11-94';
  NID_id_HMACGostR3411_94 = 810;
  SN_id_GostR3410_2001 = 'gost2001';
  LN_id_GostR3410_2001 = 'GOST R 34.10-2001';
  NID_id_GostR3410_2001 = 811;
  SN_id_GostR3410_94 = 'gost94';
  LN_id_GostR3410_94 = 'GOST R 34.10-94';
  NID_id_GostR3410_94 = 812;
  SN_id_Gost28147_89 = 'gost89';
  LN_id_Gost28147_89 = 'GOST 28147-89';
  NID_id_Gost28147_89 = 813;
  SN_gost89_cnt = 'gost89-cnt';
  NID_gost89_cnt = 814;
  SN_gost89_cnt_12 = 'gost89-cnt-12';
  NID_gost89_cnt_12 = 975;
  SN_gost89_cbc = 'gost89-cbc';
  NID_gost89_cbc = 1009;
  SN_gost89_ecb = 'gost89-ecb';
  NID_gost89_ecb = 1010;
  SN_gost89_ctr = 'gost89-ctr';
  NID_gost89_ctr = 1011;
  SN_id_Gost28147_89_MAC = 'gost-mac';
  LN_id_Gost28147_89_MAC = 'GOST 28147-89 MAC';
  NID_id_Gost28147_89_MAC = 815;
  SN_gost_mac_12 = 'gost-mac-12';
  NID_gost_mac_12 = 976;
  SN_id_GostR3411_94_prf = 'prf-gostr3411-94';
  LN_id_GostR3411_94_prf = 'GOST R 34.11-94 PRF';
  NID_id_GostR3411_94_prf = 816;
  SN_id_GostR3410_2001DH = 'id-GostR3410-2001DH';
  LN_id_GostR3410_2001DH = 'GOST R 34.10-2001 DH';
  NID_id_GostR3410_2001DH = 817;
  SN_id_GostR3410_94DH = 'id-GostR3410-94DH';
  LN_id_GostR3410_94DH = 'GOST R 34.10-94 DH';
  NID_id_GostR3410_94DH = 818;
  SN_id_Gost28147_89_CryptoPro_KeyMeshing = 'id-Gost28147-89-CryptoPro-KeyMeshing';
  NID_id_Gost28147_89_CryptoPro_KeyMeshing = 819;
  SN_id_Gost28147_89_None_KeyMeshing = 'id-Gost28147-89-None-KeyMeshing';
  NID_id_Gost28147_89_None_KeyMeshing = 820;
  SN_id_GostR3411_94_TestParamSet = 'id-GostR3411-94-TestParamSet';
  NID_id_GostR3411_94_TestParamSet = 821;
  SN_id_GostR3411_94_CryptoProParamSet = 'id-GostR3411-94-CryptoProParamSet';
  NID_id_GostR3411_94_CryptoProParamSet = 822;
  SN_id_Gost28147_89_TestParamSet = 'id-Gost28147-89-TestParamSet';
  NID_id_Gost28147_89_TestParamSet = 823;
  SN_id_Gost28147_89_CryptoPro_A_ParamSet = 'id-Gost28147-89-CryptoPro-A-ParamSet';
  NID_id_Gost28147_89_CryptoPro_A_ParamSet = 824;
  SN_id_Gost28147_89_CryptoPro_B_ParamSet = 'id-Gost28147-89-CryptoPro-B-ParamSet';
  NID_id_Gost28147_89_CryptoPro_B_ParamSet = 825;
  SN_id_Gost28147_89_CryptoPro_C_ParamSet = 'id-Gost28147-89-CryptoPro-C-ParamSet';
  NID_id_Gost28147_89_CryptoPro_C_ParamSet = 826;
  SN_id_Gost28147_89_CryptoPro_D_ParamSet = 'id-Gost28147-89-CryptoPro-D-ParamSet';
  NID_id_Gost28147_89_CryptoPro_D_ParamSet = 827;
  SN_id_Gost28147_89_CryptoPro_Oscar_1_1_ParamSet = 'id-Gost28147-89-CryptoPro-Oscar-1-1-ParamSet';
  NID_id_Gost28147_89_CryptoPro_Oscar_1_1_ParamSet = 828;
  SN_id_Gost28147_89_CryptoPro_Oscar_1_0_ParamSet = 'id-Gost28147-89-CryptoPro-Oscar-1-0-ParamSet';
  NID_id_Gost28147_89_CryptoPro_Oscar_1_0_ParamSet = 829;
  SN_id_Gost28147_89_CryptoPro_RIC_1_ParamSet = 'id-Gost28147-89-CryptoPro-RIC-1-ParamSet';
  NID_id_Gost28147_89_CryptoPro_RIC_1_ParamSet = 830;
  SN_id_GostR3410_94_TestParamSet = 'id-GostR3410-94-TestParamSet';
  NID_id_GostR3410_94_TestParamSet = 831;
  SN_id_GostR3410_94_CryptoPro_A_ParamSet = 'id-GostR3410-94-CryptoPro-A-ParamSet';
  NID_id_GostR3410_94_CryptoPro_A_ParamSet = 832;
  SN_id_GostR3410_94_CryptoPro_B_ParamSet = 'id-GostR3410-94-CryptoPro-B-ParamSet';
  NID_id_GostR3410_94_CryptoPro_B_ParamSet = 833;
  SN_id_GostR3410_94_CryptoPro_C_ParamSet = 'id-GostR3410-94-CryptoPro-C-ParamSet';
  NID_id_GostR3410_94_CryptoPro_C_ParamSet = 834;
  SN_id_GostR3410_94_CryptoPro_D_ParamSet = 'id-GostR3410-94-CryptoPro-D-ParamSet';
  NID_id_GostR3410_94_CryptoPro_D_ParamSet = 835;
  SN_id_GostR3410_94_CryptoPro_XchA_ParamSet = 'id-GostR3410-94-CryptoPro-XchA-ParamSet';
  NID_id_GostR3410_94_CryptoPro_XchA_ParamSet = 836;
  SN_id_GostR3410_94_CryptoPro_XchB_ParamSet = 'id-GostR3410-94-CryptoPro-XchB-ParamSet';
  NID_id_GostR3410_94_CryptoPro_XchB_ParamSet = 837;
  SN_id_GostR3410_94_CryptoPro_XchC_ParamSet = 'id-GostR3410-94-CryptoPro-XchC-ParamSet';
  NID_id_GostR3410_94_CryptoPro_XchC_ParamSet = 838;
  SN_id_GostR3410_2001_TestParamSet = 'id-GostR3410-2001-TestParamSet';
  NID_id_GostR3410_2001_TestParamSet = 839;
  SN_id_GostR3410_2001_CryptoPro_A_ParamSet = 'id-GostR3410-2001-CryptoPro-A-ParamSet';
  NID_id_GostR3410_2001_CryptoPro_A_ParamSet = 840;
  SN_id_GostR3410_2001_CryptoPro_B_ParamSet = 'id-GostR3410-2001-CryptoPro-B-ParamSet';
  NID_id_GostR3410_2001_CryptoPro_B_ParamSet = 841;
  SN_id_GostR3410_2001_CryptoPro_C_ParamSet = 'id-GostR3410-2001-CryptoPro-C-ParamSet';
  NID_id_GostR3410_2001_CryptoPro_C_ParamSet = 842;
  SN_id_GostR3410_2001_CryptoPro_XchA_ParamSet = 'id-GostR3410-2001-CryptoPro-XchA-ParamSet';
  NID_id_GostR3410_2001_CryptoPro_XchA_ParamSet = 843;
  SN_id_GostR3410_2001_CryptoPro_XchB_ParamSet = 'id-GostR3410-2001-CryptoPro-XchB-ParamSet';
  NID_id_GostR3410_2001_CryptoPro_XchB_ParamSet = 844;
  SN_id_GostR3410_94_a = 'id-GostR3410-94-a';
  NID_id_GostR3410_94_a = 845;
  SN_id_GostR3410_94_aBis = 'id-GostR3410-94-aBis';
  NID_id_GostR3410_94_aBis = 846;
  SN_id_GostR3410_94_b = 'id-GostR3410-94-b';
  NID_id_GostR3410_94_b = 847;
  SN_id_GostR3410_94_bBis = 'id-GostR3410-94-bBis';
  NID_id_GostR3410_94_bBis = 848;
  SN_id_Gost28147_89_cc = 'id-Gost28147-89-cc';
  LN_id_Gost28147_89_cc = 'GOST 28147-89 Cryptocom ParamSet';
  NID_id_Gost28147_89_cc = 849;
  SN_id_GostR3410_94_cc = 'gost94cc';
  LN_id_GostR3410_94_cc = 'GOST 34.10-94 Cryptocom';
  NID_id_GostR3410_94_cc = 850;
  SN_id_GostR3410_2001_cc = 'gost2001cc';
  LN_id_GostR3410_2001_cc = 'GOST 34.10-2001 Cryptocom';
  NID_id_GostR3410_2001_cc = 851;
  SN_id_GostR3411_94_with_GostR3410_94_cc = 'id-GostR3411-94-with-GostR3410-94-cc';
  LN_id_GostR3411_94_with_GostR3410_94_cc = 'GOST R 34.11-94 with GOST R 34.10-94 Cryptocom';
  NID_id_GostR3411_94_with_GostR3410_94_cc = 852;
  SN_id_GostR3411_94_with_GostR3410_2001_cc = 'id-GostR3411-94-with-GostR3410-2001-cc';
  LN_id_GostR3411_94_with_GostR3410_2001_cc = 'GOST R 34.11-94 with GOST R 34.10-2001 Cryptocom';
  NID_id_GostR3411_94_with_GostR3410_2001_cc = 853;
  SN_id_GostR3410_2001_ParamSet_cc = 'id-GostR3410-2001-ParamSet-cc';
  LN_id_GostR3410_2001_ParamSet_cc = 'GOST R 3410-2001 Parameter Set Cryptocom';
  NID_id_GostR3410_2001_ParamSet_cc = 854;
  SN_id_tc26_algorithms = 'id-tc26-algorithms';
  NID_id_tc26_algorithms = 977;
  SN_id_tc26_sign = 'id-tc26-sign';
  NID_id_tc26_sign = 978;
  SN_id_GostR3410_2012_256 = 'gost2012_256';
  LN_id_GostR3410_2012_256 = 'GOST R 34.10-2012 with 256 bit modulus';
  NID_id_GostR3410_2012_256 = 979;
  SN_id_GostR3410_2012_512 = 'gost2012_512';
  LN_id_GostR3410_2012_512 = 'GOST R 34.10-2012 with 512 bit modulus';
  NID_id_GostR3410_2012_512 = 980;
  SN_id_tc26_digest = 'id-tc26-digest';
  NID_id_tc26_digest = 981;
  SN_id_GostR3411_2012_256 = 'md_gost12_256';
  LN_id_GostR3411_2012_256 = 'GOST R 34.11-2012 with 256 bit hash';
  NID_id_GostR3411_2012_256 = 982;
  SN_id_GostR3411_2012_512 = 'md_gost12_512';
  LN_id_GostR3411_2012_512 = 'GOST R 34.11-2012 with 512 bit hash';
  NID_id_GostR3411_2012_512 = 983;
  SN_id_tc26_signwithdigest = 'id-tc26-signwithdigest';
  NID_id_tc26_signwithdigest = 984;
  SN_id_tc26_signwithdigest_gost3410_2012_256 = 'id-tc26-signwithdigest-gost3410-2012-256';
  LN_id_tc26_signwithdigest_gost3410_2012_256 = 'GOST R 34.10-2012 with GOST R 34.11-2012 256 bit';
  NID_id_tc26_signwithdigest_gost3410_2012_256 = 985;
  SN_id_tc26_signwithdigest_gost3410_2012_512 = 'id-tc26-signwithdigest-gost3410-2012-512';
  LN_id_tc26_signwithdigest_gost3410_2012_512 = 'GOST R 34.10-2012 with GOST R 34.11-2012 512 bit';
  NID_id_tc26_signwithdigest_gost3410_2012_512 = 986;
  SN_id_tc26_mac = 'id-tc26-mac';
  NID_id_tc26_mac = 987;
  SN_id_tc26_hmac_gost_3411_2012_256 = 'id-tc26-hmac-gost-3411-2012-256';
  LN_id_tc26_hmac_gost_3411_2012_256 = 'HMAC GOST 34.11-2012 256 bit';
  NID_id_tc26_hmac_gost_3411_2012_256 = 988;
  SN_id_tc26_hmac_gost_3411_2012_512 = 'id-tc26-hmac-gost-3411-2012-512';
  LN_id_tc26_hmac_gost_3411_2012_512 = 'HMAC GOST 34.11-2012 512 bit';
  NID_id_tc26_hmac_gost_3411_2012_512 = 989;
  SN_id_tc26_cipher = 'id-tc26-cipher';
  NID_id_tc26_cipher = 990;
  SN_id_tc26_cipher_gostr3412_2015_magma = 'id-tc26-cipher-gostr3412-2015-magma';
  NID_id_tc26_cipher_gostr3412_2015_magma = 1173;
  SN_id_tc26_cipher_gostr3412_2015_magma_ctracpkm = 'id-tc26-cipher-gostr3412-2015-magma-ctracpkm';
  NID_id_tc26_cipher_gostr3412_2015_magma_ctracpkm = 1174;
  SN_id_tc26_cipher_gostr3412_2015_magma_ctracpkm_omac = 'id-tc26-cipher-gostr3412-2015-magma-ctracpkm-omac';
  NID_id_tc26_cipher_gostr3412_2015_magma_ctracpkm_omac = 1175;
  SN_id_tc26_cipher_gostr3412_2015_kuznyechik = 'id-tc26-cipher-gostr3412-2015-kuznyechik';
  NID_id_tc26_cipher_gostr3412_2015_kuznyechik = 1176;
  SN_id_tc26_cipher_gostr3412_2015_kuznyechik_ctracpkm = 'id-tc26-cipher-gostr3412-2015-kuznyechik-ctracpkm';
  NID_id_tc26_cipher_gostr3412_2015_kuznyechik_ctracpkm = 1177;
  SN_id_tc26_cipher_gostr3412_2015_kuznyechik_ctracpkm_omac = 'id-tc26-cipher-gostr3412-2015-kuznyechik-ctracpkm-omac';
  NID_id_tc26_cipher_gostr3412_2015_kuznyechik_ctracpkm_omac = 1178;
  SN_id_tc26_agreement = 'id-tc26-agreement';
  NID_id_tc26_agreement = 991;
  SN_id_tc26_agreement_gost_3410_2012_256 = 'id-tc26-agreement-gost-3410-2012-256';
  NID_id_tc26_agreement_gost_3410_2012_256 = 992;
  SN_id_tc26_agreement_gost_3410_2012_512 = 'id-tc26-agreement-gost-3410-2012-512';
  NID_id_tc26_agreement_gost_3410_2012_512 = 993;
  SN_id_tc26_wrap = 'id-tc26-wrap';
  NID_id_tc26_wrap = 1179;
  SN_id_tc26_wrap_gostr3412_2015_magma = 'id-tc26-wrap-gostr3412-2015-magma';
  NID_id_tc26_wrap_gostr3412_2015_magma = 1180;
  SN_id_tc26_wrap_gostr3412_2015_magma_kexp15 = 'id-tc26-wrap-gostr3412-2015-magma-kexp15';
  NID_id_tc26_wrap_gostr3412_2015_magma_kexp15 = 1181;
  SN_id_tc26_wrap_gostr3412_2015_kuznyechik = 'id-tc26-wrap-gostr3412-2015-kuznyechik';
  NID_id_tc26_wrap_gostr3412_2015_kuznyechik = 1182;
  SN_id_tc26_wrap_gostr3412_2015_kuznyechik_kexp15 = 'id-tc26-wrap-gostr3412-2015-kuznyechik-kexp15';
  NID_id_tc26_wrap_gostr3412_2015_kuznyechik_kexp15 = 1183;
  SN_id_tc26_constants = 'id-tc26-constants';
  NID_id_tc26_constants = 994;
  SN_id_tc26_sign_constants = 'id-tc26-sign-constants';
  NID_id_tc26_sign_constants = 995;
  SN_id_tc26_gost_3410_2012_256_constants = 'id-tc26-gost-3410-2012-256-constants';
  NID_id_tc26_gost_3410_2012_256_constants = 1147;
  SN_id_tc26_gost_3410_2012_256_paramSetA = 'id-tc26-gost-3410-2012-256-paramSetA';
  LN_id_tc26_gost_3410_2012_256_paramSetA = 'GOST R 34.10-2012 256 bit ParamSet A';
  NID_id_tc26_gost_3410_2012_256_paramSetA = 1148;
  SN_id_tc26_gost_3410_2012_256_paramSetB = 'id-tc26-gost-3410-2012-256-paramSetB';
  LN_id_tc26_gost_3410_2012_256_paramSetB = 'GOST R 34.10-2012 256 bit ParamSet B';
  NID_id_tc26_gost_3410_2012_256_paramSetB = 1184;
  SN_id_tc26_gost_3410_2012_256_paramSetC = 'id-tc26-gost-3410-2012-256-paramSetC';
  LN_id_tc26_gost_3410_2012_256_paramSetC = 'GOST R 34.10-2012 256 bit ParamSet C';
  NID_id_tc26_gost_3410_2012_256_paramSetC = 1185;
  SN_id_tc26_gost_3410_2012_256_paramSetD = 'id-tc26-gost-3410-2012-256-paramSetD';
  LN_id_tc26_gost_3410_2012_256_paramSetD = 'GOST R 34.10-2012 256 bit ParamSet D';
  NID_id_tc26_gost_3410_2012_256_paramSetD = 1186;
  SN_id_tc26_gost_3410_2012_512_constants = 'id-tc26-gost-3410-2012-512-constants';
  NID_id_tc26_gost_3410_2012_512_constants = 996;
  SN_id_tc26_gost_3410_2012_512_paramSetTest = 'id-tc26-gost-3410-2012-512-paramSetTest';
  LN_id_tc26_gost_3410_2012_512_paramSetTest = 'GOST R 34.10-2012 512 bit testing parameter set';
  NID_id_tc26_gost_3410_2012_512_paramSetTest = 997;
  SN_id_tc26_gost_3410_2012_512_paramSetA = 'id-tc26-gost-3410-2012-512-paramSetA';
  LN_id_tc26_gost_3410_2012_512_paramSetA = 'GOST R 34.10-2012 512 bit ParamSet A';
  NID_id_tc26_gost_3410_2012_512_paramSetA = 998;
  SN_id_tc26_gost_3410_2012_512_paramSetB = 'id-tc26-gost-3410-2012-512-paramSetB';
  LN_id_tc26_gost_3410_2012_512_paramSetB = 'GOST R 34.10-2012 512 bit ParamSet B';
  NID_id_tc26_gost_3410_2012_512_paramSetB = 999;
  SN_id_tc26_gost_3410_2012_512_paramSetC = 'id-tc26-gost-3410-2012-512-paramSetC';
  LN_id_tc26_gost_3410_2012_512_paramSetC = 'GOST R 34.10-2012 512 bit ParamSet C';
  NID_id_tc26_gost_3410_2012_512_paramSetC = 1149;
  SN_id_tc26_digest_constants = 'id-tc26-digest-constants';
  NID_id_tc26_digest_constants = 1000;
  SN_id_tc26_cipher_constants = 'id-tc26-cipher-constants';
  NID_id_tc26_cipher_constants = 1001;
  SN_id_tc26_gost_28147_constants = 'id-tc26-gost-28147-constants';
  NID_id_tc26_gost_28147_constants = 1002;
  SN_id_tc26_gost_28147_param_Z = 'id-tc26-gost-28147-param-Z';
  LN_id_tc26_gost_28147_param_Z = 'GOST 28147-89 TC26 parameter set';
  NID_id_tc26_gost_28147_param_Z = 1003;
  SN_INN = 'INN';
  LN_INN = 'INN';
  NID_INN = 1004;
  SN_OGRN = 'OGRN';
  LN_OGRN = 'OGRN';
  NID_OGRN = 1005;
  SN_SNILS = 'SNILS';
  LN_SNILS = 'SNILS';
  NID_SNILS = 1006;
  SN_subjectSignTool = 'subjectSignTool';
  LN_subjectSignTool = 'Signing Tool of Subject';
  NID_subjectSignTool = 1007;
  SN_issuerSignTool = 'issuerSignTool';
  LN_issuerSignTool = 'Signing Tool of Issuer';
  NID_issuerSignTool = 1008;
  SN_grasshopper_ecb = 'grasshopper-ecb';
  NID_grasshopper_ecb = 1012;
  SN_grasshopper_ctr = 'grasshopper-ctr';
  NID_grasshopper_ctr = 1013;
  SN_grasshopper_ofb = 'grasshopper-ofb';
  NID_grasshopper_ofb = 1014;
  SN_grasshopper_cbc = 'grasshopper-cbc';
  NID_grasshopper_cbc = 1015;
  SN_grasshopper_cfb = 'grasshopper-cfb';
  NID_grasshopper_cfb = 1016;
  SN_grasshopper_mac = 'grasshopper-mac';
  NID_grasshopper_mac = 1017;
  SN_magma_ecb = 'magma-ecb';
  NID_magma_ecb = 1187;
  SN_magma_ctr = 'magma-ctr';
  NID_magma_ctr = 1188;
  SN_magma_ofb = 'magma-ofb';
  NID_magma_ofb = 1189;
  SN_magma_cbc = 'magma-cbc';
  NID_magma_cbc = 1190;
  SN_magma_cfb = 'magma-cfb';
  NID_magma_cfb = 1191;
  SN_magma_mac = 'magma-mac';
  NID_magma_mac = 1192;
  SN_camellia_128_cbc = 'CAMELLIA-128-CBC';
  LN_camellia_128_cbc = 'camellia-128-cbc';
  NID_camellia_128_cbc = 751;
  SN_camellia_192_cbc = 'CAMELLIA-192-CBC';
  LN_camellia_192_cbc = 'camellia-192-cbc';
  NID_camellia_192_cbc = 752;
  SN_camellia_256_cbc = 'CAMELLIA-256-CBC';
  LN_camellia_256_cbc = 'camellia-256-cbc';
  NID_camellia_256_cbc = 753;
  SN_id_camellia128_wrap = 'id-camellia128-wrap';
  NID_id_camellia128_wrap = 907;
  SN_id_camellia192_wrap = 'id-camellia192-wrap';
  NID_id_camellia192_wrap = 908;
  SN_id_camellia256_wrap = 'id-camellia256-wrap';
  NID_id_camellia256_wrap = 909;
  SN_camellia_128_ecb = 'CAMELLIA-128-ECB';
  LN_camellia_128_ecb = 'camellia-128-ecb';
  NID_camellia_128_ecb = 754;
  SN_camellia_128_ofb128 = 'CAMELLIA-128-OFB';
  LN_camellia_128_ofb128 = 'camellia-128-ofb';
  NID_camellia_128_ofb128 = 766;
  SN_camellia_128_cfb128 = 'CAMELLIA-128-CFB';
  LN_camellia_128_cfb128 = 'camellia-128-cfb';
  NID_camellia_128_cfb128 = 757;
  SN_camellia_128_gcm = 'CAMELLIA-128-GCM';
  LN_camellia_128_gcm = 'camellia-128-gcm';
  NID_camellia_128_gcm = 961;
  SN_camellia_128_ccm = 'CAMELLIA-128-CCM';
  LN_camellia_128_ccm = 'camellia-128-ccm';
  NID_camellia_128_ccm = 962;
  SN_camellia_128_ctr = 'CAMELLIA-128-CTR';
  LN_camellia_128_ctr = 'camellia-128-ctr';
  NID_camellia_128_ctr = 963;
  SN_camellia_128_cmac = 'CAMELLIA-128-CMAC';
  LN_camellia_128_cmac = 'camellia-128-cmac';
  NID_camellia_128_cmac = 964;
  SN_camellia_192_ecb = 'CAMELLIA-192-ECB';
  LN_camellia_192_ecb = 'camellia-192-ecb';
  NID_camellia_192_ecb = 755;
  SN_camellia_192_ofb128 = 'CAMELLIA-192-OFB';
  LN_camellia_192_ofb128 = 'camellia-192-ofb';
  NID_camellia_192_ofb128 = 767;
  SN_camellia_192_cfb128 = 'CAMELLIA-192-CFB';
  LN_camellia_192_cfb128 = 'camellia-192-cfb';
  NID_camellia_192_cfb128 = 758;
  SN_camellia_192_gcm = 'CAMELLIA-192-GCM';
  LN_camellia_192_gcm = 'camellia-192-gcm';
  NID_camellia_192_gcm = 965;
  SN_camellia_192_ccm = 'CAMELLIA-192-CCM';
  LN_camellia_192_ccm = 'camellia-192-ccm';
  NID_camellia_192_ccm = 966;
  SN_camellia_192_ctr = 'CAMELLIA-192-CTR';
  LN_camellia_192_ctr = 'camellia-192-ctr';
  NID_camellia_192_ctr = 967;
  SN_camellia_192_cmac = 'CAMELLIA-192-CMAC';
  LN_camellia_192_cmac = 'camellia-192-cmac';
  NID_camellia_192_cmac = 968;
  SN_camellia_256_ecb = 'CAMELLIA-256-ECB';
  LN_camellia_256_ecb = 'camellia-256-ecb';
  NID_camellia_256_ecb = 756;
  SN_camellia_256_ofb128 = 'CAMELLIA-256-OFB';
  LN_camellia_256_ofb128 = 'camellia-256-ofb';
  NID_camellia_256_ofb128 = 768;
  SN_camellia_256_cfb128 = 'CAMELLIA-256-CFB';
  LN_camellia_256_cfb128 = 'camellia-256-cfb';
  NID_camellia_256_cfb128 = 759;
  SN_camellia_256_gcm = 'CAMELLIA-256-GCM';
  LN_camellia_256_gcm = 'camellia-256-gcm';
  NID_camellia_256_gcm = 969;
  SN_camellia_256_ccm = 'CAMELLIA-256-CCM';
  LN_camellia_256_ccm = 'camellia-256-ccm';
  NID_camellia_256_ccm = 970;
  SN_camellia_256_ctr = 'CAMELLIA-256-CTR';
  LN_camellia_256_ctr = 'camellia-256-ctr';
  NID_camellia_256_ctr = 971;
  SN_camellia_256_cmac = 'CAMELLIA-256-CMAC';
  LN_camellia_256_cmac = 'camellia-256-cmac';
  NID_camellia_256_cmac = 972;
  SN_camellia_128_cfb1 = 'CAMELLIA-128-CFB1';
  LN_camellia_128_cfb1 = 'camellia-128-cfb1';
  NID_camellia_128_cfb1 = 760;
  SN_camellia_192_cfb1 = 'CAMELLIA-192-CFB1';
  LN_camellia_192_cfb1 = 'camellia-192-cfb1';
  NID_camellia_192_cfb1 = 761;
  SN_camellia_256_cfb1 = 'CAMELLIA-256-CFB1';
  LN_camellia_256_cfb1 = 'camellia-256-cfb1';
  NID_camellia_256_cfb1 = 762;
  SN_camellia_128_cfb8 = 'CAMELLIA-128-CFB8';
  LN_camellia_128_cfb8 = 'camellia-128-cfb8';
  NID_camellia_128_cfb8 = 763;
  SN_camellia_192_cfb8 = 'CAMELLIA-192-CFB8';
  LN_camellia_192_cfb8 = 'camellia-192-cfb8';
  NID_camellia_192_cfb8 = 764;
  SN_camellia_256_cfb8 = 'CAMELLIA-256-CFB8';
  LN_camellia_256_cfb8 = 'camellia-256-cfb8';
  NID_camellia_256_cfb8 = 765;
  SN_aria_128_ecb = 'ARIA-128-ECB';
  LN_aria_128_ecb = 'aria-128-ecb';
  NID_aria_128_ecb = 1065;
  SN_aria_128_cbc = 'ARIA-128-CBC';
  LN_aria_128_cbc = 'aria-128-cbc';
  NID_aria_128_cbc = 1066;
  SN_aria_128_cfb128 = 'ARIA-128-CFB';
  LN_aria_128_cfb128 = 'aria-128-cfb';
  NID_aria_128_cfb128 = 1067;
  SN_aria_128_ofb128 = 'ARIA-128-OFB';
  LN_aria_128_ofb128 = 'aria-128-ofb';
  NID_aria_128_ofb128 = 1068;
  SN_aria_128_ctr = 'ARIA-128-CTR';
  LN_aria_128_ctr = 'aria-128-ctr';
  NID_aria_128_ctr = 1069;
  SN_aria_192_ecb = 'ARIA-192-ECB';
  LN_aria_192_ecb = 'aria-192-ecb';
  NID_aria_192_ecb = 1070;
  SN_aria_192_cbc = 'ARIA-192-CBC';
  LN_aria_192_cbc = 'aria-192-cbc';
  NID_aria_192_cbc = 1071;
  SN_aria_192_cfb128 = 'ARIA-192-CFB';
  LN_aria_192_cfb128 = 'aria-192-cfb';
  NID_aria_192_cfb128 = 1072;
  SN_aria_192_ofb128 = 'ARIA-192-OFB';
  LN_aria_192_ofb128 = 'aria-192-ofb';
  NID_aria_192_ofb128 = 1073;
  SN_aria_192_ctr = 'ARIA-192-CTR';
  LN_aria_192_ctr = 'aria-192-ctr';
  NID_aria_192_ctr = 1074;
  SN_aria_256_ecb = 'ARIA-256-ECB';
  LN_aria_256_ecb = 'aria-256-ecb';
  NID_aria_256_ecb = 1075;
  SN_aria_256_cbc = 'ARIA-256-CBC';
  LN_aria_256_cbc = 'aria-256-cbc';
  NID_aria_256_cbc = 1076;
  SN_aria_256_cfb128 = 'ARIA-256-CFB';
  LN_aria_256_cfb128 = 'aria-256-cfb';
  NID_aria_256_cfb128 = 1077;
  SN_aria_256_ofb128 = 'ARIA-256-OFB';
  LN_aria_256_ofb128 = 'aria-256-ofb';
  NID_aria_256_ofb128 = 1078;
  SN_aria_256_ctr = 'ARIA-256-CTR';
  LN_aria_256_ctr = 'aria-256-ctr';
  NID_aria_256_ctr = 1079;
  SN_aria_128_cfb1 = 'ARIA-128-CFB1';
  LN_aria_128_cfb1 = 'aria-128-cfb1';
  NID_aria_128_cfb1 = 1080;
  SN_aria_192_cfb1 = 'ARIA-192-CFB1';
  LN_aria_192_cfb1 = 'aria-192-cfb1';
  NID_aria_192_cfb1 = 1081;
  SN_aria_256_cfb1 = 'ARIA-256-CFB1';
  LN_aria_256_cfb1 = 'aria-256-cfb1';
  NID_aria_256_cfb1 = 1082;
  SN_aria_128_cfb8 = 'ARIA-128-CFB8';
  LN_aria_128_cfb8 = 'aria-128-cfb8';
  NID_aria_128_cfb8 = 1083;
  SN_aria_192_cfb8 = 'ARIA-192-CFB8';
  LN_aria_192_cfb8 = 'aria-192-cfb8';
  NID_aria_192_cfb8 = 1084;
  SN_aria_256_cfb8 = 'ARIA-256-CFB8';
  LN_aria_256_cfb8 = 'aria-256-cfb8';
  NID_aria_256_cfb8 = 1085;
  SN_aria_128_ccm = 'ARIA-128-CCM';
  LN_aria_128_ccm = 'aria-128-ccm';
  NID_aria_128_ccm = 1120;
  SN_aria_192_ccm = 'ARIA-192-CCM';
  LN_aria_192_ccm = 'aria-192-ccm';
  NID_aria_192_ccm = 1121;
  SN_aria_256_ccm = 'ARIA-256-CCM';
  LN_aria_256_ccm = 'aria-256-ccm';
  NID_aria_256_ccm = 1122;
  SN_aria_128_gcm = 'ARIA-128-GCM';
  LN_aria_128_gcm = 'aria-128-gcm';
  NID_aria_128_gcm = 1123;
  SN_aria_192_gcm = 'ARIA-192-GCM';
  LN_aria_192_gcm = 'aria-192-gcm';
  NID_aria_192_gcm = 1124;
  SN_aria_256_gcm = 'ARIA-256-GCM';
  LN_aria_256_gcm = 'aria-256-gcm';
  NID_aria_256_gcm = 1125;
  SN_kisa = 'KISA';
  LN_kisa = 'kisa';
  NID_kisa = 773;
  SN_seed_ecb = 'SEED-ECB';
  LN_seed_ecb = 'seed-ecb';
  NID_seed_ecb = 776;
  SN_seed_cbc = 'SEED-CBC';
  LN_seed_cbc = 'seed-cbc';
  NID_seed_cbc = 777;
  SN_seed_cfb128 = 'SEED-CFB';
  LN_seed_cfb128 = 'seed-cfb';
  NID_seed_cfb128 = 779;
  SN_seed_ofb128 = 'SEED-OFB';
  LN_seed_ofb128 = 'seed-ofb';
  NID_seed_ofb128 = 778;
  SN_sm4_ecb = 'SM4-ECB';
  LN_sm4_ecb = 'sm4-ecb';
  NID_sm4_ecb = 1133;
  SN_sm4_cbc = 'SM4-CBC';
  LN_sm4_cbc = 'sm4-cbc';
  NID_sm4_cbc = 1134;
  SN_sm4_ofb128 = 'SM4-OFB';
  LN_sm4_ofb128 = 'sm4-ofb';
  NID_sm4_ofb128 = 1135;
  SN_sm4_cfb128 = 'SM4-CFB';
  LN_sm4_cfb128 = 'sm4-cfb';
  NID_sm4_cfb128 = 1137;
  SN_sm4_cfb1 = 'SM4-CFB1';
  LN_sm4_cfb1 = 'sm4-cfb1';
  NID_sm4_cfb1 = 1136;
  SN_sm4_cfb8 = 'SM4-CFB8';
  LN_sm4_cfb8 = 'sm4-cfb8';
  NID_sm4_cfb8 = 1138;
  SN_sm4_ctr = 'SM4-CTR';
  LN_sm4_ctr = 'sm4-ctr';
  NID_sm4_ctr = 1139;
  SN_hmac = 'HMAC';
  LN_hmac = 'hmac';
  NID_hmac = 855;
  SN_cmac = 'CMAC';
  LN_cmac = 'cmac';
  NID_cmac = 894;
  SN_rc4_hmac_md5 = 'RC4-HMAC-MD5';
  LN_rc4_hmac_md5 = 'rc4-hmac-md5';
  NID_rc4_hmac_md5 = 915;
  SN_aes_128_cbc_hmac_sha1 = 'AES-128-CBC-HMAC-SHA1';
  LN_aes_128_cbc_hmac_sha1 = 'aes-128-cbc-hmac-sha1';
  NID_aes_128_cbc_hmac_sha1 = 916;
  SN_aes_192_cbc_hmac_sha1 = 'AES-192-CBC-HMAC-SHA1';
  LN_aes_192_cbc_hmac_sha1 = 'aes-192-cbc-hmac-sha1';
  NID_aes_192_cbc_hmac_sha1 = 917;
  SN_aes_256_cbc_hmac_sha1 = 'AES-256-CBC-HMAC-SHA1';
  LN_aes_256_cbc_hmac_sha1 = 'aes-256-cbc-hmac-sha1';
  NID_aes_256_cbc_hmac_sha1 = 918;
  SN_aes_128_cbc_hmac_sha256 = 'AES-128-CBC-HMAC-SHA256';
  LN_aes_128_cbc_hmac_sha256 = 'aes-128-cbc-hmac-sha256';
  NID_aes_128_cbc_hmac_sha256 = 948;
  SN_aes_192_cbc_hmac_sha256 = 'AES-192-CBC-HMAC-SHA256';
  LN_aes_192_cbc_hmac_sha256 = 'aes-192-cbc-hmac-sha256';
  NID_aes_192_cbc_hmac_sha256 = 949;
  SN_aes_256_cbc_hmac_sha256 = 'AES-256-CBC-HMAC-SHA256';
  LN_aes_256_cbc_hmac_sha256 = 'aes-256-cbc-hmac-sha256';
  NID_aes_256_cbc_hmac_sha256 = 950;
  SN_chacha20_poly1305 = 'ChaCha20-Poly1305';
  LN_chacha20_poly1305 = 'chacha20-poly1305';
  NID_chacha20_poly1305 = 1018;
  SN_chacha20 = 'ChaCha20';
  LN_chacha20 = 'chacha20';
  NID_chacha20 = 1019;
  SN_dhpublicnumber = 'dhpublicnumber';
  LN_dhpublicnumber = 'X9.42 DH';
  NID_dhpublicnumber = 920;
  SN_brainpoolP160r1 = 'brainpoolP160r1';
  NID_brainpoolP160r1 = 921;
  SN_brainpoolP160t1 = 'brainpoolP160t1';
  NID_brainpoolP160t1 = 922;
  SN_brainpoolP192r1 = 'brainpoolP192r1';
  NID_brainpoolP192r1 = 923;
  SN_brainpoolP192t1 = 'brainpoolP192t1';
  NID_brainpoolP192t1 = 924;
  SN_brainpoolP224r1 = 'brainpoolP224r1';
  NID_brainpoolP224r1 = 925;
  SN_brainpoolP224t1 = 'brainpoolP224t1';
  NID_brainpoolP224t1 = 926;
  SN_brainpoolP256r1 = 'brainpoolP256r1';
  NID_brainpoolP256r1 = 927;
  SN_brainpoolP256t1 = 'brainpoolP256t1';
  NID_brainpoolP256t1 = 928;
  SN_brainpoolP320r1 = 'brainpoolP320r1';
  NID_brainpoolP320r1 = 929;
  SN_brainpoolP320t1 = 'brainpoolP320t1';
  NID_brainpoolP320t1 = 930;
  SN_brainpoolP384r1 = 'brainpoolP384r1';
  NID_brainpoolP384r1 = 931;
  SN_brainpoolP384t1 = 'brainpoolP384t1';
  NID_brainpoolP384t1 = 932;
  SN_brainpoolP512r1 = 'brainpoolP512r1';
  NID_brainpoolP512r1 = 933;
  SN_brainpoolP512t1 = 'brainpoolP512t1';
  NID_brainpoolP512t1 = 934;
  SN_dhSinglePass_stdDH_sha1kdf_scheme = 'dhSinglePass-stdDH-sha1kdf-scheme';
  NID_dhSinglePass_stdDH_sha1kdf_scheme = 936;
  SN_dhSinglePass_stdDH_sha224kdf_scheme = 'dhSinglePass-stdDH-sha224kdf-scheme';
  NID_dhSinglePass_stdDH_sha224kdf_scheme = 937;
  SN_dhSinglePass_stdDH_sha256kdf_scheme = 'dhSinglePass-stdDH-sha256kdf-scheme';
  NID_dhSinglePass_stdDH_sha256kdf_scheme = 938;
  SN_dhSinglePass_stdDH_sha384kdf_scheme = 'dhSinglePass-stdDH-sha384kdf-scheme';
  NID_dhSinglePass_stdDH_sha384kdf_scheme = 939;
  SN_dhSinglePass_stdDH_sha512kdf_scheme = 'dhSinglePass-stdDH-sha512kdf-scheme';
  NID_dhSinglePass_stdDH_sha512kdf_scheme = 940;
  SN_dhSinglePass_cofactorDH_sha1kdf_scheme = 'dhSinglePass-cofactorDH-sha1kdf-scheme';
  NID_dhSinglePass_cofactorDH_sha1kdf_scheme = 941;
  SN_dhSinglePass_cofactorDH_sha224kdf_scheme = 'dhSinglePass-cofactorDH-sha224kdf-scheme';
  NID_dhSinglePass_cofactorDH_sha224kdf_scheme = 942;
  SN_dhSinglePass_cofactorDH_sha256kdf_scheme = 'dhSinglePass-cofactorDH-sha256kdf-scheme';
  NID_dhSinglePass_cofactorDH_sha256kdf_scheme = 943;
  SN_dhSinglePass_cofactorDH_sha384kdf_scheme = 'dhSinglePass-cofactorDH-sha384kdf-scheme';
  NID_dhSinglePass_cofactorDH_sha384kdf_scheme = 944;
  SN_dhSinglePass_cofactorDH_sha512kdf_scheme = 'dhSinglePass-cofactorDH-sha512kdf-scheme';
  NID_dhSinglePass_cofactorDH_sha512kdf_scheme = 945;
  SN_dh_std_kdf = 'dh-std-kdf';
  NID_dh_std_kdf = 946;
  SN_dh_cofactor_kdf = 'dh-cofactor-kdf';
  NID_dh_cofactor_kdf = 947;
  SN_ct_precert_scts = 'ct_precert_scts';
  LN_ct_precert_scts = 'CT Precertificate SCTs';
  NID_ct_precert_scts = 951;
  SN_ct_precert_poison = 'ct_precert_poison';
  LN_ct_precert_poison = 'CT Precertificate Poison';
  NID_ct_precert_poison = 952;
  SN_ct_precert_signer = 'ct_precert_signer';
  LN_ct_precert_signer = 'CT Precertificate Signer';
  NID_ct_precert_signer = 953;
  SN_ct_cert_scts = 'ct_cert_scts';
  LN_ct_cert_scts = 'CT Certificate SCTs';
  NID_ct_cert_scts = 954;
  SN_jurisdictionLocalityName = 'jurisdictionL';
  LN_jurisdictionLocalityName = 'jurisdictionLocalityName';
  NID_jurisdictionLocalityName = 955;
  SN_jurisdictionStateOrProvinceName = 'jurisdictionST';
  LN_jurisdictionStateOrProvinceName = 'jurisdictionStateOrProvinceName';
  NID_jurisdictionStateOrProvinceName = 956;
  SN_jurisdictionCountryName = 'jurisdictionC';
  LN_jurisdictionCountryName = 'jurisdictionCountryName';
  NID_jurisdictionCountryName = 957;
  SN_id_scrypt = 'id-scrypt';
  LN_id_scrypt = 'scrypt';
  NID_id_scrypt = 973;
  SN_tls1_prf = 'TLS1-PRF';
  LN_tls1_prf = 'tls1-prf';
  NID_tls1_prf = 1021;
  SN_hkdf = 'HKDF';
  LN_hkdf = 'hkdf';
  NID_hkdf = 1036;
  SN_id_pkinit = 'id-pkinit';
  NID_id_pkinit = 1031;
  SN_pkInitClientAuth = 'pkInitClientAuth';
  LN_pkInitClientAuth = 'PKINIT Client Auth';
  NID_pkInitClientAuth = 1032;
  SN_pkInitKDC = 'pkInitKDC';
  LN_pkInitKDC = 'Signing KDC Response';
  NID_pkInitKDC = 1033;
  SN_X25519 = 'X25519';
  NID_X25519 = 1034;
  SN_X448 = 'X448';
  NID_X448 = 1035;
  SN_ED448 = 'ED448';
  NID_ED448 = 1088;
  SN_kx_rsa = 'KxRSA';
  LN_kx_rsa = 'kx-rsa';
  NID_kx_rsa = 1037;
  SN_kx_ecdhe = 'KxECDHE';
  LN_kx_ecdhe = 'kx-ecdhe';
  NID_kx_ecdhe = 1038;
  SN_kx_dhe = 'KxDHE';
  LN_kx_dhe = 'kx-dhe';
  NID_kx_dhe = 1039;
  SN_kx_ecdhe_psk = 'KxECDHE-PSK';
  LN_kx_ecdhe_psk = 'kx-ecdhe-psk';
  NID_kx_ecdhe_psk = 1040;
  SN_kx_dhe_psk = 'KxDHE-PSK';
  LN_kx_dhe_psk = 'kx-dhe-psk';
  NID_kx_dhe_psk = 1041;
  SN_kx_rsa_psk = 'KxRSA_PSK';
  LN_kx_rsa_psk = 'kx-rsa-psk';
  NID_kx_rsa_psk = 1042;
  SN_kx_psk = 'KxPSK';
  LN_kx_psk = 'kx-psk';
  NID_kx_psk = 1043;
  SN_kx_srp = 'KxSRP';
  LN_kx_srp = 'kx-srp';
  NID_kx_srp = 1044;
  SN_kx_gost = 'KxGOST';
  LN_kx_gost = 'kx-gost';
  NID_kx_gost = 1045;
  SN_kx_any = 'KxANY';
  LN_kx_any = 'kx-any';
  NID_kx_any = 1063;
  SN_auth_rsa = 'AuthRSA';
  LN_auth_rsa = 'auth-rsa';
  NID_auth_rsa = 1046;
  SN_auth_ecdsa = 'AuthECDSA';
  LN_auth_ecdsa = 'auth-ecdsa';
  NID_auth_ecdsa = 1047;
  SN_auth_psk = 'AuthPSK';
  LN_auth_psk = 'auth-psk';
  NID_auth_psk = 1048;
  SN_auth_dss = 'AuthDSS';
  LN_auth_dss = 'auth-dss';
  NID_auth_dss = 1049;
  SN_auth_gost01 = 'AuthGOST01';
  LN_auth_gost01 = 'auth-gost01';
  NID_auth_gost01 = 1050;
  SN_auth_gost12 = 'AuthGOST12';
  LN_auth_gost12 = 'auth-gost12';
  NID_auth_gost12 = 1051;
  SN_auth_srp = 'AuthSRP';
  LN_auth_srp = 'auth-srp';
  NID_auth_srp = 1052;
  SN_auth_null = 'AuthNULL';
  LN_auth_null = 'auth-null';
  NID_auth_null = 1053;
  SN_auth_any = 'AuthANY';
  LN_auth_any = 'auth-any';
  NID_auth_any = 1064;
  SN_siphash = 'SipHash';
  LN_siphash = 'siphash';
  NID_siphash = 1062;
  SN_ffdhe2048 = 'ffdhe2048';
  NID_ffdhe2048 = 1126;
  SN_ffdhe3072 = 'ffdhe3072';
  NID_ffdhe3072 = 1127;
  SN_ffdhe4096 = 'ffdhe4096';
  NID_ffdhe4096 = 1128;
  SN_ffdhe6144 = 'ffdhe6144';
  NID_ffdhe6144 = 1129;
  SN_ffdhe8192 = 'ffdhe8192';
  NID_ffdhe8192 = 1130;
  SN_ISO_UA = 'ISO-UA';
  NID_ISO_UA = 1150;
  SN_ua_pki = 'ua-pki';
  NID_ua_pki = 1151;
  SN_dstu28147 = 'dstu28147';
  LN_dstu28147 = 'DSTU Gost 28147-2009';
  NID_dstu28147 = 1152;
  SN_dstu28147_ofb = 'dstu28147-ofb';
  LN_dstu28147_ofb = 'DSTU Gost 28147-2009 OFB mode';
  NID_dstu28147_ofb = 1153;
  SN_dstu28147_cfb = 'dstu28147-cfb';
  LN_dstu28147_cfb = 'DSTU Gost 28147-2009 CFB mode';
  NID_dstu28147_cfb = 1154;
  SN_dstu28147_wrap = 'dstu28147-wrap';
  LN_dstu28147_wrap = 'DSTU Gost 28147-2009 key wrap';
  NID_dstu28147_wrap = 1155;
  SN_hmacWithDstu34311 = 'hmacWithDstu34311';
  LN_hmacWithDstu34311 = 'HMAC DSTU Gost 34311-95';
  NID_hmacWithDstu34311 = 1156;
  SN_dstu34311 = 'dstu34311';
  LN_dstu34311 = 'DSTU Gost 34311-95';
  NID_dstu34311 = 1157;
  SN_dstu4145le = 'dstu4145le';
  LN_dstu4145le = 'DSTU 4145-2002 little endian';
  NID_dstu4145le = 1158;
  SN_dstu4145be = 'dstu4145be';
  LN_dstu4145be = 'DSTU 4145-2002 big endian';
  NID_dstu4145be = 1159;
  SN_uacurve0 = 'uacurve0';
  LN_uacurve0 = 'DSTU curve 0';
  NID_uacurve0 = 1160;
  SN_uacurve1 = 'uacurve1';
  LN_uacurve1 = 'DSTU curve 1';
  NID_uacurve1 = 1161;
  SN_uacurve2 = 'uacurve2';
  LN_uacurve2 = 'DSTU curve 2';
  NID_uacurve2 = 1162;
  SN_uacurve3 = 'uacurve3';
  LN_uacurve3 = 'DSTU curve 3';
  NID_uacurve3 = 1163;
  SN_uacurve4 = 'uacurve4';
  LN_uacurve4 = 'DSTU curve 4';
  NID_uacurve4 = 1164;
  SN_uacurve5 = 'uacurve5';
  LN_uacurve5 = 'DSTU curve 5';
  NID_uacurve5 = 1165;
  SN_uacurve6 = 'uacurve6';
  LN_uacurve6 = 'DSTU curve 6';
  NID_uacurve6 = 1166;
  SN_uacurve7 = 'uacurve7';
  LN_uacurve7 = 'DSTU curve 7';
  NID_uacurve7 = 1167;
  SN_uacurve8 = 'uacurve8';
  LN_uacurve8 = 'DSTU curve 8';
  NID_uacurve8 = 1168;
  SN_uacurve9 = 'uacurve9';
  LN_uacurve9 = 'DSTU curve 9';
  NID_uacurve9 = 1169;
  
  
  OBJ_F_OBJ_ADD_OBJECT = 105;
  OBJ_F_OBJ_ADD_SIGID = 107;
  OBJ_F_OBJ_CREATE = 100;
  OBJ_F_OBJ_DUP = 101;
  OBJ_F_OBJ_NAME_NEW_INDEX = 106;
  OBJ_F_OBJ_NID2LN = 102;
  OBJ_F_OBJ_NID2OBJ = 103;
  OBJ_F_OBJ_NID2SN = 104;
  OBJ_F_OBJ_TXT2OBJ = 108;
  
  OBJ_R_OID_EXISTS = 102;
  OBJ_R_UNKNOWN_NID = 101;
  
  OBJ_NAME_TYPE_UNDEF = $00;
  OBJ_NAME_TYPE_MD_METH = $01;
  OBJ_NAME_TYPE_CIPHER_METH = $02;
  OBJ_NAME_TYPE_PKEY_METH = $03;
  OBJ_NAME_TYPE_COMP_METH = $04;
  OBJ_NAME_TYPE_NUM = $05;
  OBJ_NAME_ALIAS = $8000;
  
  OBJ_BSEARCH_VALUE_ON_NOMATCH = $01;
  OBJ_BSEARCH_FIRST_VALUE_ON_MATCH = $02;
  
  EVP_PK_RSA = $0001;
  EVP_PK_DSA = $0002;
  EVP_PK_DH = $0004;
  EVP_PK_EC = $0008;
  
  EVP_PKT_SIGN = $0010;
  EVP_PKT_ENC = $0020;
  EVP_PKT_EXCH = $0040;
  
  EVP_PKS_RSA = $0100;
  EVP_PKS_DSA = $0200;
  EVP_PKS_EC = $0400;

  EVP_PKEY_NONE = NID_undef;
  EVP_PKEY_RSA2 = NID_rsa;
  EVP_PKEY_DSA1 = NID_dsa_2;
  EVP_PKEY_DSA2 = NID_dsaWithSHA;
  EVP_PKEY_DSA3 = NID_dsaWithSHA1;
  EVP_PKEY_DSA4 = NID_dsaWithSHA1_2;
  EVP_PKEY_DHX = NID_dhpublicnumber;
  EVP_PKEY_SM2 = NID_sm2;
  EVP_PKEY_HMAC = NID_hmac;
  EVP_PKEY_CMAC = NID_cmac;
  EVP_PKEY_SCRYPT = NID_id_scrypt;
  EVP_PKEY_TLS1_PRF = NID_tls1_prf;
  EVP_PKEY_HKDF = NID_hkdf;
  EVP_PKEY_SIPHASH = NID_siphash;
  EVP_PKEY_X25519 = NID_X25519;
  EVP_PKEY_X448 = NID_X448;
  EVP_PKEY_ED448 = NID_ED448;
  EVP_PKEY_MO_SIGN = $0001;
  EVP_PKEY_MO_VERIFY = $0002;
  EVP_PKEY_MO_ENCRYPT = $0004;
  EVP_PKEY_MO_DECRYPT = $0008;
  
  EVP_MD_CTRL_DIGALGID = $1;
  EVP_MD_CTRL_MICALG = $2;
  EVP_MD_CTRL_XOF_LEN = $3;
  EVP_MD_CTRL_ALG_CTRL = $1000;
  EVP_MD_CTX_FLAG_ONESHOT = $0001;
  EVP_MD_CTX_FLAG_CLEANED = $0002;
  EVP_MD_CTX_FLAG_REUSE = $0004;
  EVP_MD_CTX_FLAG_NON_FIPS_ALLOW = $0008;
  EVP_MD_CTX_FLAG_PAD_MASK = $F0;
  EVP_MD_CTX_FLAG_PAD_PKCS1 = $00;
  EVP_MD_CTX_FLAG_PAD_X931 = $10;
  EVP_MD_CTX_FLAG_PAD_PSS = $20;
  EVP_MD_CTX_FLAG_NO_INIT = $0100;
  EVP_MD_CTX_FLAG_FINALISE = $0200;
  
  EVP_CIPH_STREAM_CIPHER = $0;
  EVP_CIPH_ECB_MODE = $1;
  EVP_CIPH_CBC_MODE = $2;
  EVP_CIPH_CFB_MODE = $3;
  EVP_CIPH_OFB_MODE = $4;
  EVP_CIPH_CTR_MODE = $5;
  EVP_CIPH_GCM_MODE = $6;
  EVP_CIPH_CCM_MODE = $7;
  EVP_CIPH_XTS_MODE = $10001;
  EVP_CIPH_WRAP_MODE = $10002;
  EVP_CIPH_OCB_MODE = $10003;
  EVP_CIPH_MODE = $F0007;
  EVP_CIPH_VARIABLE_LENGTH = $8;
  EVP_CIPH_CUSTOM_IV = $10;
  EVP_CIPH_ALWAYS_CALL_INIT = $20;
  EVP_CIPH_CTRL_INIT = $40;
  EVP_CIPH_CUSTOM_KEY_LENGTH = $80;
  EVP_CIPH_RAND_KEY = $200;
  EVP_CIPH_CUSTOM_COPY = $400;
  EVP_CIPH_CUSTOM_IV_LENGTH = $800;
  EVP_CIPH_FLAG_DEFAULT_ASN1 = $1000;
  EVP_CIPH_FLAG_LENGTH_BITS = $2000;
  EVP_CIPH_FLAG_FIPS = $4000;
  EVP_CIPH_FLAG_NON_FIPS_ALLOW = $8000;
  EVP_CIPH_FLAG_CUSTOM_CIPHER = $100000;
  EVP_CIPH_FLAG_AEAD_CIPHER = $200000;
  EVP_CIPH_FLAG_TLS1_1_MULTIBLOCK = $400000;
  EVP_CIPH_FLAG_PIPELINE = $800000;
  EVP_CIPHER_CTX_FLAG_WRAP_ALLOW = $1;
  
  EVP_CTRL_INIT = $0;
  EVP_CTRL_SET_KEY_LENGTH = $1;
  EVP_CTRL_GET_RC2_KEY_BITS = $2;
  EVP_CTRL_SET_RC2_KEY_BITS = $3;
  EVP_CTRL_GET_RC5_ROUNDS = $4;
  EVP_CTRL_SET_RC5_ROUNDS = $5;
  EVP_CTRL_RAND_KEY = $6;
  EVP_CTRL_PBE_PRF_NID = $7;
  EVP_CTRL_COPY = $8;
  EVP_CTRL_AEAD_SET_IVLEN = $9;
  EVP_CTRL_AEAD_GET_TAG = $10;
  EVP_CTRL_AEAD_SET_TAG = $11;
  EVP_CTRL_AEAD_SET_IV_FIXED = $12;
  EVP_CTRL_GCM_SET_IVLEN = EVP_CTRL_AEAD_SET_IVLEN;
  EVP_CTRL_GCM_SET_IV_FIXED = EVP_CTRL_AEAD_SET_IV_FIXED;
  EVP_CTRL_GCM_IV_GEN = $13;
  EVP_CTRL_CCM_SET_IVLEN = EVP_CTRL_AEAD_SET_IVLEN;
  EVP_CTRL_CCM_GET_TAG = EVP_CTRL_AEAD_GET_TAG;
  EVP_CTRL_CCM_SET_TAG = EVP_CTRL_AEAD_SET_TAG;
  EVP_CTRL_CCM_SET_IV_FIXED = EVP_CTRL_AEAD_SET_IV_FIXED;
  EVP_CTRL_CCM_SET_L = $14;
  EVP_CTRL_CCM_SET_MSGLEN = $15;
  EVP_CTRL_AEAD_TLS1_AAD = $16;
  EVP_CTRL_AEAD_SET_MAC_KEY = $17;
  EVP_CTRL_GCM_SET_IV_INV = $18;
  EVP_CTRL_TLS1_1_MULTIBLOCK_AAD = $19;
  EVP_CTRL_TLS1_1_MULTIBLOCK_ENCRYPT = $1a;
  EVP_CTRL_TLS1_1_MULTIBLOCK_DECRYPT = $1b;
  EVP_CTRL_TLS1_1_MULTIBLOCK_MAX_BUFSIZE = $1c;
  EVP_CTRL_SSL3_MASTER_SECRET = $1d;
  EVP_CTRL_SET_SBOX = $1e;
  EVP_CTRL_SBOX_USED = $1f;
  EVP_CTRL_KEY_MESH = $20;
  EVP_CTRL_BLOCK_PADDING_MODE = $21;
  EVP_CTRL_SET_PIPELINE_OUTPUT_BUFS = $22;
  EVP_CTRL_SET_PIPELINE_INPUT_BUFS = $23;
  EVP_CTRL_SET_PIPELINE_INPUT_LENS = $24;
  EVP_CTRL_GET_IVLEN = $25;
  
  EVP_PADDING_PKCS7 = 1;
  EVP_PADDING_ISO7816_4 = 2;
  EVP_PADDING_ANSI923 = 3;
  EVP_PADDING_ISO10126 = 4;
  EVP_PADDING_ZERO = 5;
 
  EVP_AEAD_TLS1_AAD_LEN = 13;
  EVP_GCM_TLS_FIXED_IV_LEN = 4;
  EVP_GCM_TLS_EXPLICIT_IV_LEN = 8;
  EVP_GCM_TLS_TAG_LEN = 16;
  EVP_CCM_TLS_FIXED_IV_LEN = 4;
  EVP_CCM_TLS_EXPLICIT_IV_LEN = 8;
  EVP_CCM_TLS_IV_LEN = 12;
  EVP_CCM_TLS_TAG_LEN = 16;
  EVP_CCM8_TLS_TAG_LEN = 8;
  EVP_CHACHAPOLY_TLS_TAG_LEN = 16;
  EVP_PBE_TYPE_OUTER = $0;
  EVP_PBE_TYPE_PRF = $1;
  EVP_PBE_TYPE_KDF = $2;
  
  ASN1_PKEY_ALIAS = $1;
  ASN1_PKEY_DYNAMIC = $2;
  ASN1_PKEY_SIGPARAM_NULL = $4;
  ASN1_PKEY_CTRL_PKCS7_SIGN = $1;
  ASN1_PKEY_CTRL_PKCS7_ENCRYPT = $2;
  ASN1_PKEY_CTRL_DEFAULT_MD_NID = $3;
  ASN1_PKEY_CTRL_CMS_SIGN = $5;
  ASN1_PKEY_CTRL_CMS_ENVELOPE = $7;
  ASN1_PKEY_CTRL_CMS_RI_TYPE = $8;
  ASN1_PKEY_CTRL_SET1_TLS_ENCPT = $9;
  ASN1_PKEY_CTRL_GET1_TLS_ENCPT = $a;
  
  EVP_PKEY_CTRL_MD = 1;
  EVP_PKEY_CTRL_PEER_KEY = 2;
  EVP_PKEY_CTRL_PKCS7_ENCRYPT = 3;
  EVP_PKEY_CTRL_PKCS7_DECRYPT = 4;
  EVP_PKEY_CTRL_PKCS7_SIGN = 5;
  EVP_PKEY_CTRL_SET_MAC_KEY = 6;
  EVP_PKEY_CTRL_DIGESTINIT = 7;
  EVP_PKEY_CTRL_SET_IV = 8;
  EVP_PKEY_CTRL_CMS_ENCRYPT = 9;
  EVP_PKEY_CTRL_CMS_DECRYPT = 10;
  EVP_PKEY_CTRL_CMS_SIGN = 11;
  EVP_PKEY_CTRL_CIPHER = 12;
  EVP_PKEY_CTRL_GET_MD = 13;
  EVP_PKEY_CTRL_SET_DIGEST_SIZE = 14;
  EVP_PKEY_FLAG_AUTOARGLEN = 2;
  EVP_PKEY_FLAG_SIGCTX_CUSTOM = 4;
  
  EC_F_BN_TO_FELEM = 224;
  EC_F_D2I_ECPARAMETERS = 144;
  EC_F_D2I_ECPKPARAMETERS = 145;
  EC_F_D2I_ECPRIVATEKEY = 146;
  EC_F_DO_EC_KEY_PRINT = 221;
  EC_F_ECDH_CMS_DECRYPT = 238;
  EC_F_ECDH_CMS_SET_SHARED_INFO = 239;
  EC_F_ECDH_COMPUTE_KEY = 246;
  EC_F_ECDH_SIMPLE_COMPUTE_KEY = 257;
  EC_F_ECDSA_DO_SIGN_EX = 251;
  EC_F_ECDSA_DO_VERIFY = 252;
  EC_F_ECDSA_SIGN_EX = 254;
  EC_F_ECDSA_SIGN_SETUP = 248;
  EC_F_ECDSA_SIG_NEW = 265;
  EC_F_ECDSA_VERIFY = 253;
  EC_F_ECD_ITEM_VERIFY = 270;
  EC_F_ECKEY_PARAM2TYPE = 223;
  EC_F_ECKEY_PARAM_DECODE = 212;
  EC_F_ECKEY_PRIV_DECODE = 213;
  EC_F_ECKEY_PRIV_ENCODE = 214;
  EC_F_ECKEY_PUB_DECODE = 215;
  EC_F_ECKEY_PUB_ENCODE = 216;
  EC_F_ECKEY_TYPE2PARAM = 220;
  EC_F_ECPARAMETERS_PRINT = 147;
  EC_F_ECPARAMETERS_PRINT_FP = 148;
  EC_F_ECPKPARAMETERS_PRINT = 149;
  EC_F_ECPKPARAMETERS_PRINT_FP = 150;
  EC_F_ECP_NISTZ256_GET_AFFINE = 240;
  EC_F_ECP_NISTZ256_INV_MOD_ORD = 275;
  EC_F_ECP_NISTZ256_MULT_PRECOMPUTE = 243;
  EC_F_ECP_NISTZ256_POINTS_MUL = 241;
  EC_F_ECP_NISTZ256_PRE_COMP_NEW = 244;
  EC_F_ECP_NISTZ256_WINDOWED_MUL = 242;
  EC_F_ECX_KEY_OP = 266;
  EC_F_ECX_PRIV_ENCODE = 267;
  EC_F_ECX_PUB_ENCODE = 268;
  EC_F_EC_ASN1_GROUP2CURVE = 153;
  EC_F_EC_ASN1_GROUP2FIELDID = 154;
  EC_F_EC_GF2M_MONTGOMERY_POINT_MULTIPLY = 208;
  EC_F_EC_GF2M_SIMPLE_FIELD_INV = 296;
  EC_F_EC_GF2M_SIMPLE_GROUP_CHECK_DISCRIMINANT = 159;
  EC_F_EC_GF2M_SIMPLE_GROUP_SET_CURVE = 195;
  EC_F_EC_GF2M_SIMPLE_LADDER_POST = 285;
  EC_F_EC_GF2M_SIMPLE_LADDER_PRE = 288;
  EC_F_EC_GF2M_SIMPLE_OCT2POINT = 160;
  EC_F_EC_GF2M_SIMPLE_POINT2OCT = 161;
  EC_F_EC_GF2M_SIMPLE_POINTS_MUL = 289;
  EC_F_EC_GF2M_SIMPLE_POINT_GET_AFFINE_COORDINATES = 162;
  EC_F_EC_GF2M_SIMPLE_POINT_SET_AFFINE_COORDINATES = 163;
  EC_F_EC_GF2M_SIMPLE_SET_COMPRESSED_COORDINATES = 164;
  EC_F_EC_GFP_MONT_FIELD_DECODE = 133;
  EC_F_EC_GFP_MONT_FIELD_ENCODE = 134;
  EC_F_EC_GFP_MONT_FIELD_INV = 297;
  EC_F_EC_GFP_MONT_FIELD_MUL = 131;
  EC_F_EC_GFP_MONT_FIELD_SET_TO_ONE = 209;
  EC_F_EC_GFP_MONT_FIELD_SQR = 132;
  EC_F_EC_GFP_MONT_GROUP_SET_CURVE = 189;
  EC_F_EC_GFP_NISTP224_GROUP_SET_CURVE = 225;
  EC_F_EC_GFP_NISTP224_POINTS_MUL = 228;
  EC_F_EC_GFP_NISTP224_POINT_GET_AFFINE_COORDINATES = 226;
  EC_F_EC_GFP_NISTP256_GROUP_SET_CURVE = 230;
  EC_F_EC_GFP_NISTP256_POINTS_MUL = 231;
  EC_F_EC_GFP_NISTP256_POINT_GET_AFFINE_COORDINATES = 232;
  EC_F_EC_GFP_NISTP521_GROUP_SET_CURVE = 233;
  EC_F_EC_GFP_NISTP521_POINTS_MUL = 234;
  EC_F_EC_GFP_NISTP521_POINT_GET_AFFINE_COORDINATES = 235;
  EC_F_EC_GFP_NIST_FIELD_MUL = 200;
  EC_F_EC_GFP_NIST_FIELD_SQR = 201;
  EC_F_EC_GFP_NIST_GROUP_SET_CURVE = 202;
  EC_F_EC_GFP_SIMPLE_BLIND_COORDINATES = 287;
  EC_F_EC_GFP_SIMPLE_FIELD_INV = 298;
  EC_F_EC_GFP_SIMPLE_GROUP_CHECK_DISCRIMINANT = 165;
  EC_F_EC_GFP_SIMPLE_GROUP_SET_CURVE = 166;
  EC_F_EC_GFP_SIMPLE_MAKE_AFFINE = 102;
  EC_F_EC_GFP_SIMPLE_OCT2POINT = 103;
  EC_F_EC_GFP_SIMPLE_POINT2OCT = 104;
  EC_F_EC_GFP_SIMPLE_POINTS_MAKE_AFFINE = 137;
  EC_F_EC_GFP_SIMPLE_POINT_GET_AFFINE_COORDINATES = 167;
  EC_F_EC_GFP_SIMPLE_POINT_SET_AFFINE_COORDINATES = 168;
  EC_F_EC_GFP_SIMPLE_SET_COMPRESSED_COORDINATES = 169;
  EC_F_EC_GROUP_CHECK = 170;
  EC_F_EC_GROUP_CHECK_DISCRIMINANT = 171;
  EC_F_EC_GROUP_COPY = 106;
  EC_F_EC_GROUP_GET_CURVE = 291;
  EC_F_EC_GROUP_GET_CURVE_GF2M = 172;
  EC_F_EC_GROUP_GET_CURVE_GFP = 130;
  EC_F_EC_GROUP_GET_DEGREE = 173;
  EC_F_EC_GROUP_GET_ECPARAMETERS = 261;
  EC_F_EC_GROUP_GET_ECPKPARAMETERS = 262;
  EC_F_EC_GROUP_GET_PENTANOMIAL_BASIS = 193;
  EC_F_EC_GROUP_GET_TRINOMIAL_BASIS = 194;
  EC_F_EC_GROUP_NEW = 108;
  EC_F_EC_GROUP_NEW_BY_CURVE_NAME = 174;
  EC_F_EC_GROUP_NEW_FROM_DATA = 175;
  EC_F_EC_GROUP_NEW_FROM_ECPARAMETERS = 263;
  EC_F_EC_GROUP_NEW_FROM_ECPKPARAMETERS = 264;
  EC_F_EC_GROUP_SET_CURVE = 292;
  EC_F_EC_GROUP_SET_CURVE_GF2M = 176;
  EC_F_EC_GROUP_SET_CURVE_GFP = 109;
  EC_F_EC_GROUP_SET_GENERATOR = 111;
  EC_F_EC_GROUP_SET_SEED = 286;
  EC_F_EC_KEY_CHECK_KEY = 177;
  EC_F_EC_KEY_COPY = 178;
  EC_F_EC_KEY_GENERATE_KEY = 179;
  EC_F_EC_KEY_NEW = 182;
  EC_F_EC_KEY_NEW_METHOD = 245;
  EC_F_EC_KEY_OCT2PRIV = 255;
  EC_F_EC_KEY_PRINT = 180;
  EC_F_EC_KEY_PRINT_FP = 181;
  EC_F_EC_KEY_PRIV2BUF = 279;
  EC_F_EC_KEY_PRIV2OCT = 256;
  EC_F_EC_KEY_SET_PUBLIC_KEY_AFFINE_COORDINATES = 229;
  EC_F_EC_KEY_SIMPLE_CHECK_KEY = 258;
  EC_F_EC_KEY_SIMPLE_OCT2PRIV = 259;
  EC_F_EC_KEY_SIMPLE_PRIV2OCT = 260;
  EC_F_EC_PKEY_CHECK = 273;
  EC_F_EC_PKEY_PARAM_CHECK = 274;
  EC_F_EC_POINTS_MAKE_AFFINE = 136;
  EC_F_EC_POINTS_MUL = 290;
  EC_F_EC_POINT_ADD = 112;
  EC_F_EC_POINT_BN2POINT = 280;
  EC_F_EC_POINT_CMP = 113;
  EC_F_EC_POINT_COPY = 114;
  EC_F_EC_POINT_DBL = 115;
  EC_F_EC_POINT_GET_AFFINE_COORDINATES = 293;
  EC_F_EC_POINT_GET_AFFINE_COORDINATES_GF2M = 183;
  EC_F_EC_POINT_GET_AFFINE_COORDINATES_GFP = 116;
  EC_F_EC_POINT_GET_JPROJECTIVE_COORDINATES_GFP = 117;
  EC_F_EC_POINT_INVERT = 210;
  EC_F_EC_POINT_IS_AT_INFINITY = 118;
  EC_F_EC_POINT_IS_ON_CURVE = 119;
  EC_F_EC_POINT_MAKE_AFFINE = 120;
  EC_F_EC_POINT_NEW = 121;
  EC_F_EC_POINT_OCT2POINT = 122;
  EC_F_EC_POINT_POINT2BUF = 281;
  EC_F_EC_POINT_POINT2OCT = 123;
  EC_F_EC_POINT_SET_AFFINE_COORDINATES = 294;
  EC_F_EC_POINT_SET_AFFINE_COORDINATES_GF2M = 185;
  EC_F_EC_POINT_SET_AFFINE_COORDINATES_GFP = 124;
  EC_F_EC_POINT_SET_COMPRESSED_COORDINATES = 295;
  EC_F_EC_POINT_SET_COMPRESSED_COORDINATES_GF2M = 186;
  EC_F_EC_POINT_SET_COMPRESSED_COORDINATES_GFP = 125;
  EC_F_EC_POINT_SET_JPROJECTIVE_COORDINATES_GFP = 126;
  EC_F_EC_POINT_SET_TO_INFINITY = 127;
  EC_F_EC_PRE_COMP_NEW = 196;
  EC_F_EC_SCALAR_MUL_LADDER = 284;
  EC_F_EC_WNAF_MUL = 187;
  EC_F_EC_WNAF_PRECOMPUTE_MULT = 188;
  
  EC_F_I2D_ECPARAMETERS = 190;
  EC_F_I2D_ECPKPARAMETERS = 191;
  EC_F_I2D_ECPRIVATEKEY = 192;
  EC_F_I2O_ECPUBLICKEY = 151;
  
  EC_F_NISTP224_PRE_COMP_NEW = 227;
  EC_F_NISTP256_PRE_COMP_NEW = 236;
  EC_F_NISTP521_PRE_COMP_NEW = 237;
  
  EC_F_O2I_ECPUBLICKEY = 152;
  EC_F_OLD_EC_PRIV_DECODE = 222;
  EC_F_OSSL_ECDH_COMPUTE_KEY = 247;
  EC_F_OSSL_ECDSA_SIGN_SIG = 249;
  EC_F_OSSL_ECDSA_VERIFY_SIG = 250;
  
  EC_F_PKEY_ECD_CTRL = 271;
  EC_F_PKEY_ECD_DIGESTSIGN = 272;
  EC_F_PKEY_ECD_DIGESTSIGN25519 = 276;
  EC_F_PKEY_ECD_DIGESTSIGN448 = 277;
  EC_F_PKEY_ECX_DERIVE = 269;
  EC_F_PKEY_EC_CTRL = 197;
  EC_F_PKEY_EC_CTRL_STR = 198;
  EC_F_PKEY_EC_DERIVE = 217;
  EC_F_PKEY_EC_INIT = 282;
  EC_F_PKEY_EC_KDF_DERIVE = 283;
  EC_F_PKEY_EC_KEYGEN = 199;
  EC_F_PKEY_EC_PARAMGEN = 219;
  EC_F_PKEY_EC_SIGN = 218;  
  EC_F_VALIDATE_ECX_DERIVE = 278;
  
  EC_R_ASN1_ERROR = 115;
  EC_R_BAD_SIGNATURE = 156;
  EC_R_BIGNUM_OUT_OF_RANGE = 144;
  EC_R_BUFFER_TOO_SMALL = 100;
  EC_R_CANNOT_INVERT = 165;
  EC_R_COORDINATES_OUT_OF_RANGE = 146;
  EC_R_CURVE_DOES_NOT_SUPPORT_ECDH = 160;
  EC_R_CURVE_DOES_NOT_SUPPORT_SIGNING = 159;
  EC_R_D2I_ECPKPARAMETERS_FAILURE = 117;
  EC_R_DECODE_ERROR = 142;
  EC_R_DISCRIMINANT_IS_ZERO = 118;
  EC_R_EC_GROUP_NEW_BY_NAME_FAILURE = 119;
  EC_R_FIELD_TOO_LARGE = 143;
  EC_R_GF2M_NOT_SUPPORTED = 147;
  EC_R_GROUP2PKPARAMETERS_FAILURE = 120;
  EC_R_I2D_ECPKPARAMETERS_FAILURE = 121;
  EC_R_INCOMPATIBLE_OBJECTS = 101;
  EC_R_INVALID_ARGUMENT = 112;
  EC_R_INVALID_COMPRESSED_POINT = 110;
  EC_R_INVALID_COMPRESSION_BIT = 109;
  EC_R_INVALID_CURVE = 141;
  EC_R_INVALID_DIGEST = 151;
  EC_R_INVALID_DIGEST_TYPE = 138;
  EC_R_INVALID_ENCODING = 102;
  EC_R_INVALID_FIELD = 103;
  EC_R_INVALID_FORM = 104;
  EC_R_INVALID_GROUP_ORDER = 122;
  EC_R_INVALID_KEY = 116;
  EC_R_INVALID_OUTPUT_LENGTH = 161;
  EC_R_INVALID_PEER_KEY = 133;
  EC_R_INVALID_PENTANOMIAL_BASIS = 132;
  EC_R_INVALID_PRIVATE_KEY = 123;
  EC_R_INVALID_TRINOMIAL_BASIS = 137;
  EC_R_KDF_PARAMETER_ERROR = 148;
  EC_R_KEYS_NOT_SET = 140;
  EC_R_LADDER_POST_FAILURE = 136;
  EC_R_LADDER_PRE_FAILURE = 153;
  EC_R_LADDER_STEP_FAILURE = 162;
  EC_R_MISSING_PARAMETERS = 124;
  EC_R_MISSING_PRIVATE_KEY = 125;
  EC_R_NEED_NEW_SETUP_VALUES = 157;
  EC_R_NOT_A_NIST_PRIME = 135;
  EC_R_NOT_IMPLEMENTED = 126;
  EC_R_NOT_INITIALIZED = 111;
  EC_R_NO_PARAMETERS_SET = 139;
  EC_R_NO_PRIVATE_VALUE = 154;
  EC_R_OPERATION_NOT_SUPPORTED = 152;
  EC_R_PASSED_NULL_PARAMETER = 134;
  EC_R_PEER_KEY_ERROR = 149;
  EC_R_PKPARAMETERS2GROUP_FAILURE = 127;
  EC_R_POINT_ARITHMETIC_FAILURE = 155;
  EC_R_POINT_AT_INFINITY = 106;
  EC_R_POINT_COORDINATES_BLIND_FAILURE = 163;
  EC_R_POINT_IS_NOT_ON_CURVE = 107;
  EC_R_RANDOM_NUMBER_GENERATION_FAILED = 158;
  EC_R_SHARED_INFO_ERROR = 150;
  EC_R_SLOT_FULL = 108;
  EC_R_UNDEFINED_GENERATOR = 113;
  EC_R_UNDEFINED_ORDER = 128;
  EC_R_UNKNOWN_COFACTOR = 164;
  EC_R_UNKNOWN_GROUP = 129;
  EC_R_UNKNOWN_ORDER = 114;
  EC_R_UNSUPPORTED_FIELD = 131;
  EC_R_WRONG_CURVE_PARAMETERS = 145;
  EC_R_WRONG_ORDER = 130;
  
  OPENSSL_ECC_MAX_FIELD_BITS = 661;
  OPENSSL_EC_EXPLICIT_CURVE = $000;
  OPENSSL_EC_NAMED_CURVE = $001;
  
  EC_PKEY_NO_PARAMETERS = $001;
  EC_PKEY_NO_PUBKEY = $002;
  
  EC_FLAG_NON_FIPS_ALLOW = $1;
  EC_FLAG_FIPS_CHECKED = $2;
  EC_FLAG_COFACTOR_ECDH = $1000;
  
  EVP_PKEY_CTRL_EC_PARAM_ENC = EVP_PKEY_ALG_CTRL + 2;
  EVP_PKEY_CTRL_EC_ECDH_COFACTOR = EVP_PKEY_ALG_CTRL + 3;
  EVP_PKEY_CTRL_EC_KDF_TYPE = EVP_PKEY_ALG_CTRL + 4;
  EVP_PKEY_CTRL_EC_KDF_MD = EVP_PKEY_ALG_CTRL + 5;
  EVP_PKEY_CTRL_GET_EC_KDF_MD = EVP_PKEY_ALG_CTRL + 6;
  EVP_PKEY_CTRL_EC_KDF_OUTLEN = EVP_PKEY_ALG_CTRL + 7;
  EVP_PKEY_CTRL_GET_EC_KDF_OUTLEN = EVP_PKEY_ALG_CTRL + 8;
  EVP_PKEY_CTRL_EC_KDF_UKM = EVP_PKEY_ALG_CTRL + 9;
  EVP_PKEY_CTRL_GET_EC_KDF_UKM = EVP_PKEY_ALG_CTRL + 10;
  EVP_PKEY_CTRL_SET1_ID = EVP_PKEY_ALG_CTRL + 11;
  EVP_PKEY_CTRL_GET1_ID = EVP_PKEY_ALG_CTRL + 12;
  EVP_PKEY_CTRL_GET1_ID_LEN = EVP_PKEY_ALG_CTRL + 13;
  
  EVP_PKEY_ECDH_KDF_NONE = 1;
  EVP_PKEY_ECDH_KDF_X9_63 = 2;
  EVP_PKEY_ECDH_KDF_X9_62 = EVP_PKEY_ECDH_KDF_X9_63;
  
  RSA_F_CHECK_PADDING_MD = 140;
  RSA_F_ENCODE_PKCS1 = 146;
  RSA_F_INT_RSA_VERIFY = 145;
  RSA_F_OLD_RSA_PRIV_DECODE = 147;
  RSA_F_PKEY_PSS_INIT = 165;
  RSA_F_PKEY_RSA_CTRL = 143;
  RSA_F_PKEY_RSA_CTRL_STR = 144;
  RSA_F_PKEY_RSA_SIGN = 142;
  RSA_F_PKEY_RSA_VERIFY = 149;
  RSA_F_PKEY_RSA_VERIFYRECOVER = 141;
  RSA_F_RSA_ALGOR_TO_MD = 156;
  RSA_F_RSA_BUILTIN_KEYGEN = 129;
  RSA_F_RSA_CHECK_KEY = 123;
  RSA_F_RSA_CHECK_KEY_EX = 160;
  RSA_F_RSA_CMS_DECRYPT = 159;
  RSA_F_RSA_CMS_VERIFY = 158;
  RSA_F_RSA_ITEM_VERIFY = 148;
  RSA_F_RSA_METH_DUP = 161;
  RSA_F_RSA_METH_NEW = 162;
  RSA_F_RSA_METH_SET1_NAME = 163;
  RSA_F_RSA_MGF1_TO_MD = 157;
  RSA_F_RSA_MULTIP_INFO_NEW = 166;
  RSA_F_RSA_NEW_METHOD = 106;
  RSA_F_RSA_NULL = 124;
  RSA_F_RSA_NULL_PRIVATE_DECRYPT = 132;
  RSA_F_RSA_NULL_PRIVATE_ENCRYPT = 133;
  RSA_F_RSA_NULL_PUBLIC_DECRYPT = 134;
  RSA_F_RSA_NULL_PUBLIC_ENCRYPT = 135;
  RSA_F_RSA_OSSL_PRIVATE_DECRYPT = 101;
  RSA_F_RSA_OSSL_PRIVATE_ENCRYPT = 102;
  RSA_F_RSA_OSSL_PUBLIC_DECRYPT = 103;
  RSA_F_RSA_OSSL_PUBLIC_ENCRYPT = 104;
  RSA_F_RSA_PADDING_ADD_NONE = 107;
  RSA_F_RSA_PADDING_ADD_PKCS1_OAEP = 121;
  RSA_F_RSA_PADDING_ADD_PKCS1_OAEP_MGF1 = 154;
  RSA_F_RSA_PADDING_ADD_PKCS1_PSS = 125;
  RSA_F_RSA_PADDING_ADD_PKCS1_PSS_MGF1 = 152;
  RSA_F_RSA_PADDING_ADD_PKCS1_TYPE_1 = 108;
  RSA_F_RSA_PADDING_ADD_PKCS1_TYPE_2 = 109;
  RSA_F_RSA_PADDING_ADD_SSLV23 = 110;
  RSA_F_RSA_PADDING_ADD_X931 = 127;
  RSA_F_RSA_PADDING_CHECK_NONE = 111;
  RSA_F_RSA_PADDING_CHECK_PKCS1_OAEP = 122;
  RSA_F_RSA_PADDING_CHECK_PKCS1_OAEP_MGF1 = 153;
  RSA_F_RSA_PADDING_CHECK_PKCS1_TYPE_1 = 112;
  RSA_F_RSA_PADDING_CHECK_PKCS1_TYPE_2 = 113;
  RSA_F_RSA_PADDING_CHECK_SSLV23 = 114;
  RSA_F_RSA_PADDING_CHECK_X931 = 128;
  RSA_F_RSA_PARAM_DECODE = 164;
  RSA_F_RSA_PRINT = 115;
  RSA_F_RSA_PRINT_FP = 116;
  RSA_F_RSA_PRIV_DECODE = 150;
  RSA_F_RSA_PRIV_ENCODE = 138;
  RSA_F_RSA_PSS_GET_PARAM = 151;
  RSA_F_RSA_PSS_TO_CTX = 155;
  RSA_F_RSA_PUB_DECODE = 139;
  RSA_F_RSA_SETUP_BLINDING = 136;
  RSA_F_RSA_SIGN = 117;
  RSA_F_RSA_SIGN_ASN1_OCTET_STRING = 118;
  RSA_F_RSA_VERIFY = 119;
  RSA_F_RSA_VERIFY_ASN1_OCTET_STRING = 120;
  RSA_F_RSA_VERIFY_PKCS1_PSS_MGF1 = 126;  
  RSA_F_SETUP_TBUF = 167;
  
  RSA_R_ALGORITHM_MISMATCH = 100;
  RSA_R_BAD_E_VALUE = 101;
  RSA_R_BAD_FIXED_HEADER_DECRYPT = 102;
  RSA_R_BAD_PAD_BYTE_COUNT = 103;
  RSA_R_BAD_SIGNATURE = 104;
  RSA_R_BLOCK_TYPE_IS_NOT_01 = 106;
  RSA_R_BLOCK_TYPE_IS_NOT_02 = 107;
  RSA_R_DATA_GREATER_THAN_MOD_LEN = 108;
  RSA_R_DATA_TOO_LARGE = 109;
  RSA_R_DATA_TOO_LARGE_FOR_KEY_SIZE = 110;
  RSA_R_DATA_TOO_LARGE_FOR_MODULUS = 132;
  RSA_R_DATA_TOO_SMALL = 111;
  RSA_R_DATA_TOO_SMALL_FOR_KEY_SIZE = 122;
  RSA_R_DIGEST_DOES_NOT_MATCH = 158;
  RSA_R_DIGEST_NOT_ALLOWED = 145;
  RSA_R_DIGEST_TOO_BIG_FOR_RSA_KEY = 112;
  RSA_R_DMP1_NOT_CONGRUENT_TO_D = 124;
  RSA_R_DMQ1_NOT_CONGRUENT_TO_D = 125;
  RSA_R_D_E_NOT_CONGRUENT_TO_1 = 123;
  RSA_R_FIRST_OCTET_INVALID = 133;
  RSA_R_ILLEGAL_OR_UNSUPPORTED_PADDING_MODE = 144;
  RSA_R_INVALID_DIGEST = 157;
  RSA_R_INVALID_DIGEST_LENGTH = 143;
  RSA_R_INVALID_HEADER = 137;
  RSA_R_INVALID_LABEL = 160;
  RSA_R_INVALID_MESSAGE_LENGTH = 131;
  RSA_R_INVALID_MGF1_MD = 156;
  RSA_R_INVALID_MULTI_PRIME_KEY = 167;
  RSA_R_INVALID_OAEP_PARAMETERS = 161;
  RSA_R_INVALID_PADDING = 138;
  RSA_R_INVALID_PADDING_MODE = 141;
  RSA_R_INVALID_PSS_PARAMETERS = 149;
  RSA_R_INVALID_PSS_SALTLEN = 146;
  RSA_R_INVALID_SALT_LENGTH = 150;
  RSA_R_INVALID_TRAILER = 139;
  RSA_R_INVALID_X931_DIGEST = 142;
  RSA_R_IQMP_NOT_INVERSE_OF_Q = 126;
  RSA_R_KEY_PRIME_NUM_INVALID = 165;
  RSA_R_KEY_SIZE_TOO_SMALL = 120;
  RSA_R_LAST_OCTET_INVALID = 134;
  RSA_R_MISSING_PRIVATE_KEY = 179;
  RSA_R_MGF1_DIGEST_NOT_ALLOWED = 152;
  RSA_R_MODULUS_TOO_LARGE = 105;
  RSA_R_MP_COEFFICIENT_NOT_INVERSE_OF_R = 168;
  RSA_R_MP_EXPONENT_NOT_CONGRUENT_TO_D = 169;
  RSA_R_MP_R_NOT_PRIME = 170;
  RSA_R_NO_PUBLIC_EXPONENT = 140;
  RSA_R_NULL_BEFORE_BLOCK_MISSING = 113;
  RSA_R_N_DOES_NOT_EQUAL_PRODUCT_OF_PRIMES = 172;
  RSA_R_N_DOES_NOT_EQUAL_P_Q = 127;
  RSA_R_OAEP_DECODING_ERROR = 121;
  RSA_R_OPERATION_NOT_SUPPORTED_FOR_THIS_KEYTYPE = 148;
  RSA_R_PADDING_CHECK_FAILED = 114;
  RSA_R_PKCS_DECODING_ERROR = 159;
  RSA_R_PSS_SALTLEN_TOO_SMALL = 164;
  RSA_R_P_NOT_PRIME = 128;
  RSA_R_Q_NOT_PRIME = 129;
  RSA_R_RSA_OPERATIONS_NOT_SUPPORTED = 130;
  RSA_R_SLEN_CHECK_FAILED = 136;
  RSA_R_SLEN_RECOVERY_FAILED = 135;
  RSA_R_SSLV3_ROLLBACK_ATTACK = 115;
  RSA_R_THE_ASN1_OBJECT_IDENTIFIER_IS_NOT_KNOWN_FOR_THIS_MD = 116;
  RSA_R_UNKNOWN_ALGORITHM_TYPE = 117;
  RSA_R_UNKNOWN_DIGEST = 166;
  RSA_R_UNKNOWN_MASK_DIGEST = 151;
  RSA_R_UNKNOWN_PADDING_TYPE = 118;
  RSA_R_UNSUPPORTED_ENCRYPTION_TYPE = 162;
  RSA_R_UNSUPPORTED_LABEL_SOURCE = 163;
  RSA_R_UNSUPPORTED_MASK_ALGORITHM = 153;
  RSA_R_UNSUPPORTED_MASK_PARAMETER = 154;
  RSA_R_UNSUPPORTED_SIGNATURE_TYPE = 155;
  RSA_R_VALUE_MISSING = 147;
  RSA_R_WRONG_SIGNATURE_LENGTH = 119;
  
  OPENSSL_RSA_MAX_MODULUS_BITS = 16384;
  OPENSSL_RSA_FIPS_MIN_MODULUS_BITS = 1024;
  OPENSSL_RSA_SMALL_MODULUS_BITS = 3072;
  OPENSSL_RSA_MAX_PUBEXP_BITS = 64;
  
  RSA_3 = $3;
  RSA_F4 = $10001;
  RSA_ASN1_VERSION_DEFAULT = 0;
  RSA_ASN1_VERSION_MULTI = 1;
  RSA_DEFAULT_PRIME_NUM = 2;
  RSA_METHOD_FLAG_NO_CHECK = $0001;
  RSA_FLAG_CACHE_PUBLIC = $0002;
  RSA_FLAG_CACHE_PRIVATE = $0004;
  RSA_FLAG_BLINDING = $0008;
  RSA_FLAG_THREAD_SAFE = $0010;
  RSA_FLAG_EXT_PKEY = $0020;
  RSA_FLAG_NO_BLINDING = $0080;
  RSA_FLAG_NO_CONSTTIME = $0000;
  RSA_FLAG_NO_EXP_CONSTTIME = RSA_FLAG_NO_CONSTTIME;
  RSA_PSS_SALTLEN_DIGEST = -1;
  RSA_PSS_SALTLEN_AUTO = -2;
  RSA_PSS_SALTLEN_MAX = -3;
  RSA_PSS_SALTLEN_MAX_SIGN = -2;
  
  DH_F_COMPUTE_KEY = 102;
  DH_F_DHPARAMS_PRINT_FP = 101;
  DH_F_DH_BUILTIN_GENPARAMS = 106;
  DH_F_DH_CHECK_EX = 121;
  DH_F_DH_CHECK_PARAMS_EX = 122;
  DH_F_DH_CHECK_PUB_KEY_EX = 123;
  DH_F_DH_CMS_DECRYPT = 114;
  DH_F_DH_CMS_SET_PEERKEY = 115;
  DH_F_DH_CMS_SET_SHARED_INFO = 116;
  DH_F_DH_METH_DUP = 117;
  DH_F_DH_METH_NEW = 118;
  DH_F_DH_METH_SET1_NAME = 119;
  DH_F_DH_NEW_BY_NID = 104;
  DH_F_DH_NEW_METHOD = 105;
  DH_F_DH_PARAM_DECODE = 107;
  DH_F_DH_PKEY_PUBLIC_CHECK = 124;
  DH_F_DH_PRIV_DECODE = 110;
  DH_F_DH_PRIV_ENCODE = 111;
  DH_F_DH_PUB_DECODE = 108;
  DH_F_DH_PUB_ENCODE = 109;
  DH_F_DO_DH_PRINT = 100;
  DH_F_GENERATE_KEY = 103;
  DH_F_PKEY_DH_CTRL_STR = 120;
  DH_F_PKEY_DH_DERIVE = 112;
  DH_F_PKEY_DH_INIT = 125;
  DH_F_PKEY_DH_KEYGEN = 113;
  
  DH_R_BAD_GENERATOR = 101;
  DH_R_BN_DECODE_ERROR = 109;
  DH_R_BN_ERROR = 106;
  DH_R_CHECK_INVALID_J_VALUE = 115;
  DH_R_CHECK_INVALID_Q_VALUE = 116;
  DH_R_CHECK_PUBKEY_INVALID = 122;
  DH_R_CHECK_PUBKEY_TOO_LARGE = 123;
  DH_R_CHECK_PUBKEY_TOO_SMALL = 124;
  DH_R_CHECK_P_NOT_PRIME = 117;
  DH_R_CHECK_P_NOT_SAFE_PRIME = 118;
  DH_R_CHECK_Q_NOT_PRIME = 119;
  DH_R_DECODE_ERROR = 104;
  DH_R_INVALID_PARAMETER_NAME = 110;
  DH_R_INVALID_PARAMETER_NID = 114;
  DH_R_INVALID_PUBKEY = 102;
  DH_R_KDF_PARAMETER_ERROR = 112;
  DH_R_KEYS_NOT_SET = 108;
  DH_R_MISSING_PUBKEY = 125;
  DH_R_MODULUS_TOO_LARGE = 103;
  DH_R_NOT_SUITABLE_GENERATOR = 120;
  DH_R_NO_PARAMETERS_SET = 107;
  DH_R_NO_PRIVATE_VALUE = 100;
  DH_R_PARAMETER_ENCODING_ERROR = 105;
  DH_R_PEER_KEY_ERROR = 111;
  DH_R_SHARED_INFO_ERROR = 113;
  DH_R_UNABLE_TO_CHECK_GENERATOR = 121;
  
  OPENSSL_DH_MAX_MODULUS_BITS = 10000;
  OPENSSL_DH_FIPS_MIN_MODULUS_BITS = 1024;
  
  DH_FLAG_CACHE_MONT_P = $01;
  DH_FLAG_NO_EXP_CONSTTIME = $00;
  DH_FLAG_FIPS_METHOD = $0400;
  DH_FLAG_NON_FIPS_ALLOW = $0400;
  DH_GENERATOR_2 = 2;
  DH_GENERATOR_5 = 5;
  DH_CHECK_P_NOT_PRIME = $01;
  DH_CHECK_P_NOT_SAFE_PRIME = $02;
  DH_UNABLE_TO_CHECK_GENERATOR = $04;
  DH_NOT_SUITABLE_GENERATOR = $08;
  DH_CHECK_Q_NOT_PRIME = $10;
  DH_CHECK_INVALID_Q_VALUE = $20;
  DH_CHECK_INVALID_J_VALUE = $40;
  DH_CHECK_PUBKEY_TOO_SMALL = $01;
  DH_CHECK_PUBKEY_TOO_LARGE = $02;
  DH_CHECK_PUBKEY_INVALID = $04;
  DH_CHECK_P_NOT_STRONG_PRIME = DH_CHECK_P_NOT_SAFE_PRIME;
  
  EVP_PKEY_CTRL_DH_PARAMGEN_PRIME_LEN = EVP_PKEY_ALG_CTRL + 1;
  EVP_PKEY_CTRL_DH_PARAMGEN_GENERATOR = EVP_PKEY_ALG_CTRL + 2;
  EVP_PKEY_CTRL_DH_RFC5114 = EVP_PKEY_ALG_CTRL + 3;
  EVP_PKEY_CTRL_DH_PARAMGEN_SUBPRIME_LEN = EVP_PKEY_ALG_CTRL + 4;
  EVP_PKEY_CTRL_DH_PARAMGEN_TYPE = EVP_PKEY_ALG_CTRL + 5;
  EVP_PKEY_CTRL_DH_KDF_TYPE = EVP_PKEY_ALG_CTRL + 6;
  EVP_PKEY_CTRL_DH_KDF_MD = EVP_PKEY_ALG_CTRL + 7;
  EVP_PKEY_CTRL_GET_DH_KDF_MD = EVP_PKEY_ALG_CTRL + 8;
  EVP_PKEY_CTRL_DH_KDF_OUTLEN = EVP_PKEY_ALG_CTRL + 9;
  EVP_PKEY_CTRL_GET_DH_KDF_OUTLEN = EVP_PKEY_ALG_CTRL + 10;
  EVP_PKEY_CTRL_DH_KDF_UKM = EVP_PKEY_ALG_CTRL + 11;
  EVP_PKEY_CTRL_GET_DH_KDF_UKM = EVP_PKEY_ALG_CTRL + 12;
  EVP_PKEY_CTRL_DH_KDF_OID = EVP_PKEY_ALG_CTRL + 13;
  EVP_PKEY_CTRL_GET_DH_KDF_OID = EVP_PKEY_ALG_CTRL + 14;
  EVP_PKEY_CTRL_DH_NID = EVP_PKEY_ALG_CTRL + 15;
  EVP_PKEY_CTRL_DH_PAD = EVP_PKEY_ALG_CTRL + 16;
  EVP_PKEY_DH_KDF_NONE = 1;
  EVP_PKEY_DH_KDF_X9_42 = 2;
  
  DSA_F_DSAPARAMS_PRINT = 100;
  DSA_F_DSAPARAMS_PRINT_FP = 101;
  DSA_F_DSA_BUILTIN_PARAMGEN = 125;
  DSA_F_DSA_BUILTIN_PARAMGEN2 = 126;
  DSA_F_DSA_DO_SIGN = 112;
  DSA_F_DSA_DO_VERIFY = 113;
  DSA_F_DSA_METH_DUP = 127;
  DSA_F_DSA_METH_NEW = 128;
  DSA_F_DSA_METH_SET1_NAME = 129;
  DSA_F_DSA_NEW_METHOD = 103;
  DSA_F_DSA_PARAM_DECODE = 119;
  DSA_F_DSA_PRINT_FP = 105;
  DSA_F_DSA_PRIV_DECODE = 115;
  DSA_F_DSA_PRIV_ENCODE = 116;
  DSA_F_DSA_PUB_DECODE = 117;
  DSA_F_DSA_PUB_ENCODE = 118;
  DSA_F_DSA_SIGN = 106;
  DSA_F_DSA_SIGN_SETUP = 107;
  DSA_F_DSA_SIG_NEW = 102;
  DSA_F_OLD_DSA_PRIV_DECODE = 122;
  DSA_F_PKEY_DSA_CTRL = 120;
  DSA_F_PKEY_DSA_CTRL_STR = 104;
  DSA_F_PKEY_DSA_KEYGEN = 121;
  
  DSA_R_BAD_Q_VALUE = 102;
  DSA_R_BN_DECODE_ERROR = 108;
  DSA_R_BN_ERROR = 109;
  DSA_R_DECODE_ERROR = 104;
  DSA_R_INVALID_DIGEST_TYPE = 106;
  DSA_R_INVALID_PARAMETERS = 112;
  DSA_R_MISSING_PARAMETERS = 101;
  DSA_R_MISSING_PRIVATE_KEY = 111;
  DSA_R_MODULUS_TOO_LARGE = 103;
  DSA_R_NO_PARAMETERS_SET = 107;
  DSA_R_PARAMETER_ENCODING_ERROR = 105;
  DSA_R_Q_NOT_PRIME = 113;
  DSA_R_SEED_LEN_SMALL = 110;
  
  OPENSSL_DSA_MAX_MODULUS_BITS = 10000;
  OPENSSL_DSA_FIPS_MIN_MODULUS_BITS = 1024;
  
  DSA_FLAG_CACHE_MONT_P = $01;
  DSA_FLAG_NO_EXP_CONSTTIME = $00;
  DSA_FLAG_FIPS_METHOD = $0400;
  DSA_FLAG_NON_FIPS_ALLOW = $0400;
  DSA_FLAG_FIPS_CHECKED = $0800;
  DSS_prime_checks = 64;
  
  EVP_PKEY_CTRL_DSA_PARAMGEN_Q_BITS = EVP_PKEY_ALG_CTRL + 2;
  EVP_PKEY_CTRL_DSA_PARAMGEN_MD = EVP_PKEY_ALG_CTRL + 3;
  
  SHA_LBLOCK = 16;
  SHA_CBLOCK = SHA_LBLOCK*4;
  SHA_LAST_BLOCK = SHA_CBLOCK-8;
  SHA_DIGEST_LENGTH = 20;
  
  SHA256_CBLOCK = SHA_LBLOCK*4;
  SHA224_DIGEST_LENGTH = 28;
  SHA256_DIGEST_LENGTH = 32;
  SHA384_DIGEST_LENGTH = 48;
  SHA512_DIGEST_LENGTH = 64;
  SHA512_CBLOCK = SHA_LBLOCK*8;
  
  X509_F_ADD_CERT_DIR = 100;
  X509_F_BUILD_CHAIN = 106;
  X509_F_BY_FILE_CTRL = 101;
  X509_F_CHECK_NAME_CONSTRAINTS = 149;
  X509_F_CHECK_POLICY = 145;
  X509_F_DANE_I2D = 107;
  X509_F_DIR_CTRL = 102;
  X509_F_GET_CERT_BY_SUBJECT = 103;
  X509_F_I2D_X509_AUX = 151;
  X509_F_LOOKUP_CERTS_SK = 152;
  X509_F_NETSCAPE_SPKI_B64_DECODE = 129;
  X509_F_NETSCAPE_SPKI_B64_ENCODE = 130;
  X509_F_NEW_DIR = 153;
  
  X509_F_X509AT_ADD1_ATTR = 135;
  X509_F_X509V3_ADD_EXT = 104;
  X509_F_X509_ATTRIBUTE_CREATE_BY_NID = 136;
  X509_F_X509_ATTRIBUTE_CREATE_BY_OBJ = 137;
  X509_F_X509_ATTRIBUTE_CREATE_BY_TXT = 140;
  X509_F_X509_ATTRIBUTE_GET0_DATA = 139;
  X509_F_X509_ATTRIBUTE_SET1_DATA = 138;
  X509_F_X509_CHECK_PRIVATE_KEY = 128;
  X509_F_X509_CRL_DIFF = 105;
  X509_F_X509_CRL_METHOD_NEW = 154;
  X509_F_X509_CRL_PRINT_FP = 147;
  X509_F_X509_EXTENSION_CREATE_BY_NID = 108;
  X509_F_X509_EXTENSION_CREATE_BY_OBJ = 109;
  X509_F_X509_GET_PUBKEY_PARAMETERS = 110;
  X509_F_X509_LOAD_CERT_CRL_FILE = 132;
  X509_F_X509_LOAD_CERT_FILE = 111;
  X509_F_X509_LOAD_CRL_FILE = 112;
  X509_F_X509_LOOKUP_METH_NEW = 160;
  X509_F_X509_LOOKUP_NEW = 155;
  X509_F_X509_NAME_ADD_ENTRY = 113;
  X509_F_X509_NAME_CANON = 156;
  X509_F_X509_NAME_ENTRY_CREATE_BY_NID = 114;
  X509_F_X509_NAME_ENTRY_CREATE_BY_TXT = 131;
  X509_F_X509_NAME_ENTRY_SET_OBJECT = 115;
  X509_F_X509_NAME_ONELINE = 116;
  X509_F_X509_NAME_PRINT = 117;
  X509_F_X509_OBJECT_NEW = 150;
  X509_F_X509_PRINT_EX_FP = 118;
  X509_F_X509_PUBKEY_DECODE = 148;
  X509_F_X509_PUBKEY_GET0 = 119;
  X509_F_X509_PUBKEY_SET = 120;
  X509_F_X509_REQ_CHECK_PRIVATE_KEY = 144;
  X509_F_X509_REQ_PRINT_EX = 121;
  X509_F_X509_REQ_PRINT_FP = 122;
  X509_F_X509_REQ_TO_X509 = 123;
  X509_F_X509_STORE_ADD_CERT = 124;
  X509_F_X509_STORE_ADD_CRL = 125;
  X509_F_X509_STORE_ADD_LOOKUP = 157;
  X509_F_X509_STORE_CTX_GET1_ISSUER = 146;
  X509_F_X509_STORE_CTX_INIT = 143;
  X509_F_X509_STORE_CTX_NEW = 142;
  X509_F_X509_STORE_CTX_PURPOSE_INHERIT = 134;
  X509_F_X509_STORE_NEW = 158;
  X509_F_X509_TO_X509_REQ = 126;
  X509_F_X509_TRUST_ADD = 133;
  X509_F_X509_TRUST_SET = 141;
  X509_F_X509_VERIFY_CERT = 127;
  X509_F_X509_VERIFY_PARAM_NEW = 159;
  
  X509_R_AKID_MISMATCH = 110;
  X509_R_BAD_SELECTOR = 133;
  X509_R_BAD_X509_FILETYPE = 100;
  X509_R_BASE64_DECODE_ERROR = 118;
  X509_R_CANT_CHECK_DH_KEY = 114;
  X509_R_CERT_ALREADY_IN_HASH_TABLE = 101;
  X509_R_CRL_ALREADY_DELTA = 127;
  X509_R_CRL_VERIFY_FAILURE = 131;
  X509_R_IDP_MISMATCH = 128;
  X509_R_INVALID_ATTRIBUTES = 138;
  X509_R_INVALID_DIRECTORY = 113;
  X509_R_INVALID_FIELD_NAME = 119;
  X509_R_INVALID_TRUST = 123;
  X509_R_ISSUER_MISMATCH = 129;
  X509_R_KEY_TYPE_MISMATCH = 115;
  X509_R_KEY_VALUES_MISMATCH = 116;
  X509_R_LOADING_CERT_DIR = 103;
  X509_R_LOADING_DEFAULTS = 104;
  X509_R_METHOD_NOT_SUPPORTED = 124;
  X509_R_NAME_TOO_LONG = 134;
  X509_R_NEWER_CRL_NOT_NEWER = 132;
  X509_R_NO_CERTIFICATE_FOUND = 135;
  X509_R_NO_CERTIFICATE_OR_CRL_FOUND = 136;
  X509_R_NO_CERT_SET_FOR_US_TO_VERIFY = 105;
  X509_R_NO_CRL_FOUND = 137;
  X509_R_NO_CRL_NUMBER = 130;
  X509_R_PUBLIC_KEY_DECODE_ERROR = 125;
  X509_R_PUBLIC_KEY_ENCODE_ERROR = 126;
  X509_R_SHOULD_RETRY = 106;
  X509_R_UNABLE_TO_FIND_PARAMETERS_IN_CHAIN = 107;
  X509_R_UNABLE_TO_GET_CERTS_PUBLIC_KEY = 108;
  X509_R_UNKNOWN_KEY_TYPE = 117;
  X509_R_UNKNOWN_NID = 109;
  X509_R_UNKNOWN_PURPOSE_ID = 121;
  X509_R_UNKNOWN_TRUST_ID = 120;
  X509_R_UNSUPPORTED_ALGORITHM = 111;
  X509_R_WRONG_LOOKUP_TYPE = 112;
  X509_R_WRONG_TYPE = 122;
  
  X509_SIG_INFO_VALID = $1;
  X509_SIG_INFO_TLS = $2;

  X509_EX_V_NETSCAPE_HACK = $8000;
  X509_EX_V_INIT = $0001;
  
  X509_FLAG_COMPAT = 0;
  X509_FLAG_NO_HEADER = 1;
  X509_FLAG_NO_VERSION = 1 shl 1;
  X509_FLAG_NO_SERIAL = 1 shl 2;
  X509_FLAG_NO_SIGNAME = 1 shl 3;
  X509_FLAG_NO_ISSUER = 1 shl 4;
  X509_FLAG_NO_VALIDITY = 1 shl 5;
  X509_FLAG_NO_SUBJECT = 1 shl 6;
  X509_FLAG_NO_PUBKEY = 1 shl 7;
  X509_FLAG_NO_EXTENSIONS = 1 shl 8;
  X509_FLAG_NO_SIGDUMP = 1 shl 9;
  X509_FLAG_NO_AUX = 1 shl 10;
  X509_FLAG_NO_ATTRIBUTES = 1 shl 11;
  X509_FLAG_NO_IDS = 1 shl 12;
  
  LH_LOAD_MULT = 256;
  //_LHASH = OPENSSL_LHASH;
  //LHASH_NODE = OPENSSL_LH_NODE;
  
  X509_LU_RETRY = -1;
  X509_LU_FAIL = 0;

  X509_VP_FLAG_DEFAULT = $1;
  X509_VP_FLAG_OVERWRITE = $2;
  X509_VP_FLAG_RESET_FLAGS = $4;
  X509_VP_FLAG_LOCKED = $8;
  X509_VP_FLAG_ONCE = $10;
  X509_V_FLAG_POLICY_MASK = X509_V_FLAG_POLICY_CHECK or X509_V_FLAG_EXPLICIT_POLICY or X509_V_FLAG_INHIBIT_ANY or X509_V_FLAG_INHIBIT_MAP;
  
  DANE_FLAG_NO_DANE_EE_NAMECHECKS = 1 shl 0;
  
  X509_PCY_TREE_FAILURE = -2;
  X509_PCY_TREE_INVALID = -1;
  X509_PCY_TREE_INTERNAL = 0;
  X509_PCY_TREE_VALID = 1;
  X509_PCY_TREE_EMPTY = 2;
  X509_PCY_TREE_EXPLICIT = 4;
  
  PKCS7_F_DO_PKCS7_SIGNED_ATTRIB = 136;
  PKCS7_F_PKCS7_ADD0_ATTRIB_SIGNING_TIME = 135;
  PKCS7_F_PKCS7_ADD_ATTRIB_SMIMECAP = 118;
  PKCS7_F_PKCS7_ADD_CERTIFICATE = 100;
  PKCS7_F_PKCS7_ADD_CRL = 101;
  PKCS7_F_PKCS7_ADD_RECIPIENT_INFO = 102;
  PKCS7_F_PKCS7_ADD_SIGNATURE = 131;
  PKCS7_F_PKCS7_ADD_SIGNER = 103;
  PKCS7_F_PKCS7_BIO_ADD_DIGEST = 125;
  PKCS7_F_PKCS7_COPY_EXISTING_DIGEST = 138;
  PKCS7_F_PKCS7_CTRL = 104;
  PKCS7_F_PKCS7_DATADECODE = 112;
  PKCS7_F_PKCS7_DATAFINAL = 128;
  PKCS7_F_PKCS7_DATAINIT = 105;
  PKCS7_F_PKCS7_DATAVERIFY = 107;
  PKCS7_F_PKCS7_DECRYPT = 114;
  PKCS7_F_PKCS7_DECRYPT_RINFO = 133;
  PKCS7_F_PKCS7_ENCODE_RINFO = 132;
  PKCS7_F_PKCS7_ENCRYPT = 115;
  PKCS7_F_PKCS7_FINAL = 134;
  PKCS7_F_PKCS7_FIND_DIGEST = 127;
  PKCS7_F_PKCS7_GET0_SIGNERS = 124;
  PKCS7_F_PKCS7_RECIP_INFO_SET = 130;
  PKCS7_F_PKCS7_SET_CIPHER = 108;
  PKCS7_F_PKCS7_SET_CONTENT = 109;
  PKCS7_F_PKCS7_SET_DIGEST = 126;
  PKCS7_F_PKCS7_SET_TYPE = 110;
  PKCS7_F_PKCS7_SIGN = 116;
  PKCS7_F_PKCS7_SIGNATUREVERIFY = 113;
  PKCS7_F_PKCS7_SIGNER_INFO_SET = 129;
  PKCS7_F_PKCS7_SIGNER_INFO_SIGN = 139;
  PKCS7_F_PKCS7_SIGN_ADD_SIGNER = 137;
  PKCS7_F_PKCS7_SIMPLE_SMIMECAP = 119;
  PKCS7_F_PKCS7_VERIFY = 117;
  
  PKCS7_R_CERTIFICATE_VERIFY_ERROR = 117;
  PKCS7_R_CIPHER_HAS_NO_OBJECT_IDENTIFIER = 144;
  PKCS7_R_CIPHER_NOT_INITIALIZED = 116;
  PKCS7_R_CONTENT_AND_DATA_PRESENT = 118;
  PKCS7_R_CTRL_ERROR = 152;
  PKCS7_R_DECRYPT_ERROR = 119;
  PKCS7_R_DIGEST_FAILURE = 101;
  PKCS7_R_ENCRYPTION_CTRL_FAILURE = 149;
  PKCS7_R_ENCRYPTION_NOT_SUPPORTED_FOR_THIS_KEY_TYPE = 150;
  PKCS7_R_ERROR_ADDING_RECIPIENT = 120;
  PKCS7_R_ERROR_SETTING_CIPHER = 121;
  PKCS7_R_INVALID_NULL_POINTER = 143;
  PKCS7_R_INVALID_SIGNED_DATA_TYPE = 155;
  PKCS7_R_NO_CONTENT = 122;
  PKCS7_R_NO_DEFAULT_DIGEST = 151;
  PKCS7_R_NO_MATCHING_DIGEST_TYPE_FOUND = 154;
  PKCS7_R_NO_RECIPIENT_MATCHES_CERTIFICATE = 115;
  PKCS7_R_NO_SIGNATURES_ON_DATA = 123;
  PKCS7_R_NO_SIGNERS = 142;
  PKCS7_R_OPERATION_NOT_SUPPORTED_ON_THIS_TYPE = 104;
  PKCS7_R_PKCS7_ADD_SIGNATURE_ERROR = 124;
  PKCS7_R_PKCS7_ADD_SIGNER_ERROR = 153;
  PKCS7_R_PKCS7_DATASIGN = 145;
  PKCS7_R_PRIVATE_KEY_DOES_NOT_MATCH_CERTIFICATE = 127;
  PKCS7_R_SIGNATURE_FAILURE = 105;
  PKCS7_R_SIGNER_CERTIFICATE_NOT_FOUND = 128;
  PKCS7_R_SIGNING_CTRL_FAILURE = 147;
  PKCS7_R_SIGNING_NOT_SUPPORTED_FOR_THIS_KEY_TYPE = 148;
  PKCS7_R_SMIME_TEXT_ERROR = 129;
  PKCS7_R_UNABLE_TO_FIND_CERTIFICATE = 106;
  PKCS7_R_UNABLE_TO_FIND_MEM_BIO = 107;
  PKCS7_R_UNABLE_TO_FIND_MESSAGE_DIGEST = 108;
  PKCS7_R_UNKNOWN_DIGEST_TYPE = 109;
  PKCS7_R_UNKNOWN_OPERATION = 110;
  PKCS7_R_UNSUPPORTED_CIPHER_TYPE = 111;
  PKCS7_R_UNSUPPORTED_CONTENT_TYPE = 112;
  PKCS7_R_WRONG_CONTENT_TYPE = 113;
  PKCS7_R_WRONG_PKCS7_TYPE = 114;
  
  PKCS7_S_HEADER = 0;
  PKCS7_S_BODY = 1;
  PKCS7_S_TAIL = 2;
  
  PKCS7_OP_SET_DETACHED_SIGNATURE = 1;
  PKCS7_OP_GET_DETACHED_SIGNATURE = 2;
  
  PKCS7_TEXT = $1;
  PKCS7_NOCERTS = $2;
  PKCS7_NOSIGS = $4;
  PKCS7_NOCHAIN = $8;
  PKCS7_NOINTERN = $10;
  PKCS7_NOVERIFY = $20;
  PKCS7_DETACHED = $40;
  PKCS7_BINARY = $80;
  PKCS7_NOATTR = $100;
  PKCS7_NOSMIMECAP = $200;
  PKCS7_NOOLDMIMETYPE = $400;
  PKCS7_CRLFEOL = $800;
  _PKCS7_STREAM = $1000;
  PKCS7_NOCRL = $2000;
  PKCS7_PARTIAL = $4000;
  PKCS7_REUSE_DIGEST = $8000;
  PKCS7_NO_DUAL_CONTENT = $10000;
  
  _SMIME_TEXT = PKCS7_TEXT;
  SMIME_NOCERTS = PKCS7_NOCERTS;
  SMIME_NOSIGS = PKCS7_NOSIGS;
  SMIME_NOCHAIN = PKCS7_NOCHAIN;
  SMIME_NOINTERN = PKCS7_NOINTERN;
  SMIME_NOVERIFY = PKCS7_NOVERIFY;
  SMIME_DETACHED = PKCS7_DETACHED;
  SMIME_BINARY = PKCS7_BINARY;
  SMIME_NOATTR = PKCS7_NOATTR;
  SMIME_ASCIICRLF = $80000;
  
  X509_EXT_PACK_UNKNOWN = 1;
  X509_EXT_PACK_STRING = 2;
  
  CONF_F_CONF_DUMP_FP = 104;
  CONF_F_CONF_LOAD = 100;
  CONF_F_CONF_LOAD_FP = 103;
  CONF_F_CONF_PARSE_LIST = 119;
  CONF_F_DEF_LOAD = 120;
  CONF_F_DEF_LOAD_BIO = 121;
  CONF_F_GET_NEXT_FILE = 107;
  CONF_F_MODULE_ADD = 122;
  CONF_F_MODULE_INIT = 115;
  CONF_F_MODULE_LOAD_DSO = 117;
  CONF_F_MODULE_RUN = 118;
  CONF_F_NCONF_DUMP_BIO = 105;
  CONF_F_NCONF_DUMP_FP = 106;
  CONF_F_NCONF_GET_NUMBER_E = 112;
  CONF_F_NCONF_GET_SECTION = 108;
  CONF_F_NCONF_GET_STRING = 109;
  CONF_F_NCONF_LOAD = 113;
  CONF_F_NCONF_LOAD_BIO = 110;
  CONF_F_NCONF_LOAD_FP = 114;
  CONF_F_NCONF_NEW = 111;
  CONF_F_PROCESS_INCLUDE = 116;
  CONF_F_SSL_MODULE_INIT = 123;
  CONF_F_STR_COPY = 101;
  
  CONF_R_ERROR_LOADING_DSO = 110;
  CONF_R_LIST_CANNOT_BE_NULL = 115;
  CONF_R_MISSING_CLOSE_SQUARE_BRACKET = 100;
  CONF_R_MISSING_EQUAL_SIGN = 101;
  CONF_R_MISSING_INIT_FUNCTION = 112;
  CONF_R_MODULE_INITIALIZATION_ERROR = 109;
  CONF_R_NO_CLOSE_BRACE = 102;
  CONF_R_NO_CONF = 105;
  CONF_R_NO_CONF_OR_ENVIRONMENT_VARIABLE = 106;
  CONF_R_NO_SECTION = 107;
  CONF_R_NO_SUCH_FILE = 114;
  CONF_R_NO_VALUE = 108;
  CONF_R_NUMBER_TOO_LARGE = 121;
  CONF_R_RECURSIVE_DIRECTORY_INCLUDE = 111;
  CONF_R_SSL_COMMAND_SECTION_EMPTY = 117;
  CONF_R_SSL_COMMAND_SECTION_NOT_FOUND = 118;
  CONF_R_SSL_SECTION_EMPTY = 119;
  CONF_R_SSL_SECTION_NOT_FOUND = 120;
  CONF_R_UNABLE_TO_CREATE_NEW_SECTION = 103;
  CONF_R_UNKNOWN_MODULE_NAME = 113;
  CONF_R_VARIABLE_EXPANSION_TOO_LONG = 116;
  CONF_R_VARIABLE_HAS_NO_VALUE = 104;
  
  CONF_MFLAGS_IGNORE_ERRORS = $1;
  CONF_MFLAGS_IGNORE_RETURN_CODES = $2;
  CONF_MFLAGS_SILENT = $4;
  CONF_MFLAGS_NO_DSO = $8;
  CONF_MFLAGS_IGNORE_MISSING_FILE = $10;
  CONF_MFLAGS_DEFAULT_SECTION = $20;
  
  X509V3_F_A2I_GENERAL_NAME = 164;
  X509V3_F_ADDR_VALIDATE_PATH_INTERNAL = 166;
  X509V3_F_ASIDENTIFIERCHOICE_CANONIZE = 161;
  X509V3_F_ASIDENTIFIERCHOICE_IS_CANONICAL = 162;
  X509V3_F_BIGNUM_TO_STRING = 167;
  X509V3_F_COPY_EMAIL = 122;
  X509V3_F_COPY_ISSUER = 123;
  X509V3_F_DO_DIRNAME = 144;
  X509V3_F_DO_EXT_I2D = 135;
  X509V3_F_DO_EXT_NCONF = 151;
  X509V3_F_GNAMES_FROM_SECTNAME = 156;
  X509V3_F_I2S_ASN1_ENUMERATED = 121;
  X509V3_F_I2S_ASN1_IA5STRING = 149;
  X509V3_F_I2S_ASN1_INTEGER = 120;
  X509V3_F_I2V_AUTHORITY_INFO_ACCESS = 138;
  X509V3_F_LEVEL_ADD_NODE = 168;
  X509V3_F_NOTICE_SECTION = 132;
  X509V3_F_NREF_NOS = 133;
  X509V3_F_POLICY_CACHE_CREATE = 169;
  X509V3_F_POLICY_CACHE_NEW = 170;
  X509V3_F_POLICY_DATA_NEW = 171;
  X509V3_F_POLICY_SECTION = 131;
  X509V3_F_PROCESS_PCI_VALUE = 150;
  X509V3_F_R2I_CERTPOL = 130;
  X509V3_F_R2I_PCI = 155;
  X509V3_F_S2I_ASN1_IA5STRING = 100;
  X509V3_F_S2I_ASN1_INTEGER = 108;
  X509V3_F_S2I_ASN1_OCTET_STRING = 112;
  X509V3_F_S2I_SKEY_ID = 115;
  X509V3_F_SET_DIST_POINT_NAME = 158;
  X509V3_F_SXNET_ADD_ID_ASC = 125;
  X509V3_F_SXNET_ADD_ID_INTEGER = 126;
  X509V3_F_SXNET_ADD_ID_ULONG = 127;
  X509V3_F_SXNET_GET_ID_ASC = 128;
  X509V3_F_SXNET_GET_ID_ULONG = 129;
  X509V3_F_TREE_INIT = 172;
  X509V3_F_V2I_ASIDENTIFIERS = 163;
  X509V3_F_V2I_ASN1_BIT_STRING = 101;
  X509V3_F_V2I_AUTHORITY_INFO_ACCESS = 139;
  X509V3_F_V2I_AUTHORITY_KEYID = 119;
  X509V3_F_V2I_BASIC_CONSTRAINTS = 102;
  X509V3_F_V2I_CRLD = 134;
  X509V3_F_V2I_EXTENDED_KEY_USAGE = 103;
  X509V3_F_V2I_GENERAL_NAMES = 118;
  X509V3_F_V2I_GENERAL_NAME_EX = 117;
  X509V3_F_V2I_IDP = 157;
  X509V3_F_V2I_IPADDRBLOCKS = 159;
  X509V3_F_V2I_ISSUER_ALT = 153;
  X509V3_F_V2I_NAME_CONSTRAINTS = 147;
  X509V3_F_V2I_POLICY_CONSTRAINTS = 146;
  X509V3_F_V2I_POLICY_MAPPINGS = 145;
  X509V3_F_V2I_SUBJECT_ALT = 154;
  X509V3_F_V2I_TLS_FEATURE = 165;
  X509V3_F_V3_GENERIC_EXTENSION = 116;
  X509V3_F_X509V3_ADD1_I2D = 140;
  X509V3_F_X509V3_ADD_VALUE = 105;
  X509V3_F_X509V3_EXT_ADD = 104;
  X509V3_F_X509V3_EXT_ADD_ALIAS = 106;
  X509V3_F_X509V3_EXT_I2D = 136;
  X509V3_F_X509V3_EXT_NCONF = 152;
  X509V3_F_X509V3_GET_SECTION = 142;
  X509V3_F_X509V3_GET_STRING = 143;
  X509V3_F_X509V3_GET_VALUE_BOOL = 110;
  X509V3_F_X509V3_PARSE_LIST = 109;
  X509V3_F_X509_PURPOSE_ADD = 137;
  X509V3_F_X509_PURPOSE_SET = 141;
  
  X509V3_R_BAD_IP_ADDRESS = 118;
  X509V3_R_BAD_OBJECT = 119;
  X509V3_R_BN_DEC2BN_ERROR = 100;
  X509V3_R_BN_TO_ASN1_INTEGER_ERROR = 101;
  X509V3_R_DIRNAME_ERROR = 149;
  X509V3_R_DISTPOINT_ALREADY_SET = 160;
  X509V3_R_DUPLICATE_ZONE_ID = 133;
  X509V3_R_ERROR_CONVERTING_ZONE = 131;
  X509V3_R_ERROR_CREATING_EXTENSION = 144;
  X509V3_R_ERROR_IN_EXTENSION = 128;
  X509V3_R_EXPECTED_A_SECTION_NAME = 137;
  X509V3_R_EXTENSION_EXISTS = 145;
  X509V3_R_EXTENSION_NAME_ERROR = 115;
  X509V3_R_EXTENSION_NOT_FOUND = 102;
  X509V3_R_EXTENSION_SETTING_NOT_SUPPORTED = 103;
  X509V3_R_EXTENSION_VALUE_ERROR = 116;
  X509V3_R_ILLEGAL_EMPTY_EXTENSION = 151;
  X509V3_R_INCORRECT_POLICY_SYNTAX_TAG = 152;
  X509V3_R_INVALID_ASNUMBER = 162;
  X509V3_R_INVALID_ASRANGE = 163;
  X509V3_R_INVALID_BOOLEAN_STRING = 104;
  X509V3_R_INVALID_EXTENSION_STRING = 105;
  X509V3_R_INVALID_INHERITANCE = 165;
  X509V3_R_INVALID_IPADDRESS = 166;
  X509V3_R_INVALID_MULTIPLE_RDNS = 161;
  X509V3_R_INVALID_NAME = 106;
  X509V3_R_INVALID_NULL_ARGUMENT = 107;
  X509V3_R_INVALID_NULL_NAME = 108;
  X509V3_R_INVALID_NULL_VALUE = 109;
  X509V3_R_INVALID_NUMBER = 140;
  X509V3_R_INVALID_NUMBERS = 141;
  X509V3_R_INVALID_OBJECT_IDENTIFIER = 110;
  X509V3_R_INVALID_OPTION = 138;
  X509V3_R_INVALID_POLICY_IDENTIFIER = 134;
  X509V3_R_INVALID_PROXY_POLICY_SETTING = 153;
  X509V3_R_INVALID_PURPOSE = 146;
  X509V3_R_INVALID_SAFI = 164;
  X509V3_R_INVALID_SECTION = 135;
  X509V3_R_INVALID_SYNTAX = 143;
  X509V3_R_ISSUER_DECODE_ERROR = 126;
  X509V3_R_MISSING_VALUE = 124;
  X509V3_R_NEED_ORGANIZATION_AND_NUMBERS = 142;
  X509V3_R_NO_CONFIG_DATABASE = 136;
  X509V3_R_NO_ISSUER_CERTIFICATE = 121;
  X509V3_R_NO_ISSUER_DETAILS = 127;
  X509V3_R_NO_POLICY_IDENTIFIER = 139;
  X509V3_R_NO_PROXY_CERT_POLICY_LANGUAGE_DEFINED = 154;
  X509V3_R_NO_PUBLIC_KEY = 114;
  X509V3_R_NO_SUBJECT_DETAILS = 125;
  X509V3_R_OPERATION_NOT_DEFINED = 148;
  X509V3_R_OTHERNAME_ERROR = 147;
  X509V3_R_POLICY_LANGUAGE_ALREADY_DEFINED = 155;
  X509V3_R_POLICY_PATH_LENGTH = 156;
  X509V3_R_POLICY_PATH_LENGTH_ALREADY_DEFINED = 157;
  X509V3_R_POLICY_WHEN_PROXY_LANGUAGE_REQUIRES_NO_POLICY = 159;
  X509V3_R_SECTION_NOT_FOUND = 150;
  X509V3_R_UNABLE_TO_GET_ISSUER_DETAILS = 122;
  X509V3_R_UNABLE_TO_GET_ISSUER_KEYID = 123;
  X509V3_R_UNKNOWN_BIT_STRING_ARGUMENT = 111;
  X509V3_R_UNKNOWN_EXTENSION = 129;
  X509V3_R_UNKNOWN_EXTENSION_NAME = 130;
  X509V3_R_UNKNOWN_OPTION = 120;
  X509V3_R_UNSUPPORTED_OPTION = 117;
  X509V3_R_UNSUPPORTED_TYPE = 167;
  X509V3_R_USER_TOO_LONG = 132;
  
  CTX_TEST = $1;
  X509V3_CTX_REPLACE = $2;
  X509V3_EXT_DYNAMIC = $1;
  X509V3_EXT_CTX_DEP = $2;
  X509V3_EXT_MULTILINE = $4;
  
  GEN_OTHERNAME = 0;
  GEN_EMAIL = 1;
  GEN_DNS = 2;
  GEN_X400 = 3;
  GEN_DIRNAME = 4;
  GEN_EDIPARTY = 5;
  GEN_URI = 6;
  GEN_IPADD = 7;
  GEN_RID = 8;
  
  IDP_PRESENT = $1;
  IDP_INVALID = $2;
  IDP_ONLYUSER = $4;
  IDP_ONLYCA = $8;
  IDP_ONLYATTR = $10;
  IDP_INDIRECT = $20;
  IDP_REASONS = $40;
  
  EXFLAG_BCONS = $1;
  EXFLAG_KUSAGE = $2;
  EXFLAG_XKUSAGE = $4;
  EXFLAG_NSCERT = $8;
  
  EXFLAG_CA = $10;
  EXFLAG_SI = $20;
  EXFLAG_V1 = $40;
  EXFLAG_INVALID = $80;
  EXFLAG_SET = $100;
  EXFLAG_CRITICAL = $200;
  EXFLAG_PROXY = $400;
  EXFLAG_INVALID_POLICY = $800;
  EXFLAG_FRESHEST = $1000;
  EXFLAG_SS = $2000;
  
  KU_DIGITAL_SIGNATURE = $0080;
  KU_NON_REPUDIATION = $0040;
  KU_KEY_ENCIPHERMENT = $0020;
  KU_DATA_ENCIPHERMENT = $0010;
  KU_KEY_AGREEMENT = $0008;
  KU_KEY_CERT_SIGN = $0004;
  KU_CRL_SIGN = $0002;
  KU_ENCIPHER_ONLY = $0001;
  KU_DECIPHER_ONLY = $8000;
  
  NS_SSL_CLIENT = $80;
  NS_SSL_SERVER = $40;
  NS_SMIME = $20;
  NS_OBJSIGN = $10;
  NS_SSL_CA = $04;
  NS_SMIME_CA = $02;
  NS_OBJSIGN_CA = $01;
  NS_ANY_CA = NS_SSL_CA or NS_SMIME_CA or NS_OBJSIGN_CA;
  
  X509V3_ADD_OP_MASK = $f;
  X509V3_ADD_DEFAULT = 0;
  X509V3_ADD_APPEND = 1;
  X509V3_ADD_REPLACE = 2;
  X509V3_ADD_REPLACE_EXISTING = 3;
  X509V3_ADD_KEEP_EXISTING = 4;
  X509V3_ADD_DELETE = 5;
  X509V3_ADD_SILENT = $10;
  
  ASIdOrRange_id = 0;
  ASIdOrRange_range = 1;
  ASIdentifierChoice_inherit = 0;
  ASIdentifierChoice_asIdsOrRanges = 1;
  
  IPAddressOrRange_addressPrefix = 0;
  IPAddressOrRange_addressRange = 1;
  IPAddressChoice_inherit = 0;
  IPAddressChoice_addressesOrRanges = 1;
  
  V3_ASID_ASNUM = 0;
  V3_ASID_RDI = 1;
  IANA_AFI_IPV4 = 1;
  IANA_AFI_IPV6 = 2;
  
  CMS_F_CHECK_CONTENT = 99;
  CMS_F_CMS_ADD0_CERT = 164;
  CMS_F_CMS_ADD0_RECIPIENT_KEY = 100;
  CMS_F_CMS_ADD0_RECIPIENT_PASSWORD = 165;
  CMS_F_CMS_ADD1_RECEIPTREQUEST = 158;
  CMS_F_CMS_ADD1_RECIPIENT_CERT = 101;
  CMS_F_CMS_ADD1_SIGNER = 102;
  CMS_F_CMS_ADD1_SIGNINGTIME = 103;
  CMS_F_CMS_COMPRESS = 104;
  CMS_F_CMS_COMPRESSEDDATA_CREATE = 105;
  CMS_F_CMS_COMPRESSEDDATA_INIT_BIO = 106;
  CMS_F_CMS_COPY_CONTENT = 107;
  CMS_F_CMS_COPY_MESSAGEDIGEST = 108;
  CMS_F_CMS_DATA = 109;
  CMS_F_CMS_DATAFINAL = 110;
  CMS_F_CMS_DATAINIT = 111;
  CMS_F_CMS_DECRYPT = 112;
  CMS_F_CMS_DECRYPT_SET1_KEY = 113;
  CMS_F_CMS_DECRYPT_SET1_PASSWORD = 166;
  CMS_F_CMS_DECRYPT_SET1_PKEY = 114;
  CMS_F_CMS_DIGESTALGORITHM_FIND_CTX = 115;
  CMS_F_CMS_DIGESTALGORITHM_INIT_BIO = 116;
  CMS_F_CMS_DIGESTEDDATA_DO_FINAL = 117;
  CMS_F_CMS_DIGEST_VERIFY = 118;
  CMS_F_CMS_ENCODE_RECEIPT = 161;
  CMS_F_CMS_ENCRYPT = 119;
  CMS_F_CMS_ENCRYPTEDCONTENT_INIT = 179;
  CMS_F_CMS_ENCRYPTEDCONTENT_INIT_BIO = 120;
  CMS_F_CMS_ENCRYPTEDDATA_DECRYPT = 121;
  CMS_F_CMS_ENCRYPTEDDATA_ENCRYPT = 122;
  CMS_F_CMS_ENCRYPTEDDATA_SET1_KEY = 123;
  CMS_F_CMS_ENVELOPEDDATA_CREATE = 124;
  CMS_F_CMS_ENVELOPEDDATA_INIT_BIO = 125;
  CMS_F_CMS_ENVELOPED_DATA_INIT = 126;
  CMS_F_CMS_ENV_ASN1_CTRL = 171;
  CMS_F_CMS_FINAL = 127;
  CMS_F_CMS_GET0_CERTIFICATE_CHOICES = 128;
  CMS_F_CMS_GET0_CONTENT = 129;
  CMS_F_CMS_GET0_ECONTENT_TYPE = 130;
  CMS_F_CMS_GET0_ENVELOPED = 131;
  CMS_F_CMS_GET0_REVOCATION_CHOICES = 132;
  CMS_F_CMS_GET0_SIGNED = 133;
  CMS_F_CMS_MSGSIGDIGEST_ADD1 = 162;
  CMS_F_CMS_RECEIPTREQUEST_CREATE0 = 159;
  CMS_F_CMS_RECEIPT_VERIFY = 160;
  CMS_F_CMS_RECIPIENTINFO_DECRYPT = 134;
  CMS_F_CMS_RECIPIENTINFO_ENCRYPT = 169;
  CMS_F_CMS_RECIPIENTINFO_KARI_ENCRYPT = 178;
  CMS_F_CMS_RECIPIENTINFO_KARI_GET0_ALG = 175;
  CMS_F_CMS_RECIPIENTINFO_KARI_GET0_ORIG_ID = 173;
  CMS_F_CMS_RECIPIENTINFO_KARI_GET0_REKS = 172;
  CMS_F_CMS_RECIPIENTINFO_KARI_ORIG_ID_CMP = 174;
  CMS_F_CMS_RECIPIENTINFO_KEKRI_DECRYPT = 135;
  CMS_F_CMS_RECIPIENTINFO_KEKRI_ENCRYPT = 136;
  CMS_F_CMS_RECIPIENTINFO_KEKRI_GET0_ID = 137;
  CMS_F_CMS_RECIPIENTINFO_KEKRI_ID_CMP = 138;
  CMS_F_CMS_RECIPIENTINFO_KTRI_CERT_CMP = 139;
  CMS_F_CMS_RECIPIENTINFO_KTRI_DECRYPT = 140;
  CMS_F_CMS_RECIPIENTINFO_KTRI_ENCRYPT = 141;
  CMS_F_CMS_RECIPIENTINFO_KTRI_GET0_ALGS = 142;
  CMS_F_CMS_RECIPIENTINFO_KTRI_GET0_SIGNER_ID = 143;
  CMS_F_CMS_RECIPIENTINFO_PWRI_CRYPT = 167;
  CMS_F_CMS_RECIPIENTINFO_SET0_KEY = 144;
  CMS_F_CMS_RECIPIENTINFO_SET0_PASSWORD = 168;
  CMS_F_CMS_RECIPIENTINFO_SET0_PKEY = 145;
  CMS_F_CMS_SD_ASN1_CTRL = 170;
  CMS_F_CMS_SET1_IAS = 176;
  CMS_F_CMS_SET1_KEYID = 177;
  CMS_F_CMS_SET1_SIGNERIDENTIFIER = 146;
  CMS_F_CMS_SET_DETACHED = 147;
  CMS_F_CMS_SIGN = 148;
  CMS_F_CMS_SIGNED_DATA_INIT = 149;
  CMS_F_CMS_SIGNERINFO_CONTENT_SIGN = 150;
  CMS_F_CMS_SIGNERINFO_SIGN = 151;
  CMS_F_CMS_SIGNERINFO_VERIFY = 152;
  CMS_F_CMS_SIGNERINFO_VERIFY_CERT = 153;
  CMS_F_CMS_SIGNERINFO_VERIFY_CONTENT = 154;
  CMS_F_CMS_SIGN_RECEIPT = 163;
  CMS_F_CMS_SI_CHECK_ATTRIBUTES = 183;
  CMS_F_CMS_STREAM = 155;
  CMS_F_CMS_UNCOMPRESS = 156;
  CMS_F_CMS_VERIFY = 157;
  CMS_F_KEK_UNWRAP_KEY = 180;
  
  CMS_R_ADD_SIGNER_ERROR = 99;
  CMS_R_ATTRIBUTE_ERROR = 161;
  CMS_R_CERTIFICATE_ALREADY_PRESENT = 175;
  CMS_R_CERTIFICATE_HAS_NO_KEYID = 160;
  CMS_R_CERTIFICATE_VERIFY_ERROR = 100;
  CMS_R_CIPHER_INITIALISATION_ERROR = 101;
  CMS_R_CIPHER_PARAMETER_INITIALISATION_ERROR = 102;
  CMS_R_CMS_DATAFINAL_ERROR = 103;
  CMS_R_CMS_LIB = 104;
  CMS_R_CONTENTIDENTIFIER_MISMATCH = 170;
  CMS_R_CONTENT_NOT_FOUND = 105;
  CMS_R_CONTENT_TYPE_MISMATCH = 171;
  CMS_R_CONTENT_TYPE_NOT_COMPRESSED_DATA = 106;
  CMS_R_CONTENT_TYPE_NOT_ENVELOPED_DATA = 107;
  CMS_R_CONTENT_TYPE_NOT_SIGNED_DATA = 108;
  CMS_R_CONTENT_VERIFY_ERROR = 109;
  CMS_R_CTRL_ERROR = 110;
  CMS_R_CTRL_FAILURE = 111;
  CMS_R_DECRYPT_ERROR = 112;
  CMS_R_ERROR_GETTING_PUBLIC_KEY = 113;
  CMS_R_ERROR_READING_MESSAGEDIGEST_ATTRIBUTE = 114;
  CMS_R_ERROR_SETTING_KEY = 115;
  CMS_R_ERROR_SETTING_RECIPIENTINFO = 116;
  CMS_R_INVALID_ENCRYPTED_KEY_LENGTH = 117;
  CMS_R_INVALID_KEY_ENCRYPTION_PARAMETER = 176;
  CMS_R_INVALID_KEY_LENGTH = 118;
  CMS_R_MD_BIO_INIT_ERROR = 119;
  CMS_R_MESSAGEDIGEST_ATTRIBUTE_WRONG_LENGTH = 120;
  CMS_R_MESSAGEDIGEST_WRONG_LENGTH = 121;
  CMS_R_MSGSIGDIGEST_ERROR = 172;
  CMS_R_MSGSIGDIGEST_VERIFICATION_FAILURE = 162;
  CMS_R_MSGSIGDIGEST_WRONG_LENGTH = 163;
  CMS_R_NEED_ONE_SIGNER = 164;
  CMS_R_NOT_A_SIGNED_RECEIPT = 165;
  CMS_R_NOT_ENCRYPTED_DATA = 122;
  CMS_R_NOT_KEK = 123;
  CMS_R_NOT_KEY_AGREEMENT = 181;
  CMS_R_NOT_KEY_TRANSPORT = 124;
  CMS_R_NOT_PWRI = 177;
  CMS_R_NOT_SUPPORTED_FOR_THIS_KEY_TYPE = 125;
  CMS_R_NO_CIPHER = 126;
  CMS_R_NO_CONTENT = 127;
  CMS_R_NO_CONTENT_TYPE = 173;
  CMS_R_NO_DEFAULT_DIGEST = 128;
  CMS_R_NO_DIGEST_SET = 129;
  CMS_R_NO_KEY = 130;
  CMS_R_NO_KEY_OR_CERT = 174;
  CMS_R_NO_MATCHING_DIGEST = 131;
  CMS_R_NO_MATCHING_RECIPIENT = 132;
  CMS_R_NO_MATCHING_SIGNATURE = 166;
  CMS_R_NO_MSGSIGDIGEST = 167;
  CMS_R_NO_PASSWORD = 178;
  CMS_R_NO_PRIVATE_KEY = 133;
  CMS_R_NO_PUBLIC_KEY = 134;
  CMS_R_NO_RECEIPT_REQUEST = 168;
  CMS_R_NO_SIGNERS = 135;
  CMS_R_PRIVATE_KEY_DOES_NOT_MATCH_CERTIFICATE = 136;
  CMS_R_RECEIPT_DECODE_ERROR = 169;
  CMS_R_RECIPIENT_ERROR = 137;
  CMS_R_SIGNER_CERTIFICATE_NOT_FOUND = 138;
  CMS_R_SIGNFINAL_ERROR = 139;
  CMS_R_SMIME_TEXT_ERROR = 140;
  CMS_R_STORE_INIT_ERROR = 141;
  CMS_R_TYPE_NOT_COMPRESSED_DATA = 142;
  CMS_R_TYPE_NOT_DATA = 143;
  CMS_R_TYPE_NOT_DIGESTED_DATA = 144;
  CMS_R_TYPE_NOT_ENCRYPTED_DATA = 145;
  CMS_R_TYPE_NOT_ENVELOPED_DATA = 146;
  CMS_R_UNABLE_TO_FINALIZE_CONTEXT = 147;
  CMS_R_UNKNOWN_CIPHER = 148;
  CMS_R_UNKNOWN_DIGEST_ALGORITHM = 149;
  CMS_R_UNKNOWN_ID = 150;
  CMS_R_UNSUPPORTED_COMPRESSION_ALGORITHM = 151;
  CMS_R_UNSUPPORTED_CONTENT_TYPE = 152;
  CMS_R_UNSUPPORTED_KEK_ALGORITHM = 153;
  CMS_R_UNSUPPORTED_KEY_ENCRYPTION_ALGORITHM = 179;
  CMS_R_UNSUPPORTED_RECIPIENTINFO_TYPE = 155;
  CMS_R_UNSUPPORTED_RECIPIENT_TYPE = 154;
  CMS_R_UNSUPPORTED_TYPE = 156;
  CMS_R_UNWRAP_ERROR = 157;
  CMS_R_UNWRAP_FAILURE = 180;
  CMS_R_VERIFICATION_FAILURE = 158;
  CMS_R_WRAP_ERROR = 159;
  
  CMS_SIGNERINFO_ISSUER_SERIAL = 0;
  CMS_SIGNERINFO_KEYIDENTIFIER = 1;
  
  CMS_RECIPINFO_NONE = -1;
  CMS_RECIPINFO_TRANS = 0;
  CMS_RECIPINFO_AGREE = 1;
  CMS_RECIPINFO_KEK = 2;
  CMS_RECIPINFO_PASS = 3;
  CMS_RECIPINFO_OTHER = 4;
  
  CMS_TEXT = $1;
  CMS_NOCERTS = $2;
  CMS_NO_CONTENT_VERIFY = $4;
  CMS_NO_ATTR_VERIFY = $8;
  CMS_NOSIGS = CMS_NO_CONTENT_VERIFY or CMS_NO_ATTR_VERIFY;
  CMS_NOINTERN = $10;
  CMS_NO_SIGNER_CERT_VERIFY = $20;
  CMS_NOVERIFY = $20;
  CMS_DETACHED = $40;
  CMS_BINARY = $80;
  CMS_NOATTR = $100;
  CMS_NOSMIMECAP = $200;
  CMS_NOOLDMIMETYPE = $400;
  CMS_CRLFEOL = $800;
  _CMS_STREAM = $1000;
  CMS_NOCRL = $2000;
  CMS_PARTIAL = $4000;
  CMS_REUSE_DIGEST = $8000;
  CMS_USE_KEYID = $10000;
  CMS_DEBUG_DECRYPT = $20000;
  CMS_KEY_PARAM = $40000;
  CMS_ASCIICRLF = $80000;
  CMS_R_UNKNOWN_DIGEST_ALGORITM = CMS_R_UNKNOWN_DIGEST_ALGORITHM;
  CMS_R_UNSUPPORTED_RECPIENTINFO_TYPE = CMS_R_UNSUPPORTED_RECIPIENTINFO_TYPE;
  
  COMP_F_BIO_ZLIB_FLUSH = 99;
  COMP_F_BIO_ZLIB_NEW = 100;
  COMP_F_BIO_ZLIB_READ = 101;
  COMP_F_BIO_ZLIB_WRITE = 102;
  COMP_F_COMP_CTX_NEW = 103;
  COMP_R_ZLIB_DEFLATE_ERROR = 99;
  COMP_R_ZLIB_INFLATE_ERROR = 100;
  COMP_R_ZLIB_NOT_SUPPORTED = 101;
  
  CT_F_CTLOG_NEW = 117;
  CT_F_CTLOG_NEW_FROM_BASE64 = 118;
  CT_F_CTLOG_NEW_FROM_CONF = 119;
  CT_F_CTLOG_STORE_LOAD_CTX_NEW = 122;
  CT_F_CTLOG_STORE_LOAD_FILE = 123;
  CT_F_CTLOG_STORE_LOAD_LOG = 130;
  CT_F_CTLOG_STORE_NEW = 131;
  CT_F_CT_BASE64_DECODE = 124;
  CT_F_CT_POLICY_EVAL_CTX_NEW = 133;
  CT_F_CT_V1_LOG_ID_FROM_PKEY = 125;
  CT_F_I2O_SCT = 107;
  CT_F_I2O_SCT_LIST = 108;
  CT_F_I2O_SCT_SIGNATURE = 109;
  CT_F_O2I_SCT = 110;
  CT_F_O2I_SCT_LIST = 111;
  CT_F_O2I_SCT_SIGNATURE = 112;
  CT_F_SCT_CTX_NEW = 126;
  CT_F_SCT_CTX_VERIFY = 128;
  CT_F_SCT_NEW = 100;
  CT_F_SCT_NEW_FROM_BASE64 = 127;
  CT_F_SCT_SET0_LOG_ID = 101;
  CT_F_SCT_SET1_EXTENSIONS = 114;
  CT_F_SCT_SET1_LOG_ID = 115;
  CT_F_SCT_SET1_SIGNATURE = 116;
  CT_F_SCT_SET_LOG_ENTRY_TYPE = 102;
  CT_F_SCT_SET_SIGNATURE_NID = 103;
  CT_F_SCT_SET_VERSION = 104;
  
  CT_R_BASE64_DECODE_ERROR = 108;
  CT_R_INVALID_LOG_ID_LENGTH = 100;
  CT_R_LOG_CONF_INVALID = 109;
  CT_R_LOG_CONF_INVALID_KEY = 110;
  CT_R_LOG_CONF_MISSING_DESCRIPTION = 111;
  CT_R_LOG_CONF_MISSING_KEY = 112;
  CT_R_LOG_KEY_INVALID = 113;
  CT_R_SCT_FUTURE_TIMESTAMP = 116;
  CT_R_SCT_INVALID = 104;
  CT_R_SCT_INVALID_SIGNATURE = 107;
  CT_R_SCT_LIST_INVALID = 105;
  CT_R_SCT_LOG_ID_MISMATCH = 114;
  CT_R_SCT_NOT_SET = 106;
  CT_R_SCT_UNSUPPORTED_VERSION = 115;
  CT_R_UNRECOGNIZED_SIGNATURE_NID = 101;
  CT_R_UNSUPPORTED_ENTRY_TYPE = 102;
  CT_R_UNSUPPORTED_VERSION = 103;
  
  SCT_MIN_RSA_BITS = 2048;
  CT_V1_HASHLEN = SHA256_DIGEST_LENGTH;
  
  DES_ENCRYPT = 1;
  DES_DECRYPT = 0;
  DES_CBC_MODE = 0;
  DES_PCBC_MODE = 1;
  
  DTLS1_VERSION = $FEFF;
  DTLS1_2_VERSION = $FEFD;
  DTLS_MIN_VERSION = DTLS1_VERSION;
  DTLS_MAX_VERSION = DTLS1_2_VERSION;
  DTLS1_VERSION_MAJOR = $FE;
  DTLS1_BAD_VER = $0100;
  DTLS_ANY_VERSION = $1FFFF;
  DTLS1_COOKIE_LENGTH = 256;
  DTLS1_RT_HEADER_LENGTH = 13;
  DTLS1_HM_HEADER_LENGTH = 12;
  DTLS1_HM_BAD_FRAGMENT = -2;
  DTLS1_HM_FRAGMENT_RETRY = -3;
  DTLS1_CCS_HEADER_LENGTH = 1;
  DTLS1_AL_HEADER_LENGTH = 2;
  DTLS1_TMO_READ_COUNT = 2;
  DTLS1_TMO_WRITE_COUNT = 2;
  DTLS1_TMO_ALERT_COUNT = 12;
  
  RAND_F_DATA_COLLECT_METHOD = 127;
  RAND_F_DRBG_BYTES = 101;
  RAND_F_DRBG_GET_ENTROPY = 105;
  RAND_F_DRBG_SETUP = 117;
  RAND_F_GET_ENTROPY = 106;
  RAND_F_RAND_BYTES = 100;
  RAND_F_RAND_DRBG_ENABLE_LOCKING = 119;
  RAND_F_RAND_DRBG_GENERATE = 107;
  RAND_F_RAND_DRBG_GET_ENTROPY = 120;
  RAND_F_RAND_DRBG_GET_NONCE = 123;
  RAND_F_RAND_DRBG_INSTANTIATE = 108;
  RAND_F_RAND_DRBG_NEW = 109;
  RAND_F_RAND_DRBG_RESEED = 110;
  RAND_F_RAND_DRBG_RESTART = 102;
  RAND_F_RAND_DRBG_SET = 104;
  RAND_F_RAND_DRBG_SET_DEFAULTS = 121;
  RAND_F_RAND_DRBG_UNINSTANTIATE = 118;
  RAND_F_RAND_LOAD_FILE = 111;
  RAND_F_RAND_POOL_ACQUIRE_ENTROPY = 122;
  RAND_F_RAND_POOL_ADD = 103;
  RAND_F_RAND_POOL_ADD_BEGIN = 113;
  RAND_F_RAND_POOL_ADD_END = 114;
  RAND_F_RAND_POOL_ATTACH = 124;
  RAND_F_RAND_POOL_BYTES_NEEDED = 115;
  RAND_F_RAND_POOL_GROW = 125;
  RAND_F_RAND_POOL_NEW = 116;
  RAND_F_RAND_PSEUDO_BYTES = 126;
  RAND_F_RAND_WRITE_FILE = 112;
  
  RAND_R_ADDITIONAL_INPUT_TOO_LONG = 102;
  RAND_R_ALREADY_INSTANTIATED = 103;
  RAND_R_ARGUMENT_OUT_OF_RANGE = 105;
  RAND_R_CANNOT_OPEN_FILE = 121;
  RAND_R_DRBG_ALREADY_INITIALIZED = 129;
  RAND_R_DRBG_NOT_INITIALISED = 104;
  RAND_R_ENTROPY_INPUT_TOO_LONG = 106;
  RAND_R_ENTROPY_OUT_OF_RANGE = 124;
  RAND_R_ERROR_ENTROPY_POOL_WAS_IGNORED = 127;
  RAND_R_ERROR_INITIALISING_DRBG = 107;
  RAND_R_ERROR_INSTANTIATING_DRBG = 108;
  RAND_R_ERROR_RETRIEVING_ADDITIONAL_INPUT = 109;
  RAND_R_ERROR_RETRIEVING_ENTROPY = 110;
  RAND_R_ERROR_RETRIEVING_NONCE = 111;
  RAND_R_FAILED_TO_CREATE_LOCK = 126;
  RAND_R_FUNC_NOT_IMPLEMENTED = 101;
  RAND_R_FWRITE_ERROR = 123;
  RAND_R_GENERATE_ERROR = 112;
  RAND_R_INTERNAL_ERROR = 113;
  RAND_R_IN_ERROR_STATE = 114;
  RAND_R_NOT_A_REGULAR_FILE = 122;
  RAND_R_NOT_INSTANTIATED = 115;
  RAND_R_NO_DRBG_IMPLEMENTATION_SELECTED = 128;
  RAND_R_PARENT_LOCKING_NOT_ENABLED = 130;
  RAND_R_PARENT_STRENGTH_TOO_WEAK = 131;
  RAND_R_PERSONALISATION_STRING_TOO_LONG = 116;
  RAND_R_PREDICTION_RESISTANCE_NOT_SUPPORTED = 133;
  RAND_R_PRNG_NOT_SEEDED = 100;
  RAND_R_RANDOM_POOL_OVERFLOW = 125;
  RAND_R_RANDOM_POOL_UNDERFLOW = 134;
  RAND_R_REQUEST_TOO_LARGE_FOR_DRBG = 117;
  RAND_R_RESEED_ERROR = 118;
  RAND_R_SELFTEST_FAILURE = 119;
  RAND_R_TOO_LITTLE_NONCE_REQUESTED = 135;
  RAND_R_TOO_MUCH_NONCE_REQUESTED = 136;
  RAND_R_UNSUPPORTED_DRBG_FLAGS = 132;
  RAND_R_UNSUPPORTED_DRBG_TYPE = 120;
  
  PEM_F_B2I_DSS = 127;
  PEM_F_B2I_PVK_BIO = 128;
  PEM_F_B2I_RSA = 129;
  PEM_F_CHECK_BITLEN_DSA = 130;
  PEM_F_CHECK_BITLEN_RSA = 131;
  PEM_F_D2I_PKCS8PRIVATEKEY_BIO = 120;
  PEM_F_D2I_PKCS8PRIVATEKEY_FP = 121;
  PEM_F_DO_B2I = 132;
  PEM_F_DO_B2I_BIO = 133;
  PEM_F_DO_BLOB_HEADER = 134;
  PEM_F_DO_I2B = 146;
  PEM_F_DO_PK8PKEY = 126;
  PEM_F_DO_PK8PKEY_FP = 125;
  PEM_F_DO_PVK_BODY = 135;
  PEM_F_DO_PVK_HEADER = 136;
  PEM_F_GET_HEADER_AND_DATA = 143;
  PEM_F_GET_NAME = 144;
  PEM_F_I2B_PVK = 137;
  PEM_F_I2B_PVK_BIO = 138;
  PEM_F_LOAD_IV = 101;
  PEM_F_PEM_ASN1_READ = 102;
  PEM_F_PEM_ASN1_READ_BIO = 103;
  PEM_F_PEM_ASN1_WRITE = 104;
  PEM_F_PEM_ASN1_WRITE_BIO = 105;
  PEM_F_PEM_DEF_CALLBACK = 100;
  PEM_F_PEM_DO_HEADER = 106;
  PEM_F_PEM_GET_EVP_CIPHER_INFO = 107;
  PEM_F_PEM_READ = 108;
  PEM_F_PEM_READ_BIO = 109;
  PEM_F_PEM_READ_BIO_DHPARAMS = 141;
  PEM_F_PEM_READ_BIO_EX = 145;
  PEM_F_PEM_READ_BIO_PARAMETERS = 140;
  PEM_F_PEM_READ_BIO_PRIVATEKEY = 123;
  PEM_F_PEM_READ_DHPARAMS = 142;
  PEM_F_PEM_READ_PRIVATEKEY = 124;
  PEM_F_PEM_SIGNFINAL = 112;
  PEM_F_PEM_WRITE = 113;
  PEM_F_PEM_WRITE_BIO = 114;
  PEM_F_PEM_WRITE_PRIVATEKEY = 139;
  PEM_F_PEM_X509_INFO_READ = 115;
  PEM_F_PEM_X509_INFO_READ_BIO = 116;
  PEM_F_PEM_X509_INFO_WRITE_BIO = 117;
  
  PEM_R_BAD_BASE64_DECODE = 100;
  PEM_R_BAD_DECRYPT = 101;
  PEM_R_BAD_END_LINE = 102;
  PEM_R_BAD_IV_CHARS = 103;
  PEM_R_BAD_MAGIC_NUMBER = 116;
  PEM_R_BAD_PASSWORD_READ = 104;
  PEM_R_BAD_VERSION_NUMBER = 117;
  PEM_R_BIO_WRITE_FAILURE = 118;
  PEM_R_CIPHER_IS_NULL = 127;
  PEM_R_ERROR_CONVERTING_PRIVATE_KEY = 115;
  PEM_R_EXPECTING_PRIVATE_KEY_BLOB = 119;
  PEM_R_EXPECTING_PUBLIC_KEY_BLOB = 120;
  PEM_R_HEADER_TOO_LONG = 128;
  PEM_R_INCONSISTENT_HEADER = 121;
  PEM_R_KEYBLOB_HEADER_PARSE_ERROR = 122;
  PEM_R_KEYBLOB_TOO_SHORT = 123;
  PEM_R_MISSING_DEK_IV = 129;
  PEM_R_NOT_DEK_INFO = 105;
  PEM_R_NOT_ENCRYPTED = 106;
  PEM_R_NOT_PROC_TYPE = 107;
  PEM_R_NO_START_LINE = 108;
  PEM_R_PROBLEMS_GETTING_PASSWORD = 109;
  PEM_R_PVK_DATA_TOO_SHORT = 124;
  PEM_R_PVK_TOO_SHORT = 125;
  PEM_R_READ_KEY = 111;
  PEM_R_SHORT_HEADER = 112;
  PEM_R_UNEXPECTED_DEK_IV = 130;
  PEM_R_UNSUPPORTED_CIPHER = 113;
  PEM_R_UNSUPPORTED_ENCRYPTION = 114;
  PEM_R_UNSUPPORTED_KEY_COMPONENTS = 126;
  PEM_BUFSIZE = 1024;
  
  PEM_STRING_X509_OLD = 'X509 CERTIFICATE';
  PEM_STRING_X509 = 'CERTIFICATE';
  PEM_STRING_X509_TRUSTED = 'TRUSTED CERTIFICATE';
  PEM_STRING_X509_REQ_OLD = 'NEW CERTIFICATE REQUEST';
  PEM_STRING_X509_REQ = 'CERTIFICATE REQUEST';
  PEM_STRING_X509_CRL = 'X509 CRL';
  PEM_STRING_EVP_PKEY = 'ANY PRIVATE KEY';
  PEM_STRING_PUBLIC = 'PUBLIC KEY';
  PEM_STRING_RSA = 'RSA PRIVATE KEY';
  PEM_STRING_RSA_PUBLIC = 'RSA PUBLIC KEY';
  PEM_STRING_DSA = 'DSA PRIVATE KEY';
  PEM_STRING_DSA_PUBLIC = 'DSA PUBLIC KEY';
  PEM_STRING_PKCS7 = 'PKCS7';
  PEM_STRING_PKCS7_SIGNED = 'PKCS #7 SIGNED DATA';
  PEM_STRING_PKCS8 = 'ENCRYPTED PRIVATE KEY';
  PEM_STRING_PKCS8INF = 'PRIVATE KEY';
  PEM_STRING_DHPARAMS = 'DH PARAMETERS';
  PEM_STRING_DHXPARAMS = 'X9.42 DH PARAMETERS';
  PEM_STRING_SSL_SESSION = 'SSL SESSION PARAMETERS';
  PEM_STRING_DSAPARAMS = 'DSA PARAMETERS';
  PEM_STRING_ECDSA_PUBLIC = 'ECDSA PUBLIC KEY';
  PEM_STRING_ECPARAMETERS = 'EC PARAMETERS';
  PEM_STRING_ECPRIVATEKEY = 'EC PRIVATE KEY';
  PEM_STRING_PARAMETERS = 'PARAMETERS';
  PEM_STRING_CMS = 'CMS';
  
  PEM_TYPE_ENCRYPTED = 10;
  PEM_TYPE_MIC_ONLY = 20;
  PEM_TYPE_MIC_CLEAR = 30;
  PEM_TYPE_CLEAR = 40;
  
  PEM_FLAG_SECURE = $1;
  PEM_FLAG_EAY_COMPATIBLE = $2;
  PEM_FLAG_ONLY_B64 = $4;
  
  UI_F_CLOSE_CONSOLE = 115;
  UI_F_ECHO_CONSOLE = 116;
  UI_F_GENERAL_ALLOCATE_BOOLEAN = 108;
  UI_F_GENERAL_ALLOCATE_PROMPT = 109;
  UI_F_NOECHO_CONSOLE = 117;
  UI_F_OPEN_CONSOLE = 114;
  UI_F_UI_CONSTRUCT_PROMPT = 121;
  UI_F_UI_CREATE_METHOD = 112;
  UI_F_UI_CTRL = 111;
  UI_F_UI_DUP_ERROR_STRING = 101;
  UI_F_UI_DUP_INFO_STRING = 102;
  UI_F_UI_DUP_INPUT_BOOLEAN = 110;
  UI_F_UI_DUP_INPUT_STRING = 103;
  UI_F_UI_DUP_USER_DATA = 118;
  UI_F_UI_DUP_VERIFY_STRING = 106;
  UI_F_UI_GET0_RESULT = 107;
  UI_F_UI_GET_RESULT_LENGTH = 119;
  UI_F_UI_NEW_METHOD = 104;
  UI_F_UI_PROCESS = 113;
  UI_F_UI_SET_RESULT = 105;
  UI_F_UI_SET_RESULT_EX = 120;
  
  UI_R_COMMON_OK_AND_CANCEL_CHARACTERS = 104;
  UI_R_INDEX_TOO_LARGE = 102;
  UI_R_INDEX_TOO_SMALL = 103;
  UI_R_NO_RESULT_BUFFER = 105;
  UI_R_PROCESSING_ERROR = 107;
  UI_R_RESULT_TOO_LARGE = 100;
  UI_R_RESULT_TOO_SMALL = 101;
  UI_R_SYSASSIGN_ERROR = 109;
  UI_R_SYSDASSGN_ERROR = 110;
  UI_R_SYSQIOW_ERROR = 111;
  UI_R_UNKNOWN_CONTROL_COMMAND = 106;
  UI_R_UNKNOWN_TTYGET_ERRNO_VALUE = 108;
  UI_R_USER_DATA_DUPLICATION_UNSUPPORTED = 112;
  
  UI_INPUT_FLAG_ECHO = $01;
  UI_INPUT_FLAG_DEFAULT_PWD = $02;  
  UI_INPUT_FLAG_USER_BASE = 16;
  
  UI_CTRL_PRINT_ERRORS = 1;
  UI_CTRL_IS_REDOABLE = 2;
  
  ERR_TXT_MALLOCED = $01;
  ERR_TXT_STRING = $02;
  
  ERR_FLAG_MARK = $01;
  ERR_FLAG_CLEAR = $02;
  
  ERR_NUM_ERRORS = 16;
  
  ERR_LIB_NONE = 1;
  ERR_LIB_SYS = 2;
  ERR_LIB_BN = 3;
  ERR_LIB_RSA = 4;
  ERR_LIB_DH = 5;
  ERR_LIB_EVP = 6;
  ERR_LIB_BUF = 7;
  ERR_LIB_OBJ = 8;
  ERR_LIB_PEM = 9;
  ERR_LIB_DSA = 10;
  ERR_LIB_X509 = 11;
  ERR_LIB_ASN1 = 13;
  ERR_LIB_CONF = 14;
  ERR_LIB_CRYPTO = 15;
  ERR_LIB_EC = 16;
  ERR_LIB_SSL = 20;
  ERR_LIB_BIO = 32;
  ERR_LIB_PKCS7 = 33;
  ERR_LIB_X509V3 = 34;
  ERR_LIB_PKCS12 = 35;
  ERR_LIB_RAND = 36;
  ERR_LIB_DSO = 37;
  ERR_LIB_ENGINE = 38;
  ERR_LIB_OCSP = 39;
  ERR_LIB_UI = 40;
  ERR_LIB_COMP = 41;
  ERR_LIB_ECDSA = 42;
  ERR_LIB_ECDH = 43;
  ERR_LIB_OSSL_STORE = 44;
  ERR_LIB_FIPS = 45;
  ERR_LIB_CMS = 46;
  ERR_LIB_TS = 47;
  ERR_LIB_HMAC = 48;
  ERR_LIB_CT = 50;
  ERR_LIB_ASYNC = 51;
  ERR_LIB_KDF = 52;
  ERR_LIB_SM2 = 53;
  ERR_LIB_USER = 128;
  
  SYS_F_FOPEN = 1;
  SYS_F_CONNECT = 2;
  SYS_F_GETSERVBYNAME = 3;
  SYS_F_SOCKET = 4;
  SYS_F_IOCTLSOCKET = 5;
  SYS_F_BIND = 6;
  SYS_F_LISTEN = 7;
  SYS_F_ACCEPT = 8;
  SYS_F_WSASTARTUP = 9;
  SYS_F_OPENDIR = 10;
  SYS_F_FREAD = 11;
  SYS_F_GETADDRINFO = 12;
  SYS_F_GETNAMEINFO = 13;
  SYS_F_SETSOCKOPT = 14;
  SYS_F_GETSOCKOPT = 15;
  SYS_F_GETSOCKNAME = 16;
  SYS_F_GETHOSTBYNAME = 17;
  SYS_F_FFLUSH = 18;
  SYS_F_OPEN = 19;
  SYS_F_CLOSE = 20;
  SYS_F_IOCTL = 21;
  SYS_F_STAT = 22;
  SYS_F_FCNTL = 23;
  SYS_F_FSTAT = 24;
  
  ERR_R_SYS_LIB = ERR_LIB_SYS;
  ERR_R_BN_LIB = ERR_LIB_BN;
  ERR_R_RSA_LIB = ERR_LIB_RSA;
  ERR_R_DH_LIB = ERR_LIB_DH;
  ERR_R_EVP_LIB = ERR_LIB_EVP;
  ERR_R_BUF_LIB = ERR_LIB_BUF;
  ERR_R_OBJ_LIB = ERR_LIB_OBJ;
  ERR_R_PEM_LIB = ERR_LIB_PEM;
  ERR_R_DSA_LIB = ERR_LIB_DSA;
  ERR_R_X509_LIB = ERR_LIB_X509;
  ERR_R_ASN1_LIB = ERR_LIB_ASN1;
  ERR_R_EC_LIB = ERR_LIB_EC;
  ERR_R_BIO_LIB = ERR_LIB_BIO;
  ERR_R_PKCS7_LIB = ERR_LIB_PKCS7;
  ERR_R_X509V3_LIB = ERR_LIB_X509V3;
  ERR_R_ENGINE_LIB = ERR_LIB_ENGINE;
  ERR_R_UI_LIB = ERR_LIB_UI;
  ERR_R_ECDSA_LIB = ERR_LIB_ECDSA;
  ERR_R_OSSL_STORE_LIB = ERR_LIB_OSSL_STORE;
  ERR_R_NESTED_ASN1_ERROR = 58;
  ERR_R_MISSING_ASN1_EOS = 63;
  ERR_R_FATAL = 64;
  ERR_R_MALLOC_FAILURE = 1 or ERR_R_FATAL;
  ERR_R_SHOULD_NOT_HAVE_BEEN_CALLED = 2 or ERR_R_FATAL;
  ERR_R_PASSED_NULL_PARAMETER = 3 or ERR_R_FATAL;
  ERR_R_INTERNAL_ERROR = 4 or ERR_R_FATAL;
  ERR_R_DISABLED = 5 or ERR_R_FATAL;
  ERR_R_INIT_FAIL = 6 or ERR_R_FATAL;
  ERR_R_PASSED_INVALID_ARGUMENT = 7;
  ERR_R_OPERATION_FAIL = 8 or ERR_R_FATAL;
  
  ENGINE_F_DIGEST_UPDATE = 198;
  ENGINE_F_DYNAMIC_CTRL = 180;
  ENGINE_F_DYNAMIC_GET_DATA_CTX = 181;
  ENGINE_F_DYNAMIC_LOAD = 182;
  ENGINE_F_DYNAMIC_SET_DATA_CTX = 183;
  ENGINE_F_ENGINE_ADD = 105;
  ENGINE_F_ENGINE_BY_ID = 106;
  ENGINE_F_ENGINE_CMD_IS_EXECUTABLE = 170;
  ENGINE_F_ENGINE_CTRL = 142;
  ENGINE_F_ENGINE_CTRL_CMD = 178;
  ENGINE_F_ENGINE_CTRL_CMD_STRING = 171;
  ENGINE_F_ENGINE_FINISH = 107;
  ENGINE_F_ENGINE_GET_CIPHER = 185;
  ENGINE_F_ENGINE_GET_DIGEST = 186;
  ENGINE_F_ENGINE_GET_FIRST = 195;
  ENGINE_F_ENGINE_GET_LAST = 196;
  ENGINE_F_ENGINE_GET_NEXT = 115;
  ENGINE_F_ENGINE_GET_PKEY_ASN1_METH = 193;
  ENGINE_F_ENGINE_GET_PKEY_METH = 192;
  ENGINE_F_ENGINE_GET_PREV = 116;
  ENGINE_F_ENGINE_INIT = 119;
  ENGINE_F_ENGINE_LIST_ADD = 120;
  ENGINE_F_ENGINE_LIST_REMOVE = 121;
  ENGINE_F_ENGINE_LOAD_PRIVATE_KEY = 150;
  ENGINE_F_ENGINE_LOAD_PUBLIC_KEY = 151;
  ENGINE_F_ENGINE_LOAD_SSL_CLIENT_CERT = 194;
  ENGINE_F_ENGINE_NEW = 122;
  ENGINE_F_ENGINE_PKEY_ASN1_FIND_STR = 197;
  ENGINE_F_ENGINE_REMOVE = 123;
  ENGINE_F_ENGINE_SET_DEFAULT_STRING = 189;
  ENGINE_F_ENGINE_SET_ID = 129;
  ENGINE_F_ENGINE_SET_NAME = 130;
  ENGINE_F_ENGINE_TABLE_REGISTER = 184;
  ENGINE_F_ENGINE_UNLOCKED_FINISH = 191;
  ENGINE_F_ENGINE_UP_REF = 190;
  ENGINE_F_INT_CLEANUP_ITEM = 199;
  ENGINE_F_INT_CTRL_HELPER = 172;
  ENGINE_F_INT_ENGINE_CONFIGURE = 188;
  ENGINE_F_INT_ENGINE_MODULE_INIT = 187;
  ENGINE_F_OSSL_HMAC_INIT = 200;
  
  ENGINE_R_ALREADY_LOADED = 100;
  ENGINE_R_ARGUMENT_IS_NOT_A_NUMBER = 133;
  ENGINE_R_CMD_NOT_EXECUTABLE = 134;
  ENGINE_R_COMMAND_TAKES_INPUT = 135;
  ENGINE_R_COMMAND_TAKES_NO_INPUT = 136;
  ENGINE_R_CONFLICTING_ENGINE_ID = 103;
  ENGINE_R_CTRL_COMMAND_NOT_IMPLEMENTED = 119;
  ENGINE_R_DSO_FAILURE = 104;
  ENGINE_R_DSO_NOT_FOUND = 132;
  ENGINE_R_ENGINES_SECTION_ERROR = 148;
  ENGINE_R_ENGINE_CONFIGURATION_ERROR = 102;
  ENGINE_R_ENGINE_IS_NOT_IN_LIST = 105;
  ENGINE_R_ENGINE_SECTION_ERROR = 149;
  ENGINE_R_FAILED_LOADING_PRIVATE_KEY = 128;
  ENGINE_R_FAILED_LOADING_PUBLIC_KEY = 129;
  ENGINE_R_FINISH_FAILED = 106;
  ENGINE_R_ID_OR_NAME_MISSING = 108;
  ENGINE_R_INIT_FAILED = 109;
  ENGINE_R_INTERNAL_LIST_ERROR = 110;
  ENGINE_R_INVALID_ARGUMENT = 143;
  ENGINE_R_INVALID_CMD_NAME = 137;
  ENGINE_R_INVALID_CMD_NUMBER = 138;
  ENGINE_R_INVALID_INIT_VALUE = 151;
  ENGINE_R_INVALID_STRING = 150;
  ENGINE_R_NOT_INITIALISED = 117;
  ENGINE_R_NOT_LOADED = 112;
  ENGINE_R_NO_CONTROL_FUNCTION = 120;
  ENGINE_R_NO_INDEX = 144;
  ENGINE_R_NO_LOAD_FUNCTION = 125;
  ENGINE_R_NO_REFERENCE = 130;
  ENGINE_R_NO_SUCH_ENGINE = 116;
  ENGINE_R_UNIMPLEMENTED_CIPHER = 146;
  ENGINE_R_UNIMPLEMENTED_DIGEST = 147;
  ENGINE_R_UNIMPLEMENTED_PUBLIC_KEY_METHOD = 101;
  ENGINE_R_VERSION_INCOMPATIBILITY = 145;
  
  ENGINE_CTRL_SET_LOGSTREAM = 1;
  ENGINE_CTRL_SET_PASSWORD_CALLBACK = 2;
  ENGINE_CTRL_HUP = 3;
  ENGINE_CTRL_SET_USER_INTERFACE = 4;
  ENGINE_CTRL_SET_CALLBACK_DATA = 5;
  ENGINE_CTRL_LOAD_CONFIGURATION = 6;
  ENGINE_CTRL_LOAD_SECTION = 7;
  ENGINE_CTRL_HAS_CTRL_FUNCTION = 10;
  ENGINE_CTRL_GET_FIRST_CMD_TYPE = 11;
  ENGINE_CTRL_GET_NEXT_CMD_TYPE = 12;
  ENGINE_CTRL_GET_CMD_FROM_NAME = 13;
  ENGINE_CTRL_GET_NAME_LEN_FROM_CMD = 14;
  ENGINE_CTRL_GET_NAME_FROM_CMD = 15;
  ENGINE_CTRL_GET_DESC_LEN_FROM_CMD = 16;
  ENGINE_CTRL_GET_DESC_FROM_CMD = 17;
  ENGINE_CTRL_GET_CMD_FLAGS = 18;
  ENGINE_CMD_BASE = 200;
  ENGINE_CTRL_CHIL_SET_FORKCHECK = 100;
  ENGINE_CTRL_CHIL_NO_LOCKING = 101;
  
  HMAC_MAX_MD_CBLOCK = 128;
  
  _IDEA_ENCRYPT = 1;
  IDEA_DECRYPT = 0;
  IDEA_BLOCK = 8;
  IDEA_KEY_LENGTH = 16;
  
  KDF_F_PKEY_HKDF_CTRL_STR = 103;
  KDF_F_PKEY_HKDF_DERIVE = 102;
  KDF_F_PKEY_HKDF_INIT = 108;
  KDF_F_PKEY_SCRYPT_CTRL_STR = 104;
  KDF_F_PKEY_SCRYPT_CTRL_UINT64 = 105;
  KDF_F_PKEY_SCRYPT_DERIVE = 109;
  KDF_F_PKEY_SCRYPT_INIT = 106;
  KDF_F_PKEY_SCRYPT_SET_MEMBUF = 107;
  KDF_F_PKEY_TLS1_PRF_CTRL_STR = 100;
  KDF_F_PKEY_TLS1_PRF_DERIVE = 101;
  KDF_F_PKEY_TLS1_PRF_INIT = 110;
  KDF_F_TLS1_PRF_ALG = 111;
  
  KDF_R_INVALID_DIGEST = 100;
  KDF_R_MISSING_ITERATION_COUNT = 109;
  KDF_R_MISSING_KEY = 104;
  KDF_R_MISSING_MESSAGE_DIGEST = 105;
  KDF_R_MISSING_PARAMETER = 101;
  KDF_R_MISSING_PASS = 110;
  KDF_R_MISSING_SALT = 111;
  KDF_R_MISSING_SECRET = 107;
  KDF_R_MISSING_SEED = 106;
  KDF_R_UNKNOWN_PARAMETER_TYPE = 103;
  KDF_R_VALUE_ERROR = 108;
  KDF_R_VALUE_MISSING = 102;
  
  EVP_PKEY_CTRL_TLS_MD = EVP_PKEY_ALG_CTRL;
  EVP_PKEY_CTRL_TLS_SECRET = EVP_PKEY_ALG_CTRL + 1;
  EVP_PKEY_CTRL_TLS_SEED = EVP_PKEY_ALG_CTRL + 2;
  EVP_PKEY_CTRL_HKDF_MD = EVP_PKEY_ALG_CTRL + 3;
  EVP_PKEY_CTRL_HKDF_SALT = EVP_PKEY_ALG_CTRL + 4;
  EVP_PKEY_CTRL_HKDF_KEY = EVP_PKEY_ALG_CTRL + 5;
  EVP_PKEY_CTRL_HKDF_INFO = EVP_PKEY_ALG_CTRL + 6;
  EVP_PKEY_CTRL_HKDF_MODE = EVP_PKEY_ALG_CTRL + 7;
  EVP_PKEY_CTRL_PASS = EVP_PKEY_ALG_CTRL + 8;
  EVP_PKEY_CTRL_SCRYPT_SALT = EVP_PKEY_ALG_CTRL + 9;
  EVP_PKEY_CTRL_SCRYPT_N = EVP_PKEY_ALG_CTRL + 10;
  EVP_PKEY_CTRL_SCRYPT_R = EVP_PKEY_ALG_CTRL + 11;
  EVP_PKEY_CTRL_SCRYPT_P = EVP_PKEY_ALG_CTRL + 12;
  EVP_PKEY_CTRL_SCRYPT_MAXMEM_BYTES = EVP_PKEY_ALG_CTRL + 13;
  EVP_PKEY_HKDEF_MODE_EXTRACT_AND_EXPAND = 0;
  EVP_PKEY_HKDEF_MODE_EXTRACT_ONLY = 1;
  EVP_PKEY_HKDEF_MODE_EXPAND_ONLY = 2;
  
  MD4_CBLOCK = 64;
  MD4_LBLOCK = MD4_CBLOCK div 4;
  MD4_DIGEST_LENGTH = 16;
  
  MD5_CBLOCK = 64;
  MD5_LBLOCK = MD5_CBLOCK div 4;
  MD5_DIGEST_LENGTH = 16;
  
  MDC2_BLOCK = 8;
  MDC2_DIGEST_LENGTH = 16;
  
  OCSP_REVOKED_STATUS_NOSTATUS = -1;
  OCSP_REVOKED_STATUS_UNSPECIFIED = 0;
  OCSP_REVOKED_STATUS_KEYCOMPROMISE = 1;
  OCSP_REVOKED_STATUS_CACOMPROMISE = 2;
  OCSP_REVOKED_STATUS_AFFILIATIONCHANGED = 3;
  OCSP_REVOKED_STATUS_SUPERSEDED = 4;
  OCSP_REVOKED_STATUS_CESSATIONOFOPERATION = 5;
  OCSP_REVOKED_STATUS_CERTIFICATEHOLD = 6;
  OCSP_REVOKED_STATUS_REMOVEFROMCRL = 8;
  
  OCSP_F_D2I_OCSP_NONCE = 102;
  OCSP_F_OCSP_BASIC_ADD1_STATUS = 103;
  OCSP_F_OCSP_BASIC_SIGN = 104;
  OCSP_F_OCSP_BASIC_SIGN_CTX = 119;
  OCSP_F_OCSP_BASIC_VERIFY = 105;
  OCSP_F_OCSP_CERT_ID_NEW = 101;
  OCSP_F_OCSP_CHECK_DELEGATED = 106;
  OCSP_F_OCSP_CHECK_IDS = 107;
  OCSP_F_OCSP_CHECK_ISSUER = 108;
  OCSP_F_OCSP_CHECK_VALIDITY = 115;
  OCSP_F_OCSP_MATCH_ISSUERID = 109;
  OCSP_F_OCSP_PARSE_URL = 114;
  OCSP_F_OCSP_REQUEST_SIGN = 110;
  OCSP_F_OCSP_REQUEST_VERIFY = 116;
  OCSP_F_OCSP_RESPONSE_GET1_BASIC = 111;
  OCSP_F_PARSE_HTTP_LINE1 = 118;
  
  OCSP_R_CERTIFICATE_VERIFY_ERROR = 101;
  OCSP_R_DIGEST_ERR = 102;
  OCSP_R_ERROR_IN_NEXTUPDATE_FIELD = 122;
  OCSP_R_ERROR_IN_THISUPDATE_FIELD = 123;
  OCSP_R_ERROR_PARSING_URL = 121;
  OCSP_R_MISSING_OCSPSIGNING_USAGE = 103;
  OCSP_R_NEXTUPDATE_BEFORE_THISUPDATE = 124;
  OCSP_R_NOT_BASIC_RESPONSE = 104;
  OCSP_R_NO_CERTIFICATES_IN_CHAIN = 105;
  OCSP_R_NO_RESPONSE_DATA = 108;
  OCSP_R_NO_REVOKED_TIME = 109;
  OCSP_R_NO_SIGNER_KEY = 130;
  OCSP_R_PRIVATE_KEY_DOES_NOT_MATCH_CERTIFICATE = 110;
  OCSP_R_REQUEST_NOT_SIGNED = 128;
  OCSP_R_RESPONSE_CONTAINS_NO_REVOCATION_DATA = 111;
  OCSP_R_ROOT_CA_NOT_TRUSTED = 112;
  OCSP_R_SERVER_RESPONSE_ERROR = 114;
  OCSP_R_SERVER_RESPONSE_PARSE_ERROR = 115;
  OCSP_R_SIGNATURE_FAILURE = 117;
  OCSP_R_SIGNER_CERTIFICATE_NOT_FOUND = 118;
  OCSP_R_STATUS_EXPIRED = 125;
  OCSP_R_STATUS_NOT_YET_VALID = 126;
  OCSP_R_STATUS_TOO_OLD = 127;
  OCSP_R_UNKNOWN_MESSAGE_DIGEST = 119;
  OCSP_R_UNKNOWN_NID = 120;
  OCSP_R_UNSUPPORTED_REQUESTORNAME_TYPE = 129;
  
  OCSP_DEFAULT_NONCE_LENGTH = 16;
  OCSP_NOCERTS = $1;
  OCSP_NOINTERN = $2;
  OCSP_NOSIGS = $4;
  OCSP_NOCHAIN = $8;
  OCSP_NOVERIFY = $10;
  OCSP_NOEXPLICIT = $20;
  OCSP_NOCASIGN = $40;
  OCSP_NODELEGATED = $80;
  OCSP_NOCHECKS = $100;
  OCSP_TRUSTOTHER = $200;
  OCSP_RESPID_KEY = $400;
  OCSP_NOTIME = $800;
  
  OCSP_RESPONSE_STATUS_SUCCESSFUL = 0;
  OCSP_RESPONSE_STATUS_MALFORMEDREQUEST = 1;
  OCSP_RESPONSE_STATUS_INTERNALERROR = 2;
  OCSP_RESPONSE_STATUS_TRYLATER = 3;
  OCSP_RESPONSE_STATUS_SIGREQUIRED = 5;
  OCSP_RESPONSE_STATUS_UNAUTHORIZED = 6;
  
  V_OCSP_RESPID_NAME = 0;
  V_OCSP_RESPID_KEY = 1;
  V_OCSP_CERTSTATUS_GOOD = 0;
  V_OCSP_CERTSTATUS_REVOKED = 1;
  V_OCSP_CERTSTATUS_UNKNOWN = 2;
  
  PEM_STRING_OCSP_REQUEST = 'OCSP REQUEST';
  PEM_STRING_OCSP_RESPONSE = 'OCSP RESPONSE';
  
  PKCS12_F_OPENSSL_ASC2UNI = 121;
  PKCS12_F_OPENSSL_UNI2ASC = 124;
  PKCS12_F_OPENSSL_UNI2UTF8 = 127;
  PKCS12_F_OPENSSL_UTF82UNI = 129;
  PKCS12_F_PKCS12_CREATE = 105;
  PKCS12_F_PKCS12_GEN_MAC = 107;
  PKCS12_F_PKCS12_INIT = 109;
  PKCS12_F_PKCS12_ITEM_DECRYPT_D2I = 106;
  PKCS12_F_PKCS12_ITEM_I2D_ENCRYPT = 108;
  PKCS12_F_PKCS12_ITEM_PACK_SAFEBAG = 117;
  PKCS12_F_PKCS12_KEY_GEN_ASC = 110;
  PKCS12_F_PKCS12_KEY_GEN_UNI = 111;
  PKCS12_F_PKCS12_KEY_GEN_UTF8 = 116;
  PKCS12_F_PKCS12_NEWPASS = 128;
  PKCS12_F_PKCS12_PACK_P7DATA = 114;
  PKCS12_F_PKCS12_PACK_P7ENCDATA = 115;
  PKCS12_F_PKCS12_PARSE = 118;
  PKCS12_F_PKCS12_PBE_CRYPT = 119;
  PKCS12_F_PKCS12_PBE_KEYIVGEN = 120;
  PKCS12_F_PKCS12_SAFEBAG_CREATE0_P8INF = 112;
  PKCS12_F_PKCS12_SAFEBAG_CREATE0_PKCS8 = 113;
  PKCS12_F_PKCS12_SAFEBAG_CREATE_PKCS8_ENCRYPT = 133;
  PKCS12_F_PKCS12_SETUP_MAC = 122;
  PKCS12_F_PKCS12_SET_MAC = 123;
  PKCS12_F_PKCS12_UNPACK_AUTHSAFES = 130;
  PKCS12_F_PKCS12_UNPACK_P7DATA = 131;
  PKCS12_F_PKCS12_VERIFY_MAC = 126;
  PKCS12_F_PKCS8_ENCRYPT = 125;
  PKCS12_F_PKCS8_SET0_PBE = 132;
  
  PKCS12_R_CANT_PACK_STRUCTURE = 100;
  PKCS12_R_CONTENT_TYPE_NOT_DATA = 121;
  PKCS12_R_DECODE_ERROR = 101;
  PKCS12_R_ENCODE_ERROR = 102;
  PKCS12_R_ENCRYPT_ERROR = 103;
  PKCS12_R_ERROR_SETTING_ENCRYPTED_DATA_TYPE = 120;
  PKCS12_R_INVALID_NULL_ARGUMENT = 104;
  PKCS12_R_INVALID_NULL_PKCS12_POINTER = 105;
  PKCS12_R_IV_GEN_ERROR = 106;
  PKCS12_R_KEY_GEN_ERROR = 107;
  PKCS12_R_MAC_ABSENT = 108;
  PKCS12_R_MAC_GENERATION_ERROR = 109;
  PKCS12_R_MAC_SETUP_ERROR = 110;
  PKCS12_R_MAC_STRING_SET_ERROR = 111;
  PKCS12_R_MAC_VERIFY_FAILURE = 113;
  PKCS12_R_PARSE_ERROR = 114;
  PKCS12_R_PKCS12_ALGOR_CIPHERINIT_ERROR = 115;
  PKCS12_R_PKCS12_CIPHERFINAL_ERROR = 116;
  PKCS12_R_PKCS12_PBE_CRYPT_ERROR = 117;
  PKCS12_R_UNKNOWN_DIGEST_ALGORITHM = 118;
  PKCS12_R_UNSUPPORTED_PKCS12_MODE = 119;
  
  KEY_EX = $10;
  KEY_SIG = $80;
  
  PKCS12_ERROR = 0;
  PKCS12_OK = 1;
  
  RAND_DRBG_FLAG_CTR_NO_DF = $1;
  RAND_DRBG_USED_FLAGS = RAND_DRBG_FLAG_CTR_NO_DF;
  RAND_DRBG_STRENGTH = 256;
  RAND_DRBG_TYPE = NID_aes_256_ctr;
  RAND_DRBG_FLAGS = 0;
  
  _RC2_ENCRYPT = 1;
  _RC2_DECRYPT = 0;
  RC2_BLOCK = 8;
  RC2_KEY_LENGTH = 16;
  
  RIPEMD160_CBLOCK = 64;
  RIPEMD160_LBLOCK = RIPEMD160_CBLOCK div 4;
  RIPEMD160_DIGEST_LENGTH = 20;
  
  SEED_BLOCK_SIZE = 16;
  SEED_KEY_LENGTH = 16;
  
  SRP_NO_ERROR = 0;
  SRP_ERR_VBASE_INCOMPLETE_FILE = 1;
  SRP_ERR_VBASE_BN_LIB = 2;
  SRP_ERR_OPEN_FILE = 3;
  SRP_ERR_MEMORY = 4;
  
  DB_srptype = 0;
  DB_srpverifier = 1;
  DB_srpsalt = 2;
  DB_srpid = 3;
  DB_srpgN = 4;
  DB_srpinfo = 5;
  DB_NUMBER = 6;
  DB_SRP_INDEX = 'I';
  DB_SRP_VALID = 'V';
  DB_SRP_REVOKED = 'R';
  DB_SRP_MODIF = 'v';
  
  SRP_MINIMAL_N = 1024;
  
  SSL_F_ADD_CLIENT_KEY_SHARE_EXT = 438;
  SSL_F_ADD_KEY_SHARE = 512;
  SSL_F_BYTES_TO_CIPHER_LIST = 519;
  SSL_F_CHECK_SUITEB_CIPHER_LIST = 331;
  SSL_F_CIPHERSUITE_CB = 622;
  SSL_F_CONSTRUCT_CA_NAMES = 552;
  SSL_F_CONSTRUCT_KEY_EXCHANGE_TBS = 553;
  SSL_F_CONSTRUCT_STATEFUL_TICKET = 636;
  SSL_F_CONSTRUCT_STATELESS_TICKET = 637;
  SSL_F_CREATE_SYNTHETIC_MESSAGE_HASH = 539;
  SSL_F_CREATE_TICKET_PREQUEL = 638;
  SSL_F_CT_MOVE_SCTS = 345;
  SSL_F_CT_STRICT = 349;
  SSL_F_CUSTOM_EXT_ADD = 554;
  SSL_F_CUSTOM_EXT_PARSE = 555;
  SSL_F_D2I_SSL_SESSION = 103;
  SSL_F_DANE_CTX_ENABLE = 347;
  SSL_F_DANE_MTYPE_SET = 393;
  SSL_F_DANE_TLSA_ADD = 394;
  SSL_F_DERIVE_SECRET_KEY_AND_IV = 514;
  SSL_F_DO_DTLS1_WRITE = 245;
  SSL_F_DO_SSL3_WRITE = 104;
  SSL_F_DTLS1_BUFFER_RECORD = 247;
  SSL_F_DTLS1_CHECK_TIMEOUT_NUM = 318;
  SSL_F_DTLS1_HEARTBEAT = 305;
  SSL_F_DTLS1_HM_FRAGMENT_NEW = 623;
  SSL_F_DTLS1_PREPROCESS_FRAGMENT = 288;
  SSL_F_DTLS1_PROCESS_BUFFERED_RECORDS = 424;
  SSL_F_DTLS1_PROCESS_RECORD = 257;
  SSL_F_DTLS1_READ_BYTES = 258;
  SSL_F_DTLS1_READ_FAILED = 339;
  SSL_F_DTLS1_RETRANSMIT_MESSAGE = 390;
  SSL_F_DTLS1_WRITE_APP_DATA_BYTES = 268;
  SSL_F_DTLS1_WRITE_BYTES = 545;
  SSL_F_DTLSV1_LISTEN = 350;
  SSL_F_DTLS_CONSTRUCT_CHANGE_CIPHER_SPEC = 371;
  SSL_F_DTLS_CONSTRUCT_HELLO_VERIFY_REQUEST = 385;
  SSL_F_DTLS_GET_REASSEMBLED_MESSAGE = 370;
  SSL_F_DTLS_PROCESS_HELLO_VERIFY = 386;
  SSL_F_DTLS_RECORD_LAYER_NEW = 635;
  SSL_F_DTLS_WAIT_FOR_DRY = 592;
  SSL_F_EARLY_DATA_COUNT_OK = 532;
  SSL_F_FINAL_EARLY_DATA = 556;
  SSL_F_FINAL_EC_PT_FORMATS = 485;
  SSL_F_FINAL_EMS = 486;
  SSL_F_FINAL_KEY_SHARE = 503;
  SSL_F_FINAL_MAXFRAGMENTLEN = 557;
  SSL_F_FINAL_RENEGOTIATE = 483;
  SSL_F_FINAL_SERVER_NAME = 558;
  SSL_F_FINAL_SIG_ALGS = 497;
  SSL_F_GET_CERT_VERIFY_TBS_DATA = 588;
  SSL_F_NSS_KEYLOG_INT = 500;
  SSL_F_OPENSSL_INIT_SSL = 342;
  SSL_F_OSSL_STATEM_CLIENT13_READ_TRANSITION = 436;
  SSL_F_OSSL_STATEM_CLIENT13_WRITE_TRANSITION = 598;
  SSL_F_OSSL_STATEM_CLIENT_CONSTRUCT_MESSAGE = 430;
  SSL_F_OSSL_STATEM_CLIENT_POST_PROCESS_MESSAGE = 593;
  SSL_F_OSSL_STATEM_CLIENT_PROCESS_MESSAGE = 594;
  SSL_F_OSSL_STATEM_CLIENT_READ_TRANSITION = 417;
  SSL_F_OSSL_STATEM_CLIENT_WRITE_TRANSITION = 599;
  SSL_F_OSSL_STATEM_SERVER13_READ_TRANSITION = 437;
  SSL_F_OSSL_STATEM_SERVER13_WRITE_TRANSITION = 600;
  SSL_F_OSSL_STATEM_SERVER_CONSTRUCT_MESSAGE = 431;
  SSL_F_OSSL_STATEM_SERVER_POST_PROCESS_MESSAGE = 601;
  SSL_F_OSSL_STATEM_SERVER_POST_WORK = 602;
  SSL_F_OSSL_STATEM_SERVER_PRE_WORK = 640;
  SSL_F_OSSL_STATEM_SERVER_PROCESS_MESSAGE = 603;
  SSL_F_OSSL_STATEM_SERVER_READ_TRANSITION = 418;
  SSL_F_OSSL_STATEM_SERVER_WRITE_TRANSITION = 604;
  SSL_F_PARSE_CA_NAMES = 541;
  SSL_F_PITEM_NEW = 624;
  SSL_F_PQUEUE_NEW = 625;
  SSL_F_PROCESS_KEY_SHARE_EXT = 439;
  SSL_F_READ_STATE_MACHINE = 352;
  SSL_F_SET_CLIENT_CIPHERSUITE = 540;
  SSL_F_SRP_GENERATE_CLIENT_MASTER_SECRET = 595;
  SSL_F_SRP_GENERATE_SERVER_MASTER_SECRET = 589;
  SSL_F_SRP_VERIFY_SERVER_PARAM = 596;
  SSL_F_SSL3_CHANGE_CIPHER_STATE = 129;
  SSL_F_SSL3_CHECK_CERT_AND_ALGORITHM = 130;
  SSL_F_SSL3_CTRL = 213;
  SSL_F_SSL3_CTX_CTRL = 133;
  SSL_F_SSL3_DIGEST_CACHED_RECORDS = 293;
  SSL_F_SSL3_DO_CHANGE_CIPHER_SPEC = 292;
  SSL_F_SSL3_ENC = 608;
  SSL_F_SSL3_FINAL_FINISH_MAC = 285;
  SSL_F_SSL3_FINISH_MAC = 587;
  SSL_F_SSL3_GENERATE_KEY_BLOCK = 238;
  SSL_F_SSL3_GENERATE_MASTER_SECRET = 388;
  SSL_F_SSL3_GET_RECORD = 143;
  SSL_F_SSL3_INIT_FINISHED_MAC = 397;
  SSL_F_SSL3_OUTPUT_CERT_CHAIN = 147;
  SSL_F_SSL3_READ_BYTES = 148;
  SSL_F_SSL3_READ_N = 149;
  SSL_F_SSL3_SETUP_KEY_BLOCK = 157;
  SSL_F_SSL3_SETUP_READ_BUFFER = 156;
  SSL_F_SSL3_SETUP_WRITE_BUFFER = 291;
  SSL_F_SSL3_WRITE_BYTES = 158;
  SSL_F_SSL3_WRITE_PENDING = 159;
  SSL_F_SSL_ADD_CERT_CHAIN = 316;
  SSL_F_SSL_ADD_CERT_TO_BUF = 319;
  SSL_F_SSL_ADD_CERT_TO_WPACKET = 493;
  SSL_F_SSL_ADD_CLIENTHELLO_RENEGOTIATE_EXT = 298;
  SSL_F_SSL_ADD_CLIENTHELLO_TLSEXT = 277;
  SSL_F_SSL_ADD_CLIENTHELLO_USE_SRTP_EXT = 307;
  SSL_F_SSL_ADD_DIR_CERT_SUBJECTS_TO_STACK = 215;
  SSL_F_SSL_ADD_FILE_CERT_SUBJECTS_TO_STACK = 216;
  SSL_F_SSL_ADD_SERVERHELLO_RENEGOTIATE_EXT = 299;
  SSL_F_SSL_ADD_SERVERHELLO_TLSEXT = 278;
  SSL_F_SSL_ADD_SERVERHELLO_USE_SRTP_EXT = 308;
  SSL_F_SSL_BAD_METHOD = 160;
  SSL_F_SSL_BUILD_CERT_CHAIN = 332;
  SSL_F_SSL_BYTES_TO_CIPHER_LIST = 161;
  SSL_F_SSL_CACHE_CIPHERLIST = 520;
  SSL_F_SSL_CERT_ADD0_CHAIN_CERT = 346;
  SSL_F_SSL_CERT_DUP = 221;
  SSL_F_SSL_CERT_NEW = 162;
  SSL_F_SSL_CERT_SET0_CHAIN = 340;
  SSL_F_SSL_CHECK_PRIVATE_KEY = 163;
  SSL_F_SSL_CHECK_SERVERHELLO_TLSEXT = 280;
  SSL_F_SSL_CHECK_SRP_EXT_CLIENTHELLO = 606;
  SSL_F_SSL_CHECK_SRVR_ECC_CERT_AND_ALG = 279;
  SSL_F_SSL_CHOOSE_CLIENT_VERSION = 607;
  SSL_F_SSL_CIPHER_DESCRIPTION = 626;
  SSL_F_SSL_CIPHER_LIST_TO_BYTES = 425;
  SSL_F_SSL_CIPHER_PROCESS_RULESTR = 230;
  SSL_F_SSL_CIPHER_STRENGTH_SORT = 231;
  SSL_F_SSL_CLEAR = 164;
  SSL_F_SSL_CLIENT_HELLO_GET1_EXTENSIONS_PRESENT = 627;
  SSL_F_SSL_COMP_ADD_COMPRESSION_METHOD = 165;
  SSL_F_SSL_CONF_CMD = 334;
  SSL_F_SSL_CREATE_CIPHER_LIST = 166;
  SSL_F_SSL_CTRL = 232;
  SSL_F_SSL_CTX_CHECK_PRIVATE_KEY = 168;
  SSL_F_SSL_CTX_ENABLE_CT = 398;
  SSL_F_SSL_CTX_MAKE_PROFILES = 309;
  SSL_F_SSL_CTX_NEW = 169;
  SSL_F_SSL_CTX_SET_ALPN_PROTOS = 343;
  SSL_F_SSL_CTX_SET_CIPHER_LIST = 269;
  SSL_F_SSL_CTX_SET_CLIENT_CERT_ENGINE = 290;
  SSL_F_SSL_CTX_SET_CT_VALIDATION_CALLBACK = 396;
  SSL_F_SSL_CTX_SET_SESSION_ID_CONTEXT = 219;
  SSL_F_SSL_CTX_SET_SSL_VERSION = 170;
  SSL_F_SSL_CTX_SET_TLSEXT_MAX_FRAGMENT_LENGTH = 551;
  SSL_F_SSL_CTX_USE_CERTIFICATE = 171;
  SSL_F_SSL_CTX_USE_CERTIFICATE_ASN1 = 172;
  SSL_F_SSL_CTX_USE_CERTIFICATE_FILE = 173;
  SSL_F_SSL_CTX_USE_PRIVATEKEY = 174;
  SSL_F_SSL_CTX_USE_PRIVATEKEY_ASN1 = 175;
  SSL_F_SSL_CTX_USE_PRIVATEKEY_FILE = 176;
  SSL_F_SSL_CTX_USE_PSK_IDENTITY_HINT = 272;
  SSL_F_SSL_CTX_USE_RSAPRIVATEKEY = 177;
  SSL_F_SSL_CTX_USE_RSAPRIVATEKEY_ASN1 = 178;
  SSL_F_SSL_CTX_USE_RSAPRIVATEKEY_FILE = 179;
  SSL_F_SSL_CTX_USE_SERVERINFO = 336;
  SSL_F_SSL_CTX_USE_SERVERINFO_EX = 543;
  SSL_F_SSL_CTX_USE_SERVERINFO_FILE = 337;
  SSL_F_SSL_DANE_DUP = 403;
  SSL_F_SSL_DANE_ENABLE = 395;
  SSL_F_SSL_DERIVE = 590;
  SSL_F_SSL_DO_CONFIG = 391;
  SSL_F_SSL_DO_HANDSHAKE = 180;
  SSL_F_SSL_DUP_CA_LIST = 408;
  SSL_F_SSL_ENABLE_CT = 402;
  SSL_F_SSL_GENERATE_PKEY_GROUP = 559;
  SSL_F_SSL_GENERATE_SESSION_ID = 547;
  SSL_F_SSL_GET_NEW_SESSION = 181;
  SSL_F_SSL_GET_PREV_SESSION = 217;
  SSL_F_SSL_GET_SERVER_CERT_INDEX = 322;
  SSL_F_SSL_GET_SIGN_PKEY = 183;
  SSL_F_SSL_HANDSHAKE_HASH = 560;
  SSL_F_SSL_INIT_WBIO_BUFFER = 184;
  SSL_F_SSL_KEY_UPDATE = 515;
  SSL_F_SSL_LOAD_CLIENT_CA_FILE = 185;
  SSL_F_SSL_LOG_MASTER_SECRET = 498;
  SSL_F_SSL_LOG_RSA_CLIENT_KEY_EXCHANGE = 499;
  SSL_F_SSL_MODULE_INIT = 392;
  SSL_F_SSL_NEW = 186;
  SSL_F_SSL_NEXT_PROTO_VALIDATE = 565;
  SSL_F_SSL_PARSE_CLIENTHELLO_RENEGOTIATE_EXT = 300;
  SSL_F_SSL_PARSE_CLIENTHELLO_TLSEXT = 302;
  SSL_F_SSL_PARSE_CLIENTHELLO_USE_SRTP_EXT = 310;
  SSL_F_SSL_PARSE_SERVERHELLO_RENEGOTIATE_EXT = 301;
  SSL_F_SSL_PARSE_SERVERHELLO_TLSEXT = 303;
  SSL_F_SSL_PARSE_SERVERHELLO_USE_SRTP_EXT = 311;
  SSL_F_SSL_PEEK = 270;
  SSL_F_SSL_PEEK_EX = 432;
  SSL_F_SSL_PEEK_INTERNAL = 522;
  SSL_F_SSL_READ = 223;
  SSL_F_SSL_READ_EARLY_DATA = 529;
  SSL_F_SSL_READ_EX = 434;
  SSL_F_SSL_READ_INTERNAL = 523;
  SSL_F_SSL_RENEGOTIATE = 516;
  SSL_F_SSL_RENEGOTIATE_ABBREVIATED = 546;
  SSL_F_SSL_SCAN_CLIENTHELLO_TLSEXT = 320;
  SSL_F_SSL_SCAN_SERVERHELLO_TLSEXT = 321;
  SSL_F_SSL_SESSION_DUP = 348;
  SSL_F_SSL_SESSION_NEW = 189;
  SSL_F_SSL_SESSION_PRINT_FP = 190;
  SSL_F_SSL_SESSION_SET1_ID = 423;
  SSL_F_SSL_SESSION_SET1_ID_CONTEXT = 312;
  SSL_F_SSL_SET_ALPN_PROTOS = 344;
  SSL_F_SSL_SET_CERT = 191;
  SSL_F_SSL_SET_CERT_AND_KEY = 621;
  SSL_F_SSL_SET_CIPHER_LIST = 271;
  SSL_F_SSL_SET_CT_VALIDATION_CALLBACK = 399;
  SSL_F_SSL_SET_FD = 192;
  SSL_F_SSL_SET_PKEY = 193;
  SSL_F_SSL_SET_RFD = 194;
  SSL_F_SSL_SET_SESSION = 195;
  SSL_F_SSL_SET_SESSION_ID_CONTEXT = 218;
  SSL_F_SSL_SET_SESSION_TICKET_EXT = 294;
  SSL_F_SSL_SET_TLSEXT_MAX_FRAGMENT_LENGTH = 550;
  SSL_F_SSL_SET_WFD = 196;
  SSL_F_SSL_SHUTDOWN = 224;
  SSL_F_SSL_SRP_CTX_INIT = 313;
  SSL_F_SSL_START_ASYNC_JOB = 389;
  SSL_F_SSL_UNDEFINED_FUNCTION = 197;
  SSL_F_SSL_UNDEFINED_VOID_FUNCTION = 244;
  SSL_F_SSL_USE_CERTIFICATE = 198;
  SSL_F_SSL_USE_CERTIFICATE_ASN1 = 199;
  SSL_F_SSL_USE_CERTIFICATE_FILE = 200;
  SSL_F_SSL_USE_PRIVATEKEY = 201;
  SSL_F_SSL_USE_PRIVATEKEY_ASN1 = 202;
  SSL_F_SSL_USE_PRIVATEKEY_FILE = 203;
  SSL_F_SSL_USE_PSK_IDENTITY_HINT = 273;
  SSL_F_SSL_USE_RSAPRIVATEKEY = 204;
  SSL_F_SSL_USE_RSAPRIVATEKEY_ASN1 = 205;
  SSL_F_SSL_USE_RSAPRIVATEKEY_FILE = 206;
  SSL_F_SSL_VALIDATE_CT = 400;
  SSL_F_SSL_VERIFY_CERT_CHAIN = 207;
  SSL_F_SSL_VERIFY_CLIENT_POST_HANDSHAKE = 616;
  SSL_F_SSL_WRITE = 208;
  SSL_F_SSL_WRITE_EARLY_DATA = 526;
  SSL_F_SSL_WRITE_EARLY_FINISH = 527;
  SSL_F_SSL_WRITE_EX = 433;
  SSL_F_SSL_WRITE_INTERNAL = 524;
  SSL_F_STATE_MACHINE = 353;
  SSL_F_TLS12_CHECK_PEER_SIGALG = 333;
  SSL_F_TLS12_COPY_SIGALGS = 533;
  SSL_F_TLS13_CHANGE_CIPHER_STATE = 440;
  SSL_F_TLS13_ENC = 609;
  SSL_F_TLS13_FINAL_FINISH_MAC = 605;
  SSL_F_TLS13_GENERATE_SECRET = 591;
  SSL_F_TLS13_HKDF_EXPAND = 561;
  SSL_F_TLS13_RESTORE_HANDSHAKE_DIGEST_FOR_PHA = 617;
  SSL_F_TLS13_SAVE_HANDSHAKE_DIGEST_FOR_PHA = 618;
  SSL_F_TLS13_SETUP_KEY_BLOCK = 441;
  SSL_F_TLS1_CHANGE_CIPHER_STATE = 209;
  SSL_F_TLS1_CHECK_DUPLICATE_EXTENSIONS = 341;
  SSL_F_TLS1_ENC = 401;
  SSL_F_TLS1_EXPORT_KEYING_MATERIAL = 314;
  SSL_F_TLS1_GET_CURVELIST = 338;
  SSL_F_TLS1_PRF = 284;
  SSL_F_TLS1_SAVE_U16 = 628;
  SSL_F_TLS1_SETUP_KEY_BLOCK = 211;
  SSL_F_TLS1_SET_GROUPS = 629;
  SSL_F_TLS1_SET_RAW_SIGALGS = 630;
  SSL_F_TLS1_SET_SERVER_SIGALGS = 335;
  SSL_F_TLS1_SET_SHARED_SIGALGS = 631;
  SSL_F_TLS1_SET_SIGALGS = 632;
  SSL_F_TLS_CHOOSE_SIGALG = 513;
  SSL_F_TLS_CLIENT_KEY_EXCHANGE_POST_WORK = 354;
  SSL_F_TLS_COLLECT_EXTENSIONS = 435;
  SSL_F_TLS_CONSTRUCT_CERTIFICATE_AUTHORITIES = 542;
  SSL_F_TLS_CONSTRUCT_CERTIFICATE_REQUEST = 372;
  SSL_F_TLS_CONSTRUCT_CERT_STATUS = 429;
  SSL_F_TLS_CONSTRUCT_CERT_STATUS_BODY = 494;
  SSL_F_TLS_CONSTRUCT_CERT_VERIFY = 496;
  SSL_F_TLS_CONSTRUCT_CHANGE_CIPHER_SPEC = 427;
  SSL_F_TLS_CONSTRUCT_CKE_DHE = 404;
  SSL_F_TLS_CONSTRUCT_CKE_ECDHE = 405;
  SSL_F_TLS_CONSTRUCT_CKE_GOST = 406;
  SSL_F_TLS_CONSTRUCT_CKE_PSK_PREAMBLE = 407;
  SSL_F_TLS_CONSTRUCT_CKE_RSA = 409;
  SSL_F_TLS_CONSTRUCT_CKE_SRP = 410;
  SSL_F_TLS_CONSTRUCT_CLIENT_CERTIFICATE = 484;
  SSL_F_TLS_CONSTRUCT_CLIENT_HELLO = 487;
  SSL_F_TLS_CONSTRUCT_CLIENT_KEY_EXCHANGE = 488;
  SSL_F_TLS_CONSTRUCT_CLIENT_VERIFY = 489;
  SSL_F_TLS_CONSTRUCT_CTOS_ALPN = 466;
  SSL_F_TLS_CONSTRUCT_CTOS_CERTIFICATE = 355;
  SSL_F_TLS_CONSTRUCT_CTOS_COOKIE = 535;
  SSL_F_TLS_CONSTRUCT_CTOS_EARLY_DATA = 530;
  SSL_F_TLS_CONSTRUCT_CTOS_EC_PT_FORMATS = 467;
  SSL_F_TLS_CONSTRUCT_CTOS_EMS = 468;
  SSL_F_TLS_CONSTRUCT_CTOS_ETM = 469;
  SSL_F_TLS_CONSTRUCT_CTOS_HELLO = 356;
  SSL_F_TLS_CONSTRUCT_CTOS_KEY_EXCHANGE = 357;
  SSL_F_TLS_CONSTRUCT_CTOS_KEY_SHARE = 470;
  SSL_F_TLS_CONSTRUCT_CTOS_MAXFRAGMENTLEN = 549;
  SSL_F_TLS_CONSTRUCT_CTOS_NPN = 471;
  SSL_F_TLS_CONSTRUCT_CTOS_PADDING = 472;
  SSL_F_TLS_CONSTRUCT_CTOS_POST_HANDSHAKE_AUTH = 619;
  SSL_F_TLS_CONSTRUCT_CTOS_PSK = 501;
  SSL_F_TLS_CONSTRUCT_CTOS_PSK_KEX_MODES = 509;
  SSL_F_TLS_CONSTRUCT_CTOS_RENEGOTIATE = 473;
  SSL_F_TLS_CONSTRUCT_CTOS_SCT = 474;
  SSL_F_TLS_CONSTRUCT_CTOS_SERVER_NAME = 475;
  SSL_F_TLS_CONSTRUCT_CTOS_SESSION_TICKET = 476;
  SSL_F_TLS_CONSTRUCT_CTOS_SIG_ALGS = 477;
  SSL_F_TLS_CONSTRUCT_CTOS_SRP = 478;
  SSL_F_TLS_CONSTRUCT_CTOS_STATUS_REQUEST = 479;
  SSL_F_TLS_CONSTRUCT_CTOS_SUPPORTED_GROUPS = 480;
  SSL_F_TLS_CONSTRUCT_CTOS_SUPPORTED_VERSIONS = 481;
  SSL_F_TLS_CONSTRUCT_CTOS_USE_SRTP = 482;
  SSL_F_TLS_CONSTRUCT_CTOS_VERIFY = 358;
  SSL_F_TLS_CONSTRUCT_ENCRYPTED_EXTENSIONS = 443;
  SSL_F_TLS_CONSTRUCT_END_OF_EARLY_DATA = 536;
  SSL_F_TLS_CONSTRUCT_EXTENSIONS = 447;
  SSL_F_TLS_CONSTRUCT_FINISHED = 359;
  SSL_F_TLS_CONSTRUCT_HELLO_REQUEST = 373;
  SSL_F_TLS_CONSTRUCT_HELLO_RETRY_REQUEST = 510;
  SSL_F_TLS_CONSTRUCT_KEY_UPDATE = 517;
  SSL_F_TLS_CONSTRUCT_NEW_SESSION_TICKET = 428;
  SSL_F_TLS_CONSTRUCT_NEXT_PROTO = 426;
  SSL_F_TLS_CONSTRUCT_SERVER_CERTIFICATE = 490;
  SSL_F_TLS_CONSTRUCT_SERVER_HELLO = 491;
  SSL_F_TLS_CONSTRUCT_SERVER_KEY_EXCHANGE = 492;
  SSL_F_TLS_CONSTRUCT_STOC_ALPN = 451;
  SSL_F_TLS_CONSTRUCT_STOC_CERTIFICATE = 374;
  SSL_F_TLS_CONSTRUCT_STOC_COOKIE = 613;
  SSL_F_TLS_CONSTRUCT_STOC_CRYPTOPRO_BUG = 452;
  SSL_F_TLS_CONSTRUCT_STOC_DONE = 375;
  SSL_F_TLS_CONSTRUCT_STOC_EARLY_DATA = 531;
  SSL_F_TLS_CONSTRUCT_STOC_EARLY_DATA_INFO = 525;
  SSL_F_TLS_CONSTRUCT_STOC_EC_PT_FORMATS = 453;
  SSL_F_TLS_CONSTRUCT_STOC_EMS = 454;
  SSL_F_TLS_CONSTRUCT_STOC_ETM = 455;
  SSL_F_TLS_CONSTRUCT_STOC_HELLO = 376;
  SSL_F_TLS_CONSTRUCT_STOC_KEY_EXCHANGE = 377;
  SSL_F_TLS_CONSTRUCT_STOC_KEY_SHARE = 456;
  SSL_F_TLS_CONSTRUCT_STOC_MAXFRAGMENTLEN = 548;
  SSL_F_TLS_CONSTRUCT_STOC_NEXT_PROTO_NEG = 457;
  SSL_F_TLS_CONSTRUCT_STOC_PSK = 504;
  SSL_F_TLS_CONSTRUCT_STOC_RENEGOTIATE = 458;
  SSL_F_TLS_CONSTRUCT_STOC_SERVER_NAME = 459;
  SSL_F_TLS_CONSTRUCT_STOC_SESSION_TICKET = 460;
  SSL_F_TLS_CONSTRUCT_STOC_STATUS_REQUEST = 461;
  SSL_F_TLS_CONSTRUCT_STOC_SUPPORTED_GROUPS = 544;
  SSL_F_TLS_CONSTRUCT_STOC_SUPPORTED_VERSIONS = 611;
  SSL_F_TLS_CONSTRUCT_STOC_USE_SRTP = 462;
  SSL_F_TLS_EARLY_POST_PROCESS_CLIENT_HELLO = 521;
  SSL_F_TLS_FINISH_HANDSHAKE = 597;
  SSL_F_TLS_GET_MESSAGE_BODY = 351;
  SSL_F_TLS_GET_MESSAGE_HEADER = 387;
  SSL_F_TLS_HANDLE_ALPN = 562;
  SSL_F_TLS_HANDLE_STATUS_REQUEST = 563;
  SSL_F_TLS_PARSE_CERTIFICATE_AUTHORITIES = 566;
  SSL_F_TLS_PARSE_CLIENTHELLO_TLSEXT = 449;
  SSL_F_TLS_PARSE_CTOS_ALPN = 567;
  SSL_F_TLS_PARSE_CTOS_COOKIE = 614;
  SSL_F_TLS_PARSE_CTOS_EARLY_DATA = 568;
  SSL_F_TLS_PARSE_CTOS_EC_PT_FORMATS = 569;
  SSL_F_TLS_PARSE_CTOS_EMS = 570;
  SSL_F_TLS_PARSE_CTOS_KEY_SHARE = 463;
  SSL_F_TLS_PARSE_CTOS_MAXFRAGMENTLEN = 571;
  SSL_F_TLS_PARSE_CTOS_POST_HANDSHAKE_AUTH = 620;
  SSL_F_TLS_PARSE_CTOS_PSK = 505;
  SSL_F_TLS_PARSE_CTOS_PSK_KEX_MODES = 572;
  SSL_F_TLS_PARSE_CTOS_RENEGOTIATE = 464;
  SSL_F_TLS_PARSE_CTOS_SERVER_NAME = 573;
  SSL_F_TLS_PARSE_CTOS_SESSION_TICKET = 574;
  SSL_F_TLS_PARSE_CTOS_SIG_ALGS = 575;
  SSL_F_TLS_PARSE_CTOS_SIG_ALGS_CERT = 615;
  SSL_F_TLS_PARSE_CTOS_SRP = 576;
  SSL_F_TLS_PARSE_CTOS_STATUS_REQUEST = 577;
  SSL_F_TLS_PARSE_CTOS_SUPPORTED_GROUPS = 578;
  SSL_F_TLS_PARSE_CTOS_USE_SRTP = 465;
  SSL_F_TLS_PARSE_STOC_ALPN = 579;
  SSL_F_TLS_PARSE_STOC_COOKIE = 534;
  SSL_F_TLS_PARSE_STOC_EARLY_DATA = 538;
  SSL_F_TLS_PARSE_STOC_EARLY_DATA_INFO = 528;
  SSL_F_TLS_PARSE_STOC_EC_PT_FORMATS = 580;
  SSL_F_TLS_PARSE_STOC_KEY_SHARE = 445;
  SSL_F_TLS_PARSE_STOC_MAXFRAGMENTLEN = 581;
  SSL_F_TLS_PARSE_STOC_NPN = 582;
  SSL_F_TLS_PARSE_STOC_PSK = 502;
  SSL_F_TLS_PARSE_STOC_RENEGOTIATE = 448;
  SSL_F_TLS_PARSE_STOC_SCT = 564;
  SSL_F_TLS_PARSE_STOC_SERVER_NAME = 583;
  SSL_F_TLS_PARSE_STOC_SESSION_TICKET = 584;
  SSL_F_TLS_PARSE_STOC_STATUS_REQUEST = 585;
  SSL_F_TLS_PARSE_STOC_SUPPORTED_VERSIONS = 612;
  SSL_F_TLS_PARSE_STOC_USE_SRTP = 446;
  SSL_F_TLS_POST_PROCESS_CLIENT_HELLO = 378;
  SSL_F_TLS_POST_PROCESS_CLIENT_KEY_EXCHANGE = 384;
  SSL_F_TLS_PREPARE_CLIENT_CERTIFICATE = 360;
  SSL_F_TLS_PROCESS_AS_HELLO_RETRY_REQUEST = 610;
  SSL_F_TLS_PROCESS_CERTIFICATE_REQUEST = 361;
  SSL_F_TLS_PROCESS_CERT_STATUS = 362;
  SSL_F_TLS_PROCESS_CERT_STATUS_BODY = 495;
  SSL_F_TLS_PROCESS_CERT_VERIFY = 379;
  SSL_F_TLS_PROCESS_CHANGE_CIPHER_SPEC = 363;
  SSL_F_TLS_PROCESS_CKE_DHE = 411;
  SSL_F_TLS_PROCESS_CKE_ECDHE = 412;
  SSL_F_TLS_PROCESS_CKE_GOST = 413;
  SSL_F_TLS_PROCESS_CKE_PSK_PREAMBLE = 414;
  SSL_F_TLS_PROCESS_CKE_RSA = 415;
  SSL_F_TLS_PROCESS_CKE_SRP = 416;
  SSL_F_TLS_PROCESS_CLIENT_CERTIFICATE = 380;
  SSL_F_TLS_PROCESS_CLIENT_HELLO = 381;
  SSL_F_TLS_PROCESS_CLIENT_KEY_EXCHANGE = 382;
  SSL_F_TLS_PROCESS_ENCRYPTED_EXTENSIONS = 444;
  SSL_F_TLS_PROCESS_END_OF_EARLY_DATA = 537;
  SSL_F_TLS_PROCESS_FINISHED = 364;
  SSL_F_TLS_PROCESS_HELLO_REQ = 507;
  SSL_F_TLS_PROCESS_HELLO_RETRY_REQUEST = 511;
  SSL_F_TLS_PROCESS_INITIAL_SERVER_FLIGHT = 442;
  SSL_F_TLS_PROCESS_KEY_EXCHANGE = 365;
  SSL_F_TLS_PROCESS_KEY_UPDATE = 518;
  SSL_F_TLS_PROCESS_NEW_SESSION_TICKET = 366;
  SSL_F_TLS_PROCESS_NEXT_PROTO = 383;
  SSL_F_TLS_PROCESS_SERVER_CERTIFICATE = 367;
  SSL_F_TLS_PROCESS_SERVER_DONE = 368;
  SSL_F_TLS_PROCESS_SERVER_HELLO = 369;
  SSL_F_TLS_PROCESS_SKE_DHE = 419;
  SSL_F_TLS_PROCESS_SKE_ECDHE = 420;
  SSL_F_TLS_PROCESS_SKE_PSK_PREAMBLE = 421;
  SSL_F_TLS_PROCESS_SKE_SRP = 422;
  SSL_F_TLS_PSK_DO_BINDER = 506;
  SSL_F_TLS_SCAN_CLIENTHELLO_TLSEXT = 450;
  SSL_F_TLS_SETUP_HANDSHAKE = 508;
  SSL_F_USE_CERTIFICATE_CHAIN_FILE = 220;
  SSL_F_WPACKET_INTERN_INIT_LEN = 633;
  SSL_F_WPACKET_START_SUB_PACKET_LEN__ = 634;
  SSL_F_WRITE_STATE_MACHINE = 586;
  
  SSL_R_APPLICATION_DATA_AFTER_CLOSE_NOTIFY = 291;
  SSL_R_APP_DATA_IN_HANDSHAKE = 100;
  SSL_R_ATTEMPT_TO_REUSE_SESSION_IN_DIFFERENT_CONTEXT = 272;
  SSL_R_AT_LEAST_TLS_1_0_NEEDED_IN_FIPS_MODE = 143;
  SSL_R_AT_LEAST_TLS_1_2_NEEDED_IN_SUITEB_MODE = 158;
  SSL_R_BAD_CHANGE_CIPHER_SPEC = 103;
  SSL_R_BAD_CIPHER = 186;
  SSL_R_BAD_DATA = 390;
  SSL_R_BAD_DATA_RETURNED_BY_CALLBACK = 106;
  SSL_R_BAD_DECOMPRESSION = 107;
  SSL_R_BAD_DH_VALUE = 102;
  SSL_R_BAD_DIGEST_LENGTH = 111;
  SSL_R_BAD_EARLY_DATA = 233;
  SSL_R_BAD_ECC_CERT = 304;
  SSL_R_BAD_ECPOINT = 306;
  SSL_R_BAD_EXTENSION = 110;
  SSL_R_BAD_HANDSHAKE_LENGTH = 332;
  SSL_R_BAD_HANDSHAKE_STATE = 236;
  SSL_R_BAD_HELLO_REQUEST = 105;
  SSL_R_BAD_HRR_VERSION = 263;
  SSL_R_BAD_KEY_SHARE = 108;
  SSL_R_BAD_KEY_UPDATE = 122;
  SSL_R_BAD_LEGACY_VERSION = 292;
  SSL_R_BAD_LENGTH = 271;
  SSL_R_BAD_PACKET = 240;
  SSL_R_BAD_PACKET_LENGTH = 115;
  SSL_R_BAD_PROTOCOL_VERSION_NUMBER = 116;
  SSL_R_BAD_PSK = 219;
  SSL_R_BAD_PSK_IDENTITY = 114;
  SSL_R_BAD_RECORD_TYPE = 443;
  SSL_R_BAD_RSA_ENCRYPT = 119;
  SSL_R_BAD_SIGNATURE = 123;
  SSL_R_BAD_SRP_A_LENGTH = 347;
  SSL_R_BAD_SRP_PARAMETERS = 371;
  SSL_R_BAD_SRTP_MKI_VALUE = 352;
  SSL_R_BAD_SRTP_PROTECTION_PROFILE_LIST = 353;
  SSL_R_BAD_SSL_FILETYPE = 124;
  SSL_R_BAD_VALUE = 384;
  SSL_R_BAD_WRITE_RETRY = 127;
  SSL_R_BINDER_DOES_NOT_VERIFY = 253;
  SSL_R_BIO_NOT_SET = 128;
  SSL_R_BLOCK_CIPHER_PAD_IS_WRONG = 129;
  SSL_R_BN_LIB = 130;
  SSL_R_CALLBACK_FAILED = 234;
  SSL_R_CANNOT_CHANGE_CIPHER = 109;
  SSL_R_CA_DN_LENGTH_MISMATCH = 131;
  SSL_R_CA_KEY_TOO_SMALL = 397;
  SSL_R_CA_MD_TOO_WEAK = 398;
  SSL_R_CCS_RECEIVED_EARLY = 133;
  SSL_R_CERTIFICATE_VERIFY_FAILED = 134;
  SSL_R_CERT_CB_ERROR = 377;
  SSL_R_CERT_LENGTH_MISMATCH = 135;
  SSL_R_CIPHERSUITE_DIGEST_HAS_CHANGED = 218;
  SSL_R_CIPHER_CODE_WRONG_LENGTH = 137;
  SSL_R_CIPHER_OR_HASH_UNAVAILABLE = 138;
  SSL_R_CLIENTHELLO_TLSEXT = 226;
  SSL_R_COMPRESSED_LENGTH_TOO_LONG = 140;
  SSL_R_COMPRESSION_DISABLED = 343;
  SSL_R_COMPRESSION_FAILURE = 141;
  SSL_R_COMPRESSION_ID_NOT_WITHIN_PRIVATE_RANGE = 307;
  SSL_R_COMPRESSION_LIBRARY_ERROR = 142;
  SSL_R_CONNECTION_TYPE_NOT_SET = 144;
  SSL_R_CONTEXT_NOT_DANE_ENABLED = 167;
  SSL_R_COOKIE_GEN_CALLBACK_FAILURE = 400;
  SSL_R_COOKIE_MISMATCH = 308;
  SSL_R_CUSTOM_EXT_HANDLER_ALREADY_INSTALLED = 206;
  SSL_R_DANE_ALREADY_ENABLED = 172;
  SSL_R_DANE_CANNOT_OVERRIDE_MTYPE_FULL = 173;
  SSL_R_DANE_NOT_ENABLED = 175;
  SSL_R_DANE_TLSA_BAD_CERTIFICATE = 180;
  SSL_R_DANE_TLSA_BAD_CERTIFICATE_USAGE = 184;
  SSL_R_DANE_TLSA_BAD_DATA_LENGTH = 189;
  SSL_R_DANE_TLSA_BAD_DIGEST_LENGTH = 192;
  SSL_R_DANE_TLSA_BAD_MATCHING_TYPE = 200;
  SSL_R_DANE_TLSA_BAD_PUBLIC_KEY = 201;
  SSL_R_DANE_TLSA_BAD_SELECTOR = 202;
  SSL_R_DANE_TLSA_NULL_DATA = 203;
  SSL_R_DATA_BETWEEN_CCS_AND_FINISHED = 145;
  SSL_R_DATA_LENGTH_TOO_LONG = 146;
  SSL_R_DECRYPTION_FAILED = 147;
  SSL_R_DECRYPTION_FAILED_OR_BAD_RECORD_MAC = 281;
  SSL_R_DH_KEY_TOO_SMALL = 394;
  SSL_R_DH_PUBLIC_VALUE_LENGTH_IS_WRONG = 148;
  SSL_R_DIGEST_CHECK_FAILED = 149;
  SSL_R_DTLS_MESSAGE_TOO_BIG = 334;
  SSL_R_DUPLICATE_COMPRESSION_ID = 309;
  SSL_R_ECC_CERT_NOT_FOR_SIGNING = 318;
  SSL_R_ECDH_REQUIRED_FOR_SUITEB_MODE = 374;
  SSL_R_EE_KEY_TOO_SMALL = 399;
  SSL_R_EMPTY_SRTP_PROTECTION_PROFILE_LIST = 354;
  SSL_R_ENCRYPTED_LENGTH_TOO_LONG = 150;
  SSL_R_ERROR_IN_RECEIVED_CIPHER_LIST = 151;
  SSL_R_ERROR_SETTING_TLSA_BASE_DOMAIN = 204;
  SSL_R_EXCEEDS_MAX_FRAGMENT_SIZE = 194;
  SSL_R_EXCESSIVE_MESSAGE_SIZE = 152;
  SSL_R_EXTENSION_NOT_RECEIVED = 279;
  SSL_R_EXTRA_DATA_IN_MESSAGE = 153;
  SSL_R_EXT_LENGTH_MISMATCH = 163;
  SSL_R_FAILED_TO_INIT_ASYNC = 405;
  SSL_R_FRAGMENTED_CLIENT_HELLO = 401;
  SSL_R_GOT_A_FIN_BEFORE_A_CCS = 154;
  SSL_R_HTTPS_PROXY_REQUEST = 155;
  SSL_R_HTTP_REQUEST = 156;
  SSL_R_ILLEGAL_POINT_COMPRESSION = 162;
  SSL_R_ILLEGAL_SUITEB_DIGEST = 380;
  SSL_R_INAPPROPRIATE_FALLBACK = 373;
  SSL_R_INCONSISTENT_COMPRESSION = 340;
  SSL_R_INCONSISTENT_EARLY_DATA_ALPN = 222;
  SSL_R_INCONSISTENT_EARLY_DATA_SNI = 231;
  SSL_R_INCONSISTENT_EXTMS = 104;
  SSL_R_INSUFFICIENT_SECURITY = 241;
  SSL_R_INVALID_ALERT = 205;
  SSL_R_INVALID_CCS_MESSAGE = 260;
  SSL_R_INVALID_CERTIFICATE_OR_ALG = 238;
  SSL_R_INVALID_COMMAND = 280;
  SSL_R_INVALID_COMPRESSION_ALGORITHM = 341;
  SSL_R_INVALID_CONFIG = 283;
  SSL_R_INVALID_CONFIGURATION_NAME = 113;
  SSL_R_INVALID_CONTEXT = 282;
  SSL_R_INVALID_CT_VALIDATION_TYPE = 212;
  SSL_R_INVALID_KEY_UPDATE_TYPE = 120;
  SSL_R_INVALID_MAX_EARLY_DATA = 174;
  SSL_R_INVALID_NULL_CMD_NAME = 385;
  SSL_R_INVALID_SEQUENCE_NUMBER = 402;
  SSL_R_INVALID_SERVERINFO_DATA = 388;
  SSL_R_INVALID_SESSION_ID = 999;
  SSL_R_INVALID_SRP_USERNAME = 357;
  SSL_R_INVALID_STATUS_RESPONSE = 328;
  SSL_R_INVALID_TICKET_KEYS_LENGTH = 325;
  SSL_R_LENGTH_MISMATCH = 159;
  SSL_R_LENGTH_TOO_LONG = 404;
  SSL_R_LENGTH_TOO_SHORT = 160;
  SSL_R_LIBRARY_BUG = 274;
  SSL_R_LIBRARY_HAS_NO_CIPHERS = 161;
  SSL_R_MISSING_DSA_SIGNING_CERT = 165;
  SSL_R_MISSING_ECDSA_SIGNING_CERT = 381;
  SSL_R_MISSING_FATAL = 256;
  SSL_R_MISSING_PARAMETERS = 290;
  SSL_R_MISSING_RSA_CERTIFICATE = 168;
  SSL_R_MISSING_RSA_ENCRYPTING_CERT = 169;
  SSL_R_MISSING_RSA_SIGNING_CERT = 170;
  SSL_R_MISSING_SIGALGS_EXTENSION = 112;
  SSL_R_MISSING_SIGNING_CERT = 221;
  SSL_R_MISSING_SRP_PARAM = 358;
  SSL_R_MISSING_SUPPORTED_GROUPS_EXTENSION = 209;
  SSL_R_MISSING_TMP_DH_KEY = 171;
  SSL_R_MISSING_TMP_ECDH_KEY = 311;
  SSL_R_MIXED_HANDSHAKE_AND_NON_HANDSHAKE_DATA = 293;
  SSL_R_NOT_ON_RECORD_BOUNDARY = 182;
  SSL_R_NOT_REPLACING_CERTIFICATE = 289;
  SSL_R_NOT_SERVER = 284;
  SSL_R_NO_APPLICATION_PROTOCOL = 235;
  SSL_R_NO_CERTIFICATES_RETURNED = 176;
  SSL_R_NO_CERTIFICATE_ASSIGNED = 177;
  SSL_R_NO_CERTIFICATE_SET = 179;
  SSL_R_NO_CHANGE_FOLLOWING_HRR = 214;
  SSL_R_NO_CIPHERS_AVAILABLE = 181;
  SSL_R_NO_CIPHERS_SPECIFIED = 183;
  SSL_R_NO_CIPHER_MATCH = 185;
  SSL_R_NO_CLIENT_CERT_METHOD = 331;
  SSL_R_NO_COMPRESSION_SPECIFIED = 187;
  SSL_R_NO_COOKIE_CALLBACK_SET = 287;
  SSL_R_NO_GOST_CERTIFICATE_SENT_BY_PEER = 330;
  SSL_R_NO_METHOD_SPECIFIED = 188;
  SSL_R_NO_PEM_EXTENSIONS = 389;
  SSL_R_NO_PRIVATE_KEY_ASSIGNED = 190;
  SSL_R_NO_PROTOCOLS_AVAILABLE = 191;
  SSL_R_NO_RENEGOTIATION = 339;
  SSL_R_NO_REQUIRED_DIGEST = 324;
  SSL_R_NO_SHARED_CIPHER = 193;
  SSL_R_NO_SHARED_GROUPS = 410;
  SSL_R_NO_SHARED_SIGNATURE_ALGORITHMS = 376;
  SSL_R_NO_SRTP_PROFILES = 359;
  SSL_R_NO_SUITABLE_KEY_SHARE = 101;
  SSL_R_NO_SUITABLE_SIGNATURE_ALGORITHM = 118;
  SSL_R_NO_VALID_SCTS = 216;
  SSL_R_NO_VERIFY_COOKIE_CALLBACK = 403;
  SSL_R_NULL_SSL_CTX = 195;
  SSL_R_NULL_SSL_METHOD_PASSED = 196;
  SSL_R_OLD_SESSION_CIPHER_NOT_RETURNED = 197;
  SSL_R_OLD_SESSION_COMPRESSION_ALGORITHM_NOT_RETURNED = 344;
  SSL_R_OVERFLOW_ERROR = 237;
  SSL_R_PACKET_LENGTH_TOO_LONG = 198;
  SSL_R_PARSE_TLSEXT = 227;
  SSL_R_PATH_TOO_LONG = 270;
  SSL_R_PEER_DID_NOT_RETURN_A_CERTIFICATE = 199;
  SSL_R_PEM_NAME_BAD_PREFIX = 391;
  SSL_R_PEM_NAME_TOO_SHORT = 392;
  SSL_R_PIPELINE_FAILURE = 406;
  SSL_R_POST_HANDSHAKE_AUTH_ENCODING_ERR = 278;
  SSL_R_PRIVATE_KEY_MISMATCH = 288;
  SSL_R_PROTOCOL_IS_SHUTDOWN = 207;
  SSL_R_PSK_IDENTITY_NOT_FOUND = 223;
  SSL_R_PSK_NO_CLIENT_CB = 224;
  SSL_R_PSK_NO_SERVER_CB = 225;
  SSL_R_READ_BIO_NOT_SET = 211;
  SSL_R_READ_TIMEOUT_EXPIRED = 312;
  SSL_R_RECORD_LENGTH_MISMATCH = 213;
  SSL_R_RECORD_TOO_SMALL = 298;
  SSL_R_RENEGOTIATE_EXT_TOO_LONG = 335;
  SSL_R_RENEGOTIATION_ENCODING_ERR = 336;
  SSL_R_RENEGOTIATION_MISMATCH = 337;
  SSL_R_REQUEST_PENDING = 285;
  SSL_R_REQUEST_SENT = 286;
  SSL_R_REQUIRED_CIPHER_MISSING = 215;
  SSL_R_REQUIRED_COMPRESSION_ALGORITHM_MISSING = 342;
  SSL_R_SCSV_RECEIVED_WHEN_RENEGOTIATING = 345;
  SSL_R_SCT_VERIFICATION_FAILED = 208;
  SSL_R_SERVERHELLO_TLSEXT = 275;
  SSL_R_SESSION_ID_CONTEXT_UNINITIALIZED = 277;
  SSL_R_SHUTDOWN_WHILE_IN_INIT = 407;
  SSL_R_SIGNATURE_ALGORITHMS_ERROR = 360;
  SSL_R_SIGNATURE_FOR_NON_SIGNING_CERTIFICATE = 220;
  SSL_R_SRP_A_CALC = 361;
  SSL_R_SRTP_COULD_NOT_ALLOCATE_PROFILES = 362;
  SSL_R_SRTP_PROTECTION_PROFILE_LIST_TOO_LONG = 363;
  SSL_R_SRTP_UNKNOWN_PROTECTION_PROFILE = 364;
  SSL_R_SSL3_EXT_INVALID_MAX_FRAGMENT_LENGTH = 232;
  SSL_R_SSL3_EXT_INVALID_SERVERNAME = 319;
  SSL_R_SSL3_EXT_INVALID_SERVERNAME_TYPE = 320;
  SSL_R_SSL3_SESSION_ID_TOO_LONG = 300;
  SSL_R_SSLV3_ALERT_BAD_CERTIFICATE = 1042;
  SSL_R_SSLV3_ALERT_BAD_RECORD_MAC = 1020;
  SSL_R_SSLV3_ALERT_CERTIFICATE_EXPIRED = 1045;
  SSL_R_SSLV3_ALERT_CERTIFICATE_REVOKED = 1044;
  SSL_R_SSLV3_ALERT_CERTIFICATE_UNKNOWN = 1046;
  SSL_R_SSLV3_ALERT_DECOMPRESSION_FAILURE = 1030;
  SSL_R_SSLV3_ALERT_HANDSHAKE_FAILURE = 1040;
  SSL_R_SSLV3_ALERT_ILLEGAL_PARAMETER = 1047;
  SSL_R_SSLV3_ALERT_NO_CERTIFICATE = 1041;
  SSL_R_SSLV3_ALERT_UNEXPECTED_MESSAGE = 1010;
  SSL_R_SSLV3_ALERT_UNSUPPORTED_CERTIFICATE = 1043;
  SSL_R_SSL_COMMAND_SECTION_EMPTY = 117;
  SSL_R_SSL_COMMAND_SECTION_NOT_FOUND = 125;
  SSL_R_SSL_CTX_HAS_NO_DEFAULT_SSL_VERSION = 228;
  SSL_R_SSL_HANDSHAKE_FAILURE = 229;
  SSL_R_SSL_LIBRARY_HAS_NO_CIPHERS = 230;
  SSL_R_SSL_NEGATIVE_LENGTH = 372;
  SSL_R_SSL_SECTION_EMPTY = 126;
  SSL_R_SSL_SECTION_NOT_FOUND = 136;
  SSL_R_SSL_SESSION_ID_CALLBACK_FAILED = 301;
  SSL_R_SSL_SESSION_ID_CONFLICT = 302;
  SSL_R_SSL_SESSION_ID_CONTEXT_TOO_LONG = 273;
  SSL_R_SSL_SESSION_ID_HAS_BAD_LENGTH = 303;
  SSL_R_SSL_SESSION_ID_TOO_LONG = 408;
  SSL_R_SSL_SESSION_VERSION_MISMATCH = 210;
  SSL_R_STILL_IN_INIT = 121;
  SSL_R_TLSV13_ALERT_CERTIFICATE_REQUIRED = 1116;
  SSL_R_TLSV13_ALERT_MISSING_EXTENSION = 1109;
  SSL_R_TLSV1_ALERT_ACCESS_DENIED = 1049;
  SSL_R_TLSV1_ALERT_DECODE_ERROR = 1050;
  SSL_R_TLSV1_ALERT_DECRYPTION_FAILED = 1021;
  SSL_R_TLSV1_ALERT_DECRYPT_ERROR = 1051;
  SSL_R_TLSV1_ALERT_EXPORT_RESTRICTION = 1060;
  SSL_R_TLSV1_ALERT_INAPPROPRIATE_FALLBACK = 1086;
  SSL_R_TLSV1_ALERT_INSUFFICIENT_SECURITY = 1071;
  SSL_R_TLSV1_ALERT_INTERNAL_ERROR = 1080;
  SSL_R_TLSV1_ALERT_NO_RENEGOTIATION = 1100;
  SSL_R_TLSV1_ALERT_PROTOCOL_VERSION = 1070;
  SSL_R_TLSV1_ALERT_RECORD_OVERFLOW = 1022;
  SSL_R_TLSV1_ALERT_UNKNOWN_CA = 1048;
  SSL_R_TLSV1_ALERT_USER_CANCELLED = 1090;
  SSL_R_TLSV1_BAD_CERTIFICATE_HASH_VALUE = 1114;
  SSL_R_TLSV1_BAD_CERTIFICATE_STATUS_RESPONSE = 1113;
  SSL_R_TLSV1_CERTIFICATE_UNOBTAINABLE = 1111;
  SSL_R_TLSV1_UNRECOGNIZED_NAME = 1112;
  SSL_R_TLSV1_UNSUPPORTED_EXTENSION = 1110;
  SSL_R_TLS_HEARTBEAT_PEER_DOESNT_ACCEPT = 365;
  SSL_R_TLS_HEARTBEAT_PENDING = 366;
  SSL_R_TLS_ILLEGAL_EXPORTER_LABEL = 367;
  SSL_R_TLS_INVALID_ECPOINTFORMAT_LIST = 157;
  SSL_R_TOO_MANY_KEY_UPDATES = 132;
  SSL_R_TOO_MANY_WARN_ALERTS = 409;
  SSL_R_TOO_MUCH_EARLY_DATA = 164;
  SSL_R_UNABLE_TO_FIND_ECDH_PARAMETERS = 314;
  SSL_R_UNABLE_TO_FIND_PUBLIC_KEY_PARAMETERS = 239;
  SSL_R_UNABLE_TO_LOAD_SSL3_MD5_ROUTINES = 242;
  SSL_R_UNABLE_TO_LOAD_SSL3_SHA1_ROUTINES = 243;
  SSL_R_UNEXPECTED_CCS_MESSAGE = 262;
  SSL_R_UNEXPECTED_END_OF_EARLY_DATA = 178;
  SSL_R_UNEXPECTED_MESSAGE = 244;
  SSL_R_UNEXPECTED_RECORD = 245;
  SSL_R_UNINITIALIZED = 276;
  SSL_R_UNKNOWN_ALERT_TYPE = 246;
  SSL_R_UNKNOWN_CERTIFICATE_TYPE = 247;
  SSL_R_UNKNOWN_CIPHER_RETURNED = 248;
  SSL_R_UNKNOWN_CIPHER_TYPE = 249;
  SSL_R_UNKNOWN_CMD_NAME = 386;
  SSL_R_UNKNOWN_COMMAND = 139;
  SSL_R_UNKNOWN_DIGEST = 368;
  SSL_R_UNKNOWN_KEY_EXCHANGE_TYPE = 250;
  SSL_R_UNKNOWN_PKEY_TYPE = 251;
  SSL_R_UNKNOWN_PROTOCOL = 252;
  SSL_R_UNKNOWN_SSL_VERSION = 254;
  SSL_R_UNKNOWN_STATE = 255;
  SSL_R_UNSAFE_LEGACY_RENEGOTIATION_DISABLED = 338;
  SSL_R_UNSOLICITED_EXTENSION = 217;
  SSL_R_UNSUPPORTED_COMPRESSION_ALGORITHM = 257;
  SSL_R_UNSUPPORTED_ELLIPTIC_CURVE = 315;
  SSL_R_UNSUPPORTED_PROTOCOL = 258;
  SSL_R_UNSUPPORTED_SSL_VERSION = 259;
  SSL_R_UNSUPPORTED_STATUS_TYPE = 329;
  SSL_R_USE_SRTP_NOT_NEGOTIATED = 369;
  SSL_R_VERSION_TOO_HIGH = 166;
  SSL_R_VERSION_TOO_LOW = 396;
  SSL_R_WRONG_CERTIFICATE_TYPE = 383;
  SSL_R_WRONG_CIPHER_RETURNED = 261;
  SSL_R_WRONG_CURVE = 378;
  SSL_R_WRONG_SIGNATURE_LENGTH = 264;
  SSL_R_WRONG_SIGNATURE_SIZE = 265;
  SSL_R_WRONG_SIGNATURE_TYPE = 370;
  SSL_R_WRONG_SSL_VERSION = 266;
  SSL_R_WRONG_VERSION_NUMBER = 267;
  SSL_R_X509_LIB = 268;
  SSL_R_X509_VERIFICATION_SETUP_PROBLEMS = 269;
  
  SSL_SESSION_ASN1_VERSION = $0001;
  SSL_MAX_SSL_SESSION_ID_LENGTH = 32;
  SSL_MAX_SID_CTX_LENGTH = 32;
  SSL_MIN_RSA_MODULUS_LENGTH_IN_BYTES = 512 div 8;
  SSL_MAX_KEY_ARG_LENGTH = 8;
  SSL_MAX_MASTER_KEY_LENGTH = 48;
  SSL_MAX_PIPELINES = 32;
  
  SSL_TXT_LOW = 'LOW';
  SSL_TXT_MEDIUM = 'MEDIUM';
  SSL_TXT_HIGH = 'HIGH';
  SSL_TXT_FIPS = 'FIPS';
  SSL_TXT_aNULL = 'aNULL';
  SSL_TXT_eNULL = 'eNULL';
  SSL_TXT_NULL = 'NULL';
  SSL_TXT_kRSA = 'kRSA';
  SSL_TXT_kDHr = 'kDHr';
  SSL_TXT_kDHd = 'kDHd';
  SSL_TXT_kDH = 'kDH';
  SSL_TXT_kEDH = 'kEDH';
  SSL_TXT_kDHE = 'kDHE';
  SSL_TXT_kECDHr = 'kECDHr';
  SSL_TXT_kECDHe = 'kECDHe';
  SSL_TXT_kECDH = 'kECDH';
  SSL_TXT_kEECDH = 'kEECDH';
  SSL_TXT_kPSK = 'kPSK';
  SSL_TXT_kRSAPSK = 'kRSAPSK';
  SSL_TXT_kECDHEPSK = 'kECDHEPSK';
  SSL_TXT_kDHEPSK = 'kDHEPSK';
  SSL_TXT_kGOST = 'kGOST';
  SSL_TXT_kSRP = 'kSRP';
  SSL_TXT_aRSA = 'aRSA';
  SSL_TXT_aDSS = 'aDSS';
  SSL_TXT_aDH = 'aDH';
  SSL_TXT_aECDH = 'aECDH';
  SSL_TXT_aECDSA = 'aECDSA';
  SSL_TXT_aPSK = 'aPSK';
  SSL_TXT_aGOST94 = 'aGOST94';
  SSL_TXT_aGOST01 = 'aGOST01';
  SSL_TXT_aGOST12 = 'aGOST12';
  SSL_TXT_aGOST = 'aGOST';
  SSL_TXT_aSRP = 'aSRP';
  SSL_TXT_DSS = 'DSS';
  SSL_TXT_DH = 'DH';
  SSL_TXT_DHE = 'DHE';
  SSL_TXT_EDH = 'EDH';
  SSL_TXT_RSA = 'RSA';
  SSL_TXT_ECDH = 'ECDH';
  SSL_TXT_EECDH = 'EECDH';
  SSL_TXT_ECDHE = 'ECDHE';
  SSL_TXT_ECDSA = 'ECDSA';
  SSL_TXT_PSK = 'PSK';
  SSL_TXT_SRP = 'SRP';
  SSL_TXT_DES = 'DES';
  SSL_TXT_3DES = '3DES';
  SSL_TXT_RC4 = 'RC4';
  SSL_TXT_RC2 = 'RC2';
  SSL_TXT_IDEA = 'IDEA';
  SSL_TXT_SEED = 'SEED';
  SSL_TXT_AES128 = 'AES128';
  SSL_TXT_AES256 = 'AES256';
  SSL_TXT_AES = 'AES';
  SSL_TXT_AES_GCM = 'AESGCM';
  SSL_TXT_AES_CCM = 'AESCCM';
  SSL_TXT_AES_CCM_8 = 'AESCCM8';
  SSL_TXT_CAMELLIA128 = 'CAMELLIA128';
  SSL_TXT_CAMELLIA256 = 'CAMELLIA256';
  SSL_TXT_CAMELLIA = 'CAMELLIA';
  SSL_TXT_CHACHA20 = 'CHACHA20';
  SSL_TXT_GOST = 'GOST89';
  SSL_TXT_ARIA = 'ARIA';
  SSL_TXT_ARIA_GCM = 'ARIAGCM';
  SSL_TXT_ARIA128 = 'ARIA128';
  SSL_TXT_ARIA256 = 'ARIA256';
  SSL_TXT_MD5 = 'MD5';
  SSL_TXT_SHA1 = 'SHA1';
  SSL_TXT_SHA = 'SHA';
  SSL_TXT_GOST94 = 'GOST94';
  SSL_TXT_GOST89MAC = 'GOST89MAC';
  SSL_TXT_GOST12 = 'GOST12';
  SSL_TXT_GOST89MAC12 = 'GOST89MAC12';
  SSL_TXT_SHA256 = 'SHA256';
  SSL_TXT_SHA384 = 'SHA384';
  SSL_TXT_SSLV3 = 'SSLv3';
  SSL_TXT_TLSV1 = 'TLSv1';
  SSL_TXT_TLSV1_1 = 'TLSv1.1';
  SSL_TXT_TLSV1_2 = 'TLSv1.2';
  SSL_TXT_ALL = 'ALL';
  SSL_TXT_CMPALL = 'COMPLEMENTOFALL';
  SSL_TXT_CMPDEF = 'COMPLEMENTOFDEFAULT';
  
  SSL_DEFAULT_CIPHER_LIST = 'ALL:!COMPLEMENTOFDEFAULT:!eNULL';
  
  TLS_DEFAULT_CIPHERSUITES = 'TLS_AES_256_GCM_SHA384:' +
                             'TLS_CHACHA20_POLY1305_SHA256:' +
                             'TLS_AES_128_GCM_SHA256';
  
  SSL_SENT_SHUTDOWN = 1;
  SSL_RECEIVED_SHUTDOWN = 2;
  
  SSL_EXT_TLS_ONLY = $0001;
  SSL_EXT_DTLS_ONLY = $0002;
  SSL_EXT_TLS_IMPLEMENTATION_ONLY = $0004;
  SSL_EXT_SSL3_ALLOWED = $0008;
  SSL_EXT_TLS1_2_AND_BELOW_ONLY = $0010;
  SSL_EXT_TLS1_3_ONLY = $0020;
  SSL_EXT_IGNORE_ON_RESUMPTION = $0040;
  SSL_EXT_CLIENT_HELLO = $0080;
  SSL_EXT_TLS1_2_SERVER_HELLO = $0100;
  SSL_EXT_TLS1_3_SERVER_HELLO = $0200;
  SSL_EXT_TLS1_3_ENCRYPTED_EXTENSIONS = $0400;
  SSL_EXT_TLS1_3_HELLO_RETRY_REQUEST = $0800;
  SSL_EXT_TLS1_3_CERTIFICATE = $1000;
  SSL_EXT_TLS1_3_NEW_SESSION_TICKET = $2000;
  SSL_EXT_TLS1_3_CERTIFICATE_REQUEST = $4000;
  
  SSL_OP_MICROSOFT_SESS_ID_BUG = $0;
  SSL_OP_NETSCAPE_CHALLENGE_BUG = $0;
  SSL_OP_NETSCAPE_REUSE_CIPHER_CHANGE_BUG = $0;
  SSL_OP_SSLREF2_REUSE_CERT_TYPE_BUG = $0;
  SSL_OP_MICROSOFT_BIG_SSLV3_BUFFER = $0;
  SSL_OP_MSIE_SSLV2_RSA_PADDING = $0;
  SSL_OP_SSLEAY_080_CLIENT_DH_BUG = $0;
  SSL_OP_TLS_D5_BUG = $0;
  SSL_OP_TLS_BLOCK_PADDING_BUG = $0;
  SSL_OP_SINGLE_ECDH_USE = $0;
  SSL_OP_SINGLE_DH_USE = $0;
  SSL_OP_EPHEMERAL_RSA = $0;
  SSL_OP_NO_SSLv2 = $0;
  SSL_OP_PKCS1_CHECK_1 = $0;
  SSL_OP_PKCS1_CHECK_2 = $0;
  SSL_OP_NETSCAPE_CA_DN_BUG = $0;
  SSL_OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG = $0;
  
  SSL_MODE_ENABLE_PARTIAL_WRITE = $00000001;
  SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER = $00000002;
  SSL_MODE_AUTO_RETRY = $00000004;
  SSL_MODE_NO_AUTO_CHAIN = $00000008;
  SSL_MODE_RELEASE_BUFFERS = $00000010;
  SSL_MODE_SEND_CLIENTHELLO_TIME = $00000020;
  SSL_MODE_SEND_SERVERHELLO_TIME = $00000040;
  SSL_MODE_SEND_FALLBACK_SCSV = $00000080;
  SSL_MODE_ASYNC = $00000100;
  SSL_MODE_DTLS_SCTP_LABEL_LENGTH_BUG = $00000400;
  
  SSL_CERT_FLAG_TLS_STRICT = $00000001;
  SSL_CERT_FLAG_SUITEB_128_LOS_ONLY = $10000;
  SSL_CERT_FLAG_SUITEB_192_LOS = $20000;
  SSL_CERT_FLAG_SUITEB_128_LOS = $30000;
  SSL_CERT_FLAG_BROKEN_PROTOCOL = $10000000;
  
  SSL_BUILD_CHAIN_FLAG_UNTRUSTED = $1;
  SSL_BUILD_CHAIN_FLAG_NO_ROOT = $2;
  SSL_BUILD_CHAIN_FLAG_CHECK = $4;
  SSL_BUILD_CHAIN_FLAG_IGNORE_ERROR = $8;
  SSL_BUILD_CHAIN_FLAG_CLEAR_ERROR = $10;
  
  CERT_PKEY_VALID = $1;
  CERT_PKEY_SIGN = $2;
  CERT_PKEY_EE_SIGNATURE = $10;
  CERT_PKEY_CA_SIGNATURE = $20;
  CERT_PKEY_EE_PARAM = $40;
  CERT_PKEY_CA_PARAM = $80;
  CERT_PKEY_EXPLICIT_SIGN = $100;
  CERT_PKEY_ISSUER_NAME = $200;
  CERT_PKEY_CERT_TYPE = $400;
  CERT_PKEY_SUITEB = $800;
  
  SSL_CONF_FLAG_CMDLINE = $1;
  SSL_CONF_FLAG_FILE = $2;
  SSL_CONF_FLAG_CLIENT = $4;
  SSL_CONF_FLAG_SERVER = $8;
  SSL_CONF_FLAG_SHOW_ERRORS = $10;
  SSL_CONF_FLAG_CERTIFICATE = $20;
  SSL_CONF_FLAG_REQUIRE_PRIVATE = $40;
  SSL_CONF_TYPE_UNKNOWN = $0;
  SSL_CONF_TYPE_STRING = $1;
  SSL_CONF_TYPE_FILE = $2;
  SSL_CONF_TYPE_DIR = $3;
  SSL_CONF_TYPE_NONE = $4;
  
  SSL_COOKIE_LENGTH = 4096;
  SSL_MAX_CERT_LIST_DEFAULT = 1024*100;
  
  SSL_SESSION_CACHE_MAX_SIZE_DEFAULT = 1024*20;
  SSL_SESS_CACHE_OFF = $0000;
  SSL_SESS_CACHE_CLIENT = $0001;
  SSL_SESS_CACHE_SERVER = $0002;
  SSL_SESS_CACHE_BOTH = SSL_SESS_CACHE_CLIENT or SSL_SESS_CACHE_SERVER;
  SSL_SESS_CACHE_NO_AUTO_CLEAR = $0080;
  SSL_SESS_CACHE_NO_INTERNAL_LOOKUP = $0100;
  SSL_SESS_CACHE_NO_INTERNAL_STORE = $0200;
  SSL_SESS_CACHE_NO_INTERNAL = SSL_SESS_CACHE_NO_INTERNAL_LOOKUP or SSL_SESS_CACHE_NO_INTERNAL_STORE;
  
  OPENSSL_NPN_UNSUPPORTED = 0;
  OPENSSL_NPN_NEGOTIATED = 1;
  OPENSSL_NPN_NO_OVERLAP = 2;
  
  PSK_MAX_IDENTITY_LEN = 128;
  PSK_MAX_PSK_LEN = 256;
  
  SSL_NOTHING = 1;
  SSL_WRITING = 2;
  SSL_READING = 3;
  SSL_X509_LOOKUP = 4;
  SSL_ASYNC_PAUSED = 5;
  SSL_ASYNC_NO_JOBS = 6;
  SSL_CLIENT_HELLO_CB = 7;
  
  SSL_MAC_FLAG_READ_MAC_STREAM = 1;
  SSL_MAC_FLAG_WRITE_MAC_STREAM = 2;
  
  SSL2_VERSION = $0002;
  SSL2_MT_CLIENT_HELLO = 1;
  
  SSL3_CK_SCSV = $030000FF;
  SSL3_CK_FALLBACK_SCSV = $03005600;
  SSL3_CK_RSA_NULL_MD5 = $03000001;
  SSL3_CK_RSA_NULL_SHA = $03000002;
  SSL3_CK_RSA_RC4_40_MD5 = $03000003;
  SSL3_CK_RSA_RC4_128_MD5 = $03000004;
  SSL3_CK_RSA_RC4_128_SHA = $03000005;
  SSL3_CK_RSA_RC2_40_MD5 = $03000006;
  SSL3_CK_RSA_IDEA_128_SHA = $03000007;
  SSL3_CK_RSA_DES_40_CBC_SHA = $03000008;
  SSL3_CK_RSA_DES_64_CBC_SHA = $03000009;
  SSL3_CK_RSA_DES_192_CBC3_SHA = $0300000A;
  SSL3_CK_DH_DSS_DES_40_CBC_SHA = $0300000B;
  SSL3_CK_DH_DSS_DES_64_CBC_SHA = $0300000C;
  SSL3_CK_DH_DSS_DES_192_CBC3_SHA = $0300000D;
  SSL3_CK_DH_RSA_DES_40_CBC_SHA = $0300000E;
  SSL3_CK_DH_RSA_DES_64_CBC_SHA = $0300000F;
  SSL3_CK_DH_RSA_DES_192_CBC3_SHA = $03000010;
  SSL3_CK_DHE_DSS_DES_40_CBC_SHA = $03000011;
  SSL3_CK_EDH_DSS_DES_40_CBC_SHA = SSL3_CK_DHE_DSS_DES_40_CBC_SHA;
  SSL3_CK_DHE_DSS_DES_64_CBC_SHA = $03000012;
  SSL3_CK_EDH_DSS_DES_64_CBC_SHA = SSL3_CK_DHE_DSS_DES_64_CBC_SHA;
  SSL3_CK_DHE_DSS_DES_192_CBC3_SHA = $03000013;
  SSL3_CK_EDH_DSS_DES_192_CBC3_SHA = SSL3_CK_DHE_DSS_DES_192_CBC3_SHA;
  SSL3_CK_DHE_RSA_DES_40_CBC_SHA = $03000014;
  SSL3_CK_EDH_RSA_DES_40_CBC_SHA = SSL3_CK_DHE_RSA_DES_40_CBC_SHA;
  SSL3_CK_DHE_RSA_DES_64_CBC_SHA = $03000015;
  SSL3_CK_EDH_RSA_DES_64_CBC_SHA = SSL3_CK_DHE_RSA_DES_64_CBC_SHA;
  SSL3_CK_DHE_RSA_DES_192_CBC3_SHA = $03000016;
  SSL3_CK_EDH_RSA_DES_192_CBC3_SHA = SSL3_CK_DHE_RSA_DES_192_CBC3_SHA;
  SSL3_CK_ADH_RC4_40_MD5 = $03000017;
  SSL3_CK_ADH_RC4_128_MD5 = $03000018;
  SSL3_CK_ADH_DES_40_CBC_SHA = $03000019;
  SSL3_CK_ADH_DES_64_CBC_SHA = $0300001A;
  SSL3_CK_ADH_DES_192_CBC_SHA = $0300001B;
  
  SSL3_RFC_RSA_NULL_MD5 = 'TLS_RSA_WITH_NULL_MD5';
  SSL3_RFC_RSA_NULL_SHA = 'TLS_RSA_WITH_NULL_SHA';
  SSL3_RFC_RSA_DES_192_CBC3_SHA = 'TLS_RSA_WITH_3DES_EDE_CBC_SHA';
  SSL3_RFC_DHE_DSS_DES_192_CBC3_SHA = 'TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA';
  SSL3_RFC_DHE_RSA_DES_192_CBC3_SHA = 'TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA';
  SSL3_RFC_ADH_DES_192_CBC_SHA = 'TLS_DH_anon_WITH_3DES_EDE_CBC_SHA';
  SSL3_RFC_RSA_IDEA_128_SHA = 'TLS_RSA_WITH_IDEA_CBC_SHA';
  SSL3_RFC_RSA_RC4_128_MD5 = 'TLS_RSA_WITH_RC4_128_MD5';
  SSL3_RFC_RSA_RC4_128_SHA = 'TLS_RSA_WITH_RC4_128_SHA';
  SSL3_RFC_ADH_RC4_128_MD5 = 'TLS_DH_anon_WITH_RC4_128_MD5';
  
  SSL3_TXT_RSA_NULL_MD5 = 'NULL-MD5';
  SSL3_TXT_RSA_NULL_SHA = 'NULL-SHA';
  SSL3_TXT_RSA_RC4_40_MD5 = 'EXP-RC4-MD5';
  SSL3_TXT_RSA_RC4_128_MD5 = 'RC4-MD5';
  SSL3_TXT_RSA_RC4_128_SHA = 'RC4-SHA';
  SSL3_TXT_RSA_RC2_40_MD5 = 'EXP-RC2-CBC-MD5';
  SSL3_TXT_RSA_IDEA_128_SHA = 'IDEA-CBC-SHA';
  SSL3_TXT_RSA_DES_40_CBC_SHA = 'EXP-DES-CBC-SHA';
  SSL3_TXT_RSA_DES_64_CBC_SHA = 'DES-CBC-SHA';
  SSL3_TXT_RSA_DES_192_CBC3_SHA = 'DES-CBC3-SHA';
  SSL3_TXT_DH_DSS_DES_40_CBC_SHA = 'EXP-DH-DSS-DES-CBC-SHA';
  SSL3_TXT_DH_DSS_DES_64_CBC_SHA = 'DH-DSS-DES-CBC-SHA';
  SSL3_TXT_DH_DSS_DES_192_CBC3_SHA = 'DH-DSS-DES-CBC3-SHA';
  SSL3_TXT_DH_RSA_DES_40_CBC_SHA = 'EXP-DH-RSA-DES-CBC-SHA';
  SSL3_TXT_DH_RSA_DES_64_CBC_SHA = 'DH-RSA-DES-CBC-SHA';
  SSL3_TXT_DH_RSA_DES_192_CBC3_SHA = 'DH-RSA-DES-CBC3-SHA';
  SSL3_TXT_DHE_DSS_DES_40_CBC_SHA = 'EXP-DHE-DSS-DES-CBC-SHA';
  SSL3_TXT_DHE_DSS_DES_64_CBC_SHA = 'DHE-DSS-DES-CBC-SHA';
  SSL3_TXT_DHE_DSS_DES_192_CBC3_SHA = 'DHE-DSS-DES-CBC3-SHA';
  SSL3_TXT_DHE_RSA_DES_40_CBC_SHA = 'EXP-DHE-RSA-DES-CBC-SHA';
  SSL3_TXT_DHE_RSA_DES_64_CBC_SHA = 'DHE-RSA-DES-CBC-SHA';
  SSL3_TXT_DHE_RSA_DES_192_CBC3_SHA = 'DHE-RSA-DES-CBC3-SHA';
  SSL3_TXT_EDH_DSS_DES_40_CBC_SHA = 'EXP-EDH-DSS-DES-CBC-SHA';
  SSL3_TXT_EDH_DSS_DES_64_CBC_SHA = 'EDH-DSS-DES-CBC-SHA';
  SSL3_TXT_EDH_DSS_DES_192_CBC3_SHA = 'EDH-DSS-DES-CBC3-SHA';
  SSL3_TXT_EDH_RSA_DES_40_CBC_SHA = 'EXP-EDH-RSA-DES-CBC-SHA';
  SSL3_TXT_EDH_RSA_DES_64_CBC_SHA = 'EDH-RSA-DES-CBC-SHA';
  SSL3_TXT_EDH_RSA_DES_192_CBC3_SHA = 'EDH-RSA-DES-CBC3-SHA';
  SSL3_TXT_ADH_RC4_40_MD5 = 'EXP-ADH-RC4-MD5';
  SSL3_TXT_ADH_RC4_128_MD5 = 'ADH-RC4-MD5';
  SSL3_TXT_ADH_DES_40_CBC_SHA = 'EXP-ADH-DES-CBC-SHA';
  SSL3_TXT_ADH_DES_64_CBC_SHA = 'ADH-DES-CBC-SHA';
  SSL3_TXT_ADH_DES_192_CBC_SHA = 'ADH-DES-CBC3-SHA';
  
  SSL3_SSL_SESSION_ID_LENGTH = 32;
  SSL3_MAX_SSL_SESSION_ID_LENGTH = 32;
  SSL3_MASTER_SECRET_SIZE = 48;
  SSL3_RANDOM_SIZE = 32;
  SSL3_SESSION_ID_SIZE = 32;
  SSL3_RT_HEADER_LENGTH = 5;
  SSL3_HM_HEADER_LENGTH = 4;
  SSL3_ALIGN_PAYLOAD = 8;
  
  SSL3_RT_MAX_MD_SIZE = 64;
  SSL_RT_MAX_CIPHER_BLOCK_SIZE = 16;
  SSL3_RT_MAX_EXTRA = 16384;
  SSL3_RT_MAX_PLAIN_LENGTH = 16384;
  SSL3_RT_MAX_COMPRESSED_OVERHEAD = 1024;
  SSL3_RT_MAX_ENCRYPTED_OVERHEAD = 256 + SSL3_RT_MAX_MD_SIZE;
  SSL3_RT_MAX_TLS13_ENCRYPTED_OVERHEAD = 256;
  SSL3_RT_SEND_MAX_ENCRYPTED_OVERHEAD = SSL_RT_MAX_CIPHER_BLOCK_SIZE + SSL3_RT_MAX_MD_SIZE;
  SSL3_RT_MAX_COMPRESSED_LENGTH = SSL3_RT_MAX_PLAIN_LENGTH + SSL3_RT_MAX_COMPRESSED_OVERHEAD;
  SSL3_RT_MAX_ENCRYPTED_LENGTH = SSL3_RT_MAX_ENCRYPTED_OVERHEAD + SSL3_RT_MAX_COMPRESSED_LENGTH;
  SSL3_RT_MAX_TLS13_ENCRYPTED_LENGTH = SSL3_RT_MAX_PLAIN_LENGTH + SSL3_RT_MAX_TLS13_ENCRYPTED_OVERHEAD;
  SSL3_RT_MAX_PACKET_SIZE = SSL3_RT_MAX_ENCRYPTED_LENGTH + SSL3_RT_HEADER_LENGTH;
  
  SSL3_MD_CLIENT_FINISHED_CONST = #67''#76''#78''#84;
  SSL3_MD_SERVER_FINISHED_CONST = #83''#82''#86''#82;
  
  SSL3_VERSION = $0300;
  SSL3_VERSION_MAJOR = $03;
  SSL3_VERSION_MINOR = $00;
  
  SSL3_RT_CHANGE_CIPHER_SPEC = 20;
  SSL3_RT_ALERT = 21;
  SSL3_RT_HANDSHAKE = 22;
  SSL3_RT_APPLICATION_DATA = 23;
  
  DTLS1_RT_HEARTBEAT = 24;
  TLS1_RT_CRYPTO = $1000;
  TLS1_RT_CRYPTO_PREMASTER = TLS1_RT_CRYPTO or $1;
  TLS1_RT_CRYPTO_CLIENT_RANDOM = TLS1_RT_CRYPTO or $2;
  TLS1_RT_CRYPTO_SERVER_RANDOM = TLS1_RT_CRYPTO or $3;
  TLS1_RT_CRYPTO_MASTER = TLS1_RT_CRYPTO or $4;
  TLS1_RT_CRYPTO_READ = $0000;
  TLS1_RT_CRYPTO_WRITE = $0100;
  TLS1_RT_CRYPTO_MAC = TLS1_RT_CRYPTO or $5;
  TLS1_RT_CRYPTO_KEY = TLS1_RT_CRYPTO or $6;
  TLS1_RT_CRYPTO_IV = TLS1_RT_CRYPTO or $7;
  TLS1_RT_CRYPTO_FIXED_IV = TLS1_RT_CRYPTO or $8;
  
  SSL3_RT_HEADER = $100;
  SSL3_RT_INNER_CONTENT_TYPE = $101;
  
  SSL3_AL_WARNING = 1;
  SSL3_AL_FATAL = 2;
  
  SSL3_AD_CLOSE_NOTIFY = 0;
  SSL3_AD_UNEXPECTED_MESSAGE = 10;
  SSL3_AD_BAD_RECORD_MAC = 20;
  SSL3_AD_DECOMPRESSION_FAILURE = 30;
  SSL3_AD_HANDSHAKE_FAILURE = 40;
  SSL3_AD_NO_CERTIFICATE = 41;
  SSL3_AD_BAD_CERTIFICATE = 42;
  SSL3_AD_UNSUPPORTED_CERTIFICATE = 43;
  SSL3_AD_CERTIFICATE_REVOKED = 44;
  SSL3_AD_CERTIFICATE_EXPIRED = 45;
  SSL3_AD_CERTIFICATE_UNKNOWN = 46;
  SSL3_AD_ILLEGAL_PARAMETER = 47;
  
  TLS1_HB_REQUEST = 1;
  TLS1_HB_RESPONSE = 2;
  
  SSL3_CT_RSA_SIGN = 1;
  SSL3_CT_DSS_SIGN = 2;
  SSL3_CT_RSA_FIXED_DH = 3;
  SSL3_CT_DSS_FIXED_DH = 4;
  SSL3_CT_RSA_EPHEMERAL_DH = 5;
  SSL3_CT_DSS_EPHEMERAL_DH = 6;
  SSL3_CT_FORTEZZA_DMS = 20;
  SSL3_CT_NUMBER = 10;
  SSL3_FLAGS_NO_RENEGOTIATE_CIPHERS = $0001;
  
  TLS1_FLAGS_TLS_PADDING_BUG = $0;
  TLS1_FLAGS_SKIP_CERT_VERIFY = $0010;
  TLS1_FLAGS_ENCRYPT_THEN_MAC_READ = $0100;
  TLS1_FLAGS_ENCRYPT_THEN_MAC = TLS1_FLAGS_ENCRYPT_THEN_MAC_READ;
  TLS1_FLAGS_RECEIVED_EXTMS = $0200;
  TLS1_FLAGS_ENCRYPT_THEN_MAC_WRITE = $0400;
  TLS1_FLAGS_STATELESS = $0800;
  
  SSL3_MT_HELLO_REQUEST = 0;
  SSL3_MT_CLIENT_HELLO = 1;
  SSL3_MT_SERVER_HELLO = 2;
  SSL3_MT_NEWSESSION_TICKET = 4;
  SSL3_MT_END_OF_EARLY_DATA = 5;
  SSL3_MT_ENCRYPTED_EXTENSIONS = 8;
  SSL3_MT_CERTIFICATE = 11;
  SSL3_MT_SERVER_KEY_EXCHANGE = 12;
  SSL3_MT_CERTIFICATE_REQUEST = 13;
  SSL3_MT_SERVER_DONE = 14;
  SSL3_MT_CERTIFICATE_VERIFY = 15;
  SSL3_MT_CLIENT_KEY_EXCHANGE = 16;
  SSL3_MT_FINISHED = 20;
  SSL3_MT_CERTIFICATE_URL = 21;
  SSL3_MT_CERTIFICATE_STATUS = 22;
  SSL3_MT_SUPPLEMENTAL_DATA = 23;
  SSL3_MT_KEY_UPDATE = 24;
  SSL3_MT_NEXT_PROTO = 67;
  SSL3_MT_MESSAGE_HASH = 254;
  DTLS1_MT_HELLO_VERIFY_REQUEST = 3;
  SSL3_MT_CHANGE_CIPHER_SPEC = $0101;
  SSL3_MT_CCS = 1;
  
  SSL3_CC_READ = $001;
  SSL3_CC_WRITE = $002;
  SSL3_CC_CLIENT = $010;
  SSL3_CC_SERVER = $020;
  SSL3_CC_EARLY = $040;
  SSL3_CC_HANDSHAKE = $080;
  SSL3_CC_APPLICATION = $100;
  SSL3_CHANGE_CIPHER_CLIENT_WRITE = SSL3_CC_CLIENT or SSL3_CC_WRITE;
  SSL3_CHANGE_CIPHER_SERVER_READ = SSL3_CC_SERVER or SSL3_CC_READ;
  SSL3_CHANGE_CIPHER_CLIENT_READ = SSL3_CC_CLIENT or SSL3_CC_READ;
  SSL3_CHANGE_CIPHER_SERVER_WRITE = SSL3_CC_SERVER or SSL3_CC_WRITE;
  
  OPENSSL_TLS_SECURITY_LEVEL = 1;

  TLS1_VERSION_MAJOR = $03;
  TLS1_VERSION_MINOR = $01;
  TLS1_1_VERSION_MAJOR = $03;
  TLS1_1_VERSION_MINOR = $02;
  TLS1_2_VERSION_MAJOR = $03;
  TLS1_2_VERSION_MINOR = $03;
  
  TLS1_AD_DECRYPTION_FAILED = 21;
  TLS1_AD_RECORD_OVERFLOW = 22;
  TLS1_AD_UNKNOWN_CA = 48;
  TLS1_AD_ACCESS_DENIED = 49;
  TLS1_AD_DECODE_ERROR = 50;
  TLS1_AD_DECRYPT_ERROR = 51;
  TLS1_AD_EXPORT_RESTRICTION = 60;
  TLS1_AD_PROTOCOL_VERSION = 70;
  TLS1_AD_INSUFFICIENT_SECURITY = 71;
  TLS1_AD_INTERNAL_ERROR = 80;
  TLS1_AD_INAPPROPRIATE_FALLBACK = 86;
  TLS1_AD_USER_CANCELLED = 90;
  TLS1_AD_NO_RENEGOTIATION = 100;
  TLS13_AD_MISSING_EXTENSION = 109;
  TLS13_AD_CERTIFICATE_REQUIRED = 116;
  TLS1_AD_UNSUPPORTED_EXTENSION = 110;
  TLS1_AD_CERTIFICATE_UNOBTAINABLE = 111;
  TLS1_AD_UNRECOGNIZED_NAME = 112;
  TLS1_AD_BAD_CERTIFICATE_STATUS_RESPONSE = 113;
  TLS1_AD_BAD_CERTIFICATE_HASH_VALUE = 114;
  TLS1_AD_UNKNOWN_PSK_IDENTITY = 115;
  TLS1_AD_NO_APPLICATION_PROTOCOL = 120;
  
  TLSEXT_TYPE_server_name = 0;
  TLSEXT_TYPE_max_fragment_length = 1;
  TLSEXT_TYPE_client_certificate_url = 2;
  TLSEXT_TYPE_trusted_ca_keys = 3;
  TLSEXT_TYPE_truncated_hmac = 4;
  TLSEXT_TYPE_status_request = 5;
  TLSEXT_TYPE_user_mapping = 6;
  TLSEXT_TYPE_client_authz = 7;
  TLSEXT_TYPE_server_authz = 8;
  TLSEXT_TYPE_cert_type = 9;
  TLSEXT_TYPE_supported_groups = 10;
  TLSEXT_TYPE_elliptic_curves = TLSEXT_TYPE_supported_groups;
  TLSEXT_TYPE_ec_point_formats = 11;
  TLSEXT_TYPE_srp = 12;
  TLSEXT_TYPE_signature_algorithms = 13;
  TLSEXT_TYPE_use_srtp = 14;
  TLSEXT_TYPE_heartbeat = 15;
  TLSEXT_TYPE_application_layer_protocol_negotiation = 16;
  TLSEXT_TYPE_signed_certificate_timestamp = 18;
  TLSEXT_TYPE_padding = 21;
  TLSEXT_TYPE_encrypt_then_mac = 22;
  TLSEXT_TYPE_extended_master_secret = 23;
  TLSEXT_TYPE_session_ticket = 35;
  TLSEXT_TYPE_psk = 41;
  TLSEXT_TYPE_early_data = 42;
  TLSEXT_TYPE_supported_versions = 43;
  TLSEXT_TYPE_cookie = 44;
  TLSEXT_TYPE_psk_kex_modes = 45;
  TLSEXT_TYPE_certificate_authorities = 47;
  TLSEXT_TYPE_post_handshake_auth = 49;
  TLSEXT_TYPE_signature_algorithms_cert = 50;
  TLSEXT_TYPE_key_share = 51;
  TLSEXT_TYPE_renegotiate = $ff01;
  TLSEXT_TYPE_next_proto_neg = 13172;
  
  TLSEXT_ECPOINTFORMAT_first = 0;
  TLSEXT_ECPOINTFORMAT_uncompressed = 0;
  TLSEXT_ECPOINTFORMAT_ansiX962_compressed_prime = 1;
  TLSEXT_ECPOINTFORMAT_ansiX962_compressed_char2 = 2;
  TLSEXT_ECPOINTFORMAT_last = 2;
  
  TLSEXT_signature_anonymous = 0;
  TLSEXT_signature_rsa = 1;
  TLSEXT_signature_dsa = 2;
  TLSEXT_signature_ecdsa = 3;
  TLSEXT_signature_gostr34102001 = 237;
  TLSEXT_signature_gostr34102012_256 = 238;
  TLSEXT_signature_gostr34102012_512 = 239;
  TLSEXT_signature_num = 7;
  
  TLSEXT_hash_none = 0;
  TLSEXT_hash_md5 = 1;
  TLSEXT_hash_sha1 = 2;
  TLSEXT_hash_sha224 = 3;
  TLSEXT_hash_sha256 = 4;
  TLSEXT_hash_sha384 = 5;
  TLSEXT_hash_sha512 = 6;
  TLSEXT_hash_gostr3411 = 237;
  TLSEXT_hash_gostr34112012_256 = 238;
  TLSEXT_hash_gostr34112012_512 = 239;
  TLSEXT_hash_num = 10;
  
  TLSEXT_nid_unknown = $1000000;
  TLSEXT_curve_P_256 = 23;
  TLSEXT_curve_P_384 = 24;
  
  TLSEXT_max_fragment_length_DISABLED = 0;
  TLSEXT_max_fragment_length_512 = 1;
  TLSEXT_max_fragment_length_1024 = 2;
  TLSEXT_max_fragment_length_2048 = 3;
  TLSEXT_max_fragment_length_4096 = 4;
  TLSEXT_MAXLEN_host_name = 255;
  
  TLS1_CK_PSK_WITH_RC4_128_SHA = $0300008A;
  TLS1_CK_PSK_WITH_3DES_EDE_CBC_SHA = $0300008B;
  TLS1_CK_PSK_WITH_AES_128_CBC_SHA = $0300008C;
  TLS1_CK_PSK_WITH_AES_256_CBC_SHA = $0300008D;
  TLS1_CK_DHE_PSK_WITH_RC4_128_SHA = $0300008E;
  TLS1_CK_DHE_PSK_WITH_3DES_EDE_CBC_SHA = $0300008F;
  TLS1_CK_DHE_PSK_WITH_AES_128_CBC_SHA = $03000090;
  TLS1_CK_DHE_PSK_WITH_AES_256_CBC_SHA = $03000091;
  TLS1_CK_RSA_PSK_WITH_RC4_128_SHA = $03000092;
  TLS1_CK_RSA_PSK_WITH_3DES_EDE_CBC_SHA = $03000093;
  TLS1_CK_RSA_PSK_WITH_AES_128_CBC_SHA = $03000094;
  TLS1_CK_RSA_PSK_WITH_AES_256_CBC_SHA = $03000095;
  TLS1_CK_PSK_WITH_AES_128_GCM_SHA256 = $030000A8;
  TLS1_CK_PSK_WITH_AES_256_GCM_SHA384 = $030000A9;
  TLS1_CK_DHE_PSK_WITH_AES_128_GCM_SHA256 = $030000AA;
  TLS1_CK_DHE_PSK_WITH_AES_256_GCM_SHA384 = $030000AB;
  TLS1_CK_RSA_PSK_WITH_AES_128_GCM_SHA256 = $030000AC;
  TLS1_CK_RSA_PSK_WITH_AES_256_GCM_SHA384 = $030000AD;
  TLS1_CK_PSK_WITH_AES_128_CBC_SHA256 = $030000AE;
  TLS1_CK_PSK_WITH_AES_256_CBC_SHA384 = $030000AF;
  TLS1_CK_PSK_WITH_NULL_SHA256 = $030000B0;
  TLS1_CK_PSK_WITH_NULL_SHA384 = $030000B1;
  TLS1_CK_DHE_PSK_WITH_AES_128_CBC_SHA256 = $030000B2;
  TLS1_CK_DHE_PSK_WITH_AES_256_CBC_SHA384 = $030000B3;
  TLS1_CK_DHE_PSK_WITH_NULL_SHA256 = $030000B4;
  TLS1_CK_DHE_PSK_WITH_NULL_SHA384 = $030000B5;
  TLS1_CK_RSA_PSK_WITH_AES_128_CBC_SHA256 = $030000B6;
  TLS1_CK_RSA_PSK_WITH_AES_256_CBC_SHA384 = $030000B7;
  TLS1_CK_RSA_PSK_WITH_NULL_SHA256 = $030000B8;
  TLS1_CK_RSA_PSK_WITH_NULL_SHA384 = $030000B9;
  TLS1_CK_PSK_WITH_NULL_SHA = $0300002C;
  TLS1_CK_DHE_PSK_WITH_NULL_SHA = $0300002D;
  TLS1_CK_RSA_PSK_WITH_NULL_SHA = $0300002E;
  TLS1_CK_RSA_WITH_AES_128_SHA = $0300002F;
  TLS1_CK_DH_DSS_WITH_AES_128_SHA = $03000030;
  TLS1_CK_DH_RSA_WITH_AES_128_SHA = $03000031;
  TLS1_CK_DHE_DSS_WITH_AES_128_SHA = $03000032;
  TLS1_CK_DHE_RSA_WITH_AES_128_SHA = $03000033;
  TLS1_CK_ADH_WITH_AES_128_SHA = $03000034;
  TLS1_CK_RSA_WITH_AES_256_SHA = $03000035;
  TLS1_CK_DH_DSS_WITH_AES_256_SHA = $03000036;
  TLS1_CK_DH_RSA_WITH_AES_256_SHA = $03000037;
  TLS1_CK_DHE_DSS_WITH_AES_256_SHA = $03000038;
  TLS1_CK_DHE_RSA_WITH_AES_256_SHA = $03000039;
  TLS1_CK_ADH_WITH_AES_256_SHA = $0300003A;
  TLS1_CK_RSA_WITH_NULL_SHA256 = $0300003B;
  TLS1_CK_RSA_WITH_AES_128_SHA256 = $0300003C;
  TLS1_CK_RSA_WITH_AES_256_SHA256 = $0300003D;
  TLS1_CK_DH_DSS_WITH_AES_128_SHA256 = $0300003E;
  TLS1_CK_DH_RSA_WITH_AES_128_SHA256 = $0300003F;
  TLS1_CK_DHE_DSS_WITH_AES_128_SHA256 = $03000040;
  TLS1_CK_RSA_WITH_CAMELLIA_128_CBC_SHA = $03000041;
  TLS1_CK_DH_DSS_WITH_CAMELLIA_128_CBC_SHA = $03000042;
  TLS1_CK_DH_RSA_WITH_CAMELLIA_128_CBC_SHA = $03000043;
  TLS1_CK_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA = $03000044;
  TLS1_CK_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA = $03000045;
  TLS1_CK_ADH_WITH_CAMELLIA_128_CBC_SHA = $03000046;
  TLS1_CK_DHE_RSA_WITH_AES_128_SHA256 = $03000067;
  TLS1_CK_DH_DSS_WITH_AES_256_SHA256 = $03000068;
  TLS1_CK_DH_RSA_WITH_AES_256_SHA256 = $03000069;
  TLS1_CK_DHE_DSS_WITH_AES_256_SHA256 = $0300006A;
  TLS1_CK_DHE_RSA_WITH_AES_256_SHA256 = $0300006B;
  TLS1_CK_ADH_WITH_AES_128_SHA256 = $0300006C;
  TLS1_CK_ADH_WITH_AES_256_SHA256 = $0300006D;
  TLS1_CK_RSA_WITH_CAMELLIA_256_CBC_SHA = $03000084;
  TLS1_CK_DH_DSS_WITH_CAMELLIA_256_CBC_SHA = $03000085;
  TLS1_CK_DH_RSA_WITH_CAMELLIA_256_CBC_SHA = $03000086;
  TLS1_CK_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA = $03000087;
  TLS1_CK_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA = $03000088;
  TLS1_CK_ADH_WITH_CAMELLIA_256_CBC_SHA = $03000089;
  TLS1_CK_RSA_WITH_SEED_SHA = $03000096;
  TLS1_CK_DH_DSS_WITH_SEED_SHA = $03000097;
  TLS1_CK_DH_RSA_WITH_SEED_SHA = $03000098;
  TLS1_CK_DHE_DSS_WITH_SEED_SHA = $03000099;
  TLS1_CK_DHE_RSA_WITH_SEED_SHA = $0300009A;
  TLS1_CK_ADH_WITH_SEED_SHA = $0300009B;
  TLS1_CK_RSA_WITH_AES_128_GCM_SHA256 = $0300009C;
  TLS1_CK_RSA_WITH_AES_256_GCM_SHA384 = $0300009D;
  TLS1_CK_DHE_RSA_WITH_AES_128_GCM_SHA256 = $0300009E;
  TLS1_CK_DHE_RSA_WITH_AES_256_GCM_SHA384 = $0300009F;
  TLS1_CK_DH_RSA_WITH_AES_128_GCM_SHA256 = $030000A0;
  TLS1_CK_DH_RSA_WITH_AES_256_GCM_SHA384 = $030000A1;
  TLS1_CK_DHE_DSS_WITH_AES_128_GCM_SHA256 = $030000A2;
  TLS1_CK_DHE_DSS_WITH_AES_256_GCM_SHA384 = $030000A3;
  TLS1_CK_DH_DSS_WITH_AES_128_GCM_SHA256 = $030000A4;
  TLS1_CK_DH_DSS_WITH_AES_256_GCM_SHA384 = $030000A5;
  TLS1_CK_ADH_WITH_AES_128_GCM_SHA256 = $030000A6;
  TLS1_CK_ADH_WITH_AES_256_GCM_SHA384 = $030000A7;
  TLS1_CK_RSA_WITH_AES_128_CCM = $0300C09C;
  TLS1_CK_RSA_WITH_AES_256_CCM = $0300C09D;
  TLS1_CK_DHE_RSA_WITH_AES_128_CCM = $0300C09E;
  TLS1_CK_DHE_RSA_WITH_AES_256_CCM = $0300C09F;
  TLS1_CK_RSA_WITH_AES_128_CCM_8 = $0300C0A0;
  TLS1_CK_RSA_WITH_AES_256_CCM_8 = $0300C0A1;
  TLS1_CK_DHE_RSA_WITH_AES_128_CCM_8 = $0300C0A2;
  TLS1_CK_DHE_RSA_WITH_AES_256_CCM_8 = $0300C0A3;
  TLS1_CK_PSK_WITH_AES_128_CCM = $0300C0A4;
  TLS1_CK_PSK_WITH_AES_256_CCM = $0300C0A5;
  TLS1_CK_DHE_PSK_WITH_AES_128_CCM = $0300C0A6;
  TLS1_CK_DHE_PSK_WITH_AES_256_CCM = $0300C0A7;
  TLS1_CK_PSK_WITH_AES_128_CCM_8 = $0300C0A8;
  TLS1_CK_PSK_WITH_AES_256_CCM_8 = $0300C0A9;
  TLS1_CK_DHE_PSK_WITH_AES_128_CCM_8 = $0300C0AA;
  TLS1_CK_DHE_PSK_WITH_AES_256_CCM_8 = $0300C0AB;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_128_CCM = $0300C0AC;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_256_CCM = $0300C0AD;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_128_CCM_8 = $0300C0AE;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_256_CCM_8 = $0300C0AF;
  TLS1_CK_RSA_WITH_CAMELLIA_128_CBC_SHA256 = $030000BA;
  TLS1_CK_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256 = $030000BB;
  TLS1_CK_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256 = $030000BC;
  TLS1_CK_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256 = $030000BD;
  TLS1_CK_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = $030000BE;
  TLS1_CK_ADH_WITH_CAMELLIA_128_CBC_SHA256 = $030000BF;
  TLS1_CK_RSA_WITH_CAMELLIA_256_CBC_SHA256 = $030000C0;
  TLS1_CK_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256 = $030000C1;
  TLS1_CK_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256 = $030000C2;
  TLS1_CK_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256 = $030000C3;
  TLS1_CK_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256 = $030000C4;
  TLS1_CK_ADH_WITH_CAMELLIA_256_CBC_SHA256 = $030000C5;
  TLS1_CK_ECDH_ECDSA_WITH_NULL_SHA = $0300C001;
  TLS1_CK_ECDH_ECDSA_WITH_RC4_128_SHA = $0300C002;
  TLS1_CK_ECDH_ECDSA_WITH_DES_192_CBC3_SHA = $0300C003;
  TLS1_CK_ECDH_ECDSA_WITH_AES_128_CBC_SHA = $0300C004;
  TLS1_CK_ECDH_ECDSA_WITH_AES_256_CBC_SHA = $0300C005;
  TLS1_CK_ECDHE_ECDSA_WITH_NULL_SHA = $0300C006;
  TLS1_CK_ECDHE_ECDSA_WITH_RC4_128_SHA = $0300C007;
  TLS1_CK_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA = $0300C008;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = $0300C009;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = $0300C00A;
  TLS1_CK_ECDH_RSA_WITH_NULL_SHA = $0300C00B;
  TLS1_CK_ECDH_RSA_WITH_RC4_128_SHA = $0300C00C;
  TLS1_CK_ECDH_RSA_WITH_DES_192_CBC3_SHA = $0300C00D;
  TLS1_CK_ECDH_RSA_WITH_AES_128_CBC_SHA = $0300C00E;
  TLS1_CK_ECDH_RSA_WITH_AES_256_CBC_SHA = $0300C00F;
  TLS1_CK_ECDHE_RSA_WITH_NULL_SHA = $0300C010;
  TLS1_CK_ECDHE_RSA_WITH_RC4_128_SHA = $0300C011;
  TLS1_CK_ECDHE_RSA_WITH_DES_192_CBC3_SHA = $0300C012;
  TLS1_CK_ECDHE_RSA_WITH_AES_128_CBC_SHA = $0300C013;
  TLS1_CK_ECDHE_RSA_WITH_AES_256_CBC_SHA = $0300C014;
  TLS1_CK_ECDH_anon_WITH_NULL_SHA = $0300C015;
  TLS1_CK_ECDH_anon_WITH_RC4_128_SHA = $0300C016;
  TLS1_CK_ECDH_anon_WITH_DES_192_CBC3_SHA = $0300C017;
  TLS1_CK_ECDH_anon_WITH_AES_128_CBC_SHA = $0300C018;
  TLS1_CK_ECDH_anon_WITH_AES_256_CBC_SHA = $0300C019;
  TLS1_CK_SRP_SHA_WITH_3DES_EDE_CBC_SHA = $0300C01A;
  TLS1_CK_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA = $0300C01B;
  TLS1_CK_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA = $0300C01C;
  TLS1_CK_SRP_SHA_WITH_AES_128_CBC_SHA = $0300C01D;
  TLS1_CK_SRP_SHA_RSA_WITH_AES_128_CBC_SHA = $0300C01E;
  TLS1_CK_SRP_SHA_DSS_WITH_AES_128_CBC_SHA = $0300C01F;
  TLS1_CK_SRP_SHA_WITH_AES_256_CBC_SHA = $0300C020;
  TLS1_CK_SRP_SHA_RSA_WITH_AES_256_CBC_SHA = $0300C021;
  TLS1_CK_SRP_SHA_DSS_WITH_AES_256_CBC_SHA = $0300C022;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_128_SHA256 = $0300C023;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_256_SHA384 = $0300C024;
  TLS1_CK_ECDH_ECDSA_WITH_AES_128_SHA256 = $0300C025;
  TLS1_CK_ECDH_ECDSA_WITH_AES_256_SHA384 = $0300C026;
  TLS1_CK_ECDHE_RSA_WITH_AES_128_SHA256 = $0300C027;
  TLS1_CK_ECDHE_RSA_WITH_AES_256_SHA384 = $0300C028;
  TLS1_CK_ECDH_RSA_WITH_AES_128_SHA256 = $0300C029;
  TLS1_CK_ECDH_RSA_WITH_AES_256_SHA384 = $0300C02A;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 = $0300C02B;
  TLS1_CK_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 = $0300C02C;
  TLS1_CK_ECDH_ECDSA_WITH_AES_128_GCM_SHA256 = $0300C02D;
  TLS1_CK_ECDH_ECDSA_WITH_AES_256_GCM_SHA384 = $0300C02E;
  TLS1_CK_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = $0300C02F;
  TLS1_CK_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = $0300C030;
  TLS1_CK_ECDH_RSA_WITH_AES_128_GCM_SHA256 = $0300C031;
  TLS1_CK_ECDH_RSA_WITH_AES_256_GCM_SHA384 = $0300C032;
  TLS1_CK_ECDHE_PSK_WITH_RC4_128_SHA = $0300C033;
  TLS1_CK_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA = $0300C034;
  TLS1_CK_ECDHE_PSK_WITH_AES_128_CBC_SHA = $0300C035;
  TLS1_CK_ECDHE_PSK_WITH_AES_256_CBC_SHA = $0300C036;
  TLS1_CK_ECDHE_PSK_WITH_AES_128_CBC_SHA256 = $0300C037;
  TLS1_CK_ECDHE_PSK_WITH_AES_256_CBC_SHA384 = $0300C038;
  TLS1_CK_ECDHE_PSK_WITH_NULL_SHA = $0300C039;
  TLS1_CK_ECDHE_PSK_WITH_NULL_SHA256 = $0300C03A;
  TLS1_CK_ECDHE_PSK_WITH_NULL_SHA384 = $0300C03B;
  TLS1_CK_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = $0300C072;
  TLS1_CK_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = $0300C073;
  TLS1_CK_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = $0300C074;
  TLS1_CK_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = $0300C075;
  TLS1_CK_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = $0300C076;
  TLS1_CK_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384 = $0300C077;
  TLS1_CK_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256 = $0300C078;
  TLS1_CK_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384 = $0300C079;
  TLS1_CK_PSK_WITH_CAMELLIA_128_CBC_SHA256 = $0300C094;
  TLS1_CK_PSK_WITH_CAMELLIA_256_CBC_SHA384 = $0300C095;
  TLS1_CK_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = $0300C096;
  TLS1_CK_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = $0300C097;
  TLS1_CK_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256 = $0300C098;
  TLS1_CK_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384 = $0300C099;
  TLS1_CK_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = $0300C09A;
  TLS1_CK_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = $0300C09B;
  TLS1_CK_ECDHE_RSA_WITH_CHACHA20_POLY1305 = $0300CCA8;
  TLS1_CK_ECDHE_ECDSA_WITH_CHACHA20_POLY1305 = $0300CCA9;
  TLS1_CK_DHE_RSA_WITH_CHACHA20_POLY1305 = $0300CCAA;
  TLS1_CK_PSK_WITH_CHACHA20_POLY1305 = $0300CCAB;
  TLS1_CK_ECDHE_PSK_WITH_CHACHA20_POLY1305 = $0300CCAC;
  TLS1_CK_DHE_PSK_WITH_CHACHA20_POLY1305 = $0300CCAD;
  TLS1_CK_RSA_PSK_WITH_CHACHA20_POLY1305 = $0300CCAE;
  
  TLS1_3_CK_AES_128_GCM_SHA256 = $03001301;
  TLS1_3_CK_AES_256_GCM_SHA384 = $03001302;
  TLS1_3_CK_CHACHA20_POLY1305_SHA256 = $03001303;
  TLS1_3_CK_AES_128_CCM_SHA256 = $03001304;
  TLS1_3_CK_AES_128_CCM_8_SHA256 = $03001305;
  
  TLS1_CK_RSA_WITH_ARIA_128_GCM_SHA256 = $0300C050;
  TLS1_CK_RSA_WITH_ARIA_256_GCM_SHA384 = $0300C051;
  TLS1_CK_DHE_RSA_WITH_ARIA_128_GCM_SHA256 = $0300C052;
  TLS1_CK_DHE_RSA_WITH_ARIA_256_GCM_SHA384 = $0300C053;
  TLS1_CK_DH_RSA_WITH_ARIA_128_GCM_SHA256 = $0300C054;
  TLS1_CK_DH_RSA_WITH_ARIA_256_GCM_SHA384 = $0300C055;
  TLS1_CK_DHE_DSS_WITH_ARIA_128_GCM_SHA256 = $0300C056;
  TLS1_CK_DHE_DSS_WITH_ARIA_256_GCM_SHA384 = $0300C057;
  TLS1_CK_DH_DSS_WITH_ARIA_128_GCM_SHA256 = $0300C058;
  TLS1_CK_DH_DSS_WITH_ARIA_256_GCM_SHA384 = $0300C059;
  TLS1_CK_DH_anon_WITH_ARIA_128_GCM_SHA256 = $0300C05A;
  TLS1_CK_DH_anon_WITH_ARIA_256_GCM_SHA384 = $0300C05B;
  TLS1_CK_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256 = $0300C05C;
  TLS1_CK_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384 = $0300C05D;
  TLS1_CK_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256 = $0300C05E;
  TLS1_CK_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384 = $0300C05F;
  TLS1_CK_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256 = $0300C060;
  TLS1_CK_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384 = $0300C061;
  TLS1_CK_ECDH_RSA_WITH_ARIA_128_GCM_SHA256 = $0300C062;
  TLS1_CK_ECDH_RSA_WITH_ARIA_256_GCM_SHA384 = $0300C063;
  TLS1_CK_PSK_WITH_ARIA_128_GCM_SHA256 = $0300C06A;
  TLS1_CK_PSK_WITH_ARIA_256_GCM_SHA384 = $0300C06B;
  TLS1_CK_DHE_PSK_WITH_ARIA_128_GCM_SHA256 = $0300C06C;
  TLS1_CK_DHE_PSK_WITH_ARIA_256_GCM_SHA384 = $0300C06D;
  TLS1_CK_RSA_PSK_WITH_ARIA_128_GCM_SHA256 = $0300C06E;
  TLS1_CK_RSA_PSK_WITH_ARIA_256_GCM_SHA384 = $0300C06F;
  
  TLS1_RFC_RSA_WITH_AES_128_SHA = 'TLS_RSA_WITH_AES_128_CBC_SHA';
  TLS1_RFC_DHE_DSS_WITH_AES_128_SHA = 'TLS_DHE_DSS_WITH_AES_128_CBC_SHA';
  TLS1_RFC_DHE_RSA_WITH_AES_128_SHA = 'TLS_DHE_RSA_WITH_AES_128_CBC_SHA';
  TLS1_RFC_ADH_WITH_AES_128_SHA = 'TLS_DH_anon_WITH_AES_128_CBC_SHA';
  TLS1_RFC_RSA_WITH_AES_256_SHA = 'TLS_RSA_WITH_AES_256_CBC_SHA';
  TLS1_RFC_DHE_DSS_WITH_AES_256_SHA = 'TLS_DHE_DSS_WITH_AES_256_CBC_SHA';
  TLS1_RFC_DHE_RSA_WITH_AES_256_SHA = 'TLS_DHE_RSA_WITH_AES_256_CBC_SHA';
  TLS1_RFC_ADH_WITH_AES_256_SHA = 'TLS_DH_anon_WITH_AES_256_CBC_SHA';
  TLS1_RFC_RSA_WITH_NULL_SHA256 = 'TLS_RSA_WITH_NULL_SHA256';
  TLS1_RFC_RSA_WITH_AES_128_SHA256 = 'TLS_RSA_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_RSA_WITH_AES_256_SHA256 = 'TLS_RSA_WITH_AES_256_CBC_SHA256';
  TLS1_RFC_DHE_DSS_WITH_AES_128_SHA256 = 'TLS_DHE_DSS_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_DHE_RSA_WITH_AES_128_SHA256 = 'TLS_DHE_RSA_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_DHE_DSS_WITH_AES_256_SHA256 = 'TLS_DHE_DSS_WITH_AES_256_CBC_SHA256';
  TLS1_RFC_DHE_RSA_WITH_AES_256_SHA256 = 'TLS_DHE_RSA_WITH_AES_256_CBC_SHA256';
  TLS1_RFC_ADH_WITH_AES_128_SHA256 = 'TLS_DH_anon_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_ADH_WITH_AES_256_SHA256 = 'TLS_DH_anon_WITH_AES_256_CBC_SHA256';
  TLS1_RFC_RSA_WITH_AES_128_GCM_SHA256 = 'TLS_RSA_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_RSA_WITH_AES_256_GCM_SHA384 = 'TLS_RSA_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_DHE_RSA_WITH_AES_128_GCM_SHA256 = 'TLS_DHE_RSA_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_DHE_RSA_WITH_AES_256_GCM_SHA384 = 'TLS_DHE_RSA_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_DHE_DSS_WITH_AES_128_GCM_SHA256 = 'TLS_DHE_DSS_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_DHE_DSS_WITH_AES_256_GCM_SHA384 = 'TLS_DHE_DSS_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_ADH_WITH_AES_128_GCM_SHA256 = 'TLS_DH_anon_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_ADH_WITH_AES_256_GCM_SHA384 = 'TLS_DH_anon_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_RSA_WITH_AES_128_CCM = 'TLS_RSA_WITH_AES_128_CCM';
  TLS1_RFC_RSA_WITH_AES_256_CCM = 'TLS_RSA_WITH_AES_256_CCM';
  TLS1_RFC_DHE_RSA_WITH_AES_128_CCM = 'TLS_DHE_RSA_WITH_AES_128_CCM';
  TLS1_RFC_DHE_RSA_WITH_AES_256_CCM = 'TLS_DHE_RSA_WITH_AES_256_CCM';
  TLS1_RFC_RSA_WITH_AES_128_CCM_8 = 'TLS_RSA_WITH_AES_128_CCM_8';
  TLS1_RFC_RSA_WITH_AES_256_CCM_8 = 'TLS_RSA_WITH_AES_256_CCM_8';
  TLS1_RFC_DHE_RSA_WITH_AES_128_CCM_8 = 'TLS_DHE_RSA_WITH_AES_128_CCM_8';
  TLS1_RFC_DHE_RSA_WITH_AES_256_CCM_8 = 'TLS_DHE_RSA_WITH_AES_256_CCM_8';
  TLS1_RFC_PSK_WITH_AES_128_CCM = 'TLS_PSK_WITH_AES_128_CCM';
  TLS1_RFC_PSK_WITH_AES_256_CCM = 'TLS_PSK_WITH_AES_256_CCM';
  TLS1_RFC_DHE_PSK_WITH_AES_128_CCM = 'TLS_DHE_PSK_WITH_AES_128_CCM';
  TLS1_RFC_DHE_PSK_WITH_AES_256_CCM = 'TLS_DHE_PSK_WITH_AES_256_CCM';
  TLS1_RFC_PSK_WITH_AES_128_CCM_8 = 'TLS_PSK_WITH_AES_128_CCM_8';
  TLS1_RFC_PSK_WITH_AES_256_CCM_8 = 'TLS_PSK_WITH_AES_256_CCM_8';
  TLS1_RFC_DHE_PSK_WITH_AES_128_CCM_8 = 'TLS_PSK_DHE_WITH_AES_128_CCM_8';
  TLS1_RFC_DHE_PSK_WITH_AES_256_CCM_8 = 'TLS_PSK_DHE_WITH_AES_256_CCM_8';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_128_CCM = 'TLS_ECDHE_ECDSA_WITH_AES_128_CCM';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_256_CCM = 'TLS_ECDHE_ECDSA_WITH_AES_256_CCM';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_128_CCM_8 = 'TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_256_CCM_8 = 'TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8';
  
  TLS1_3_RFC_AES_128_GCM_SHA256 = 'TLS_AES_128_GCM_SHA256';
  TLS1_3_RFC_AES_256_GCM_SHA384 = 'TLS_AES_256_GCM_SHA384';
  TLS1_3_RFC_CHACHA20_POLY1305_SHA256 = 'TLS_CHACHA20_POLY1305_SHA256';
  TLS1_3_RFC_AES_128_CCM_SHA256 = 'TLS_AES_128_CCM_SHA256';
  TLS1_3_RFC_AES_128_CCM_8_SHA256 = 'TLS_AES_128_CCM_8_SHA256';
  
  TLS1_RFC_ECDHE_ECDSA_WITH_NULL_SHA = 'TLS_ECDHE_ECDSA_WITH_NULL_SHA';
  TLS1_RFC_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA = 'TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = 'TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = 'TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA';
  TLS1_RFC_ECDHE_RSA_WITH_NULL_SHA = 'TLS_ECDHE_RSA_WITH_NULL_SHA';
  TLS1_RFC_ECDHE_RSA_WITH_DES_192_CBC3_SHA = 'TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_ECDHE_RSA_WITH_AES_128_CBC_SHA = 'TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA';
  TLS1_RFC_ECDHE_RSA_WITH_AES_256_CBC_SHA = 'TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA';
  TLS1_RFC_ECDH_anon_WITH_NULL_SHA = 'TLS_ECDH_anon_WITH_NULL_SHA';
  TLS1_RFC_ECDH_anon_WITH_DES_192_CBC3_SHA = 'TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_ECDH_anon_WITH_AES_128_CBC_SHA = 'TLS_ECDH_anon_WITH_AES_128_CBC_SHA';
  TLS1_RFC_ECDH_anon_WITH_AES_256_CBC_SHA = 'TLS_ECDH_anon_WITH_AES_256_CBC_SHA';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_128_SHA256 = 'TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_256_SHA384 = 'TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384';
  TLS1_RFC_ECDHE_RSA_WITH_AES_128_SHA256 = 'TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_ECDHE_RSA_WITH_AES_256_SHA384 = 'TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 = 'TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 = 'TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = 'TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = 'TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_PSK_WITH_NULL_SHA = 'TLS_PSK_WITH_NULL_SHA';
  TLS1_RFC_DHE_PSK_WITH_NULL_SHA = 'TLS_DHE_PSK_WITH_NULL_SHA';
  TLS1_RFC_RSA_PSK_WITH_NULL_SHA = 'TLS_RSA_PSK_WITH_NULL_SHA';
  TLS1_RFC_PSK_WITH_3DES_EDE_CBC_SHA = 'TLS_PSK_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_PSK_WITH_AES_128_CBC_SHA = 'TLS_PSK_WITH_AES_128_CBC_SHA';
  TLS1_RFC_PSK_WITH_AES_256_CBC_SHA = 'TLS_PSK_WITH_AES_256_CBC_SHA';
  TLS1_RFC_DHE_PSK_WITH_3DES_EDE_CBC_SHA = 'TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_DHE_PSK_WITH_AES_128_CBC_SHA = 'TLS_DHE_PSK_WITH_AES_128_CBC_SHA';
  TLS1_RFC_DHE_PSK_WITH_AES_256_CBC_SHA = 'TLS_DHE_PSK_WITH_AES_256_CBC_SHA';
  TLS1_RFC_RSA_PSK_WITH_3DES_EDE_CBC_SHA = 'TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_RSA_PSK_WITH_AES_128_CBC_SHA = 'TLS_RSA_PSK_WITH_AES_128_CBC_SHA';
  TLS1_RFC_RSA_PSK_WITH_AES_256_CBC_SHA = 'TLS_RSA_PSK_WITH_AES_256_CBC_SHA';
  TLS1_RFC_PSK_WITH_AES_128_GCM_SHA256 = 'TLS_PSK_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_PSK_WITH_AES_256_GCM_SHA384 = 'TLS_PSK_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_DHE_PSK_WITH_AES_128_GCM_SHA256 = 'TLS_DHE_PSK_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_DHE_PSK_WITH_AES_256_GCM_SHA384 = 'TLS_DHE_PSK_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_RSA_PSK_WITH_AES_128_GCM_SHA256 = 'TLS_RSA_PSK_WITH_AES_128_GCM_SHA256';
  TLS1_RFC_RSA_PSK_WITH_AES_256_GCM_SHA384 = 'TLS_RSA_PSK_WITH_AES_256_GCM_SHA384';
  TLS1_RFC_PSK_WITH_AES_128_CBC_SHA256 = 'TLS_PSK_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_PSK_WITH_AES_256_CBC_SHA384 = 'TLS_PSK_WITH_AES_256_CBC_SHA384';
  TLS1_RFC_PSK_WITH_NULL_SHA256 = 'TLS_PSK_WITH_NULL_SHA256';
  TLS1_RFC_PSK_WITH_NULL_SHA384 = 'TLS_PSK_WITH_NULL_SHA384';
  TLS1_RFC_DHE_PSK_WITH_AES_128_CBC_SHA256 = 'TLS_DHE_PSK_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_DHE_PSK_WITH_AES_256_CBC_SHA384 = 'TLS_DHE_PSK_WITH_AES_256_CBC_SHA384';
  TLS1_RFC_DHE_PSK_WITH_NULL_SHA256 = 'TLS_DHE_PSK_WITH_NULL_SHA256';
  TLS1_RFC_DHE_PSK_WITH_NULL_SHA384 = 'TLS_DHE_PSK_WITH_NULL_SHA384';
  TLS1_RFC_RSA_PSK_WITH_AES_128_CBC_SHA256 = 'TLS_RSA_PSK_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_RSA_PSK_WITH_AES_256_CBC_SHA384 = 'TLS_RSA_PSK_WITH_AES_256_CBC_SHA384';
  TLS1_RFC_RSA_PSK_WITH_NULL_SHA256 = 'TLS_RSA_PSK_WITH_NULL_SHA256';
  TLS1_RFC_RSA_PSK_WITH_NULL_SHA384 = 'TLS_RSA_PSK_WITH_NULL_SHA384';
  TLS1_RFC_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA = 'TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_ECDHE_PSK_WITH_AES_128_CBC_SHA = 'TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA';
  TLS1_RFC_ECDHE_PSK_WITH_AES_256_CBC_SHA = 'TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA';
  TLS1_RFC_ECDHE_PSK_WITH_AES_128_CBC_SHA256 = 'TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256';
  TLS1_RFC_ECDHE_PSK_WITH_AES_256_CBC_SHA384 = 'TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384';
  TLS1_RFC_ECDHE_PSK_WITH_NULL_SHA = 'TLS_ECDHE_PSK_WITH_NULL_SHA';
  TLS1_RFC_ECDHE_PSK_WITH_NULL_SHA256 = 'TLS_ECDHE_PSK_WITH_NULL_SHA256';
  TLS1_RFC_ECDHE_PSK_WITH_NULL_SHA384 = 'TLS_ECDHE_PSK_WITH_NULL_SHA384';
  TLS1_RFC_SRP_SHA_WITH_3DES_EDE_CBC_SHA = 'TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA = 'TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA = 'TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA';
  TLS1_RFC_SRP_SHA_WITH_AES_128_CBC_SHA = 'TLS_SRP_SHA_WITH_AES_128_CBC_SHA';
  TLS1_RFC_SRP_SHA_RSA_WITH_AES_128_CBC_SHA = 'TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA';
  TLS1_RFC_SRP_SHA_DSS_WITH_AES_128_CBC_SHA = 'TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA';
  TLS1_RFC_SRP_SHA_WITH_AES_256_CBC_SHA = 'TLS_SRP_SHA_WITH_AES_256_CBC_SHA';
  TLS1_RFC_SRP_SHA_RSA_WITH_AES_256_CBC_SHA = 'TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA';
  TLS1_RFC_SRP_SHA_DSS_WITH_AES_256_CBC_SHA = 'TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA';
  TLS1_RFC_DHE_RSA_WITH_CHACHA20_POLY1305 = 'TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256';
  TLS1_RFC_ECDHE_RSA_WITH_CHACHA20_POLY1305 = 'TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256';
  TLS1_RFC_ECDHE_ECDSA_WITH_CHACHA20_POLY1305 = 'TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256';
  TLS1_RFC_PSK_WITH_CHACHA20_POLY1305 = 'TLS_PSK_WITH_CHACHA20_POLY1305_SHA256';
  TLS1_RFC_ECDHE_PSK_WITH_CHACHA20_POLY1305 = 'TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256';
  TLS1_RFC_DHE_PSK_WITH_CHACHA20_POLY1305 = 'TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256';
  TLS1_RFC_RSA_PSK_WITH_CHACHA20_POLY1305 = 'TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256';
  TLS1_RFC_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_ADH_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 'TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256';
  TLS1_RFC_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256 = 'TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256';
  TLS1_RFC_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 'TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256';
  TLS1_RFC_ADH_WITH_CAMELLIA_256_CBC_SHA256 = 'TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256';
  TLS1_RFC_RSA_WITH_CAMELLIA_256_CBC_SHA = 'TLS_RSA_WITH_CAMELLIA_256_CBC_SHA';
  TLS1_RFC_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA = 'TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA';
  TLS1_RFC_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA = 'TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA';
  TLS1_RFC_ADH_WITH_CAMELLIA_256_CBC_SHA = 'TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA';
  TLS1_RFC_RSA_WITH_CAMELLIA_128_CBC_SHA = 'TLS_RSA_WITH_CAMELLIA_128_CBC_SHA';
  TLS1_RFC_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA = 'TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA';
  TLS1_RFC_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA = 'TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA';
  TLS1_RFC_ADH_WITH_CAMELLIA_128_CBC_SHA = 'TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA';
  TLS1_RFC_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = 'TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384';
  TLS1_RFC_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384 = 'TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384';
  TLS1_RFC_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 'TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384';
  TLS1_RFC_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 'TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384';
  TLS1_RFC_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 'TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384';
  TLS1_RFC_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 'TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256';
  TLS1_RFC_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 'TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384';
  TLS1_RFC_RSA_WITH_SEED_SHA = 'TLS_RSA_WITH_SEED_CBC_SHA';
  TLS1_RFC_DHE_DSS_WITH_SEED_SHA = 'TLS_DHE_DSS_WITH_SEED_CBC_SHA';
  TLS1_RFC_DHE_RSA_WITH_SEED_SHA = 'TLS_DHE_RSA_WITH_SEED_CBC_SHA';
  TLS1_RFC_ADH_WITH_SEED_SHA = 'TLS_DH_anon_WITH_SEED_CBC_SHA';
  TLS1_RFC_ECDHE_PSK_WITH_RC4_128_SHA = 'TLS_ECDHE_PSK_WITH_RC4_128_SHA';
  TLS1_RFC_ECDH_anon_WITH_RC4_128_SHA = 'TLS_ECDH_anon_WITH_RC4_128_SHA';
  TLS1_RFC_ECDHE_ECDSA_WITH_RC4_128_SHA = 'TLS_ECDHE_ECDSA_WITH_RC4_128_SHA';
  TLS1_RFC_ECDHE_RSA_WITH_RC4_128_SHA = 'TLS_ECDHE_RSA_WITH_RC4_128_SHA';
  TLS1_RFC_PSK_WITH_RC4_128_SHA = 'TLS_PSK_WITH_RC4_128_SHA';
  TLS1_RFC_RSA_PSK_WITH_RC4_128_SHA = 'TLS_RSA_PSK_WITH_RC4_128_SHA';
  TLS1_RFC_DHE_PSK_WITH_RC4_128_SHA = 'TLS_DHE_PSK_WITH_RC4_128_SHA';
  TLS1_RFC_RSA_WITH_ARIA_128_GCM_SHA256 = 'TLS_RSA_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_RSA_WITH_ARIA_256_GCM_SHA384 = 'TLS_RSA_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_DHE_RSA_WITH_ARIA_128_GCM_SHA256 = 'TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_DHE_RSA_WITH_ARIA_256_GCM_SHA384 = 'TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_DH_RSA_WITH_ARIA_128_GCM_SHA256 = 'TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_DH_RSA_WITH_ARIA_256_GCM_SHA384 = 'TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_DHE_DSS_WITH_ARIA_128_GCM_SHA256 = 'TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_DHE_DSS_WITH_ARIA_256_GCM_SHA384 = 'TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_DH_DSS_WITH_ARIA_128_GCM_SHA256 = 'TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_DH_DSS_WITH_ARIA_256_GCM_SHA384 = 'TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_DH_anon_WITH_ARIA_128_GCM_SHA256 = 'TLS_DH_anon_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_DH_anon_WITH_ARIA_256_GCM_SHA384 = 'TLS_DH_anon_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256 = 'TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384 = 'TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256 = 'TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384 = 'TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256 = 'TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384 = 'TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_ECDH_RSA_WITH_ARIA_128_GCM_SHA256 = 'TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_ECDH_RSA_WITH_ARIA_256_GCM_SHA384 = 'TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_PSK_WITH_ARIA_128_GCM_SHA256 = 'TLS_PSK_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_PSK_WITH_ARIA_256_GCM_SHA384 = 'TLS_PSK_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_DHE_PSK_WITH_ARIA_128_GCM_SHA256 = 'TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_DHE_PSK_WITH_ARIA_256_GCM_SHA384 = 'TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384';
  TLS1_RFC_RSA_PSK_WITH_ARIA_128_GCM_SHA256 = 'TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256';
  TLS1_RFC_RSA_PSK_WITH_ARIA_256_GCM_SHA384 = 'TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384';
  
  TLS1_TXT_DHE_DSS_WITH_RC4_128_SHA = 'DHE-DSS-RC4-SHA';
  TLS1_TXT_PSK_WITH_NULL_SHA = 'PSK-NULL-SHA';
  TLS1_TXT_DHE_PSK_WITH_NULL_SHA = 'DHE-PSK-NULL-SHA';
  TLS1_TXT_RSA_PSK_WITH_NULL_SHA = 'RSA-PSK-NULL-SHA';
  TLS1_TXT_RSA_WITH_AES_128_SHA = 'AES128-SHA';
  TLS1_TXT_DH_DSS_WITH_AES_128_SHA = 'DH-DSS-AES128-SHA';
  TLS1_TXT_DH_RSA_WITH_AES_128_SHA = 'DH-RSA-AES128-SHA';
  TLS1_TXT_DHE_DSS_WITH_AES_128_SHA = 'DHE-DSS-AES128-SHA';
  TLS1_TXT_DHE_RSA_WITH_AES_128_SHA = 'DHE-RSA-AES128-SHA';
  TLS1_TXT_ADH_WITH_AES_128_SHA = 'ADH-AES128-SHA';
  TLS1_TXT_RSA_WITH_AES_256_SHA = 'AES256-SHA';
  TLS1_TXT_DH_DSS_WITH_AES_256_SHA = 'DH-DSS-AES256-SHA';
  TLS1_TXT_DH_RSA_WITH_AES_256_SHA = 'DH-RSA-AES256-SHA';
  TLS1_TXT_DHE_DSS_WITH_AES_256_SHA = 'DHE-DSS-AES256-SHA';
  TLS1_TXT_DHE_RSA_WITH_AES_256_SHA = 'DHE-RSA-AES256-SHA';
  TLS1_TXT_ADH_WITH_AES_256_SHA = 'ADH-AES256-SHA';
  TLS1_TXT_ECDH_ECDSA_WITH_NULL_SHA = 'ECDH-ECDSA-NULL-SHA';
  TLS1_TXT_ECDH_ECDSA_WITH_RC4_128_SHA = 'ECDH-ECDSA-RC4-SHA';
  TLS1_TXT_ECDH_ECDSA_WITH_DES_192_CBC3_SHA = 'ECDH-ECDSA-DES-CBC3-SHA';
  TLS1_TXT_ECDH_ECDSA_WITH_AES_128_CBC_SHA = 'ECDH-ECDSA-AES128-SHA';
  TLS1_TXT_ECDH_ECDSA_WITH_AES_256_CBC_SHA = 'ECDH-ECDSA-AES256-SHA';
  TLS1_TXT_ECDHE_ECDSA_WITH_NULL_SHA = 'ECDHE-ECDSA-NULL-SHA';
  TLS1_TXT_ECDHE_ECDSA_WITH_RC4_128_SHA = 'ECDHE-ECDSA-RC4-SHA';
  TLS1_TXT_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA = 'ECDHE-ECDSA-DES-CBC3-SHA';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = 'ECDHE-ECDSA-AES128-SHA';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = 'ECDHE-ECDSA-AES256-SHA';
  TLS1_TXT_ECDH_RSA_WITH_NULL_SHA = 'ECDH-RSA-NULL-SHA';
  TLS1_TXT_ECDH_RSA_WITH_RC4_128_SHA = 'ECDH-RSA-RC4-SHA';
  TLS1_TXT_ECDH_RSA_WITH_DES_192_CBC3_SHA = 'ECDH-RSA-DES-CBC3-SHA';
  TLS1_TXT_ECDH_RSA_WITH_AES_128_CBC_SHA = 'ECDH-RSA-AES128-SHA';
  TLS1_TXT_ECDH_RSA_WITH_AES_256_CBC_SHA = 'ECDH-RSA-AES256-SHA';
  TLS1_TXT_ECDHE_RSA_WITH_NULL_SHA = 'ECDHE-RSA-NULL-SHA';
  TLS1_TXT_ECDHE_RSA_WITH_RC4_128_SHA = 'ECDHE-RSA-RC4-SHA';
  TLS1_TXT_ECDHE_RSA_WITH_DES_192_CBC3_SHA = 'ECDHE-RSA-DES-CBC3-SHA';
  TLS1_TXT_ECDHE_RSA_WITH_AES_128_CBC_SHA = 'ECDHE-RSA-AES128-SHA';
  TLS1_TXT_ECDHE_RSA_WITH_AES_256_CBC_SHA = 'ECDHE-RSA-AES256-SHA';
  TLS1_TXT_ECDH_anon_WITH_NULL_SHA = 'AECDH-NULL-SHA';
  TLS1_TXT_ECDH_anon_WITH_RC4_128_SHA = 'AECDH-RC4-SHA';
  TLS1_TXT_ECDH_anon_WITH_DES_192_CBC3_SHA = 'AECDH-DES-CBC3-SHA';
  TLS1_TXT_ECDH_anon_WITH_AES_128_CBC_SHA = 'AECDH-AES128-SHA';
  TLS1_TXT_ECDH_anon_WITH_AES_256_CBC_SHA = 'AECDH-AES256-SHA';
  TLS1_TXT_PSK_WITH_RC4_128_SHA = 'PSK-RC4-SHA';
  TLS1_TXT_PSK_WITH_3DES_EDE_CBC_SHA = 'PSK-3DES-EDE-CBC-SHA';
  TLS1_TXT_PSK_WITH_AES_128_CBC_SHA = 'PSK-AES128-CBC-SHA';
  TLS1_TXT_PSK_WITH_AES_256_CBC_SHA = 'PSK-AES256-CBC-SHA';
  TLS1_TXT_DHE_PSK_WITH_RC4_128_SHA = 'DHE-PSK-RC4-SHA';
  TLS1_TXT_DHE_PSK_WITH_3DES_EDE_CBC_SHA = 'DHE-PSK-3DES-EDE-CBC-SHA';
  TLS1_TXT_DHE_PSK_WITH_AES_128_CBC_SHA = 'DHE-PSK-AES128-CBC-SHA';
  TLS1_TXT_DHE_PSK_WITH_AES_256_CBC_SHA = 'DHE-PSK-AES256-CBC-SHA';
  TLS1_TXT_RSA_PSK_WITH_RC4_128_SHA = 'RSA-PSK-RC4-SHA';
  TLS1_TXT_RSA_PSK_WITH_3DES_EDE_CBC_SHA = 'RSA-PSK-3DES-EDE-CBC-SHA';
  TLS1_TXT_RSA_PSK_WITH_AES_128_CBC_SHA = 'RSA-PSK-AES128-CBC-SHA';
  TLS1_TXT_RSA_PSK_WITH_AES_256_CBC_SHA = 'RSA-PSK-AES256-CBC-SHA';
  TLS1_TXT_PSK_WITH_AES_128_GCM_SHA256 = 'PSK-AES128-GCM-SHA256';
  TLS1_TXT_PSK_WITH_AES_256_GCM_SHA384 = 'PSK-AES256-GCM-SHA384';
  TLS1_TXT_DHE_PSK_WITH_AES_128_GCM_SHA256 = 'DHE-PSK-AES128-GCM-SHA256';
  TLS1_TXT_DHE_PSK_WITH_AES_256_GCM_SHA384 = 'DHE-PSK-AES256-GCM-SHA384';
  TLS1_TXT_RSA_PSK_WITH_AES_128_GCM_SHA256 = 'RSA-PSK-AES128-GCM-SHA256';
  TLS1_TXT_RSA_PSK_WITH_AES_256_GCM_SHA384 = 'RSA-PSK-AES256-GCM-SHA384';
  TLS1_TXT_PSK_WITH_AES_128_CBC_SHA256 = 'PSK-AES128-CBC-SHA256';
  TLS1_TXT_PSK_WITH_AES_256_CBC_SHA384 = 'PSK-AES256-CBC-SHA384';
  TLS1_TXT_PSK_WITH_NULL_SHA256 = 'PSK-NULL-SHA256';
  TLS1_TXT_PSK_WITH_NULL_SHA384 = 'PSK-NULL-SHA384';
  TLS1_TXT_DHE_PSK_WITH_AES_128_CBC_SHA256 = 'DHE-PSK-AES128-CBC-SHA256';
  TLS1_TXT_DHE_PSK_WITH_AES_256_CBC_SHA384 = 'DHE-PSK-AES256-CBC-SHA384';
  TLS1_TXT_DHE_PSK_WITH_NULL_SHA256 = 'DHE-PSK-NULL-SHA256';
  TLS1_TXT_DHE_PSK_WITH_NULL_SHA384 = 'DHE-PSK-NULL-SHA384';
  TLS1_TXT_RSA_PSK_WITH_AES_128_CBC_SHA256 = 'RSA-PSK-AES128-CBC-SHA256';
  TLS1_TXT_RSA_PSK_WITH_AES_256_CBC_SHA384 = 'RSA-PSK-AES256-CBC-SHA384';
  TLS1_TXT_RSA_PSK_WITH_NULL_SHA256 = 'RSA-PSK-NULL-SHA256';
  TLS1_TXT_RSA_PSK_WITH_NULL_SHA384 = 'RSA-PSK-NULL-SHA384';
  TLS1_TXT_SRP_SHA_WITH_3DES_EDE_CBC_SHA = 'SRP-3DES-EDE-CBC-SHA';
  TLS1_TXT_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA = 'SRP-RSA-3DES-EDE-CBC-SHA';
  TLS1_TXT_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA = 'SRP-DSS-3DES-EDE-CBC-SHA';
  TLS1_TXT_SRP_SHA_WITH_AES_128_CBC_SHA = 'SRP-AES-128-CBC-SHA';
  TLS1_TXT_SRP_SHA_RSA_WITH_AES_128_CBC_SHA = 'SRP-RSA-AES-128-CBC-SHA';
  TLS1_TXT_SRP_SHA_DSS_WITH_AES_128_CBC_SHA = 'SRP-DSS-AES-128-CBC-SHA';
  TLS1_TXT_SRP_SHA_WITH_AES_256_CBC_SHA = 'SRP-AES-256-CBC-SHA';
  TLS1_TXT_SRP_SHA_RSA_WITH_AES_256_CBC_SHA = 'SRP-RSA-AES-256-CBC-SHA';
  TLS1_TXT_SRP_SHA_DSS_WITH_AES_256_CBC_SHA = 'SRP-DSS-AES-256-CBC-SHA';
  TLS1_TXT_RSA_WITH_CAMELLIA_128_CBC_SHA = 'CAMELLIA128-SHA';
  TLS1_TXT_DH_DSS_WITH_CAMELLIA_128_CBC_SHA = 'DH-DSS-CAMELLIA128-SHA';
  TLS1_TXT_DH_RSA_WITH_CAMELLIA_128_CBC_SHA = 'DH-RSA-CAMELLIA128-SHA';
  TLS1_TXT_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA = 'DHE-DSS-CAMELLIA128-SHA';
  TLS1_TXT_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA = 'DHE-RSA-CAMELLIA128-SHA';
  TLS1_TXT_ADH_WITH_CAMELLIA_128_CBC_SHA = 'ADH-CAMELLIA128-SHA';
  TLS1_TXT_RSA_WITH_CAMELLIA_256_CBC_SHA = 'CAMELLIA256-SHA';
  TLS1_TXT_DH_DSS_WITH_CAMELLIA_256_CBC_SHA = 'DH-DSS-CAMELLIA256-SHA';
  TLS1_TXT_DH_RSA_WITH_CAMELLIA_256_CBC_SHA = 'DH-RSA-CAMELLIA256-SHA';
  TLS1_TXT_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA = 'DHE-DSS-CAMELLIA256-SHA';
  TLS1_TXT_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA = 'DHE-RSA-CAMELLIA256-SHA';
  TLS1_TXT_ADH_WITH_CAMELLIA_256_CBC_SHA = 'ADH-CAMELLIA256-SHA';
  TLS1_TXT_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 'CAMELLIA128-SHA256';
  TLS1_TXT_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256 = 'DH-DSS-CAMELLIA128-SHA256';
  TLS1_TXT_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 'DH-RSA-CAMELLIA128-SHA256';
  TLS1_TXT_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256 = 'DHE-DSS-CAMELLIA128-SHA256';
  TLS1_TXT_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 'DHE-RSA-CAMELLIA128-SHA256';
  TLS1_TXT_ADH_WITH_CAMELLIA_128_CBC_SHA256 = 'ADH-CAMELLIA128-SHA256';
  TLS1_TXT_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 'CAMELLIA256-SHA256';
  TLS1_TXT_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256 = 'DH-DSS-CAMELLIA256-SHA256';
  TLS1_TXT_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 'DH-RSA-CAMELLIA256-SHA256';
  TLS1_TXT_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256 = 'DHE-DSS-CAMELLIA256-SHA256';
  TLS1_TXT_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 'DHE-RSA-CAMELLIA256-SHA256';
  TLS1_TXT_ADH_WITH_CAMELLIA_256_CBC_SHA256 = 'ADH-CAMELLIA256-SHA256';
  TLS1_TXT_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 'PSK-CAMELLIA128-SHA256';
  TLS1_TXT_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 'PSK-CAMELLIA256-SHA384';
  TLS1_TXT_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 'DHE-PSK-CAMELLIA128-SHA256';
  TLS1_TXT_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 'DHE-PSK-CAMELLIA256-SHA384';
  TLS1_TXT_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 'RSA-PSK-CAMELLIA128-SHA256';
  TLS1_TXT_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 'RSA-PSK-CAMELLIA256-SHA384';
  TLS1_TXT_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 'ECDHE-PSK-CAMELLIA128-SHA256';
  TLS1_TXT_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 'ECDHE-PSK-CAMELLIA256-SHA384';
  TLS1_TXT_RSA_WITH_SEED_SHA = 'SEED-SHA';
  TLS1_TXT_DH_DSS_WITH_SEED_SHA = 'DH-DSS-SEED-SHA';
  TLS1_TXT_DH_RSA_WITH_SEED_SHA = 'DH-RSA-SEED-SHA';
  TLS1_TXT_DHE_DSS_WITH_SEED_SHA = 'DHE-DSS-SEED-SHA';
  TLS1_TXT_DHE_RSA_WITH_SEED_SHA = 'DHE-RSA-SEED-SHA';
  TLS1_TXT_ADH_WITH_SEED_SHA = 'ADH-SEED-SHA';
  TLS1_TXT_RSA_WITH_NULL_SHA256 = 'NULL-SHA256';
  TLS1_TXT_RSA_WITH_AES_128_SHA256 = 'AES128-SHA256';
  TLS1_TXT_RSA_WITH_AES_256_SHA256 = 'AES256-SHA256';
  TLS1_TXT_DH_DSS_WITH_AES_128_SHA256 = 'DH-DSS-AES128-SHA256';
  TLS1_TXT_DH_RSA_WITH_AES_128_SHA256 = 'DH-RSA-AES128-SHA256';
  TLS1_TXT_DHE_DSS_WITH_AES_128_SHA256 = 'DHE-DSS-AES128-SHA256';
  TLS1_TXT_DHE_RSA_WITH_AES_128_SHA256 = 'DHE-RSA-AES128-SHA256';
  TLS1_TXT_DH_DSS_WITH_AES_256_SHA256 = 'DH-DSS-AES256-SHA256';
  TLS1_TXT_DH_RSA_WITH_AES_256_SHA256 = 'DH-RSA-AES256-SHA256';
  TLS1_TXT_DHE_DSS_WITH_AES_256_SHA256 = 'DHE-DSS-AES256-SHA256';
  TLS1_TXT_DHE_RSA_WITH_AES_256_SHA256 = 'DHE-RSA-AES256-SHA256';
  TLS1_TXT_ADH_WITH_AES_128_SHA256 = 'ADH-AES128-SHA256';
  TLS1_TXT_ADH_WITH_AES_256_SHA256 = 'ADH-AES256-SHA256';
  TLS1_TXT_RSA_WITH_AES_128_GCM_SHA256 = 'AES128-GCM-SHA256';
  TLS1_TXT_RSA_WITH_AES_256_GCM_SHA384 = 'AES256-GCM-SHA384';
  TLS1_TXT_DHE_RSA_WITH_AES_128_GCM_SHA256 = 'DHE-RSA-AES128-GCM-SHA256';
  TLS1_TXT_DHE_RSA_WITH_AES_256_GCM_SHA384 = 'DHE-RSA-AES256-GCM-SHA384';
  TLS1_TXT_DH_RSA_WITH_AES_128_GCM_SHA256 = 'DH-RSA-AES128-GCM-SHA256';
  TLS1_TXT_DH_RSA_WITH_AES_256_GCM_SHA384 = 'DH-RSA-AES256-GCM-SHA384';
  TLS1_TXT_DHE_DSS_WITH_AES_128_GCM_SHA256 = 'DHE-DSS-AES128-GCM-SHA256';
  TLS1_TXT_DHE_DSS_WITH_AES_256_GCM_SHA384 = 'DHE-DSS-AES256-GCM-SHA384';
  TLS1_TXT_DH_DSS_WITH_AES_128_GCM_SHA256 = 'DH-DSS-AES128-GCM-SHA256';
  TLS1_TXT_DH_DSS_WITH_AES_256_GCM_SHA384 = 'DH-DSS-AES256-GCM-SHA384';
  TLS1_TXT_ADH_WITH_AES_128_GCM_SHA256 = 'ADH-AES128-GCM-SHA256';
  TLS1_TXT_ADH_WITH_AES_256_GCM_SHA384 = 'ADH-AES256-GCM-SHA384';
  TLS1_TXT_RSA_WITH_AES_128_CCM = 'AES128-CCM';
  TLS1_TXT_RSA_WITH_AES_256_CCM = 'AES256-CCM';
  TLS1_TXT_DHE_RSA_WITH_AES_128_CCM = 'DHE-RSA-AES128-CCM';
  TLS1_TXT_DHE_RSA_WITH_AES_256_CCM = 'DHE-RSA-AES256-CCM';
  TLS1_TXT_RSA_WITH_AES_128_CCM_8 = 'AES128-CCM8';
  TLS1_TXT_RSA_WITH_AES_256_CCM_8 = 'AES256-CCM8';
  TLS1_TXT_DHE_RSA_WITH_AES_128_CCM_8 = 'DHE-RSA-AES128-CCM8';
  TLS1_TXT_DHE_RSA_WITH_AES_256_CCM_8 = 'DHE-RSA-AES256-CCM8';
  TLS1_TXT_PSK_WITH_AES_128_CCM = 'PSK-AES128-CCM';
  TLS1_TXT_PSK_WITH_AES_256_CCM = 'PSK-AES256-CCM';
  TLS1_TXT_DHE_PSK_WITH_AES_128_CCM = 'DHE-PSK-AES128-CCM';
  TLS1_TXT_DHE_PSK_WITH_AES_256_CCM = 'DHE-PSK-AES256-CCM';
  TLS1_TXT_PSK_WITH_AES_128_CCM_8 = 'PSK-AES128-CCM8';
  TLS1_TXT_PSK_WITH_AES_256_CCM_8 = 'PSK-AES256-CCM8';
  TLS1_TXT_DHE_PSK_WITH_AES_128_CCM_8 = 'DHE-PSK-AES128-CCM8';
  TLS1_TXT_DHE_PSK_WITH_AES_256_CCM_8 = 'DHE-PSK-AES256-CCM8';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_CCM = 'ECDHE-ECDSA-AES128-CCM';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_CCM = 'ECDHE-ECDSA-AES256-CCM';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_CCM_8 = 'ECDHE-ECDSA-AES128-CCM8';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_CCM_8 = 'ECDHE-ECDSA-AES256-CCM8';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_SHA256 = 'ECDHE-ECDSA-AES128-SHA256';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_SHA384 = 'ECDHE-ECDSA-AES256-SHA384';
  TLS1_TXT_ECDH_ECDSA_WITH_AES_128_SHA256 = 'ECDH-ECDSA-AES128-SHA256';
  TLS1_TXT_ECDH_ECDSA_WITH_AES_256_SHA384 = 'ECDH-ECDSA-AES256-SHA384';
  TLS1_TXT_ECDHE_RSA_WITH_AES_128_SHA256 = 'ECDHE-RSA-AES128-SHA256';
  TLS1_TXT_ECDHE_RSA_WITH_AES_256_SHA384 = 'ECDHE-RSA-AES256-SHA384';
  TLS1_TXT_ECDH_RSA_WITH_AES_128_SHA256 = 'ECDH-RSA-AES128-SHA256';
  TLS1_TXT_ECDH_RSA_WITH_AES_256_SHA384 = 'ECDH-RSA-AES256-SHA384';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 = 'ECDHE-ECDSA-AES128-GCM-SHA256';
  TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 = 'ECDHE-ECDSA-AES256-GCM-SHA384';
  TLS1_TXT_ECDH_ECDSA_WITH_AES_128_GCM_SHA256 = 'ECDH-ECDSA-AES128-GCM-SHA256';
  TLS1_TXT_ECDH_ECDSA_WITH_AES_256_GCM_SHA384 = 'ECDH-ECDSA-AES256-GCM-SHA384';
  TLS1_TXT_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = 'ECDHE-RSA-AES128-GCM-SHA256';
  TLS1_TXT_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = 'ECDHE-RSA-AES256-GCM-SHA384';
  TLS1_TXT_ECDH_RSA_WITH_AES_128_GCM_SHA256 = 'ECDH-RSA-AES128-GCM-SHA256';
  TLS1_TXT_ECDH_RSA_WITH_AES_256_GCM_SHA384 = 'ECDH-RSA-AES256-GCM-SHA384';
  TLS1_TXT_ECDHE_PSK_WITH_RC4_128_SHA = 'ECDHE-PSK-RC4-SHA';
  TLS1_TXT_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA = 'ECDHE-PSK-3DES-EDE-CBC-SHA';
  TLS1_TXT_ECDHE_PSK_WITH_AES_128_CBC_SHA = 'ECDHE-PSK-AES128-CBC-SHA';
  TLS1_TXT_ECDHE_PSK_WITH_AES_256_CBC_SHA = 'ECDHE-PSK-AES256-CBC-SHA';
  TLS1_TXT_ECDHE_PSK_WITH_AES_128_CBC_SHA256 = 'ECDHE-PSK-AES128-CBC-SHA256';
  TLS1_TXT_ECDHE_PSK_WITH_AES_256_CBC_SHA384 = 'ECDHE-PSK-AES256-CBC-SHA384';
  TLS1_TXT_ECDHE_PSK_WITH_NULL_SHA = 'ECDHE-PSK-NULL-SHA';
  TLS1_TXT_ECDHE_PSK_WITH_NULL_SHA256 = 'ECDHE-PSK-NULL-SHA256';
  TLS1_TXT_ECDHE_PSK_WITH_NULL_SHA384 = 'ECDHE-PSK-NULL-SHA384';
  TLS1_TXT_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = 'ECDHE-ECDSA-CAMELLIA128-SHA256';
  TLS1_TXT_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = 'ECDHE-ECDSA-CAMELLIA256-SHA384';
  TLS1_TXT_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = 'ECDH-ECDSA-CAMELLIA128-SHA256';
  TLS1_TXT_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = 'ECDH-ECDSA-CAMELLIA256-SHA384';
  TLS1_TXT_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 'ECDHE-RSA-CAMELLIA128-SHA256';
  TLS1_TXT_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384 = 'ECDHE-RSA-CAMELLIA256-SHA384';
  TLS1_TXT_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 'ECDH-RSA-CAMELLIA128-SHA256';
  TLS1_TXT_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384 = 'ECDH-RSA-CAMELLIA256-SHA384';
  TLS1_TXT_ECDHE_RSA_WITH_CHACHA20_POLY1305 = 'ECDHE-RSA-CHACHA20-POLY1305';
  TLS1_TXT_ECDHE_ECDSA_WITH_CHACHA20_POLY1305 = 'ECDHE-ECDSA-CHACHA20-POLY1305';
  TLS1_TXT_DHE_RSA_WITH_CHACHA20_POLY1305 = 'DHE-RSA-CHACHA20-POLY1305';
  TLS1_TXT_PSK_WITH_CHACHA20_POLY1305 = 'PSK-CHACHA20-POLY1305';
  TLS1_TXT_ECDHE_PSK_WITH_CHACHA20_POLY1305 = 'ECDHE-PSK-CHACHA20-POLY1305';
  TLS1_TXT_DHE_PSK_WITH_CHACHA20_POLY1305 = 'DHE-PSK-CHACHA20-POLY1305';
  TLS1_TXT_RSA_PSK_WITH_CHACHA20_POLY1305 = 'RSA-PSK-CHACHA20-POLY1305';
  TLS1_TXT_RSA_WITH_ARIA_128_GCM_SHA256 = 'ARIA128-GCM-SHA256';
  TLS1_TXT_RSA_WITH_ARIA_256_GCM_SHA384 = 'ARIA256-GCM-SHA384';
  TLS1_TXT_DHE_RSA_WITH_ARIA_128_GCM_SHA256 = 'DHE-RSA-ARIA128-GCM-SHA256';
  TLS1_TXT_DHE_RSA_WITH_ARIA_256_GCM_SHA384 = 'DHE-RSA-ARIA256-GCM-SHA384';
  TLS1_TXT_DH_RSA_WITH_ARIA_128_GCM_SHA256 = 'DH-RSA-ARIA128-GCM-SHA256';
  TLS1_TXT_DH_RSA_WITH_ARIA_256_GCM_SHA384 = 'DH-RSA-ARIA256-GCM-SHA384';
  TLS1_TXT_DHE_DSS_WITH_ARIA_128_GCM_SHA256 = 'DHE-DSS-ARIA128-GCM-SHA256';
  TLS1_TXT_DHE_DSS_WITH_ARIA_256_GCM_SHA384 = 'DHE-DSS-ARIA256-GCM-SHA384';
  TLS1_TXT_DH_DSS_WITH_ARIA_128_GCM_SHA256 = 'DH-DSS-ARIA128-GCM-SHA256';
  TLS1_TXT_DH_DSS_WITH_ARIA_256_GCM_SHA384 = 'DH-DSS-ARIA256-GCM-SHA384';
  TLS1_TXT_DH_anon_WITH_ARIA_128_GCM_SHA256 = 'ADH-ARIA128-GCM-SHA256';
  TLS1_TXT_DH_anon_WITH_ARIA_256_GCM_SHA384 = 'ADH-ARIA256-GCM-SHA384';
  TLS1_TXT_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256 = 'ECDHE-ECDSA-ARIA128-GCM-SHA256';
  TLS1_TXT_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384 = 'ECDHE-ECDSA-ARIA256-GCM-SHA384';
  TLS1_TXT_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256 = 'ECDH-ECDSA-ARIA128-GCM-SHA256';
  TLS1_TXT_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384 = 'ECDH-ECDSA-ARIA256-GCM-SHA384';
  TLS1_TXT_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256 = 'ECDHE-ARIA128-GCM-SHA256';
  TLS1_TXT_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384 = 'ECDHE-ARIA256-GCM-SHA384';
  TLS1_TXT_ECDH_RSA_WITH_ARIA_128_GCM_SHA256 = 'ECDH-ARIA128-GCM-SHA256';
  TLS1_TXT_ECDH_RSA_WITH_ARIA_256_GCM_SHA384 = 'ECDH-ARIA256-GCM-SHA384';
  TLS1_TXT_PSK_WITH_ARIA_128_GCM_SHA256 = 'PSK-ARIA128-GCM-SHA256';
  TLS1_TXT_PSK_WITH_ARIA_256_GCM_SHA384 = 'PSK-ARIA256-GCM-SHA384';
  TLS1_TXT_DHE_PSK_WITH_ARIA_128_GCM_SHA256 = 'DHE-PSK-ARIA128-GCM-SHA256';
  TLS1_TXT_DHE_PSK_WITH_ARIA_256_GCM_SHA384 = 'DHE-PSK-ARIA256-GCM-SHA384';
  TLS1_TXT_RSA_PSK_WITH_ARIA_128_GCM_SHA256 = 'RSA-PSK-ARIA128-GCM-SHA256';
  TLS1_TXT_RSA_PSK_WITH_ARIA_256_GCM_SHA384 = 'RSA-PSK-ARIA256-GCM-SHA384';
  
  TLS_CT_RSA_SIGN = 1;
  TLS_CT_DSS_SIGN = 2;
  TLS_CT_RSA_FIXED_DH = 3;
  TLS_CT_DSS_FIXED_DH = 4;
  TLS_CT_ECDSA_SIGN = 64;
  TLS_CT_RSA_FIXED_ECDH = 65;
  TLS_CT_ECDSA_FIXED_ECDH = 66;
  TLS_CT_GOST01_SIGN = 22;
  TLS_CT_GOST12_SIGN = 238;
  TLS_CT_GOST12_512_SIGN = 239;
  TLS_CT_NUMBER = 10;
  TLS1_FINISH_MAC_LENGTH = 12;
  
  TLS_MD_MAX_CONST_SIZE = 22;
  TLS_MD_CLIENT_FINISH_CONST = 'client finished';
  TLS_MD_CLIENT_FINISH_CONST_SIZE = 15;
  TLS_MD_SERVER_FINISH_CONST = 'server finished';
  TLS_MD_SERVER_FINISH_CONST_SIZE = 15;
  TLS_MD_KEY_EXPANSION_CONST = 'key expansion';
  TLS_MD_KEY_EXPANSION_CONST_SIZE = 13;
  TLS_MD_CLIENT_WRITE_KEY_CONST = 'client write key';
  TLS_MD_CLIENT_WRITE_KEY_CONST_SIZE = 16;
  TLS_MD_SERVER_WRITE_KEY_CONST = 'server write key';
  TLS_MD_SERVER_WRITE_KEY_CONST_SIZE = 16;
  TLS_MD_IV_BLOCK_CONST = 'IV block';
  TLS_MD_IV_BLOCK_CONST_SIZE = 8;
  TLS_MD_MASTER_SECRET_CONST = 'master secret';
  TLS_MD_MASTER_SECRET_CONST_SIZE = 13;
  TLS_MD_EXTENDED_MASTER_SECRET_CONST = 'extended master secret';
  TLS_MD_EXTENDED_MASTER_SECRET_CONST_SIZE = 22;
  
  SSL_KEY_UPDATE_NONE = -1;
  SSL_KEY_UPDATE_NOT_REQUESTED = 0;
  SSL_KEY_UPDATE_REQUESTED = 1;
  
  SSL_ST_CONNECT = $1000;
  SSL_ST_ACCEPT = $2000;
  SSL_ST_MASK = $0FFF;
  
  SSL_CB_LOOP = $01;
  SSL_CB_EXIT = $02;
  SSL_CB_READ = $04;
  SSL_CB_WRITE = $08;
  SSL_CB_ALERT = $4000;
  SSL_CB_READ_ALERT = SSL_CB_ALERT or SSL_CB_READ;
  SSL_CB_WRITE_ALERT = SSL_CB_ALERT or SSL_CB_WRITE;
  SSL_CB_ACCEPT_LOOP = SSL_ST_ACCEPT or SSL_CB_LOOP;
  SSL_CB_ACCEPT_EXIT = SSL_ST_ACCEPT or SSL_CB_EXIT;
  SSL_CB_CONNECT_LOOP = SSL_ST_CONNECT or SSL_CB_LOOP;
  SSL_CB_CONNECT_EXIT = SSL_ST_CONNECT or SSL_CB_EXIT;
  SSL_CB_HANDSHAKE_START = $10;
  SSL_CB_HANDSHAKE_DONE = $20;
  
  SSL_ST_READ_HEADER = $F0;
  SSL_ST_READ_BODY = $F1;
  SSL_ST_READ_DONE = $F2;
  
  SSL_AD_REASON_OFFSET = 1000;
  SSL_AD_CLOSE_NOTIFY = SSL3_AD_CLOSE_NOTIFY;
  SSL_AD_UNEXPECTED_MESSAGE = SSL3_AD_UNEXPECTED_MESSAGE;
  SSL_AD_BAD_RECORD_MAC = SSL3_AD_BAD_RECORD_MAC;
  SSL_AD_DECRYPTION_FAILED = TLS1_AD_DECRYPTION_FAILED;
  SSL_AD_RECORD_OVERFLOW = TLS1_AD_RECORD_OVERFLOW;
  SSL_AD_DECOMPRESSION_FAILURE = SSL3_AD_DECOMPRESSION_FAILURE;
  SSL_AD_HANDSHAKE_FAILURE = SSL3_AD_HANDSHAKE_FAILURE;
  SSL_AD_NO_CERTIFICATE = SSL3_AD_NO_CERTIFICATE;
  SSL_AD_BAD_CERTIFICATE = SSL3_AD_BAD_CERTIFICATE;
  SSL_AD_UNSUPPORTED_CERTIFICATE = SSL3_AD_UNSUPPORTED_CERTIFICATE;
  SSL_AD_CERTIFICATE_REVOKED = SSL3_AD_CERTIFICATE_REVOKED;
  SSL_AD_CERTIFICATE_EXPIRED = SSL3_AD_CERTIFICATE_EXPIRED;
  SSL_AD_CERTIFICATE_UNKNOWN = SSL3_AD_CERTIFICATE_UNKNOWN;
  SSL_AD_ILLEGAL_PARAMETER = SSL3_AD_ILLEGAL_PARAMETER;
  SSL_AD_UNKNOWN_CA = TLS1_AD_UNKNOWN_CA;
  SSL_AD_ACCESS_DENIED = TLS1_AD_ACCESS_DENIED;
  SSL_AD_DECODE_ERROR = TLS1_AD_DECODE_ERROR;
  SSL_AD_DECRYPT_ERROR = TLS1_AD_DECRYPT_ERROR;
  SSL_AD_EXPORT_RESTRICTION = TLS1_AD_EXPORT_RESTRICTION;
  SSL_AD_PROTOCOL_VERSION = TLS1_AD_PROTOCOL_VERSION;
  SSL_AD_INSUFFICIENT_SECURITY = TLS1_AD_INSUFFICIENT_SECURITY;
  SSL_AD_INTERNAL_ERROR = TLS1_AD_INTERNAL_ERROR;
  SSL_AD_USER_CANCELLED = TLS1_AD_USER_CANCELLED;
  SSL_AD_NO_RENEGOTIATION = TLS1_AD_NO_RENEGOTIATION;
  SSL_AD_MISSING_EXTENSION = TLS13_AD_MISSING_EXTENSION;
  SSL_AD_CERTIFICATE_REQUIRED = TLS13_AD_CERTIFICATE_REQUIRED;
  SSL_AD_UNSUPPORTED_EXTENSION = TLS1_AD_UNSUPPORTED_EXTENSION;
  SSL_AD_CERTIFICATE_UNOBTAINABLE = TLS1_AD_CERTIFICATE_UNOBTAINABLE;
  SSL_AD_UNRECOGNIZED_NAME = TLS1_AD_UNRECOGNIZED_NAME;
  SSL_AD_BAD_CERTIFICATE_STATUS_RESPONSE = TLS1_AD_BAD_CERTIFICATE_STATUS_RESPONSE;
  SSL_AD_BAD_CERTIFICATE_HASH_VALUE = TLS1_AD_BAD_CERTIFICATE_HASH_VALUE;
  SSL_AD_UNKNOWN_PSK_IDENTITY = TLS1_AD_UNKNOWN_PSK_IDENTITY;
  SSL_AD_INAPPROPRIATE_FALLBACK = TLS1_AD_INAPPROPRIATE_FALLBACK;
  SSL_AD_NO_APPLICATION_PROTOCOL = TLS1_AD_NO_APPLICATION_PROTOCOL;
  
  SSL_CTRL_GET_RI_SUPPORT = 76;
  SSL_CTRL_CLEAR_MODE = 78;
  SSL_CTRL_SET_NOT_RESUMABLE_SESS_CB = 79;
  SSL_CTRL_GET_EXTRA_CHAIN_CERTS = 82;
  SSL_CTRL_CLEAR_EXTRA_CHAIN_CERTS = 83;
  SSL_CTRL_CHAIN = 88;
  SSL_CTRL_CHAIN_CERT = 89;
  SSL_CTRL_GET_GROUPS = 90;
  SSL_CTRL_SET_GROUPS = 91;
  SSL_CTRL_SET_GROUPS_LIST = 92;
  SSL_CTRL_GET_SHARED_GROUP = 93;
  SSL_CTRL_SET_SIGALGS = 97;
  SSL_CTRL_SET_SIGALGS_LIST = 98;
  SSL_CTRL_CERT_FLAGS = 99;
  SSL_CTRL_CLEAR_CERT_FLAGS = 100;
  SSL_CTRL_SET_CLIENT_SIGALGS = 101;
  SSL_CTRL_SET_CLIENT_SIGALGS_LIST = 102;
  SSL_CTRL_GET_CLIENT_CERT_TYPES = 103;
  SSL_CTRL_SET_CLIENT_CERT_TYPES = 104;
  SSL_CTRL_BUILD_CERT_CHAIN = 105;
  SSL_CTRL_SET_VERIFY_CERT_STORE = 106;
  SSL_CTRL_SET_CHAIN_CERT_STORE = 107;
  SSL_CTRL_GET_PEER_SIGNATURE_NID = 108;
  SSL_CTRL_GET_PEER_TMP_KEY = 109;
  SSL_CTRL_GET_RAW_CIPHERLIST = 110;
  SSL_CTRL_GET_EC_POINT_FORMATS = 111;
  SSL_CTRL_GET_CHAIN_CERTS = 115;
  SSL_CTRL_SELECT_CURRENT_CERT = 116;
  SSL_CTRL_SET_CURRENT_CERT = 117;
  SSL_CTRL_SET_DH_AUTO = 118;
  DTLS_CTRL_SET_LINK_MTU = 120;
  DTLS_CTRL_GET_LINK_MIN_MTU = 121;
  SSL_CTRL_GET_EXTMS_SUPPORT = 122;
  SSL_CTRL_SET_SPLIT_SEND_FRAGMENT = 125;
  SSL_CTRL_SET_MAX_PIPELINES = 126;
  SSL_CTRL_GET_TLSEXT_STATUS_REQ_TYPE = 127;
  SSL_CTRL_GET_TLSEXT_STATUS_REQ_CB = 128;
  SSL_CTRL_GET_TLSEXT_STATUS_REQ_CB_ARG = 129;
  SSL_CTRL_GET_MIN_PROTO_VERSION = 130;
  SSL_CTRL_GET_MAX_PROTO_VERSION = 131;
  SSL_CTRL_GET_SIGNATURE_NID = 132;
  SSL_CTRL_GET_TMP_KEY = 133;
  
  SSL_CERT_SET_FIRST = 1;
  SSL_CERT_SET_NEXT = 2;
  SSL_CERT_SET_SERVER = 3;
  
  SSL_CTRL_GET_SERVER_TMP_KEY = SSL_CTRL_GET_PEER_TMP_KEY;
  SSL_CTRL_GET_CURVES = SSL_CTRL_GET_GROUPS;
  SSL_CTRL_SET_CURVES = SSL_CTRL_SET_GROUPS;
  SSL_CTRL_SET_CURVES_LIST = SSL_CTRL_SET_GROUPS_LIST;
  SSL_CTRL_GET_SHARED_CURVE = SSL_CTRL_GET_SHARED_GROUP;
  
  SSL_SERVERINFOV1 = 1;
  SSL_SERVERINFOV2 = 2;
  
  SSL_CLIENT_HELLO_SUCCESS = 1;
  SSL_CLIENT_HELLO_ERROR = 0;
  SSL_CLIENT_HELLO_RETRY = -1;
  
  SSL_READ_EARLY_DATA_ERROR = 0;
  SSL_READ_EARLY_DATA_SUCCESS = 1;
  SSL_READ_EARLY_DATA_FINISH = 2;
  
  SSL_EARLY_DATA_NOT_SENT = 0;
  SSL_EARLY_DATA_REJECTED = 1;
  SSL_EARLY_DATA_ACCEPTED = 2;
  
  SSL_SECOP_OTHER_TYPE = $ffff0000;
  SSL_SECOP_OTHER_NONE = 0;
  SSL_SECOP_OTHER_CIPHER = 1 shl 16;
  SSL_SECOP_OTHER_CURVE = 2 shl 16;
  SSL_SECOP_OTHER_DH = 3 shl 16;
  SSL_SECOP_OTHER_PKEY = 4 shl 16;
  SSL_SECOP_OTHER_SIGALG = 5 shl 16;
  SSL_SECOP_OTHER_CERT = 6 shl 16;
  SSL_SECOP_PEER = $1000;
  
  SSL_SECOP_CIPHER_SUPPORTED = 1 or SSL_SECOP_OTHER_CIPHER;
  SSL_SECOP_CIPHER_SHARED = 2 or SSL_SECOP_OTHER_CIPHER;
  SSL_SECOP_CIPHER_CHECK = 3 or SSL_SECOP_OTHER_CIPHER;
  SSL_SECOP_CURVE_SUPPORTED = 4 or SSL_SECOP_OTHER_CURVE;
  SSL_SECOP_CURVE_SHARED = 5 or SSL_SECOP_OTHER_CURVE;
  SSL_SECOP_CURVE_CHECK = 6 or SSL_SECOP_OTHER_CURVE;
  SSL_SECOP_TMP_DH = 7 or SSL_SECOP_OTHER_PKEY;
  SSL_SECOP_VERSION = 9 or SSL_SECOP_OTHER_NONE;
  SSL_SECOP_TICKET = 10 or SSL_SECOP_OTHER_NONE;
  SSL_SECOP_SIGALG_SUPPORTED = 11 or SSL_SECOP_OTHER_SIGALG;
  SSL_SECOP_SIGALG_SHARED = 12 or SSL_SECOP_OTHER_SIGALG;
  SSL_SECOP_SIGALG_CHECK = 13 or SSL_SECOP_OTHER_SIGALG;
  SSL_SECOP_SIGALG_MASK = 14 or SSL_SECOP_OTHER_SIGALG;
  SSL_SECOP_COMPRESSION = 15 or SSL_SECOP_OTHER_NONE;
  SSL_SECOP_EE_KEY = 16 or SSL_SECOP_OTHER_CERT;
  SSL_SECOP_CA_KEY = 17 or SSL_SECOP_OTHER_CERT;
  SSL_SECOP_CA_MD = 18 or SSL_SECOP_OTHER_CERT;
  SSL_SECOP_PEER_EE_KEY = SSL_SECOP_EE_KEY or SSL_SECOP_PEER;
  SSL_SECOP_PEER_CA_KEY = SSL_SECOP_CA_KEY or SSL_SECOP_PEER;
  SSL_SECOP_PEER_CA_MD = SSL_SECOP_CA_MD or SSL_SECOP_PEER;
  
  OPENSSL_INIT_NO_LOAD_SSL_STRINGS = $00100000;
  OPENSSL_INIT_LOAD_SSL_STRINGS = $00200000;
  OPENSSL_INIT_SSL_DEFAULT = OPENSSL_INIT_LOAD_SSL_STRINGS or OPENSSL_INIT_LOAD_CRYPTO_STRINGS;
  
  SSL_TICKET_FATAL_ERR_MALLOC = 0;
  SSL_TICKET_FATAL_ERR_OTHER = 1;
  SSL_TICKET_NONE = 2;
  SSL_TICKET_EMPTY = 3;
  SSL_TICKET_NO_DECRYPT = 4;
  SSL_TICKET_SUCCESS = 5;
  SSL_TICKET_SUCCESS_RENEW = 6;
  SSL_TICKET_RETURN_ABORT = 0;
  SSL_TICKET_RETURN_IGNORE = 1;
  SSL_TICKET_RETURN_IGNORE_RENEW = 2;
  SSL_TICKET_RETURN_USE = 3;
  SSL_TICKET_RETURN_USE_RENEW = 4;
  SRTP_AES128_CM_SHA1_80 = $0001;
  SRTP_AES128_CM_SHA1_32 = $0002;
  SRTP_AES128_F8_SHA1_80 = $0003;
  SRTP_AES128_F8_SHA1_32 = $0004;
  SRTP_NULL_SHA1_80 = $0005;
  SRTP_NULL_SHA1_32 = $0006;
  SRTP_AEAD_AES_128_GCM = $0007;
  SRTP_AEAD_AES_256_GCM = $0008;
  OSSL_STORE_F_FILE_CTRL = 129;
  OSSL_STORE_F_FILE_FIND = 138;
  OSSL_STORE_F_FILE_GET_PASS = 118;
  OSSL_STORE_F_FILE_LOAD = 119;
  OSSL_STORE_F_FILE_LOAD_TRY_DECODE = 124;
  OSSL_STORE_F_FILE_NAME_TO_URI = 126;
  OSSL_STORE_F_FILE_OPEN = 120;
  OSSL_STORE_F_OSSL_STORE_ATTACH_PEM_BIO = 127;
  OSSL_STORE_F_OSSL_STORE_EXPECT = 130;
  OSSL_STORE_F_OSSL_STORE_FILE_ATTACH_PEM_BIO_INT = 128;
  OSSL_STORE_F_OSSL_STORE_FIND = 131;
  OSSL_STORE_F_OSSL_STORE_GET0_LOADER_INT = 100;
  OSSL_STORE_F_OSSL_STORE_INFO_GET1_CERT = 101;
  OSSL_STORE_F_OSSL_STORE_INFO_GET1_CRL = 102;
  OSSL_STORE_F_OSSL_STORE_INFO_GET1_NAME = 103;
  OSSL_STORE_F_OSSL_STORE_INFO_GET1_NAME_DESCRIPTION = 135;
  OSSL_STORE_F_OSSL_STORE_INFO_GET1_PARAMS = 104;
  OSSL_STORE_F_OSSL_STORE_INFO_GET1_PKEY = 105;
  OSSL_STORE_F_OSSL_STORE_INFO_NEW_CERT = 106;
  OSSL_STORE_F_OSSL_STORE_INFO_NEW_CRL = 107;
  OSSL_STORE_F_OSSL_STORE_INFO_NEW_EMBEDDED = 123;
  OSSL_STORE_F_OSSL_STORE_INFO_NEW_NAME = 109;
  OSSL_STORE_F_OSSL_STORE_INFO_NEW_PARAMS = 110;
  OSSL_STORE_F_OSSL_STORE_INFO_NEW_PKEY = 111;
  OSSL_STORE_F_OSSL_STORE_INFO_SET0_NAME_DESCRIPTION = 134;
  OSSL_STORE_F_OSSL_STORE_INIT_ONCE = 112;
  OSSL_STORE_F_OSSL_STORE_LOADER_NEW = 113;
  OSSL_STORE_F_OSSL_STORE_OPEN = 114;
  OSSL_STORE_F_OSSL_STORE_OPEN_INT = 115;
  OSSL_STORE_F_OSSL_STORE_REGISTER_LOADER_INT = 117;
  OSSL_STORE_F_OSSL_STORE_SEARCH_BY_ALIAS = 132;
  OSSL_STORE_F_OSSL_STORE_SEARCH_BY_ISSUER_SERIAL = 133;
  OSSL_STORE_F_OSSL_STORE_SEARCH_BY_KEY_FINGERPRINT = 136;
  OSSL_STORE_F_OSSL_STORE_SEARCH_BY_NAME = 137;
  OSSL_STORE_F_OSSL_STORE_UNREGISTER_LOADER_INT = 116;
  OSSL_STORE_F_TRY_DECODE_PARAMS = 121;
  OSSL_STORE_F_TRY_DECODE_PKCS12 = 122;
  OSSL_STORE_F_TRY_DECODE_PKCS8ENCRYPTED = 125;
  
  OSSL_STORE_R_AMBIGUOUS_CONTENT_TYPE = 107;
  OSSL_STORE_R_BAD_PASSWORD_READ = 115;
  OSSL_STORE_R_ERROR_VERIFYING_PKCS12_MAC = 113;
  OSSL_STORE_R_FINGERPRINT_SIZE_DOES_NOT_MATCH_DIGEST = 121;
  OSSL_STORE_R_INVALID_SCHEME = 106;
  OSSL_STORE_R_IS_NOT_A = 112;
  OSSL_STORE_R_LOADER_INCOMPLETE = 116;
  OSSL_STORE_R_LOADING_STARTED = 117;
  OSSL_STORE_R_NOT_A_CERTIFICATE = 100;
  OSSL_STORE_R_NOT_A_CRL = 101;
  OSSL_STORE_R_NOT_A_KEY = 102;
  OSSL_STORE_R_NOT_A_NAME = 103;
  OSSL_STORE_R_NOT_PARAMETERS = 104;
  OSSL_STORE_R_PASSPHRASE_CALLBACK_ERROR = 114;
  OSSL_STORE_R_PATH_MUST_BE_ABSOLUTE = 108;
  OSSL_STORE_R_SEARCH_ONLY_SUPPORTED_FOR_DIRECTORIES = 119;
  OSSL_STORE_R_UI_PROCESS_INTERRUPTED_OR_CANCELLED = 109;
  OSSL_STORE_R_UNREGISTERED_SCHEME = 105;
  OSSL_STORE_R_UNSUPPORTED_CONTENT_TYPE = 110;
  OSSL_STORE_R_UNSUPPORTED_OPERATION = 118;
  OSSL_STORE_R_UNSUPPORTED_SEARCH_TYPE = 120;
  OSSL_STORE_R_URI_AUTHORITY_UNSUPPORTED = 111;
  
  OSSL_STORE_C_USE_SECMEM = 1;
  OSSL_STORE_C_CUSTOM_START = 100;
  
  OSSL_STORE_INFO_NAME = 1;
  OSSL_STORE_INFO_PARAMS = 2;
  OSSL_STORE_INFO_PKEY = 3;
  OSSL_STORE_INFO_CERT = 4;
  OSSL_STORE_INFO_CRL = 5;
  
  _OSSL_STORE_SEARCH_BY_NAME = 1;
  _OSSL_STORE_SEARCH_BY_ISSUER_SERIAL = 2;
  _OSSL_STORE_SEARCH_BY_KEY_FINGERPRINT = 3;
  _OSSL_STORE_SEARCH_BY_ALIAS = 4;
  
  TS_F_DEF_SERIAL_CB = 110;
  TS_F_DEF_TIME_CB = 111;
  TS_F_ESS_ADD_SIGNING_CERT = 112;
  TS_F_ESS_ADD_SIGNING_CERT_V2 = 147;
  TS_F_ESS_CERT_ID_NEW_INIT = 113;
  TS_F_ESS_CERT_ID_V2_NEW_INIT = 156;
  TS_F_ESS_SIGNING_CERT_NEW_INIT = 114;
  TS_F_ESS_SIGNING_CERT_V2_NEW_INIT = 157;
  TS_F_INT_TS_RESP_VERIFY_TOKEN = 149;
  TS_F_PKCS7_TO_TS_TST_INFO = 148;
  TS_F_TS_ACCURACY_SET_MICROS = 115;
  TS_F_TS_ACCURACY_SET_MILLIS = 116;
  TS_F_TS_ACCURACY_SET_SECONDS = 117;
  TS_F_TS_CHECK_IMPRINTS = 100;
  TS_F_TS_CHECK_NONCES = 101;
  TS_F_TS_CHECK_POLICY = 102;
  TS_F_TS_CHECK_SIGNING_CERTS = 103;
  TS_F_TS_CHECK_STATUS_INFO = 104;
  TS_F_TS_COMPUTE_IMPRINT = 145;
  TS_F_TS_CONF_INVALID = 151;
  TS_F_TS_CONF_LOAD_CERT = 153;
  TS_F_TS_CONF_LOAD_CERTS = 154;
  TS_F_TS_CONF_LOAD_KEY = 155;
  TS_F_TS_CONF_LOOKUP_FAIL = 152;
  TS_F_TS_CONF_SET_DEFAULT_ENGINE = 146;
  TS_F_TS_GET_STATUS_TEXT = 105;
  TS_F_TS_MSG_IMPRINT_SET_ALGO = 118;
  TS_F_TS_REQ_SET_MSG_IMPRINT = 119;
  TS_F_TS_REQ_SET_NONCE = 120;
  TS_F_TS_REQ_SET_POLICY_ID = 121;
  TS_F_TS_RESP_CREATE_RESPONSE = 122;
  TS_F_TS_RESP_CREATE_TST_INFO = 123;
  TS_F_TS_RESP_CTX_ADD_FAILURE_INFO = 124;
  TS_F_TS_RESP_CTX_ADD_MD = 125;
  TS_F_TS_RESP_CTX_ADD_POLICY = 126;
  TS_F_TS_RESP_CTX_NEW = 127;
  TS_F_TS_RESP_CTX_SET_ACCURACY = 128;
  TS_F_TS_RESP_CTX_SET_CERTS = 129;
  TS_F_TS_RESP_CTX_SET_DEF_POLICY = 130;
  TS_F_TS_RESP_CTX_SET_SIGNER_CERT = 131;
  TS_F_TS_RESP_CTX_SET_STATUS_INFO = 132;
  TS_F_TS_RESP_GET_POLICY = 133;
  TS_F_TS_RESP_SET_GENTIME_WITH_PRECISION = 134;
  TS_F_TS_RESP_SET_STATUS_INFO = 135;
  TS_F_TS_RESP_SET_TST_INFO = 150;
  TS_F_TS_RESP_SIGN = 136;
  TS_F_TS_RESP_VERIFY_SIGNATURE = 106;
  TS_F_TS_TST_INFO_SET_ACCURACY = 137;
  TS_F_TS_TST_INFO_SET_MSG_IMPRINT = 138;
  TS_F_TS_TST_INFO_SET_NONCE = 139;
  TS_F_TS_TST_INFO_SET_POLICY_ID = 140;
  TS_F_TS_TST_INFO_SET_SERIAL = 141;
  TS_F_TS_TST_INFO_SET_TIME = 142;
  TS_F_TS_TST_INFO_SET_TSA = 143;
  TS_F_TS_VERIFY = 108;
  TS_F_TS_VERIFY_CERT = 109;
  TS_F_TS_VERIFY_CTX_NEW = 144;
  
  TS_R_BAD_PKCS7_TYPE = 132;
  TS_R_BAD_TYPE = 133;
  TS_R_CANNOT_LOAD_CERT = 137;
  TS_R_CANNOT_LOAD_KEY = 138;
  TS_R_CERTIFICATE_VERIFY_ERROR = 100;
  TS_R_COULD_NOT_SET_ENGINE = 127;
  TS_R_COULD_NOT_SET_TIME = 115;
  TS_R_DETACHED_CONTENT = 134;
  TS_R_ESS_ADD_SIGNING_CERT_ERROR = 116;
  TS_R_ESS_ADD_SIGNING_CERT_V2_ERROR = 139;
  TS_R_ESS_SIGNING_CERTIFICATE_ERROR = 101;
  TS_R_INVALID_NULL_POINTER = 102;
  TS_R_INVALID_SIGNER_CERTIFICATE_PURPOSE = 117;
  TS_R_MESSAGE_IMPRINT_MISMATCH = 103;
  TS_R_NONCE_MISMATCH = 104;
  TS_R_NONCE_NOT_RETURNED = 105;
  TS_R_NO_CONTENT = 106;
  TS_R_NO_TIME_STAMP_TOKEN = 107;
  TS_R_PKCS7_ADD_SIGNATURE_ERROR = 118;
  TS_R_PKCS7_ADD_SIGNED_ATTR_ERROR = 119;
  TS_R_PKCS7_TO_TS_TST_INFO_FAILED = 129;
  TS_R_POLICY_MISMATCH = 108;
  TS_R_PRIVATE_KEY_DOES_NOT_MATCH_CERTIFICATE = 120;
  TS_R_RESPONSE_SETUP_ERROR = 121;
  TS_R_SIGNATURE_FAILURE = 109;
  TS_R_THERE_MUST_BE_ONE_SIGNER = 110;
  TS_R_TIME_SYSCALL_ERROR = 122;
  TS_R_TOKEN_NOT_PRESENT = 130;
  TS_R_TOKEN_PRESENT = 131;
  TS_R_TSA_NAME_MISMATCH = 111;
  TS_R_TSA_UNTRUSTED = 112;
  TS_R_TST_INFO_SETUP_ERROR = 123;
  TS_R_TS_DATASIGN = 124;
  TS_R_UNACCEPTABLE_POLICY = 125;
  TS_R_UNSUPPORTED_MD_ALGORITHM = 126;
  TS_R_UNSUPPORTED_VERSION = 113;
  TS_R_VAR_BAD_VALUE = 135;
  TS_R_VAR_LOOKUP_FAILURE = 136;
  TS_R_WRONG_CONTENT_TYPE = 114;
  
  TS_STATUS_GRANTED = 0;
  TS_STATUS_GRANTED_WITH_MODS = 1;
  TS_STATUS_REJECTION = 2;
  TS_STATUS_WAITING = 3;
  TS_STATUS_REVOCATION_WARNING = 4;
  TS_STATUS_REVOCATION_NOTIFICATION = 5;
  
  TS_INFO_BAD_ALG = 0;
  TS_INFO_BAD_REQUEST = 2;
  TS_INFO_BAD_DATA_FORMAT = 5;
  TS_INFO_TIME_NOT_AVAILABLE = 14;
  TS_INFO_UNACCEPTED_POLICY = 15;
  TS_INFO_UNACCEPTED_EXTENSION = 16;
  TS_INFO_ADD_INFO_NOT_AVAILABLE = 17;
  TS_INFO_SYSTEM_FAILURE = 25;
  
  TS_TSA_NAME = $01;
  TS_ORDERING = $02;
  TS_ESS_CERT_ID_CHAIN = $04;
  
  TS_MAX_CLOCK_PRECISION_DIGITS = 6;
  TS_MAX_STATUS_LENGTH = 1024*1024;
  
  TS_VFY_SIGNATURE = 1 shl 0;
  TS_VFY_VERSION = 1 shl 1;
  TS_VFY_POLICY = 1 shl 2;
  TS_VFY_IMPRINT = 1 shl 3;
  TS_VFY_DATA = 1 shl 4;
  TS_VFY_NONCE = 1 shl 5;
  TS_VFY_SIGNER = 1 shl 6;
  TS_VFY_TSA_NAME = 1 shl 7;
  TS_VFY_ALL_IMPRINT = TS_VFY_SIGNATURE or TS_VFY_VERSION or TS_VFY_POLICY or TS_VFY_IMPRINT or TS_VFY_NONCE or TS_VFY_SIGNER or TS_VFY_TSA_NAME;
  TS_VFY_ALL_DATA = TS_VFY_SIGNATURE or TS_VFY_VERSION or TS_VFY_POLICY or TS_VFY_DATA or TS_VFY_NONCE or TS_VFY_SIGNER or TS_VFY_TSA_NAME;
  
  DB_ERROR_OK = 0;
  DB_ERROR_MALLOC = 1;
  DB_ERROR_INDEX_CLASH = 2;
  DB_ERROR_INDEX_OUT_OF_RANGE = 3;
  DB_ERROR_NO_INDEX = 4;
  DB_ERROR_INSERT_INDEX_CLASH = 5;
  DB_ERROR_WRONG_NUM_FIELDS = 6;
  WHIRLPOOL_DIGEST_LENGTH = 512 div 8;
  WHIRLPOOL_BBLOCK = 512;
  WHIRLPOOL_COUNTER = 256 div 8;


{ ******************** OpenSSL Library Types and Structures }

type
  Pstack_st = pointer;
  PPstack_st = ^Pstack_st;
  Pstack_st_OPENSSL_STRING = pointer;
  PPstack_st_OPENSSL_STRING = ^Pstack_st_OPENSSL_STRING;
  Pstack_st_OPENSSL_CSTRING = pointer;
  PPstack_st_OPENSSL_CSTRING = ^Pstack_st_OPENSSL_CSTRING;
  Pstack_st_OPENSSL_BLOCK = pointer;
  PPstack_st_OPENSSL_BLOCK = ^Pstack_st_OPENSSL_BLOCK;
  Pasn1_object_st = pointer;
  PPasn1_object_st = ^Pasn1_object_st;
  Pasn1_pctx_st = pointer;
  PPasn1_pctx_st = ^Pasn1_pctx_st;
  Pasn1_sctx_st = pointer;
  PPasn1_sctx_st = ^Pasn1_sctx_st;
  Pdane_st = pointer;
  PPdane_st = ^Pdane_st;
  Pbio_st = pointer;
  PPbio_st = ^Pbio_st;
  Pbignum_st = pointer;
  PPbignum_st = ^Pbignum_st;
  Pbignum_ctx = pointer;
  PPbignum_ctx = ^Pbignum_ctx;
  Pbn_blinding_st = pointer;
  PPbn_blinding_st = ^Pbn_blinding_st;
  Pbn_mont_ctx_st = pointer;
  PPbn_mont_ctx_st = ^Pbn_mont_ctx_st;
  Pbn_recp_ctx_st = pointer;
  PPbn_recp_ctx_st = ^Pbn_recp_ctx_st;
  Pbn_gencb_st = pointer;
  PPbn_gencb_st = ^Pbn_gencb_st;
  Pevp_cipher_st = pointer;
  PPevp_cipher_st = ^Pevp_cipher_st;
  Pevp_cipher_ctx_st = pointer;
  PPevp_cipher_ctx_st = ^Pevp_cipher_ctx_st;
  Pevp_md_st = pointer;
  PPevp_md_st = ^Pevp_md_st;
  Pevp_md_ctx_st = pointer;
  PPevp_md_ctx_st = ^Pevp_md_ctx_st;
  Pevp_pkey_st = pointer;
  PPevp_pkey_st = ^Pevp_pkey_st;
  Pevp_pkey_asn1_method_st = pointer;
  PPevp_pkey_asn1_method_st = ^Pevp_pkey_asn1_method_st;
  Pevp_pkey_method_st = pointer;
  PPevp_pkey_method_st = ^Pevp_pkey_method_st;
  Pevp_pkey_ctx_st = pointer;
  PPevp_pkey_ctx_st = ^Pevp_pkey_ctx_st;
  Pevp_Encode_Ctx_st = pointer;
  PPevp_Encode_Ctx_st = ^Pevp_Encode_Ctx_st;
  Phmac_ctx_st = pointer;
  PPhmac_ctx_st = ^Phmac_ctx_st;
  Prsa_meth_st = pointer;
  PPrsa_meth_st = ^Prsa_meth_st;
  Pec_key_method_st = pointer;
  PPec_key_method_st = ^Pec_key_method_st;
  Prand_drbg_st = pointer;
  PPrand_drbg_st = ^Prand_drbg_st;
  Pssl_dane_st = pointer;
  PPssl_dane_st = ^Pssl_dane_st;
  Px509_st = pointer;
  PPx509_st = ^Px509_st;
  PX509_crl_st = pointer;
  PPX509_crl_st = ^PX509_crl_st;
  Px509_crl_method_st = pointer;
  PPx509_crl_method_st = ^Px509_crl_method_st;
  Px509_revoked_st = pointer;
  PPx509_revoked_st = ^Px509_revoked_st;
  PX509_name_st = pointer;
  PPX509_name_st = ^PX509_name_st;
  PX509_pubkey_st = pointer;
  PPX509_pubkey_st = ^PX509_pubkey_st;
  Px509_store_st = pointer;
  PPx509_store_st = ^Px509_store_st;
  Px509_store_ctx_st = pointer;
  PPx509_store_ctx_st = ^Px509_store_ctx_st;
  Px509_object_st = pointer;
  PPx509_object_st = ^Px509_object_st;
  Px509_lookup_st = pointer;
  PPx509_lookup_st = ^Px509_lookup_st;
  Px509_lookup_method_st = pointer;
  PPx509_lookup_method_st = ^Px509_lookup_method_st;
  PX509_VERIFY_PARAM_st = pointer;
  PPX509_VERIFY_PARAM_st = ^PX509_VERIFY_PARAM_st;
  Px509_sig_info_st = pointer;
  PPx509_sig_info_st = ^Px509_sig_info_st;
  Ppkcs8_priv_key_info_st = pointer;
  PPpkcs8_priv_key_info_st = ^Ppkcs8_priv_key_info_st;
  Possl_init_settings_st = pointer;
  PPossl_init_settings_st = ^Possl_init_settings_st;
  Pui_st = pointer;
  PPui_st = ^Pui_st;
  Pui_method_st = pointer;
  PPui_method_st = ^Pui_method_st;
  Pengine_st = pointer;
  PPengine_st = ^Pengine_st;
  Pssl_st = pointer;
  PPssl_st = ^Pssl_st;
  Pssl_ctx_st = pointer;
  PPssl_ctx_st = ^Pssl_ctx_st;
  Pcomp_ctx_st = pointer;
  PPcomp_ctx_st = ^Pcomp_ctx_st;
  Pcomp_method_st = pointer;
  PPcomp_method_st = ^Pcomp_method_st;
  PX509_POLICY_NODE_st = pointer;
  PPX509_POLICY_NODE_st = ^PX509_POLICY_NODE_st;
  PX509_POLICY_LEVEL_st = pointer;
  PPX509_POLICY_LEVEL_st = ^PX509_POLICY_LEVEL_st;
  PX509_POLICY_TREE_st = pointer;
  PPX509_POLICY_TREE_st = ^PX509_POLICY_TREE_st;
  PX509_POLICY_CACHE_st = pointer;
  PPX509_POLICY_CACHE_st = ^PX509_POLICY_CACHE_st;
  Pocsp_req_ctx_st = pointer;
  PPocsp_req_ctx_st = ^Pocsp_req_ctx_st;
  Pocsp_response_st = pointer;
  PPocsp_response_st = ^Pocsp_response_st;
  Pocsp_responder_id_st = pointer;
  PPocsp_responder_id_st = ^Pocsp_responder_id_st;
  Psct_st = pointer;
  PPsct_st = ^Psct_st;
  Psct_ctx_st = pointer;
  PPsct_ctx_st = ^Psct_ctx_st;
  Pctlog_st = pointer;
  PPctlog_st = ^Pctlog_st;
  Pctlog_store_st = pointer;
  PPctlog_store_st = ^Pctlog_store_st;
  Pct_policy_eval_ctx_st = pointer;
  PPct_policy_eval_ctx_st = ^Pct_policy_eval_ctx_st;
  Possl_store_info_st = pointer;
  PPossl_store_info_st = ^Possl_store_info_st;
  Possl_store_search_st = pointer;
  PPossl_store_search_st = ^Possl_store_search_st;
  PPstack_st_void = ^Pstack_st_void;
  Pbio_addrinfo_st = pointer;
  PPbio_addrinfo_st = ^Pbio_addrinfo_st;
  Pbio_method_st = pointer;
  PPbio_method_st = ^Pbio_method_st;
  Pstack_st_BIO = pointer;
  PPstack_st_BIO = ^Pstack_st_BIO;
  Phostent = pointer;
  PPhostent = ^Phostent;
  Pstack_st_X509_ALGOR = pointer;
  PPstack_st_X509_ALGOR = ^Pstack_st_X509_ALGOR;
  Pstack_st_ASN1_STRING_TABLE = pointer;
  PPstack_st_ASN1_STRING_TABLE = ^Pstack_st_ASN1_STRING_TABLE;
  PASN1_VALUE_st = pointer;
  PPASN1_VALUE_st = ^PASN1_VALUE_st;
  Pstack_st_ASN1_INTEGER = pointer;
  PPstack_st_ASN1_INTEGER = ^Pstack_st_ASN1_INTEGER;
  Pstack_st_ASN1_GENERALSTRING = pointer;
  PPstack_st_ASN1_GENERALSTRING = ^Pstack_st_ASN1_GENERALSTRING;
  Pstack_st_ASN1_UTF8STRING = pointer;
  PPstack_st_ASN1_UTF8STRING = ^Pstack_st_ASN1_UTF8STRING;
  Pstack_st_ASN1_TYPE = pointer;
  PPstack_st_ASN1_TYPE = ^Pstack_st_ASN1_TYPE;
  Pstack_st_ASN1_OBJECT = pointer;
  PPstack_st_ASN1_OBJECT = ^Pstack_st_ASN1_OBJECT;
  Pstack_st_ASN1_VALUE = pointer;
  PPstack_st_ASN1_VALUE = ^Pstack_st_ASN1_VALUE;
  Pasync_job_st = pointer;
  PPasync_job_st = ^Pasync_job_st;
  Pasync_wait_ctx_st = pointer;
  PPasync_wait_ctx_st = ^Pasync_wait_ctx_st;
  Pdsa_st = pointer;
  PPdsa_st = ^Pdsa_st;
  Pdh_st = pointer;
  PPdh_st = ^Pdh_st;
  Pec_key_st = pointer;
  PPec_key_st = ^Pec_key_st;
  PCMAC_CTX_st = pointer;
  PPCMAC_CTX_st = ^PCMAC_CTX_st;
  Pec_method_st = pointer;
  PPec_method_st = ^Pec_method_st;
  Pec_group_st = pointer;
  PPec_group_st = ^Pec_group_st;
  Pec_point_st = pointer;
  PPec_point_st = ^Pec_point_st;
  Pecpk_parameters_st = pointer;
  PPecpk_parameters_st = ^Pecpk_parameters_st;
  Pec_parameters_st = pointer;
  PPec_parameters_st = ^Pec_parameters_st;
  PECDSA_SIG_st = pointer;
  PPECDSA_SIG_st = ^PECDSA_SIG_st;
  PDSA_SIG_st = pointer;
  PPDSA_SIG_st = ^PDSA_SIG_st;
  PX509_sig_st = pointer;
  PPX509_sig_st = ^PX509_sig_st;
  PX509_name_entry_st = pointer;
  PPX509_name_entry_st = ^PX509_name_entry_st;
  Pstack_st_X509_NAME_ENTRY = pointer;
  PPstack_st_X509_NAME_ENTRY = ^Pstack_st_X509_NAME_ENTRY;
  Pstack_st_X509_NAME = pointer;
  PPstack_st_X509_NAME = ^Pstack_st_X509_NAME;
  PX509_extension_st = pointer;
  PPX509_extension_st = ^PX509_extension_st;
  Px509_attributes_st = pointer;
  PPx509_attributes_st = ^Px509_attributes_st;
  Pstack_st_X509_ATTRIBUTE = pointer;
  PPstack_st_X509_ATTRIBUTE = ^Pstack_st_X509_ATTRIBUTE;
  PX509_req_info_st = pointer;
  PPX509_req_info_st = ^PX509_req_info_st;
  PX509_req_st = pointer;
  PPX509_req_st = ^PX509_req_st;
  Px509_cert_aux_st = pointer;
  PPx509_cert_aux_st = ^Px509_cert_aux_st;
  Px509_cinf_st = pointer;
  PPx509_cinf_st = ^Px509_cinf_st;
  Pstack_st_X509_TRUST = pointer;
  PPstack_st_X509_TRUST = ^Pstack_st_X509_TRUST;
  PX509_crl_info_st = pointer;
  PPX509_crl_info_st = ^PX509_crl_info_st;
  Pstack_st_X509_INFO = pointer;
  PPstack_st_X509_INFO = ^Pstack_st_X509_INFO;
  Plhash_node_st = pointer;
  PPlhash_node_st = ^Plhash_node_st;
  Plhash_st = pointer;
  PPlhash_st = ^Plhash_st;
  Pstack_st_X509_LOOKUP = pointer;
  PPstack_st_X509_LOOKUP = ^Pstack_st_X509_LOOKUP;
  Pstack_st_X509_VERIFY_PARAM = pointer;
  PPstack_st_X509_VERIFY_PARAM = ^Pstack_st_X509_VERIFY_PARAM;
  Pstack_st_PKCS7_SIGNER_INFO = pointer;
  PPstack_st_PKCS7_SIGNER_INFO = ^Pstack_st_PKCS7_SIGNER_INFO;
  Pstack_st_PKCS7_RECIP_INFO = pointer;
  PPstack_st_PKCS7_RECIP_INFO = ^Pstack_st_PKCS7_RECIP_INFO;
  Pstack_st_PKCS7 = pointer;
  PPstack_st_PKCS7 = ^Pstack_st_PKCS7;
  PPstack_st_CONF_VALUE = ^Pstack_st_CONF_VALUE;
  Pconf_imodule_st = pointer;
  PPconf_imodule_st = ^Pconf_imodule_st;
  Pconf_module_st = pointer;
  PPconf_module_st = ^Pconf_module_st;
  Pstack_st_CONF_MODULE = pointer;
  PPstack_st_CONF_MODULE = ^Pstack_st_CONF_MODULE;
  Pstack_st_CONF_IMODULE = pointer;
  PPstack_st_CONF_IMODULE = ^Pstack_st_CONF_IMODULE;
  Pstack_st_X509V3_EXT_METHOD = pointer;
  PPstack_st_X509V3_EXT_METHOD = ^Pstack_st_X509V3_EXT_METHOD;
  Pstack_st_GENERAL_NAME = pointer;
  PPstack_st_GENERAL_NAME = ^Pstack_st_GENERAL_NAME;
  Pstack_st_GENERAL_NAMES = pointer;
  PPstack_st_GENERAL_NAMES = ^Pstack_st_GENERAL_NAMES;
  Pstack_st_ACCESS_DESCRIPTION = pointer;
  PPstack_st_ACCESS_DESCRIPTION = ^Pstack_st_ACCESS_DESCRIPTION;
  Pstack_st_DIST_POINT = pointer;
  PPstack_st_DIST_POINT = ^Pstack_st_DIST_POINT;
  Pstack_st_SXNETID = pointer;
  PPstack_st_SXNETID = ^Pstack_st_SXNETID;
  Pstack_st_POLICYQUALINFO = pointer;
  PPstack_st_POLICYQUALINFO = ^Pstack_st_POLICYQUALINFO;
  Pstack_st_POLICYINFO = pointer;
  PPstack_st_POLICYINFO = ^Pstack_st_POLICYINFO;
  Pstack_st_POLICY_MAPPING = pointer;
  PPstack_st_POLICY_MAPPING = ^Pstack_st_POLICY_MAPPING;
  Pstack_st_GENERAL_SUBTREE = pointer;
  PPstack_st_GENERAL_SUBTREE = ^Pstack_st_GENERAL_SUBTREE;
  Pstack_st_X509_PURPOSE = pointer;
  PPstack_st_X509_PURPOSE = ^Pstack_st_X509_PURPOSE;
  Pstack_st_X509_POLICY_NODE = pointer;
  PPstack_st_X509_POLICY_NODE = ^Pstack_st_X509_POLICY_NODE;
  Pstack_st_ASIdOrRange = pointer;
  PPstack_st_ASIdOrRange = ^Pstack_st_ASIdOrRange;
  Pstack_st_IPAddressOrRange = pointer;
  PPstack_st_IPAddressOrRange = ^Pstack_st_IPAddressOrRange;
  Pstack_st_IPAddressFamily = pointer;
  PPstack_st_IPAddressFamily = ^Pstack_st_IPAddressFamily;
  Pstack_st_ASN1_STRING = pointer;
  PPstack_st_ASN1_STRING = ^Pstack_st_ASN1_STRING;
  PNamingAuthority_st = pointer;
  PPNamingAuthority_st = ^PNamingAuthority_st;
  PProfessionInfo_st = pointer;
  PPProfessionInfo_st = ^PProfessionInfo_st;
  PAdmissions_st = pointer;
  PPAdmissions_st = ^PAdmissions_st;
  PAdmissionSyntax_st = pointer;
  PPAdmissionSyntax_st = ^PAdmissionSyntax_st;
  Pstack_st_ADMISSIONS = pointer;
  PPstack_st_ADMISSIONS = ^Pstack_st_ADMISSIONS;
  Pstack_st_PROFESSION_INFO = pointer;
  PPstack_st_PROFESSION_INFO = ^Pstack_st_PROFESSION_INFO;
  PCMS_ContentInfo_st = pointer;
  PPCMS_ContentInfo_st = ^PCMS_ContentInfo_st;
  PCMS_SignerInfo_st = pointer;
  PPCMS_SignerInfo_st = ^PCMS_SignerInfo_st;
  PCMS_RevocationInfoChoice_st = pointer;
  PPCMS_RevocationInfoChoice_st = ^PCMS_RevocationInfoChoice_st;
  PCMS_RecipientInfo_st = pointer;
  PPCMS_RecipientInfo_st = ^PCMS_RecipientInfo_st;
  PCMS_ReceiptRequest_st = pointer;
  PPCMS_ReceiptRequest_st = ^PCMS_ReceiptRequest_st;
  PCMS_Receipt_st = pointer;
  PPCMS_Receipt_st = ^PCMS_Receipt_st;
  PCMS_RecipientEncryptedKey_st = pointer;
  PPCMS_RecipientEncryptedKey_st = ^PCMS_RecipientEncryptedKey_st;
  PCMS_OtherKeyAttribute_st = pointer;
  PPCMS_OtherKeyAttribute_st = ^PCMS_OtherKeyAttribute_st;
  Pstack_st_CMS_SignerInfo = pointer;
  PPstack_st_CMS_SignerInfo = ^Pstack_st_CMS_SignerInfo;
  Pstack_st_CMS_RecipientEncryptedKey = pointer;
  PPstack_st_CMS_RecipientEncryptedKey = ^Pstack_st_CMS_RecipientEncryptedKey;
  Pstack_st_CMS_RecipientInfo = pointer;
  PPstack_st_CMS_RecipientInfo = ^Pstack_st_CMS_RecipientInfo;
  Pstack_st_CMS_RevocationInfoChoice = pointer;
  PPstack_st_CMS_RevocationInfoChoice = ^Pstack_st_CMS_RevocationInfoChoice;
  Pstack_st_SCT = pointer;
  PPstack_st_SCT = ^Pstack_st_SCT;
  Pstack_st_CTLOG = pointer;
  PPstack_st_CTLOG = ^Pstack_st_CTLOG;
  Pui_string_st = pointer;
  PPui_string_st = ^Pui_string_st;
  Pstack_st_UI_STRING = pointer;
  PPstack_st_UI_STRING = ^Pstack_st_UI_STRING;
  Pocsp_cert_id_st = pointer;
  PPocsp_cert_id_st = ^Pocsp_cert_id_st;
  Pstack_st_OCSP_CERTID = pointer;
  PPstack_st_OCSP_CERTID = ^Pstack_st_OCSP_CERTID;
  Pocsp_one_request_st = pointer;
  PPocsp_one_request_st = ^Pocsp_one_request_st;
  Pstack_st_OCSP_ONEREQ = pointer;
  PPstack_st_OCSP_ONEREQ = ^Pstack_st_OCSP_ONEREQ;
  Pocsp_req_info_st = pointer;
  PPocsp_req_info_st = ^Pocsp_req_info_st;
  Pocsp_signature_st = pointer;
  PPocsp_signature_st = ^Pocsp_signature_st;
  Pocsp_request_st = pointer;
  PPocsp_request_st = ^Pocsp_request_st;
  Pocsp_resp_bytes_st = pointer;
  PPocsp_resp_bytes_st = ^Pocsp_resp_bytes_st;
  Pstack_st_OCSP_RESPID = pointer;
  PPstack_st_OCSP_RESPID = ^Pstack_st_OCSP_RESPID;
  Pocsp_revoked_info_st = pointer;
  PPocsp_revoked_info_st = ^Pocsp_revoked_info_st;
  Pocsp_cert_status_st = pointer;
  PPocsp_cert_status_st = ^Pocsp_cert_status_st;
  Pocsp_single_response_st = pointer;
  PPocsp_single_response_st = ^Pocsp_single_response_st;
  Pstack_st_OCSP_SINGLERESP = pointer;
  PPstack_st_OCSP_SINGLERESP = ^Pstack_st_OCSP_SINGLERESP;
  Pocsp_response_data_st = pointer;
  PPocsp_response_data_st = ^Pocsp_response_data_st;
  Pocsp_basic_response_st = pointer;
  PPocsp_basic_response_st = ^Pocsp_basic_response_st;
  Pocsp_crl_id_st = pointer;
  PPocsp_crl_id_st = ^Pocsp_crl_id_st;
  Pocsp_service_locator_st = pointer;
  PPocsp_service_locator_st = ^Pocsp_service_locator_st;
  PPKCS12_MAC_DATA_st = pointer;
  PPPKCS12_MAC_DATA_st = ^PPKCS12_MAC_DATA_st;
  PPKCS12_st = pointer;
  PPPKCS12_st = ^PPKCS12_st;
  PPKCS12_SAFEBAG_st = pointer;
  PPPKCS12_SAFEBAG_st = ^PPKCS12_SAFEBAG_st;
  Ppkcs12_bag_st = pointer;
  PPpkcs12_bag_st = ^Ppkcs12_bag_st;
  Pstack_st_SRP_gN_cache = pointer;
  PPstack_st_SRP_gN_cache = ^Pstack_st_SRP_gN_cache;
  Pstack_st_SRP_user_pwd = pointer;
  PPstack_st_SRP_user_pwd = ^Pstack_st_SRP_user_pwd;
  Pstack_st_SRP_gN = pointer;
  PPstack_st_SRP_gN = ^Pstack_st_SRP_gN;
  Pssl_method_st = pointer;
  PPssl_method_st = ^Pssl_method_st;
  Pssl_cipher_st = pointer;
  PPssl_cipher_st = ^Pssl_cipher_st;
  Pssl_session_st = pointer;
  PPssl_session_st = ^Pssl_session_st;
  Ptls_sigalgs_st = pointer;
  PPtls_sigalgs_st = ^Ptls_sigalgs_st;
  Pssl_conf_ctx_st = pointer;
  PPssl_conf_ctx_st = ^Pssl_conf_ctx_st;
  Pssl_comp_st = pointer;
  PPssl_comp_st = ^Pssl_comp_st;
  Pstack_st_SRTP_PROTECTION_PROFILE = pointer;
  PPstack_st_SRTP_PROTECTION_PROFILE = ^Pstack_st_SRTP_PROTECTION_PROFILE;
  Plhash_st_SSL_SESSION = pointer;
  PPlhash_st_SSL_SESSION = ^Plhash_st_SSL_SESSION;
  Pstack_st_SSL_CIPHER = pointer;
  PPstack_st_SSL_CIPHER = ^Pstack_st_SSL_CIPHER;
  Pstack_st_SSL_COMP = pointer;
  PPstack_st_SSL_COMP = ^Pstack_st_SSL_COMP;
  Possl_store_ctx_st = pointer;
  PPossl_store_ctx_st = ^Possl_store_ctx_st;
  Possl_store_loader_st = pointer;
  PPossl_store_loader_st = ^Possl_store_loader_st;
  Possl_store_loader_ctx_st = pointer;
  PPossl_store_loader_ctx_st = ^Possl_store_loader_ctx_st;
  PTS_msg_imprint_st = pointer;
  PPTS_msg_imprint_st = ^PTS_msg_imprint_st;
  PTS_req_st = pointer;
  PPTS_req_st = ^PTS_req_st;
  PTS_accuracy_st = pointer;
  PPTS_accuracy_st = ^PTS_accuracy_st;
  PTS_tst_info_st = pointer;
  PPTS_tst_info_st = ^PTS_tst_info_st;
  PTS_status_info_st = pointer;
  PPTS_status_info_st = ^PTS_status_info_st;
  Pstack_st_ESS_CERT_ID = pointer;
  PPstack_st_ESS_CERT_ID = ^Pstack_st_ESS_CERT_ID;
  PESS_cert_id_v2_st = pointer;
  PPESS_cert_id_v2_st = ^PESS_cert_id_v2_st;
  PESS_signing_cert_v2_st = pointer;
  PPESS_signing_cert_v2_st = ^PESS_signing_cert_v2_st;
  Pstack_st_ESS_CERT_ID_V2 = pointer;
  PPstack_st_ESS_CERT_ID_V2 = ^Pstack_st_ESS_CERT_ID_V2;
  PTS_resp_st = pointer;
  PPTS_resp_st = ^PTS_resp_st;
  Pstack_st_EVP_MD = pointer;
  PPstack_st_EVP_MD = ^Pstack_st_EVP_MD;
  Pstack_st_OPENSSL_PSTRING = pointer;
  PPstack_st_OPENSSL_PSTRING = ^Pstack_st_OPENSSL_PSTRING;
  Paes_key_st = ^aes_key_st;
  PCRYPTO_dynlock = ^CRYPTO_dynlock;
  Pcrypto_ex_data_st = ^crypto_ex_data_st;
  Pcrypto_threadid_st = ^crypto_threadid_st;
  Pasn1_string_st = ^asn1_string_st;
  PASN1_ENCODING_st = ^ASN1_ENCODING_st;
  Pasn1_string_table_st = ^asn1_string_table_st;
  Pasn1_type_st = ^asn1_type_st;
  PBIT_STRING_BITNAME_st = ^BIT_STRING_BITNAME_st;
  PASN1_TEMPLATE_st = ^ASN1_TEMPLATE_st;
  PASN1_ADB_st = ^ASN1_ADB_st;
  PASN1_ADB_TABLE_st = ^ASN1_ADB_TABLE_st;
  PASN1_ITEM_st = ^ASN1_ITEM_st;
  PASN1_TLC_st = ^ASN1_TLC_st;
  PASN1_EXTERN_FUNCS_st = ^ASN1_EXTERN_FUNCS_st;
  PASN1_PRIMITIVE_FUNCS_st = ^ASN1_PRIMITIVE_FUNCS_st;
  PASN1_AUX_st = ^ASN1_AUX_st;
  PASN1_PRINT_ARG_st = ^ASN1_PRINT_ARG_st;
  PASN1_STREAM_ARG_st = ^ASN1_STREAM_ARG_st;
  Pbf_key_st = ^bf_key_st;
  Pbuf_mem_st = ^buf_mem_st;
  Pcamellia_key_st = ^camellia_key_st;
  Pcast_key_st = ^cast_key_st;
  Pobj_name_st = ^obj_name_st;
  PEVP_CTRL_TLS1_1_MULTIBLOCK_PARAM = ^EVP_CTRL_TLS1_1_MULTIBLOCK_PARAM;
  Pevp_cipher_info_st = ^evp_cipher_info_st;
  PEC_builtin_curve = ^EC_builtin_curve;
  Prsa_pss_params_st = ^rsa_pss_params_st;
  Prsa_oaep_params_st = ^rsa_oaep_params_st;
  PSHAstate_st = ^SHAstate_st;
  PSHA256state_st = ^SHA256state_st;
  PSHA512state_st = ^SHA512state_st;
  PX509_algor_st = ^X509_algor_st;
  PX509_val_st = ^X509_val_st;
  Px509_trust_st = ^x509_trust_st;
  Pprivate_key_st = ^private_key_st;
  PX509_info_st = ^X509_info_st;
  PNetscape_spkac_st = ^Netscape_spkac_st;
  PNetscape_spki_st = ^Netscape_spki_st;
  PNetscape_certificate_sequence = ^Netscape_certificate_sequence;
  PPBEPARAM_st = ^PBEPARAM_st;
  PPBE2PARAM_st = ^PBE2PARAM_st;
  PPBKDF2PARAM_st = ^PBKDF2PARAM_st;
  PSCRYPT_PARAMS_st = ^SCRYPT_PARAMS_st;
  Plhash_st_OPENSSL_STRING = ^lhash_st_OPENSSL_STRING;
  PPlhash_st_OPENSSL_STRING = ^Plhash_st_OPENSSL_STRING;
  Plhash_st_OPENSSL_CSTRING = ^lhash_st_OPENSSL_CSTRING;
  Ppkcs7_issuer_and_serial_st = ^pkcs7_issuer_and_serial_st;
  Ppkcs7_signer_info_st = ^pkcs7_signer_info_st;
  Ppkcs7_recip_info_st = ^pkcs7_recip_info_st;
  Ppkcs7_signed_st = ^pkcs7_signed_st;
  Ppkcs7_enc_content_st = ^pkcs7_enc_content_st;
  Ppkcs7_enveloped_st = ^pkcs7_enveloped_st;
  Ppkcs7_signedandenveloped_st = ^pkcs7_signedandenveloped_st;
  Ppkcs7_digest_st = ^pkcs7_digest_st;
  Ppkcs7_encrypted_st = ^pkcs7_encrypted_st;
  Ppkcs7_st = ^pkcs7_st;
  PCONF_VALUE = ^CONF_VALUE;
  PPCONF_VALUE = ^PCONF_VALUE;
  Pconf_method_st = ^conf_method_st;
  Pconf_st = ^conf_st;
  Pv3_ext_method = ^v3_ext_method;
  PX509V3_CONF_METHOD_st = ^X509V3_CONF_METHOD_st;
  Pv3_ext_ctx = ^v3_ext_ctx;
  PBASIC_CONSTRAINTS_st = ^BASIC_CONSTRAINTS_st;
  PPKEY_USAGE_PERIOD_st = ^PKEY_USAGE_PERIOD_st;
  PotherName_st = ^otherName_st;
  PEDIPartyName_st = ^EDIPartyName_st;
  PGENERAL_NAME_st = ^GENERAL_NAME_st;
  PACCESS_DESCRIPTION_st = ^ACCESS_DESCRIPTION_st;
  PDIST_POINT_NAME_st = ^DIST_POINT_NAME_st;
  PDIST_POINT_st = ^DIST_POINT_st;
  PAUTHORITY_KEYID_st = ^AUTHORITY_KEYID_st;
  PSXNET_ID_st = ^SXNET_ID_st;
  PSXNET_st = ^SXNET_st;
  PNOTICEREF_st = ^NOTICEREF_st;
  PUSERNOTICE_st = ^USERNOTICE_st;
  PPOLICYQUALINFO_st = ^POLICYQUALINFO_st;
  PPOLICYINFO_st = ^POLICYINFO_st;
  PPOLICY_MAPPING_st = ^POLICY_MAPPING_st;
  PGENERAL_SUBTREE_st = ^GENERAL_SUBTREE_st;
  PNAME_CONSTRAINTS_st = ^NAME_CONSTRAINTS_st;
  PPOLICY_CONSTRAINTS_st = ^POLICY_CONSTRAINTS_st;
  PPROXY_POLICY_st = ^PROXY_POLICY_st;
  PPROXY_CERT_INFO_EXTENSION_st = ^PROXY_CERT_INFO_EXTENSION_st;
  PISSUING_DIST_POINT_st = ^ISSUING_DIST_POINT_st;
  Px509_purpose_st = ^x509_purpose_st;
  PASRange_st = ^ASRange_st;
  PASIdOrRange_st = ^ASIdOrRange_st;
  PASIdentifierChoice_st = ^ASIdentifierChoice_st;
  PASIdentifiers_st = ^ASIdentifiers_st;
  PIPAddressRange_st = ^IPAddressRange_st;
  PIPAddressOrRange_st = ^IPAddressOrRange_st;
  PIPAddressChoice_st = ^IPAddressChoice_st;
  PIPAddressFamily_st = ^IPAddressFamily_st;
  PDES_ks = ^DES_ks;
  Prand_meth_st = ^rand_meth_st;
  Perr_state_st = ^err_state_st;
  PERR_string_data_st = ^ERR_string_data_st;
  Plhash_st_ERR_STRING_DATA = ^lhash_st_ERR_STRING_DATA;
  PENGINE_CMD_DEFN_st = ^ENGINE_CMD_DEFN_st;
  Pst_dynamic_MEM_fns = ^st_dynamic_MEM_fns;
  Pst_dynamic_fns = ^st_dynamic_fns;
  Pidea_key_st = ^idea_key_st;
  PMD4state_st = ^MD4state_st;
  PMD5state_st = ^MD5state_st;
  Pmdc2_ctx_st = ^mdc2_ctx_st;
  Prc2_key_st = ^rc2_key_st;
  Prc4_key_st = ^rc4_key_st;
  PRIPEMD160state_st = ^RIPEMD160state_st;
  Pseed_key_st = ^seed_key_st;
  PSRP_gN_cache_st = ^SRP_gN_cache_st;
  PSRP_user_pwd_st = ^SRP_user_pwd_st;
  PSRP_VBASE_st = ^SRP_VBASE_st;
  PSRP_gN_st = ^SRP_gN_st;
  Psrtp_protection_profile_st = ^srtp_protection_profile_st;
  Ptls_session_ticket_ext_st = ^tls_session_ticket_ext_st;
  Ptxt_db_st = ^txt_db_st;
  PWHIRLPOOL_CTX = ^WHIRLPOOL_CTX;

  aes_key_st = record
    rd_key: array [0..59] of cardinal;
    rounds: integer;
  end;

  AES_KEY = aes_key_st;
  PAES_KEY = ^AES_KEY;

  OPENSSL_STRING = PUtf8Char;
  POPENSSL_STRING = ^OPENSSL_STRING;
  PPOPENSSL_STRING = ^POPENSSL_STRING;
  OPENSSL_CSTRING = PUtf8Char;
  POPENSSL_CSTRING = ^OPENSSL_CSTRING;

  OPENSSL_sk_copyfunc = function(p1: pointer): pointer; cdecl;

  sk_OPENSSL_STRING_compfunc = function(a: PPUtf8Char; b: PPUtf8Char): integer; cdecl;
  sk_OPENSSL_STRING_freefunc = procedure(a: PUtf8Char); cdecl;
  sk_OPENSSL_STRING_copyfunc = function(a: PUtf8Char): PUtf8Char; cdecl;
  sk_OPENSSL_CSTRING_compfunc = function(a: PPUtf8Char; b: PPUtf8Char): integer; cdecl;
  sk_OPENSSL_CSTRING_freefunc = procedure(a: PUtf8Char); cdecl;
  sk_OPENSSL_CSTRING_copyfunc = function(a: PUtf8Char): PUtf8Char; cdecl;

  OPENSSL_BLOCK = pointer;

  sk_OPENSSL_BLOCK_compfunc = function(a: PPointer; b: PPointer): integer; cdecl;
  sk_OPENSSL_BLOCK_freefunc = procedure(a: pointer); cdecl;
  sk_OPENSSL_BLOCK_copyfunc = function(a: pointer): pointer; cdecl;

  PBN_BLINDING = pointer;
  PPBN_BLINDING = ^PBN_BLINDING;
  PBN_MONT_CTX = pointer;
  PPBN_MONT_CTX = ^PBN_MONT_CTX;
  PBN_RECP_CTX = pointer;
  PPBN_RECP_CTX = ^PBN_RECP_CTX;
  PBN_GENCB = pointer;
  PPBN_GENCB = ^PBN_GENCB;
  PEVP_PKEY_ASN1_METHOD = pointer;
  PPEVP_PKEY_ASN1_METHOD = ^PEVP_PKEY_ASN1_METHOD;
  PEVP_PKEY_METHOD = pointer;
  PPEVP_PKEY_METHOD = ^PEVP_PKEY_METHOD;
  PEVP_ENCODE_CTX = pointer;
  PPEVP_ENCODE_CTX = ^PEVP_ENCODE_CTX;
  PDH = pointer;
  PPDH = ^PDH;
  PDH_METHOD = pointer;
  PPDH_METHOD = ^PDH_METHOD;
  PDSA = pointer;
  PPDSA = ^PDSA;
  PDSA_METHOD = pointer;
  PPDSA_METHOD = ^PDSA_METHOD;
  PRSA_METHOD = pointer;
  PPRSA_METHOD = ^PRSA_METHOD;
  PEC_KEY_METHOD = pointer;
  PPEC_KEY_METHOD = ^PEC_KEY_METHOD;
  PSSL_DANE = pointer;
  PPSSL_DANE = ^PSSL_DANE;
  PX509_SIG_INFO = pointer;
  PPX509_SIG_INFO = ^PX509_SIG_INFO;
  PPKCS8_PRIV_KEY_INFO = pointer;
  PPPKCS8_PRIV_KEY_INFO = ^PPKCS8_PRIV_KEY_INFO;
  PCONF = ^CONF;
  POPENSSL_INIT_SETTINGS = pointer;
  PPOPENSSL_INIT_SETTINGS = ^POPENSSL_INIT_SETTINGS;
  PUI = pointer;
  PPUI = ^PUI;
  PUI_METHOD = pointer;
  PPUI_METHOD = ^PUI_METHOD;
  PCOMP_CTX = pointer;
  PPCOMP_CTX = ^PCOMP_CTX;
  PCOMP_METHOD = pointer;
  PPCOMP_METHOD = ^PCOMP_METHOD;
  PX509_POLICY_NODE = pointer;
  PPX509_POLICY_NODE = ^PX509_POLICY_NODE;
  PX509_POLICY_LEVEL = pointer;
  PPX509_POLICY_LEVEL = ^PX509_POLICY_LEVEL;
  PX509_POLICY_TREE = pointer;
  PPX509_POLICY_TREE = ^PX509_POLICY_TREE;
  PX509_POLICY_CACHE = pointer;
  PPX509_POLICY_CACHE = ^PX509_POLICY_CACHE;
  PAUTHORITY_KEYID = ^AUTHORITY_KEYID;
  PPAUTHORITY_KEYID = ^PAUTHORITY_KEYID;
  PDIST_POINT = ^DIST_POINT;
  PPDIST_POINT = ^PDIST_POINT;
  PISSUING_DIST_POINT = ^ISSUING_DIST_POINT;
  PPISSUING_DIST_POINT = ^PISSUING_DIST_POINT;
  POCSP_REQ_CTX = pointer;
  PPOCSP_REQ_CTX = ^POCSP_REQ_CTX;
  POCSP_RESPONSE = pointer;
  PPOCSP_RESPONSE = ^POCSP_RESPONSE;
  POCSP_RESPID = pointer;
  PPOCSP_RESPID = ^POCSP_RESPID;
  PSCT = pointer;
  PPSCT = ^PSCT;
  PSCT_CTX = pointer;
  PPSCT_CTX = ^PSCT_CTX;
  PCTLOG = pointer;
  PPCTLOG = ^PCTLOG;
  PCTLOG_STORE = pointer;
  PPCTLOG_STORE = ^PCTLOG_STORE;
  PCT_POLICY_EVAL_CTX = pointer;
  PPCT_POLICY_EVAL_CTX = ^PCT_POLICY_EVAL_CTX;
  POSSL_STORE_INFO = pointer;
  PPOSSL_STORE_INFO = ^POSSL_STORE_INFO;
  POSSL_STORE_SEARCH = pointer;
  PPOSSL_STORE_SEARCH = ^POSSL_STORE_SEARCH;
  ossl_intmax_t = Int64;
  ossl_uintmax_t = Qword;

  CRYPTO_dynlock = record
    dummy: integer;
  end;

  PCRYPTO_RWLOCK = pointer;
  PPCRYPTO_RWLOCK = ^PCRYPTO_RWLOCK;

  sk_void_compfunc = function(a: PPointer; b: PPointer): integer; cdecl;
  sk_void_freefunc = procedure(a: pointer); cdecl;
  sk_void_copyfunc = function(a: pointer): pointer; cdecl;

  crypto_threadid_st = record
    dummy: integer;
  end;

  CRYPTO_THREADID = crypto_threadid_st;
  CRYPTO_ONCE = cardinal;
  PCRYPTO_ONCE = ^CRYPTO_ONCE;
  CRYPTO_THREAD_LOCAL = cardinal;
  PCRYPTO_THREAD_LOCAL = ^CRYPTO_THREAD_LOCAL;
  CRYPTO_THREAD_ID = cardinal;
  PBIO_ADDR = pointer;
  PPBIO_ADDR = ^PBIO_ADDR;
  PBIO_ADDRINFO = pointer;
  PPBIO_ADDRINFO = ^PBIO_ADDRINFO;

  BIO_callback_fn = function(b: PBIO; oper: integer; argp: PUtf8Char; argi: integer; argl: integer; ret: integer): integer; cdecl;
  BIO_callback_fn_ex = function(b: PBIO; oper: integer; argp: PUtf8Char; len: PtrUInt; argi: integer; argl: integer; ret: integer; processed: PPtrUInt): integer; cdecl;

  PBIO_info_cb = function(p1: PBIO; p2: integer; p3: integer): integer; cdecl;
  sk_BIO_compfunc = function(a: PPBIO; b: PPBIO): integer; cdecl;
  sk_BIO_freefunc = procedure(a: PBIO); cdecl;
  sk_BIO_copyfunc = function(a: PBIO): Pbio_st; cdecl;
  Pasn1_ps_func = function(b: PBIO; pbuf: PPByte; plen: PInteger; parg: pointer): integer; cdecl;

  BIO_hostserv_priorities = (
    BIO_PARSE_PRIO_HOST = 0,
    BIO_PARSE_PRIO_SERV = 1);
  PBIO_hostserv_priorities = ^BIO_hostserv_priorities;

  BIO_lookup_type = (
    BIO_LOOKUP_CLIENT = 0,
    BIO_LOOKUP_SERVER = 1);
  PBIO_lookup_type = ^BIO_lookup_type;

  BIO_sock_info_u = record
    case integer of
      0: (addr: PBIO_ADDR);
  end;

  BIO_sock_info_type = (
    BIO_SOCK_INFO_ADDRESS = 0);
  PBIO_sock_info_type = ^BIO_sock_info_type;

  PPASN1_ENUMERATED = ^PASN1_ENUMERATED;
  PPASN1_BIT_STRING = ^PASN1_BIT_STRING;
  PPASN1_OCTET_STRING = ^PASN1_OCTET_STRING;
  PPASN1_PRINTABLESTRING = ^PASN1_PRINTABLESTRING;
  PPASN1_T61STRING = ^PASN1_T61STRING;
  PPASN1_IA5STRING = ^PASN1_IA5STRING;
  PPASN1_GENERALSTRING = ^PASN1_GENERALSTRING;
  PPASN1_UNIVERSALSTRING = ^PASN1_UNIVERSALSTRING;
  PPASN1_UTCTIME = ^PASN1_UTCTIME;
  PPASN1_TIME = ^PASN1_TIME;
  PPASN1_GENERALIZEDTIME = ^PASN1_GENERALIZEDTIME;
  PPASN1_VISIBLESTRING = ^PASN1_VISIBLESTRING;
  PPASN1_UTF8STRING = ^PASN1_UTF8STRING;
  PPASN1_NULL = ^PASN1_NULL;
  PASN1_PCTX = pointer;
  PPASN1_PCTX = ^PASN1_PCTX;
  PASN1_SCTX = pointer;
  PPASN1_SCTX = ^PASN1_SCTX;

  ASN1_ENCODING_st = record
    enc: PByte;
    len: integer;
    modified: integer;
  end;

  ASN1_ENCODING = ASN1_ENCODING_st;

  asn1_string_table_st = record
    nid: integer;
    minsize: integer;
    maxsize: integer;
    mask: cardinal;
    flags: cardinal;
  end;

  ASN1_STRING_TABLE = asn1_string_table_st;
  PASN1_STRING_TABLE = ^ASN1_STRING_TABLE;
  PPASN1_STRING_TABLE = ^PASN1_STRING_TABLE;

  sk_ASN1_STRING_TABLE_compfunc = function(a: PPASN1_STRING_TABLE; b: PPASN1_STRING_TABLE): integer; cdecl;
  sk_ASN1_STRING_TABLE_freefunc = procedure(a: PASN1_STRING_TABLE); cdecl;
  sk_ASN1_STRING_TABLE_copyfunc = function(a: PASN1_STRING_TABLE): Pasn1_string_table_st; cdecl;

  Pd2i_of_void = function(p1: PPointer; p2: PPByte; p3: integer): pointer; cdecl;
  Pi2d_of_void = function(p1: pointer; p2: PPByte): integer; cdecl;
  sk_ASN1_INTEGER_compfunc = function(a: PPASN1_INTEGER; b: PPASN1_INTEGER): integer; cdecl;
  sk_ASN1_INTEGER_freefunc = procedure(a: PASN1_INTEGER); cdecl;
  sk_ASN1_INTEGER_copyfunc = function(a: PASN1_INTEGER): Pasn1_string_st; cdecl;
  sk_ASN1_GENERALSTRING_compfunc = function(a: PPASN1_GENERALSTRING; b: PPASN1_GENERALSTRING): integer; cdecl;
  sk_ASN1_GENERALSTRING_freefunc = procedure(a: PASN1_GENERALSTRING); cdecl;
  sk_ASN1_GENERALSTRING_copyfunc = function(a: PASN1_GENERALSTRING): Pasn1_string_st; cdecl;
  sk_ASN1_UTF8STRING_compfunc = function(a: PPASN1_UTF8STRING; b: PPASN1_UTF8STRING): integer; cdecl;
  sk_ASN1_UTF8STRING_freefunc = procedure(a: PASN1_UTF8STRING); cdecl;
  sk_ASN1_UTF8STRING_copyfunc = function(a: PASN1_UTF8STRING): Pasn1_string_st; cdecl;

  sk_ASN1_TYPE_compfunc = function(a: PPASN1_TYPE; b: PPASN1_TYPE): integer; cdecl;
  sk_ASN1_TYPE_freefunc = procedure(a: PASN1_TYPE); cdecl;
  sk_ASN1_TYPE_copyfunc = function(a: PASN1_TYPE): Pasn1_type_st; cdecl;

  PASN1_SEQUENCE_ANY = pointer;
  PPASN1_SEQUENCE_ANY = ^PASN1_SEQUENCE_ANY;

  BIT_STRING_BITNAME_st = record
    bitnum: integer;
    lname: PUtf8Char;
    sname: PUtf8Char;
  end;

  BIT_STRING_BITNAME = BIT_STRING_BITNAME_st;
  PBIT_STRING_BITNAME = ^BIT_STRING_BITNAME;

  sk_ASN1_OBJECT_compfunc = function(a: PPASN1_OBJECT; b: PPASN1_OBJECT): integer; cdecl;
  sk_ASN1_OBJECT_freefunc = procedure(a: PASN1_OBJECT); cdecl;
  sk_ASN1_OBJECT_copyfunc = function(a: PASN1_OBJECT): Pasn1_object_st; cdecl;
  PASN1_ITEM_EXP = function(): pointer{PASN1_ITEM}; cdecl;

  ASN1_TEMPLATE_st = record
    flags: cardinal;
    tag: integer;
    offset: cardinal;
    field_name: PUtf8Char;
    item: PASN1_ITEM_EXP;
  end;
  ASN1_TEMPLATE = ASN1_TEMPLATE_st;
  PASN1_TEMPLATE = ^ASN1_TEMPLATE;

  ASN1_ITEM_st = record
    itype: AnsiChar;
    utype: integer;
    templates: PASN1_TEMPLATE;
    tcount: integer;
    funcs: pointer;
    size: integer;
    sname: PUtf8Char;
  end;
  ASN1_ITEM = ASN1_ITEM_st;
  PASN1_ITEM = ^ASN1_ITEM;

  ASN1_ADB_TABLE_st = record
    value: integer;
    tt: ASN1_TEMPLATE;
  end;

  ASN1_ADB_TABLE = ASN1_ADB_TABLE_st;
  PASN1_ADB_TABLE = ^ASN1_ADB_TABLE;

  ASN1_ADB_st = record
    flags: cardinal;
    offset: cardinal;
    adb_cb: function(psel: PInteger): integer; cdecl;
    tbl: PASN1_ADB_TABLE;
    tblcount: integer;
    default_tt: PASN1_TEMPLATE;
    null_tt: PASN1_TEMPLATE;
  end;

  ASN1_ADB = ASN1_ADB_st;

  ASN1_TLC_st = record
    valid: AnsiChar;
    ret: integer;
    plen: integer;
    ptag: integer;
    pclass: integer;
    hdrlen: integer;
  end;
  ASN1_TLC = ASN1_TLC_st;
  PASN1_TLC = ^ASN1_TLC;

  PASN1_ex_d2i = function(pval: PPASN1_VALUE; _in: PPByte; len: integer; it: PASN1_ITEM; tag: integer; aclass: integer; opt: AnsiChar; ctx: PASN1_TLC): integer; cdecl;
  PASN1_ex_i2d = function(pval: PPASN1_VALUE; _out: PPByte; it: PASN1_ITEM; tag: integer; aclass: integer): integer; cdecl;
  PASN1_ex_new_func = function(pval: PPASN1_VALUE; it: PASN1_ITEM): integer; cdecl;
  PASN1_ex_free_func = procedure(pval: PPASN1_VALUE; it: PASN1_ITEM); cdecl;
  PASN1_ex_print_func = function(_out: PBIO; pval: PPASN1_VALUE; indent: integer; fname: PUtf8Char; pctx: PASN1_PCTX): integer; cdecl;
  PASN1_primitive_i2c = function(pval: PPASN1_VALUE; cont: PByte; putype: PInteger; it: PASN1_ITEM): integer; cdecl;
  PASN1_primitive_c2i = function(pval: PPASN1_VALUE; cont: PByte; len: integer; utype: integer; free_cont: PUtf8Char; it: PASN1_ITEM): integer; cdecl;
  PASN1_primitive_print = function(_out: PBIO; pval: PPASN1_VALUE; it: PASN1_ITEM; indent: integer; pctx: PASN1_PCTX): integer; cdecl;

  ASN1_EXTERN_FUNCS_st = record
    app_data: pointer;
    asn1_ex_new: PASN1_ex_new_func;
    asn1_ex_free: PASN1_ex_free_func;
    asn1_ex_clear: PASN1_ex_free_func;
    asn1_ex_d2i: PASN1_ex_d2i;
    asn1_ex_i2d: PASN1_ex_i2d;
    asn1_ex_print: PASN1_ex_print_func;
  end;

  ASN1_EXTERN_FUNCS = ASN1_EXTERN_FUNCS_st;

  ASN1_PRIMITIVE_FUNCS_st = record
    app_data: pointer;
    flags: cardinal;
    prim_new: PASN1_ex_new_func;
    prim_free: PASN1_ex_free_func;
    prim_clear: PASN1_ex_free_func;
    prim_c2i: PASN1_primitive_c2i;
    prim_i2c: PASN1_primitive_i2c;
    prim_print: PASN1_primitive_print;
  end;

  ASN1_PRIMITIVE_FUNCS = ASN1_PRIMITIVE_FUNCS_st;

  PASN1_aux_cb = function(operation: integer; _in: PPASN1_VALUE; it: PASN1_ITEM; exarg: pointer): integer; cdecl;

  ASN1_AUX_st = record
    app_data: pointer;
    flags: integer;
    ref_offset: integer;
    ref_lock: integer;
    asn1_cb: PASN1_aux_cb;
    enc_offset: integer;
  end;

  ASN1_AUX = ASN1_AUX_st;

  ASN1_PRINT_ARG_st = record
    _out: PBIO;
    indent: integer;
    pctx: PASN1_PCTX;
  end;

  ASN1_PRINT_ARG = ASN1_PRINT_ARG_st;

  ASN1_STREAM_ARG_st = record
    _out: PBIO;
    ndef_bio: PBIO;
    boundary: PPByte;
  end;

  ASN1_STREAM_ARG = ASN1_STREAM_ARG_st;

  sk_ASN1_VALUE_compfunc = function(a: PPASN1_VALUE; b: PPASN1_VALUE): integer; cdecl;
  sk_ASN1_VALUE_freefunc = procedure(a: PASN1_VALUE); cdecl;
  sk_ASN1_VALUE_copyfunc = function(a: PASN1_VALUE): PASN1_VALUE_st; cdecl;

  PASYNC_JOB = pointer;
  PPASYNC_JOB = ^PASYNC_JOB;
  PASYNC_WAIT_CTX = pointer;
  PPASYNC_WAIT_CTX = ^PASYNC_WAIT_CTX;

  bf_key_st = record
    P: array [0..17] of cardinal;
    S: array [0..1023] of cardinal;
  end;

  BF_KEY = bf_key_st;
  PBF_KEY = ^BF_KEY;

  KEY_TABLE_TYPE = array [0..67] of cardinal;

  _anonymous_type_2 = record
    case integer of
      0: (d: Double);
      1: (rd_key: KEY_TABLE_TYPE);
  end;
  P_anonymous_type_2 = ^_anonymous_type_2;

  camellia_key_st = record
    u: _anonymous_type_2;
    grand_rounds: integer;
  end;

  CAMELLIA_KEY = camellia_key_st;
  PCAMELLIA_KEY = ^CAMELLIA_KEY;

  cast_key_st = record
    data: array [0..31] of cardinal;
    short_key: integer;
  end;

  CAST_KEY = cast_key_st;
  PCAST_KEY = ^CAST_KEY;

  obj_name_st = record
    asn1type: integer;
    alias: integer;
    name: PUtf8Char;
    data: PUtf8Char;
  end;

  OBJ_NAME = obj_name_st;
  POBJ_NAME = ^OBJ_NAME;

  EVP_CTRL_TLS1_1_MULTIBLOCK_PARAM = record
    _out: PByte;
    inp: PByte;
    len: PtrUInt;
    interleave: cardinal;
  end;

  evp_cipher_info_st = record
    cipher: PEVP_CIPHER;
    iv: array [0..15] of Byte;
  end;

  EVP_CIPHER_INFO = evp_cipher_info_st;
  PEVP_CIPHER_INFO = ^EVP_CIPHER_INFO;

  PEVP_PBE_KEYGEN = function(ctx: PEVP_CIPHER_CTX; pass: PUtf8Char; passlen: integer; param: PASN1_TYPE; cipher: PEVP_CIPHER; md: PEVP_MD; en_de: integer): integer; cdecl;
  PEVP_PKEY_gen_cb = function(ctx: PEVP_PKEY_CTX): integer; cdecl;

  PCMAC_CTX = pointer;
  PPCMAC_CTX = ^PCMAC_CTX;

  PEC_METHOD = pointer;
  PPEC_METHOD = ^PEC_METHOD;
  PECPKPARAMETERS = pointer;
  PPECPKPARAMETERS = ^PECPKPARAMETERS;
  PECPARAMETERS = pointer;
  PPECPARAMETERS = ^PECPARAMETERS;

  EC_builtin_curve = record
    nid: integer;
    comment: PUtf8Char;
  end;

  PECDSA_SIG = pointer;
  PPECDSA_SIG = ^PECDSA_SIG;

  SHAstate_st = record
    h0: cardinal;
    h1: cardinal;
    h2: cardinal;
    h3: cardinal;
    h4: cardinal;
    Nl: cardinal;
    Nh: cardinal;
    data: array [0..15] of cardinal;
    num: cardinal;
  end;

  SHA_CTX = SHAstate_st;
  PSHA_CTX = ^SHA_CTX;

  SHA256state_st = record
    h: array [0..7] of cardinal;
    Nl: cardinal;
    Nh: cardinal;
    data: array [0..15] of cardinal;
    num: cardinal;
    md_len: cardinal;
  end;

  SHA256_CTX = SHA256state_st;
  PSHA256_CTX = ^SHA256_CTX;

  _anonymous_type_3 = record
    case integer of
      0: (d: array [0..15] of Qword);
      1: (p: array [0..127] of Byte);
  end;
  P_anonymous_type_3 = ^_anonymous_type_3;

  SHA512state_st = record
    h: array [0..7] of Qword;
    Nl: Qword;
    Nh: Qword;
    u: _anonymous_type_3;
    num: cardinal;
    md_len: cardinal;
  end;

  SHA512_CTX = SHA512state_st;
  PSHA512_CTX = ^SHA512_CTX;

  sk_X509_ALGOR_compfunc = function(a: PPX509_ALGOR; b: PPX509_ALGOR): integer; cdecl;
  sk_X509_ALGOR_freefunc = procedure(a: PX509_ALGOR); cdecl;
  sk_X509_ALGOR_copyfunc = function(a: PX509_ALGOR): PX509_algor_st; cdecl;

  rsa_pss_params_st = record
    hashAlgorithm: PX509_ALGOR;
    maskGenAlgorithm: PX509_ALGOR;
    saltLength: PASN1_INTEGER;
    trailerField: PASN1_INTEGER;
    maskHash: PX509_ALGOR;
  end;

  RSA_PSS_PARAMS = rsa_pss_params_st;
  PRSA_PSS_PARAMS = ^RSA_PSS_PARAMS;
  PPRSA_PSS_PARAMS = ^PRSA_PSS_PARAMS;

  rsa_oaep_params_st = record
    hashFunc: PX509_ALGOR;
    maskGenFunc: PX509_ALGOR;
    pSourceFunc: PX509_ALGOR;
    maskHash: PX509_ALGOR;
  end;

  RSA_OAEP_PARAMS = rsa_oaep_params_st;
  PRSA_OAEP_PARAMS = ^RSA_OAEP_PARAMS;
  PPRSA_OAEP_PARAMS = ^PRSA_OAEP_PARAMS;
  PDSA_SIG = pointer;
  PPDSA_SIG = ^PDSA_SIG;

  PPX509_VAL = ^PX509_VAL;
  PX509_SIG = pointer;
  PPX509_SIG = ^PX509_SIG;

  sk_X509_NAME_ENTRY_compfunc = function(a: PPX509_NAME_ENTRY; b: PPX509_NAME_ENTRY): integer; cdecl;
  sk_X509_NAME_ENTRY_freefunc = procedure(a: PX509_NAME_ENTRY); cdecl;
  sk_X509_NAME_ENTRY_copyfunc = function(a: PX509_NAME_ENTRY): PX509_name_entry_st; cdecl;
  sk_X509_NAME_compfunc = function(a: PPX509_NAME; b: PPX509_NAME): integer; cdecl;
  sk_X509_NAME_freefunc = procedure(a: PX509_NAME); cdecl;
  sk_X509_NAME_copyfunc = function(a: PX509_NAME): PX509_name_st; cdecl;

  sk_X509_EXTENSION_compfunc = function(a: PPX509_EXTENSION; b: PPX509_EXTENSION): integer; cdecl;
  sk_X509_EXTENSION_freefunc = procedure(a: PX509_EXTENSION); cdecl;
  sk_X509_EXTENSION_copyfunc = function(a: PX509_EXTENSION): PX509_extension_st; cdecl;

  PX509_ATTRIBUTE = pointer;
  PPX509_ATTRIBUTE = ^PX509_ATTRIBUTE;

  sk_X509_ATTRIBUTE_compfunc = function(a: PPX509_ATTRIBUTE; b: PPX509_ATTRIBUTE): integer; cdecl;
  sk_X509_ATTRIBUTE_freefunc = procedure(a: PX509_ATTRIBUTE); cdecl;
  sk_X509_ATTRIBUTE_copyfunc = function(a: PX509_ATTRIBUTE): Px509_attributes_st; cdecl;

  PSTACK_OF_X509_INFO = PSTACK_st;
  PSTACK_OF_X509_ALGOR = PSTACK_st;
  PSTACK_OF_X509 = PSTACK_st;
  PPSTACK_OF_X509 = ^PSTACK_OF_X509;
  PSTACK_OF_X509_CRL = PSTACK_st;
  PSTACK_OF_PKCS7_SIGNER_INFO = PSTACK_st;
  PSTACK_OF_X509_ATTRIBUTE = PSTACK_st;
  PSTACK = PSTACK_st;

  sk_X509_compfunc = function(a: PPX509; b: PPX509): integer; cdecl;
  sk_X509_freefunc = procedure(a: PX509); cdecl;
  sk_X509_copyfunc = function(a: PX509): Px509_st; cdecl;

  x509_trust_st = record
    trust: integer;
    flags: integer;
    check_trust: function(p1: Px509_trust_st; p2: PX509; p3: integer): integer; cdecl;
    name: PUtf8Char;
    arg1: integer;
    arg2: pointer;
  end;

  X509_TRUST = x509_trust_st;
  PX509_TRUST = ^X509_TRUST;
  PPX509_TRUST = ^PX509_TRUST;

  sk_X509_TRUST_compfunc = function(a: PPX509_TRUST; b: PPX509_TRUST): integer; cdecl;
  sk_X509_TRUST_freefunc = procedure(a: PX509_TRUST); cdecl;
  sk_X509_TRUST_copyfunc = function(a: PX509_TRUST): Px509_trust_st; cdecl;
  sk_X509_REVOKED_compfunc = function(a: PPX509_REVOKED; b: PPX509_REVOKED): integer; cdecl;
  sk_X509_REVOKED_freefunc = procedure(a: PX509_REVOKED); cdecl;
  sk_X509_REVOKED_copyfunc = function(a: PX509_REVOKED): Px509_revoked_st; cdecl;

  PX509_CRL_INFO = pointer;
  PPX509_CRL_INFO = ^PX509_CRL_INFO;

  sk_X509_CRL_compfunc = function(a: PPX509_CRL; b: PPX509_CRL): integer; cdecl;
  sk_X509_CRL_freefunc = procedure(a: PX509_CRL); cdecl;
  sk_X509_CRL_copyfunc = function(a: PX509_CRL): PX509_crl_st; cdecl;

  private_key_st = record
    version: integer;
    enc_algor: PX509_ALGOR;
    enc_pkey: PASN1_OCTET_STRING;
    dec_pkey: PEVP_PKEY;
    key_length: integer;
    key_data: PUtf8Char;
    key_free: integer;
    cipher: EVP_CIPHER_INFO;
  end;

  X509_PKEY = private_key_st;
  PX509_PKEY = ^X509_PKEY;

  X509_info_st = record
    x509: PX509;
    crl: PX509_CRL;
    x_pkey: PX509_PKEY;
    enc_cipher: EVP_CIPHER_INFO;
    enc_len: integer;
    enc_data: PUtf8Char;
  end;

  X509_INFO = X509_info_st;
  PX509_INFO = ^X509_INFO;
  PPX509_INFO = ^PX509_INFO;

  sk_X509_INFO_compfunc = function(a: PPX509_INFO; b: PPX509_INFO): integer; cdecl;
  sk_X509_INFO_freefunc = procedure(a: PX509_INFO); cdecl;
  sk_X509_INFO_copyfunc = function(a: PX509_INFO): PX509_info_st; cdecl;

  Netscape_spkac_st = record
    pubkey: PX509_PUBKEY;
    challenge: PASN1_IA5STRING;
  end;

  NETSCAPE_SPKAC = Netscape_spkac_st;
  PNETSCAPE_SPKAC = ^NETSCAPE_SPKAC;
  PPNETSCAPE_SPKAC = ^PNETSCAPE_SPKAC;

  Netscape_spki_st = record
    spkac: PNETSCAPE_SPKAC;
    sig_algor: X509_ALGOR;
    signature: PASN1_BIT_STRING;
  end;

  NETSCAPE_SPKI = Netscape_spki_st;
  PNETSCAPE_SPKI = ^NETSCAPE_SPKI;
  PPNETSCAPE_SPKI = ^PNETSCAPE_SPKI;

  Netscape_certificate_sequence = record
    asn1type: PASN1_OBJECT;
    certs: Pstack_st_X509;
  end;

  NETSCAPE_CERT_SEQUENCE = Netscape_certificate_sequence;
  PNETSCAPE_CERT_SEQUENCE = ^NETSCAPE_CERT_SEQUENCE;
  PPNETSCAPE_CERT_SEQUENCE = ^PNETSCAPE_CERT_SEQUENCE;

  PBEPARAM_st = record
    salt: PASN1_OCTET_STRING;
    iter: PASN1_INTEGER;
  end;

  PBEPARAM = PBEPARAM_st;
  PPBEPARAM = ^PBEPARAM;
  PPPBEPARAM = ^PPBEPARAM;

  PBE2PARAM_st = record
    keyfunc: PX509_ALGOR;
    encryption: PX509_ALGOR;
  end;

  PBE2PARAM = PBE2PARAM_st;
  PPBE2PARAM = ^PBE2PARAM;
  PPPBE2PARAM = ^PPBE2PARAM;

  PBKDF2PARAM_st = record
    salt: PASN1_TYPE;
    iter: PASN1_INTEGER;
    keylength: PASN1_INTEGER;
    prf: PX509_ALGOR;
  end;

  PBKDF2PARAM = PBKDF2PARAM_st;
  PPBKDF2PARAM = ^PBKDF2PARAM;
  PPPBKDF2PARAM = ^PPBKDF2PARAM;

  SCRYPT_PARAMS_st = record
    salt: PASN1_OCTET_STRING;
    costParameter: PASN1_INTEGER;
    blockSize: PASN1_INTEGER;
    parallelizationParameter: PASN1_INTEGER;
    keyLength: PASN1_INTEGER;
  end;

  SCRYPT_PARAMS = SCRYPT_PARAMS_st;
  PSCRYPT_PARAMS = ^SCRYPT_PARAMS;
  PPSCRYPT_PARAMS = ^PSCRYPT_PARAMS;
  POPENSSL_LH_NODE = pointer;
  PPOPENSSL_LH_NODE = ^POPENSSL_LH_NODE;

  OPENSSL_LH_COMPFUNC = function(p1: pointer; p2: pointer): integer; cdecl;
  OPENSSL_LH_HASHFUNC = function(p1: pointer): cardinal; cdecl;
  OPENSSL_LH_DOALL_FUNC = procedure(p1: pointer); cdecl;
  OPENSSL_LH_DOALL_FUNCARG = procedure(p1: pointer; p2: pointer); cdecl;

  POPENSSL_LHASH = pointer;
  PPOPENSSL_LHASH = ^POPENSSL_LHASH;

  lh_OPENSSL_STRING_dummy = record
    case integer of
      0: (d1: pointer);
      1: (d2: cardinal);
      2: (d3: integer);
  end;

  lhash_st_OPENSSL_STRING = record
    dummy: lh_OPENSSL_STRING_dummy;
  end;

  lh_OPENSSL_CSTRING_dummy = record
    case integer of
      0: (d1: pointer);
      1: (d2: cardinal);
      2: (d3: integer);
  end;

  lhash_st_OPENSSL_CSTRING = record
    dummy: lh_OPENSSL_CSTRING_dummy;
  end;

  X509_LOOKUP_TYPE = (
    X509_LU_NONE = 0,
    X509_LU_X509 = 1,
    X509_LU_CRL = 2);
  PX509_LOOKUP_TYPE = ^X509_LOOKUP_TYPE;

  sk_X509_LOOKUP_compfunc = function(a: PPX509_LOOKUP; b: PPX509_LOOKUP): integer; cdecl;
  sk_X509_LOOKUP_freefunc = procedure(a: PX509_LOOKUP); cdecl;
  sk_X509_LOOKUP_copyfunc = function(a: PX509_LOOKUP): Px509_lookup_st; cdecl;

  sk_X509_OBJECT_compfunc = function(a: PPX509_OBJECT; b: PPX509_OBJECT): integer; cdecl;
  sk_X509_OBJECT_freefunc = procedure(a: PX509_OBJECT); cdecl;
  sk_X509_OBJECT_copyfunc = function(a: PX509_OBJECT): Px509_object_st; cdecl;

  sk_X509_VERIFY_PARAM_compfunc = function(a: PPX509_VERIFY_PARAM; b: PPX509_VERIFY_PARAM): integer; cdecl;
  sk_X509_VERIFY_PARAM_freefunc = procedure(a: PX509_VERIFY_PARAM); cdecl;
  sk_X509_VERIFY_PARAM_copyfunc = function(a: PX509_VERIFY_PARAM): PX509_VERIFY_PARAM_st; cdecl;

  X509_STORE_CTX_verify_fn = function(p1: PX509_STORE_CTX): integer; cdecl;
  X509_STORE_CTX_get_issuer_fn = function(issuer: PPX509; ctx: PX509_STORE_CTX; x: PX509): integer; cdecl;
  X509_STORE_CTX_check_issued_fn = function(ctx: PX509_STORE_CTX; x: PX509; issuer: PX509): integer; cdecl;
  X509_STORE_CTX_check_revocation_fn = function(ctx: PX509_STORE_CTX): integer; cdecl;
  X509_STORE_CTX_get_crl_fn = function(ctx: PX509_STORE_CTX; crl: PPX509_CRL; x: PX509): integer; cdecl;
  X509_STORE_CTX_check_crl_fn = function(ctx: PX509_STORE_CTX; crl: PX509_CRL): integer; cdecl;
  X509_STORE_CTX_cert_crl_fn = function(ctx: PX509_STORE_CTX; crl: PX509_CRL; x: PX509): integer; cdecl;
  X509_STORE_CTX_check_policy_fn = function(ctx: PX509_STORE_CTX): integer; cdecl;
  X509_STORE_CTX_lookup_certs_fn = function(ctx: PX509_STORE_CTX; nm: PX509_NAME): Pstack_st_X509; cdecl;
  X509_STORE_CTX_lookup_crls_fn = function(ctx: PX509_STORE_CTX; nm: PX509_NAME): Pstack_st_X509_CRL; cdecl;
  X509_STORE_CTX_cleanup_fn = function(ctx: PX509_STORE_CTX): integer; cdecl;

  X509_LOOKUP_ctrl_fn = function(ctx: PX509_LOOKUP; cmd: integer; argc: PUtf8Char; argl: integer; ret: PPUtf8Char): integer; cdecl;
  X509_LOOKUP_get_by_subject_fn = function(ctx: PX509_LOOKUP; x509type: X509_LOOKUP_TYPE; name: PX509_NAME; ret: PX509_OBJECT): integer; cdecl;
  X509_LOOKUP_get_by_issuer_serial_fn = function(ctx: PX509_LOOKUP; x509type: X509_LOOKUP_TYPE; name: PX509_NAME; serial: PASN1_INTEGER; ret: PX509_OBJECT): integer; cdecl;
  X509_LOOKUP_get_by_fingerprint_fn = function(ctx: PX509_LOOKUP; x509type: X509_LOOKUP_TYPE; bytes: PByte; len: integer; ret: PX509_OBJECT): integer; cdecl;
  X509_LOOKUP_get_by_alias_fn = function(ctx: PX509_LOOKUP; x509type: X509_LOOKUP_TYPE; str: PUtf8Char; len: integer; ret: PX509_OBJECT): integer; cdecl;

  pkcs7_issuer_and_serial_st = record
    issuer: PX509_NAME;
    serial: PASN1_INTEGER;
  end;

  PKCS7_ISSUER_AND_SERIAL = pkcs7_issuer_and_serial_st;
  PPKCS7_ISSUER_AND_SERIAL = ^PKCS7_ISSUER_AND_SERIAL;
  PPPKCS7_ISSUER_AND_SERIAL = ^PPKCS7_ISSUER_AND_SERIAL;

  pkcs7_signer_info_st = record
    version: PASN1_INTEGER;
    issuer_and_serial: PPKCS7_ISSUER_AND_SERIAL;
    digest_alg: PX509_ALGOR;
    auth_attr: Pstack_st_X509_ATTRIBUTE;
    digest_enc_alg: PX509_ALGOR;
    enc_digest: PASN1_OCTET_STRING;
    unauth_attr: Pstack_st_X509_ATTRIBUTE;
    pkey: PEVP_PKEY;
  end;

  PKCS7_SIGNER_INFO = pkcs7_signer_info_st;
  PPKCS7_SIGNER_INFO = ^PKCS7_SIGNER_INFO;
  PPPKCS7_SIGNER_INFO = ^PPKCS7_SIGNER_INFO;

  sk_PKCS7_SIGNER_INFO_compfunc = function(a: PPPKCS7_SIGNER_INFO; b: PPPKCS7_SIGNER_INFO): integer; cdecl;
  sk_PKCS7_SIGNER_INFO_freefunc = procedure(a: PPKCS7_SIGNER_INFO); cdecl;
  sk_PKCS7_SIGNER_INFO_copyfunc = function(a: PPKCS7_SIGNER_INFO): Ppkcs7_signer_info_st; cdecl;

  pkcs7_recip_info_st = record
    version: PASN1_INTEGER;
    issuer_and_serial: PPKCS7_ISSUER_AND_SERIAL;
    key_enc_algor: PX509_ALGOR;
    enc_key: PASN1_OCTET_STRING;
    cert: PX509;
  end;

  PKCS7_RECIP_INFO = pkcs7_recip_info_st;
  PPKCS7_RECIP_INFO = ^PKCS7_RECIP_INFO;
  PPPKCS7_RECIP_INFO = ^PPKCS7_RECIP_INFO;

  sk_PKCS7_RECIP_INFO_compfunc = function(a: PPPKCS7_RECIP_INFO; b: PPPKCS7_RECIP_INFO): integer; cdecl;
  sk_PKCS7_RECIP_INFO_freefunc = procedure(a: PPKCS7_RECIP_INFO); cdecl;
  sk_PKCS7_RECIP_INFO_copyfunc = function(a: PPKCS7_RECIP_INFO): Ppkcs7_recip_info_st; cdecl;

  pkcs7_signed_st = record
    version: PASN1_INTEGER;
    md_algs: Pstack_st_X509_ALGOR;
    cert: Pstack_st_X509;
    crl: Pstack_st_X509_CRL;
    signer_info: Pstack_st_PKCS7_SIGNER_INFO;
    contents: Ppkcs7_st;
  end;

  PKCS7_SIGNED = pkcs7_signed_st;
  PPKCS7_SIGNED = ^PKCS7_SIGNED;
  PPPKCS7_SIGNED = ^PPKCS7_SIGNED;

  pkcs7_enc_content_st = record
    content_type: PASN1_OBJECT;
    algorithm: PX509_ALGOR;
    enc_data: PASN1_OCTET_STRING;
    cipher: PEVP_CIPHER;
  end;

  PKCS7_ENC_CONTENT = pkcs7_enc_content_st;
  PPKCS7_ENC_CONTENT = ^PKCS7_ENC_CONTENT;
  PPPKCS7_ENC_CONTENT = ^PPKCS7_ENC_CONTENT;

  pkcs7_enveloped_st = record
    version: PASN1_INTEGER;
    recipientinfo: Pstack_st_PKCS7_RECIP_INFO;
    enc_data: PPKCS7_ENC_CONTENT;
  end;

  PKCS7_ENVELOPE = pkcs7_enveloped_st;
  PPKCS7_ENVELOPE = ^PKCS7_ENVELOPE;
  PPPKCS7_ENVELOPE = ^PPKCS7_ENVELOPE;

  pkcs7_signedandenveloped_st = record
    version: PASN1_INTEGER;
    md_algs: Pstack_st_X509_ALGOR;
    cert: Pstack_st_X509;
    crl: Pstack_st_X509_CRL;
    signer_info: Pstack_st_PKCS7_SIGNER_INFO;
    enc_data: PPKCS7_ENC_CONTENT;
    recipientinfo: Pstack_st_PKCS7_RECIP_INFO;
  end;

  PKCS7_SIGN_ENVELOPE = pkcs7_signedandenveloped_st;
  PPKCS7_SIGN_ENVELOPE = ^PKCS7_SIGN_ENVELOPE;
  PPPKCS7_SIGN_ENVELOPE = ^PPKCS7_SIGN_ENVELOPE;

  pkcs7_digest_st = record
    version: PASN1_INTEGER;
    md: PX509_ALGOR;
    contents: Ppkcs7_st;
    digest: PASN1_OCTET_STRING;
  end;

  PKCS7_DIGEST = pkcs7_digest_st;
  PPKCS7_DIGEST = ^PKCS7_DIGEST;
  PPPKCS7_DIGEST = ^PPKCS7_DIGEST;

  pkcs7_encrypted_st = record
    version: PASN1_INTEGER;
    enc_data: PPKCS7_ENC_CONTENT;
  end;

  _PKCS7_ENCRYPT = pkcs7_encrypted_st;
  PPKCS7_ENCRYPT = ^_PKCS7_ENCRYPT;
  PPPKCS7_ENCRYPT = ^PPKCS7_ENCRYPT;

  _anonymous_type_4 = record
    case integer of
      0: (ptr: PUtf8Char);
      1: (data: PASN1_OCTET_STRING);
      2: (sign: PPKCS7_SIGNED);
      3: (enveloped: PPKCS7_ENVELOPE);
      4: (signed_and_enveloped: PPKCS7_SIGN_ENVELOPE);
      5: (digest: PPKCS7_DIGEST);
      6: (encrypted: PPKCS7_ENCRYPT);
      7: (other: PASN1_TYPE);
  end;
  P_anonymous_type_4 = ^_anonymous_type_4;

  pkcs7_st = record
    asn1: PByte;
    length: integer;
    state: integer;
    detached: integer;
    asn1type: PASN1_OBJECT;
    d: _anonymous_type_4;
  end;

  PKCS7 = pkcs7_st;
  PPKCS7 = ^PKCS7;
  PPPKCS7 = ^PPKCS7;

  sk_PKCS7_compfunc = function(a: PPPKCS7; b: PPPKCS7): integer; cdecl;
  sk_PKCS7_freefunc = procedure(a: PPKCS7); cdecl;
  sk_PKCS7_copyfunc = function(a: PPKCS7): Ppkcs7_st; cdecl;

  CONF_VALUE = record
    section: PUtf8Char;
    name: PUtf8Char;
    value: PUtf8Char;
  end;

  sk_CONF_VALUE_compfunc = function(a: PPCONF_VALUE; b: PPCONF_VALUE): integer; cdecl;
  sk_CONF_VALUE_freefunc = procedure(a: PCONF_VALUE); cdecl;
  sk_CONF_VALUE_copyfunc = function(a: PCONF_VALUE): PCONF_VALUE; cdecl;

  lh_CONF_VALUE_dummy = record
    case integer of
      0: (d1: pointer);
      1: (d2: cardinal);
      2: (d3: integer);
  end;

  lhash_st_CONF_VALUE = record
    dummy: lh_CONF_VALUE_dummy;
  end;

  conf_method_st = record
    name: PUtf8Char;
    create: function(meth: pointer{PCONF_METHOD}): Pconf_st; cdecl;
    init: function(conf: PCONF): integer; cdecl;
    destroy: function(conf: PCONF): integer; cdecl;
    destroy_data: function(conf: PCONF): integer; cdecl;
    load_bio: function(conf: PCONF; bp: PBIO; eline: PInteger): integer; cdecl;
    dump: function(conf: PCONF; bp: PBIO): integer; cdecl;
    is_number: function(conf: PCONF; c: AnsiChar): integer; cdecl;
    to_int: function(conf: PCONF; c: AnsiChar): integer; cdecl;
    load: function(conf: PCONF; name: PUtf8Char; eline: PInteger): integer; cdecl;
  end;
  CONF_METHOD = conf_method_st;
  PCONF_METHOD = ^CONF_METHOD;

  PCONF_IMODULE = pointer;
  PPCONF_IMODULE = ^PCONF_IMODULE;
  PCONF_MODULE = pointer;
  PPCONF_MODULE = ^PCONF_MODULE;

  sk_CONF_MODULE_compfunc = function(a: PPCONF_MODULE; b: PPCONF_MODULE): integer; cdecl;
  sk_CONF_MODULE_freefunc = procedure(a: PCONF_MODULE); cdecl;
  sk_CONF_MODULE_copyfunc = function(a: PCONF_MODULE): Pconf_module_st; cdecl;
  sk_CONF_IMODULE_compfunc = function(a: PPCONF_IMODULE; b: PPCONF_IMODULE): integer; cdecl;
  sk_CONF_IMODULE_freefunc = procedure(a: PCONF_IMODULE); cdecl;
  sk_CONF_IMODULE_copyfunc = function(a: PCONF_IMODULE): Pconf_imodule_st; cdecl;

  Pconf_init_func = function(md: PCONF_IMODULE; cnf: PCONF): integer; cdecl;
  Pconf_finish_func = procedure(md: PCONF_IMODULE); cdecl;

  conf_st = record
    meth: PCONF_METHOD;
    meth_data: pointer;
    data: Plhash_st_CONF_VALUE;
  end;
  CONF = conf_st;

  X509V3_EXT_NEW = function(): pointer; cdecl;
  X509V3_EXT_FREE = procedure(p1: pointer); cdecl;
  _X509V3_EXT_D2I = function(p1: pointer; p2: PPByte; p3: integer): pointer; cdecl;
  _X509V3_EXT_I2D = function(p1: pointer; p2: PPByte): integer; cdecl;
  X509V3_EXT_I2V = function(method: Pv3_ext_method; ext: pointer; extlist: Pstack_st_CONF_VALUE): Pstack_st_CONF_VALUE; cdecl;
  X509V3_EXT_V2I = function(method: Pv3_ext_method; ctx: Pv3_ext_ctx; values: Pstack_st_CONF_VALUE): pointer; cdecl;
  X509V3_EXT_I2S = function(method: Pv3_ext_method; ext: pointer): PUtf8Char; cdecl;
  X509V3_EXT_S2I = function(method: Pv3_ext_method; ctx: Pv3_ext_ctx; str: PUtf8Char): pointer; cdecl;
  X509V3_EXT_I2R = function(method: Pv3_ext_method; ext: pointer; _out: PBIO; indent: integer): integer; cdecl;
  X509V3_EXT_R2I = function(method: Pv3_ext_method; ctx: Pv3_ext_ctx; str: PUtf8Char): pointer; cdecl;

  v3_ext_method = record
    ext_nid: integer;
    ext_flags: integer;
    it: PASN1_ITEM_EXP;
    ext_new: X509V3_EXT_NEW;
    ext_free: X509V3_EXT_FREE;
    d2i: _X509V3_EXT_D2I;
    i2d: _X509V3_EXT_I2D;
    i2s: X509V3_EXT_I2S;
    s2i: X509V3_EXT_S2I;
    i2v: X509V3_EXT_I2V;
    v2i: X509V3_EXT_V2I;
    i2r: X509V3_EXT_I2R;
    r2i: X509V3_EXT_R2I;
    usr_data: pointer;
  end;

  X509V3_EXT_METHOD = v3_ext_method;
  PX509V3_EXT_METHOD = ^X509V3_EXT_METHOD;
  PPX509V3_EXT_METHOD = ^PX509V3_EXT_METHOD;

  sk_X509V3_EXT_METHOD_compfunc = function(a: PPX509V3_EXT_METHOD; b: PPX509V3_EXT_METHOD): integer; cdecl;
  sk_X509V3_EXT_METHOD_freefunc = procedure(a: PX509V3_EXT_METHOD); cdecl;
  sk_X509V3_EXT_METHOD_copyfunc = function(a: PX509V3_EXT_METHOD): Pv3_ext_method; cdecl;

  ENUMERATED_NAMES = BIT_STRING_BITNAME;

  PKEY_USAGE_PERIOD_st = record
    notBefore: PASN1_GENERALIZEDTIME;
    notAfter: PASN1_GENERALIZEDTIME;
  end;

  PKEY_USAGE_PERIOD = PKEY_USAGE_PERIOD_st;
  PPKEY_USAGE_PERIOD = ^PKEY_USAGE_PERIOD;
  PPPKEY_USAGE_PERIOD = ^PPKEY_USAGE_PERIOD;

  otherName_st = record
    type_id: PASN1_OBJECT;
    value: PASN1_TYPE;
  end;

  OTHERNAME = otherName_st;
  POTHERNAME = ^OTHERNAME;
  PPOTHERNAME = ^POTHERNAME;

  EDIPartyName_st = record
    nameAssigner: PASN1_STRING;
    partyName: PASN1_STRING;
  end;

  EDIPARTYNAME = EDIPartyName_st;
  PEDIPARTYNAME = ^EDIPARTYNAME;
  PPEDIPARTYNAME = ^PEDIPARTYNAME;

  _anonymous_type_5 = record
    case integer of
      0: (ptr: PUtf8Char);
      1: (otherName: POTHERNAME);
      2: (rfc822Name: PASN1_IA5STRING);
      3: (dNSName: PASN1_IA5STRING);
      4: (x400Address: PASN1_TYPE);
      5: (directoryName: PX509_NAME);
      6: (ediPartyName: PEDIPARTYNAME);
      7: (uniformResourceIdentifier: PASN1_IA5STRING);
      8: (iPAddress: PASN1_OCTET_STRING);
      9: (registeredID: PASN1_OBJECT);
      10: (ip: PASN1_OCTET_STRING);
      11: (dirn: PX509_NAME);
      12: (ia5: PASN1_IA5STRING);
      13: (rid: PASN1_OBJECT);
      14: (other: PASN1_TYPE);
  end;
  P_anonymous_type_5 = ^_anonymous_type_5;

  GENERAL_NAME_st = record
    gentype: integer;
    d: _anonymous_type_5;
  end;

  GENERAL_NAME = GENERAL_NAME_st;
  PGENERAL_NAME = ^GENERAL_NAME;
  PPGENERAL_NAME = ^PGENERAL_NAME;

  ACCESS_DESCRIPTION_st = record
    method: PASN1_OBJECT;
    location: PGENERAL_NAME;
  end;

  ACCESS_DESCRIPTION = ACCESS_DESCRIPTION_st;
  PACCESS_DESCRIPTION = ^ACCESS_DESCRIPTION;
  PPACCESS_DESCRIPTION = ^PACCESS_DESCRIPTION;
  PAUTHORITY_INFO_ACCESS = pointer;
  PPAUTHORITY_INFO_ACCESS = ^PAUTHORITY_INFO_ACCESS;
  PEXTENDED_KEY_USAGE = pointer;
  PPEXTENDED_KEY_USAGE = ^PEXTENDED_KEY_USAGE;
  PTLS_FEATURE = pointer;
  PPTLS_FEATURE = ^PTLS_FEATURE;

  sk_GENERAL_NAME_compfunc = function(a: PPGENERAL_NAME; b: PPGENERAL_NAME): integer; cdecl;
  sk_GENERAL_NAME_freefunc = procedure(a: PGENERAL_NAME); cdecl;
  sk_GENERAL_NAME_copyfunc = function(a: PGENERAL_NAME): PGENERAL_NAME_st; cdecl;

  PGENERAL_NAMES = pointer;
  PPGENERAL_NAMES = ^PGENERAL_NAMES;

  sk_GENERAL_NAMES_compfunc = function(a: PPGENERAL_NAMES; b: PPGENERAL_NAMES): integer; cdecl;
  sk_GENERAL_NAMES_freefunc = procedure(a: PGENERAL_NAMES); cdecl;
  sk_GENERAL_NAMES_copyfunc = function(a: PGENERAL_NAMES): Pstack_st_GENERAL_NAME; cdecl;

  sk_ACCESS_DESCRIPTION_compfunc = function(a: PPACCESS_DESCRIPTION; b: PPACCESS_DESCRIPTION): integer; cdecl;
  sk_ACCESS_DESCRIPTION_freefunc = procedure(a: PACCESS_DESCRIPTION); cdecl;
  sk_ACCESS_DESCRIPTION_copyfunc = function(a: PACCESS_DESCRIPTION): PACCESS_DESCRIPTION_st; cdecl;

  _anonymous_type_6 = record
    case integer of
      0: (fullname: PGENERAL_NAMES);
      1: (relativename: Pstack_st_X509_NAME_ENTRY);
  end;
  P_anonymous_type_6 = ^_anonymous_type_6;

  DIST_POINT_NAME_st = record
    dptype: integer;
    name: _anonymous_type_6;
    dpname: PX509_NAME;
  end;

  DIST_POINT_NAME = DIST_POINT_NAME_st;
  PDIST_POINT_NAME = ^DIST_POINT_NAME;
  PPDIST_POINT_NAME = ^PDIST_POINT_NAME;

  DIST_POINT_st = record
    distpoint: PDIST_POINT_NAME;
    reasons: PASN1_BIT_STRING;
    CRLissuer: PGENERAL_NAMES;
    dp_reasons: integer;
  end;
  DIST_POINT = DIST_POINT_st;

  PCRL_DIST_POINTS = pointer;
  PPCRL_DIST_POINTS = ^PCRL_DIST_POINTS;

  sk_DIST_POINT_compfunc = function(a: PPDIST_POINT; b: PPDIST_POINT): integer; cdecl;
  sk_DIST_POINT_freefunc = procedure(a: PDIST_POINT); cdecl;
  sk_DIST_POINT_copyfunc = function(a: PDIST_POINT): PDIST_POINT_st; cdecl;

  AUTHORITY_KEYID_st = record
    keyid: PASN1_OCTET_STRING;
    issuer: PGENERAL_NAMES;
    serial: PASN1_INTEGER;
  end;
  AUTHORITY_KEYID = AUTHORITY_KEYID_st;

  SXNET_ID_st = record
    zone: PASN1_INTEGER;
    user: PASN1_OCTET_STRING;
  end;

  SXNETID = SXNET_ID_st;
  PSXNETID = ^SXNETID;
  PPSXNETID = ^PSXNETID;

  sk_SXNETID_compfunc = function(a: PPSXNETID; b: PPSXNETID): integer; cdecl;
  sk_SXNETID_freefunc = procedure(a: PSXNETID); cdecl;
  sk_SXNETID_copyfunc = function(a: PSXNETID): PSXNET_ID_st; cdecl;

  SXNET_st = record
    version: PASN1_INTEGER;
    ids: Pstack_st_SXNETID;
  end;

  SXNET = SXNET_st;
  PSXNET = ^SXNET;
  PPSXNET = ^PSXNET;

  NOTICEREF_st = record
    organization: PASN1_STRING;
    noticenos: Pstack_st_ASN1_INTEGER;
  end;

  NOTICEREF = NOTICEREF_st;
  PNOTICEREF = ^NOTICEREF;
  PPNOTICEREF = ^PNOTICEREF;

  USERNOTICE_st = record
    noticeref: PNOTICEREF;
    exptext: PASN1_STRING;
  end;

  USERNOTICE = USERNOTICE_st;
  PUSERNOTICE = ^USERNOTICE;
  PPUSERNOTICE = ^PUSERNOTICE;

  _anonymous_type_7 = record
    case integer of
      0: (cpsuri: PASN1_IA5STRING);
      1: (usernotice: PUSERNOTICE);
      2: (other: PASN1_TYPE);
  end;
  P_anonymous_type_7 = ^_anonymous_type_7;

  POLICYQUALINFO_st = record
    pqualid: PASN1_OBJECT;
    d: _anonymous_type_7;
  end;

  POLICYQUALINFO = POLICYQUALINFO_st;
  PPOLICYQUALINFO = ^POLICYQUALINFO;
  PPPOLICYQUALINFO = ^PPOLICYQUALINFO;

  sk_POLICYQUALINFO_compfunc = function(a: PPPOLICYQUALINFO; b: PPPOLICYQUALINFO): integer; cdecl;
  sk_POLICYQUALINFO_freefunc = procedure(a: PPOLICYQUALINFO); cdecl;
  sk_POLICYQUALINFO_copyfunc = function(a: PPOLICYQUALINFO): PPOLICYQUALINFO_st; cdecl;

  POLICYINFO_st = record
    policyid: PASN1_OBJECT;
    qualifiers: Pstack_st_POLICYQUALINFO;
  end;

  POLICYINFO = POLICYINFO_st;
  PPOLICYINFO = ^POLICYINFO;
  PPPOLICYINFO = ^PPOLICYINFO;
  PCERTIFICATEPOLICIES = pointer;
  PPCERTIFICATEPOLICIES = ^PCERTIFICATEPOLICIES;

  sk_POLICYINFO_compfunc = function(a: PPPOLICYINFO; b: PPPOLICYINFO): integer; cdecl;
  sk_POLICYINFO_freefunc = procedure(a: PPOLICYINFO); cdecl;
  sk_POLICYINFO_copyfunc = function(a: PPOLICYINFO): PPOLICYINFO_st; cdecl;

  POLICY_MAPPING_st = record
    issuerDomainPolicy: PASN1_OBJECT;
    subjectDomainPolicy: PASN1_OBJECT;
  end;

  POLICY_MAPPING = POLICY_MAPPING_st;
  PPOLICY_MAPPING = ^POLICY_MAPPING;
  PPPOLICY_MAPPING = ^PPOLICY_MAPPING;

  sk_POLICY_MAPPING_compfunc = function(a: PPPOLICY_MAPPING; b: PPPOLICY_MAPPING): integer; cdecl;
  sk_POLICY_MAPPING_freefunc = procedure(a: PPOLICY_MAPPING); cdecl;
  sk_POLICY_MAPPING_copyfunc = function(a: PPOLICY_MAPPING): PPOLICY_MAPPING_st; cdecl;

  PPOLICY_MAPPINGS = pointer;
  PPPOLICY_MAPPINGS = ^PPOLICY_MAPPINGS;

  GENERAL_SUBTREE_st = record
    base: PGENERAL_NAME;
    minimum: PASN1_INTEGER;
    maximum: PASN1_INTEGER;
  end;

  GENERAL_SUBTREE = GENERAL_SUBTREE_st;
  PGENERAL_SUBTREE = ^GENERAL_SUBTREE;
  PPGENERAL_SUBTREE = ^PGENERAL_SUBTREE;

  sk_GENERAL_SUBTREE_compfunc = function(a: PPGENERAL_SUBTREE; b: PPGENERAL_SUBTREE): integer; cdecl;
  sk_GENERAL_SUBTREE_freefunc = procedure(a: PGENERAL_SUBTREE); cdecl;
  sk_GENERAL_SUBTREE_copyfunc = function(a: PGENERAL_SUBTREE): PGENERAL_SUBTREE_st; cdecl;

  NAME_CONSTRAINTS_st = record
    permittedSubtrees: Pstack_st_GENERAL_SUBTREE;
    excludedSubtrees: Pstack_st_GENERAL_SUBTREE;
  end;
  NAME_CONSTRAINTS = NAME_CONSTRAINTS_st;
  PNAME_CONSTRAINTS = ^NAME_CONSTRAINTS;

  POLICY_CONSTRAINTS_st = record
    requireExplicitPolicy: PASN1_INTEGER;
    inhibitPolicyMapping: PASN1_INTEGER;
  end;

  POLICY_CONSTRAINTS = POLICY_CONSTRAINTS_st;
  PPOLICY_CONSTRAINTS = ^POLICY_CONSTRAINTS;

  PROXY_POLICY_st = record
    policyLanguage: PASN1_OBJECT;
    policy: PASN1_OCTET_STRING;
  end;

  PROXY_POLICY = PROXY_POLICY_st;
  PPROXY_POLICY = ^PROXY_POLICY;
  PPPROXY_POLICY = ^PPROXY_POLICY;

  PROXY_CERT_INFO_EXTENSION_st = record
    pcPathLengthConstraint: PASN1_INTEGER;
    proxyPolicy: PPROXY_POLICY;
  end;

  PROXY_CERT_INFO_EXTENSION = PROXY_CERT_INFO_EXTENSION_st;
  PPROXY_CERT_INFO_EXTENSION = ^PROXY_CERT_INFO_EXTENSION;
  PPPROXY_CERT_INFO_EXTENSION = ^PPROXY_CERT_INFO_EXTENSION;

  ISSUING_DIST_POINT_st = record
    distpoint: PDIST_POINT_NAME;
    onlyuser: integer;
    onlyCA: integer;
    onlysomereasons: PASN1_BIT_STRING;
    indirectCRL: integer;
    onlyattr: integer;
  end;
  ISSUING_DIST_POINT = ISSUING_DIST_POINT_st;

  x509_purpose_st = record
    purpose: integer;
    trust: integer;
    flags: integer;
    check_purpose: function(p1: Px509_purpose_st; p2: PX509; p3: integer): integer; cdecl;
    name: PUtf8Char;
    sname: PUtf8Char;
    usr_data: pointer;
  end;

  X509_PURPOSE = x509_purpose_st;
  PX509_PURPOSE = ^X509_PURPOSE;
  PPX509_PURPOSE = ^PX509_PURPOSE;

  sk_X509_PURPOSE_compfunc = function(a: PPX509_PURPOSE; b: PPX509_PURPOSE): integer; cdecl;
  sk_X509_PURPOSE_freefunc = procedure(a: PX509_PURPOSE); cdecl;
  sk_X509_PURPOSE_copyfunc = function(a: PX509_PURPOSE): Px509_purpose_st; cdecl;
  sk_X509_POLICY_NODE_compfunc = function(a: PPX509_POLICY_NODE; b: PPX509_POLICY_NODE): integer; cdecl;
  sk_X509_POLICY_NODE_freefunc = procedure(a: PX509_POLICY_NODE); cdecl;
  sk_X509_POLICY_NODE_copyfunc = function(a: PX509_POLICY_NODE): PX509_POLICY_NODE_st; cdecl;

  ASRange_st = record
    min: PASN1_INTEGER;
    max: PASN1_INTEGER;
  end;

  ASRange = ASRange_st;
  PASRange = ^ASRange;
  PPASRange = ^PASRange;

  _anonymous_type_8 = record
    case integer of
      0: (id: PASN1_INTEGER);
      1: (range: PASRange);
  end;
  P_anonymous_type_8 = ^_anonymous_type_8;

  ASIdOrRange_st = record
    asitype: integer;
    u: _anonymous_type_8;
  end;

  ASIdOrRange = ASIdOrRange_st;
  PASIdOrRange = ^ASIdOrRange;
  PPASIdOrRange = ^PASIdOrRange;
  PASIdOrRanges = pointer;
  PPASIdOrRanges = ^PASIdOrRanges;

  sk_ASIdOrRange_compfunc = function(a: PPASIdOrRange; b: PPASIdOrRange): integer; cdecl;
  sk_ASIdOrRange_freefunc = procedure(a: PASIdOrRange); cdecl;
  sk_ASIdOrRange_copyfunc = function(a: PASIdOrRange): PASIdOrRange_st; cdecl;

  _anonymous_type_9 = record
    case integer of
      0: (inherit: PASN1_NULL);
      1: (asIdsOrRanges: PASIdOrRanges);
  end;
  P_anonymous_type_9 = ^_anonymous_type_9;

  ASIdentifierChoice_st = record
    asitype: integer;
    u: _anonymous_type_9;
  end;

  ASIdentifierChoice = ASIdentifierChoice_st;
  PASIdentifierChoice = ^ASIdentifierChoice;
  PPASIdentifierChoice = ^PASIdentifierChoice;

  ASIdentifiers_st = record
    asnum: PASIdentifierChoice;
    rdi: PASIdentifierChoice;
  end;

  ASIdentifiers = ASIdentifiers_st;
  PASIdentifiers = ^ASIdentifiers;
  PPASIdentifiers = ^PASIdentifiers;

  IPAddressRange_st = record
    min: PASN1_BIT_STRING;
    max: PASN1_BIT_STRING;
  end;

  IPAddressRange = IPAddressRange_st;
  PIPAddressRange = ^IPAddressRange;
  PPIPAddressRange = ^PIPAddressRange;

  _anonymous_type_10 = record
    case integer of
      0: (addressPrefix: PASN1_BIT_STRING);
      1: (addressRange: PIPAddressRange);
  end;
  P_anonymous_type_10 = ^_anonymous_type_10;

  IPAddressOrRange_st = record
    iptype: integer;
    u: _anonymous_type_10;
  end;

  IPAddressOrRange = IPAddressOrRange_st;
  PIPAddressOrRange = ^IPAddressOrRange;
  PPIPAddressOrRange = ^PIPAddressOrRange;
  PIPAddressOrRanges = pointer;
  PPIPAddressOrRanges = ^PIPAddressOrRanges;

  sk_IPAddressOrRange_compfunc = function(a: PPIPAddressOrRange; b: PPIPAddressOrRange): integer; cdecl;
  sk_IPAddressOrRange_freefunc = procedure(a: PIPAddressOrRange); cdecl;
  sk_IPAddressOrRange_copyfunc = function(a: PIPAddressOrRange): PIPAddressOrRange_st; cdecl;

  _anonymous_type_11 = record
    case integer of
      0: (inherit: PASN1_NULL);
      1: (addressesOrRanges: PIPAddressOrRanges);
  end;
  P_anonymous_type_11 = ^_anonymous_type_11;

  IPAddressChoice_st = record
    iptype: integer;
    u: _anonymous_type_11;
  end;

  IPAddressChoice = IPAddressChoice_st;
  PIPAddressChoice = ^IPAddressChoice;
  PPIPAddressChoice = ^PIPAddressChoice;

  IPAddressFamily_st = record
    addressFamily: PASN1_OCTET_STRING;
    ipAddressChoice: PIPAddressChoice;
  end;

  IPAddressFamily = IPAddressFamily_st;
  PIPAddressFamily = ^IPAddressFamily;
  PPIPAddressFamily = ^PIPAddressFamily;
  PIPAddrBlocks = pointer;
  PPIPAddrBlocks = ^PIPAddrBlocks;

  sk_IPAddressFamily_compfunc = function(a: PPIPAddressFamily; b: PPIPAddressFamily): integer; cdecl;
  sk_IPAddressFamily_freefunc = procedure(a: PIPAddressFamily); cdecl;
  sk_IPAddressFamily_copyfunc = function(a: PIPAddressFamily): PIPAddressFamily_st; cdecl;

  sk_ASN1_STRING_compfunc = function(a: PPASN1_STRING; b: PPASN1_STRING): integer; cdecl;
  sk_ASN1_STRING_freefunc = procedure(a: PASN1_STRING); cdecl;
  sk_ASN1_STRING_copyfunc = function(a: PASN1_STRING): Pasn1_string_st; cdecl;

  PNAMING_AUTHORITY = pointer;
  PPNAMING_AUTHORITY = ^PNAMING_AUTHORITY;
  PPROFESSION_INFO = pointer;
  PPPROFESSION_INFO = ^PPROFESSION_INFO;
  PADMISSIONS = pointer;
  PPADMISSIONS = ^PADMISSIONS;
  PADMISSION_SYNTAX = pointer;
  PPADMISSION_SYNTAX = ^PADMISSION_SYNTAX;

  sk_ADMISSIONS_compfunc = function(a: PPADMISSIONS; b: PPADMISSIONS): integer; cdecl;
  sk_ADMISSIONS_freefunc = procedure(a: PADMISSIONS); cdecl;
  sk_ADMISSIONS_copyfunc = function(a: PADMISSIONS): PAdmissions_st; cdecl;

  sk_PROFESSION_INFO_compfunc = function(a: PPPROFESSION_INFO; b: PPPROFESSION_INFO): integer; cdecl;
  sk_PROFESSION_INFO_freefunc = procedure(a: PPROFESSION_INFO); cdecl;
  sk_PROFESSION_INFO_copyfunc = function(a: PPROFESSION_INFO): PProfessionInfo_st; cdecl;

  PPROFESSION_INFOS = pointer;
  PPPROFESSION_INFOS = ^PPROFESSION_INFOS;

  PCMS_ContentInfo = pointer;
  PPCMS_ContentInfo = ^PCMS_ContentInfo;
  PCMS_SignerInfo = pointer;
  PPCMS_SignerInfo = ^PCMS_SignerInfo;
  PCMS_CertificateChoices = pointer;
  PPCMS_CertificateChoices = ^PCMS_CertificateChoices;
  PCMS_RevocationInfoChoice = pointer;
  PPCMS_RevocationInfoChoice = ^PCMS_RevocationInfoChoice;
  PCMS_RecipientInfo = pointer;
  PPCMS_RecipientInfo = ^PCMS_RecipientInfo;
  PCMS_ReceiptRequest = pointer;
  PPCMS_ReceiptRequest = ^PCMS_ReceiptRequest;
  PCMS_Receipt = pointer;
  PPCMS_Receipt = ^PCMS_Receipt;
  PCMS_RecipientEncryptedKey = pointer;
  PPCMS_RecipientEncryptedKey = ^PCMS_RecipientEncryptedKey;
  PCMS_OtherKeyAttribute = pointer;
  PPCMS_OtherKeyAttribute = ^PCMS_OtherKeyAttribute;

  sk_CMS_SignerInfo_compfunc = function(a: PPCMS_SignerInfo; b: PPCMS_SignerInfo): integer; cdecl;
  sk_CMS_SignerInfo_freefunc = procedure(a: PCMS_SignerInfo); cdecl;
  sk_CMS_SignerInfo_copyfunc = function(a: PCMS_SignerInfo): PCMS_SignerInfo_st; cdecl;
  sk_CMS_RecipientEncryptedKey_compfunc = function(a: PPCMS_RecipientEncryptedKey; b: PPCMS_RecipientEncryptedKey): integer; cdecl;
  sk_CMS_RecipientEncryptedKey_freefunc = procedure(a: PCMS_RecipientEncryptedKey); cdecl;
  sk_CMS_RecipientEncryptedKey_copyfunc = function(a: PCMS_RecipientEncryptedKey): PCMS_RecipientEncryptedKey_st; cdecl;
  sk_CMS_RecipientInfo_compfunc = function(a: PPCMS_RecipientInfo; b: PPCMS_RecipientInfo): integer; cdecl;
  sk_CMS_RecipientInfo_freefunc = procedure(a: PCMS_RecipientInfo); cdecl;
  sk_CMS_RecipientInfo_copyfunc = function(a: PCMS_RecipientInfo): PCMS_RecipientInfo_st; cdecl;
  sk_CMS_RevocationInfoChoice_compfunc = function(a: PPCMS_RevocationInfoChoice; b: PPCMS_RevocationInfoChoice): integer; cdecl;
  sk_CMS_RevocationInfoChoice_freefunc = procedure(a: PCMS_RevocationInfoChoice); cdecl;
  sk_CMS_RevocationInfoChoice_copyfunc = function(a: PCMS_RevocationInfoChoice): PCMS_RevocationInfoChoice_st; cdecl;

  ct_log_entry_type_t = (
    CT_LOG_ENTRY_TYPE_NOT_SET = -1,
    CT_LOG_ENTRY_TYPE_X509 = 0,
    CT_LOG_ENTRY_TYPE_PRECERT = 1);
  Pct_log_entry_type_t = ^ct_log_entry_type_t;

  sct_version_t = (
    SCT_VERSION_NOT_SET = -1,
    SCT_VERSION_V1 = 0);
  Psct_version_t = ^sct_version_t;

  sct_source_t = (
    SCT_SOURCE_UNKNOWN = 0,
    SCT_SOURCE_TLS_EXTENSION = 1,
    SCT_SOURCE_X509V3_EXTENSION = 2,
    SCT_SOURCE_OCSP_STAPLED_RESPONSE = 3);
  Psct_source_t = ^sct_source_t;

  sct_validation_status_t = (
    SCT_VALIDATION_STATUS_NOT_SET = 0,
    SCT_VALIDATION_STATUS_UNKNOWN_LOG = 1,
    SCT_VALIDATION_STATUS_VALID = 2,
    SCT_VALIDATION_STATUS_INVALID = 3,
    SCT_VALIDATION_STATUS_UNVERIFIED = 4,
    SCT_VALIDATION_STATUS_UNKNOWN_VERSION = 5);
  Psct_validation_status_t = ^sct_validation_status_t;

  sk_SCT_compfunc = function(a: PPSCT; b: PPSCT): integer; cdecl;
  sk_SCT_freefunc = procedure(a: PSCT); cdecl;
  sk_SCT_copyfunc = function(a: PSCT): Psct_st; cdecl;
  sk_CTLOG_compfunc = function(a: PPCTLOG; b: PPCTLOG): integer; cdecl;
  sk_CTLOG_freefunc = procedure(a: PCTLOG); cdecl;
  sk_CTLOG_copyfunc = function(a: PCTLOG): Pctlog_st; cdecl;

  DES_LONG = cardinal;
  PDES_LONG = ^DES_LONG;
  DES_cblock = array [0..7] of Byte;
  PDES_cblock = ^DES_cblock;
  const_DES_cblock = array [0..7] of Byte;
  Pconst_DES_cblock = ^const_DES_cblock;

  _anonymous_type_12 = record
    case integer of
      0: (cblock: DES_cblock);
      1: (deslong: array [0..1] of DES_LONG);
  end;
  P_anonymous_type_12 = ^_anonymous_type_12;

  DES_ks = record
    ks: array [0..15] of _anonymous_type_12;
  end;

  DES_key_schedule = DES_ks;
  PDES_key_schedule = ^DES_key_schedule;

  rand_meth_st = record
    seed: function(buf: pointer; num: integer): integer; cdecl;
    bytes: function(buf: PByte; num: integer): integer; cdecl;
    cleanup: procedure(); cdecl;
    add: function(buf: pointer; num: integer; randomness: Double): integer; cdecl;
    pseudorand: function(buf: PByte; num: integer): integer; cdecl;
    status: function(): integer; cdecl;
  end;

  RAND_METHOD = rand_meth_st;
  PRAND_METHOD = ^RAND_METHOD;
  PRAND_DRBG = pointer;
  PPRAND_DRBG = ^PRAND_DRBG;

  PUI_STRING = pointer;
  PPUI_STRING = ^PUI_STRING;

  sk_UI_STRING_compfunc = function(a: PPUI_STRING; b: PPUI_STRING): integer; cdecl;
  sk_UI_STRING_freefunc = procedure(a: PUI_STRING); cdecl;
  sk_UI_STRING_copyfunc = function(a: PUI_STRING): Pui_string_st; cdecl;

  UI_string_types = (
    UIT_NONE = 0,
    UIT_PROMPT = 1,
    UIT_VERIFY = 2,
    UIT_BOOLEAN = 3,
    UIT_INFO = 4,
    UIT_ERROR = 5);
  PUI_string_types = ^UI_string_types;

  err_state_st = record
    err_flags: array [0..15] of integer;
    err_buffer: array [0..15] of cardinal;
    err_data: array [0..15] of PUtf8Char;
    err_data_flags: array [0..15] of integer;
    err_file: array [0..15] of PUtf8Char;
    err_line: array [0..15] of integer;
    top: integer;
    bottom: integer;
  end;

  ERR_STATE = err_state_st;
  PERR_STATE = ^ERR_STATE;

  ERR_string_data_st = record
    error: cardinal;
    _string: PUtf8Char;
  end;

  ERR_STRING_DATA = ERR_string_data_st;
  PERR_STRING_DATA = ^ERR_STRING_DATA;

  lh_ERR_STRING_DATA_dummy = record
    case integer of
      0: (d1: pointer);
      1: (d2: cardinal);
      2: (d3: integer);
  end;

  lhash_st_ERR_STRING_DATA = record
    dummy: lh_ERR_STRING_DATA_dummy;
  end;

  ENGINE_CMD_DEFN_st = record
    cmd_num: cardinal;
    cmd_name: PUtf8Char;
    cmd_desc: PUtf8Char;
    cmd_flags: cardinal;
  end;

  ENGINE_CMD_DEFN = ENGINE_CMD_DEFN_st;
  PENGINE_CMD_DEFN = ^ENGINE_CMD_DEFN;

  ENGINE_GEN_FUNC_PTR = function(): integer; cdecl;
  ENGINE_GEN_INT_FUNC_PTR = function(p1: PENGINE): integer; cdecl;
  ENGINE_CTRL_FUNC_PTR_f = pointer;
  ENGINE_CTRL_FUNC_PTR = function(p1: PENGINE; p2: integer; p3: integer; p4: pointer; f: ENGINE_CTRL_FUNC_PTR_f): integer; cdecl;
  ENGINE_LOAD_KEY_PTR = function(p1: PENGINE; p2: PUtf8Char; ui_method: PUI_METHOD; callback_data: pointer): Pevp_pkey_st; cdecl;
  ENGINE_SSL_CLIENT_CERT_PTR = function(p1: PENGINE; ssl: PSSL; ca_dn: Pstack_st_X509_NAME; pcert: PPX509; pkey: PPEVP_PKEY; pother: PPstack_st_X509; ui_method: PUI_METHOD; callback_data: pointer): integer; cdecl;
  ENGINE_CIPHERS_PTR = function(p1: PENGINE; p2: PPEVP_CIPHER; p3: PPInteger; p4: integer): integer; cdecl;
  ENGINE_DIGESTS_PTR = function(p1: PENGINE; p2: PPEVP_MD; p3: PPInteger; p4: integer): integer; cdecl;
  ENGINE_PKEY_METHS_PTR = function(p1: PENGINE; p2: PPEVP_PKEY_METHOD; p3: PPInteger; p4: integer): integer; cdecl;
  ENGINE_PKEY_ASN1_METHS_PTR = function(p1: PENGINE; p2: PPEVP_PKEY_ASN1_METHOD; p3: PPInteger; p4: integer): integer; cdecl;

  st_dynamic_MEM_fns = record
    malloc_fn: dyn_MEM_malloc_fn;
    realloc_fn: dyn_MEM_realloc_fn;
    free_fn: dyn_MEM_free_fn;
  end;

  dynamic_MEM_fns = st_dynamic_MEM_fns;

  st_dynamic_fns = record
    static_state: pointer;
    mem_fns: dynamic_MEM_fns;
  end;

  dynamic_fns = st_dynamic_fns;
  Pdynamic_fns = ^dynamic_fns;

  dynamic_v_check_fn = function(ossl_version: cardinal): cardinal; cdecl;
  dynamic_bind_engine = function(e: PENGINE; id: PUtf8Char; fns: Pdynamic_fns): integer; cdecl;

  IDEA_INT = cardinal;

  idea_key_st = record
    data: array [0..8] of array [0..5] of IDEA_INT;
  end;

  IDEA_KEY_SCHEDULE = idea_key_st;
  PIDEA_KEY_SCHEDULE = ^IDEA_KEY_SCHEDULE;

  MD4state_st = record
    A: cardinal;
    B: cardinal;
    C: cardinal;
    D: cardinal;
    Nl: cardinal;
    Nh: cardinal;
    data: array [0..15] of cardinal;
    num: cardinal;
  end;

  MD4_CTX = MD4state_st;
  PMD4_CTX = ^MD4_CTX;

  MD5state_st = record
    A: cardinal;
    B: cardinal;
    C: cardinal;
    D: cardinal;
    Nl: cardinal;
    Nh: cardinal;
    data: array [0..15] of cardinal;
    num: cardinal;
  end;

  MD5_CTX = MD5state_st;
  PMD5_CTX = ^MD5_CTX;

  mdc2_ctx_st = record
    num: cardinal;
    data: array [0..7] of Byte;
    h: DES_cblock;
    hh: DES_cblock;
    pad_type: integer;
  end;

  MDC2_CTX = mdc2_ctx_st;
  PMDC2_CTX = ^MDC2_CTX;

  block128_f = procedure(_in: PByte; _out: PByte; key: pointer); cdecl;
  cbc128_f = procedure(_in: PByte; _out: PByte; len: PtrUInt; key: pointer; ivec: PByte; enc: integer); cdecl;
  ctr128_f = procedure(_in: PByte; _out: PByte; blocks: PtrUInt; key: pointer; ivec: PByte); cdecl;
  ccm128_f = procedure(_in: PByte; _out: PByte; blocks: PtrUInt; key: pointer; ivec: PByte; cmac: PByte); cdecl;

  PGCM128_CONTEXT = pointer;
  PPGCM128_CONTEXT = ^PGCM128_CONTEXT;
  PCCM128_CONTEXT = pointer;
  PPCCM128_CONTEXT = ^PCCM128_CONTEXT;
  PXTS128_CONTEXT = pointer;
  PPXTS128_CONTEXT = ^PXTS128_CONTEXT;
  POCB128_CONTEXT = pointer;
  PPOCB128_CONTEXT = ^POCB128_CONTEXT;

  PArray = pointer;

  ocb128_f = procedure(_in: PByte; _out: PByte; blocks: PtrUInt; key: pointer;
    start_block_num: PtrUInt; offset_i: PByte; L_: PArray {Parray [0..15] of Byte};
    checksum: PByte); cdecl;

  POCSP_CERTID = pointer;
  PPOCSP_CERTID = ^POCSP_CERTID;

  sk_OCSP_CERTID_compfunc = function(a: PPOCSP_CERTID; b: PPOCSP_CERTID): integer; cdecl;
  sk_OCSP_CERTID_freefunc = procedure(a: POCSP_CERTID); cdecl;
  sk_OCSP_CERTID_copyfunc = function(a: POCSP_CERTID): Pocsp_cert_id_st; cdecl;

  POCSP_ONEREQ = pointer;
  PPOCSP_ONEREQ = ^POCSP_ONEREQ;

  sk_OCSP_ONEREQ_compfunc = function(a: PPOCSP_ONEREQ; b: PPOCSP_ONEREQ): integer; cdecl;
  sk_OCSP_ONEREQ_freefunc = procedure(a: POCSP_ONEREQ); cdecl;
  sk_OCSP_ONEREQ_copyfunc = function(a: POCSP_ONEREQ): Pocsp_one_request_st; cdecl;

  POCSP_REQINFO = pointer;
  PPOCSP_REQINFO = ^POCSP_REQINFO;
  POCSP_SIGNATURE = pointer;
  PPOCSP_SIGNATURE = ^POCSP_SIGNATURE;
  POCSP_REQUEST = pointer;
  PPOCSP_REQUEST = ^POCSP_REQUEST;
  POCSP_RESPBYTES = pointer;
  PPOCSP_RESPBYTES = ^POCSP_RESPBYTES;

  sk_OCSP_RESPID_compfunc = function(a: PPOCSP_RESPID; b: PPOCSP_RESPID): integer; cdecl;
  sk_OCSP_RESPID_freefunc = procedure(a: POCSP_RESPID); cdecl;
  sk_OCSP_RESPID_copyfunc = function(a: POCSP_RESPID): Pocsp_responder_id_st; cdecl;

  POCSP_REVOKEDINFO = pointer;
  PPOCSP_REVOKEDINFO = ^POCSP_REVOKEDINFO;
  POCSP_CERTSTATUS = pointer;
  PPOCSP_CERTSTATUS = ^POCSP_CERTSTATUS;
  POCSP_SINGLERESP = pointer;
  PPOCSP_SINGLERESP = ^POCSP_SINGLERESP;

  sk_OCSP_SINGLERESP_compfunc = function(a: PPOCSP_SINGLERESP; b: PPOCSP_SINGLERESP): integer; cdecl;
  sk_OCSP_SINGLERESP_freefunc = procedure(a: POCSP_SINGLERESP); cdecl;
  sk_OCSP_SINGLERESP_copyfunc = function(a: POCSP_SINGLERESP): Pocsp_single_response_st; cdecl;

  POCSP_RESPDATA = pointer;
  PPOCSP_RESPDATA = ^POCSP_RESPDATA;
  POCSP_BASICRESP = pointer;
  PPOCSP_BASICRESP = ^POCSP_BASICRESP;
  POCSP_CRLID = pointer;
  PPOCSP_CRLID = ^POCSP_CRLID;
  POCSP_SERVICELOC = pointer;
  PPOCSP_SERVICELOC = ^POCSP_SERVICELOC;
  PPKCS12_MAC_DATA = pointer;
  PPPKCS12_MAC_DATA = ^PPKCS12_MAC_DATA;

  sk_PKCS12_SAFEBAG_compfunc = function(a: PPPKCS12_SAFEBAG; b: PPPKCS12_SAFEBAG): integer; cdecl;
  sk_PKCS12_SAFEBAG_freefunc = procedure(a: PPKCS12_SAFEBAG); cdecl;
  sk_PKCS12_SAFEBAG_copyfunc = function(a: PPKCS12_SAFEBAG): PPKCS12_SAFEBAG_st; cdecl;

  PPKCS12_BAGS = pointer;
  PPPKCS12_BAGS = ^PPKCS12_BAGS;

  RAND_DRBG_get_entropy_fn = function(drbg: PRAND_DRBG; pout: PPByte; entropy: integer; min_len: PtrUInt; max_len: PtrUInt; prediction_resistance: integer): Qword; cdecl;
  RAND_DRBG_cleanup_entropy_fn = procedure(ctx: PRAND_DRBG; _out: PByte; outlen: PtrUInt); cdecl;
  RAND_DRBG_get_nonce_fn = function(drbg: PRAND_DRBG; pout: PPByte; entropy: integer; min_len: PtrUInt; max_len: PtrUInt): Qword; cdecl;
  RAND_DRBG_cleanup_nonce_fn = procedure(drbg: PRAND_DRBG; _out: PByte; outlen: PtrUInt); cdecl;

  RC2_INT = cardinal;

  rc2_key_st = record
    data: array [0..63] of RC2_INT;
  end;

  RC2_KEY = rc2_key_st;
  PRC2_KEY = ^RC2_KEY;

  rc4_key_st = record
    x: cardinal;
    y: cardinal;
    data: array [0..255] of cardinal;
  end;

  RC4_KEY = rc4_key_st;
  PRC4_KEY = ^RC4_KEY;

  RIPEMD160state_st = record
    A: cardinal;
    B: cardinal;
    C: cardinal;
    D: cardinal;
    E: cardinal;
    Nl: cardinal;
    Nh: cardinal;
    data: array [0..15] of cardinal;
    num: cardinal;
  end;

  RIPEMD160_CTX = RIPEMD160state_st;
  PRIPEMD160_CTX = ^RIPEMD160_CTX;

  seed_key_st = record
    data: array [0..31] of cardinal;
  end;

  SEED_KEY_SCHEDULE = seed_key_st;
  PSEED_KEY_SCHEDULE = ^SEED_KEY_SCHEDULE;

  SRP_gN_cache_st = record
    b64_bn: PUtf8Char;
    bn: PBIGNUM;
  end;

  SRP_gN_cache = SRP_gN_cache_st;
  PSRP_gN_cache = ^SRP_gN_cache;
  PPSRP_gN_cache = ^PSRP_gN_cache;

  sk_SRP_gN_cache_compfunc = function(a: PPSRP_gN_cache; b: PPSRP_gN_cache): integer; cdecl;
  sk_SRP_gN_cache_freefunc = procedure(a: PSRP_gN_cache); cdecl;
  sk_SRP_gN_cache_copyfunc = function(a: PSRP_gN_cache): PSRP_gN_cache_st; cdecl;

  SRP_user_pwd_st = record
    id: PUtf8Char;
    s: PBIGNUM;
    v: PBIGNUM;
    g: PBIGNUM;
    N: PBIGNUM;
    info: PUtf8Char;
  end;

  SRP_user_pwd = SRP_user_pwd_st;
  PSRP_user_pwd = ^SRP_user_pwd;
  PPSRP_user_pwd = ^PSRP_user_pwd;

  sk_SRP_user_pwd_compfunc = function(a: PPSRP_user_pwd; b: PPSRP_user_pwd): integer; cdecl;
  sk_SRP_user_pwd_freefunc = procedure(a: PSRP_user_pwd); cdecl;
  sk_SRP_user_pwd_copyfunc = function(a: PSRP_user_pwd): PSRP_user_pwd_st; cdecl;

  SRP_VBASE_st = record
    users_pwd: Pstack_st_SRP_user_pwd;
    gN_cache: Pstack_st_SRP_gN_cache;
    seed_key: PUtf8Char;
    default_g: PBIGNUM;
    default_N: PBIGNUM;
  end;

  SRP_VBASE = SRP_VBASE_st;
  PSRP_VBASE = ^SRP_VBASE;

  SRP_gN_st = record
    id: PUtf8Char;
    g: PBIGNUM;
    N: PBIGNUM;
  end;

  SRP_gN = SRP_gN_st;
  PSRP_gN = ^SRP_gN;
  PPSRP_gN = ^PSRP_gN;

  sk_SRP_gN_compfunc = function(a: PPSRP_gN; b: PPSRP_gN): integer; cdecl;
  sk_SRP_gN_freefunc = procedure(a: PSRP_gN); cdecl;
  sk_SRP_gN_copyfunc = function(a: PSRP_gN): PSRP_gN_st; cdecl;

  ssl_crock_st = pointer;
  Pssl_crock_st = ^ssl_crock_st;
  PTLS_SIGALGS = pointer;
  PPTLS_SIGALGS = ^PTLS_SIGALGS;
  PSSL_CONF_CTX = pointer;
  PPSSL_CONF_CTX = ^PSSL_CONF_CTX;
  PSSL_COMP = pointer;
  PPSSL_COMP = ^PSSL_COMP;

  srtp_protection_profile_st = record
    name: PUtf8Char;
    id: cardinal;
  end;

  SRTP_PROTECTION_PROFILE = srtp_protection_profile_st;
  PSRTP_PROTECTION_PROFILE = ^SRTP_PROTECTION_PROFILE;
  PPSRTP_PROTECTION_PROFILE = ^PSRTP_PROTECTION_PROFILE;

  sk_SRTP_PROTECTION_PROFILE_compfunc = function(a: PPSRTP_PROTECTION_PROFILE; b: PPSRTP_PROTECTION_PROFILE): integer; cdecl;
  sk_SRTP_PROTECTION_PROFILE_freefunc = procedure(a: PSRTP_PROTECTION_PROFILE); cdecl;
  sk_SRTP_PROTECTION_PROFILE_copyfunc = function(a: PSRTP_PROTECTION_PROFILE): Psrtp_protection_profile_st; cdecl;
  tls_session_ticket_ext_cb_fn = function(s: PSSL; data: PByte; len: integer; arg: pointer): integer; cdecl;
  tls_session_secret_cb_fn = function(s: PSSL; secret: pointer; secret_len: PInteger; peer_ciphers: Pstack_st_SSL_CIPHER; cipher: PPSSL_CIPHER; arg: pointer): integer; cdecl;
  custom_ext_add_cb = function(s: PSSL; ext_type: cardinal; _out: PPByte; outlen: PPtrUInt; al: PInteger; add_arg: pointer): integer; cdecl;
  custom_ext_free_cb = procedure(s: PSSL; ext_type: cardinal; _out: PByte; add_arg: pointer); cdecl;
  custom_ext_parse_cb = function(s: PSSL; ext_type: cardinal; _in: PByte; inlen: PtrUInt; al: PInteger; parse_arg: pointer): integer; cdecl;
  SSL_custom_ext_add_cb_ex = function(s: PSSL; ext_type: cardinal; context: cardinal; _out: PPByte; outlen: PPtrUInt; x: PX509; chainidx: PtrUInt; al: PInteger; add_arg: pointer): integer; cdecl;
  SSL_custom_ext_free_cb_ex = procedure(s: PSSL; ext_type: cardinal; context: cardinal; _out: PByte; add_arg: pointer); cdecl;
  SSL_custom_ext_parse_cb_ex = function(s: PSSL; ext_type: cardinal; context: cardinal; _in: PByte; inlen: PtrUInt; x: PX509; chainidx: PtrUInt; al: PInteger; parse_arg: pointer): integer; cdecl;
  GEN_SESSION_CB = function(ssl: PSSL; id: PByte; id_len: PCardinal): integer; cdecl;
  SSL_CTX_npn_advertised_cb_func = function(ssl: PSSL; _out: PPByte; outlen: PCardinal; arg: pointer): integer; cdecl;
  SSL_CTX_npn_select_cb_func = function(s: PSSL; _out: PPByte; outlen: PByte; _in: PByte; inlen: cardinal; arg: pointer): integer; cdecl;
  SSL_CTX_alpn_select_cb_func = function(ssl: PSSL; _out: PPByte; outlen: PByte; _in: PByte; inlen: cardinal; arg: pointer): integer; cdecl;
  SSL_psk_client_cb_func = function(ssl: PSSL; hint: PUtf8Char; identity: PUtf8Char; max_identity_len: cardinal; psk: PByte; max_psk_len: cardinal): cardinal; cdecl;
  SSL_psk_server_cb_func = function(ssl: PSSL; identity: PUtf8Char; psk: PByte; max_psk_len: cardinal): cardinal; cdecl;
  SSL_psk_find_session_cb_func = function(ssl: PSSL; identity: PByte; identity_len: PtrUInt; sess: PPSSL_SESSION): integer; cdecl;
  SSL_psk_use_session_cb_func = function(ssl: PSSL; md: PEVP_MD; id: PPByte; idlen: PPtrUInt; sess: PPSSL_SESSION): integer; cdecl;
  SSL_CTX_keylog_cb_func = procedure(ssl: PSSL; line: PUtf8Char); cdecl;

  tls_session_ticket_ext_st = record
    length: Word;
    data: pointer;
  end;
  TLS_SESSION_TICKET_EXT = tls_session_ticket_ext_st;

  sk_SSL_CIPHER_compfunc = function(a: PPSSL_CIPHER; b: PPSSL_CIPHER): integer; cdecl;
  sk_SSL_CIPHER_freefunc = procedure(a: PSSL_CIPHER); cdecl;
  sk_SSL_CIPHER_copyfunc = function(a: PSSL_CIPHER): Pssl_cipher_st; cdecl;
  sk_SSL_COMP_compfunc = function(a: PPSSL_COMP; b: PPSSL_COMP): integer; cdecl;
  sk_SSL_COMP_freefunc = procedure(a: PSSL_COMP); cdecl;
  sk_SSL_COMP_copyfunc = function(a: PSSL_COMP): Pssl_comp_st; cdecl;

  SSL_client_hello_cb_fn = function(s: PSSL; al: PInteger; arg: pointer): integer; cdecl;
  ssl_ct_validation_cb = function(ctx: PCT_POLICY_EVAL_CTX; scts: Pstack_st_SCT; arg: pointer): integer; cdecl;

  _anonymous_type_13 = (
    SSL_CT_VALIDATION_PERMISSIVE = 0,
    SSL_CT_VALIDATION_STRICT = 1);
  P_anonymous_type_13 = ^_anonymous_type_13;
  SSL_TICKET_STATUS = integer;
  SSL_TICKET_RETURN = integer;

  SSL_CTX_generate_session_ticket_fn = function(s: PSSL; arg: pointer): integer; cdecl;
  SSL_CTX_decrypt_session_ticket_fn = function(s: PSSL; ss: PSSL_SESSION; keyname: PByte; keyname_length: PtrUInt; status: SSL_TICKET_STATUS; arg: pointer): integer; cdecl;
  DTLS_timer_cb = function(s: PSSL; timer_us: cardinal): cardinal; cdecl;
  SSL_allow_early_data_cb_fn = function(s: PSSL; arg: pointer): integer; cdecl;

  POSSL_STORE_CTX = pointer;
  PPOSSL_STORE_CTX = ^POSSL_STORE_CTX;

  OSSL_STORE_post_process_info_fn = function(p1: POSSL_STORE_INFO; p2: pointer): Possl_store_info_st; cdecl;

  POSSL_STORE_LOADER = pointer;
  PPOSSL_STORE_LOADER = ^POSSL_STORE_LOADER;
  POSSL_STORE_LOADER_CTX = pointer;
  PPOSSL_STORE_LOADER_CTX = ^POSSL_STORE_LOADER_CTX;

  OSSL_STORE_open_fn = function(loader: POSSL_STORE_LOADER; uri: PUtf8Char; ui_method: PUI_METHOD; ui_data: pointer): Possl_store_loader_ctx_st; cdecl;
  OSSL_STORE_ctrl_fn = function(ctx: POSSL_STORE_LOADER_CTX; cmd: integer; args: pointer): integer; cdecl;
  OSSL_STORE_expect_fn = function(ctx: POSSL_STORE_LOADER_CTX; expected: integer): integer; cdecl;
  OSSL_STORE_find_fn = function(ctx: POSSL_STORE_LOADER_CTX; criteria: POSSL_STORE_SEARCH): integer; cdecl;
  OSSL_STORE_load_fn = function(ctx: POSSL_STORE_LOADER_CTX; ui_method: PUI_METHOD; ui_data: pointer): Possl_store_info_st; cdecl;
  OSSL_STORE_eof_fn = function(ctx: POSSL_STORE_LOADER_CTX): integer; cdecl;
  OSSL_STORE_error_fn = function(ctx: POSSL_STORE_LOADER_CTX): integer; cdecl;
  OSSL_STORE_close_fn = function(ctx: POSSL_STORE_LOADER_CTX): integer; cdecl;

  PTS_MSG_IMPRINT = pointer;
  PPTS_MSG_IMPRINT = ^PTS_MSG_IMPRINT;
  PTS_REQ = pointer;
  PPTS_REQ = ^PTS_REQ;
  PTS_ACCURACY = pointer;
  PPTS_ACCURACY = ^PTS_ACCURACY;
  PTS_TST_INFO = pointer;
  PPTS_TST_INFO = ^PTS_TST_INFO;
  PTS_STATUS_INFO = pointer;
  PPTS_STATUS_INFO = ^PTS_STATUS_INFO;
  PESS_ISSUER_SERIAL = pointer;
  PPESS_ISSUER_SERIAL = ^PESS_ISSUER_SERIAL;
  PESS_CERT_ID = pointer;
  PPESS_CERT_ID = ^PESS_CERT_ID;
  PESS_SIGNING_CERT = pointer;
  PPESS_SIGNING_CERT = ^PESS_SIGNING_CERT;

  sk_ESS_CERT_ID_compfunc = function(a: PPESS_CERT_ID; b: PPESS_CERT_ID): integer; cdecl;
  sk_ESS_CERT_ID_freefunc = procedure(a: PESS_CERT_ID); cdecl;
  sk_ESS_CERT_ID_copyfunc = function(a: PESS_CERT_ID): PESS_cert_id; cdecl;

  PESS_CERT_ID_V2 = pointer;
  PPESS_CERT_ID_V2 = ^PESS_CERT_ID_V2;
  PESS_SIGNING_CERT_V2 = pointer;
  PPESS_SIGNING_CERT_V2 = ^PESS_SIGNING_CERT_V2;

  sk_ESS_CERT_ID_V2_compfunc = function(a: PPESS_CERT_ID_V2; b: PPESS_CERT_ID_V2): integer; cdecl;
  sk_ESS_CERT_ID_V2_freefunc = procedure(a: PESS_CERT_ID_V2); cdecl;
  sk_ESS_CERT_ID_V2_copyfunc = function(a: PESS_CERT_ID_V2): PESS_cert_id_v2_st; cdecl;

  PTS_RESP = pointer;
  PPTS_RESP = ^PTS_RESP;

  PTS_RESP_CTX = pointer;
  PPTS_RESP_CTX = ^PTS_RESP_CTX;

  TS_serial_cb = function(p1: PTS_resp_ctx; p2: pointer): Pasn1_string_st; cdecl;
  TS_time_cb = function(p1: PTS_resp_ctx; p2: pointer; sec: PInteger; usec: PInteger): integer; cdecl;
  TS_extension_cb = function(p1: PTS_resp_ctx; p2: PX509_EXTENSION; p3: pointer): integer; cdecl;
  sk_EVP_MD_compfunc = function(a: PPEVP_MD; b: PPEVP_MD): integer; cdecl;
  sk_EVP_MD_freefunc = procedure(a: PEVP_MD); cdecl;
  sk_EVP_MD_copyfunc = function(a: PEVP_MD): Pevp_md_st; cdecl;

  PTS_VERIFY_CTX = pointer;
  PPTS_VERIFY_CTX = ^PTS_VERIFY_CTX;
  OPENSSL_PSTRING = POPENSSL_STRING;

  sk_OPENSSL_PSTRING_compfunc = function(a: PPOPENSSL_STRING; b: PPOPENSSL_STRING): integer; cdecl;
  sk_OPENSSL_PSTRING_freefunc = procedure(a: POPENSSL_STRING); cdecl;
  sk_OPENSSL_PSTRING_copyfunc = function(a: POPENSSL_STRING): PPUtf8Char; cdecl;

  txt_db_st = record
    num_fields: integer;
    data: Pstack_st_OPENSSL_PSTRING;
    index: PPlhash_st_OPENSSL_STRING;
    qual: integer { TODO : Cannot convert original type "int (**)(OPENSSL_STRING *)" };
    error: integer;
    arg1: integer;
    arg2: integer;
    arg_row: POPENSSL_STRING;
  end;

  TXT_DB = txt_db_st;
  PTXT_DB = ^TXT_DB;

  _anonymous_type_14 = record
    case integer of
      0: (c: array [0..63] of Byte);
      1: (q: array [0..7] of Double);
  end;
  P_anonymous_type_14 = ^_anonymous_type_14;

  WHIRLPOOL_CTX = record
    H: _anonymous_type_14;
    data: array [0..63] of Byte;
    bitoff: cardinal;
    bitlen: array [0..3] of PtrUInt;
  end;

  PPasn1_ps_func = pointer;
  PBIO_sock_info_u = pointer;
  PPEVP_PBE_KEYGEN = pointer;

  OPENSSL_atexit_handler = procedure(); cdecl;
  CRYPTO_THREAD_run_once_init = procedure(); cdecl;
  CRYPTO_THREAD_init_local_cleanup = procedure(p1: pointer); cdecl;

  BIO_dump_cb_cb = function(data: pointer; len: PtrUInt; u: pointer): integer; cdecl;
  BIO_dump_indent_cb_cb = function(data: pointer; len: PtrUInt; u: pointer): integer; cdecl;
  BIO_meth_set_write_write = function(p1: PBIO; p2: PUtf8Char; p3: integer): integer; cdecl;
  BIO_meth_set_write_ex_bwrite = function(p1: PBIO; p2: PUtf8Char; p3: PtrUInt; p4: PPtrUInt): integer; cdecl;
  BIO_meth_set_read_read = function(p1: PBIO; p2: PUtf8Char; p3: integer): integer; cdecl;
  BIO_meth_set_read_ex_bread = function(p1: PBIO; p2: PUtf8Char; p3: PtrUInt; p4: PPtrUInt): integer; cdecl;
  BIO_meth_set_puts_puts = function(p1: PBIO; p2: PUtf8Char): integer; cdecl;
  BIO_meth_set_gets_gets = function(p1: PBIO; p2: PUtf8Char; p3: integer): integer; cdecl;
  BIO_meth_set_ctrl_ctrl = function(p1: PBIO; p2: integer; p3: integer; p4: pointer): integer; cdecl;
  BIO_meth_set_create_create = function(p1: PBIO): integer; cdecl;
  BIO_meth_set_destroy_destroy = function(p1: PBIO): integer; cdecl;
  BIO_meth_set_callback_ctrl_callback_ctrl = function(p1: PBIO; p2: integer; p3: PBIO_info_cb): integer; cdecl;

  BN_GENCB_set_old_callback = procedure(p1: integer; p2: integer; p3: pointer); cdecl;
  BN_GENCB_set_callback = function(p1: integer; p2: integer; p3: PBN_GENCB): integer; cdecl;
  BN_generate_prime_callback = procedure(p1: integer; p2: integer; p3: pointer); cdecl;
  BN_is_prime_callback = procedure(p1: integer; p2: integer; p3: pointer); cdecl;
  BN_is_prime_fasttest_callback = procedure(p1: integer; p2: integer; p3: pointer); cdecl;
  BN_BLINDING_create_param_bn_mod_exp = function(r: PBIGNUM; a: PBIGNUM; p: PBIGNUM; m: PBIGNUM; ctx: PBN_CTX; m_ctx: PBN_MONT_CTX): integer; cdecl;

  ASN1_d2i_fp_xnew = function(): pointer; cdecl;
  ASN1_d2i_bio_xnew = function(): pointer; cdecl;
  ASN1_SCTX_new_scan_cb = function(ctx: PASN1_SCTX): integer; cdecl;

  ASYNC_start_job_func = function(p1: pointer): integer; cdecl;

  OBJ_NAME_new_index_hash_func = function(p1: PUtf8Char): cardinal; cdecl;
  OBJ_NAME_new_index_cmp_func = function(p1: PUtf8Char; p2: PUtf8Char): integer; cdecl;
  OBJ_NAME_new_index_free_func = procedure(p1: PUtf8Char; p2: integer; p3: PUtf8Char); cdecl;
  OBJ_NAME_do_all_fn = procedure(p1: POBJ_NAME; arg: pointer); cdecl;
  OBJ_NAME_do_all_sorted_fn = procedure(p1: POBJ_NAME; arg: pointer); cdecl;
  OBJ_bsearch__cmp = function(p1: pointer; p2: pointer): integer; cdecl;
  OBJ_bsearch_ex__cmp = function(p1: pointer; p2: pointer): integer; cdecl;

  EVP_MD_meth_set_init_init = function(ctx: PEVP_MD_CTX): integer; cdecl;
  EVP_MD_meth_set_update_update = function(ctx: PEVP_MD_CTX; data: pointer; count: PtrUInt): integer; cdecl;
  EVP_MD_meth_set_final_final = function(ctx: PEVP_MD_CTX; md: PByte): integer; cdecl;
  EVP_MD_meth_set_copy_copy = function(_to: PEVP_MD_CTX; from: PEVP_MD_CTX): integer; cdecl;
  EVP_MD_meth_set_cleanup_cleanup = function(ctx: PEVP_MD_CTX): integer; cdecl;
  EVP_MD_meth_set_ctrl_ctrl = function(ctx: PEVP_MD_CTX; cmd: integer; p1: integer; p2: pointer): integer; cdecl;

  EVP_CIPHER_meth_set_init_init = function(ctx: PEVP_CIPHER_CTX; key: PByte; iv: PByte; enc: integer): integer; cdecl;
  EVP_CIPHER_meth_set_do_cipher_do_cipher = function(ctx: PEVP_CIPHER_CTX; _out: PByte; _in: PByte; inl: PtrUInt): integer; cdecl;
  EVP_CIPHER_meth_set_cleanup_cleanup = function(p1: PEVP_CIPHER_CTX): integer; cdecl;
  EVP_CIPHER_meth_set_set_asn1_params_set_asn1_parameters = function(p1: PEVP_CIPHER_CTX; p2: PASN1_TYPE): integer; cdecl;
  EVP_CIPHER_meth_set_get_asn1_params_get_asn1_parameters = function(p1: PEVP_CIPHER_CTX; p2: PASN1_TYPE): integer; cdecl;
  EVP_CIPHER_meth_set_ctrl_ctrl = function(p1: PEVP_CIPHER_CTX; typ: integer; arg: integer; ptr: pointer): integer; cdecl;
  EVP_CIPHER_do_all_fn = procedure(ciph: PEVP_CIPHER; from: PUtf8Char; _to: PUtf8Char; x: pointer); cdecl;
  EVP_CIPHER_do_all_sorted_fn = procedure(ciph: PEVP_CIPHER; from: PUtf8Char; _to: PUtf8Char; x: pointer); cdecl;

  EVP_MD_CTX_set_update_fn_update = function(ctx: PEVP_MD_CTX; data: pointer; count: PtrUInt): integer; cdecl;
  EVP_MD_do_all_fn = procedure(ciph: PEVP_MD; from: PUtf8Char; _to: PUtf8Char; x: pointer); cdecl;
  EVP_MD_do_all_sorted_fn = procedure(ciph: PEVP_MD; from: PUtf8Char; _to: PUtf8Char; x: pointer); cdecl;

  EVP_PKEY_asn1_set_public_pub_decode = function(pk: PEVP_PKEY; pub: PX509_PUBKEY): integer; cdecl;
  EVP_PKEY_asn1_set_public_pub_encode = function(pub: PX509_PUBKEY; pk: PEVP_PKEY): integer; cdecl;
  EVP_PKEY_asn1_set_public_pub_cmp = function(a: PEVP_PKEY; b: PEVP_PKEY): integer; cdecl;
  EVP_PKEY_asn1_set_public_pub_print = function(_out: PBIO; pkey: PEVP_PKEY; indent: integer; pctx: PASN1_PCTX): integer; cdecl;
  EVP_PKEY_asn1_set_public_pkey_size = function(pk: PEVP_PKEY): integer; cdecl;
  EVP_PKEY_asn1_set_public_pkey_bits = function(pk: PEVP_PKEY): integer; cdecl;
  EVP_PKEY_asn1_set_private_priv_decode = function(pk: PEVP_PKEY; p8inf: PPKCS8_PRIV_KEY_INFO): integer; cdecl;
  EVP_PKEY_asn1_set_private_priv_encode = function(p8: PPKCS8_PRIV_KEY_INFO; pk: PEVP_PKEY): integer; cdecl;
  EVP_PKEY_asn1_set_private_priv_print = function(_out: PBIO; pkey: PEVP_PKEY; indent: integer; pctx: PASN1_PCTX): integer; cdecl;
  EVP_PKEY_asn1_set_param_param_decode = function(pkey: PEVP_PKEY; pder: PPByte; derlen: integer): integer; cdecl;
  EVP_PKEY_asn1_set_param_param_encode = function(pkey: PEVP_PKEY; pder: PPByte): integer; cdecl;
  EVP_PKEY_asn1_set_param_param_missing = function(pk: PEVP_PKEY): integer; cdecl;
  EVP_PKEY_asn1_set_param_param_copy = function(_to: PEVP_PKEY; from: PEVP_PKEY): integer; cdecl;
  EVP_PKEY_asn1_set_param_param_cmp = function(a: PEVP_PKEY; b: PEVP_PKEY): integer; cdecl;
  EVP_PKEY_asn1_set_param_param_print = function(_out: PBIO; pkey: PEVP_PKEY; indent: integer; pctx: PASN1_PCTX): integer; cdecl;
  EVP_PKEY_asn1_set_free_pkey_free = procedure(pkey: PEVP_PKEY); cdecl;
  EVP_PKEY_asn1_set_ctrl_pkey_ctrl = function(pkey: PEVP_PKEY; op: integer; arg1: integer; arg2: pointer): integer; cdecl;
  EVP_PKEY_asn1_set_item_item_verify = function(ctx: PEVP_MD_CTX; it: PASN1_ITEM; asn: pointer; a: PX509_ALGOR; sig: PASN1_BIT_STRING; pkey: PEVP_PKEY): integer; cdecl;
  EVP_PKEY_asn1_set_item_item_sign = function(ctx: PEVP_MD_CTX; it: PASN1_ITEM; asn: pointer; alg1: PX509_ALGOR; alg2: PX509_ALGOR; sig: PASN1_BIT_STRING): integer; cdecl;
  EVP_PKEY_asn1_set_siginf_siginf_set = function(siginf: PX509_SIG_INFO; alg: PX509_ALGOR; sig: PASN1_STRING): integer; cdecl;
  EVP_PKEY_asn1_set_check_pkey_check = function(pk: PEVP_PKEY): integer; cdecl;
  EVP_PKEY_asn1_set_public_check_pkey_pub_check = function(pk: PEVP_PKEY): integer; cdecl;
  EVP_PKEY_asn1_set_param_check_pkey_param_check = function(pk: PEVP_PKEY): integer; cdecl;
  EVP_PKEY_asn1_set_set_priv_key_set_priv_key = function(pk: PEVP_PKEY; priv: PByte; len: PtrUInt): integer; cdecl;
  EVP_PKEY_asn1_set_set_pub_key_set_pub_key = function(pk: PEVP_PKEY; pub: PByte; len: PtrUInt): integer; cdecl;
  EVP_PKEY_asn1_set_get_priv_key_get_priv_key = function(pk: PEVP_PKEY; priv: PByte; len: PPtrUInt): integer; cdecl;
  EVP_PKEY_asn1_set_get_pub_key_get_pub_key = function(pk: PEVP_PKEY; pub: PByte; len: PPtrUInt): integer; cdecl;
  EVP_PKEY_asn1_set_security_bits_pkey_security_bits = function(pk: PEVP_PKEY): integer; cdecl;

  EVP_PKEY_meth_set_init_init = function(ctx: PEVP_PKEY_CTX): integer; cdecl;
  EVP_PKEY_meth_set_copy_copy = function(dst: PEVP_PKEY_CTX; src: PEVP_PKEY_CTX): integer; cdecl;
  EVP_PKEY_meth_set_cleanup_cleanup = procedure(ctx: PEVP_PKEY_CTX); cdecl;
  EVP_PKEY_meth_set_paramgen_paramgen_init = function(ctx: PEVP_PKEY_CTX): integer; cdecl;
  EVP_PKEY_meth_set_paramgen_paramgen = function(ctx: PEVP_PKEY_CTX; pkey: PEVP_PKEY): integer; cdecl;
  EVP_PKEY_meth_set_keygen_keygen_init = function(ctx: PEVP_PKEY_CTX): integer; cdecl;
  EVP_PKEY_meth_set_keygen_keygen = function(ctx: PEVP_PKEY_CTX; pkey: PEVP_PKEY): integer; cdecl;
  EVP_PKEY_meth_set_sign_sign_init = function(ctx: PEVP_PKEY_CTX): integer; cdecl;
  EVP_PKEY_meth_set_sign_sign = function(ctx: PEVP_PKEY_CTX; sig: PByte; var siglen: PtrUInt; tbs: PByte; tbslen: PtrUInt): integer; cdecl;
  EVP_PKEY_meth_set_verify_verify_init = function(ctx: PEVP_PKEY_CTX): integer; cdecl;
  EVP_PKEY_meth_set_verify_verify = function(ctx: PEVP_PKEY_CTX; sig: PByte; siglen: PtrUInt; tbs: PByte; tbslen: PtrUInt): integer; cdecl;
  EVP_PKEY_meth_set_verify_recover_verify_recover_init = function(ctx: PEVP_PKEY_CTX): integer; cdecl;
  EVP_PKEY_meth_set_verify_recover_verify_recover = function(ctx: PEVP_PKEY_CTX; sig: PByte; var siglen: PtrUInt; tbs: PByte; tbslen: PtrUInt): integer; cdecl;
  EVP_PKEY_meth_set_signctx_signctx_init = function(ctx: PEVP_PKEY_CTX; mctx: PEVP_MD_CTX): integer; cdecl;
  EVP_PKEY_meth_set_signctx_signctx = function(ctx: PEVP_PKEY_CTX; sig: PByte; var siglen: PtrUInt; mctx: PEVP_MD_CTX): integer; cdecl;
  EVP_PKEY_meth_set_verifyctx_verifyctx_init = function(ctx: PEVP_PKEY_CTX; mctx: PEVP_MD_CTX): integer; cdecl;
  EVP_PKEY_meth_set_verifyctx_verifyctx = function(ctx: PEVP_PKEY_CTX; sig: PByte; siglen: integer; mctx: PEVP_MD_CTX): integer; cdecl;
  EVP_PKEY_meth_set_encrypt_encrypt_init = function(ctx: PEVP_PKEY_CTX): integer; cdecl;
  EVP_PKEY_meth_set_encrypt_encryptfn = function(ctx: PEVP_PKEY_CTX; _out: PByte; outlen: PPtrUInt; _in: PByte; inlen: PtrUInt): integer; cdecl;
  EVP_PKEY_meth_set_decrypt_decrypt_init = function(ctx: PEVP_PKEY_CTX): integer; cdecl;
  EVP_PKEY_meth_set_decrypt_decrypt = function(ctx: PEVP_PKEY_CTX; _out: PByte; outlen: PPtrUInt; _in: PByte; inlen: PtrUInt): integer; cdecl;
  EVP_PKEY_meth_set_derive_derive_init = function(ctx: PEVP_PKEY_CTX): integer; cdecl;
  EVP_PKEY_meth_set_derive_derive = function(ctx: PEVP_PKEY_CTX; key: PByte; keylen: PPtrUInt): integer; cdecl;
  EVP_PKEY_meth_set_ctrl_ctrl = function(ctx: PEVP_PKEY_CTX; typ: integer; p1: integer; p2: pointer): integer; cdecl;
  EVP_PKEY_meth_set_ctrl_ctrl_str = function(ctx: PEVP_PKEY_CTX; typ: PUtf8Char; value: PUtf8Char): integer; cdecl;
  EVP_PKEY_meth_set_digestsign_digestsign = function(ctx: PEVP_MD_CTX; sig: PByte; var siglen: PtrUInt; tbs: PByte; tbslen: PtrUInt): integer; cdecl;
  EVP_PKEY_meth_set_digestverify_digestverify = function(ctx: PEVP_MD_CTX; sig: PByte; siglen: PtrUInt; tbs: PByte; tbslen: PtrUInt): integer; cdecl;
  EVP_PKEY_meth_set_check_check = function(pkey: PEVP_PKEY): integer; cdecl;
  EVP_PKEY_meth_set_public_check_check = function(pkey: PEVP_PKEY): integer; cdecl;
  EVP_PKEY_meth_set_param_check_check = function(pkey: PEVP_PKEY): integer; cdecl;
  EVP_PKEY_meth_set_digest_custom_digest_custom = function(ctx: PEVP_PKEY_CTX; mctx: PEVP_MD_CTX): integer; cdecl;

  EC_KEY_METHOD_set_init_init = function(key: PEC_KEY): integer; cdecl;
  EC_KEY_METHOD_set_init_finish = procedure(key: PEC_KEY); cdecl;
  EC_KEY_METHOD_set_init_copy = function(dest: PEC_KEY; src: PEC_KEY): integer; cdecl;
  EC_KEY_METHOD_set_init_set_group = function(key: PEC_KEY; grp: PEC_GROUP): integer; cdecl;
  EC_KEY_METHOD_set_init_set_private = function(key: PEC_KEY; priv_key: PBIGNUM): integer; cdecl;
  EC_KEY_METHOD_set_init_set_public = function(key: PEC_KEY; pub_key: PEC_POINT): integer; cdecl;
  EC_KEY_METHOD_set_keygen_keygen = function(key: PEC_KEY): integer; cdecl;
  EC_KEY_METHOD_set_compute_key_ckey = function(psec: PPByte; pseclen: PPtrUInt; pub_key: PEC_POINT; ecdh: PEC_KEY): integer; cdecl;
  EC_KEY_METHOD_set_sign_sign = function(typ: integer; dgst: PByte; dlen: integer; sig: PByte; siglen: PCardinal; kinv: PBIGNUM; r: PBIGNUM; eckey: PEC_KEY): integer; cdecl;
  EC_KEY_METHOD_set_sign_sign_setup = function(eckey: PEC_KEY; ctx_in: PBN_CTX; kinvp: PPBIGNUM; rp: PPBIGNUM): integer; cdecl;
  EC_KEY_METHOD_set_sign_sign_sig = function(dgst: PByte; dgst_len: integer; in_kinv: PBIGNUM; in_r: PBIGNUM; eckey: PEC_KEY): PECDSA_SIG_st; cdecl;
  EC_KEY_METHOD_set_verify_verify = function(typ: integer; dgst: PByte; dgst_len: integer; sigbuf: PByte; sig_len: integer; eckey: PEC_KEY): integer; cdecl;
  EC_KEY_METHOD_set_verify_verify_sig = function(dgst: PByte; dgst_len: integer; sig: PECDSA_SIG; eckey: PEC_KEY): integer; cdecl;

  RSA_generate_key_callback = procedure(p1: integer; p2: integer; p3: pointer); cdecl;

  RSA_meth_set_pub_enc_pub_enc = function(flen: integer; from: PByte; _to: PByte; rsa: PRSA; padding: integer): integer; cdecl;
  RSA_meth_set_pub_dec_pub_dec = function(flen: integer; from: PByte; _to: PByte; rsa: PRSA; padding: integer): integer; cdecl;
  RSA_meth_set_priv_enc_priv_enc = function(flen: integer; from: PByte; _to: PByte; rsa: PRSA; padding: integer): integer; cdecl;
  RSA_meth_set_priv_dec_priv_dec = function(flen: integer; from: PByte; _to: PByte; rsa: PRSA; padding: integer): integer; cdecl;
  RSA_meth_set_mod_exp_mod_exp = function(r0: PBIGNUM; i: PBIGNUM; rsa: PRSA; ctx: PBN_CTX): integer; cdecl;
  RSA_meth_set_bn_mod_exp_bn_mod_exp = function(r: PBIGNUM; a: PBIGNUM; p: PBIGNUM; m: PBIGNUM; ctx: PBN_CTX; m_ctx: PBN_MONT_CTX): integer; cdecl;
  RSA_meth_set_init_init = function(rsa: PRSA): integer; cdecl;
  RSA_meth_set_finish_finish = function(rsa: PRSA): integer; cdecl;
  RSA_meth_set_sign_sign = function(typ: integer; m: PByte; m_length: cardinal; sigret: PByte; siglen: PCardinal; rsa: PRSA): integer; cdecl;
  RSA_meth_set_verify_verify = function(dtype: integer; m: PByte; m_length: cardinal; sigbuf: PByte; siglen: cardinal; rsa: PRSA): integer; cdecl;
  RSA_meth_set_keygen_keygen = function(rsa: PRSA; bits: integer; e: PBIGNUM; cb: PBN_GENCB): integer; cdecl;
  RSA_meth_set_multi_prime_keygen_keygen = function(rsa: PRSA; bits: integer; primes: integer; e: PBIGNUM; cb: PBN_GENCB): integer; cdecl;

  DH_generate_parameters_callback = procedure(p1: integer; p2: integer; p3: pointer); cdecl;

  DH_meth_set_generate_key_generate_key = function(p1: PDH): integer; cdecl;
  DH_meth_set_compute_key_compute_key = function(key: PByte; pub_key: PBIGNUM; dh: PDH): integer; cdecl;
  DH_meth_set_bn_mod_exp_bn_mod_exp = function(p1: PDH; p2: PBIGNUM; p3: PBIGNUM; p4: PBIGNUM; p5: PBIGNUM; p6: PBN_CTX; p7: PBN_MONT_CTX): integer; cdecl;
  DH_meth_set_init_init = function(p1: PDH): integer; cdecl;
  DH_meth_set_finish_finish = function(p1: PDH): integer; cdecl;
  DH_meth_set_generate_params_generate_params = function(p1: PDH; p2: integer; p3: integer; p4: PBN_GENCB): integer; cdecl;

  DSA_generate_parameters_callback = procedure(p1: integer; p2: integer; p3: pointer); cdecl;

  DSA_meth_set_sign_sign = function(p1: PByte; p2: integer; p3: PDSA): PDSA_SIG_st; cdecl;
  DSA_meth_set_sign_setup_sign_setup = function(p1: PDSA; p2: PBN_CTX; p3: PPBIGNUM; p4: PPBIGNUM): integer; cdecl;
  DSA_meth_set_verify_verify = function(p1: PByte; p2: integer; p3: PDSA_SIG; p4: PDSA): integer; cdecl;
  DSA_meth_set_mod_exp_mod_exp = function(p1: PDSA; p2: PBIGNUM; p3: PBIGNUM; p4: PBIGNUM; p5: PBIGNUM; p6: PBIGNUM; p7: PBIGNUM; p8: PBN_CTX; p9: PBN_MONT_CTX): integer; cdecl;
  DSA_meth_set_bn_mod_exp_bn_mod_exp = function(p1: PDSA; p2: PBIGNUM; p3: PBIGNUM; p4: PBIGNUM; p5: PBIGNUM; p6: PBN_CTX; p7: PBN_MONT_CTX): integer; cdecl;
  DSA_meth_set_init_init = function(p1: PDSA): integer; cdecl;
  DSA_meth_set_finish_finish = function(p1: PDSA): integer; cdecl;
  DSA_meth_set_paramgen_paramgen = function(p1: PDSA; p2: integer; p3: PByte; p4: integer; p5: PInteger; p6: PCardinal; p7: PBN_GENCB): integer; cdecl;
  DSA_meth_set_keygen_keygen = function(p1: PDSA): integer; cdecl;

  X509_LOOKUP_meth_set_new_item_new_item = function(ctx: PX509_LOOKUP): integer; cdecl;
  X509_LOOKUP_meth_set_free_free_fn = procedure(ctx: PX509_LOOKUP); cdecl;
  X509_LOOKUP_meth_set_init_init = function(ctx: PX509_LOOKUP): integer; cdecl;
  X509_LOOKUP_meth_set_shutdown_shutdown = function(ctx: PX509_LOOKUP): integer; cdecl;

  X509_CRL_METHOD_new_crl_init = function(crl: PX509_CRL): integer; cdecl;
  X509_CRL_METHOD_new_crl_free = function(crl: PX509_CRL): integer; cdecl;
  X509_CRL_METHOD_new_crl_lookup = function(crl: PX509_CRL; ret: PPX509_REVOKED; ser: PASN1_INTEGER; issuer: PX509_NAME): integer; cdecl;
  X509_CRL_METHOD_new_crl_verify = function(crl: PX509_CRL; pk: PEVP_PKEY): integer; cdecl;

  X509_TRUST_set_default_trust = function(p1: integer; p2: PX509; p3: integer): integer; cdecl;
  X509_TRUST_add_ck = function(p1: PX509_TRUST; p2: PX509; p3: integer): integer; cdecl;

  CONF_parse_list_list_cb = function(elem: PUtf8Char; len: integer; usr: pointer): integer; cdecl;

  X509_PURPOSE_add_ck = function(p1: PX509_PURPOSE; p2: PX509; p3: integer): integer; cdecl;

  UI_ctrl_f = procedure(); cdecl;
  UI_method_set_opener_opener = function(ui: PUI): integer; cdecl;
  UI_method_set_writer_writer = function(ui: PUI; uis: PUI_STRING): integer; cdecl;
  UI_method_set_flusher_flusher = function(ui: PUI): integer; cdecl;
  UI_method_set_reader_reader = function(ui: PUI; uis: PUI_STRING): integer; cdecl;
  UI_method_set_closer_closer = function(ui: PUI): integer; cdecl;
  UI_method_set_data_duplicator_duplicator = function(ui: PUI; ui_data: pointer): pointer; cdecl;
  UI_method_set_data_duplicator_destructor = procedure(ui: PUI; ui_data: pointer); cdecl;
  UI_method_set_prompt_constructor_prompt_constructor = function(ui: PUI; object_desc: PUtf8Char; object_name: PUtf8Char): PUtf8Char; cdecl;

  ERR_print_errors_cb_cb = function(str: PUtf8Char; len: PtrUInt; u: pointer): integer; cdecl;

  ENGINE_ctrl_f = procedure(); cdecl;
  ENGINE_ctrl_cmd_f = procedure(); cdecl;

  OSSL_STORE_do_all_loaders_do_function = procedure(loader: POSSL_STORE_LOADER; do_arg: pointer); cdecl;

  TXT_DB_create_index_qual = function(p1: POPENSSL_STRING): integer; cdecl;

  SSL_CTX_set_cert_verify_callback_cb = function(p1: PX509_STORE_CTX; p2: pointer): integer; cdecl;
  SSL_CTX_set_cert_cb_cb = function(ssl: PSSL; arg: pointer): integer; cdecl;
  SSL_CTX_set_srp_client_pwd_callback_cb = function(p1: PSSL; p2: pointer): PUtf8Char; cdecl;
  SSL_CTX_set_srp_verify_param_callback_cb = function(p1: PSSL; p2: pointer): integer; cdecl;
  SSL_CTX_set_srp_username_callback_cb = function(p1: PSSL; p2: PInteger; p3: pointer): integer; cdecl;
  SSL_CTX_set_tmp_dh_callback_dh = function(ssl: PSSL; is_export: integer; keylength: integer): Pdh_st; cdecl;
  SSL_CTX_set_not_resumable_session_callback_cb = function(ssl: PSSL; is_forward_secure: integer): integer; cdecl;
  SSL_CTX_set_record_padding_callback_cb = function(ssl: PSSL; typ: integer; len: PtrUInt; arg: pointer): Qword; cdecl;
  SSL_CTX_set_security_callback_cb = function(s: PSSL; ctx: PSSL_CTX; op: integer; bits: integer; nid: integer; other: pointer; ex: pointer): integer; cdecl;
  SSL_CTX_set_msg_callback_cb = procedure(write_p: integer; version: integer; content_type: integer; buf: pointer; len: PtrUInt; ssl: PSSL; arg: pointer); cdecl;

  SSL_callback_ctrl_ = procedure(); cdecl;
  SSL_set_info_callback_cb = procedure(ssl: PSSL; typ: integer; val: integer); cdecl;
  SSL_set_tmp_dh_callback_dh = function(ssl: PSSL; is_export: integer; keylength: integer): Pdh_st; cdecl;
  SSL_set_not_resumable_session_callback_cb = function(ssl: PSSL; is_forward_secure: integer): integer; cdecl;
  SSL_set_record_padding_callback_cb = function(ssl: PSSL; typ: integer; len: PtrUInt; arg: pointer): Qword; cdecl;
  SSL_set_security_callback_cb = function(s: PSSL; ctx: PSSL_CTX; op: integer; bits: integer; nid: integer; other: pointer; ex: pointer): integer; cdecl;
  SSL_set_msg_callback_cb = procedure(write_p: integer; version: integer; content_type: integer; buf: pointer; len: PtrUInt; ssl: PSSL; arg: pointer); cdecl;
  SSL_set_cert_cb_cb = function(ssl: PSSL; arg: pointer): integer; cdecl;

  SSL_CTX_sess_set_new_cb_new_session_cb = function(ssl: Pssl_st; sess: PSSL_SESSION): integer; cdecl;
  SSL_CTX_sess_set_remove_cb_remove_session_cb = procedure(ctx: Pssl_ctx_st; sess: PSSL_SESSION); cdecl;
  SSL_CTX_sess_set_get_cb_get_session_cb = function(ssl: Pssl_st; data: PByte; len: integer; copy: PInteger): Pssl_session_st; cdecl;
  SSL_CTX_set_info_callback_cb = procedure(ssl: PSSL; typ: integer; val: integer); cdecl;
  SSL_CTX_set_client_cert_cb_client_cert_cb = function(ssl: PSSL; x509: PPX509; pkey: PPEVP_PKEY): integer; cdecl;
  SSL_CTX_set_cookie_generate_cb_app_gen_cookie_cb = function(ssl: PSSL; cookie: PByte; cookie_len: PCardinal): integer; cdecl;
  SSL_CTX_set_cookie_verify_cb_app_verify_cookie_cb = function(ssl: PSSL; cookie: PByte; cookie_len: cardinal): integer; cdecl;
  SSL_CTX_set_stateless_cookie_generate_cb_gen_stateless_cookie_cb = function(ssl: PSSL; cookie: PByte; cookie_len: PPtrUInt): integer; cdecl;
  SSL_CTX_set_stateless_cookie_verify_cb_verify_stateless_cookie_cb = function(ssl: PSSL; cookie: PByte; cookie_len: PtrUInt): integer; cdecl;



{ ******************** OpenSSL Library Functions }

{ Crypto Library }

function AES_options(): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'AES_options';

function AES_set_encrypt_key(userKey: PByte; bits: integer; key: PAES_KEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'AES_set_encrypt_key';

function AES_set_decrypt_key(userKey: PByte; bits: integer; key: PAES_KEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'AES_set_decrypt_key';

procedure AES_encrypt(_in: PByte; _out: PByte; key: PAES_KEY); cdecl;
  external LIB_CRYPTO name _PU + 'AES_encrypt';

procedure AES_decrypt(_in: PByte; _out: PByte; key: PAES_KEY); cdecl;
  external LIB_CRYPTO name _PU + 'AES_decrypt';

procedure AES_ecb_encrypt(_in: PByte; _out: PByte; key: PAES_KEY; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'AES_ecb_encrypt';

procedure AES_cbc_encrypt(_in: PByte; _out: PByte; length: PtrUInt; key: PAES_KEY; ivec: PByte; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'AES_cbc_encrypt';

procedure AES_cfb128_encrypt(_in: PByte; _out: PByte; length: PtrUInt; key: PAES_KEY; ivec: PByte; num: PInteger; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'AES_cfb128_encrypt';

procedure AES_cfb1_encrypt(_in: PByte; _out: PByte; length: PtrUInt; key: PAES_KEY; ivec: PByte; num: PInteger; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'AES_cfb1_encrypt';

procedure AES_cfb8_encrypt(_in: PByte; _out: PByte; length: PtrUInt; key: PAES_KEY; ivec: PByte; num: PInteger; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'AES_cfb8_encrypt';

procedure AES_ofb128_encrypt(_in: PByte; _out: PByte; length: PtrUInt; key: PAES_KEY; ivec: PByte; num: PInteger); cdecl;
  external LIB_CRYPTO name _PU + 'AES_ofb128_encrypt';

procedure AES_ige_encrypt(_in: PByte; _out: PByte; length: PtrUInt; key: PAES_KEY; ivec: PByte; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'AES_ige_encrypt';

procedure AES_bi_ige_encrypt(_in: PByte; _out: PByte; length: PtrUInt; key: PAES_KEY; key2: PAES_KEY; ivec: PByte; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'AES_bi_ige_encrypt';

function AES_wrap_key(key: PAES_KEY; iv: PByte; _out: PByte; _in: PByte; inlen: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'AES_wrap_key';

function AES_unwrap_key(key: PAES_KEY; iv: PByte; _out: PByte; _in: PByte; inlen: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'AES_unwrap_key';

function OPENSSL_sk_set(st: POPENSSL_STACK; i: integer; data: pointer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_sk_set';

function OPENSSL_sk_new_null(): POPENSSL_STACK; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_sk_new_null';

function OPENSSL_sk_new_reserve(c: OPENSSL_sk_compfunc; n: integer): POPENSSL_STACK; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_sk_new_reserve';

function OPENSSL_sk_reserve(st: POPENSSL_STACK; n: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_sk_reserve';

function OPENSSL_sk_deep_copy(p1: POPENSSL_STACK; c: OPENSSL_sk_copyfunc; f: OPENSSL_sk_freefunc): POPENSSL_STACK; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_sk_deep_copy';

function OPENSSL_sk_insert(sk: POPENSSL_STACK; data: pointer; where: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_sk_insert';

function OPENSSL_sk_delete_ptr(st: POPENSSL_STACK; p: pointer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_sk_delete_ptr';

function OPENSSL_sk_find_ex(st: POPENSSL_STACK; data: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_sk_find_ex';

function OPENSSL_sk_unshift(st: POPENSSL_STACK; data: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_sk_unshift';

function OPENSSL_sk_shift(st: POPENSSL_STACK): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_sk_shift';

procedure OPENSSL_sk_zero(st: POPENSSL_STACK); cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_sk_zero';

function OPENSSL_sk_set_cmp_func(sk: POPENSSL_STACK; cmp: OPENSSL_sk_compfunc): OPENSSL_sk_compfunc; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_sk_set_cmp_func';

function OPENSSL_sk_dup(st: POPENSSL_STACK): POPENSSL_STACK; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_sk_dup';

procedure OPENSSL_sk_sort(st: POPENSSL_STACK); cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_sk_sort';

function OPENSSL_sk_is_sorted(st: POPENSSL_STACK): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_sk_is_sorted';

function ERR_load_CRYPTO_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_CRYPTO_strings';

function CRYPTO_THREAD_lock_new(): PCRYPTO_RWLOCK; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_THREAD_lock_new';

function CRYPTO_THREAD_read_lock(lock: PCRYPTO_RWLOCK): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_THREAD_read_lock';

function CRYPTO_THREAD_write_lock(lock: PCRYPTO_RWLOCK): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_THREAD_write_lock';

function CRYPTO_THREAD_unlock(lock: PCRYPTO_RWLOCK): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_THREAD_unlock';

procedure CRYPTO_THREAD_lock_free(lock: PCRYPTO_RWLOCK); cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_THREAD_lock_free';

function CRYPTO_atomic_add(val: PInteger; amount: integer; ret: PInteger; lock: PCRYPTO_RWLOCK): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_atomic_add';

function CRYPTO_mem_ctrl(mode: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_mem_ctrl';

function OPENSSL_strlcpy(dst: PUtf8Char; src: PUtf8Char; siz: PtrUInt): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_strlcpy';

function OPENSSL_strlcat(dst: PUtf8Char; src: PUtf8Char; siz: PtrUInt): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_strlcat';

function OPENSSL_strnlen(str: PUtf8Char; maxlen: PtrUInt): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_strnlen';

function OPENSSL_buf2hexstr(buffer: PByte; len: integer): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_buf2hexstr';

function OPENSSL_hexstr2buf(str: PUtf8Char; len: PInteger): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_hexstr2buf';

function OPENSSL_hexchar2int(c: Byte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_hexchar2int';

function SSLeay(): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'OpenSSL_version_num';

function SSLeay_version(typ: integer): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'OpenSSL_version';

function OPENSSL_issetugid(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_issetugid';

function CRYPTO_free_ex_index(class_index: integer; idx: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_free_ex_index';

function CRYPTO_new_ex_data(class_index: integer; obj: pointer; ad: PCRYPTO_EX_DATA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_new_ex_data';

function CRYPTO_dup_ex_data(class_index: integer; _to: PCRYPTO_EX_DATA; from: PCRYPTO_EX_DATA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_dup_ex_data';

procedure CRYPTO_free_ex_data(class_index: integer; obj: pointer; ad: PCRYPTO_EX_DATA); cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_free_ex_data';

function CRYPTO_set_ex_data(ad: PCRYPTO_EX_DATA; idx: integer; val: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_set_ex_data';

function CRYPTO_get_ex_data(ad: PCRYPTO_EX_DATA; idx: integer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_get_ex_data';

function CRYPTO_set_mem_debug(flag: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_set_mem_debug';

procedure CRYPTO_get_mem_functions(m: integer; r, f: integer); cdecl;
  { TODO : Cannot convert original type "void (**)(void *, const char *, int)" }
  external LIB_CRYPTO name _PU + 'CRYPTO_get_mem_functions';

function CRYPTO_zalloc(num: PtrUInt; _file: PUtf8Char; line: integer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_zalloc';

function CRYPTO_memdup(str: pointer; siz: PtrUInt; _file: PUtf8Char; line: integer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_memdup';

function CRYPTO_strdup(str: PUtf8Char; _file: PUtf8Char; line: integer): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_strdup';

function CRYPTO_strndup(str: PUtf8Char; s: PtrUInt; _file: PUtf8Char; line: integer): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_strndup';

procedure CRYPTO_clear_free(ptr: pointer; num: PtrUInt; _file: PUtf8Char; line: integer); cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_clear_free';

function CRYPTO_realloc(addr: pointer; num: PtrUInt; _file: PUtf8Char; line: integer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_realloc';

function CRYPTO_clear_realloc(addr: pointer; old_num: PtrUInt; num: PtrUInt; _file: PUtf8Char; line: integer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_clear_realloc';

function CRYPTO_secure_malloc_init(sz: PtrUInt; minsize: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_secure_malloc_init';

function CRYPTO_secure_malloc_done(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_secure_malloc_done';

function CRYPTO_secure_malloc(num: PtrUInt; _file: PUtf8Char; line: integer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_secure_malloc';

function CRYPTO_secure_zalloc(num: PtrUInt; _file: PUtf8Char; line: integer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_secure_zalloc';

procedure CRYPTO_secure_free(ptr: pointer; _file: PUtf8Char; line: integer); cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_secure_free';

procedure CRYPTO_secure_clear_free(ptr: pointer; num: PtrUInt; _file: PUtf8Char; line: integer); cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_secure_clear_free';

function CRYPTO_secure_allocated(ptr: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_secure_allocated';

function CRYPTO_secure_malloc_initialized(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_secure_malloc_initialized';

function CRYPTO_secure_actual_size(ptr: pointer): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_secure_actual_size';

function CRYPTO_secure_used(): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_secure_used';

procedure OPENSSL_cleanse(ptr: pointer; len: PtrUInt); cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_cleanse';

procedure OPENSSL_die(assertion: PUtf8Char; _file: PUtf8Char; line: integer); cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_die';

function OPENSSL_isservice(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_isservice';

function FIPS_mode(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'FIPS_mode';

function FIPS_mode_set(r: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'FIPS_mode_set';

procedure OPENSSL_init(); cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_init';


function OPENSSL_gmtime(timer: ptime_t; result: Ptm): Ptm; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_gmtime';

function OPENSSL_gmtime_adj(tm: Ptm; offset_day: integer; offset_sec: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_gmtime_adj';

function OPENSSL_gmtime_diff(pday: PInteger; psec: PInteger; from: Ptm; _to: Ptm): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_gmtime_diff';

function CRYPTO_memcmp(in_a: pointer; in_b: pointer; len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_memcmp';

procedure OPENSSL_cleanup(); cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_cleanup';

function OPENSSL_init_crypto(opts: Qword; settings: POPENSSL_INIT_SETTINGS): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_init_crypto';

function OPENSSL_atexit(handler: OPENSSL_atexit_handler): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_atexit';

procedure OPENSSL_thread_stop(); cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_thread_stop';

function OPENSSL_INIT_new(): POPENSSL_INIT_SETTINGS; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_INIT_new';

function OPENSSL_INIT_set_config_filename(settings: POPENSSL_INIT_SETTINGS; config_filename: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_INIT_set_config_filename';

procedure OPENSSL_INIT_set_config_file_flags(settings: POPENSSL_INIT_SETTINGS; flags: cardinal); cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_INIT_set_config_file_flags';

function OPENSSL_INIT_set_config_appname(settings: POPENSSL_INIT_SETTINGS; config_appname: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_INIT_set_config_appname';

procedure OPENSSL_INIT_free(settings: POPENSSL_INIT_SETTINGS); cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_INIT_free';

function CRYPTO_THREAD_run_once(once: PCRYPTO_ONCE; init: CRYPTO_THREAD_run_once_init): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_THREAD_run_once';

function CRYPTO_THREAD_init_local(key: PCRYPTO_THREAD_LOCAL; cleanup: CRYPTO_THREAD_init_local_cleanup): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_THREAD_init_local';

function CRYPTO_THREAD_get_local(key: PCRYPTO_THREAD_LOCAL): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_THREAD_get_local';

function CRYPTO_THREAD_set_local(key: PCRYPTO_THREAD_LOCAL; val: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_THREAD_set_local';

function CRYPTO_THREAD_cleanup_local(key: PCRYPTO_THREAD_LOCAL): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_THREAD_cleanup_local';

function CRYPTO_THREAD_get_current_id(): CRYPTO_THREAD_ID; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_THREAD_get_current_id';

function CRYPTO_THREAD_compare_id(a: CRYPTO_THREAD_ID; b: CRYPTO_THREAD_ID): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_THREAD_compare_id';

function BIO_get_new_index(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_get_new_index';

procedure BIO_set_flags(b: PBIO; flags: integer); cdecl;
  external LIB_CRYPTO name _PU + 'BIO_set_flags';

procedure BIO_clear_flags(b: PBIO; flags: integer); cdecl;
  external LIB_CRYPTO name _PU + 'BIO_clear_flags';

function BIO_get_callback(b: PBIO): BIO_callback_fn; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_get_callback';

procedure BIO_set_callback(b: PBIO; callback: BIO_callback_fn); cdecl;
  external LIB_CRYPTO name _PU + 'BIO_set_callback';

function BIO_get_callback_ex(b: PBIO): BIO_callback_fn_ex; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_get_callback_ex';

procedure BIO_set_callback_ex(b: PBIO; callback: BIO_callback_fn_ex); cdecl;
  external LIB_CRYPTO name _PU + 'BIO_set_callback_ex';

function BIO_get_callback_arg(b: PBIO): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_get_callback_arg';

procedure BIO_set_callback_arg(b: PBIO; arg: PUtf8Char); cdecl;
  external LIB_CRYPTO name _PU + 'BIO_set_callback_arg';

function BIO_method_name(b: PBIO): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_method_name';

function BIO_method_type(b: PBIO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_method_type';

function BIO_ctrl_pending(b: PBIO): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_ctrl_pending';

function BIO_ctrl_wpending(b: PBIO): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_ctrl_wpending';

function BIO_ctrl_get_write_guarantee(b: PBIO): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_ctrl_get_write_guarantee';

function BIO_ctrl_get_read_request(b: PBIO): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_ctrl_get_read_request';

function BIO_ctrl_reset_read_request(b: PBIO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_ctrl_reset_read_request';

function BIO_set_ex_data(bio: PBIO; idx: integer; data: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_set_ex_data';

function BIO_get_ex_data(bio: PBIO; idx: integer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_get_ex_data';

function BIO_number_read(bio: PBIO): Qword; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_number_read';

function BIO_number_written(bio: PBIO): Qword; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_number_written';

function BIO_asn1_set_prefix(b: PBIO; prefix: Pasn1_ps_func; prefix_free: Pasn1_ps_func): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_asn1_set_prefix';

function BIO_asn1_get_prefix(b: PBIO; pprefix: PPasn1_ps_func; pprefix_free: PPasn1_ps_func): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_asn1_get_prefix';

function BIO_asn1_set_suffix(b: PBIO; suffix: Pasn1_ps_func; suffix_free: Pasn1_ps_func): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_asn1_set_suffix';

function BIO_asn1_get_suffix(b: PBIO; psuffix: PPasn1_ps_func; psuffix_free: PPasn1_ps_func): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_asn1_get_suffix';

function BIO_s_file(): PBIO_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_s_file';

function BIO_new_file(filename: PUtf8Char; mode: PUtf8Char): PBIO; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_new_file';

function BIO_new_fp(stream: PPointer; close_flag: integer): PBIO; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_new_fp';

procedure BIO_set_data(a: PBIO; ptr: pointer); cdecl;
  external LIB_CRYPTO name _PU + 'BIO_set_data';

function BIO_get_data(a: PBIO): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_get_data';

procedure BIO_set_init(a: PBIO; init: integer); cdecl;
  external LIB_CRYPTO name _PU + 'BIO_set_init';

function BIO_get_init(a: PBIO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_get_init';

procedure BIO_set_shutdown(a: PBIO; shut: integer); cdecl;
  external LIB_CRYPTO name _PU + 'BIO_set_shutdown';

function BIO_get_shutdown(a: PBIO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_get_shutdown';

procedure BIO_vfree(a: PBIO); cdecl;
  external LIB_CRYPTO name _PU + 'BIO_vfree';

function BIO_up_ref(a: PBIO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_up_ref';

function BIO_read_ex(b: PBIO; data: pointer; dlen: PtrUInt; readbytes: PPtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_read_ex';

function BIO_gets(bp: PBIO; buf: PUtf8Char; size: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_gets';

function BIO_write_ex(b: PBIO; data: pointer; dlen: PtrUInt; written: PPtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_write_ex';

function BIO_puts(bp: PBIO; buf: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_puts';

function BIO_indent(b: PBIO; indent: integer; max: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_indent';

function BIO_callback_ctrl(b: PBIO; cmd: integer; fp: PBIO_info_cb): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_callback_ctrl';

function BIO_ptr_ctrl(bp: PBIO; cmd: integer; larg: integer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_ptr_ctrl';

function BIO_int_ctrl(bp: PBIO; cmd: integer; larg: integer; iarg: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_int_ctrl';

function BIO_push(b: PBIO; append: PBIO): PBIO; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_push';

function BIO_pop(b: PBIO): PBIO; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_pop';

procedure BIO_free_all(a: PBIO); cdecl;
  external LIB_CRYPTO name _PU + 'BIO_free_all';

function BIO_find_type(b: PBIO; bio_type: integer): PBIO; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_find_type';

function BIO_next(b: PBIO): PBIO; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_next';

procedure BIO_set_next(b: PBIO; next: PBIO); cdecl;
  external LIB_CRYPTO name _PU + 'BIO_set_next';

function BIO_get_retry_BIO(bio: PBIO; reason: PInteger): PBIO; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_get_retry_BIO';

function BIO_get_retry_reason(bio: PBIO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_get_retry_reason';

procedure BIO_set_retry_reason(bio: PBIO; reason: integer); cdecl;
  external LIB_CRYPTO name _PU + 'BIO_set_retry_reason';

function BIO_dup_chain(_in: PBIO): PBIO; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_dup_chain';

function BIO_nread0(bio: PBIO; buf: PPUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_nread0';

function BIO_nread(bio: PBIO; buf: PPUtf8Char; num: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_nread';

function BIO_nwrite0(bio: PBIO; buf: PPUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_nwrite0';

function BIO_nwrite(bio: PBIO; buf: PPUtf8Char; num: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_nwrite';

function BIO_debug_callback(bio: PBIO; cmd: integer; argp: PUtf8Char; argi: integer; argl: integer; ret: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_debug_callback';

function BIO_s_secmem(): PBIO_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_s_secmem';

function BIO_s_socket(): PBIO_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_s_socket';

function BIO_s_connect(): PBIO_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_s_connect';

function BIO_s_accept(): PBIO_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_s_accept';

function BIO_s_fd(): PBIO_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_s_fd';

function BIO_s_log(): PBIO_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_s_log';

function BIO_s_bio(): PBIO_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_s_bio';

function BIO_s_null(): PBIO_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_s_null';

function BIO_f_null(): PBIO_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_f_null';

function BIO_f_buffer(): PBIO_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_f_buffer';

function BIO_f_linebuffer(): PBIO_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_f_linebuffer';

function BIO_f_nbio_test(): PBIO_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_f_nbio_test';

function BIO_s_datagram(): PBIO_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_s_datagram';

function BIO_dgram_non_fatal_error(error: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_dgram_non_fatal_error';

function BIO_new_dgram(fd: integer; close_flag: integer): PBIO; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_new_dgram';

function BIO_sock_should_retry(i: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_sock_should_retry';

function BIO_sock_non_fatal_error(error: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_sock_non_fatal_error';

function BIO_fd_should_retry(i: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_fd_should_retry';

function BIO_fd_non_fatal_error(error: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_fd_non_fatal_error';

function BIO_dump_cb(cb: BIO_dump_cb_cb; u: pointer; s: PUtf8Char; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_dump_cb';

function BIO_dump_indent_cb(cb: BIO_dump_indent_cb_cb; u: pointer; s: PUtf8Char; len: integer; indent: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_dump_indent_cb';

function BIO_dump(b: PBIO; bytes: PUtf8Char; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_dump';

function BIO_dump_indent(b: PBIO; bytes: PUtf8Char; len: integer; indent: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_dump_indent';

function BIO_dump_fp(fp: PPointer; s: PUtf8Char; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_dump_fp';

function BIO_dump_indent_fp(fp: PPointer; s: PUtf8Char; len: integer; indent: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_dump_indent_fp';

function BIO_hex_string(_out: PBIO; indent: integer; width: integer; data: PByte; datalen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_hex_string';

function BIO_ADDR_new(): PBIO_ADDR; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_ADDR_new';

function BIO_ADDR_rawmake(ap: PBIO_ADDR; family: integer; where: pointer; wherelen: PtrUInt; port: Word): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_ADDR_rawmake';

procedure BIO_ADDR_free(p1: PBIO_ADDR); cdecl;
  external LIB_CRYPTO name _PU + 'BIO_ADDR_free';

procedure BIO_ADDR_clear(ap: PBIO_ADDR); cdecl;
  external LIB_CRYPTO name _PU + 'BIO_ADDR_clear';

function BIO_ADDR_family(ap: PBIO_ADDR): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_ADDR_family';

function BIO_ADDR_rawaddress(ap: PBIO_ADDR; p: pointer; l: PPtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_ADDR_rawaddress';

function BIO_ADDR_rawport(ap: PBIO_ADDR): Word; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_ADDR_rawport';

function BIO_ADDR_hostname_string(ap: PBIO_ADDR; numeric: integer): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_ADDR_hostname_string';

function BIO_ADDR_service_string(ap: PBIO_ADDR; numeric: integer): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_ADDR_service_string';

function BIO_ADDR_path_string(ap: PBIO_ADDR): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_ADDR_path_string';

function BIO_ADDRINFO_next(bai: PBIO_ADDRINFO): PBIO_ADDRINFO; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_ADDRINFO_next';

function BIO_ADDRINFO_family(bai: PBIO_ADDRINFO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_ADDRINFO_family';

function BIO_ADDRINFO_socktype(bai: PBIO_ADDRINFO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_ADDRINFO_socktype';

function BIO_ADDRINFO_protocol(bai: PBIO_ADDRINFO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_ADDRINFO_protocol';

function BIO_ADDRINFO_address(bai: PBIO_ADDRINFO): PBIO_ADDR; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_ADDRINFO_address';

procedure BIO_ADDRINFO_free(bai: PBIO_ADDRINFO); cdecl;
  external LIB_CRYPTO name _PU + 'BIO_ADDRINFO_free';

function BIO_parse_hostserv(hostserv: PUtf8Char; host: PPUtf8Char; service: PPUtf8Char; hostserv_prio: BIO_hostserv_priorities): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_parse_hostserv';

function BIO_lookup(host: PUtf8Char; service: PUtf8Char; lookup_type: BIO_lookup_type; family: integer; socktype: integer; res: PPBIO_ADDRINFO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_lookup';

function BIO_lookup_ex(host: PUtf8Char; service: PUtf8Char; lookup_type: integer; family: integer; socktype: integer; protocol: integer; res: PPBIO_ADDRINFO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_lookup_ex';

function BIO_sock_error(sock: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_sock_error';

function BIO_socket_ioctl(fd: integer; typ: integer; arg: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_socket_ioctl';

function BIO_socket_nbio(fd: integer; mode: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_socket_nbio';

function BIO_sock_init(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_sock_init';

function BIO_set_tcp_ndelay(sock: integer; turn_on: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_set_tcp_ndelay';

function BIO_gethostbyname(name: PUtf8Char): Phostent; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_gethostbyname';

function BIO_get_port(str: PUtf8Char; port_ptr: PWord): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_get_port';

function BIO_get_host_ip(str: PUtf8Char; ip: PByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_get_host_ip';

function BIO_get_accept_socket(host_port: PUtf8Char; mode: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_get_accept_socket';

function BIO_accept(sock: integer; ip_port: PPUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_accept';

function BIO_sock_info(sock: integer; typ: BIO_sock_info_type; info: PBIO_sock_info_u): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_sock_info';

function BIO_socket(domain: integer; socktype: integer; protocol: integer; options: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_socket';

function BIO_connect(sock: integer; addr: PBIO_ADDR; options: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_connect';

function BIO_bind(sock: integer; addr: PBIO_ADDR; options: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_bind';

function BIO_listen(sock: integer; addr: PBIO_ADDR; options: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_listen';

function BIO_accept_ex(accept_sock: integer; addr: PBIO_ADDR; options: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_accept_ex';

function BIO_closesocket(sock: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_closesocket';

function BIO_new_connect(host_port: PUtf8Char): PBIO; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_new_connect';

function BIO_new_accept(host_port: PUtf8Char): PBIO; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_new_accept';

function BIO_new_fd(fd: integer; close_flag: integer): PBIO; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_new_fd';

function BIO_new_bio_pair(bio1: PPBIO; writebuf1: PtrUInt; bio2: PPBIO; writebuf2: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_new_bio_pair';

procedure BIO_copy_next_retry(b: PBIO); cdecl;
  external LIB_CRYPTO name _PU + 'BIO_copy_next_retry';

function BIO_printf(bio: PBIO; format: PUtf8Char): integer varargs; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_printf';

function BIO_vprintf(bio: PBIO; format: PUtf8Char; args: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_vprintf';

function BIO_snprintf(buf: PUtf8Char; n: PtrUInt; format: PUtf8Char): integer varargs; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_snprintf';

function BIO_vsnprintf(buf: PUtf8Char; n: PtrUInt; format: PUtf8Char; args: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_vsnprintf';

function BIO_meth_new(typ: integer; name: PUtf8Char): PBIO_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_meth_new';

procedure BIO_meth_free(biom: PBIO_METHOD); cdecl;
  external LIB_CRYPTO name _PU + 'BIO_meth_free';

//function BIO_meth_get_write(p1: PBIO; p2: PUTF8Char; p3: integer; biom: PBIO_METHOD): integer;
{ TODO : Cannot convert original type "int (*)(BIO *, const char *, int)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'BIO_meth_get_write';

//function BIO_meth_get_write_ex(p1: PBIO; p2: PUTF8Char; p3: PtrUIntp4: PPtrUInt; biom: PBIO_METHOD): integer;
{ TODO : Cannot convert original type "int (*)(BIO *, const char *, size_t, size_t *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'BIO_meth_get_write_ex';

function BIO_meth_set_write(biom: PBIO_METHOD; write: BIO_meth_set_write_write): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_meth_set_write';

function BIO_meth_set_write_ex(biom: PBIO_METHOD; bwrite: BIO_meth_set_write_ex_bwrite): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_meth_set_write_ex';

//function BIO_meth_get_read(p1: PBIO; p2: PUTF8Char; p3: integer; biom: PBIO_METHOD): integer;
{ TODO : Cannot convert original type "int (*)(BIO *, char *, int)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'BIO_meth_get_read';

//function BIO_meth_get_read_ex(p1: PBIO; p2: PUTF8Char; p3: PtrUInt; p4: PPtrUInt; biom: PBIO_METHOD): integer
{ TODO : Cannot convert original type "int (*)(BIO *, char *, size_t, size_t *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'BIO_meth_get_read_ex';

function BIO_meth_set_read(biom: PBIO_METHOD; read: BIO_meth_set_read_read): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_meth_set_read';

function BIO_meth_set_read_ex(biom: PBIO_METHOD; bread: BIO_meth_set_read_ex_bread): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_meth_set_read_ex';

//function BIO_meth_get_puts(p1: PBIOp2: PUTF8Char; biom: PBIO_METHOD): integer;
{ TODO : Cannot convert original type "int (*)(BIO *, const char *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'BIO_meth_get_puts';

function BIO_meth_set_puts(biom: PBIO_METHOD; puts: BIO_meth_set_puts_puts): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_meth_set_puts';

//function BIO_meth_get_gets(p1: PBIO; p2: PUTF8Char; p3: integer; biom: PBIO_METHOD): integer;
{ TODO : Cannot convert original type "int (*)(BIO *, char *, int)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'BIO_meth_get_gets';

function BIO_meth_set_gets(biom: PBIO_METHOD; gets: BIO_meth_set_gets_gets): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_meth_set_gets';

//function BIO_meth_get_ctrl(p1: PBIOp2: integer; p3, p4: pointer; biom: PBIO_METHOD): integer;
{ TODO : Cannot convert original type "long (*)(BIO *, int, long, void *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'BIO_meth_get_ctrl';

function BIO_meth_set_ctrl(biom: PBIO_METHOD; ctrl: BIO_meth_set_ctrl_ctrl): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_meth_set_ctrl';

//function BIO_meth_get_create(p1: PBIO; bion: PBIO_METHOD): integer;
{ TODO : Cannot convert original type "int (*)(BIO *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'BIO_meth_get_create';

function BIO_meth_set_create(biom: PBIO_METHOD; create: BIO_meth_set_create_create): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_meth_set_create';

//function BIO_meth_get_destroy(p1: PBIO; biom: PBIO_METHOD): integer;
{ TODO : Cannot convert original type "int (*)(BIO *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'BIO_meth_get_destroy';

function BIO_meth_set_destroy(biom: PBIO_METHOD; destroy: BIO_meth_set_destroy_destroy): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_meth_set_destroy';

//function BIO_meth_get_callback_ctrl(p1: PBIO; p2: integer; p3: PBIO_info_cb; biom: PBIO_METHOD): integer;
{ TODO : Cannot convert original type "long (*)(BIO *, int, BIO_info_cb *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'BIO_meth_get_callback_ctrl';

function BIO_meth_set_callback_ctrl(biom: PBIO_METHOD;
    callback_ctrl: BIO_meth_set_callback_ctrl_callback_ctrl): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_meth_set_callback_ctrl';

function ERR_load_ASN1_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_ASN1_strings';

function ERR_load_BN_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_BN_strings';

procedure BN_set_flags(b: PBIGNUM; n: integer); cdecl;
  external LIB_CRYPTO name _PU + 'BN_set_flags';

function BN_get_flags(b: PBIGNUM; n: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_get_flags';

procedure BN_with_flags(dest: PBIGNUM; b: PBIGNUM; flags: integer); cdecl;
  external LIB_CRYPTO name _PU + 'BN_with_flags';

function BN_GENCB_call(cb: PBN_GENCB; a: integer; b: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_GENCB_call';

function BN_GENCB_new(): PBN_GENCB; cdecl;
  external LIB_CRYPTO name _PU + 'BN_GENCB_new';

procedure BN_GENCB_free(cb: PBN_GENCB); cdecl;
  external LIB_CRYPTO name _PU + 'BN_GENCB_free';

procedure BN_GENCB_set_old(gencb: PBN_GENCB; callback: BN_GENCB_set_old_callback; cb_arg: pointer); cdecl;
  external LIB_CRYPTO name _PU + 'BN_GENCB_set_old';

procedure BN_GENCB_set(gencb: PBN_GENCB; callback: BN_GENCB_set_callback; cb_arg: pointer); cdecl;
  external LIB_CRYPTO name _PU + 'BN_GENCB_set';

function BN_GENCB_get_arg(cb: PBN_GENCB): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_GENCB_get_arg';

function BN_abs_is_word(a: PBIGNUM; w: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_abs_is_word';

function BN_is_zero(a: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_is_zero';

function BN_is_one(a: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_is_one';

function BN_is_word(a: PBIGNUM; w: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_is_word';

function BN_is_odd(a: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_is_odd';

procedure BN_zero_ex(a: PBIGNUM); cdecl;
  external LIB_CRYPTO name _PU + 'BN_zero_ex';

function BN_value_one(): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'BN_value_one';

function BN_options(): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'BN_options';

function BN_CTX_new(): PBN_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'BN_CTX_new';

function BN_CTX_secure_new(): PBN_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'BN_CTX_secure_new';

procedure BN_CTX_free(c: PBN_CTX); cdecl;
  external LIB_CRYPTO name _PU + 'BN_CTX_free';

procedure BN_CTX_start(ctx: PBN_CTX); cdecl;
  external LIB_CRYPTO name _PU + 'BN_CTX_start';

function BN_CTX_get(ctx: PBN_CTX): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'BN_CTX_get';

procedure BN_CTX_end(ctx: PBN_CTX); cdecl;
  external LIB_CRYPTO name _PU + 'BN_CTX_end';

function BN_rand(rnd: PBIGNUM; bits: integer; top: integer; bottom: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_rand';

function BN_priv_rand(rnd: PBIGNUM; bits: integer; top: integer; bottom: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_priv_rand';

function BN_rand_range(rnd: PBIGNUM; range: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_rand_range';

function BN_priv_rand_range(rnd: PBIGNUM; range: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_priv_rand_range';

function BN_pseudo_rand(rnd: PBIGNUM; bits: integer; top: integer; bottom: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_pseudo_rand';

function BN_pseudo_rand_range(rnd: PBIGNUM; range: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_pseudo_rand_range';

function BN_num_bits_word(l: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_num_bits_word';

function BN_security_bits(L: integer; N: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_security_bits';

function BN_new(): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'BN_new';

function BN_secure_new(): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'BN_secure_new';

procedure BN_clear_free(a: PBIGNUM); cdecl;
  external LIB_CRYPTO name _PU + 'BN_clear_free';

function BN_copy(a: PBIGNUM; b: PBIGNUM): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'BN_copy';

procedure BN_swap(a: PBIGNUM; b: PBIGNUM); cdecl;
  external LIB_CRYPTO name _PU + 'BN_swap';

function BN_bn2binpad(a: PBIGNUM; _to: pointer; tolen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_bn2binpad';

function BN_lebin2bn(s: pointer; len: integer; ret: PBIGNUM): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'BN_lebin2bn';

function BN_bn2lebinpad(a: PBIGNUM; _to: pointer; tolen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_bn2lebinpad';

function BN_mpi2bn(s: pointer; len: integer; ret: PBIGNUM): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mpi2bn';

function BN_bn2mpi(a: PBIGNUM; _to: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_bn2mpi';

function BN_sub(r: PBIGNUM; a: PBIGNUM; b: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_sub';

function BN_usub(r: PBIGNUM; a: PBIGNUM; b: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_usub';

function BN_uadd(r: PBIGNUM; a: PBIGNUM; b: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_uadd';

function BN_add(r: PBIGNUM; a: PBIGNUM; b: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_add';

function BN_mul(r: PBIGNUM; a: PBIGNUM; b: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mul';

function BN_sqr(r: PBIGNUM; a: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_sqr';

(** BN_set_negative sets sign of a BIGNUM
 * \param  b  pointer to the BIGNUM object
 * \param  n  0 if the BIGNUM b should be positive and a value != 0 otherwise
 *)
procedure BN_set_negative(b: PBIGNUM; n: integer); cdecl;
  external LIB_CRYPTO name _PU + 'BN_set_negative';

(** BN_is_negative returns 1 if the BIGNUM is negative
 * \param  b  pointer to the BIGNUM object
 * \return 1 if a < 0 and 0 otherwise
 *)
function BN_is_negative(b: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_is_negative';

function BN_div(dv: PBIGNUM; rem: PBIGNUM; m: PBIGNUM; d: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_div';

function BN_nnmod(r: PBIGNUM; m: PBIGNUM; d: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_nnmod';

function BN_mod_add(r: PBIGNUM; a: PBIGNUM; b: PBIGNUM; m: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mod_add';

function BN_mod_add_quick(r: PBIGNUM; a: PBIGNUM; b: PBIGNUM; m: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mod_add_quick';

function BN_mod_sub(r: PBIGNUM; a: PBIGNUM; b: PBIGNUM; m: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mod_sub';

function BN_mod_sub_quick(r: PBIGNUM; a: PBIGNUM; b: PBIGNUM; m: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mod_sub_quick';

function BN_mod_mul(r: PBIGNUM; a: PBIGNUM; b: PBIGNUM; m: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mod_mul';

function BN_mod_sqr(r: PBIGNUM; a: PBIGNUM; m: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mod_sqr';

function BN_mod_lshift1(r: PBIGNUM; a: PBIGNUM; m: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mod_lshift1';

function BN_mod_lshift1_quick(r: PBIGNUM; a: PBIGNUM; m: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mod_lshift1_quick';

function BN_mod_lshift(r: PBIGNUM; a: PBIGNUM; n: integer; m: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mod_lshift';

function BN_mod_lshift_quick(r: PBIGNUM; a: PBIGNUM; n: integer; m: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mod_lshift_quick';

function BN_mod_word(a: PBIGNUM; w: cardinal): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mod_word';

function BN_div_word(a: PBIGNUM; w: cardinal): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'BN_div_word';

function BN_mul_word(a: PBIGNUM; w: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mul_word';

function BN_add_word(a: PBIGNUM; w: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_add_word';

function BN_sub_word(a: PBIGNUM; w: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_sub_word';

function BN_set_word(a: PBIGNUM; w: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_set_word';

function BN_get_word(a: PBIGNUM): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'BN_get_word';

function BN_cmp(a: PBIGNUM; b: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_cmp';

function BN_is_bit_set(a: PBIGNUM; n: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_is_bit_set';

function BN_lshift(r: PBIGNUM; a: PBIGNUM; n: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_lshift';

function BN_lshift1(r: PBIGNUM; a: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_lshift1';

function BN_exp(r: PBIGNUM; a: PBIGNUM; p: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_exp';

function BN_mod_exp(r: PBIGNUM; a: PBIGNUM; p: PBIGNUM; m: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mod_exp';

function BN_mod_exp_mont(r: PBIGNUM; a: PBIGNUM; p: PBIGNUM; m: PBIGNUM; ctx: PBN_CTX; m_ctx: PBN_MONT_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mod_exp_mont';

function BN_mod_exp_mont_consttime(rr: PBIGNUM; a: PBIGNUM; p: PBIGNUM; m: PBIGNUM; ctx: PBN_CTX; in_mont: PBN_MONT_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mod_exp_mont_consttime';

function BN_mod_exp_mont_word(r: PBIGNUM; a: cardinal; p: PBIGNUM; m: PBIGNUM; ctx: PBN_CTX; m_ctx: PBN_MONT_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mod_exp_mont_word';

function BN_mod_exp2_mont(r: PBIGNUM; a1: PBIGNUM; p1: PBIGNUM; a2: PBIGNUM; p2: PBIGNUM; m: PBIGNUM; ctx: PBN_CTX; m_ctx: PBN_MONT_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mod_exp2_mont';

function BN_mod_exp_simple(r: PBIGNUM; a: PBIGNUM; p: PBIGNUM; m: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mod_exp_simple';

function BN_mask_bits(a: PBIGNUM; n: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mask_bits';

function BN_print_fp(fp: PPointer; a: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_print_fp';

function BN_print(bio: PBIO; a: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_print';

function BN_reciprocal(r: PBIGNUM; m: PBIGNUM; len: integer; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_reciprocal';

function BN_rshift(r: PBIGNUM; a: PBIGNUM; n: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_rshift';

function BN_rshift1(r: PBIGNUM; a: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_rshift1';

procedure BN_clear(a: PBIGNUM); cdecl;
  external LIB_CRYPTO name _PU + 'BN_clear';

function BN_dup(a: PBIGNUM): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'BN_dup';

function BN_ucmp(a: PBIGNUM; b: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_ucmp';

function BN_set_bit(a: PBIGNUM; n: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_set_bit';

function BN_clear_bit(a: PBIGNUM; n: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_clear_bit';

function BN_bn2hex(a: PBIGNUM): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'BN_bn2hex';

function BN_hex2bn(a: PPBIGNUM; str: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_hex2bn';

function BN_asc2bn(a: PPBIGNUM; str: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_asc2bn';

function BN_gcd(r: PBIGNUM; a: PBIGNUM; b: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_gcd';

function BN_kronecker(a: PBIGNUM; b: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_kronecker';

function BN_mod_inverse(ret: PBIGNUM; a: PBIGNUM; n: PBIGNUM; ctx: PBN_CTX): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mod_inverse';

function BN_mod_sqrt(ret: PBIGNUM; a: PBIGNUM; n: PBIGNUM; ctx: PBN_CTX): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mod_sqrt';

procedure BN_consttime_swap(swap: cardinal; a: PBIGNUM; b: PBIGNUM; nwords: integer); cdecl;
  external LIB_CRYPTO name _PU + 'BN_consttime_swap';

function BN_generate_prime(ret: PBIGNUM; bits: integer; safe: integer; add: PBIGNUM; rem: PBIGNUM; callback: BN_generate_prime_callback; cb_arg: pointer): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'BN_generate_prime';

function BN_is_prime(p: PBIGNUM; nchecks: integer; callback: BN_is_prime_callback; ctx: PBN_CTX; cb_arg: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_is_prime';

function BN_is_prime_fasttest(p: PBIGNUM; nchecks: integer; callback: BN_is_prime_fasttest_callback; ctx: PBN_CTX; cb_arg: pointer; do_trial_division: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_is_prime_fasttest';

function BN_generate_prime_ex(ret: PBIGNUM; bits: integer; safe: integer; add: PBIGNUM; rem: PBIGNUM; cb: PBN_GENCB): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_generate_prime_ex';

function BN_is_prime_ex(p: PBIGNUM; nchecks: integer; ctx: PBN_CTX; cb: PBN_GENCB): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_is_prime_ex';

function BN_is_prime_fasttest_ex(p: PBIGNUM; nchecks: integer; ctx: PBN_CTX; do_trial_division: integer; cb: PBN_GENCB): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_is_prime_fasttest_ex';

function BN_X931_generate_Xpq(Xp: PBIGNUM; Xq: PBIGNUM; nbits: integer; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_X931_generate_Xpq';

function BN_X931_derive_prime_ex(p: PBIGNUM; p1: PBIGNUM; p2: PBIGNUM; Xp: PBIGNUM; Xp1: PBIGNUM; Xp2: PBIGNUM; e: PBIGNUM; ctx: PBN_CTX; cb: PBN_GENCB): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_X931_derive_prime_ex';

function BN_X931_generate_prime_ex(p: PBIGNUM; p1: PBIGNUM; p2: PBIGNUM; Xp1: PBIGNUM; Xp2: PBIGNUM; Xp: PBIGNUM; e: PBIGNUM; ctx: PBN_CTX; cb: PBN_GENCB): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_X931_generate_prime_ex';

function BN_MONT_CTX_new(): PBN_MONT_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'BN_MONT_CTX_new';

function BN_mod_mul_montgomery(r: PBIGNUM; a: PBIGNUM; b: PBIGNUM; mont: PBN_MONT_CTX; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mod_mul_montgomery';

function BN_to_montgomery(r: PBIGNUM; a: PBIGNUM; mont: PBN_MONT_CTX; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_to_montgomery';

function BN_from_montgomery(r: PBIGNUM; a: PBIGNUM; mont: PBN_MONT_CTX; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_from_montgomery';

procedure BN_MONT_CTX_free(mont: PBN_MONT_CTX); cdecl;
  external LIB_CRYPTO name _PU + 'BN_MONT_CTX_free';

function BN_MONT_CTX_set(mont: PBN_MONT_CTX; _mod: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_MONT_CTX_set';

function BN_MONT_CTX_copy(_to: PBN_MONT_CTX; from: PBN_MONT_CTX): PBN_MONT_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'BN_MONT_CTX_copy';

function BN_MONT_CTX_set_locked(pmont: PPBN_MONT_CTX; lock: PCRYPTO_RWLOCK; _mod: PBIGNUM; ctx: PBN_CTX): PBN_MONT_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'BN_MONT_CTX_set_locked';

function BN_BLINDING_new(A: PBIGNUM; Ai: PBIGNUM; _mod: PBIGNUM): PBN_BLINDING; cdecl;
  external LIB_CRYPTO name _PU + 'BN_BLINDING_new';

procedure BN_BLINDING_free(b: PBN_BLINDING); cdecl;
  external LIB_CRYPTO name _PU + 'BN_BLINDING_free';

function BN_BLINDING_update(b: PBN_BLINDING; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_BLINDING_update';

function BN_BLINDING_convert(n: PBIGNUM; b: PBN_BLINDING; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_BLINDING_convert';

function BN_BLINDING_invert(n: PBIGNUM; b: PBN_BLINDING; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_BLINDING_invert';

function BN_BLINDING_convert_ex(n: PBIGNUM; r: PBIGNUM; b: PBN_BLINDING; p4: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_BLINDING_convert_ex';

function BN_BLINDING_invert_ex(n: PBIGNUM; r: PBIGNUM; b: PBN_BLINDING; p4: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_BLINDING_invert_ex';

function BN_BLINDING_is_current_thread(b: PBN_BLINDING): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_BLINDING_is_current_thread';

procedure BN_BLINDING_set_current_thread(b: PBN_BLINDING); cdecl;
  external LIB_CRYPTO name _PU + 'BN_BLINDING_set_current_thread';

function BN_BLINDING_lock(b: PBN_BLINDING): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_BLINDING_lock';

function BN_BLINDING_unlock(b: PBN_BLINDING): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_BLINDING_unlock';

function BN_BLINDING_get_flags(p1: PBN_BLINDING): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'BN_BLINDING_get_flags';

procedure BN_BLINDING_set_flags(p1: PBN_BLINDING; p2: cardinal); cdecl;
  external LIB_CRYPTO name _PU + 'BN_BLINDING_set_flags';

function BN_BLINDING_create_param(b: PBN_BLINDING; e: PBIGNUM; m: PBIGNUM; ctx: PBN_CTX; bn_mod_exp: BN_BLINDING_create_param_bn_mod_exp; m_ctx: PBN_MONT_CTX): PBN_BLINDING; cdecl;
  external LIB_CRYPTO name _PU + 'BN_BLINDING_create_param';

procedure BN_set_params(mul: integer; high: integer; low: integer; mont: integer); cdecl;
  external LIB_CRYPTO name _PU + 'BN_set_params';

function BN_get_params(which: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_get_params';

function BN_RECP_CTX_new(): PBN_RECP_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'BN_RECP_CTX_new';

procedure BN_RECP_CTX_free(recp: PBN_RECP_CTX); cdecl;
  external LIB_CRYPTO name _PU + 'BN_RECP_CTX_free';

function BN_RECP_CTX_set(recp: PBN_RECP_CTX; rdiv: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_RECP_CTX_set';

function BN_mod_mul_reciprocal(r: PBIGNUM; x: PBIGNUM; y: PBIGNUM; recp: PBN_RECP_CTX; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mod_mul_reciprocal';

function BN_mod_exp_recp(r: PBIGNUM; a: PBIGNUM; p: PBIGNUM; m: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_mod_exp_recp';

function BN_div_recp(dv: PBIGNUM; rem: PBIGNUM; m: PBIGNUM; recp: PBN_RECP_CTX; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_div_recp';

function BN_GF2m_add(r: PBIGNUM; a: PBIGNUM; b: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_GF2m_add';

function BN_GF2m_mod(r: PBIGNUM; a: PBIGNUM; p: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_GF2m_mod';

function BN_GF2m_mod_mul(r: PBIGNUM; a: PBIGNUM; b: PBIGNUM; p: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_GF2m_mod_mul';

function BN_GF2m_mod_sqr(r: PBIGNUM; a: PBIGNUM; p: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_GF2m_mod_sqr';

function BN_GF2m_mod_inv(r: PBIGNUM; b: PBIGNUM; p: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_GF2m_mod_inv';

function BN_GF2m_mod_div(r: PBIGNUM; a: PBIGNUM; b: PBIGNUM; p: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_GF2m_mod_div';

function BN_GF2m_mod_exp(r: PBIGNUM; a: PBIGNUM; b: PBIGNUM; p: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_GF2m_mod_exp';

function BN_GF2m_mod_sqrt(r: PBIGNUM; a: PBIGNUM; p: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_GF2m_mod_sqrt';

function BN_GF2m_mod_solve_quad(r: PBIGNUM; a: PBIGNUM; p: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_GF2m_mod_solve_quad';

function BN_GF2m_mod_arr(r: PBIGNUM; a: PBIGNUM; p: PInteger): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_GF2m_mod_arr';

function BN_GF2m_mod_mul_arr(r: PBIGNUM; a: PBIGNUM; b: PBIGNUM; p: PInteger; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_GF2m_mod_mul_arr';

function BN_GF2m_mod_sqr_arr(r: PBIGNUM; a: PBIGNUM; p: PInteger; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_GF2m_mod_sqr_arr';

function BN_GF2m_mod_inv_arr(r: PBIGNUM; b: PBIGNUM; p: PInteger; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_GF2m_mod_inv_arr';

function BN_GF2m_mod_div_arr(r: PBIGNUM; a: PBIGNUM; b: PBIGNUM; p: PInteger; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_GF2m_mod_div_arr';

function BN_GF2m_mod_exp_arr(r: PBIGNUM; a: PBIGNUM; b: PBIGNUM; p: PInteger; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_GF2m_mod_exp_arr';

function BN_GF2m_mod_sqrt_arr(r: PBIGNUM; a: PBIGNUM; p: PInteger; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_GF2m_mod_sqrt_arr';

function BN_GF2m_mod_solve_quad_arr(r: PBIGNUM; a: PBIGNUM; p: PInteger; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_GF2m_mod_solve_quad_arr';

function BN_GF2m_poly2arr(a: PBIGNUM; p: PInteger; max: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_GF2m_poly2arr';

function BN_GF2m_arr2poly(p: PInteger; a: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_GF2m_arr2poly';

function BN_nist_mod_192(r: PBIGNUM; a: PBIGNUM; p: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_nist_mod_192';

function BN_nist_mod_224(r: PBIGNUM; a: PBIGNUM; p: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_nist_mod_224';

function BN_nist_mod_256(r: PBIGNUM; a: PBIGNUM; p: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_nist_mod_256';

function BN_nist_mod_384(r: PBIGNUM; a: PBIGNUM; p: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_nist_mod_384';

function BN_nist_mod_521(r: PBIGNUM; a: PBIGNUM; p: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_nist_mod_521';

function BN_get0_nist_prime_192(): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'BN_get0_nist_prime_192';

function BN_get0_nist_prime_224(): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'BN_get0_nist_prime_224';

function BN_get0_nist_prime_256(): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'BN_get0_nist_prime_256';

function BN_get0_nist_prime_384(): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'BN_get0_nist_prime_384';

function BN_get0_nist_prime_521(): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'BN_get0_nist_prime_521';

//function BN_nist_mod_func(r: PBIGNUM; a: PBIGNUM; field: PBIGNUM; ctx: PBN_CTX; p: PBIGNUM): integer;
{ TODO : Cannot convert original type "int (*)(BIGNUM *, const BIGNUM *, const BIGNUM *, BN_CTX *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'BN_nist_mod_func';

function BN_generate_dsa_nonce(_out: PBIGNUM; range: PBIGNUM; priv: PBIGNUM; _message: PByte; message_len: PtrUInt; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_generate_dsa_nonce';

function BN_get_rfc2409_prime_768(bn: PBIGNUM): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'BN_get_rfc2409_prime_768';

function BN_get_rfc2409_prime_1024(bn: PBIGNUM): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'BN_get_rfc2409_prime_1024';

function BN_get_rfc3526_prime_1536(bn: PBIGNUM): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'BN_get_rfc3526_prime_1536';

function BN_get_rfc3526_prime_2048(bn: PBIGNUM): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'BN_get_rfc3526_prime_2048';

function BN_get_rfc3526_prime_3072(bn: PBIGNUM): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'BN_get_rfc3526_prime_3072';

function BN_get_rfc3526_prime_4096(bn: PBIGNUM): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'BN_get_rfc3526_prime_4096';

function BN_get_rfc3526_prime_6144(bn: PBIGNUM): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'BN_get_rfc3526_prime_6144';

function BN_get_rfc3526_prime_8192(bn: PBIGNUM): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'BN_get_rfc3526_prime_8192';

function BN_bntest_rand(rnd: PBIGNUM; bits: integer; top: integer; bottom: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BN_bntest_rand';

function d2i_ASN1_SEQUENCE_ANY(a: PPASN1_SEQUENCE_ANY; _in: PPByte; len: integer): PASN1_SEQUENCE_ANY; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASN1_SEQUENCE_ANY';

function i2d_ASN1_SEQUENCE_ANY(a: PASN1_SEQUENCE_ANY; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASN1_SEQUENCE_ANY';

function ASN1_SEQUENCE_ANY_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_SEQUENCE_ANY_it';

function d2i_ASN1_SET_ANY(a: PPASN1_SEQUENCE_ANY; _in: PPByte; len: integer): PASN1_SEQUENCE_ANY; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASN1_SET_ANY';

function i2d_ASN1_SET_ANY(a: PASN1_SEQUENCE_ANY; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASN1_SET_ANY';

function ASN1_SET_ANY_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_SET_ANY_it';

function ASN1_TYPE_new(): PASN1_TYPE; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_TYPE_new';

procedure ASN1_TYPE_free(a: PASN1_TYPE); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_TYPE_free';

function d2i_ASN1_TYPE(a: PPASN1_TYPE; _in: PPByte; len: integer): PASN1_TYPE; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASN1_TYPE';

function i2d_ASN1_TYPE(a: PASN1_TYPE; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASN1_TYPE';

function ASN1_ANY_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_ANY_it';

function ASN1_TYPE_get(a: PASN1_TYPE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_TYPE_get';

procedure ASN1_TYPE_set(a: PASN1_TYPE; typ: integer; value: pointer); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_TYPE_set';

function ASN1_TYPE_set1(a: PASN1_TYPE; typ: integer; value: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_TYPE_set1';

function ASN1_TYPE_cmp(a: PASN1_TYPE; b: PASN1_TYPE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_TYPE_cmp';

function ASN1_TYPE_pack_sequence(it: PASN1_ITEM; s: pointer; t: PPASN1_TYPE): PASN1_TYPE; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_TYPE_pack_sequence';

function ASN1_TYPE_unpack_sequence(it: PASN1_ITEM; t: PASN1_TYPE): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_TYPE_unpack_sequence';

function ASN1_OBJECT_new(): PASN1_OBJECT; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_OBJECT_new';

procedure ASN1_OBJECT_free(a: PASN1_OBJECT); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_OBJECT_free';

function i2d_ASN1_OBJECT(a: PASN1_OBJECT; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASN1_OBJECT';

function d2i_ASN1_OBJECT(a: PPASN1_OBJECT; pp: PPByte; length: integer): PASN1_OBJECT; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASN1_OBJECT';

function ASN1_OBJECT_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_OBJECT_it';

function ASN1_STRING_new(): PASN1_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_STRING_new';

procedure ASN1_STRING_free(a: PASN1_STRING); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_STRING_free';

procedure ASN1_STRING_clear_free(a: PASN1_STRING); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_STRING_clear_free';

function ASN1_STRING_copy(dst: PASN1_STRING; str: PASN1_STRING): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_STRING_copy';

function ASN1_STRING_dup(a: PASN1_STRING): PASN1_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_STRING_dup';

function ASN1_STRING_type_new(typ: integer): PASN1_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_STRING_type_new';

function ASN1_STRING_cmp(a: PASN1_STRING; b: PASN1_STRING): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_STRING_cmp';

function ASN1_STRING_set(str: PASN1_STRING; data: pointer; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_STRING_set';

procedure ASN1_STRING_set0(str: PASN1_STRING; data: pointer; len: integer); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_STRING_set0';

procedure ASN1_STRING_length_set(x: PASN1_STRING; n: integer); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_STRING_length_set';

function ASN1_STRING_get0_data(x: PASN1_STRING): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_STRING_get0_data';

function ASN1_BIT_STRING_new(): PASN1_BIT_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_BIT_STRING_new';

procedure ASN1_BIT_STRING_free(a: PASN1_BIT_STRING); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_BIT_STRING_free';

function d2i_ASN1_BIT_STRING(a: PPASN1_BIT_STRING; _in: PPByte; len: integer): PASN1_BIT_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASN1_BIT_STRING';

function i2d_ASN1_BIT_STRING(a: PASN1_BIT_STRING; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASN1_BIT_STRING';

function ASN1_BIT_STRING_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_BIT_STRING_it';

function ASN1_BIT_STRING_set(a: PASN1_BIT_STRING; d: PByte; length: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_BIT_STRING_set';

function ASN1_BIT_STRING_set_bit(a: PASN1_BIT_STRING; n: integer; value: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_BIT_STRING_set_bit';

function ASN1_BIT_STRING_check(a: PASN1_BIT_STRING; flags: PByte; flags_len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_BIT_STRING_check';

function ASN1_BIT_STRING_name_print(_out: PBIO; bs: PASN1_BIT_STRING; tbl: PBIT_STRING_BITNAME; indent: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_BIT_STRING_name_print';

function ASN1_BIT_STRING_num_asc(name: PUtf8Char; tbl: PBIT_STRING_BITNAME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_BIT_STRING_num_asc';

function ASN1_BIT_STRING_set_asc(bs: PASN1_BIT_STRING; name: PUtf8Char; value: integer; tbl: PBIT_STRING_BITNAME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_BIT_STRING_set_asc';

function d2i_ASN1_INTEGER(a: PPASN1_INTEGER; _in: PPByte; len: integer): PASN1_INTEGER; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASN1_INTEGER';

function i2d_ASN1_INTEGER(a: PASN1_INTEGER; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASN1_INTEGER';

function ASN1_INTEGER_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_INTEGER_it';

function d2i_ASN1_UINTEGER(a: PPASN1_INTEGER; pp: PPByte; length: integer): PASN1_INTEGER; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASN1_UINTEGER';

function ASN1_INTEGER_dup(x: PASN1_INTEGER): PASN1_INTEGER; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_INTEGER_dup';

function ASN1_INTEGER_cmp(x: PASN1_INTEGER; y: PASN1_INTEGER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_INTEGER_cmp';

function d2i_ASN1_ENUMERATED(a: PPASN1_ENUMERATED; _in: PPByte; len: integer): PASN1_ENUMERATED; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASN1_ENUMERATED';

function i2d_ASN1_ENUMERATED(a: PASN1_ENUMERATED; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASN1_ENUMERATED';

function ASN1_ENUMERATED_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_ENUMERATED_it';

function ASN1_UTCTIME_check(a: PASN1_UTCTIME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_UTCTIME_check';

function ASN1_UTCTIME_set(s: PASN1_UTCTIME; t: time_t): PASN1_UTCTIME; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_UTCTIME_set';

function ASN1_UTCTIME_adj(s: PASN1_UTCTIME; t: time_t; offset_day: integer; offset_sec: integer): PASN1_UTCTIME; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_UTCTIME_adj';

function ASN1_UTCTIME_set_string(s: PASN1_UTCTIME; str: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_UTCTIME_set_string';

function ASN1_UTCTIME_cmp_time_t(s: PASN1_UTCTIME; t: time_t): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_UTCTIME_cmp_time_t';

function ASN1_GENERALIZEDTIME_check(a: PASN1_GENERALIZEDTIME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_GENERALIZEDTIME_check';

function ASN1_GENERALIZEDTIME_set(s: PASN1_GENERALIZEDTIME; t: time_t): PASN1_GENERALIZEDTIME; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_GENERALIZEDTIME_set';

function ASN1_GENERALIZEDTIME_adj(s: PASN1_GENERALIZEDTIME; t: time_t; offset_day: integer; offset_sec: integer): PASN1_GENERALIZEDTIME; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_GENERALIZEDTIME_adj';

function ASN1_GENERALIZEDTIME_set_string(s: PASN1_GENERALIZEDTIME; str: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_GENERALIZEDTIME_set_string';

function ASN1_TIME_diff(pday: PInteger; psec: PInteger; from: PASN1_TIME; _to: PASN1_TIME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_TIME_diff';

function ASN1_OCTET_STRING_new(): PASN1_OCTET_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_OCTET_STRING_new';

procedure ASN1_OCTET_STRING_free(a: PASN1_OCTET_STRING); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_OCTET_STRING_free';

function d2i_ASN1_OCTET_STRING(a: PPASN1_OCTET_STRING; _in: PPByte; len: integer): PASN1_OCTET_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASN1_OCTET_STRING';

function i2d_ASN1_OCTET_STRING(a: PASN1_OCTET_STRING; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASN1_OCTET_STRING';

function ASN1_OCTET_STRING_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_OCTET_STRING_it';

function ASN1_OCTET_STRING_dup(a: PASN1_OCTET_STRING): PASN1_OCTET_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_OCTET_STRING_dup';

function ASN1_OCTET_STRING_cmp(a: PASN1_OCTET_STRING; b: PASN1_OCTET_STRING): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_OCTET_STRING_cmp';

function ASN1_OCTET_STRING_set(str: PASN1_OCTET_STRING; data: PByte; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_OCTET_STRING_set';

function ASN1_VISIBLESTRING_new(): PASN1_VISIBLESTRING; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_VISIBLESTRING_new';

procedure ASN1_VISIBLESTRING_free(a: PASN1_VISIBLESTRING); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_VISIBLESTRING_free';

function d2i_ASN1_VISIBLESTRING(a: PPASN1_VISIBLESTRING; _in: PPByte; len: integer): PASN1_VISIBLESTRING; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASN1_VISIBLESTRING';

function i2d_ASN1_VISIBLESTRING(a: PASN1_VISIBLESTRING; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASN1_VISIBLESTRING';

function ASN1_VISIBLESTRING_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_VISIBLESTRING_it';

function ASN1_UNIVERSALSTRING_new(): PASN1_UNIVERSALSTRING; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_UNIVERSALSTRING_new';

procedure ASN1_UNIVERSALSTRING_free(a: PASN1_UNIVERSALSTRING); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_UNIVERSALSTRING_free';

function d2i_ASN1_UNIVERSALSTRING(a: PPASN1_UNIVERSALSTRING; _in: PPByte; len: integer): PASN1_UNIVERSALSTRING; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASN1_UNIVERSALSTRING';

function i2d_ASN1_UNIVERSALSTRING(a: PASN1_UNIVERSALSTRING; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASN1_UNIVERSALSTRING';

function ASN1_UNIVERSALSTRING_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_UNIVERSALSTRING_it';

function ASN1_UTF8STRING_new(): PASN1_UTF8STRING; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_UTF8STRING_new';

procedure ASN1_UTF8STRING_free(a: PASN1_UTF8STRING); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_UTF8STRING_free';

function d2i_ASN1_UTF8STRING(a: PPASN1_UTF8STRING; _in: PPByte; len: integer): PASN1_UTF8STRING; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASN1_UTF8STRING';

function i2d_ASN1_UTF8STRING(a: PASN1_UTF8STRING; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASN1_UTF8STRING';

function ASN1_UTF8STRING_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_UTF8STRING_it';

function ASN1_NULL_new(): PASN1_NULL; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_NULL_new';

procedure ASN1_NULL_free(a: PASN1_NULL); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_NULL_free';

function d2i_ASN1_NULL(a: PPASN1_NULL; _in: PPByte; len: integer): PASN1_NULL; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASN1_NULL';

function i2d_ASN1_NULL(a: PASN1_NULL; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASN1_NULL';

function ASN1_NULL_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_NULL_it';

function ASN1_BMPSTRING_new(): PASN1_BMPSTRING; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_BMPSTRING_new';

procedure ASN1_BMPSTRING_free(a: PASN1_BMPSTRING); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_BMPSTRING_free';

function d2i_ASN1_BMPSTRING(a: PPASN1_BMPSTRING; _in: PPByte; len: integer): PASN1_BMPSTRING; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASN1_BMPSTRING';

function i2d_ASN1_BMPSTRING(a: PASN1_BMPSTRING; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASN1_BMPSTRING';

function ASN1_BMPSTRING_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_BMPSTRING_it';

function UTF8_getc(str: PByte; len: integer; val: PCardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UTF8_getc';

function UTF8_putc(str: PByte; len: integer; value: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UTF8_putc';

function ASN1_PRINTABLE_new(): PASN1_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_PRINTABLE_new';

procedure ASN1_PRINTABLE_free(a: PASN1_STRING); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_PRINTABLE_free';

function d2i_ASN1_PRINTABLE(a: PPASN1_STRING; _in: PPByte; len: integer): PASN1_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASN1_PRINTABLE';

function i2d_ASN1_PRINTABLE(a: PASN1_STRING; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASN1_PRINTABLE';

function ASN1_PRINTABLE_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_PRINTABLE_it';

function DIRECTORYSTRING_new(): PASN1_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'DIRECTORYSTRING_new';

procedure DIRECTORYSTRING_free(a: PASN1_STRING); cdecl;
  external LIB_CRYPTO name _PU + 'DIRECTORYSTRING_free';

function d2i_DIRECTORYSTRING(a: PPASN1_STRING; _in: PPByte; len: integer): PASN1_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_DIRECTORYSTRING';

function i2d_DIRECTORYSTRING(a: PASN1_STRING; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_DIRECTORYSTRING';

function DIRECTORYSTRING_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'DIRECTORYSTRING_it';

function DISPLAYTEXT_new(): PASN1_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'DISPLAYTEXT_new';

procedure DISPLAYTEXT_free(a: PASN1_STRING); cdecl;
  external LIB_CRYPTO name _PU + 'DISPLAYTEXT_free';

function d2i_DISPLAYTEXT(a: PPASN1_STRING; _in: PPByte; len: integer): PASN1_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_DISPLAYTEXT';

function i2d_DISPLAYTEXT(a: PASN1_STRING; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_DISPLAYTEXT';

function DISPLAYTEXT_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'DISPLAYTEXT_it';

function ASN1_PRINTABLESTRING_new(): PASN1_PRINTABLESTRING; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_PRINTABLESTRING_new';

procedure ASN1_PRINTABLESTRING_free(a: PASN1_PRINTABLESTRING); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_PRINTABLESTRING_free';

function d2i_ASN1_PRINTABLESTRING(a: PPASN1_PRINTABLESTRING; _in: PPByte; len: integer): PASN1_PRINTABLESTRING; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASN1_PRINTABLESTRING';

function i2d_ASN1_PRINTABLESTRING(a: PASN1_PRINTABLESTRING; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASN1_PRINTABLESTRING';

function ASN1_PRINTABLESTRING_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_PRINTABLESTRING_it';

function ASN1_T61STRING_new(): PASN1_T61STRING; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_T61STRING_new';

procedure ASN1_T61STRING_free(a: PASN1_T61STRING); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_T61STRING_free';

function d2i_ASN1_T61STRING(a: PPASN1_T61STRING; _in: PPByte; len: integer): PASN1_T61STRING; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASN1_T61STRING';

function i2d_ASN1_T61STRING(a: PASN1_T61STRING; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASN1_T61STRING';

function ASN1_T61STRING_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_T61STRING_it';

function ASN1_IA5STRING_new(): PASN1_IA5STRING; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_IA5STRING_new';

procedure ASN1_IA5STRING_free(a: PASN1_IA5STRING); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_IA5STRING_free';

function d2i_ASN1_IA5STRING(a: PPASN1_IA5STRING; _in: PPByte; len: integer): PASN1_IA5STRING; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASN1_IA5STRING';

function i2d_ASN1_IA5STRING(a: PASN1_IA5STRING; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASN1_IA5STRING';

function ASN1_IA5STRING_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_IA5STRING_it';

function ASN1_GENERALSTRING_new(): PASN1_GENERALSTRING; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_GENERALSTRING_new';

procedure ASN1_GENERALSTRING_free(a: PASN1_GENERALSTRING); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_GENERALSTRING_free';

function d2i_ASN1_GENERALSTRING(a: PPASN1_GENERALSTRING; _in: PPByte; len: integer): PASN1_GENERALSTRING; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASN1_GENERALSTRING';

function i2d_ASN1_GENERALSTRING(a: PASN1_GENERALSTRING; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASN1_GENERALSTRING';

function ASN1_GENERALSTRING_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_GENERALSTRING_it';

function ASN1_UTCTIME_new(): PASN1_UTCTIME; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_UTCTIME_new';

procedure ASN1_UTCTIME_free(a: PASN1_UTCTIME); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_UTCTIME_free';

function d2i_ASN1_UTCTIME(a: PPASN1_UTCTIME; _in: PPByte; len: integer): PASN1_UTCTIME; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASN1_UTCTIME';

function i2d_ASN1_UTCTIME(a: PASN1_UTCTIME; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASN1_UTCTIME';

function ASN1_UTCTIME_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_UTCTIME_it';

function ASN1_GENERALIZEDTIME_new(): PASN1_GENERALIZEDTIME; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_GENERALIZEDTIME_new';

procedure ASN1_GENERALIZEDTIME_free(a: PASN1_GENERALIZEDTIME); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_GENERALIZEDTIME_free';

function d2i_ASN1_GENERALIZEDTIME(a: PPASN1_GENERALIZEDTIME; _in: PPByte; len: integer): PASN1_GENERALIZEDTIME; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASN1_GENERALIZEDTIME';

function i2d_ASN1_GENERALIZEDTIME(a: PASN1_GENERALIZEDTIME; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASN1_GENERALIZEDTIME';

function ASN1_GENERALIZEDTIME_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_GENERALIZEDTIME_it';

function d2i_ASN1_TIME(a: PPASN1_TIME; _in: PPByte; len: integer): PASN1_TIME; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASN1_TIME';

function i2d_ASN1_TIME(a: PASN1_TIME; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASN1_TIME';

function ASN1_TIME_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_TIME_it';

function ASN1_OCTET_STRING_NDEF_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_OCTET_STRING_NDEF_it';

function ASN1_TIME_adj(s: PASN1_TIME; t: time_t; offset_day: integer; offset_sec: integer): PASN1_TIME; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_TIME_adj';

function ASN1_TIME_check(t: PASN1_TIME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_TIME_check';

function ASN1_TIME_to_generalizedtime(t: PASN1_TIME; _out: PPASN1_GENERALIZEDTIME): PASN1_GENERALIZEDTIME; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_TIME_to_generalizedtime';

function ASN1_TIME_set_string(s: PASN1_TIME; str: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_TIME_set_string';

function ASN1_TIME_cmp_time_t(s: PASN1_TIME; t: time_t): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_TIME_cmp_time_t';

function ASN1_TIME_compare(a: PASN1_TIME; b: PASN1_TIME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_TIME_compare';

function i2a_ASN1_INTEGER(bp: PBIO; a: PASN1_INTEGER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2a_ASN1_INTEGER';

function a2i_ASN1_INTEGER(bp: PBIO; bs: PASN1_INTEGER; buf: PUtf8Char; size: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'a2i_ASN1_INTEGER';

function i2a_ASN1_ENUMERATED(bp: PBIO; a: PASN1_ENUMERATED): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2a_ASN1_ENUMERATED';

function a2i_ASN1_ENUMERATED(bp: PBIO; bs: PASN1_ENUMERATED; buf: PUtf8Char; size: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'a2i_ASN1_ENUMERATED';

function i2a_ASN1_OBJECT(bp: PBIO; a: PASN1_OBJECT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2a_ASN1_OBJECT';

function a2i_ASN1_STRING(bp: PBIO; bs: PASN1_STRING; buf: PUtf8Char; size: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'a2i_ASN1_STRING';

function i2a_ASN1_STRING(bp: PBIO; a: PASN1_STRING; typ: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2a_ASN1_STRING';

function i2t_ASN1_OBJECT(buf: PUtf8Char; buf_len: integer; a: PASN1_OBJECT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2t_ASN1_OBJECT';

function a2d_ASN1_OBJECT(_out: PByte; olen: integer; buf: PUtf8Char; num: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'a2d_ASN1_OBJECT';

function ASN1_OBJECT_create(nid: integer; data: PByte; len: integer; sn: PUtf8Char; ln: PUtf8Char): PASN1_OBJECT; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_OBJECT_create';

function ASN1_INTEGER_get_int64(pr: PInt64; a: PASN1_INTEGER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_INTEGER_get_int64';

function ASN1_INTEGER_set_int64(a: PASN1_INTEGER; r: Int64): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_INTEGER_set_int64';

function ASN1_INTEGER_get_uint64(pr: PQWord; a: PASN1_INTEGER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_INTEGER_get_uint64';

function ASN1_INTEGER_set_uint64(a: PASN1_INTEGER; r: Qword): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_INTEGER_set_uint64';

function ASN1_INTEGER_set(a: PASN1_INTEGER; v: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_INTEGER_set';

function ASN1_INTEGER_get(a: PASN1_INTEGER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_INTEGER_get';

function ASN1_ENUMERATED_get_int64(pr: PInt64; a: PASN1_ENUMERATED): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_ENUMERATED_get_int64';

function ASN1_ENUMERATED_set_int64(a: PASN1_ENUMERATED; r: Int64): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_ENUMERATED_set_int64';

function BN_to_ASN1_ENUMERATED(bn: PBIGNUM; ai: PASN1_ENUMERATED): PASN1_ENUMERATED; cdecl;
  external LIB_CRYPTO name _PU + 'BN_to_ASN1_ENUMERATED';

function ASN1_ENUMERATED_to_BN(ai: PASN1_ENUMERATED; bn: PBIGNUM): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_ENUMERATED_to_BN';

function ASN1_PRINTABLE_type(s: PByte; max: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_PRINTABLE_type';

function ASN1_tag2bit(tag: integer): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_tag2bit';

function ASN1_get_object(pp: PPByte; plength: PInteger; ptag: PInteger; pclass: PInteger; omax: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_get_object';

function ASN1_check_infinite_end(p: PPByte; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_check_infinite_end';

function ASN1_const_check_infinite_end(p: PPByte; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_const_check_infinite_end';

procedure ASN1_put_object(pp: PPByte; constructed: integer; length: integer; tag: integer; xclass: integer); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_put_object';

function ASN1_put_eoc(pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_put_eoc';

function ASN1_object_size(constructed: integer; length: integer; tag: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_object_size';

function ASN1_dup(i2d: Pi2d_of_void; d2i: Pd2i_of_void; x: pointer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_dup';

function ASN1_item_dup(it: PASN1_ITEM; x: pointer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_item_dup';

function ASN1_d2i_fp(xnew: ASN1_d2i_fp_xnew; d2i: Pd2i_of_void; _in: PPointer; x: PPointer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_d2i_fp';

function ASN1_item_d2i_fp(it: PASN1_ITEM; _in: PPointer; x: pointer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_item_d2i_fp';

function ASN1_i2d_fp(i2d: Pi2d_of_void; _out: PPointer; x: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_i2d_fp';

function ASN1_item_i2d_fp(it: PASN1_ITEM; _out: PPointer; x: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_item_i2d_fp';

function ASN1_STRING_print_ex_fp(fp: PPointer; str: PASN1_STRING; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_STRING_print_ex_fp';

function ASN1_STRING_to_UTF8(_out: PPByte; _in: PASN1_STRING): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_STRING_to_UTF8';

function ASN1_d2i_bio(xnew: ASN1_d2i_bio_xnew; d2i: Pd2i_of_void; _in: PBIO; x: PPointer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_d2i_bio';

function ASN1_item_d2i_bio(it: PASN1_ITEM; _in: PBIO; x: pointer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_item_d2i_bio';

function ASN1_i2d_bio(i2d: Pi2d_of_void; _out: PBIO; x: PByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_i2d_bio';

function ASN1_item_i2d_bio(it: PASN1_ITEM; _out: PBIO; x: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_item_i2d_bio';

function ASN1_UTCTIME_print(fp: PBIO; a: PASN1_UTCTIME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_UTCTIME_print';

function ASN1_GENERALIZEDTIME_print(fp: PBIO; a: PASN1_GENERALIZEDTIME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_GENERALIZEDTIME_print';

function ASN1_TIME_print(fp: PBIO; a: PASN1_TIME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_TIME_print';

function ASN1_STRING_print(bp: PBIO; v: PASN1_STRING): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_STRING_print';

function ASN1_buf_print(bp: PBIO; buf: PByte; buflen: PtrUInt; off: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_buf_print';

function ASN1_parse(bp: PBIO; pp: PByte; len: integer; indent: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_parse';

function ASN1_parse_dump(bp: PBIO; pp: PByte; len: integer; indent: integer; dump: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_parse_dump';

function ASN1_tag2str(tag: integer): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_tag2str';

function ASN1_UNIVERSALSTRING_to_string(s: PASN1_UNIVERSALSTRING): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_UNIVERSALSTRING_to_string';

function ASN1_TYPE_set_octetstring(a: PASN1_TYPE; data: PByte; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_TYPE_set_octetstring';

function ASN1_TYPE_get_octetstring(a: PASN1_TYPE; data: PByte; max_len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_TYPE_get_octetstring';

function ASN1_TYPE_set_int_octetstring(a: PASN1_TYPE; num: integer; data: PByte; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_TYPE_set_int_octetstring';

function ASN1_TYPE_get_int_octetstring(a: PASN1_TYPE; num: PInteger; data: PByte; max_len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_TYPE_get_int_octetstring';

function ASN1_item_unpack(oct: PASN1_STRING; it: PASN1_ITEM): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_item_unpack';

function ASN1_item_pack(obj: pointer; it: PASN1_ITEM; oct: PPASN1_OCTET_STRING): PASN1_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_item_pack';

procedure ASN1_STRING_set_default_mask(mask: cardinal); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_STRING_set_default_mask';

function ASN1_STRING_set_default_mask_asc(p: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_STRING_set_default_mask_asc';

function ASN1_STRING_get_default_mask(): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_STRING_get_default_mask';

function ASN1_mbstring_copy(_out: PPASN1_STRING; _in: PByte; len: integer; inform: integer; mask: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_mbstring_copy';

function ASN1_mbstring_ncopy(_out: PPASN1_STRING; _in: PByte; len: integer; inform: integer; mask: cardinal; minsize: integer; maxsize: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_mbstring_ncopy';

function ASN1_STRING_set_by_NID(_out: PPASN1_STRING; _in: PByte; inlen: integer; inform: integer; nid: integer): PASN1_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_STRING_set_by_NID';

function ASN1_STRING_TABLE_get(nid: integer): PASN1_STRING_TABLE; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_STRING_TABLE_get';

function ASN1_STRING_TABLE_add(p1: integer; p2: integer; p3: integer; p4: cardinal; p5: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_STRING_TABLE_add';

procedure ASN1_STRING_TABLE_cleanup(); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_STRING_TABLE_cleanup';

function ASN1_item_new(it: PASN1_ITEM): PASN1_VALUE; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_item_new';

procedure ASN1_item_free(val: PASN1_VALUE; it: PASN1_ITEM); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_item_free';

function ASN1_item_d2i(val: PPASN1_VALUE; _in: PPByte; len: integer; it: PASN1_ITEM): PASN1_VALUE; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_item_d2i';

function ASN1_item_i2d(val: PASN1_VALUE; _out: PPByte; it: PASN1_ITEM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_item_i2d';

function ASN1_item_ndef_i2d(val: PASN1_VALUE; _out: PPByte; it: PASN1_ITEM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_item_ndef_i2d';

procedure ASN1_add_oid_module(); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_add_oid_module';

procedure ASN1_add_stable_module(); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_add_stable_module';

function ASN1_generate_nconf(str: PUtf8Char; nconf: PCONF): PASN1_TYPE; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_generate_nconf';

function ASN1_generate_v3(str: PUtf8Char; cnf: PX509V3_CTX): PASN1_TYPE; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_generate_v3';

function ASN1_str2mask(str: PUtf8Char; pmask: PCardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_str2mask';

function ASN1_item_print(_out: PBIO; ifld: PASN1_VALUE; indent: integer; it: PASN1_ITEM; pctx: PASN1_PCTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_item_print';

function ASN1_PCTX_new(): PASN1_PCTX; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_PCTX_new';

procedure ASN1_PCTX_free(p: PASN1_PCTX); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_PCTX_free';

function ASN1_PCTX_get_flags(p: PASN1_PCTX): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_PCTX_get_flags';

procedure ASN1_PCTX_set_flags(p: PASN1_PCTX; flags: cardinal); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_PCTX_set_flags';

function ASN1_PCTX_get_nm_flags(p: PASN1_PCTX): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_PCTX_get_nm_flags';

procedure ASN1_PCTX_set_nm_flags(p: PASN1_PCTX; flags: cardinal); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_PCTX_set_nm_flags';

function ASN1_PCTX_get_cert_flags(p: PASN1_PCTX): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_PCTX_get_cert_flags';

procedure ASN1_PCTX_set_cert_flags(p: PASN1_PCTX; flags: cardinal); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_PCTX_set_cert_flags';

function ASN1_PCTX_get_oid_flags(p: PASN1_PCTX): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_PCTX_get_oid_flags';

procedure ASN1_PCTX_set_oid_flags(p: PASN1_PCTX; flags: cardinal); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_PCTX_set_oid_flags';

function ASN1_PCTX_get_str_flags(p: PASN1_PCTX): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_PCTX_get_str_flags';

procedure ASN1_PCTX_set_str_flags(p: PASN1_PCTX; flags: cardinal); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_PCTX_set_str_flags';

function ASN1_SCTX_new(scan_cb: ASN1_SCTX_new_scan_cb): PASN1_SCTX; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_SCTX_new';

procedure ASN1_SCTX_free(p: PASN1_SCTX); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_SCTX_free';

function ASN1_SCTX_get_item(p: PASN1_SCTX): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_SCTX_get_item';

function ASN1_SCTX_get_template(p: PASN1_SCTX): PASN1_TEMPLATE; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_SCTX_get_template';

function ASN1_SCTX_get_flags(p: PASN1_SCTX): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_SCTX_get_flags';

procedure ASN1_SCTX_set_app_data(p: PASN1_SCTX; data: pointer); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_SCTX_set_app_data';

function ASN1_SCTX_get_app_data(p: PASN1_SCTX): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_SCTX_get_app_data';

function BIO_f_asn1(): PBIO_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_f_asn1';

function BIO_new_NDEF(_out: PBIO; val: PASN1_VALUE; it: PASN1_ITEM): PBIO; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_new_NDEF';

function i2d_ASN1_bio_stream(_out: PBIO; val: PASN1_VALUE; _in: PBIO; flags: integer; it: PASN1_ITEM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASN1_bio_stream';

function PEM_write_bio_ASN1_stream(_out: PBIO; val: PASN1_VALUE; _in: PBIO; flags: integer; hdr: PUtf8Char; it: PASN1_ITEM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_bio_ASN1_stream';

function SMIME_write_ASN1(bio: PBIO; val: PASN1_VALUE; data: PBIO; flags: integer; ctype_nid: integer; econt_nid: integer; mdalgs: Pstack_st_X509_ALGOR; it: PASN1_ITEM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SMIME_write_ASN1';

function SMIME_read_ASN1(bio: PBIO; bcont: PPBIO; it: PASN1_ITEM): PASN1_VALUE; cdecl;
  external LIB_CRYPTO name _PU + 'SMIME_read_ASN1';

function SMIME_crlf_copy(_in: PBIO; _out: PBIO; flags: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SMIME_crlf_copy';

function SMIME_text(_in: PBIO; _out: PBIO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SMIME_text';

function ASN1_ITEM_lookup(name: PUtf8Char): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_ITEM_lookup';

function ASN1_ITEM_get(i: PtrUInt): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_ITEM_get';

function ASN1_BOOLEAN_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_BOOLEAN_it';

function ASN1_TBOOLEAN_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_TBOOLEAN_it';

function ASN1_FBOOLEAN_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_FBOOLEAN_it';

function ASN1_SEQUENCE_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_SEQUENCE_it';

function CBIGNUM_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'CBIGNUM_it';

function BIGNUM_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'BIGNUM_it';

function INT32_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'INT32_it';

function ZINT32_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ZINT32_it';

function Cardinal_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'Cardinal_it';

function ZCardinal_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ZCardinal_it';

function INT64_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'INT64_it';

function ZINT64_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ZINT64_it';

function UINT64_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'UINT64_it';

function ZUINT64_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ZUINT64_it';

function LONG_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'LONG_it';

function ZLONG_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ZLONG_it';

function ASN1_item_ex_new(pval: PPASN1_VALUE; it: PASN1_ITEM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_item_ex_new';

procedure ASN1_item_ex_free(pval: PPASN1_VALUE; it: PASN1_ITEM); cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_item_ex_free';

function ASN1_item_ex_d2i(pval: PPASN1_VALUE; _in: PPByte; len: integer; it: PASN1_ITEM; tag: integer; aclass: integer; opt: AnsiChar; ctx: PASN1_TLC): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_item_ex_d2i';

function ASN1_item_ex_i2d(pval: PPASN1_VALUE; _out: PPByte; it: PASN1_ITEM; tag: integer; aclass: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_item_ex_i2d';

function ERR_load_ASYNC_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_ASYNC_strings';

function ASYNC_init_thread(max_size: PtrUInt; init_size: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASYNC_init_thread';

procedure ASYNC_cleanup_thread(); cdecl;
  external LIB_CRYPTO name _PU + 'ASYNC_cleanup_thread';

function ASYNC_is_capable(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASYNC_is_capable';

function ASYNC_start_job(job: PPASYNC_JOB; ctx: PASYNC_WAIT_CTX; ret: PInteger; func: ASYNC_start_job_func; args: pointer; size: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASYNC_start_job';

function ASYNC_pause_job(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASYNC_pause_job';

function ASYNC_get_current_job(): PASYNC_JOB; cdecl;
  external LIB_CRYPTO name _PU + 'ASYNC_get_current_job';

function ASYNC_get_wait_ctx(job: PASYNC_JOB): PASYNC_WAIT_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'ASYNC_get_wait_ctx';

procedure ASYNC_block_pause(); cdecl;
  external LIB_CRYPTO name _PU + 'ASYNC_block_pause';

procedure ASYNC_unblock_pause(); cdecl;
  external LIB_CRYPTO name _PU + 'ASYNC_unblock_pause';

procedure BF_set_key(key: PBF_KEY; len: integer; data: PByte); cdecl;
  external LIB_CRYPTO name _PU + 'BF_set_key';

procedure BF_encrypt(data: PCardinal; key: PBF_KEY); cdecl;
  external LIB_CRYPTO name _PU + 'BF_encrypt';

procedure BF_decrypt(data: PCardinal; key: PBF_KEY); cdecl;
  external LIB_CRYPTO name _PU + 'BF_decrypt';

procedure BF_ecb_encrypt(_in: PByte; _out: PByte; key: PBF_KEY; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'BF_ecb_encrypt';

procedure BF_cbc_encrypt(_in: PByte; _out: PByte; length: integer; schedule: PBF_KEY; ivec: PByte; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'BF_cbc_encrypt';

procedure BF_cfb64_encrypt(_in: PByte; _out: PByte; length: integer; schedule: PBF_KEY; ivec: PByte; num: PInteger; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'BF_cfb64_encrypt';

procedure BF_ofb64_encrypt(_in: PByte; _out: PByte; length: integer; schedule: PBF_KEY; ivec: PByte; num: PInteger); cdecl;
  external LIB_CRYPTO name _PU + 'BF_ofb64_encrypt';

function BF_options(): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'BF_options';

function ERR_load_BUF_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_BUF_strings';

function BUF_MEM_new(): PBUF_MEM; cdecl;
  external LIB_CRYPTO name _PU + 'BUF_MEM_new';

function BUF_MEM_new_ex(flags: cardinal): PBUF_MEM; cdecl;
  external LIB_CRYPTO name _PU + 'BUF_MEM_new_ex';

procedure BUF_MEM_free(a: PBUF_MEM); cdecl;
  external LIB_CRYPTO name _PU + 'BUF_MEM_free';

function BUF_MEM_grow(str: PBUF_MEM; len: PtrUInt): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'BUF_MEM_grow';

function BUF_MEM_grow_clean(str: PBUF_MEM; len: PtrUInt): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'BUF_MEM_grow_clean';

procedure BUF_reverse(_out: PByte; _in: PByte; siz: PtrUInt); cdecl;
  external LIB_CRYPTO name _PU + 'BUF_reverse';

function Camellia_set_key(userKey: PByte; bits: integer; key: PCAMELLIA_KEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'Camellia_set_key';

procedure Camellia_encrypt(_in: PByte; _out: PByte; key: PCAMELLIA_KEY); cdecl;
  external LIB_CRYPTO name _PU + 'Camellia_encrypt';

procedure Camellia_decrypt(_in: PByte; _out: PByte; key: PCAMELLIA_KEY); cdecl;
  external LIB_CRYPTO name _PU + 'Camellia_decrypt';

procedure Camellia_ecb_encrypt(_in: PByte; _out: PByte; key: PCAMELLIA_KEY; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'Camellia_ecb_encrypt';

procedure Camellia_cbc_encrypt(_in: PByte; _out: PByte; length: PtrUInt; key: PCAMELLIA_KEY; ivec: PByte; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'Camellia_cbc_encrypt';

procedure Camellia_cfb128_encrypt(_in: PByte; _out: PByte; length: PtrUInt; key: PCAMELLIA_KEY; ivec: PByte; num: PInteger; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'Camellia_cfb128_encrypt';

procedure Camellia_cfb1_encrypt(_in: PByte; _out: PByte; length: PtrUInt; key: PCAMELLIA_KEY; ivec: PByte; num: PInteger; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'Camellia_cfb1_encrypt';

procedure Camellia_cfb8_encrypt(_in: PByte; _out: PByte; length: PtrUInt; key: PCAMELLIA_KEY; ivec: PByte; num: PInteger; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'Camellia_cfb8_encrypt';

procedure Camellia_ofb128_encrypt(_in: PByte; _out: PByte; length: PtrUInt; key: PCAMELLIA_KEY; ivec: PByte; num: PInteger); cdecl;
  external LIB_CRYPTO name _PU + 'Camellia_ofb128_encrypt';

procedure Camellia_ctr128_encrypt(_in: PByte; _out: PByte; length: PtrUInt; key: PCAMELLIA_KEY; ivec: PByte; ecount_buf: PByte; num: PCardinal); cdecl;
  external LIB_CRYPTO name _PU + 'Camellia_ctr128_encrypt';

procedure CAST_set_key(key: PCAST_KEY; len: integer; data: PByte); cdecl;
  external LIB_CRYPTO name _PU + 'CAST_set_key';

procedure CAST_ecb_encrypt(_in: PByte; _out: PByte; key: PCAST_KEY; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'CAST_ecb_encrypt';

procedure CAST_encrypt(data: PCardinal; key: PCAST_KEY); cdecl;
  external LIB_CRYPTO name _PU + 'CAST_encrypt';

procedure CAST_decrypt(data: PCardinal; key: PCAST_KEY); cdecl;
  external LIB_CRYPTO name _PU + 'CAST_decrypt';

procedure CAST_cbc_encrypt(_in: PByte; _out: PByte; length: integer; ks: PCAST_KEY; iv: PByte; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'CAST_cbc_encrypt';

procedure CAST_cfb64_encrypt(_in: PByte; _out: PByte; length: integer; schedule: PCAST_KEY; ivec: PByte; num: PInteger; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'CAST_cfb64_encrypt';

procedure CAST_ofb64_encrypt(_in: PByte; _out: PByte; length: integer; schedule: PCAST_KEY; ivec: PByte; num: PInteger); cdecl;
  external LIB_CRYPTO name _PU + 'CAST_ofb64_encrypt';

function ERR_load_EVP_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_EVP_strings';

function ERR_load_OBJ_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_OBJ_strings';

function OBJ_NAME_init(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_NAME_init';

function OBJ_NAME_new_index(hash_func: OBJ_NAME_new_index_hash_func; cmp_func: OBJ_NAME_new_index_cmp_func; free_func: OBJ_NAME_new_index_free_func): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_NAME_new_index';

function OBJ_NAME_get(name: PUtf8Char; typ: integer): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_NAME_get';

function OBJ_NAME_add(name: PUtf8Char; typ: integer; data: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_NAME_add';

function OBJ_NAME_remove(name: PUtf8Char; typ: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_NAME_remove';

procedure OBJ_NAME_cleanup(typ: integer); cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_NAME_cleanup';

procedure OBJ_NAME_do_all(typ: integer; fn: OBJ_NAME_do_all_fn; arg: pointer); cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_NAME_do_all';

procedure OBJ_NAME_do_all_sorted(typ: integer; fn: OBJ_NAME_do_all_sorted_fn; arg: pointer); cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_NAME_do_all_sorted';

function OBJ_dup(o: PASN1_OBJECT): PASN1_OBJECT; cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_dup';

function OBJ_nid2obj(n: integer): PASN1_OBJECT; cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_nid2obj';

function OBJ_txt2obj(s: PUtf8Char; no_name: integer): PASN1_OBJECT; cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_txt2obj';

function OBJ_obj2txt(buf: PUtf8Char; buf_len: integer; a: PASN1_OBJECT; no_name: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_obj2txt';

function OBJ_ln2nid(s: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_ln2nid';

function OBJ_sn2nid(s: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_sn2nid';

function OBJ_cmp(a: PASN1_OBJECT; b: PASN1_OBJECT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_cmp';

function OBJ_bsearch_(key: pointer; base: pointer; num: integer; size: integer; cmp: OBJ_bsearch__cmp): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_bsearch_';

function OBJ_bsearch_ex_(key: pointer; base: pointer; num: integer; size: integer; cmp: OBJ_bsearch_ex__cmp; flags: integer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_bsearch_ex_';

function OBJ_new_nid(num: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_new_nid';

function OBJ_add_object(obj: PASN1_OBJECT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_add_object';

function OBJ_create(oid: PUtf8Char; sn: PUtf8Char; ln: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_create';

function OBJ_create_objects(_in: PBIO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_create_objects';

function OBJ_length(obj: PASN1_OBJECT): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_length';

function OBJ_get0_data(obj: PASN1_OBJECT): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_get0_data';

function OBJ_find_sigid_algs(signid: integer; pdig_nid: PInteger; ppkey_nid: PInteger): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_find_sigid_algs';

function OBJ_find_sigid_by_algs(psignid: PInteger; dig_nid: integer; pkey_nid: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_find_sigid_by_algs';

function OBJ_add_sigid(signid: integer; dig_id: integer; pkey_id: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_add_sigid';

procedure OBJ_sigid_free(); cdecl;
  external LIB_CRYPTO name _PU + 'OBJ_sigid_free';

function EVP_MD_meth_new(md_type: integer; pkey_type: integer): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_meth_new';

function EVP_MD_meth_dup(md: PEVP_MD): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_meth_dup';

procedure EVP_MD_meth_free(md: PEVP_MD); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_meth_free';

function EVP_MD_meth_set_input_blocksize(md: PEVP_MD; blocksize: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_meth_set_input_blocksize';

function EVP_MD_meth_set_result_size(md: PEVP_MD; resultsize: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_meth_set_result_size';

function EVP_MD_meth_set_app_datasize(md: PEVP_MD; datasize: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_meth_set_app_datasize';

function EVP_MD_meth_set_flags(md: PEVP_MD; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_meth_set_flags';

function EVP_MD_meth_set_init(md: PEVP_MD; init: EVP_MD_meth_set_init_init): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_meth_set_init';

function EVP_MD_meth_set_update(md: PEVP_MD; update: EVP_MD_meth_set_update_update): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_meth_set_update';

function EVP_MD_meth_set_final(md: PEVP_MD; _final: EVP_MD_meth_set_final_final): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_meth_set_final';

function EVP_MD_meth_set_copy(md: PEVP_MD; copy: EVP_MD_meth_set_copy_copy): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_meth_set_copy';

function EVP_MD_meth_set_cleanup(md: PEVP_MD; cleanup: EVP_MD_meth_set_cleanup_cleanup): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_meth_set_cleanup';

function EVP_MD_meth_set_ctrl(md: PEVP_MD; ctrl: EVP_MD_meth_set_ctrl_ctrl): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_meth_set_ctrl';

function EVP_MD_meth_get_input_blocksize(md: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_meth_get_input_blocksize';

function EVP_MD_meth_get_result_size(md: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_meth_get_result_size';

function EVP_MD_meth_get_app_datasize(md: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_meth_get_app_datasize';

function EVP_MD_meth_get_flags(md: PEVP_MD): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_meth_get_flags';

//function EVP_MD_meth_get_init(ctx: PEVP_MD_CTXmd: PEVP_MD): integer;
{ TODO : Cannot convert original type "int (*)(EVP_MD_CTX *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'EVP_MD_meth_get_init';

//function EVP_MD_meth_get_update(ctx: PEVP_MD_CTXdata: Pointercount: PtrUIntmd: PEVP_MD): integer;
{ TODO : Cannot convert original type "int (*)(EVP_MD_CTX *, const void *, size_t)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'EVP_MD_meth_get_update';

//function EVP_MD_meth_get_final(ctx: PEVP_MD_CTXmd: PBytemd: PEVP_MD): integer
{ TODO : Cannot convert original type "int (*)(EVP_MD_CTX *, unsigned char *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'EVP_MD_meth_get_final';

//function EVP_MD_meth_get_copy(_to: PEVP_MD_CTXfrom: PEVP_MD_CTXmd: PEVP_MD): integer
{ TODO : Cannot convert original type "int (*)(EVP_MD_CTX *, const EVP_MD_CTX *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'EVP_MD_meth_get_copy';

//function EVP_MD_meth_get_cleanup(ctx: PEVP_MD_CTXmd: PEVP_MD): integer
{ TODO : Cannot convert original type "int (*)(EVP_MD_CTX *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'EVP_MD_meth_get_cleanup';

//function EVP_MD_meth_get_ctrl(ctx: PEVP_MD_CTXcmd: Integerp1: Integerp2: Pointermd: PEVP_MD): integer
{ TODO : Cannot convert original type "int (*)(EVP_MD_CTX *, int, int, void *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'EVP_MD_meth_get_ctrl';

function EVP_CIPHER_meth_new(cipher_type: integer; block_size: integer; key_len: integer): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_meth_new';

function EVP_CIPHER_meth_dup(cipher: PEVP_CIPHER): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_meth_dup';

procedure EVP_CIPHER_meth_free(cipher: PEVP_CIPHER); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_meth_free';

function EVP_CIPHER_meth_set_iv_length(cipher: PEVP_CIPHER; iv_len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_meth_set_iv_length';

function EVP_CIPHER_meth_set_flags(cipher: PEVP_CIPHER; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_meth_set_flags';

function EVP_CIPHER_meth_set_impl_ctx_size(cipher: PEVP_CIPHER; ctx_size: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_meth_set_impl_ctx_size';

function EVP_CIPHER_meth_set_init(cipher: PEVP_CIPHER; init: EVP_CIPHER_meth_set_init_init): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_meth_set_init';

function EVP_CIPHER_meth_set_do_cipher(cipher: PEVP_CIPHER; do_cipher: EVP_CIPHER_meth_set_do_cipher_do_cipher): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_meth_set_do_cipher';

function EVP_CIPHER_meth_set_cleanup(cipher: PEVP_CIPHER; cleanup: EVP_CIPHER_meth_set_cleanup_cleanup): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_meth_set_cleanup';

function EVP_CIPHER_meth_set_set_asn1_params(cipher: PEVP_CIPHER; set_asn1_parameters: EVP_CIPHER_meth_set_set_asn1_params_set_asn1_parameters): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_meth_set_set_asn1_params';

function EVP_CIPHER_meth_set_get_asn1_params(cipher: PEVP_CIPHER; get_asn1_parameters: EVP_CIPHER_meth_set_get_asn1_params_get_asn1_parameters): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_meth_set_get_asn1_params';

function EVP_CIPHER_meth_set_ctrl(cipher: PEVP_CIPHER; ctrl: EVP_CIPHER_meth_set_ctrl_ctrl): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_meth_set_ctrl';

//function EVP_CIPHER_meth_get_init(ctx: PEVP_CIPHER_CTXkey: PByteiv: PByteenc: Integercipher: PEVP_CIPHER): integer
{ TODO : Cannot convert original type "int (*)(EVP_CIPHER_CTX *, const unsigned char *, const unsigned char *, int)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'EVP_CIPHER_meth_get_init';

//function EVP_CIPHER_meth_get_do_cipher(ctx: PEVP_CIPHER_CTX_out: PByte_in: PByteinl: PtrUIntcipher: PEVP_CIPHER): integer
{ TODO : Cannot convert original type "int (*)(EVP_CIPHER_CTX *, unsigned char *, const unsigned char *, size_t)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'EVP_CIPHER_meth_get_do_cipher';

//function EVP_CIPHER_meth_get_cleanup(p1: PEVP_CIPHER_CTXcipher: PEVP_CIPHER): integer
{ TODO : Cannot convert original type "int (*)(EVP_CIPHER_CTX *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'EVP_CIPHER_meth_get_cleanup';

//function EVP_CIPHER_meth_get_set_asn1_params(p1: PEVP_CIPHER_CTXp2: PASN1_TYPEcipher: PEVP_CIPHER): integer
{ TODO : Cannot convert original type "int (*)(EVP_CIPHER_CTX *, ASN1_TYPE *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'EVP_CIPHER_meth_get_set_asn1_params';

//function EVP_CIPHER_meth_get_get_asn1_params(p1: PEVP_CIPHER_CTXp2: PASN1_TYPEcipher: PEVP_CIPHER): integer
{ TODO : Cannot convert original type "int (*)(EVP_CIPHER_CTX *, ASN1_TYPE *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'EVP_CIPHER_meth_get_get_asn1_params';

//function EVP_CIPHER_meth_get_ctrl(p1: PEVP_CIPHER_CTX&type: Integerarg: Integerptr: Pointercipher: PEVP_CIPHER): integer
{ TODO : Cannot convert original type "int (*)(EVP_CIPHER_CTX *, int, int, void *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'EVP_CIPHER_meth_get_ctrl';

function EVP_MD_type(md: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_type';

function EVP_MD_pkey_type(md: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_pkey_type';

function EVP_MD_block_size(md: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_block_size';

//function EVP_MD_CTX_update_fn(ctx: PEVP_MD_CTXdata: Pointercount: PtrUIntctx: PEVP_MD_CTX): integer
{ TODO : Cannot convert original type "int (*)(EVP_MD_CTX *, const void *, size_t)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'EVP_MD_CTX_update_fn';

procedure EVP_MD_CTX_set_update_fn(ctx: PEVP_MD_CTX; update: EVP_MD_CTX_set_update_fn_update); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_CTX_set_update_fn';

function EVP_MD_CTX_pkey_ctx(ctx: PEVP_MD_CTX): PEVP_PKEY_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_CTX_pkey_ctx';

procedure EVP_MD_CTX_set_pkey_ctx(ctx: PEVP_MD_CTX; pctx: PEVP_PKEY_CTX); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_CTX_set_pkey_ctx';

function EVP_MD_CTX_md_data(ctx: PEVP_MD_CTX): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_CTX_md_data';

function EVP_CIPHER_nid(cipher: PEVP_CIPHER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_nid';

function EVP_CIPHER_block_size(cipher: PEVP_CIPHER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_block_size';

function EVP_CIPHER_impl_ctx_size(cipher: PEVP_CIPHER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_impl_ctx_size';

function EVP_CIPHER_key_length(cipher: PEVP_CIPHER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_key_length';

function EVP_CIPHER_iv_length(cipher: PEVP_CIPHER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_iv_length';

function EVP_CIPHER_flags(cipher: PEVP_CIPHER): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_flags';

function EVP_CIPHER_CTX_cipher(ctx: PEVP_CIPHER_CTX): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_CTX_cipher';

function EVP_CIPHER_CTX_encrypting(ctx: PEVP_CIPHER_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_CTX_encrypting';

function EVP_CIPHER_CTX_nid(ctx: PEVP_CIPHER_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_CTX_nid';

function EVP_CIPHER_CTX_block_size(ctx: PEVP_CIPHER_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_CTX_block_size';

function EVP_CIPHER_CTX_key_length(ctx: PEVP_CIPHER_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_CTX_key_length';

function EVP_CIPHER_CTX_iv_length(ctx: PEVP_CIPHER_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_CTX_iv_length';

function EVP_CIPHER_CTX_original_iv(ctx: PEVP_CIPHER_CTX): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_CTX_original_iv';

function EVP_CIPHER_CTX_iv_noconst(ctx: PEVP_CIPHER_CTX): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_CTX_iv_noconst';

function EVP_CIPHER_CTX_buf_noconst(ctx: PEVP_CIPHER_CTX): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_CTX_buf_noconst';

function EVP_CIPHER_CTX_num(ctx: PEVP_CIPHER_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_CTX_num';

procedure EVP_CIPHER_CTX_set_num(ctx: PEVP_CIPHER_CTX; num: integer); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_CTX_set_num';

function EVP_CIPHER_CTX_get_app_data(ctx: PEVP_CIPHER_CTX): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_CTX_get_app_data';

procedure EVP_CIPHER_CTX_set_app_data(ctx: PEVP_CIPHER_CTX; data: pointer); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_CTX_set_app_data';

function EVP_CIPHER_CTX_get_cipher_data(ctx: PEVP_CIPHER_CTX): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_CTX_get_cipher_data';

function EVP_CIPHER_CTX_set_cipher_data(ctx: PEVP_CIPHER_CTX; cipher_data: pointer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_CTX_set_cipher_data';

function EVP_Cipher(c: PEVP_CIPHER_CTX; _out: PByte; _in: PByte; inl: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_Cipher';

function EVP_MD_CTX_ctrl(ctx: PEVP_MD_CTX; cmd: integer; p1: integer; p2: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_CTX_ctrl';

function EVP_MD_CTX_reset(ctx: PEVP_MD_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_CTX_reset';

function EVP_MD_CTX_copy_ex(_out: PEVP_MD_CTX; _in: PEVP_MD_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_CTX_copy_ex';

procedure EVP_MD_CTX_set_flags(ctx: PEVP_MD_CTX; flags: integer); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_CTX_set_flags';

procedure EVP_MD_CTX_clear_flags(ctx: PEVP_MD_CTX; flags: integer); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_CTX_clear_flags';

function EVP_MD_CTX_test_flags(ctx: PEVP_MD_CTX; flags: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_CTX_test_flags';

function EVP_Digest(data: pointer; count: PtrUInt; md: PByte; size: PCardinal; typ: PEVP_MD; impl: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_Digest';

function EVP_MD_CTX_copy(_out: PEVP_MD_CTX; _in: PEVP_MD_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_CTX_copy';

function EVP_DigestInit(ctx: PEVP_MD_CTX; typ: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_DigestInit';

function EVP_DigestFinal(ctx: PEVP_MD_CTX; md: PByte; s: PCardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_DigestFinal';

function EVP_read_pw_string(buf: PUtf8Char; length: integer; prompt: PUtf8Char; verify: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_read_pw_string';

function EVP_read_pw_string_min(buf: PUtf8Char; minlen: integer; maxlen: integer; prompt: PUtf8Char; verify: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_read_pw_string_min';

procedure EVP_set_pw_prompt(prompt: PUtf8Char); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_set_pw_prompt';

function EVP_get_pw_prompt(): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_get_pw_prompt';

function EVP_BytesToKey(typ: PEVP_CIPHER; md: PEVP_MD; salt: PByte; data: PByte; datal: integer; count: integer; key: PByte; iv: PByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_BytesToKey';

procedure EVP_CIPHER_CTX_set_flags(ctx: PEVP_CIPHER_CTX; flags: integer); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_CTX_set_flags';

procedure EVP_CIPHER_CTX_clear_flags(ctx: PEVP_CIPHER_CTX; flags: integer); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_CTX_clear_flags';

function EVP_CIPHER_CTX_test_flags(ctx: PEVP_CIPHER_CTX; flags: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_CTX_test_flags';

function EVP_EncryptInit(ctx: PEVP_CIPHER_CTX; cipher: PEVP_CIPHER; key: PByte; iv: PByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_EncryptInit';

function EVP_EncryptInit_ex(ctx: PEVP_CIPHER_CTX; cipher: PEVP_CIPHER;
  impl: PENGINE; key: PByte; iv: PByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_EncryptInit_ex';

function EVP_EncryptFinal_ex(ctx: PEVP_CIPHER_CTX;
  _out: PByte; outl: PInteger): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_EncryptFinal_ex';

function EVP_EncryptFinal(ctx: PEVP_CIPHER_CTX; _out: PByte; outl: PInteger): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_EncryptFinal';

function EVP_DecryptInit(ctx: PEVP_CIPHER_CTX; cipher: PEVP_CIPHER; key: PByte; iv: PByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_DecryptInit';

function EVP_DecryptInit_ex(ctx: PEVP_CIPHER_CTX; cipher: PEVP_CIPHER; impl: PENGINE; key: PByte; iv: PByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_DecryptInit_ex';

function EVP_DecryptFinal(ctx: PEVP_CIPHER_CTX; outm: PByte; outl: PInteger): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_DecryptFinal';

function EVP_DecryptFinal_ex(ctx: PEVP_CIPHER_CTX; outm: PByte; outl: PInteger): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_DecryptFinal_ex';

function EVP_CipherInit(ctx: PEVP_CIPHER_CTX; cipher: PEVP_CIPHER; key: PByte; iv: PByte; enc: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CipherInit';

function EVP_CipherFinal(ctx: PEVP_CIPHER_CTX; outm: PByte; outl: PInteger): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CipherFinal';

function EVP_SignFinal(ctx: PEVP_MD_CTX; md: PByte; s: PCardinal; pkey: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_SignFinal';

function EVP_VerifyFinal(ctx: PEVP_MD_CTX; sigbuf: PByte; siglen: cardinal; pkey: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_VerifyFinal';

function EVP_sha224(): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_sha224';

function EVP_sha384(): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_sha384';

function EVP_sha512(): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_sha512';

function EVP_sha512_224(): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_sha512_224';

function EVP_sha512_256(): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_sha512_256';

function EVP_sha3_224(): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_sha3_224';

function EVP_sha3_256(): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_sha3_256';

function EVP_sha3_384(): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_sha3_384';

function EVP_sha3_512(): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_sha3_512';

function EVP_shake128(): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_shake128';

function EVP_shake256(): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_shake256';

function EVP_ENCODE_CTX_new(): PEVP_ENCODE_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_ENCODE_CTX_new';

procedure EVP_ENCODE_CTX_free(ctx: PEVP_ENCODE_CTX); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_ENCODE_CTX_free';

function EVP_ENCODE_CTX_copy(dctx: PEVP_ENCODE_CTX; sctx: PEVP_ENCODE_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_ENCODE_CTX_copy';

function EVP_ENCODE_CTX_num(ctx: PEVP_ENCODE_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_ENCODE_CTX_num';

procedure EVP_EncodeInit(ctx: PEVP_ENCODE_CTX); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_EncodeInit';

function EVP_EncodeUpdate(ctx: PEVP_ENCODE_CTX; _out: PByte; outl: PInteger; _in: PByte; inl: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_EncodeUpdate';

procedure EVP_EncodeFinal(ctx: PEVP_ENCODE_CTX; _out: PByte; outl: PInteger); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_EncodeFinal';

function EVP_EncodeBlock(t: PByte; f: PByte; n: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_EncodeBlock';

procedure EVP_DecodeInit(ctx: PEVP_ENCODE_CTX); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_DecodeInit';

function EVP_DecodeUpdate(ctx: PEVP_ENCODE_CTX; _out: PByte; outl: PInteger; _in: PByte; inl: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_DecodeUpdate';

function EVP_DecodeFinal(ctx: PEVP_ENCODE_CTX; _out: PByte; outl: PInteger): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_DecodeFinal';

function EVP_DecodeBlock(t: PByte; f: PByte; n: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_DecodeBlock';

function EVP_CIPHER_CTX_set_key_length(x: PEVP_CIPHER_CTX; keylen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_CTX_set_key_length';

function EVP_CIPHER_CTX_rand_key(ctx: PEVP_CIPHER_CTX; key: PByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_CTX_rand_key';

function BIO_f_md(): PBIO_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_f_md';

function BIO_f_base64(): PBIO_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_f_base64';

function BIO_f_cipher(): PBIO_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_f_cipher';

function BIO_f_reliable(): PBIO_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_f_reliable';

function BIO_set_cipher(b: PBIO; c: PEVP_CIPHER; k: PByte; i: PByte; enc: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_set_cipher';

function EVP_md_null(): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_md_null';

function EVP_md4(): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_md4';

function EVP_md5(): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_md5';

function EVP_md5_sha1(): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_md5_sha1';

function EVP_blake2b512(): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_blake2b512';

function EVP_blake2s256(): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_blake2s256';

function EVP_mdc2(): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_mdc2';

function EVP_ripemd160(): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_ripemd160';

function EVP_whirlpool(): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_whirlpool';

function EVP_sm3(): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_sm3';

function EVP_enc_null(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_enc_null';

function EVP_des_ecb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_des_ecb';

function EVP_des_ede(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_des_ede';

function EVP_des_ede3(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_des_ede3';

function EVP_des_ede_ecb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_des_ede_ecb';

function EVP_des_ede3_ecb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_des_ede3_ecb';

function EVP_des_cfb64(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_des_cfb64';

function EVP_des_cfb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_des_cfb64';

function EVP_des_cfb1(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_des_cfb1';

function EVP_des_cfb8(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_des_cfb8';

function EVP_des_ede_cfb64(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_des_ede_cfb64';

function EVP_des_ede_cfb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_des_ede_cfb64';

function EVP_des_ede3_cfb64(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_des_ede3_cfb64';

function EVP_des_ede3_cfb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_des_ede3_cfb64';

function EVP_des_ede3_cfb1(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_des_ede3_cfb1';

function EVP_des_ede3_cfb8(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_des_ede3_cfb8';

function EVP_des_ofb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_des_ofb';

function EVP_des_ede_ofb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_des_ede_ofb';

function EVP_des_ede3_ofb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_des_ede3_ofb';

function EVP_des_cbc(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_des_cbc';

function EVP_des_ede_cbc(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_des_ede_cbc';

function EVP_des_ede3_cbc(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_des_ede3_cbc';

function EVP_desx_cbc(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_desx_cbc';

function EVP_des_ede3_wrap(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_des_ede3_wrap';

function EVP_rc4(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_rc4';

function EVP_rc4_40(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_rc4_40';

function EVP_rc4_hmac_md5(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_rc4_hmac_md5';

function EVP_idea_ecb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_idea_ecb';

function EVP_idea_cfb64(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_idea_cfb64';

function EVP_idea_cfb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_idea_cfb64';

function EVP_idea_ofb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_idea_ofb';

function EVP_idea_cbc(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_idea_cbc';

function EVP_rc2_ecb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_rc2_ecb';

function EVP_rc2_cbc(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_rc2_cbc';

function EVP_rc2_40_cbc(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_rc2_40_cbc';

function EVP_rc2_64_cbc(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_rc2_64_cbc';

function EVP_rc2_cfb64(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_rc2_cfb64';

function EVP_rc2_cfb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_rc2_cfb64';

function EVP_rc2_ofb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_rc2_ofb';

function EVP_bf_ecb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_bf_ecb';

function EVP_bf_cbc(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_bf_cbc';

function EVP_bf_cfb64(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_bf_cfb64';
function EVP_bf_cfb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_bf_cfb64';

function EVP_bf_ofb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_bf_ofb';

function EVP_cast5_ecb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_cast5_ecb';

function EVP_cast5_cbc(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_cast5_cbc';

function EVP_cast5_cfb64(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_cast5_cfb64';

function EVP_cast5_cfb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_cast5_cfb64';

function EVP_cast5_ofb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_cast5_ofb';

function EVP_aes_128_ecb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_128_ecb';

function EVP_aes_128_cbc(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_128_cbc';

function EVP_aes_128_cfb1(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_128_cfb1';

function EVP_aes_128_cfb8(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_128_cfb8';

function EVP_aes_128_cfb128(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_128_cfb128';

function EVP_aes_128_cfb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_128_cfb128';

function EVP_aes_128_ofb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_128_ofb';

function EVP_aes_128_ctr(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_128_ctr';

function EVP_aes_128_ccm(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_128_ccm';

function EVP_aes_128_gcm(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_128_gcm';

function EVP_aes_128_xts(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_128_xts';

function EVP_aes_128_wrap(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_128_wrap';

function EVP_aes_128_wrap_pad(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_128_wrap_pad';

function EVP_aes_128_ocb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_128_ocb';

function EVP_aes_192_ecb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_192_ecb';

function EVP_aes_192_cbc(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_192_cbc';

function EVP_aes_192_cfb1(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_192_cfb1';

function EVP_aes_192_cfb8(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_192_cfb8';

function EVP_aes_192_cfb128(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_192_cfb128';

function EVP_aes_192_cfb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_192_cfb128';

function EVP_aes_192_ofb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_192_ofb';

function EVP_aes_192_ctr(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_192_ctr';

function EVP_aes_192_ccm(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_192_ccm';

function EVP_aes_192_gcm(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_192_gcm';

function EVP_aes_192_wrap(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_192_wrap';

function EVP_aes_192_wrap_pad(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_192_wrap_pad';

function EVP_aes_192_ocb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_192_ocb';

function EVP_aes_256_ecb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_256_ecb';

function EVP_aes_256_cfb1(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_256_cfb1';

function EVP_aes_256_cfb8(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_256_cfb8';

function EVP_aes_256_cfb128(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_256_cfb128';

function EVP_aes_256_cfb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_256_cfb128';

function EVP_aes_256_ofb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_256_ofb';

function EVP_aes_256_ctr(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_256_ctr';

function EVP_aes_256_ccm(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_256_ccm';

function EVP_aes_256_gcm(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_256_gcm';

function EVP_aes_256_xts(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_256_xts';

function EVP_aes_256_wrap(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_256_wrap';

function EVP_aes_256_wrap_pad(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_256_wrap_pad';

function EVP_aes_256_ocb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_256_ocb';

function EVP_aes_128_cbc_hmac_sha1(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_128_cbc_hmac_sha1';

function EVP_aes_256_cbc_hmac_sha1(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_256_cbc_hmac_sha1';

function EVP_aes_128_cbc_hmac_sha256(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_128_cbc_hmac_sha256';

function EVP_aes_256_cbc_hmac_sha256(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aes_256_cbc_hmac_sha256';

function EVP_aria_128_ecb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_128_ecb';

function EVP_aria_128_cbc(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_128_cbc';

function EVP_aria_128_cfb1(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_128_cfb1';

function EVP_aria_128_cfb8(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_128_cfb8';

function EVP_aria_128_cfb128(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_128_cfb128';

function EVP_aria_128_cfb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_128_cfb128';

function EVP_aria_128_ctr(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_128_ctr';

function EVP_aria_128_ofb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_128_ofb';

function EVP_aria_128_gcm(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_128_gcm';

function EVP_aria_128_ccm(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_128_ccm';

function EVP_aria_192_ecb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_192_ecb';

function EVP_aria_192_cbc(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_192_cbc';

function EVP_aria_192_cfb1(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_192_cfb1';

function EVP_aria_192_cfb8(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_192_cfb8';

function EVP_aria_192_cfb128(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_192_cfb128';

function EVP_aria_192_cfb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_192_cfb128';

function EVP_aria_192_ctr(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_192_ctr';

function EVP_aria_192_ofb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_192_ofb';

function EVP_aria_192_gcm(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_192_gcm';

function EVP_aria_192_ccm(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_192_ccm';

function EVP_aria_256_ecb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_256_ecb';

function EVP_aria_256_cbc(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_256_cbc';

function EVP_aria_256_cfb1(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_256_cfb1';

function EVP_aria_256_cfb8(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_256_cfb8';

function EVP_aria_256_cfb128(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_256_cfb128';

function EVP_aria_256_cfb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_256_cfb128';

function EVP_aria_256_ctr(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_256_ctr';

function EVP_aria_256_ofb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_256_ofb';

function EVP_aria_256_gcm(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_256_gcm';

function EVP_aria_256_ccm(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_aria_256_ccm';

function EVP_camellia_128_ecb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_camellia_128_ecb';

function EVP_camellia_128_cbc(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_camellia_128_cbc';

function EVP_camellia_128_cfb1(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_camellia_128_cfb1';

function EVP_camellia_128_cfb8(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_camellia_128_cfb8';

function EVP_camellia_128_cfb128(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_camellia_128_cfb128';

function EVP_camellia_128_cfb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_camellia_128_cfb128';

function EVP_camellia_128_ofb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_camellia_128_ofb';

function EVP_camellia_128_ctr(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_camellia_128_ctr';

function EVP_camellia_192_ecb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_camellia_192_ecb';

function EVP_camellia_192_cbc(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_camellia_192_cbc';

function EVP_camellia_192_cfb1(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_camellia_192_cfb1';

function EVP_camellia_192_cfb8(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_camellia_192_cfb8';

function EVP_camellia_192_cfb128(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_camellia_192_cfb128';

function EVP_camellia_192_cfb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_camellia_192_cfb128';

function EVP_camellia_192_ofb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_camellia_192_ofb';

function EVP_camellia_192_ctr(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_camellia_192_ctr';

function EVP_camellia_256_ecb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_camellia_256_ecb';

function EVP_camellia_256_cbc(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_camellia_256_cbc';

function EVP_camellia_256_cfb1(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_camellia_256_cfb1';

function EVP_camellia_256_cfb8(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_camellia_256_cfb8';

function EVP_camellia_256_cfb128(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_camellia_256_cfb128';

function EVP_camellia_256_cfb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_camellia_256_cfb128';

function EVP_camellia_256_ofb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_camellia_256_ofb';

function EVP_camellia_256_ctr(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_camellia_256_ctr';

function EVP_chacha20(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_chacha20';

function EVP_chacha20_poly1305(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_chacha20_poly1305';

function EVP_seed_ecb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_seed_ecb';

function EVP_seed_cbc(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_seed_cbc';

function EVP_seed_cfb128(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_seed_cfb128';

function EVP_seed_cfb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_seed_cfb128';

function EVP_seed_ofb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_seed_ofb';

function EVP_sm4_ecb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_sm4_ecb';

function EVP_sm4_cbc(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_sm4_cbc';

function EVP_sm4_cfb128(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_sm4_cfb128';

function EVP_sm4_cfb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_sm4_cfb128';

function EVP_sm4_ofb(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_sm4_ofb';

function EVP_sm4_ctr(): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_sm4_ctr';

function EVP_add_cipher(cipher: PEVP_CIPHER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_add_cipher';

function EVP_add_digest(digest: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_add_digest';

procedure EVP_CIPHER_do_all(fn: EVP_CIPHER_do_all_fn; arg: pointer); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_do_all';

procedure EVP_CIPHER_do_all_sorted(fn: EVP_CIPHER_do_all_sorted_fn; arg: pointer); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_do_all_sorted';

procedure EVP_MD_do_all(fn: EVP_MD_do_all_fn; arg: pointer); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_do_all';

procedure EVP_MD_do_all_sorted(fn: EVP_MD_do_all_sorted_fn; arg: pointer); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_MD_do_all_sorted';

function EVP_PKEY_decrypt_old(dec_key: PByte; enc_key: PByte; enc_key_len: integer; private_key: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_decrypt_old';

function EVP_PKEY_encrypt_old(enc_key: PByte; key: PByte; key_len: integer; pub_key: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_encrypt_old';

function EVP_PKEY_security_bits(pkey: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_security_bits';

function EVP_PKEY_set_type(pkey: PEVP_PKEY; typ: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_set_type';

function EVP_PKEY_set_type_str(pkey: PEVP_PKEY; str: PUtf8Char; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_set_type_str';

function EVP_PKEY_set_alias_type(pkey: PEVP_PKEY; typ: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_set_alias_type';

function EVP_PKEY_set1_engine(pkey: PEVP_PKEY; e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_set1_engine';

function EVP_PKEY_get0_engine(pkey: PEVP_PKEY): PENGINE; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_get0_engine';

function EVP_PKEY_assign(pkey: PEVP_PKEY; typ: integer; key: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_assign';

function EVP_PKEY_get0(pkey: PEVP_PKEY): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_get0';

function EVP_PKEY_get0_hmac(pkey: PEVP_PKEY; len: PPtrUInt): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_get0_hmac';

function EVP_PKEY_get0_poly1305(pkey: PEVP_PKEY; len: PPtrUInt): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_get0_poly1305';

function EVP_PKEY_get0_siphash(pkey: PEVP_PKEY; len: PPtrUInt): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_get0_siphash';

function EVP_PKEY_set1_RSA(pkey: PEVP_PKEY; key: Prsa_st): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_set1_RSA';

function EVP_PKEY_get1_RSA(pkey: PEVP_PKEY): Prsa_st; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_get1_RSA';

function EVP_PKEY_set1_DSA(pkey: PEVP_PKEY; key: Pdsa_st): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_set1_DSA';

function EVP_PKEY_get0_DSA(pkey: PEVP_PKEY): Pdsa_st; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_get0_DSA';

function EVP_PKEY_get1_DSA(pkey: PEVP_PKEY): Pdsa_st; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_get1_DSA';

function EVP_PKEY_set1_DH(pkey: PEVP_PKEY; key: Pdh_st): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_set1_DH';

function EVP_PKEY_get0_DH(pkey: PEVP_PKEY): Pdh_st; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_get0_DH';

function EVP_PKEY_get1_DH(pkey: PEVP_PKEY): Pdh_st; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_get1_DH';

function EVP_PKEY_set1_EC_KEY(pkey: PEVP_PKEY; key: Pec_key_st): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_set1_EC_KEY';

function EVP_PKEY_get1_EC_KEY(pkey: PEVP_PKEY): Pec_key_st; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_get1_EC_KEY';

function EVP_PKEY_new(): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_new';

function EVP_PKEY_up_ref(pkey: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_up_ref';

function d2i_PublicKey(typ: integer; a: PPEVP_PKEY; pp: PPByte; length: integer): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PublicKey';

function i2d_PublicKey(a: PEVP_PKEY; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PublicKey';

function d2i_PrivateKey(typ: integer; a: PPEVP_PKEY; pp: PPByte; length: integer): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PrivateKey';

function d2i_AutoPrivateKey(a: PPEVP_PKEY; pp: PPByte; length: integer): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_AutoPrivateKey';

function i2d_PrivateKey(a: PEVP_PKEY; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PrivateKey';

function EVP_PKEY_copy_parameters(_to: PEVP_PKEY; from: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_copy_parameters';

function EVP_PKEY_missing_parameters(pkey: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_missing_parameters';

function EVP_PKEY_save_parameters(pkey: PEVP_PKEY; mode: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_save_parameters';

function EVP_PKEY_cmp_parameters(a: PEVP_PKEY; b: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_cmp_parameters';

function EVP_PKEY_cmp(a: PEVP_PKEY; b: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_cmp';

function EVP_PKEY_print_public(_out: PBIO; pkey: PEVP_PKEY; indent: integer; pctx: PASN1_PCTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_print_public';

function EVP_PKEY_print_private(_out: PBIO; pkey: PEVP_PKEY; indent: integer; pctx: PASN1_PCTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_print_private';

function EVP_PKEY_print_params(_out: PBIO; pkey: PEVP_PKEY; indent: integer; pctx: PASN1_PCTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_print_params';

function EVP_PKEY_get_default_digest_nid(pkey: PEVP_PKEY; pnid: PInteger): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_get_default_digest_nid';

function EVP_PKEY_set1_tls_encodedpoint(pkey: PEVP_PKEY; pt: PByte; ptlen: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_set1_tls_encodedpoint';

function EVP_PKEY_get1_tls_encodedpoint(pkey: PEVP_PKEY; ppt: PPByte): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_get1_tls_encodedpoint';

function EVP_CIPHER_type(ctx: PEVP_CIPHER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_type';

function EVP_CIPHER_param_to_asn1(c: PEVP_CIPHER_CTX; typ: PASN1_TYPE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_param_to_asn1';

function EVP_CIPHER_asn1_to_param(c: PEVP_CIPHER_CTX; typ: PASN1_TYPE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_asn1_to_param';

function EVP_CIPHER_set_asn1_iv(c: PEVP_CIPHER_CTX; typ: PASN1_TYPE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_set_asn1_iv';

function EVP_CIPHER_get_asn1_iv(c: PEVP_CIPHER_CTX; typ: PASN1_TYPE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_CIPHER_get_asn1_iv';

function PKCS5_PBE_keyivgen(ctx: PEVP_CIPHER_CTX; pass: PUtf8Char; passlen: integer; param: PASN1_TYPE; cipher: PEVP_CIPHER; md: PEVP_MD; en_de: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS5_PBE_keyivgen';

function PKCS5_PBKDF2_HMAC_SHA1(pass: PUtf8Char; passlen: integer; salt: PByte; saltlen: integer; iter: integer; keylen: integer; _out: PByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS5_PBKDF2_HMAC_SHA1';

function PKCS5_PBKDF2_HMAC(pass: PUtf8Char; passlen: integer; salt: PByte; saltlen: integer; iter: integer; digest: PEVP_MD; keylen: integer; _out: PByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS5_PBKDF2_HMAC';

function PKCS5_v2_PBE_keyivgen(ctx: PEVP_CIPHER_CTX; pass: PUtf8Char; passlen: integer; param: PASN1_TYPE; cipher: PEVP_CIPHER; md: PEVP_MD; en_de: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS5_v2_PBE_keyivgen';

function EVP_PBE_scrypt(pass: PUtf8Char; passlen: PtrUInt; salt: PByte; saltlen: PtrUInt; N: Qword; r: Qword; p: Qword; maxmem: Qword; key: PByte; keylen: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PBE_scrypt';

function PKCS5_v2_scrypt_keyivgen(ctx: PEVP_CIPHER_CTX; pass: PUtf8Char; passlen: integer; param: PASN1_TYPE; c: PEVP_CIPHER; md: PEVP_MD; en_de: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS5_v2_scrypt_keyivgen';

procedure PKCS5_PBE_add(); cdecl;
  external LIB_CRYPTO name _PU + 'PKCS5_PBE_add';

function EVP_PBE_CipherInit(pbe_obj: PASN1_OBJECT; pass: PUtf8Char; passlen: integer; param: PASN1_TYPE; ctx: PEVP_CIPHER_CTX; en_de: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PBE_CipherInit';

function EVP_PBE_alg_add_type(pbe_type: integer; pbe_nid: integer; cipher_nid: integer; md_nid: integer; keygen: PEVP_PBE_KEYGEN): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PBE_alg_add_type';

function EVP_PBE_alg_add(nid: integer; cipher: PEVP_CIPHER; md: PEVP_MD; keygen: PEVP_PBE_KEYGEN): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PBE_alg_add';

function EVP_PBE_find(typ: integer; pbe_nid: integer; pcnid: PInteger; pmnid: PInteger; pkeygen: PPEVP_PBE_KEYGEN): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PBE_find';

procedure EVP_PBE_cleanup(); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PBE_cleanup';

function EVP_PBE_get(ptype: PInteger; ppbe_nid: PInteger; num: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PBE_get';

function EVP_PKEY_asn1_get_count(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_asn1_get_count';

function EVP_PKEY_asn1_get0(idx: integer): PEVP_PKEY_ASN1_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_asn1_get0';

function EVP_PKEY_asn1_find(pe: PPENGINE; typ: integer): PEVP_PKEY_ASN1_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_asn1_find';

function EVP_PKEY_asn1_find_str(pe: PPENGINE; str: PUtf8Char; len: integer): PEVP_PKEY_ASN1_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_asn1_find_str';

function EVP_PKEY_asn1_add0(ameth: PEVP_PKEY_ASN1_METHOD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_asn1_add0';

function EVP_PKEY_asn1_add_alias(_to: integer; from: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_asn1_add_alias';

function EVP_PKEY_asn1_get0_info(ppkey_id: PInteger; pkey_base_id: PInteger; ppkey_flags: PInteger; pinfo: PPUtf8Char; ppem_str: PPUtf8Char; ameth: PEVP_PKEY_ASN1_METHOD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_asn1_get0_info';

function EVP_PKEY_get0_asn1(pkey: PEVP_PKEY): PEVP_PKEY_ASN1_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_get0_asn1';

function EVP_PKEY_asn1_new(id: integer; flags: integer; pem_str: PUtf8Char; info: PUtf8Char): PEVP_PKEY_ASN1_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_asn1_new';

procedure EVP_PKEY_asn1_copy(dst: PEVP_PKEY_ASN1_METHOD; src: PEVP_PKEY_ASN1_METHOD); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_asn1_copy';

procedure EVP_PKEY_asn1_free(ameth: PEVP_PKEY_ASN1_METHOD); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_asn1_free';

procedure EVP_PKEY_asn1_set_public(ameth: PEVP_PKEY_ASN1_METHOD; pub_decode: EVP_PKEY_asn1_set_public_pub_decode; pub_encode: EVP_PKEY_asn1_set_public_pub_encode; pub_cmp: EVP_PKEY_asn1_set_public_pub_cmp; pub_print: EVP_PKEY_asn1_set_public_pub_print; pkey_size: EVP_PKEY_asn1_set_public_pkey_size; pkey_bits: EVP_PKEY_asn1_set_public_pkey_bits); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_asn1_set_public';

procedure EVP_PKEY_asn1_set_private(ameth: PEVP_PKEY_ASN1_METHOD; priv_decode: EVP_PKEY_asn1_set_private_priv_decode; priv_encode: EVP_PKEY_asn1_set_private_priv_encode; priv_print: EVP_PKEY_asn1_set_private_priv_print); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_asn1_set_private';

procedure EVP_PKEY_asn1_set_param(ameth: PEVP_PKEY_ASN1_METHOD; param_decode: EVP_PKEY_asn1_set_param_param_decode; param_encode: EVP_PKEY_asn1_set_param_param_encode; param_missing: EVP_PKEY_asn1_set_param_param_missing; param_copy: EVP_PKEY_asn1_set_param_param_copy; param_cmp: EVP_PKEY_asn1_set_param_param_cmp; param_print: EVP_PKEY_asn1_set_param_param_print); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_asn1_set_param';

procedure EVP_PKEY_asn1_set_free(ameth: PEVP_PKEY_ASN1_METHOD; pkey_free: EVP_PKEY_asn1_set_free_pkey_free); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_asn1_set_free';

procedure EVP_PKEY_asn1_set_ctrl(ameth: PEVP_PKEY_ASN1_METHOD; pkey_ctrl: EVP_PKEY_asn1_set_ctrl_pkey_ctrl); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_asn1_set_ctrl';

procedure EVP_PKEY_asn1_set_item(ameth: PEVP_PKEY_ASN1_METHOD; item_verify: EVP_PKEY_asn1_set_item_item_verify; item_sign: EVP_PKEY_asn1_set_item_item_sign); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_asn1_set_item';

procedure EVP_PKEY_asn1_set_siginf(ameth: PEVP_PKEY_ASN1_METHOD; siginf_set: EVP_PKEY_asn1_set_siginf_siginf_set); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_asn1_set_siginf';

procedure EVP_PKEY_asn1_set_check(ameth: PEVP_PKEY_ASN1_METHOD; pkey_check: EVP_PKEY_asn1_set_check_pkey_check); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_asn1_set_check';

procedure EVP_PKEY_asn1_set_public_check(ameth: PEVP_PKEY_ASN1_METHOD; pkey_pub_check: EVP_PKEY_asn1_set_public_check_pkey_pub_check); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_asn1_set_public_check';

procedure EVP_PKEY_asn1_set_param_check(ameth: PEVP_PKEY_ASN1_METHOD; pkey_param_check: EVP_PKEY_asn1_set_param_check_pkey_param_check); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_asn1_set_param_check';

procedure EVP_PKEY_asn1_set_set_priv_key(ameth: PEVP_PKEY_ASN1_METHOD; set_priv_key: EVP_PKEY_asn1_set_set_priv_key_set_priv_key); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_asn1_set_set_priv_key';

procedure EVP_PKEY_asn1_set_set_pub_key(ameth: PEVP_PKEY_ASN1_METHOD; set_pub_key: EVP_PKEY_asn1_set_set_pub_key_set_pub_key); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_asn1_set_set_pub_key';

procedure EVP_PKEY_asn1_set_get_priv_key(ameth: PEVP_PKEY_ASN1_METHOD; get_priv_key: EVP_PKEY_asn1_set_get_priv_key_get_priv_key); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_asn1_set_get_priv_key';

procedure EVP_PKEY_asn1_set_get_pub_key(ameth: PEVP_PKEY_ASN1_METHOD; get_pub_key: EVP_PKEY_asn1_set_get_pub_key_get_pub_key); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_asn1_set_get_pub_key';

procedure EVP_PKEY_asn1_set_security_bits(ameth: PEVP_PKEY_ASN1_METHOD; pkey_security_bits: EVP_PKEY_asn1_set_security_bits_pkey_security_bits); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_asn1_set_security_bits';

function EVP_PKEY_meth_find(typ: integer): PEVP_PKEY_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_find';

function EVP_PKEY_meth_new(id: integer; flags: integer): PEVP_PKEY_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_new';

procedure EVP_PKEY_meth_get0_info(ppkey_id: PInteger; pflags: PInteger; meth: PEVP_PKEY_METHOD); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_get0_info';

procedure EVP_PKEY_meth_copy(dst: PEVP_PKEY_METHOD; src: PEVP_PKEY_METHOD); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_copy';

procedure EVP_PKEY_meth_free(pmeth: PEVP_PKEY_METHOD); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_free';

function EVP_PKEY_meth_add0(pmeth: PEVP_PKEY_METHOD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_add0';

function EVP_PKEY_meth_remove(pmeth: PEVP_PKEY_METHOD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_remove';

function EVP_PKEY_meth_get_count(): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_get_count';

function EVP_PKEY_meth_get0(idx: PtrUInt): PEVP_PKEY_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_get0';

function EVP_PKEY_CTX_dup(ctx: PEVP_PKEY_CTX): PEVP_PKEY_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_CTX_dup';

function EVP_PKEY_CTX_ctrl_str(ctx: PEVP_PKEY_CTX; typ: PUtf8Char; value: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_CTX_ctrl_str';

function EVP_PKEY_CTX_ctrl_uint64(ctx: PEVP_PKEY_CTX; keytype: integer; optype: integer; cmd: integer; value: Qword): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_CTX_ctrl_uint64';

function EVP_PKEY_CTX_str2ctrl(ctx: PEVP_PKEY_CTX; cmd: integer; str: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_CTX_str2ctrl';

function EVP_PKEY_CTX_hex2ctrl(ctx: PEVP_PKEY_CTX; cmd: integer; hex: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_CTX_hex2ctrl';

function EVP_PKEY_CTX_md(ctx: PEVP_PKEY_CTX; optype: integer; cmd: integer; md: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_CTX_md';

function EVP_PKEY_CTX_get_operation(ctx: PEVP_PKEY_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_CTX_get_operation';

procedure EVP_PKEY_CTX_set0_keygen_info(ctx: PEVP_PKEY_CTX; dat: PInteger; datlen: integer); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_CTX_set0_keygen_info';

function EVP_PKEY_new_mac_key(typ: integer; e: PENGINE; key: PByte; keylen: integer): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_new_mac_key';

function EVP_PKEY_new_raw_private_key(typ: integer; e: PENGINE; priv: PByte; len: PtrUInt): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_new_raw_private_key';

function EVP_PKEY_new_raw_public_key(typ: integer; e: PENGINE; pub: PByte; len: PtrUInt): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_new_raw_public_key';

function EVP_PKEY_get_raw_private_key(pkey: PEVP_PKEY; priv: PByte; len: PPtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_get_raw_private_key';

function EVP_PKEY_get_raw_public_key(pkey: PEVP_PKEY; pub: PByte; len: PPtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_get_raw_public_key';

function EVP_PKEY_new_CMAC_key(e: PENGINE; priv: PByte; len: PtrUInt; cipher: PEVP_CIPHER): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_new_CMAC_key';

procedure EVP_PKEY_CTX_set_data(ctx: PEVP_PKEY_CTX; data: pointer); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_CTX_set_data';

function EVP_PKEY_CTX_get_data(ctx: PEVP_PKEY_CTX): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_CTX_get_data';

function EVP_PKEY_CTX_get0_pkey(ctx: PEVP_PKEY_CTX): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_CTX_get0_pkey';

function EVP_PKEY_CTX_get0_peerkey(ctx: PEVP_PKEY_CTX): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_CTX_get0_peerkey';

procedure EVP_PKEY_CTX_set_app_data(ctx: PEVP_PKEY_CTX; data: pointer); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_CTX_set_app_data';

function EVP_PKEY_CTX_get_app_data(ctx: PEVP_PKEY_CTX): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_CTX_get_app_data';

function EVP_PKEY_sign_init(ctx: PEVP_PKEY_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_sign_init';

function EVP_PKEY_sign(ctx: PEVP_PKEY_CTX; sig: PByte; var siglen: PtrUInt; tbs: PByte; tbslen: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_sign';

function EVP_PKEY_verify_init(ctx: PEVP_PKEY_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_verify_init';

function EVP_PKEY_verify(ctx: PEVP_PKEY_CTX; sig: PByte; siglen: PtrUInt; tbs: PByte; tbslen: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_verify';

function EVP_PKEY_verify_recover_init(ctx: PEVP_PKEY_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_verify_recover_init';

function EVP_PKEY_verify_recover(ctx: PEVP_PKEY_CTX; rout: PByte; routlen: PPtrUInt; sig: PByte; siglen: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_verify_recover';

function EVP_PKEY_check(ctx: PEVP_PKEY_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_check';

function EVP_PKEY_public_check(ctx: PEVP_PKEY_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_public_check';

function EVP_PKEY_param_check(ctx: PEVP_PKEY_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_param_check';

procedure EVP_PKEY_CTX_set_cb(ctx: PEVP_PKEY_CTX; cb: PEVP_PKEY_gen_cb); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_CTX_set_cb';

function EVP_PKEY_CTX_get_cb(ctx: PEVP_PKEY_CTX): PEVP_PKEY_gen_cb; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_CTX_get_cb';

function EVP_PKEY_CTX_get_keygen_info(ctx: PEVP_PKEY_CTX; idx: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_CTX_get_keygen_info';

procedure EVP_PKEY_meth_set_init(pmeth: PEVP_PKEY_METHOD; init: EVP_PKEY_meth_set_init_init); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_set_init';

procedure EVP_PKEY_meth_set_copy(pmeth: PEVP_PKEY_METHOD; copy: EVP_PKEY_meth_set_copy_copy); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_set_copy';

procedure EVP_PKEY_meth_set_cleanup(pmeth: PEVP_PKEY_METHOD; cleanup: EVP_PKEY_meth_set_cleanup_cleanup); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_set_cleanup';

procedure EVP_PKEY_meth_set_paramgen(pmeth: PEVP_PKEY_METHOD; paramgen_init: EVP_PKEY_meth_set_paramgen_paramgen_init; paramgen: EVP_PKEY_meth_set_paramgen_paramgen); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_set_paramgen';

procedure EVP_PKEY_meth_set_keygen(pmeth: PEVP_PKEY_METHOD; keygen_init: EVP_PKEY_meth_set_keygen_keygen_init; keygen: EVP_PKEY_meth_set_keygen_keygen); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_set_keygen';

procedure EVP_PKEY_meth_set_sign(pmeth: PEVP_PKEY_METHOD; sign_init: EVP_PKEY_meth_set_sign_sign_init; sign: EVP_PKEY_meth_set_sign_sign); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_set_sign';

procedure EVP_PKEY_meth_set_verify(pmeth: PEVP_PKEY_METHOD; verify_init: EVP_PKEY_meth_set_verify_verify_init; verify: EVP_PKEY_meth_set_verify_verify); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_set_verify';

procedure EVP_PKEY_meth_set_verify_recover(pmeth: PEVP_PKEY_METHOD; verify_recover_init: EVP_PKEY_meth_set_verify_recover_verify_recover_init; verify_recover: EVP_PKEY_meth_set_verify_recover_verify_recover); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_set_verify_recover';

procedure EVP_PKEY_meth_set_signctx(pmeth: PEVP_PKEY_METHOD; signctx_init: EVP_PKEY_meth_set_signctx_signctx_init; signctx: EVP_PKEY_meth_set_signctx_signctx); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_set_signctx';

procedure EVP_PKEY_meth_set_verifyctx(pmeth: PEVP_PKEY_METHOD; verifyctx_init: EVP_PKEY_meth_set_verifyctx_verifyctx_init; verifyctx: EVP_PKEY_meth_set_verifyctx_verifyctx); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_set_verifyctx';

procedure EVP_PKEY_meth_set_encrypt(pmeth: PEVP_PKEY_METHOD; encrypt_init: EVP_PKEY_meth_set_encrypt_encrypt_init; encryptfn: EVP_PKEY_meth_set_encrypt_encryptfn); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_set_encrypt';

procedure EVP_PKEY_meth_set_decrypt(pmeth: PEVP_PKEY_METHOD; decrypt_init: EVP_PKEY_meth_set_decrypt_decrypt_init; decrypt: EVP_PKEY_meth_set_decrypt_decrypt); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_set_decrypt';

procedure EVP_PKEY_meth_set_derive(pmeth: PEVP_PKEY_METHOD; derive_init: EVP_PKEY_meth_set_derive_derive_init; derive: EVP_PKEY_meth_set_derive_derive); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_set_derive';

procedure EVP_PKEY_meth_set_ctrl(pmeth: PEVP_PKEY_METHOD; ctrl: EVP_PKEY_meth_set_ctrl_ctrl; ctrl_str: EVP_PKEY_meth_set_ctrl_ctrl_str); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_set_ctrl';

procedure EVP_PKEY_meth_set_digestsign(pmeth: PEVP_PKEY_METHOD; digestsign: EVP_PKEY_meth_set_digestsign_digestsign); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_set_digestsign';

procedure EVP_PKEY_meth_set_digestverify(pmeth: PEVP_PKEY_METHOD; digestverify: EVP_PKEY_meth_set_digestverify_digestverify); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_set_digestverify';

procedure EVP_PKEY_meth_set_check(pmeth: PEVP_PKEY_METHOD; check: EVP_PKEY_meth_set_check_check); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_set_check';

procedure EVP_PKEY_meth_set_public_check(pmeth: PEVP_PKEY_METHOD; check: EVP_PKEY_meth_set_public_check_check); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_set_public_check';

procedure EVP_PKEY_meth_set_param_check(pmeth: PEVP_PKEY_METHOD; check: EVP_PKEY_meth_set_param_check_check); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_set_param_check';

procedure EVP_PKEY_meth_set_digest_custom(pmeth: PEVP_PKEY_METHOD; digest_custom: EVP_PKEY_meth_set_digest_custom_digest_custom); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_set_digest_custom';

procedure EVP_PKEY_meth_get_init(pmeth: PEVP_PKEY_METHOD; pinit: integer
  { TODO : Cannot convert original type "int (**)(EVP_PKEY_CTX *)" }); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_get_init';

procedure EVP_PKEY_meth_get_copy(pmeth: PEVP_PKEY_METHOD; pcopy: integer
  { TODO : Cannot convert original type "int (**)(EVP_PKEY_CTX *, EVP_PKEY_CTX *)" }); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_get_copy';

procedure EVP_PKEY_meth_get_cleanup(pmeth: PEVP_PKEY_METHOD; pcleanup: integer
  { TODO : Cannot convert original type "void (**)(EVP_PKEY_CTX *)" }); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_get_cleanup';

procedure EVP_PKEY_meth_get_paramgen(pmeth: PEVP_PKEY_METHOD; pparamgen_init: integer
  { TODO : Cannot convert original type "int (**)(EVP_PKEY_CTX *)" }; pparamgen: integer
  { TODO : Cannot convert original type "int (**)(EVP_PKEY_CTX *, EVP_PKEY *)" }); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_get_paramgen';

procedure EVP_PKEY_meth_get_keygen(pmeth: PEVP_PKEY_METHOD; pkeygen_init: integer
  { TODO : Cannot convert original type "int (**)(EVP_PKEY_CTX *)" }; pkeygen: integer
  { TODO : Cannot convert original type "int (**)(EVP_PKEY_CTX *, EVP_PKEY *)" }); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_get_keygen';

procedure EVP_PKEY_meth_get_sign(pmeth: PEVP_PKEY_METHOD; psign_init: integer
  { TODO : Cannot convert original type "int (**)(EVP_PKEY_CTX *)" }; psign: integer
  { TODO : Cannot convert original type "int (**)(EVP_PKEY_CTX *, unsigned char *, size_t *, const unsigned char *, size_t)" }); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_get_sign';

procedure EVP_PKEY_meth_get_verify(pmeth: PEVP_PKEY_METHOD; pverify_init: integer
  { TODO : Cannot convert original type "int (**)(EVP_PKEY_CTX *)" }; pverify: integer
  { TODO : Cannot convert original type "int (**)(EVP_PKEY_CTX *, const unsigned char *, size_t, const unsigned char *, size_t)" }); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_get_verify';

procedure EVP_PKEY_meth_get_verify_recover(pmeth: PEVP_PKEY_METHOD; pverify_recover_init: integer
  { TODO : Cannot convert original type "int (**)(EVP_PKEY_CTX *)" }; pverify_recover: integer { TODO : Cannot convert original type "int (**)(EVP_PKEY_CTX *, unsigned char *, size_t *, const unsigned char *, size_t)" }); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_get_verify_recover';

procedure EVP_PKEY_meth_get_signctx(pmeth: PEVP_PKEY_METHOD; psignctx_init: integer
  { TODO : Cannot convert original type "int (**)(EVP_PKEY_CTX *, EVP_MD_CTX *)" }; psignctx: integer { TODO : Cannot convert original type "int (**)(EVP_PKEY_CTX *, unsigned char *, size_t *, EVP_MD_CTX *)" }); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_get_signctx';

procedure EVP_PKEY_meth_get_verifyctx(pmeth: PEVP_PKEY_METHOD; pverifyctx_init: integer { TODO : Cannot convert original type "int (**)(EVP_PKEY_CTX *, EVP_MD_CTX *)" }; pverifyctx: integer { TODO : Cannot convert original type "int (**)(EVP_PKEY_CTX *, const unsigned char *, int, EVP_MD_CTX *)" }); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_get_verifyctx';

procedure EVP_PKEY_meth_get_encrypt(pmeth: PEVP_PKEY_METHOD; pencrypt_init: integer { TODO : Cannot convert original type "int (**)(EVP_PKEY_CTX *)" }; pencryptfn: integer { TODO : Cannot convert original type "int (**)(EVP_PKEY_CTX *, unsigned char *, size_t *, const unsigned char *, size_t)" }); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_get_encrypt';

procedure EVP_PKEY_meth_get_decrypt(pmeth: PEVP_PKEY_METHOD; pdecrypt_init: integer { TODO : Cannot convert original type "int (**)(EVP_PKEY_CTX *)" }; pdecrypt: integer { TODO : Cannot convert original type "int (**)(EVP_PKEY_CTX *, unsigned char *, size_t *, const unsigned char *, size_t)" }); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_get_decrypt';

procedure EVP_PKEY_meth_get_derive(pmeth: PEVP_PKEY_METHOD; pderive_init: integer { TODO : Cannot convert original type "int (**)(EVP_PKEY_CTX *)" }; pderive: integer { TODO : Cannot convert original type "int (**)(EVP_PKEY_CTX *, unsigned char *, size_t *)" }); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_get_derive';

procedure EVP_PKEY_meth_get_ctrl(pmeth: PEVP_PKEY_METHOD; pctrl: integer { TODO : Cannot convert original type "int (**)(EVP_PKEY_CTX *, int, int, void *)" }; pctrl_str: integer { TODO : Cannot convert original type "int (**)(EVP_PKEY_CTX *, const char *, const char *)" }); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_get_ctrl';

procedure EVP_PKEY_meth_get_digestsign(pmeth: PEVP_PKEY_METHOD; digestsign: integer { TODO : Cannot convert original type "int (**)(EVP_MD_CTX *, unsigned char *, size_t *, const unsigned char *, size_t)" }); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_get_digestsign';

procedure EVP_PKEY_meth_get_digestverify(pmeth: PEVP_PKEY_METHOD; digestverify: integer { TODO : Cannot convert original type "int (**)(EVP_MD_CTX *, const unsigned char *, size_t, const unsigned char *, size_t)" }); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_get_digestverify';

procedure EVP_PKEY_meth_get_check(pmeth: PEVP_PKEY_METHOD; pcheck: integer { TODO : Cannot convert original type "int (**)(EVP_PKEY *)" }); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_get_check';

procedure EVP_PKEY_meth_get_public_check(pmeth: PEVP_PKEY_METHOD; pcheck: integer { TODO : Cannot convert original type "int (**)(EVP_PKEY *)" }); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_get_public_check';

procedure EVP_PKEY_meth_get_param_check(pmeth: PEVP_PKEY_METHOD; pcheck: integer { TODO : Cannot convert original type "int (**)(EVP_PKEY *)" }); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_get_param_check';

procedure EVP_PKEY_meth_get_digest_custom(pmeth: PEVP_PKEY_METHOD; pdigest_custom: integer { TODO : Cannot convert original type "int (**)(EVP_PKEY_CTX *, EVP_MD_CTX *)" }); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_meth_get_digest_custom';

procedure EVP_add_alg_module(); cdecl;
  external LIB_CRYPTO name _PU + 'EVP_add_alg_module';

function CMAC_CTX_new(): PCMAC_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'CMAC_CTX_new';

procedure CMAC_CTX_cleanup(ctx: PCMAC_CTX); cdecl;
  external LIB_CRYPTO name _PU + 'CMAC_CTX_cleanup';

procedure CMAC_CTX_free(ctx: PCMAC_CTX); cdecl;
  external LIB_CRYPTO name _PU + 'CMAC_CTX_free';

function CMAC_CTX_get0_cipher_ctx(ctx: PCMAC_CTX): PEVP_CIPHER_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'CMAC_CTX_get0_cipher_ctx';

function CMAC_CTX_copy(_out: PCMAC_CTX; _in: PCMAC_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMAC_CTX_copy';

function CMAC_Init(ctx: PCMAC_CTX; key: pointer; keylen: PtrUInt; cipher: PEVP_CIPHER; impl: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMAC_Init';

function CMAC_Update(ctx: PCMAC_CTX; data: pointer; dlen: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMAC_Update';

function CMAC_Final(ctx: PCMAC_CTX; _out: PByte; poutlen: PPtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMAC_Final';

function CMAC_resume(ctx: PCMAC_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMAC_resume';

function ERR_load_EC_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_EC_strings';

function EC_GFp_simple_method(): PEC_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GFp_simple_method';

function EC_GFp_mont_method(): PEC_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GFp_mont_method';

function EC_GFp_nist_method(): PEC_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GFp_nist_method';

function EC_GF2m_simple_method(): PEC_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GF2m_simple_method';

function EC_GROUP_new(meth: PEC_METHOD): PEC_GROUP; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_new';

procedure EC_GROUP_clear_free(group: PEC_GROUP); cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_clear_free';

function EC_GROUP_copy(dst: PEC_GROUP; src: PEC_GROUP): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_copy';

function EC_GROUP_dup(src: PEC_GROUP): PEC_GROUP; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_dup';

function EC_GROUP_method_of(group: PEC_GROUP): PEC_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_method_of';

function EC_METHOD_get_field_type(meth: PEC_METHOD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_METHOD_get_field_type';

function EC_GROUP_set_generator(group: PEC_GROUP; generator: PEC_POINT; order: PBIGNUM; cofactor: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_set_generator';

function EC_GROUP_get0_generator(group: PEC_GROUP): PEC_POINT; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_get0_generator';

function EC_GROUP_get_mont_data(group: PEC_GROUP): PBN_MONT_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_get_mont_data';

function EC_GROUP_get_order(group: PEC_GROUP; order: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_get_order';

function EC_GROUP_get0_order(group: PEC_GROUP): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_get0_order';

function EC_GROUP_order_bits(group: PEC_GROUP): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_order_bits';

function EC_GROUP_get_cofactor(group: PEC_GROUP; cofactor: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_get_cofactor';

function EC_GROUP_get0_cofactor(group: PEC_GROUP): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_get0_cofactor';

procedure EC_GROUP_set_curve_name(group: PEC_GROUP; nid: integer); cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_set_curve_name';

function EC_GROUP_get_curve_name(group: PEC_GROUP): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_get_curve_name';

procedure EC_GROUP_set_asn1_flag(group: PEC_GROUP; flag: integer); cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_set_asn1_flag';

function EC_GROUP_get_asn1_flag(group: PEC_GROUP): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_get_asn1_flag';

procedure EC_GROUP_set_point_conversion_form(group: PEC_GROUP; form: point_conversion_form_t); cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_set_point_conversion_form';

function EC_GROUP_get_point_conversion_form(p1: PEC_GROUP): point_conversion_form_t; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_get_point_conversion_form';

function EC_GROUP_get0_seed(x: PEC_GROUP): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_get0_seed';

function EC_GROUP_get_seed_len(p1: PEC_GROUP): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_get_seed_len';

function EC_GROUP_set_seed(p1: PEC_GROUP; p2: PByte; len: PtrUInt): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_set_seed';

function EC_GROUP_set_curve(group: PEC_GROUP; p: PBIGNUM; a: PBIGNUM; b: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_set_curve';

function EC_GROUP_get_curve(group: PEC_GROUP; p: PBIGNUM; a: PBIGNUM; b: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_get_curve';

function EC_GROUP_set_curve_GFp(group: PEC_GROUP; p: PBIGNUM; a: PBIGNUM; b: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_set_curve_GFp';

function EC_GROUP_get_curve_GFp(group: PEC_GROUP; p: PBIGNUM; a: PBIGNUM; b: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_get_curve_GFp';

function EC_GROUP_set_curve_GF2m(group: PEC_GROUP; p: PBIGNUM; a: PBIGNUM; b: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_set_curve_GF2m';

function EC_GROUP_get_curve_GF2m(group: PEC_GROUP; p: PBIGNUM; a: PBIGNUM; b: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_get_curve_GF2m';

function EC_GROUP_get_degree(group: PEC_GROUP): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_get_degree';

function EC_GROUP_check(group: PEC_GROUP; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_check';

function EC_GROUP_check_discriminant(group: PEC_GROUP; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_check_discriminant';

function EC_GROUP_cmp(a: PEC_GROUP; b: PEC_GROUP; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_cmp';

function EC_GROUP_new_curve_GFp(p: PBIGNUM; a: PBIGNUM; b: PBIGNUM; ctx: PBN_CTX): PEC_GROUP; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_new_curve_GFp';

function EC_GROUP_new_curve_GF2m(p: PBIGNUM; a: PBIGNUM; b: PBIGNUM; ctx: PBN_CTX): PEC_GROUP; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_new_curve_GF2m';

function EC_GROUP_new_from_ecparameters(params: PECPARAMETERS): PEC_GROUP; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_new_from_ecparameters';

function EC_GROUP_get_ecparameters(group: PEC_GROUP; params: PECPARAMETERS): PECPARAMETERS; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_get_ecparameters';

function EC_GROUP_new_from_ecpkparameters(params: PECPKPARAMETERS): PEC_GROUP; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_new_from_ecpkparameters';

function EC_GROUP_get_ecpkparameters(group: PEC_GROUP; params: PECPKPARAMETERS): PECPKPARAMETERS; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_get_ecpkparameters';

function EC_get_builtin_curves(r: PEC_builtin_curve; nitems: PtrUInt): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'EC_get_builtin_curves';

function EC_curve_nid2nist(nid: integer): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'EC_curve_nid2nist';

function EC_curve_nist2nid(name: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_curve_nist2nid';

procedure EC_POINT_clear_free(point: PEC_POINT); cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_clear_free';

function EC_POINT_copy(dst: PEC_POINT; src: PEC_POINT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_copy';

function EC_POINT_dup(src: PEC_POINT; group: PEC_GROUP): PEC_POINT; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_dup';

function EC_POINT_method_of(point: PEC_POINT): PEC_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_method_of';

function EC_POINT_set_to_infinity(group: PEC_GROUP; point: PEC_POINT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_set_to_infinity';

function EC_POINT_set_Jprojective_coordinates_GFp(group: PEC_GROUP; p: PEC_POINT; x: PBIGNUM; y: PBIGNUM; z: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_set_Jprojective_coordinates_GFp';

function EC_POINT_get_Jprojective_coordinates_GFp(group: PEC_GROUP; p: PEC_POINT; x: PBIGNUM; y: PBIGNUM; z: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_get_Jprojective_coordinates_GFp';

function EC_POINT_set_affine_coordinates(group: PEC_GROUP; p: PEC_POINT; x: PBIGNUM; y: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_set_affine_coordinates';

function EC_POINT_get_affine_coordinates(group: PEC_GROUP; p: PEC_POINT; x: PBIGNUM; y: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_get_affine_coordinates';

function EC_POINT_set_affine_coordinates_GFp(group: PEC_GROUP; p: PEC_POINT; x: PBIGNUM; y: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_set_affine_coordinates_GFp';

function EC_POINT_get_affine_coordinates_GFp(group: PEC_GROUP; p: PEC_POINT; x: PBIGNUM; y: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_get_affine_coordinates_GFp';

function EC_POINT_set_compressed_coordinates(group: PEC_GROUP; p: PEC_POINT; x: PBIGNUM; y_bit: integer; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_set_compressed_coordinates';

function EC_POINT_set_compressed_coordinates_GFp(group: PEC_GROUP; p: PEC_POINT; x: PBIGNUM; y_bit: integer; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_set_compressed_coordinates_GFp';

function EC_POINT_set_affine_coordinates_GF2m(group: PEC_GROUP; p: PEC_POINT; x: PBIGNUM; y: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_set_affine_coordinates_GF2m';

function EC_POINT_get_affine_coordinates_GF2m(group: PEC_GROUP; p: PEC_POINT; x: PBIGNUM; y: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_get_affine_coordinates_GF2m';

function EC_POINT_set_compressed_coordinates_GF2m(group: PEC_GROUP; p: PEC_POINT; x: PBIGNUM; y_bit: integer; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_set_compressed_coordinates_GF2m';

function EC_POINT_point2oct(group: PEC_GROUP; p: PEC_POINT; form: point_conversion_form_t; buf: PByte; len: PtrUInt; ctx: PBN_CTX): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_point2oct';

function EC_POINT_point2bn(p1: PEC_GROUP; p2: PEC_POINT; form: point_conversion_form_t; p4: PBIGNUM; p5: PBN_CTX): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_point2bn';

function EC_POINT_point2hex(p1: PEC_GROUP; p2: PEC_POINT; form: point_conversion_form_t; p4: PBN_CTX): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_point2hex';

function EC_POINT_hex2point(p1: PEC_GROUP; p2: PUtf8Char; p3: PEC_POINT; p4: PBN_CTX): PEC_POINT; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_hex2point';

function EC_POINT_add(group: PEC_GROUP; r: PEC_POINT; a: PEC_POINT; b: PEC_POINT; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_add';

function EC_POINT_dbl(group: PEC_GROUP; r: PEC_POINT; a: PEC_POINT; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_dbl';

function EC_POINT_invert(group: PEC_GROUP; a: PEC_POINT; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_invert';

function EC_POINT_is_at_infinity(group: PEC_GROUP; p: PEC_POINT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_is_at_infinity';

function EC_POINT_is_on_curve(group: PEC_GROUP; point: PEC_POINT; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_is_on_curve';

function EC_POINT_cmp(group: PEC_GROUP; a: PEC_POINT; b: PEC_POINT; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_cmp';

function EC_POINT_make_affine(group: PEC_GROUP; point: PEC_POINT; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_make_affine';

function EC_POINTs_make_affine(group: PEC_GROUP; num: PtrUInt; points: PPEC_POINT; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINTs_make_affine';

function EC_POINTs_mul(group: PEC_GROUP; r: PEC_POINT; n: PBIGNUM; num: PtrUInt; p: PPEC_POINT; m: PPBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINTs_mul';

function EC_POINT_mul(group: PEC_GROUP; r: PEC_POINT; n: PBIGNUM; q: PEC_POINT; m: PBIGNUM; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_POINT_mul';

function EC_GROUP_precompute_mult(group: PEC_GROUP; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_precompute_mult';

function EC_GROUP_have_precompute_mult(group: PEC_GROUP): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_have_precompute_mult';

function ECPKPARAMETERS_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ECPKPARAMETERS_it';

function ECPKPARAMETERS_new(): PECPKPARAMETERS; cdecl;
  external LIB_CRYPTO name _PU + 'ECPKPARAMETERS_new';

procedure ECPKPARAMETERS_free(a: PECPKPARAMETERS); cdecl;
  external LIB_CRYPTO name _PU + 'ECPKPARAMETERS_free';

function ECPARAMETERS_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ECPARAMETERS_it';

function ECPARAMETERS_new(): PECPARAMETERS; cdecl;
  external LIB_CRYPTO name _PU + 'ECPARAMETERS_new';

procedure ECPARAMETERS_free(a: PECPARAMETERS); cdecl;
  external LIB_CRYPTO name _PU + 'ECPARAMETERS_free';

function EC_GROUP_get_basis_type(p1: PEC_GROUP): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_get_basis_type';

function EC_GROUP_get_trinomial_basis(p1: PEC_GROUP; k: PCardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_get_trinomial_basis';

function EC_GROUP_get_pentanomial_basis(p1: PEC_GROUP; k1: PCardinal; k2: PCardinal; k3: PCardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_GROUP_get_pentanomial_basis';

function d2i_ECPKParameters(p1: PPEC_GROUP; _in: PPByte; len: integer): PEC_GROUP; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ECPKParameters';

function i2d_ECPKParameters(p1: PEC_GROUP; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ECPKParameters';

function ECPKParameters_print(bp: PBIO; x: PEC_GROUP; off: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ECPKParameters_print';

function ECPKParameters_print_fp(fp: PPointer; x: PEC_GROUP; off: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ECPKParameters_print_fp';

function EC_KEY_get_flags(key: PEC_KEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_get_flags';

procedure EC_KEY_set_flags(key: PEC_KEY; flags: integer); cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_set_flags';

procedure EC_KEY_clear_flags(key: PEC_KEY; flags: integer); cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_clear_flags';

function EC_KEY_new_by_curve_name(nid: integer): PEC_KEY; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_new_by_curve_name';

function EC_KEY_copy(dst: PEC_KEY; src: PEC_KEY): PEC_KEY; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_copy';

function EC_KEY_dup(src: PEC_KEY): PEC_KEY; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_dup';

function EC_KEY_up_ref(key: PEC_KEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_up_ref';

function EC_KEY_get0_engine(eckey: PEC_KEY): PENGINE; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_get0_engine';

function EC_KEY_get0_group(key: PEC_KEY): PEC_GROUP; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_get0_group';

function EC_KEY_get_enc_flags(key: PEC_KEY): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_get_enc_flags';

procedure EC_KEY_set_enc_flags(eckey: PEC_KEY; flags: cardinal); cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_set_enc_flags';

function EC_KEY_get_conv_form(key: PEC_KEY): point_conversion_form_t; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_get_conv_form';

procedure EC_KEY_set_conv_form(eckey: PEC_KEY; cform: point_conversion_form_t); cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_set_conv_form';

function EC_KEY_set_ex_data(key: PEC_KEY; idx: integer; arg: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_set_ex_data';

function EC_KEY_get_ex_data(key: PEC_KEY; idx: integer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_get_ex_data';

procedure EC_KEY_set_asn1_flag(eckey: PEC_KEY; asn1_flag: integer); cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_set_asn1_flag';

function EC_KEY_precompute_mult(key: PEC_KEY; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_precompute_mult';

function EC_KEY_check_key(key: PEC_KEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_check_key';

function EC_KEY_can_sign(eckey: PEC_KEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_can_sign';

function EC_KEY_oct2key(key: PEC_KEY; buf: PByte; len: PtrUInt; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_oct2key';

function EC_KEY_oct2priv(key: PEC_KEY; buf: PByte; len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_oct2priv';

function EC_KEY_priv2oct(key: PEC_KEY; buf: PByte; len: PtrUInt): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_priv2oct';

function EC_KEY_priv2buf(eckey: PEC_KEY; pbuf: PPByte): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_priv2buf';

function d2i_ECPrivateKey(key: PPEC_KEY; _in: PPByte; len: integer): PEC_KEY; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ECPrivateKey';

function i2d_ECPrivateKey(key: PEC_KEY; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ECPrivateKey';

function d2i_ECParameters(key: PPEC_KEY; _in: PPByte; len: integer): PEC_KEY; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ECParameters';

function i2d_ECParameters(key: PEC_KEY; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ECParameters';

function o2i_ECPublicKey(key: PPEC_KEY; _in: PPByte; len: integer): PEC_KEY; cdecl;
  external LIB_CRYPTO name _PU + 'o2i_ECPublicKey';

function i2o_ECPublicKey(key: PEC_KEY; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2o_ECPublicKey';

function ECParameters_print(bp: PBIO; key: PEC_KEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ECParameters_print';

function EC_KEY_print(bp: PBIO; key: PEC_KEY; off: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_print';

function ECParameters_print_fp(fp: PPointer; key: PEC_KEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ECParameters_print_fp';

function EC_KEY_print_fp(fp: PPointer; key: PEC_KEY; off: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_print_fp';

function EC_KEY_OpenSSL(): PEC_KEY_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_OpenSSL';

function EC_KEY_get_default_method(): PEC_KEY_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_get_default_method';

procedure EC_KEY_set_default_method(meth: PEC_KEY_METHOD); cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_set_default_method';

function EC_KEY_get_method(key: PEC_KEY): PEC_KEY_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_get_method';

function EC_KEY_set_method(key: PEC_KEY; meth: PEC_KEY_METHOD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_set_method';

function EC_KEY_new_method(engine: PENGINE): PEC_KEY; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_new_method';

function ECDH_KDF_X9_62(_out: PByte; outlen: PtrUInt; Z: PByte; Zlen: PtrUInt; sinfo: PByte; sinfolen: PtrUInt; md: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ECDH_KDF_X9_62';

function ECDSA_SIG_new(): PECDSA_SIG; cdecl;
  external LIB_CRYPTO name _PU + 'ECDSA_SIG_new';

procedure ECDSA_SIG_free(sig: PECDSA_SIG); cdecl;
  external LIB_CRYPTO name _PU + 'ECDSA_SIG_free';

function i2d_ECDSA_SIG(sig: PECDSA_SIG; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ECDSA_SIG';

function d2i_ECDSA_SIG(sig: PPECDSA_SIG; pp: PPByte; len: integer): PECDSA_SIG; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ECDSA_SIG';

procedure ECDSA_SIG_get0(sig: PECDSA_SIG; pr: PPBIGNUM; ps: PPBIGNUM); cdecl;
  external LIB_CRYPTO name _PU + 'ECDSA_SIG_get0';

function ECDSA_SIG_get0_r(sig: PECDSA_SIG): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'ECDSA_SIG_get0_r';

function ECDSA_SIG_get0_s(sig: PECDSA_SIG): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'ECDSA_SIG_get0_s';

function ECDSA_SIG_set0(sig: PECDSA_SIG; r: PBIGNUM; s: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ECDSA_SIG_set0';

function ECDSA_do_sign(dgst: PByte; dgst_len: integer; eckey: PEC_KEY): PECDSA_SIG; cdecl;
  external LIB_CRYPTO name _PU + 'ECDSA_do_sign';

function ECDSA_do_sign_ex(dgst: PByte; dgstlen: integer; kinv: PBIGNUM; rp: PBIGNUM; eckey: PEC_KEY): PECDSA_SIG; cdecl;
  external LIB_CRYPTO name _PU + 'ECDSA_do_sign_ex';

function ECDSA_do_verify(dgst: PByte; dgst_len: integer; sig: PECDSA_SIG; eckey: PEC_KEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ECDSA_do_verify';

function ECDSA_sign_setup(eckey: PEC_KEY; ctx: PBN_CTX; kinv: PPBIGNUM; rp: PPBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ECDSA_sign_setup';

function ECDSA_sign_ex(typ: integer; dgst: PByte; dgstlen: integer; sig: PByte; siglen: PCardinal; kinv: PBIGNUM; rp: PBIGNUM; eckey: PEC_KEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ECDSA_sign_ex';

function EC_KEY_METHOD_new(meth: PEC_KEY_METHOD): PEC_KEY_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_METHOD_new';

procedure EC_KEY_METHOD_free(meth: PEC_KEY_METHOD); cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_METHOD_free';

procedure EC_KEY_METHOD_set_init(meth: PEC_KEY_METHOD; init: EC_KEY_METHOD_set_init_init; finish: EC_KEY_METHOD_set_init_finish; copy: EC_KEY_METHOD_set_init_copy; set_group: EC_KEY_METHOD_set_init_set_group; set_private: EC_KEY_METHOD_set_init_set_private; set_public: EC_KEY_METHOD_set_init_set_public); cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_METHOD_set_init';

procedure EC_KEY_METHOD_set_keygen(meth: PEC_KEY_METHOD; keygen: EC_KEY_METHOD_set_keygen_keygen); cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_METHOD_set_keygen';

procedure EC_KEY_METHOD_set_compute_key(meth: PEC_KEY_METHOD; ckey: EC_KEY_METHOD_set_compute_key_ckey); cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_METHOD_set_compute_key';

procedure EC_KEY_METHOD_set_sign(meth: PEC_KEY_METHOD; sign: EC_KEY_METHOD_set_sign_sign; sign_setup: EC_KEY_METHOD_set_sign_sign_setup; sign_sig: EC_KEY_METHOD_set_sign_sign_sig); cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_METHOD_set_sign';

procedure EC_KEY_METHOD_set_verify(meth: PEC_KEY_METHOD; verify: EC_KEY_METHOD_set_verify_verify; verify_sig: EC_KEY_METHOD_set_verify_verify_sig); cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_METHOD_set_verify';

procedure EC_KEY_METHOD_get_init(meth: PEC_KEY_METHOD; pinit: integer { TODO : Cannot convert original type "int (**)(EC_KEY *)" }; pfinish: integer { TODO : Cannot convert original type "void (**)(EC_KEY *)" }; pcopy: integer { TODO : Cannot convert original type "int (**)(EC_KEY *, const EC_KEY *)" }; pset_group: integer { TODO : Cannot convert original type "int (**)(EC_KEY *, const EC_GROUP *)" }; pset_private: integer { TODO : Cannot convert original type "int (**)(EC_KEY *, const BIGNUM *)" }; pset_public: integer { TODO : Cannot convert original type "int (**)(EC_KEY *, const EC_POINT *)" }); cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_METHOD_get_init';

procedure EC_KEY_METHOD_get_keygen(meth: PEC_KEY_METHOD; pkeygen: integer { TODO : Cannot convert original type "int (**)(EC_KEY *)" }); cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_METHOD_get_keygen';

procedure EC_KEY_METHOD_get_compute_key(meth: PEC_KEY_METHOD; pck: integer { TODO : Cannot convert original type "int (**)(unsigned char **, size_t *, const EC_POINT *, const EC_KEY *)" }); cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_METHOD_get_compute_key';

procedure EC_KEY_METHOD_get_sign(meth: PEC_KEY_METHOD; psign: integer { TODO : Cannot convert original type "int (**)(int, const unsigned char *, int, unsigned char *, unsigned int *, const BIGNUM *, const BIGNUM *, EC_KEY *)" }; psign_setup: integer { TODO : Cannot convert original type "int (**)(EC_KEY *, BN_CTX *, BIGNUM **, BIGNUM **)" }; psign_sig: integer { TODO : Cannot convert original type "ECDSA_SIG *(**)(const unsigned char *, int, const BIGNUM *, const BIGNUM *, EC_KEY *)" }); cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_METHOD_get_sign';

procedure EC_KEY_METHOD_get_verify(meth: PEC_KEY_METHOD; pverify: integer { TODO : Cannot convert original type "int (**)(int, const unsigned char *, int, const unsigned char *, int, EC_KEY *)" }; pverify_sig: integer { TODO : Cannot convert original type "int (**)(const unsigned char *, int, const ECDSA_SIG *, EC_KEY *)" }); cdecl;
  external LIB_CRYPTO name _PU + 'EC_KEY_METHOD_get_verify';

function ERR_load_RSA_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_RSA_strings';

function RSA_new(): PRSA; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_new';

function RSA_new_method(engine: PENGINE): PRSA; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_new_method';

function RSA_bits(rsa: PRSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_bits';

function RSA_size(rsa: PRSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_size';

function RSA_security_bits(rsa: PRSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_security_bits';

function RSA_set0_key(r: PRSA; n: PBIGNUM; e: PBIGNUM; d: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_set0_key';

function RSA_set0_factors(r: PRSA; p: PBIGNUM; q: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_set0_factors';

function RSA_set0_crt_params(r: PRSA; dmp1: PBIGNUM; dmq1: PBIGNUM; iqmp: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_set0_crt_params';

function RSA_set0_multi_prime_params(r: PRSA; primes: PPBIGNUM; exps: PPBIGNUM; coeffs: PPBIGNUM; pnum: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_set0_multi_prime_params';

procedure RSA_get0_factors(r: PRSA; p: PPBIGNUM; q: PPBIGNUM); cdecl;
  external LIB_CRYPTO name _PU + 'RSA_get0_factors';

function RSA_get_multi_prime_extra_count(r: PRSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_get_multi_prime_extra_count';

function RSA_get0_multi_prime_factors(r: PRSA; primes: PPBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_get0_multi_prime_factors';

procedure RSA_get0_crt_params(r: PRSA; dmp1: PPBIGNUM; dmq1: PPBIGNUM; iqmp: PPBIGNUM); cdecl;
  external LIB_CRYPTO name _PU + 'RSA_get0_crt_params';

function RSA_get0_multi_prime_crt_params(r: PRSA; exps: PPBIGNUM; coeffs: PPBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_get0_multi_prime_crt_params';

function RSA_get0_n(d: PRSA): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_get0_n';

function RSA_get0_e(d: PRSA): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_get0_e';

function RSA_get0_d(d: PRSA): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_get0_d';

function RSA_get0_p(d: PRSA): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_get0_p';

function RSA_get0_q(d: PRSA): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_get0_q';

function RSA_get0_dmp1(r: PRSA): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_get0_dmp1';

function RSA_get0_dmq1(r: PRSA): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_get0_dmq1';

function RSA_get0_iqmp(r: PRSA): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_get0_iqmp';

function RSA_get0_pss_params(r: PRSA): PRSA_PSS_PARAMS; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_get0_pss_params';

procedure RSA_clear_flags(r: PRSA; flags: integer); cdecl;
  external LIB_CRYPTO name _PU + 'RSA_clear_flags';

function RSA_test_flags(r: PRSA; flags: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_test_flags';

procedure RSA_set_flags(r: PRSA; flags: integer); cdecl;
  external LIB_CRYPTO name _PU + 'RSA_set_flags';

function RSA_get_version(r: PRSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_get_version';

function RSA_get0_engine(r: PRSA): PENGINE; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_get0_engine';

function RSA_generate_key(bits: integer; e: cardinal; callback: RSA_generate_key_callback; cb_arg: pointer): PRSA; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_generate_key';

function RSA_generate_key_ex(rsa: PRSA; bits: integer; e: PBIGNUM; cb: PBN_GENCB): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_generate_key_ex';

function RSA_generate_multi_prime_key(rsa: PRSA; bits: integer; primes: integer; e: PBIGNUM; cb: PBN_GENCB): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_generate_multi_prime_key';

function RSA_X931_derive_ex(rsa: PRSA; p1: PBIGNUM; p2: PBIGNUM; q1: PBIGNUM; q2: PBIGNUM; Xp1: PBIGNUM; Xp2: PBIGNUM; Xp: PBIGNUM; Xq1: PBIGNUM; Xq2: PBIGNUM; Xq: PBIGNUM; e: PBIGNUM; cb: PBN_GENCB): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_X931_derive_ex';

function RSA_X931_generate_key_ex(rsa: PRSA; bits: integer; e: PBIGNUM; cb: PBN_GENCB): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_X931_generate_key_ex';

function RSA_check_key(p1: PRSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_check_key';

function RSA_check_key_ex(p1: PRSA; cb: PBN_GENCB): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_check_key_ex';

procedure RSA_free(r: PRSA); cdecl;
  external LIB_CRYPTO name _PU + 'RSA_free';

function RSA_up_ref(r: PRSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_up_ref';

function RSA_flags(r: PRSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_flags';

procedure RSA_set_default_method(meth: PRSA_METHOD); cdecl;
  external LIB_CRYPTO name _PU + 'RSA_set_default_method';

function RSA_get_default_method(): PRSA_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_get_default_method';

function RSA_null_method(): PRSA_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_null_method';

function RSA_get_method(rsa: PRSA): PRSA_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_get_method';

function RSA_set_method(rsa: PRSA; meth: PRSA_METHOD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_set_method';

function RSA_PKCS1_OpenSSL(): PRSA_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_PKCS1_OpenSSL';

function d2i_RSAPublicKey(a: PPRSA; _in: PPByte; len: integer): PRSA; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_RSAPublicKey';

function i2d_RSAPublicKey(a: PRSA; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_RSAPublicKey';

function RSAPublicKey_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'RSAPublicKey_it';

function d2i_RSAPrivateKey(a: PPRSA; _in: PPByte; len: integer): PRSA; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_RSAPrivateKey';

function i2d_RSAPrivateKey(a: PRSA; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_RSAPrivateKey';

function RSAPrivateKey_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'RSAPrivateKey_it';

function RSA_PSS_PARAMS_new(): PRSA_PSS_PARAMS; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_PSS_PARAMS_new';

procedure RSA_PSS_PARAMS_free(a: PRSA_PSS_PARAMS); cdecl;
  external LIB_CRYPTO name _PU + 'RSA_PSS_PARAMS_free';

function d2i_RSA_PSS_PARAMS(a: PPRSA_PSS_PARAMS; _in: PPByte; len: integer): PRSA_PSS_PARAMS; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_RSA_PSS_PARAMS';

function i2d_RSA_PSS_PARAMS(a: PRSA_PSS_PARAMS; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_RSA_PSS_PARAMS';

function RSA_PSS_PARAMS_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_PSS_PARAMS_it';

function RSA_OAEP_PARAMS_new(): PRSA_OAEP_PARAMS; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_OAEP_PARAMS_new';

procedure RSA_OAEP_PARAMS_free(a: PRSA_OAEP_PARAMS); cdecl;
  external LIB_CRYPTO name _PU + 'RSA_OAEP_PARAMS_free';

function d2i_RSA_OAEP_PARAMS(a: PPRSA_OAEP_PARAMS; _in: PPByte; len: integer): PRSA_OAEP_PARAMS; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_RSA_OAEP_PARAMS';

function i2d_RSA_OAEP_PARAMS(a: PRSA_OAEP_PARAMS; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_RSA_OAEP_PARAMS';

function RSA_OAEP_PARAMS_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_OAEP_PARAMS_it';

function RSA_print_fp(fp: PPointer; r: PRSA; offset: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_print_fp';

function RSA_print(bp: PBIO; r: PRSA; offset: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_print';

function RSA_sign(typ: integer; m: PByte; m_length: cardinal; sigret: PByte; siglen: PCardinal; rsa: PRSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_sign';

function RSA_verify(typ: integer; m: PByte; m_length: cardinal; sigbuf: PByte; siglen: cardinal; rsa: PRSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_verify';

function RSA_sign_ASN1_OCTET_STRING(typ: integer; m: PByte; m_length: cardinal; sigret: PByte; siglen: PCardinal; rsa: PRSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_sign_ASN1_OCTET_STRING';

function RSA_verify_ASN1_OCTET_STRING(typ: integer; m: PByte; m_length: cardinal; sigbuf: PByte; siglen: cardinal; rsa: PRSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_verify_ASN1_OCTET_STRING';

function RSA_blinding_on(rsa: PRSA; ctx: PBN_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_blinding_on';

procedure RSA_blinding_off(rsa: PRSA); cdecl;
  external LIB_CRYPTO name _PU + 'RSA_blinding_off';

function RSA_setup_blinding(rsa: PRSA; ctx: PBN_CTX): PBN_BLINDING; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_setup_blinding';

function RSA_padding_add_PKCS1_type_1(_to: PByte; tlen: integer; f: PByte; fl: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_padding_add_PKCS1_type_1';

function RSA_padding_check_PKCS1_type_1(_to: PByte; tlen: integer; f: PByte; fl: integer; rsa_len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_padding_check_PKCS1_type_1';

function RSA_padding_add_PKCS1_type_2(_to: PByte; tlen: integer; f: PByte; fl: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_padding_add_PKCS1_type_2';

function RSA_padding_check_PKCS1_type_2(_to: PByte; tlen: integer; f: PByte; fl: integer; rsa_len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_padding_check_PKCS1_type_2';

function PKCS1_MGF1(mask: PByte; len: integer; seed: PByte; seedlen: integer; dgst: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS1_MGF1';

function RSA_padding_add_PKCS1_OAEP(_to: PByte; tlen: integer; f: PByte; fl: integer; p: PByte; pl: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_padding_add_PKCS1_OAEP';

function RSA_padding_check_PKCS1_OAEP(_to: PByte; tlen: integer; f: PByte; fl: integer; rsa_len: integer; p: PByte; pl: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_padding_check_PKCS1_OAEP';

function RSA_padding_add_PKCS1_OAEP_mgf1(_to: PByte; tlen: integer; from: PByte; flen: integer; param: PByte; plen: integer; md: PEVP_MD; mgf1md: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_padding_add_PKCS1_OAEP_mgf1';

function RSA_padding_check_PKCS1_OAEP_mgf1(_to: PByte; tlen: integer; from: PByte; flen: integer; num: integer; param: PByte; plen: integer; md: PEVP_MD; mgf1md: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_padding_check_PKCS1_OAEP_mgf1';

function RSA_padding_add_SSLv23(_to: PByte; tlen: integer; f: PByte; fl: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_padding_add_SSLv23';

function RSA_padding_check_SSLv23(_to: PByte; tlen: integer; f: PByte; fl: integer; rsa_len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_padding_check_SSLv23';

function RSA_padding_add_none(_to: PByte; tlen: integer; f: PByte; fl: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_padding_add_none';

function RSA_padding_check_none(_to: PByte; tlen: integer; f: PByte; fl: integer; rsa_len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_padding_check_none';

function RSA_padding_add_X931(_to: PByte; tlen: integer; f: PByte; fl: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_padding_add_X931';

function RSA_padding_check_X931(_to: PByte; tlen: integer; f: PByte; fl: integer; rsa_len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_padding_check_X931';

function RSA_X931_hash_id(nid: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_X931_hash_id';

function RSA_verify_PKCS1_PSS(rsa: PRSA; mHash: PByte; Hash: PEVP_MD; EM: PByte; sLen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_verify_PKCS1_PSS';

function RSA_padding_add_PKCS1_PSS(rsa: PRSA; EM: PByte; mHash: PByte; Hash: PEVP_MD; sLen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_padding_add_PKCS1_PSS';

function RSA_verify_PKCS1_PSS_mgf1(rsa: PRSA; mHash: PByte; Hash: PEVP_MD; mgf1Hash: PEVP_MD; EM: PByte; sLen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_verify_PKCS1_PSS_mgf1';

function RSA_padding_add_PKCS1_PSS_mgf1(rsa: PRSA; EM: PByte; mHash: PByte; Hash: PEVP_MD; mgf1Hash: PEVP_MD; sLen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_padding_add_PKCS1_PSS_mgf1';

function RSA_set_ex_data(r: PRSA; idx: integer; arg: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_set_ex_data';

function RSA_get_ex_data(r: PRSA; idx: integer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_get_ex_data';

function RSAPublicKey_dup(rsa: PRSA): PRSA; cdecl;
  external LIB_CRYPTO name _PU + 'RSAPublicKey_dup';

function RSAPrivateKey_dup(rsa: PRSA): PRSA; cdecl;
  external LIB_CRYPTO name _PU + 'RSAPrivateKey_dup';

function RSA_meth_new(name: PUtf8Char; flags: integer): PRSA_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_meth_new';

procedure RSA_meth_free(meth: PRSA_METHOD); cdecl;
  external LIB_CRYPTO name _PU + 'RSA_meth_free';

function RSA_meth_dup(meth: PRSA_METHOD): PRSA_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_meth_dup';

function RSA_meth_get0_name(meth: PRSA_METHOD): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_meth_get0_name';

function RSA_meth_set1_name(meth: PRSA_METHOD; name: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_meth_set1_name';

function RSA_meth_get_flags(meth: PRSA_METHOD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_meth_get_flags';

function RSA_meth_set_flags(meth: PRSA_METHOD; flags: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_meth_set_flags';

function RSA_meth_get0_app_data(meth: PRSA_METHOD): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_meth_get0_app_data';

function RSA_meth_set0_app_data(meth: PRSA_METHOD; app_data: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_meth_set0_app_data';

//function RSA_meth_get_pub_enc(flen: Integerfrom: PByte_to: PBytersa: PRSApadding: Integermeth: PRSA_METHOD): integer { TODO : Cannot convert original type "int (*)(int, const unsigned char *, unsigned char *, RSA *, int)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'RSA_meth_get_pub_enc';

function RSA_meth_set_pub_enc(rsa: PRSA_METHOD; pub_enc: RSA_meth_set_pub_enc_pub_enc): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_meth_set_pub_enc';

//function RSA_meth_get_pub_dec(flen: Integerfrom: PByte_to: PBytersa: PRSApadding: Integermeth: PRSA_METHOD): integer { TODO : Cannot convert original type "int (*)(int, const unsigned char *, unsigned char *, RSA *, int)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'RSA_meth_get_pub_dec';

function RSA_meth_set_pub_dec(rsa: PRSA_METHOD; pub_dec: RSA_meth_set_pub_dec_pub_dec): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_meth_set_pub_dec';

//function RSA_meth_get_priv_enc(flen: Integerfrom: PByte_to: PBytersa: PRSApadding: Integermeth: PRSA_METHOD): integer { TODO : Cannot convert original type "int (*)(int, const unsigned char *, unsigned char *, RSA *, int)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'RSA_meth_get_priv_enc';

function RSA_meth_set_priv_enc(rsa: PRSA_METHOD; priv_enc: RSA_meth_set_priv_enc_priv_enc): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_meth_set_priv_enc';

//function RSA_meth_get_priv_dec(flen: Integerfrom: PByte_to: PBytersa: PRSApadding: Integermeth: PRSA_METHOD): integer { TODO : Cannot convert original type "int (*)(int, const unsigned char *, unsigned char *, RSA *, int)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'RSA_meth_get_priv_dec';

function RSA_meth_set_priv_dec(rsa: PRSA_METHOD; priv_dec: RSA_meth_set_priv_dec_priv_dec): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_meth_set_priv_dec';

//function RSA_meth_get_mod_exp(r0: PBIGNUMi: PBIGNUMrsa: PRSActx: PBN_CTXmeth: PRSA_METHOD): integer { TODO : Cannot convert original type "int (*)(BIGNUM *, const BIGNUM *, RSA *, BN_CTX *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'RSA_meth_get_mod_exp';

function RSA_meth_set_mod_exp(rsa: PRSA_METHOD; mod_exp: RSA_meth_set_mod_exp_mod_exp): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_meth_set_mod_exp';

//function RSA_meth_get_bn_mod_exp(r: PBIGNUMa: PBIGNUMp: PBIGNUMm: PBIGNUMctx: PBN_CTXm_ctx: PBN_MONT_CTXmeth: PRSA_METHOD): integer { TODO : Cannot convert original type "int (*)(BIGNUM *, const BIGNUM *, const BIGNUM *, const BIGNUM *, BN_CTX *, BN_MONT_CTX *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'RSA_meth_get_bn_mod_exp';

function RSA_meth_set_bn_mod_exp(rsa: PRSA_METHOD; bn_mod_exp: RSA_meth_set_bn_mod_exp_bn_mod_exp): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_meth_set_bn_mod_exp';

//function RSA_meth_get_init(rsa: PRSAmeth: PRSA_METHOD): integer { TODO : Cannot convert original type "int (*)(RSA *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'RSA_meth_get_init';

function RSA_meth_set_init(rsa: PRSA_METHOD; init: RSA_meth_set_init_init): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_meth_set_init';

//function RSA_meth_get_finish(rsa: PRSAmeth: PRSA_METHOD): integer { TODO : Cannot convert original type "int (*)(RSA *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'RSA_meth_get_finish';

function RSA_meth_set_finish(rsa: PRSA_METHOD; finish: RSA_meth_set_finish_finish): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_meth_set_finish';

//function RSA_meth_get_sign(typ: Integerm: PBytem_length: Cardinalsigret: PBytesiglen: PCardinalrsa: PRSAmeth: PRSA_METHOD): integer { TODO : Cannot convert original type "int (*)(int, const unsigned char *, unsigned int, unsigned char *, unsigned int *, const RSA *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'RSA_meth_get_sign';

function RSA_meth_set_sign(rsa: PRSA_METHOD; sign: RSA_meth_set_sign_sign): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_meth_set_sign';

//function RSA_meth_get_verify(dtype: Integerm: PBytem_length: Cardinalsigbuf: PBytesiglen: Cardinalrsa: PRSAmeth: PRSA_METHOD): integer { TODO : Cannot convert original type "int (*)(int, const unsigned char *, unsigned int, const unsigned char *, unsigned int, const RSA *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'RSA_meth_get_verify';

function RSA_meth_set_verify(rsa: PRSA_METHOD; verify: RSA_meth_set_verify_verify): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_meth_set_verify';

//function RSA_meth_get_keygen(rsa: PRSAbits: Integere: PBIGNUMcb: PBN_GENCBmeth: PRSA_METHOD): integer { TODO : Cannot convert original type "int (*)(RSA *, int, BIGNUM *, BN_GENCB *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'RSA_meth_get_keygen';

function RSA_meth_set_keygen(rsa: PRSA_METHOD; keygen: RSA_meth_set_keygen_keygen): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_meth_set_keygen';

//function RSA_meth_get_multi_prime_keygen(rsa: PRSAbits: Integerprimes: Integere: PBIGNUMcb: PBN_GENCBmeth: PRSA_METHOD): integer { TODO : Cannot convert original type "int (*)(RSA *, int, int, BIGNUM *, BN_GENCB *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'RSA_meth_get_multi_prime_keygen';

function RSA_meth_set_multi_prime_keygen(meth: PRSA_METHOD; keygen: RSA_meth_set_multi_prime_keygen_keygen): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RSA_meth_set_multi_prime_keygen';

function ERR_load_DH_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_DH_strings';

function DHparams_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'DHparams_it';

function DHparams_dup(p1: PDH): PDH; cdecl;
  external LIB_CRYPTO name _PU + 'DHparams_dup';

function DH_OpenSSL(): PDH_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'DH_OpenSSL';

procedure DH_set_default_method(meth: PDH_METHOD); cdecl;
  external LIB_CRYPTO name _PU + 'DH_set_default_method';

function DH_get_default_method(): PDH_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'DH_get_default_method';

function DH_set_method(dh: PDH; meth: PDH_METHOD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_set_method';

function DH_new_method(engine: PENGINE): PDH; cdecl;
  external LIB_CRYPTO name _PU + 'DH_new_method';

function DH_new(): PDH; cdecl;
  external LIB_CRYPTO name _PU + 'DH_new';

procedure DH_free(dh: PDH); cdecl;
  external LIB_CRYPTO name _PU + 'DH_free';

function DH_up_ref(dh: PDH): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_up_ref';

function DH_bits(dh: PDH): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_bits';

function DH_size(dh: PDH): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_size';

function DH_security_bits(dh: PDH): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_security_bits';

function DH_set_ex_data(d: PDH; idx: integer; arg: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_set_ex_data';

function DH_get_ex_data(d: PDH; idx: integer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_get_ex_data';

function DH_generate_parameters(prime_len: integer; generator: integer; callback: DH_generate_parameters_callback; cb_arg: pointer): PDH; cdecl;
  external LIB_CRYPTO name _PU + 'DH_generate_parameters';

function DH_generate_parameters_ex(dh: PDH; prime_len: integer; generator: integer; cb: PBN_GENCB): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_generate_parameters_ex';

function DH_check_params_ex(dh: PDH): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_check_params_ex';

function DH_check_ex(dh: PDH): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_check_ex';

function DH_check_pub_key_ex(dh: PDH; pub_key: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_check_pub_key_ex';

function DH_check_params(dh: PDH; ret: PInteger): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_check_params';

function DH_check(dh: PDH; codes: PInteger): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_check';

function DH_check_pub_key(dh: PDH; pub_key: PBIGNUM; codes: PInteger): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_check_pub_key';

function DH_generate_key(dh: PDH): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_generate_key';

function DH_compute_key(key: PByte; pub_key: PBIGNUM; dh: PDH): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_compute_key';

function DH_compute_key_padded(key: PByte; pub_key: PBIGNUM; dh: PDH): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_compute_key_padded';

function d2i_DHparams(a: PPDH; pp: PPByte; length: integer): PDH; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_DHparams';

function i2d_DHparams(a: PDH; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_DHparams';

function d2i_DHxparams(a: PPDH; pp: PPByte; length: integer): PDH; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_DHxparams';

function i2d_DHxparams(a: PDH; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_DHxparams';

function DHparams_print_fp(fp: PPointer; x: PDH): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DHparams_print_fp';

function DHparams_print(bp: PBIO; x: PDH): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DHparams_print';

function DH_get_1024_160(): PDH; cdecl;
  external LIB_CRYPTO name _PU + 'DH_get_1024_160';

function DH_get_2048_224(): PDH; cdecl;
  external LIB_CRYPTO name _PU + 'DH_get_2048_224';

function DH_get_2048_256(): PDH; cdecl;
  external LIB_CRYPTO name _PU + 'DH_get_2048_256';

function DH_new_by_nid(nid: integer): PDH; cdecl;
  external LIB_CRYPTO name _PU + 'DH_new_by_nid';

function DH_get_nid(dh: PDH): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_get_nid';

function DH_KDF_X9_42(_out: PByte; outlen: PtrUInt; Z: PByte; Zlen: PtrUInt; key_oid: PASN1_OBJECT; ukm: PByte; ukmlen: PtrUInt; md: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_KDF_X9_42';

procedure DH_get0_pqg(dh: PDH; p: PPBIGNUM; q: PPBIGNUM; g: PPBIGNUM); cdecl;
  external LIB_CRYPTO name _PU + 'DH_get0_pqg';

function DH_set0_pqg(dh: PDH; p: PBIGNUM; q: PBIGNUM; g: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_set0_pqg';

procedure DH_get0_key(dh: PDH; pub_key: PPBIGNUM; priv_key: PPBIGNUM); cdecl;
  external LIB_CRYPTO name _PU + 'DH_get0_key';

function DH_set0_key(dh: PDH; pub_key: PBIGNUM; priv_key: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_set0_key';

function DH_get0_p(dh: PDH): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'DH_get0_p';

function DH_get0_q(dh: PDH): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'DH_get0_q';

function DH_get0_g(dh: PDH): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'DH_get0_g';

function DH_get0_priv_key(dh: PDH): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'DH_get0_priv_key';

function DH_get0_pub_key(dh: PDH): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'DH_get0_pub_key';

procedure DH_clear_flags(dh: PDH; flags: integer); cdecl;
  external LIB_CRYPTO name _PU + 'DH_clear_flags';

function DH_test_flags(dh: PDH; flags: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_test_flags';

procedure DH_set_flags(dh: PDH; flags: integer); cdecl;
  external LIB_CRYPTO name _PU + 'DH_set_flags';

function DH_get0_engine(d: PDH): PENGINE; cdecl;
  external LIB_CRYPTO name _PU + 'DH_get0_engine';

function DH_get_length(dh: PDH): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_get_length';

function DH_set_length(dh: PDH; length: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_set_length';

function DH_meth_new(name: PUtf8Char; flags: integer): PDH_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'DH_meth_new';

procedure DH_meth_free(dhm: PDH_METHOD); cdecl;
  external LIB_CRYPTO name _PU + 'DH_meth_free';

function DH_meth_dup(dhm: PDH_METHOD): PDH_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'DH_meth_dup';

function DH_meth_get0_name(dhm: PDH_METHOD): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'DH_meth_get0_name';

function DH_meth_set1_name(dhm: PDH_METHOD; name: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_meth_set1_name';

function DH_meth_get_flags(dhm: PDH_METHOD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_meth_get_flags';

function DH_meth_set_flags(dhm: PDH_METHOD; flags: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_meth_set_flags';

function DH_meth_get0_app_data(dhm: PDH_METHOD): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_meth_get0_app_data';

function DH_meth_set0_app_data(dhm: PDH_METHOD; app_data: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_meth_set0_app_data';

//function DH_meth_get_generate_key(p1: PDHdhm: PDH_METHOD): integer { TODO : Cannot convert original type "int (*)(DH *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'DH_meth_get_generate_key';

function DH_meth_set_generate_key(dhm: PDH_METHOD; generate_key: DH_meth_set_generate_key_generate_key): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_meth_set_generate_key';

//function DH_meth_get_compute_key(key: PBytepub_key: PBIGNUMdh: PDHdhm: PDH_METHOD): integer { TODO : Cannot convert original type "int (*)(unsigned char *, const BIGNUM *, DH *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'DH_meth_get_compute_key';

function DH_meth_set_compute_key(dhm: PDH_METHOD; compute_key: DH_meth_set_compute_key_compute_key): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_meth_set_compute_key';

//function DH_meth_get_bn_mod_exp(p1: PDHp2: PBIGNUMp3: PBIGNUMp4: PBIGNUMp5: PBIGNUMp6: PBN_CTXp7: PBN_MONT_CTXdhm: PDH_METHOD): integer { TODO : Cannot convert original type "int (*)(const DH *, BIGNUM *, const BIGNUM *, const BIGNUM *, const BIGNUM *, BN_CTX *, BN_MONT_CTX *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'DH_meth_get_bn_mod_exp';

function DH_meth_set_bn_mod_exp(dhm: PDH_METHOD; bn_mod_exp: DH_meth_set_bn_mod_exp_bn_mod_exp): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_meth_set_bn_mod_exp';

//function DH_meth_get_init(p1: PDHdhm: PDH_METHOD): integer { TODO : Cannot convert original type "int (*)(DH *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'DH_meth_get_init';

function DH_meth_set_init(dhm: PDH_METHOD; init: DH_meth_set_init_init): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_meth_set_init';

//function DH_meth_get_finish(p1: PDHdhm: PDH_METHOD): integer { TODO : Cannot convert original type "int (*)(DH *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'DH_meth_get_finish';

function DH_meth_set_finish(dhm: PDH_METHOD; finish: DH_meth_set_finish_finish): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_meth_set_finish';

//function DH_meth_get_generate_params(p1: PDHp2: Integerp3: Integerp4: PBN_GENCBdhm: PDH_METHOD): integer { TODO : Cannot convert original type "int (*)(DH *, int, int, BN_GENCB *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'DH_meth_get_generate_params';

function DH_meth_set_generate_params(dhm: PDH_METHOD; generate_params: DH_meth_set_generate_params_generate_params): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DH_meth_set_generate_params';

function ERR_load_DSA_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_DSA_strings';

function DSAparams_dup(x: PDSA): PDSA; cdecl;
  external LIB_CRYPTO name _PU + 'DSAparams_dup';

function DSA_SIG_new(): PDSA_SIG; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_SIG_new';

procedure DSA_SIG_free(a: PDSA_SIG); cdecl;
  external LIB_CRYPTO name _PU + 'DSA_SIG_free';

function i2d_DSA_SIG(a: PDSA_SIG; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_DSA_SIG';

function d2i_DSA_SIG(v: PPDSA_SIG; pp: PPByte; length: integer): PDSA_SIG; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_DSA_SIG';

procedure DSA_SIG_get0(sig: PDSA_SIG; pr: PPBIGNUM; ps: PPBIGNUM); cdecl;
  external LIB_CRYPTO name _PU + 'DSA_SIG_get0';

function DSA_SIG_set0(sig: PDSA_SIG; r: PBIGNUM; s: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_SIG_set0';

function DSA_do_sign(dgst: PByte; dlen: integer; dsa: PDSA): PDSA_SIG; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_do_sign';

function DSA_do_verify(dgst: PByte; dgst_len: integer; sig: PDSA_SIG; dsa: PDSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_do_verify';

function DSA_OpenSSL(): PDSA_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_OpenSSL';

procedure DSA_set_default_method(p1: PDSA_METHOD); cdecl;
  external LIB_CRYPTO name _PU + 'DSA_set_default_method';

function DSA_get_default_method(): PDSA_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_get_default_method';

function DSA_set_method(dsa: PDSA; p2: PDSA_METHOD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_set_method';

function DSA_get_method(d: PDSA): PDSA_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_get_method';

function DSA_new(): PDSA; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_new';

function DSA_new_method(engine: PENGINE): PDSA; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_new_method';

procedure DSA_free(r: PDSA); cdecl;
  external LIB_CRYPTO name _PU + 'DSA_free';

function DSA_up_ref(r: PDSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_up_ref';

function DSA_size(p1: PDSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_size';

function DSA_bits(d: PDSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_bits';

function DSA_security_bits(d: PDSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_security_bits';

function DSA_sign_setup(dsa: PDSA; ctx_in: PBN_CTX; kinvp: PPBIGNUM; rp: PPBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_sign_setup';

function DSA_sign(typ: integer; dgst: PByte; dlen: integer; sig: PByte; siglen: PCardinal; dsa: PDSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_sign';

function DSA_verify(typ: integer; dgst: PByte; dgst_len: integer; sigbuf: PByte; siglen: integer; dsa: PDSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_verify';

function DSA_set_ex_data(d: PDSA; idx: integer; arg: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_set_ex_data';

function DSA_get_ex_data(d: PDSA; idx: integer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_get_ex_data';

function d2i_DSAPublicKey(a: PPDSA; pp: PPByte; length: integer): PDSA; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_DSAPublicKey';

function d2i_DSAPrivateKey(a: PPDSA; pp: PPByte; length: integer): PDSA; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_DSAPrivateKey';

function d2i_DSAparams(a: PPDSA; pp: PPByte; length: integer): PDSA; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_DSAparams';

function DSA_generate_parameters(bits: integer; seed: PByte; seed_len: integer; counter_ret: PInteger; h_ret: PCardinal; callback: DSA_generate_parameters_callback; cb_arg: pointer): PDSA; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_generate_parameters';

function DSA_generate_parameters_ex(dsa: PDSA; bits: integer; seed: PByte; seed_len: integer; counter_ret: PInteger; h_ret: PCardinal; cb: PBN_GENCB): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_generate_parameters_ex';

function DSA_generate_key(a: PDSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_generate_key';

function i2d_DSAPublicKey(a: PDSA; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_DSAPublicKey';

function i2d_DSAPrivateKey(a: PDSA; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_DSAPrivateKey';

function i2d_DSAparams(a: PDSA; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_DSAparams';

function DSAparams_print(bp: PBIO; x: PDSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSAparams_print';

function DSA_print(bp: PBIO; x: PDSA; off: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_print';

function DSAparams_print_fp(fp: PPointer; x: PDSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSAparams_print_fp';

function DSA_print_fp(bp: PPointer; x: PDSA; off: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_print_fp';

function DSA_dup_DH(r: PDSA): PDH; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_dup_DH';

procedure DSA_get0_pqg(d: PDSA; p: PPBIGNUM; q: PPBIGNUM; g: PPBIGNUM); cdecl;
  external LIB_CRYPTO name _PU + 'DSA_get0_pqg';

function DSA_set0_pqg(d: PDSA; p: PBIGNUM; q: PBIGNUM; g: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_set0_pqg';

procedure DSA_get0_key(d: PDSA; pub_key: PPBIGNUM; priv_key: PPBIGNUM); cdecl;
  external LIB_CRYPTO name _PU + 'DSA_get0_key';

function DSA_set0_key(d: PDSA; pub_key: PBIGNUM; priv_key: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_set0_key';

function DSA_get0_p(d: PDSA): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_get0_p';

function DSA_get0_q(d: PDSA): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_get0_q';

function DSA_get0_g(d: PDSA): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_get0_g';

function DSA_get0_pub_key(d: PDSA): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_get0_pub_key';

function DSA_get0_priv_key(d: PDSA): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_get0_priv_key';

procedure DSA_clear_flags(d: PDSA; flags: integer); cdecl;
  external LIB_CRYPTO name _PU + 'DSA_clear_flags';

function DSA_test_flags(d: PDSA; flags: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_test_flags';

procedure DSA_set_flags(d: PDSA; flags: integer); cdecl;
  external LIB_CRYPTO name _PU + 'DSA_set_flags';

function DSA_get0_engine(d: PDSA): PENGINE; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_get0_engine';

function DSA_meth_new(name: PUtf8Char; flags: integer): PDSA_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_meth_new';

procedure DSA_meth_free(dsam: PDSA_METHOD); cdecl;
  external LIB_CRYPTO name _PU + 'DSA_meth_free';

function DSA_meth_dup(dsam: PDSA_METHOD): PDSA_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_meth_dup';

function DSA_meth_get0_name(dsam: PDSA_METHOD): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_meth_get0_name';

function DSA_meth_set1_name(dsam: PDSA_METHOD; name: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_meth_set1_name';

function DSA_meth_get_flags(dsam: PDSA_METHOD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_meth_get_flags';

function DSA_meth_set_flags(dsam: PDSA_METHOD; flags: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_meth_set_flags';

function DSA_meth_get0_app_data(dsam: PDSA_METHOD): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_meth_get0_app_data';

function DSA_meth_set0_app_data(dsam: PDSA_METHOD; app_data: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_meth_set0_app_data';

//function DSA_meth_get_sign(p1: PBytep2: Integerp3: PDSAdsam: PDSA_METHOD): integer { TODO : Cannot convert original type "DSA_SIG *(*)(const unsigned char *, int, DSA *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'DSA_meth_get_sign';

function DSA_meth_set_sign(dsam: PDSA_METHOD; sign: DSA_meth_set_sign_sign): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_meth_set_sign';

//function DSA_meth_get_sign_setup(p1: PDSAp2: PBN_CTXp3: PPBIGNUMp4: PPBIGNUMdsam: PDSA_METHOD): integer { TODO : Cannot convert original type "int (*)(DSA *, BN_CTX *, BIGNUM **, BIGNUM **)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'DSA_meth_get_sign_setup';

function DSA_meth_set_sign_setup(dsam: PDSA_METHOD; sign_setup: DSA_meth_set_sign_setup_sign_setup): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_meth_set_sign_setup';

//function DSA_meth_get_verify(p1: PBytep2: Integerp3: PDSA_SIGp4: PDSAdsam: PDSA_METHOD): integer { TODO : Cannot convert original type "int (*)(const unsigned char *, int, DSA_SIG *, DSA *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'DSA_meth_get_verify';

function DSA_meth_set_verify(dsam: PDSA_METHOD; verify: DSA_meth_set_verify_verify): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_meth_set_verify';

//function DSA_meth_get_mod_exp(p1: PDSAp2: PBIGNUMp3: PBIGNUMp4: PBIGNUMp5: PBIGNUMp6: PBIGNUMp7: PBIGNUMp8: PBN_CTXp9: PBN_MONT_CTXdsam: PDSA_METHOD): integer { TODO : Cannot convert original type "int (*)(DSA *, BIGNUM *, const BIGNUM *, const BIGNUM *, const BIGNUM *, const BIGNUM *, const BIGNUM *, BN_CTX *, BN_MONT_CTX *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'DSA_meth_get_mod_exp';

function DSA_meth_set_mod_exp(dsam: PDSA_METHOD; mod_exp: DSA_meth_set_mod_exp_mod_exp): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_meth_set_mod_exp';

//function DSA_meth_get_bn_mod_exp(p1: PDSAp2: PBIGNUMp3: PBIGNUMp4: PBIGNUMp5: PBIGNUMp6: PBN_CTXp7: PBN_MONT_CTXdsam: PDSA_METHOD): integer { TODO : Cannot convert original type "int (*)(DSA *, BIGNUM *, const BIGNUM *, const BIGNUM *, const BIGNUM *, BN_CTX *, BN_MONT_CTX *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'DSA_meth_get_bn_mod_exp';

function DSA_meth_set_bn_mod_exp(dsam: PDSA_METHOD; bn_mod_exp: DSA_meth_set_bn_mod_exp_bn_mod_exp): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_meth_set_bn_mod_exp';

//function DSA_meth_get_init(p1: PDSAdsam: PDSA_METHOD): integer { TODO : Cannot convert original type "int (*)(DSA *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'DSA_meth_get_init';

function DSA_meth_set_init(dsam: PDSA_METHOD; init: DSA_meth_set_init_init): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_meth_set_init';

//function DSA_meth_get_finish(p1: PDSAdsam: PDSA_METHOD): integer { TODO : Cannot convert original type "int (*)(DSA *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'DSA_meth_get_finish';

function DSA_meth_set_finish(dsam: PDSA_METHOD; finish: DSA_meth_set_finish_finish): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_meth_set_finish';

//function DSA_meth_get_paramgen(p1: PDSAp2: Integerp3: PBytep4: Integerp5: PIntegerp6: PCardinalp7: PBN_GENCBdsam: PDSA_METHOD): integer { TODO : Cannot convert original type "int (*)(DSA *, int, const unsigned char *, int, int *, unsigned long *, BN_GENCB *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'DSA_meth_get_paramgen';

function DSA_meth_set_paramgen(dsam: PDSA_METHOD; paramgen: DSA_meth_set_paramgen_paramgen): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_meth_set_paramgen';

//function DSA_meth_get_keygen(p1: PDSAdsam: PDSA_METHOD): integer { TODO : Cannot convert original type "int (*)(DSA *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'DSA_meth_get_keygen';

function DSA_meth_set_keygen(dsam: PDSA_METHOD; keygen: DSA_meth_set_keygen_keygen): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DSA_meth_set_keygen';

function SHA1_Init(c: PSHA_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SHA1_Init';

function SHA1_Update(c: PSHA_CTX; data: pointer; len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SHA1_Update';

function SHA1_Final(md: PByte; c: PSHA_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SHA1_Final';

function SHA1(d: PByte; n: PtrUInt; md: PByte): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'SHA1';

procedure SHA1_Transform(c: PSHA_CTX; data: PByte); cdecl;
  external LIB_CRYPTO name _PU + 'SHA1_Transform';

function SHA224_Init(c: PSHA256_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SHA224_Init';

function SHA224_Update(c: PSHA256_CTX; data: pointer; len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SHA224_Update';

function SHA224_Final(md: PByte; c: PSHA256_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SHA224_Final';

function SHA224(d: PByte; n: PtrUInt; md: PByte): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'SHA224';

function SHA256_Init(c: PSHA256_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SHA256_Init';

function SHA256_Update(c: PSHA256_CTX; data: pointer; len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SHA256_Update';

function SHA256_Final(md: PByte; c: PSHA256_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SHA256_Final';

function SHA256(d: PByte; n: PtrUInt; md: PByte): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'SHA256';

procedure SHA256_Transform(c: PSHA256_CTX; data: PByte); cdecl;
  external LIB_CRYPTO name _PU + 'SHA256_Transform';

function SHA384_Init(c: PSHA512_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SHA384_Init';

function SHA384_Update(c: PSHA512_CTX; data: pointer; len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SHA384_Update';

function SHA384_Final(md: PByte; c: PSHA512_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SHA384_Final';

function SHA384(d: PByte; n: PtrUInt; md: PByte): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'SHA384';

function SHA512_Init(c: PSHA512_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SHA512_Init';

function SHA512_Update(c: PSHA512_CTX; data: pointer; len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SHA512_Update';

function SHA512_Final(md: PByte; c: PSHA512_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SHA512_Final';

function SHA512(d: PByte; n: PtrUInt; md: PByte): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'SHA512';

procedure SHA512_Transform(c: PSHA512_CTX; data: PByte); cdecl;
  external LIB_CRYPTO name _PU + 'SHA512_Transform';

function ERR_load_X509_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_X509_strings';

function OPENSSL_LH_error(lh: POPENSSL_LHASH): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_LH_error';

function OPENSSL_LH_new(h: OPENSSL_LH_HASHFUNC; c: OPENSSL_LH_COMPFUNC): POPENSSL_LHASH; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_LH_new';

procedure OPENSSL_LH_free(lh: POPENSSL_LHASH); cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_LH_free';

function OPENSSL_LH_insert(lh: POPENSSL_LHASH; data: pointer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_LH_insert';

function OPENSSL_LH_delete(lh: POPENSSL_LHASH; data: pointer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_LH_delete';

function OPENSSL_LH_retrieve(lh: POPENSSL_LHASH; data: pointer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_LH_retrieve';

procedure OPENSSL_LH_doall(lh: POPENSSL_LHASH; func: OPENSSL_LH_DOALL_FUNC); cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_LH_doall';

procedure OPENSSL_LH_doall_arg(lh: POPENSSL_LHASH; func: OPENSSL_LH_DOALL_FUNCARG; arg: pointer); cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_LH_doall_arg';

function OPENSSL_LH_strhash(c: PUtf8Char): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_LH_strhash';

function OPENSSL_LH_num_items(lh: POPENSSL_LHASH): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_LH_num_items';

function OPENSSL_LH_get_down_load(lh: POPENSSL_LHASH): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_LH_get_down_load';

procedure OPENSSL_LH_set_down_load(lh: POPENSSL_LHASH; down_load: cardinal); cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_LH_set_down_load';

procedure OPENSSL_LH_stats(lh: POPENSSL_LHASH; fp: PPointer); cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_LH_stats';

procedure OPENSSL_LH_node_stats(lh: POPENSSL_LHASH; fp: PPointer); cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_LH_node_stats';

procedure OPENSSL_LH_node_usage_stats(lh: POPENSSL_LHASH; fp: PPointer); cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_LH_node_usage_stats';

procedure OPENSSL_LH_stats_bio(lh: POPENSSL_LHASH; _out: PBIO); cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_LH_stats_bio';

procedure OPENSSL_LH_node_stats_bio(lh: POPENSSL_LHASH; _out: PBIO); cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_LH_node_stats_bio';

procedure OPENSSL_LH_node_usage_stats_bio(lh: POPENSSL_LHASH; _out: PBIO); cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_LH_node_usage_stats_bio';

function X509_STORE_set_depth(store: PX509_STORE; depth: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_set_depth';

procedure X509_STORE_CTX_set_depth(ctx: PX509_STORE_CTX; depth: integer); cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_set_depth';

function X509_OBJECT_idx_by_subject(h: Pstack_st_X509_OBJECT; typ: X509_LOOKUP_TYPE; name: PX509_NAME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_OBJECT_idx_by_subject';

function X509_OBJECT_retrieve_by_subject(h: Pstack_st_X509_OBJECT; typ: X509_LOOKUP_TYPE; name: PX509_NAME): PX509_OBJECT; cdecl;
  external LIB_CRYPTO name _PU + 'X509_OBJECT_retrieve_by_subject';

function X509_OBJECT_retrieve_match(h: Pstack_st_X509_OBJECT; x: PX509_OBJECT): PX509_OBJECT; cdecl;
  external LIB_CRYPTO name _PU + 'X509_OBJECT_retrieve_match';

function X509_OBJECT_up_ref_count(a: PX509_OBJECT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_OBJECT_up_ref_count';

function X509_OBJECT_new(): PX509_OBJECT; cdecl;
  external LIB_CRYPTO name _PU + 'X509_OBJECT_new';

procedure X509_OBJECT_free(a: PX509_OBJECT); cdecl;
  external LIB_CRYPTO name _PU + 'X509_OBJECT_free';

function X509_OBJECT_get_type(a: PX509_OBJECT): X509_LOOKUP_TYPE; cdecl;
  external LIB_CRYPTO name _PU + 'X509_OBJECT_get_type';

function X509_OBJECT_set1_X509(a: PX509_OBJECT; obj: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_OBJECT_set1_X509';

function X509_OBJECT_set1_X509_CRL(a: PX509_OBJECT; obj: PX509_CRL): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_OBJECT_set1_X509_CRL';

function X509_STORE_CTX_get1_certs(st: PX509_STORE_CTX; nm: PX509_NAME): Pstack_st_X509; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get1_certs';

function X509_STORE_get1_certs(st: PX509_STORE_CTX; nm: PX509_NAME): Pstack_st_X509; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get1_certs';

function X509_STORE_get1_cert(st: PX509_STORE_CTX; nm: PX509_NAME): Pstack_st_X509; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get1_certs';

function X509_STORE_CTX_get1_crls(st: PX509_STORE_CTX; nm: PX509_NAME): Pstack_st_X509_CRL; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get1_crls';

function X509_STORE_get1_crls(st: PX509_STORE_CTX; nm: PX509_NAME): Pstack_st_X509_CRL; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get1_crls';

function X509_STORE_get1_crl(st: PX509_STORE_CTX; nm: PX509_NAME): Pstack_st_X509_CRL; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get1_crls';

function X509_STORE_set_purpose(ctx: PX509_STORE; purpose: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_set_purpose';

function X509_STORE_set_trust(ctx: PX509_STORE; trust: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_set_trust';

procedure X509_STORE_set_verify(ctx: PX509_STORE; verify: X509_STORE_CTX_verify_fn); cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_set_verify';

procedure X509_STORE_CTX_set_verify(ctx: PX509_STORE_CTX; verify: X509_STORE_CTX_verify_fn); cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_set_verify';

function X509_STORE_get_verify(ctx: PX509_STORE): X509_STORE_CTX_verify_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_get_verify';

function X509_STORE_get_verify_cb(ctx: PX509_STORE): X509_STORE_CTX_verify_cb; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_get_verify_cb';

procedure X509_STORE_set_get_issuer(ctx: PX509_STORE; get_issuer: X509_STORE_CTX_get_issuer_fn); cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_set_get_issuer';

function X509_STORE_get_get_issuer(ctx: PX509_STORE): X509_STORE_CTX_get_issuer_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_get_get_issuer';

procedure X509_STORE_set_check_issued(ctx: PX509_STORE; check_issued: X509_STORE_CTX_check_issued_fn); cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_set_check_issued';

function X509_STORE_get_check_issued(ctx: PX509_STORE): X509_STORE_CTX_check_issued_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_get_check_issued';

procedure X509_STORE_set_check_revocation(ctx: PX509_STORE; check_revocation: X509_STORE_CTX_check_revocation_fn); cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_set_check_revocation';

function X509_STORE_get_check_revocation(ctx: PX509_STORE): X509_STORE_CTX_check_revocation_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_get_check_revocation';

procedure X509_STORE_set_get_crl(ctx: PX509_STORE; get_crl: X509_STORE_CTX_get_crl_fn); cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_set_get_crl';

function X509_STORE_get_get_crl(ctx: PX509_STORE): X509_STORE_CTX_get_crl_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_get_get_crl';

procedure X509_STORE_set_check_crl(ctx: PX509_STORE; check_crl: X509_STORE_CTX_check_crl_fn); cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_set_check_crl';

function X509_STORE_get_check_crl(ctx: PX509_STORE): X509_STORE_CTX_check_crl_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_get_check_crl';

procedure X509_STORE_set_cert_crl(ctx: PX509_STORE; cert_crl: X509_STORE_CTX_cert_crl_fn); cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_set_cert_crl';

function X509_STORE_get_cert_crl(ctx: PX509_STORE): X509_STORE_CTX_cert_crl_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_get_cert_crl';

procedure X509_STORE_set_check_policy(ctx: PX509_STORE; check_policy: X509_STORE_CTX_check_policy_fn); cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_set_check_policy';

function X509_STORE_get_check_policy(ctx: PX509_STORE): X509_STORE_CTX_check_policy_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_get_check_policy';

procedure X509_STORE_set_lookup_certs(ctx: PX509_STORE; lookup_certs: X509_STORE_CTX_lookup_certs_fn); cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_set_lookup_certs';

function X509_STORE_get_lookup_certs(ctx: PX509_STORE): X509_STORE_CTX_lookup_certs_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_get_lookup_certs';

procedure X509_STORE_set_lookup_crls(ctx: PX509_STORE; lookup_crls: X509_STORE_CTX_lookup_crls_fn); cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_set_lookup_crls';

function X509_STORE_get_lookup_crls(ctx: PX509_STORE): X509_STORE_CTX_lookup_crls_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_get_lookup_crls';

procedure X509_STORE_set_cleanup(ctx: PX509_STORE; cleanup: X509_STORE_CTX_cleanup_fn); cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_set_cleanup';

function X509_STORE_get_cleanup(ctx: PX509_STORE): X509_STORE_CTX_cleanup_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_get_cleanup';

function X509_STORE_set_ex_data(ctx: PX509_STORE; idx: integer; data: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_set_ex_data';

function X509_STORE_get_ex_data(ctx: PX509_STORE; idx: integer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_get_ex_data';

function X509_STORE_CTX_get1_issuer(issuer: PPX509; ctx: PX509_STORE_CTX; x: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get1_issuer';

procedure X509_STORE_CTX_set0_trusted_stack(ctx: PX509_STORE_CTX; sk: Pstack_st_X509); cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_set0_trusted_stack';

procedure X509_STORE_CTX_trusted_stack(ctx: PX509_STORE_CTX; sk: Pstack_st_X509); cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_set0_trusted_stack';

procedure X509_STORE_CTX_cleanup(ctx: PX509_STORE_CTX); cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_cleanup';

function X509_STORE_CTX_get0_store(ctx: PX509_STORE_CTX): PX509_STORE; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get0_store';

function X509_STORE_CTX_get0_cert(ctx: PX509_STORE_CTX): PX509; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get0_cert';

function X509_STORE_CTX_get0_untrusted(ctx: PX509_STORE_CTX): Pstack_st_X509; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get0_untrusted';

procedure X509_STORE_CTX_set_chain(ctx: PX509_STORE_CTX; sk: Pstack_st_X509); cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_set0_untrusted';

function X509_STORE_CTX_get_verify_cb(ctx: PX509_STORE_CTX): X509_STORE_CTX_verify_cb; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get_verify_cb';

function X509_STORE_CTX_get_verify(ctx: PX509_STORE_CTX): X509_STORE_CTX_verify_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get_verify';

function X509_STORE_CTX_get_get_issuer(ctx: PX509_STORE_CTX): X509_STORE_CTX_get_issuer_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get_get_issuer';

function X509_STORE_CTX_get_check_issued(ctx: PX509_STORE_CTX): X509_STORE_CTX_check_issued_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get_check_issued';

function X509_STORE_CTX_get_check_revocation(ctx: PX509_STORE_CTX): X509_STORE_CTX_check_revocation_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get_check_revocation';

function X509_STORE_CTX_get_get_crl(ctx: PX509_STORE_CTX): X509_STORE_CTX_get_crl_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get_get_crl';

function X509_STORE_CTX_get_check_crl(ctx: PX509_STORE_CTX): X509_STORE_CTX_check_crl_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get_check_crl';

function X509_STORE_CTX_get_cert_crl(ctx: PX509_STORE_CTX): X509_STORE_CTX_cert_crl_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get_cert_crl';

function X509_STORE_CTX_get_check_policy(ctx: PX509_STORE_CTX): X509_STORE_CTX_check_policy_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get_check_policy';

function X509_STORE_CTX_get_lookup_certs(ctx: PX509_STORE_CTX): X509_STORE_CTX_lookup_certs_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get_lookup_certs';

function X509_STORE_CTX_get_lookup_crls(ctx: PX509_STORE_CTX): X509_STORE_CTX_lookup_crls_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get_lookup_crls';

function X509_STORE_CTX_get_cleanup(ctx: PX509_STORE_CTX): X509_STORE_CTX_cleanup_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get_cleanup';

function X509_LOOKUP_meth_new(name: PUtf8Char): PX509_LOOKUP_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_meth_new';

procedure X509_LOOKUP_meth_free(method: PX509_LOOKUP_METHOD); cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_meth_free';

function X509_LOOKUP_meth_set_new_item(method: PX509_LOOKUP_METHOD; new_item: X509_LOOKUP_meth_set_new_item_new_item): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_meth_set_new_item';

//function X509_LOOKUP_meth_get_new_item(ctx: PX509_LOOKUPmethod: PX509_LOOKUP_METHOD): integer { TODO : Cannot convert original type "int (*)(X509_LOOKUP *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'X509_LOOKUP_meth_get_new_item';

function X509_LOOKUP_meth_set_free(method: PX509_LOOKUP_METHOD; free_fn: X509_LOOKUP_meth_set_free_free_fn): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_meth_set_free';

//function X509_LOOKUP_meth_get_free(ctx: PX509_LOOKUPmethod: PX509_LOOKUP_METHOD): integer { TODO : Cannot convert original type "void (*)(X509_LOOKUP *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'X509_LOOKUP_meth_get_free';

function X509_LOOKUP_meth_set_init(method: PX509_LOOKUP_METHOD; init: X509_LOOKUP_meth_set_init_init): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_meth_set_init';

//function X509_LOOKUP_meth_get_init(ctx: PX509_LOOKUPmethod: PX509_LOOKUP_METHOD): integer { TODO : Cannot convert original type "int (*)(X509_LOOKUP *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'X509_LOOKUP_meth_get_init';

function X509_LOOKUP_meth_set_shutdown(method: PX509_LOOKUP_METHOD; shutdown: X509_LOOKUP_meth_set_shutdown_shutdown): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_meth_set_shutdown';

//function X509_LOOKUP_meth_get_shutdown(ctx: PX509_LOOKUPmethod: PX509_LOOKUP_METHOD): integer { TODO : Cannot convert original type "int (*)(X509_LOOKUP *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'X509_LOOKUP_meth_get_shutdown';

function X509_LOOKUP_meth_set_ctrl(method: PX509_LOOKUP_METHOD; ctrl_fn: X509_LOOKUP_ctrl_fn): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_meth_set_ctrl';

function X509_LOOKUP_meth_get_ctrl(method: PX509_LOOKUP_METHOD): X509_LOOKUP_ctrl_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_meth_get_ctrl';

function X509_LOOKUP_meth_set_get_by_subject(method: PX509_LOOKUP_METHOD; fn: X509_LOOKUP_get_by_subject_fn): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_meth_set_get_by_subject';

function X509_LOOKUP_meth_get_get_by_subject(method: PX509_LOOKUP_METHOD): X509_LOOKUP_get_by_subject_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_meth_get_get_by_subject';

function X509_LOOKUP_meth_set_get_by_issuer_serial(method: PX509_LOOKUP_METHOD; fn: X509_LOOKUP_get_by_issuer_serial_fn): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_meth_set_get_by_issuer_serial';

function X509_LOOKUP_meth_get_get_by_issuer_serial(method: PX509_LOOKUP_METHOD): X509_LOOKUP_get_by_issuer_serial_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_meth_get_get_by_issuer_serial';

function X509_LOOKUP_meth_set_get_by_fingerprint(method: PX509_LOOKUP_METHOD; fn: X509_LOOKUP_get_by_fingerprint_fn): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_meth_set_get_by_fingerprint';

function X509_LOOKUP_meth_get_get_by_fingerprint(method: PX509_LOOKUP_METHOD): X509_LOOKUP_get_by_fingerprint_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_meth_get_get_by_fingerprint';

function X509_LOOKUP_meth_set_get_by_alias(method: PX509_LOOKUP_METHOD; fn: X509_LOOKUP_get_by_alias_fn): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_meth_set_get_by_alias';

function X509_LOOKUP_meth_get_get_by_alias(method: PX509_LOOKUP_METHOD): X509_LOOKUP_get_by_alias_fn; cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_meth_get_get_by_alias';

function X509_STORE_CTX_get_by_subject(vs: PX509_STORE_CTX; typ: X509_LOOKUP_TYPE; name: PX509_NAME; ret: PX509_OBJECT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get_by_subject';

function X509_STORE_get_by_subject(vs: PX509_STORE_CTX; typ: X509_LOOKUP_TYPE; name: PX509_NAME; ret: PX509_OBJECT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get_by_subject';

function X509_STORE_CTX_get_obj_by_subject(vs: PX509_STORE_CTX; typ: X509_LOOKUP_TYPE; name: PX509_NAME): PX509_OBJECT; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get_obj_by_subject';

function X509_LOOKUP_new(method: PX509_LOOKUP_METHOD): PX509_LOOKUP; cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_new';

procedure X509_LOOKUP_free(ctx: PX509_LOOKUP); cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_free';

function X509_LOOKUP_init(ctx: PX509_LOOKUP): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_init';

function X509_LOOKUP_by_subject(ctx: PX509_LOOKUP; typ: X509_LOOKUP_TYPE; name: PX509_NAME; ret: PX509_OBJECT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_by_subject';

function X509_LOOKUP_by_issuer_serial(ctx: PX509_LOOKUP; typ: X509_LOOKUP_TYPE; name: PX509_NAME; serial: PASN1_INTEGER; ret: PX509_OBJECT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_by_issuer_serial';

function X509_LOOKUP_by_fingerprint(ctx: PX509_LOOKUP; typ: X509_LOOKUP_TYPE; bytes: PByte; len: integer; ret: PX509_OBJECT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_by_fingerprint';

function X509_LOOKUP_by_alias(ctx: PX509_LOOKUP; typ: X509_LOOKUP_TYPE; str: PUtf8Char; len: integer; ret: PX509_OBJECT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_by_alias';

function X509_LOOKUP_set_method_data(ctx: PX509_LOOKUP; data: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_set_method_data';

function X509_LOOKUP_get_method_data(ctx: PX509_LOOKUP): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_get_method_data';

function X509_LOOKUP_get_store(ctx: PX509_LOOKUP): PX509_STORE; cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_get_store';

function X509_LOOKUP_shutdown(ctx: PX509_LOOKUP): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_LOOKUP_shutdown';

function X509_STORE_CTX_set_ex_data(ctx: PX509_STORE_CTX; idx: integer; data: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_set_ex_data';

function X509_STORE_CTX_get_ex_data(ctx: PX509_STORE_CTX; idx: integer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get_ex_data';

procedure X509_STORE_CTX_set_error(ctx: PX509_STORE_CTX; s: integer); cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_set_error';

function X509_STORE_CTX_get_error_depth(ctx: PX509_STORE_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get_error_depth';

procedure X509_STORE_CTX_set_error_depth(ctx: PX509_STORE_CTX; depth: integer); cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_set_error_depth';

procedure X509_STORE_CTX_set_current_cert(ctx: PX509_STORE_CTX; x: PX509); cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_set_current_cert';

function X509_STORE_CTX_get0_current_issuer(ctx: PX509_STORE_CTX): PX509; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get0_current_issuer';

function X509_STORE_CTX_get0_current_crl(ctx: PX509_STORE_CTX): PX509_CRL; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get0_current_crl';

function X509_STORE_CTX_get0_parent_ctx(ctx: PX509_STORE_CTX): PX509_STORE_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get0_parent_ctx';

function X509_STORE_CTX_get0_chain(ctx: PX509_STORE_CTX): Pstack_st_X509; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get0_chain';

function X509_STORE_CTX_get_chain(ctx: PX509_STORE_CTX): Pstack_st_X509; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get0_chain';

function X509_STORE_CTX_get1_chain(ctx: PX509_STORE_CTX): Pstack_st_X509; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get1_chain';

procedure X509_STORE_CTX_set0_verified_chain(c: PX509_STORE_CTX; sk: Pstack_st_X509); cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_set0_verified_chain';

procedure X509_STORE_CTX_set0_crls(c: PX509_STORE_CTX; sk: Pstack_st_X509_CRL); cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_set0_crls';

function X509_STORE_CTX_purpose_inherit(ctx: PX509_STORE_CTX; def_purpose: integer; purpose: integer; trust: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_purpose_inherit';

procedure X509_STORE_CTX_set_flags(ctx: PX509_STORE_CTX; flags: cardinal); cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_set_flags';

function X509_STORE_CTX_get0_policy_tree(ctx: PX509_STORE_CTX): PX509_POLICY_TREE; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get0_policy_tree';

function X509_STORE_CTX_get_explicit_policy(ctx: PX509_STORE_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get_explicit_policy';

function X509_STORE_CTX_get_num_untrusted(ctx: PX509_STORE_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get_num_untrusted';

function X509_STORE_CTX_get0_param(ctx: PX509_STORE_CTX): PX509_VERIFY_PARAM; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_get0_param';

function X509_STORE_CTX_set_default(ctx: PX509_STORE_CTX; name: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_set_default';

procedure X509_STORE_CTX_set0_dane(ctx: PX509_STORE_CTX; dane: PSSL_DANE); cdecl;
  external LIB_CRYPTO name _PU + 'X509_STORE_CTX_set0_dane';

function X509_VERIFY_PARAM_inherit(_to: PX509_VERIFY_PARAM; from: PX509_VERIFY_PARAM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_inherit';

function X509_VERIFY_PARAM_set1(_to: PX509_VERIFY_PARAM; from: PX509_VERIFY_PARAM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_set1';

function X509_VERIFY_PARAM_set1_name(param: PX509_VERIFY_PARAM; name: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_set1_name';

function X509_VERIFY_PARAM_get_time(param: PX509_VERIFY_PARAM): time_t; cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_get_time';

procedure X509_VERIFY_PARAM_set_time(param: PX509_VERIFY_PARAM; t: time_t); cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_set_time';

function X509_VERIFY_PARAM_add0_policy(param: PX509_VERIFY_PARAM; policy: PASN1_OBJECT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_add0_policy';

function X509_VERIFY_PARAM_set1_policies(param: PX509_VERIFY_PARAM; policies: Pstack_st_ASN1_OBJECT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_set1_policies';

function X509_VERIFY_PARAM_set_inh_flags(param: PX509_VERIFY_PARAM; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_set_inh_flags';

function X509_VERIFY_PARAM_get_inh_flags(param: PX509_VERIFY_PARAM): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_get_inh_flags';

function X509_VERIFY_PARAM_set1_host(param: PX509_VERIFY_PARAM; name: PUtf8Char; namelen: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_set1_host';

function X509_VERIFY_PARAM_add1_host(param: PX509_VERIFY_PARAM; name: PUtf8Char; namelen: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_add1_host';

procedure X509_VERIFY_PARAM_set_hostflags(param: PX509_VERIFY_PARAM; flags: cardinal); cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_set_hostflags';

function X509_VERIFY_PARAM_get_hostflags(param: PX509_VERIFY_PARAM): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_get_hostflags';

function X509_VERIFY_PARAM_get0_peername(p1: PX509_VERIFY_PARAM): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_get0_peername';

procedure X509_VERIFY_PARAM_move_peername(p1: PX509_VERIFY_PARAM; p2: PX509_VERIFY_PARAM); cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_move_peername';

function X509_VERIFY_PARAM_set1_email(param: PX509_VERIFY_PARAM; email: PUtf8Char; emaillen: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_set1_email';

function X509_VERIFY_PARAM_set1_ip(param: PX509_VERIFY_PARAM; ip: PByte; iplen: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_set1_ip';

function X509_VERIFY_PARAM_set1_ip_asc(param: PX509_VERIFY_PARAM; ipasc: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_set1_ip_asc';

function X509_VERIFY_PARAM_get_depth(param: PX509_VERIFY_PARAM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_get_depth';

function X509_VERIFY_PARAM_get_auth_level(param: PX509_VERIFY_PARAM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_get_auth_level';

function X509_VERIFY_PARAM_get0_name(param: PX509_VERIFY_PARAM): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_get0_name';

function X509_VERIFY_PARAM_add0_table(param: PX509_VERIFY_PARAM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_add0_table';

function X509_VERIFY_PARAM_get_count(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_get_count';

function X509_VERIFY_PARAM_get0(id: integer): PX509_VERIFY_PARAM; cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_get0';

function X509_VERIFY_PARAM_lookup(name: PUtf8Char): PX509_VERIFY_PARAM; cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_lookup';

procedure X509_VERIFY_PARAM_table_cleanup(); cdecl;
  external LIB_CRYPTO name _PU + 'X509_VERIFY_PARAM_table_cleanup';

function X509_policy_check(ptree: PPX509_POLICY_TREE; pexplicit_policy: PInteger; certs: Pstack_st_X509; policy_oids: Pstack_st_ASN1_OBJECT; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_policy_check';

procedure X509_policy_tree_free(tree: PX509_POLICY_TREE); cdecl;
  external LIB_CRYPTO name _PU + 'X509_policy_tree_free';

function X509_policy_tree_level_count(tree: PX509_POLICY_TREE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_policy_tree_level_count';

function X509_policy_tree_get0_level(tree: PX509_POLICY_TREE; i: integer): PX509_POLICY_LEVEL; cdecl;
  external LIB_CRYPTO name _PU + 'X509_policy_tree_get0_level';

function X509_policy_tree_get0_policies(tree: PX509_POLICY_TREE): Pstack_st_X509_POLICY_NODE; cdecl;
  external LIB_CRYPTO name _PU + 'X509_policy_tree_get0_policies';

function X509_policy_tree_get0_user_policies(tree: PX509_POLICY_TREE): Pstack_st_X509_POLICY_NODE; cdecl;
  external LIB_CRYPTO name _PU + 'X509_policy_tree_get0_user_policies';

function X509_policy_level_node_count(level: PX509_POLICY_LEVEL): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_policy_level_node_count';

function X509_policy_level_get0_node(level: PX509_POLICY_LEVEL; i: integer): PX509_POLICY_NODE; cdecl;
  external LIB_CRYPTO name _PU + 'X509_policy_level_get0_node';

function X509_policy_node_get0_policy(node: PX509_POLICY_NODE): PASN1_OBJECT; cdecl;
  external LIB_CRYPTO name _PU + 'X509_policy_node_get0_policy';

function X509_policy_node_get0_qualifiers(node: PX509_POLICY_NODE): Pstack_st_POLICYQUALINFO; cdecl;
  external LIB_CRYPTO name _PU + 'X509_policy_node_get0_qualifiers';

function X509_policy_node_get0_parent(node: PX509_POLICY_NODE): PX509_POLICY_NODE; cdecl;
  external LIB_CRYPTO name _PU + 'X509_policy_node_get0_parent';

function ERR_load_PKCS7_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_PKCS7_strings';

function PKCS7_ISSUER_AND_SERIAL_new(): PPKCS7_ISSUER_AND_SERIAL; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_ISSUER_AND_SERIAL_new';

procedure PKCS7_ISSUER_AND_SERIAL_free(a: PPKCS7_ISSUER_AND_SERIAL); cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_ISSUER_AND_SERIAL_free';

function d2i_PKCS7_ISSUER_AND_SERIAL(a: PPPKCS7_ISSUER_AND_SERIAL; _in: PPByte; len: integer): PPKCS7_ISSUER_AND_SERIAL; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PKCS7_ISSUER_AND_SERIAL';

function i2d_PKCS7_ISSUER_AND_SERIAL(a: PPKCS7_ISSUER_AND_SERIAL; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS7_ISSUER_AND_SERIAL';

function PKCS7_ISSUER_AND_SERIAL_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_ISSUER_AND_SERIAL_it';

function PKCS7_ISSUER_AND_SERIAL_digest(data: PPKCS7_ISSUER_AND_SERIAL; typ: PEVP_MD; md: PByte; len: PCardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_ISSUER_AND_SERIAL_digest';

function d2i_PKCS7_fp(fp: PPointer; p7: PPPKCS7): PPKCS7; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PKCS7_fp';

function i2d_PKCS7_fp(fp: PPointer; p7: PPKCS7): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS7_fp';

function PKCS7_dup(p7: PPKCS7): PPKCS7; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_dup';

function d2i_PKCS7_bio(bp: PBIO; p7: PPPKCS7): PPKCS7; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PKCS7_bio';

function i2d_PKCS7_bio(bp: PBIO; p7: PPKCS7): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS7_bio';

function i2d_PKCS7_bio_stream(_out: PBIO; p7: PPKCS7; _in: PBIO; flags: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS7_bio_stream';

function PEM_write_bio_PKCS7_stream(_out: PBIO; p7: PPKCS7; _in: PBIO; flags: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_bio_PKCS7_stream';

function PKCS7_SIGNER_INFO_new(): PPKCS7_SIGNER_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_SIGNER_INFO_new';

procedure PKCS7_SIGNER_INFO_free(a: PPKCS7_SIGNER_INFO); cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_SIGNER_INFO_free';

function d2i_PKCS7_SIGNER_INFO(a: PPPKCS7_SIGNER_INFO; _in: PPByte; len: integer): PPKCS7_SIGNER_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PKCS7_SIGNER_INFO';

function i2d_PKCS7_SIGNER_INFO(a: PPKCS7_SIGNER_INFO; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS7_SIGNER_INFO';

function PKCS7_SIGNER_INFO_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_SIGNER_INFO_it';

function PKCS7_RECIP_INFO_new(): PPKCS7_RECIP_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_RECIP_INFO_new';

procedure PKCS7_RECIP_INFO_free(a: PPKCS7_RECIP_INFO); cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_RECIP_INFO_free';

function d2i_PKCS7_RECIP_INFO(a: PPPKCS7_RECIP_INFO; _in: PPByte; len: integer): PPKCS7_RECIP_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PKCS7_RECIP_INFO';

function i2d_PKCS7_RECIP_INFO(a: PPKCS7_RECIP_INFO; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS7_RECIP_INFO';

function PKCS7_RECIP_INFO_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_RECIP_INFO_it';

function PKCS7_SIGNED_new(): PPKCS7_SIGNED; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_SIGNED_new';

procedure PKCS7_SIGNED_free(a: PPKCS7_SIGNED); cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_SIGNED_free';

function d2i_PKCS7_SIGNED(a: PPPKCS7_SIGNED; _in: PPByte; len: integer): PPKCS7_SIGNED; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PKCS7_SIGNED';

function i2d_PKCS7_SIGNED(a: PPKCS7_SIGNED; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS7_SIGNED';

function PKCS7_SIGNED_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_SIGNED_it';

function PKCS7_ENC_CONTENT_new(): PPKCS7_ENC_CONTENT; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_ENC_CONTENT_new';

procedure PKCS7_ENC_CONTENT_free(a: PPKCS7_ENC_CONTENT); cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_ENC_CONTENT_free';

function d2i_PKCS7_ENC_CONTENT(a: PPPKCS7_ENC_CONTENT; _in: PPByte; len: integer): PPKCS7_ENC_CONTENT; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PKCS7_ENC_CONTENT';

function i2d_PKCS7_ENC_CONTENT(a: PPKCS7_ENC_CONTENT; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS7_ENC_CONTENT';

function PKCS7_ENC_CONTENT_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_ENC_CONTENT_it';

function PKCS7_ENVELOPE_new(): PPKCS7_ENVELOPE; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_ENVELOPE_new';

procedure PKCS7_ENVELOPE_free(a: PPKCS7_ENVELOPE); cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_ENVELOPE_free';

function d2i_PKCS7_ENVELOPE(a: PPPKCS7_ENVELOPE; _in: PPByte; len: integer): PPKCS7_ENVELOPE; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PKCS7_ENVELOPE';

function i2d_PKCS7_ENVELOPE(a: PPKCS7_ENVELOPE; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS7_ENVELOPE';

function PKCS7_ENVELOPE_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_ENVELOPE_it';

function PKCS7_SIGN_ENVELOPE_new(): PPKCS7_SIGN_ENVELOPE; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_SIGN_ENVELOPE_new';

procedure PKCS7_SIGN_ENVELOPE_free(a: PPKCS7_SIGN_ENVELOPE); cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_SIGN_ENVELOPE_free';

function d2i_PKCS7_SIGN_ENVELOPE(a: PPPKCS7_SIGN_ENVELOPE; _in: PPByte; len: integer): PPKCS7_SIGN_ENVELOPE; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PKCS7_SIGN_ENVELOPE';

function i2d_PKCS7_SIGN_ENVELOPE(a: PPKCS7_SIGN_ENVELOPE; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS7_SIGN_ENVELOPE';

function PKCS7_SIGN_ENVELOPE_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_SIGN_ENVELOPE_it';

function PKCS7_DIGEST_new(): PPKCS7_DIGEST; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_DIGEST_new';

procedure PKCS7_DIGEST_free(a: PPKCS7_DIGEST); cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_DIGEST_free';

function d2i_PKCS7_DIGEST(a: PPPKCS7_DIGEST; _in: PPByte; len: integer): PPKCS7_DIGEST; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PKCS7_DIGEST';

function i2d_PKCS7_DIGEST(a: PPKCS7_DIGEST; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS7_DIGEST';

function PKCS7_DIGEST_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_DIGEST_it';

function PKCS7_ENCRYPT_new(): PPKCS7_ENCRYPT; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_ENCRYPT_new';

procedure PKCS7_ENCRYPT_free(a: PPKCS7_ENCRYPT); cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_ENCRYPT_free';

function d2i_PKCS7_ENCRYPT(a: PPPKCS7_ENCRYPT; _in: PPByte; len: integer): PPKCS7_ENCRYPT; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PKCS7_ENCRYPT';

function i2d_PKCS7_ENCRYPT(a: PPKCS7_ENCRYPT; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS7_ENCRYPT';

function PKCS7_ENCRYPT_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_ENCRYPT_it';

function PKCS7_new(): PPKCS7; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_new';

procedure PKCS7_free(a: PPKCS7); cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_free';

function d2i_PKCS7(a: PPPKCS7; _in: PPByte; len: integer): PPKCS7; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PKCS7';

function i2d_PKCS7(a: PPKCS7; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS7';

function PKCS7_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_it';

function PKCS7_ATTR_SIGN_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_ATTR_SIGN_it';

function PKCS7_ATTR_VERIFY_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_ATTR_VERIFY_it';

function i2d_PKCS7_NDEF(a: PPKCS7; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS7_NDEF';

function PKCS7_print_ctx(_out: PBIO; x: PPKCS7; indent: integer; pctx: PASN1_PCTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_print_ctx';

function PKCS7_ctrl(p7: PPKCS7; cmd: integer; larg: integer; parg: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_ctrl';

function PKCS7_set_type(p7: PPKCS7; typ: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_set_type';

function PKCS7_set0_type_other(p7: PPKCS7; typ: integer; other: PASN1_TYPE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_set0_type_other';

function PKCS7_set_content(p7: PPKCS7; p7_data: PPKCS7): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_set_content';

function PKCS7_SIGNER_INFO_set(p7i: PPKCS7_SIGNER_INFO; x509: PX509; pkey: PEVP_PKEY; dgst: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_SIGNER_INFO_set';

function PKCS7_SIGNER_INFO_sign(si: PPKCS7_SIGNER_INFO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_SIGNER_INFO_sign';

function PKCS7_add_signer(p7: PPKCS7; p7i: PPKCS7_SIGNER_INFO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_add_signer';

function PKCS7_add_certificate(p7: PPKCS7; x509: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_add_certificate';

function PKCS7_add_crl(p7: PPKCS7; x509: PX509_CRL): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_add_crl';

function PKCS7_content_new(p7: PPKCS7; nid: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_content_new';

function PKCS7_dataVerify(cert_store: PX509_STORE; ctx: PX509_STORE_CTX; bio: PBIO; p7: PPKCS7; si: PPKCS7_SIGNER_INFO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_dataVerify';

function PKCS7_signatureVerify(bio: PBIO; p7: PPKCS7; si: PPKCS7_SIGNER_INFO; x509: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_signatureVerify';

function PKCS7_dataInit(p7: PPKCS7; bio: PBIO): PBIO; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_dataInit';

function PKCS7_dataFinal(p7: PPKCS7; bio: PBIO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_dataFinal';

function PKCS7_dataDecode(p7: PPKCS7; pkey: PEVP_PKEY; in_bio: PBIO; pcert: PX509): PBIO; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_dataDecode';

function PKCS7_add_signature(p7: PPKCS7; x509: PX509; pkey: PEVP_PKEY; dgst: PEVP_MD): PPKCS7_SIGNER_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_add_signature';

function PKCS7_cert_from_signer_info(p7: PPKCS7; si: PPKCS7_SIGNER_INFO): PX509; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_cert_from_signer_info';

function PKCS7_set_digest(p7: PPKCS7; md: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_set_digest';

function PKCS7_get_signer_info(p7: PPKCS7): Pstack_st_PKCS7_SIGNER_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_get_signer_info';

function PKCS7_add_recipient(p7: PPKCS7; x509: PX509): PPKCS7_RECIP_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_add_recipient';

procedure PKCS7_SIGNER_INFO_get0_algs(si: PPKCS7_SIGNER_INFO; pk: PPEVP_PKEY; pdig: PPX509_ALGOR; psig: PPX509_ALGOR); cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_SIGNER_INFO_get0_algs';

procedure PKCS7_RECIP_INFO_get0_alg(ri: PPKCS7_RECIP_INFO; penc: PPX509_ALGOR); cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_RECIP_INFO_get0_alg';

function PKCS7_add_recipient_info(p7: PPKCS7; ri: PPKCS7_RECIP_INFO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_add_recipient_info';

function PKCS7_RECIP_INFO_set(p7i: PPKCS7_RECIP_INFO; x509: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_RECIP_INFO_set';

function PKCS7_set_cipher(p7: PPKCS7; cipher: PEVP_CIPHER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_set_cipher';

function PKCS7_stream(boundary: PPPByte; p7: PPKCS7): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_stream';

function PKCS7_get_issuer_and_serial(p7: PPKCS7; idx: integer): PPKCS7_ISSUER_AND_SERIAL; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_get_issuer_and_serial';

function PKCS7_digest_from_attributes(sk: Pstack_st_X509_ATTRIBUTE): PASN1_OCTET_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_digest_from_attributes';

function PKCS7_add_signed_attribute(p7si: PPKCS7_SIGNER_INFO; nid: integer; typ: integer; data: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_add_signed_attribute';

function PKCS7_add_attribute(p7si: PPKCS7_SIGNER_INFO; nid: integer; atrtype: integer; value: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_add_attribute';

function PKCS7_get_attribute(si: PPKCS7_SIGNER_INFO; nid: integer): PASN1_TYPE; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_get_attribute';

function PKCS7_get_signed_attribute(si: PPKCS7_SIGNER_INFO; nid: integer): PASN1_TYPE; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_get_signed_attribute';

function PKCS7_set_signed_attributes(p7si: PPKCS7_SIGNER_INFO; sk: Pstack_st_X509_ATTRIBUTE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_set_signed_attributes';

function PKCS7_set_attributes(p7si: PPKCS7_SIGNER_INFO; sk: Pstack_st_X509_ATTRIBUTE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_set_attributes';

function PKCS7_sign(signcert: PX509; pkey: PEVP_PKEY; certs: Pstack_st_X509; data: PBIO; flags: integer): PPKCS7; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_sign';

function PKCS7_sign_add_signer(p7: PPKCS7; signcert: PX509; pkey: PEVP_PKEY; md: PEVP_MD; flags: integer): PPKCS7_SIGNER_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_sign_add_signer';

function PKCS7_final(p7: PPKCS7; data: PBIO; flags: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_final';

function PKCS7_verify(p7: PPKCS7; certs: Pstack_st_X509; store: PX509_STORE; indata: PBIO; _out: PBIO; flags: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_verify';

function PKCS7_get0_signers(p7: PPKCS7; certs: Pstack_st_X509; flags: integer): Pstack_st_X509; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_get0_signers';

function PKCS7_encrypt(certs: Pstack_st_X509; _in: PBIO; cipher: PEVP_CIPHER; flags: integer): PPKCS7; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_encrypt';

function PKCS7_decrypt(p7: PPKCS7; pkey: PEVP_PKEY; cert: PX509; data: PBIO; flags: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_decrypt';

function PKCS7_add_attrib_smimecap(si: PPKCS7_SIGNER_INFO; cap: Pstack_st_X509_ALGOR): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_add_attrib_smimecap';

function PKCS7_get_smimecap(si: PPKCS7_SIGNER_INFO): Pstack_st_X509_ALGOR; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_get_smimecap';

function PKCS7_simple_smimecap(sk: Pstack_st_X509_ALGOR; nid: integer; arg: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_simple_smimecap';

function PKCS7_add_attrib_content_type(si: PPKCS7_SIGNER_INFO; coid: PASN1_OBJECT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_add_attrib_content_type';

function PKCS7_add0_attrib_signing_time(si: PPKCS7_SIGNER_INFO; t: PASN1_TIME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_add0_attrib_signing_time';

function PKCS7_add1_attrib_digest(si: PPKCS7_SIGNER_INFO; md: PByte; mdlen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_add1_attrib_digest';

function SMIME_write_PKCS7(bio: PBIO; p7: PPKCS7; data: PBIO; flags: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SMIME_write_PKCS7';

function SMIME_read_PKCS7(bio: PBIO; bcont: PPBIO): PPKCS7; cdecl;
  external LIB_CRYPTO name _PU + 'SMIME_read_PKCS7';

function BIO_new_PKCS7(_out: PBIO; p7: PPKCS7): PBIO; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_new_PKCS7';

procedure X509_CRL_set_default_method(meth: PX509_CRL_METHOD); cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_set_default_method';

function X509_CRL_METHOD_new(crl_init: X509_CRL_METHOD_new_crl_init; crl_free: X509_CRL_METHOD_new_crl_free; crl_lookup: X509_CRL_METHOD_new_crl_lookup; crl_verify: X509_CRL_METHOD_new_crl_verify): PX509_CRL_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_METHOD_new';

procedure X509_CRL_METHOD_free(m: PX509_CRL_METHOD); cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_METHOD_free';

procedure X509_CRL_set_meth_data(crl: PX509_CRL; dat: pointer); cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_set_meth_data';

function X509_CRL_get_meth_data(crl: PX509_CRL): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_get_meth_data';

function NETSCAPE_SPKI_verify(a: PNETSCAPE_SPKI; r: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'NETSCAPE_SPKI_verify';

function NETSCAPE_SPKI_b64_decode(str: PUtf8Char; len: integer): PNETSCAPE_SPKI; cdecl;
  external LIB_CRYPTO name _PU + 'NETSCAPE_SPKI_b64_decode';

function NETSCAPE_SPKI_b64_encode(x: PNETSCAPE_SPKI): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'NETSCAPE_SPKI_b64_encode';

function NETSCAPE_SPKI_get_pubkey(x: PNETSCAPE_SPKI): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'NETSCAPE_SPKI_get_pubkey';

function NETSCAPE_SPKI_set_pubkey(x: PNETSCAPE_SPKI; pkey: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'NETSCAPE_SPKI_set_pubkey';

function NETSCAPE_SPKI_print(_out: PBIO; spki: PNETSCAPE_SPKI): integer; cdecl;
  external LIB_CRYPTO name _PU + 'NETSCAPE_SPKI_print';

function X509_signature_dump(bp: PBIO; sig: PASN1_STRING; indent: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_signature_dump';

function X509_signature_print(bp: PBIO; alg: PX509_ALGOR; sig: PASN1_STRING): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_signature_print';

function X509_sign_ctx(x: PX509; ctx: PEVP_MD_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_sign_ctx';

function X509_http_nbio(rctx: POCSP_REQ_CTX; pcert: PPX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_http_nbio';

function X509_REQ_sign_ctx(x: PX509_REQ; ctx: PEVP_MD_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_sign_ctx';

function X509_CRL_sign_ctx(x: PX509_CRL; ctx: PEVP_MD_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_sign_ctx';

function X509_CRL_http_nbio(rctx: POCSP_REQ_CTX; pcrl: PPX509_CRL): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_http_nbio';

function NETSCAPE_SPKI_sign(x: PNETSCAPE_SPKI; pkey: PEVP_PKEY; md: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'NETSCAPE_SPKI_sign';

function X509_pubkey_digest(data: PX509; typ: PEVP_MD; md: PByte; len: PCardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_pubkey_digest';

function X509_CRL_digest(data: PX509_CRL; typ: PEVP_MD; md: PByte; len: PCardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_digest';

function X509_REQ_digest(data: PX509_REQ; typ: PEVP_MD; md: PByte; len: PCardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_digest';

function X509_NAME_digest(data: PX509_NAME; typ: PEVP_MD; md: PByte; len: PCardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_NAME_digest';

function d2i_X509_fp(fp: PPointer; x509: PPX509): PX509; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_X509_fp';

function i2d_X509_fp(fp: PPointer; x509: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_X509_fp';

function d2i_X509_REQ_fp(fp: PPointer; req: PPX509_REQ): PX509_REQ; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_X509_REQ_fp';

function i2d_X509_REQ_fp(fp: PPointer; req: PX509_REQ): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_X509_REQ_fp';

function d2i_RSAPrivateKey_fp(fp: PPointer; rsa: PPRSA): PRSA; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_RSAPrivateKey_fp';

function i2d_RSAPrivateKey_fp(fp: PPointer; rsa: PRSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_RSAPrivateKey_fp';

function d2i_RSAPublicKey_fp(fp: PPointer; rsa: PPRSA): PRSA; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_RSAPublicKey_fp';

function i2d_RSAPublicKey_fp(fp: PPointer; rsa: PRSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_RSAPublicKey_fp';

function d2i_RSA_PUBKEY_fp(fp: PPointer; rsa: PPRSA): PRSA; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_RSA_PUBKEY_fp';

function i2d_RSA_PUBKEY_fp(fp: PPointer; rsa: PRSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_RSA_PUBKEY_fp';

function d2i_DSA_PUBKEY_fp(fp: PPointer; dsa: PPDSA): PDSA; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_DSA_PUBKEY_fp';

function i2d_DSA_PUBKEY_fp(fp: PPointer; dsa: PDSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_DSA_PUBKEY_fp';

function d2i_DSAPrivateKey_fp(fp: PPointer; dsa: PPDSA): PDSA; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_DSAPrivateKey_fp';

function i2d_DSAPrivateKey_fp(fp: PPointer; dsa: PDSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_DSAPrivateKey_fp';

function d2i_EC_PUBKEY_fp(fp: PPointer; eckey: PPEC_KEY): PEC_KEY; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_EC_PUBKEY_fp';

function i2d_EC_PUBKEY_fp(fp: PPointer; eckey: PEC_KEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_EC_PUBKEY_fp';

function d2i_ECPrivateKey_fp(fp: PPointer; eckey: PPEC_KEY): PEC_KEY; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ECPrivateKey_fp';

function i2d_ECPrivateKey_fp(fp: PPointer; eckey: PEC_KEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ECPrivateKey_fp';

function d2i_PKCS8_fp(fp: PPointer; p8: PPX509_SIG): PX509_SIG; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PKCS8_fp';

function i2d_PKCS8_fp(fp: PPointer; p8: PX509_SIG): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS8_fp';

function d2i_PKCS8_PRIV_KEY_INFO_fp(fp: PPointer; p8inf: PPPKCS8_PRIV_KEY_INFO): PPKCS8_PRIV_KEY_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PKCS8_PRIV_KEY_INFO_fp';

function i2d_PKCS8_PRIV_KEY_INFO_fp(fp: PPointer; p8inf: PPKCS8_PRIV_KEY_INFO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS8_PRIV_KEY_INFO_fp';

function i2d_PKCS8PrivateKeyInfo_fp(fp: PPointer; key: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS8PrivateKeyInfo_fp';

function i2d_PrivateKey_fp(fp: PPointer; pkey: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PrivateKey_fp';

function d2i_PrivateKey_fp(fp: PPointer; a: PPEVP_PKEY): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PrivateKey_fp';

function i2d_PUBKEY_fp(fp: PPointer; pkey: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PUBKEY_fp';

function d2i_PUBKEY_fp(fp: PPointer; a: PPEVP_PKEY): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PUBKEY_fp';

function d2i_RSAPrivateKey_bio(bp: PBIO; rsa: PPRSA): PRSA; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_RSAPrivateKey_bio';

function i2d_RSAPrivateKey_bio(bp: PBIO; rsa: PRSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_RSAPrivateKey_bio';

function d2i_RSAPublicKey_bio(bp: PBIO; rsa: PPRSA): PRSA; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_RSAPublicKey_bio';

function i2d_RSAPublicKey_bio(bp: PBIO; rsa: PRSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_RSAPublicKey_bio';

function d2i_RSA_PUBKEY_bio(bp: PBIO; rsa: PPRSA): PRSA; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_RSA_PUBKEY_bio';

function i2d_RSA_PUBKEY_bio(bp: PBIO; rsa: PRSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_RSA_PUBKEY_bio';

function d2i_DSA_PUBKEY_bio(bp: PBIO; dsa: PPDSA): PDSA; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_DSA_PUBKEY_bio';

function i2d_DSA_PUBKEY_bio(bp: PBIO; dsa: PDSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_DSA_PUBKEY_bio';

function d2i_DSAPrivateKey_bio(bp: PBIO; dsa: PPDSA): PDSA; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_DSAPrivateKey_bio';

function i2d_DSAPrivateKey_bio(bp: PBIO; dsa: PDSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_DSAPrivateKey_bio';

function d2i_EC_PUBKEY_bio(bp: PBIO; eckey: PPEC_KEY): PEC_KEY; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_EC_PUBKEY_bio';

function i2d_EC_PUBKEY_bio(bp: PBIO; eckey: PEC_KEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_EC_PUBKEY_bio';

function d2i_ECPrivateKey_bio(bp: PBIO; eckey: PPEC_KEY): PEC_KEY; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ECPrivateKey_bio';

function i2d_ECPrivateKey_bio(bp: PBIO; eckey: PEC_KEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ECPrivateKey_bio';

function d2i_PKCS8_bio(bp: PBIO; p8: PPX509_SIG): PX509_SIG; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PKCS8_bio';

function i2d_PKCS8_bio(bp: PBIO; p8: PX509_SIG): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS8_bio';

function d2i_PKCS8_PRIV_KEY_INFO_bio(bp: PBIO; p8inf: PPPKCS8_PRIV_KEY_INFO): PPKCS8_PRIV_KEY_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PKCS8_PRIV_KEY_INFO_bio';

function i2d_PKCS8_PRIV_KEY_INFO_bio(bp: PBIO; p8inf: PPKCS8_PRIV_KEY_INFO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS8_PRIV_KEY_INFO_bio';

function i2d_PKCS8PrivateKeyInfo_bio(bp: PBIO; key: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS8PrivateKeyInfo_bio';

function X509_dup(x509: PX509): PX509; cdecl;
  external LIB_CRYPTO name _PU + 'X509_dup';

function X509_ATTRIBUTE_dup(xa: PX509_ATTRIBUTE): PX509_ATTRIBUTE; cdecl;
  external LIB_CRYPTO name _PU + 'X509_ATTRIBUTE_dup';

function X509_EXTENSION_dup(ex: PX509_EXTENSION): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'X509_EXTENSION_dup';

function X509_REVOKED_dup(rev: PX509_REVOKED): PX509_REVOKED; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REVOKED_dup';

function X509_REQ_dup(req: PX509_REQ): PX509_REQ; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_dup';

function X509_ALGOR_dup(xn: PX509_ALGOR): PX509_ALGOR; cdecl;
  external LIB_CRYPTO name _PU + 'X509_ALGOR_dup';

function X509_ALGOR_set0(alg: PX509_ALGOR; aobj: PASN1_OBJECT; ptype: integer; pval: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_ALGOR_set0';

procedure X509_ALGOR_get0(paobj: PPASN1_OBJECT; pptype: PInteger; ppval: PPointer; algor: PX509_ALGOR); cdecl;
  external LIB_CRYPTO name _PU + 'X509_ALGOR_get0';

procedure X509_ALGOR_set_md(alg: PX509_ALGOR; md: PEVP_MD); cdecl;
  external LIB_CRYPTO name _PU + 'X509_ALGOR_set_md';

function X509_ALGOR_cmp(a: PX509_ALGOR; b: PX509_ALGOR): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_ALGOR_cmp';

function X509_NAME_dup(xn: PX509_NAME): PX509_NAME; cdecl;
  external LIB_CRYPTO name _PU + 'X509_NAME_dup';

function X509_NAME_ENTRY_dup(ne: PX509_NAME_ENTRY): PX509_NAME_ENTRY; cdecl;
  external LIB_CRYPTO name _PU + 'X509_NAME_ENTRY_dup';

function X509_cmp_time(s: PASN1_TIME; t: ptime_t): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_cmp_time';

function X509_cmp_current_time(s: PASN1_TIME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_cmp_current_time';

function X509_time_adj(s: PASN1_TIME; adj: integer; t: ptime_t): PASN1_TIME; cdecl;
  external LIB_CRYPTO name _PU + 'X509_time_adj';

function X509_time_adj_ex(s: PASN1_TIME; offset_day: integer; offset_sec: integer; t: ptime_t): PASN1_TIME; cdecl;
  external LIB_CRYPTO name _PU + 'X509_time_adj_ex';

function X509_gmtime_adj(s: PASN1_TIME; adj: integer): PASN1_TIME; cdecl;
  external LIB_CRYPTO name _PU + 'X509_gmtime_adj';

function X509_get_default_cert_area(): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get_default_cert_area';

function X509_get_default_cert_dir(): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get_default_cert_dir';

function X509_get_default_cert_file(): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get_default_cert_file';

function X509_get_default_cert_dir_env(): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get_default_cert_dir_env';

function X509_get_default_cert_file_env(): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get_default_cert_file_env';

function X509_get_default_private_dir(): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get_default_private_dir';

function X509_to_X509_REQ(x: PX509; pkey: PEVP_PKEY; md: PEVP_MD): PX509_REQ; cdecl;
  external LIB_CRYPTO name _PU + 'X509_to_X509_REQ';

function X509_REQ_to_X509(r: PX509_REQ; days: integer; pkey: PEVP_PKEY): PX509; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_to_X509';

function X509_ALGOR_new(): PX509_ALGOR; cdecl;
  external LIB_CRYPTO name _PU + 'X509_ALGOR_new';

procedure X509_ALGOR_free(a: PX509_ALGOR); cdecl;
  external LIB_CRYPTO name _PU + 'X509_ALGOR_free';

function d2i_X509_ALGOR(a: PPX509_ALGOR; _in: PPByte; len: integer): PX509_ALGOR; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_X509_ALGOR';

function i2d_X509_ALGOR(a: PX509_ALGOR; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_X509_ALGOR';

function X509_ALGOR_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'X509_ALGOR_it';

function d2i_X509_ALGORS(a: PPX509_ALGORS; _in: PPByte; len: integer): PX509_ALGORS; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_X509_ALGORS';

function i2d_X509_ALGORS(a: PX509_ALGORS; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_X509_ALGORS';

function X509_ALGORS_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'X509_ALGORS_it';

function X509_VAL_new(): PX509_VAL; cdecl;
  external LIB_CRYPTO name _PU + 'X509_VAL_new';

procedure X509_VAL_free(a: PX509_VAL); cdecl;
  external LIB_CRYPTO name _PU + 'X509_VAL_free';

function d2i_X509_VAL(a: PPX509_VAL; _in: PPByte; len: integer): PX509_VAL; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_X509_VAL';

function i2d_X509_VAL(a: PX509_VAL; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_X509_VAL';

function X509_VAL_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'X509_VAL_it';

function X509_PUBKEY_new(): PX509_PUBKEY; cdecl;
  external LIB_CRYPTO name _PU + 'X509_PUBKEY_new';

procedure X509_PUBKEY_free(a: PX509_PUBKEY); cdecl;
  external LIB_CRYPTO name _PU + 'X509_PUBKEY_free';

function d2i_X509_PUBKEY(a: PPX509_PUBKEY; _in: PPByte; len: integer): PX509_PUBKEY; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_X509_PUBKEY';

function i2d_X509_PUBKEY(a: PX509_PUBKEY; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_X509_PUBKEY';

function X509_PUBKEY_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'X509_PUBKEY_it';

function X509_PUBKEY_set(x: PPX509_PUBKEY; pkey: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_PUBKEY_set';

function X509_PUBKEY_get0(key: PX509_PUBKEY): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'X509_PUBKEY_get0';

function X509_PUBKEY_get(key: PX509_PUBKEY): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'X509_PUBKEY_get';

function X509_get_pubkey_parameters(pkey: PEVP_PKEY; chain: Pstack_st_X509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get_pubkey_parameters';

function X509_get_pathlen(x: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get_pathlen';

function i2d_PUBKEY(a: PEVP_PKEY; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PUBKEY';

function d2i_PUBKEY(a: PPEVP_PKEY; pp: PPByte; length: integer): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PUBKEY';

function i2d_RSA_PUBKEY(a: PRSA; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_RSA_PUBKEY';

function d2i_RSA_PUBKEY(a: PPRSA; pp: PPByte; length: integer): PRSA; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_RSA_PUBKEY';

function i2d_DSA_PUBKEY(a: PDSA; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_DSA_PUBKEY';

function d2i_DSA_PUBKEY(a: PPDSA; pp: PPByte; length: integer): PDSA; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_DSA_PUBKEY';

function i2d_EC_PUBKEY(a: PEC_KEY; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_EC_PUBKEY';

function d2i_EC_PUBKEY(a: PPEC_KEY; pp: PPByte; length: integer): PEC_KEY; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_EC_PUBKEY';

function X509_SIG_new(): PX509_SIG; cdecl;
  external LIB_CRYPTO name _PU + 'X509_SIG_new';

procedure X509_SIG_free(a: PX509_SIG); cdecl;
  external LIB_CRYPTO name _PU + 'X509_SIG_free';

function d2i_X509_SIG(a: PPX509_SIG; _in: PPByte; len: integer): PX509_SIG; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_X509_SIG';

function i2d_X509_SIG(a: PX509_SIG; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_X509_SIG';

function X509_SIG_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'X509_SIG_it';

procedure X509_SIG_get0(sig: PX509_SIG; palg: PPX509_ALGOR; pdigest: PPASN1_OCTET_STRING); cdecl;
  external LIB_CRYPTO name _PU + 'X509_SIG_get0';

procedure X509_SIG_getm(sig: PX509_SIG; palg: PPX509_ALGOR; pdigest: PPASN1_OCTET_STRING); cdecl;
  external LIB_CRYPTO name _PU + 'X509_SIG_getm';

function X509_REQ_INFO_new(): PX509_REQ_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_INFO_new';

procedure X509_REQ_INFO_free(a: PX509_REQ_INFO); cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_INFO_free';

function d2i_X509_REQ_INFO(a: PPX509_REQ_INFO; _in: PPByte; len: integer): PX509_REQ_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_X509_REQ_INFO';

function i2d_X509_REQ_INFO(a: PX509_REQ_INFO; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_X509_REQ_INFO';

function X509_REQ_INFO_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_INFO_it';

function d2i_X509_REQ(a: PPX509_REQ; _in: PPByte; len: integer): PX509_REQ; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_X509_REQ';

function i2d_X509_REQ(a: PX509_REQ; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_X509_REQ';

function X509_REQ_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_it';

function X509_ATTRIBUTE_new(): PX509_ATTRIBUTE; cdecl;
  external LIB_CRYPTO name _PU + 'X509_ATTRIBUTE_new';

procedure X509_ATTRIBUTE_free(a: PX509_ATTRIBUTE); cdecl;
  external LIB_CRYPTO name _PU + 'X509_ATTRIBUTE_free';

function d2i_X509_ATTRIBUTE(a: PPX509_ATTRIBUTE; _in: PPByte; len: integer): PX509_ATTRIBUTE; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_X509_ATTRIBUTE';

function i2d_X509_ATTRIBUTE(a: PX509_ATTRIBUTE; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_X509_ATTRIBUTE';

function X509_ATTRIBUTE_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'X509_ATTRIBUTE_it';

function X509_ATTRIBUTE_create(nid: integer; atrtype: integer; value: pointer): PX509_ATTRIBUTE; cdecl;
  external LIB_CRYPTO name _PU + 'X509_ATTRIBUTE_create';

function d2i_X509_EXTENSION(a: PPX509_EXTENSION; _in: PPByte; len: integer): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_X509_EXTENSION';

function i2d_X509_EXTENSION(a: PX509_EXTENSION; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_X509_EXTENSION';

function X509_EXTENSION_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'X509_EXTENSION_it';

function d2i_X509_EXTENSIONS(a: PPX509_EXTENSIONS; _in: PPByte; len: integer): PX509_EXTENSIONS; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_X509_EXTENSIONS';

function i2d_X509_EXTENSIONS(a: PX509_EXTENSIONS; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_X509_EXTENSIONS';

function X509_EXTENSIONS_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'X509_EXTENSIONS_it';

function X509_NAME_ENTRY_new(): PX509_NAME_ENTRY; cdecl;
  external LIB_CRYPTO name _PU + 'X509_NAME_ENTRY_new';

function d2i_X509_NAME_ENTRY(a: PPX509_NAME_ENTRY; _in: PPByte; len: integer): PX509_NAME_ENTRY; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_X509_NAME_ENTRY';

function i2d_X509_NAME_ENTRY(a: PX509_NAME_ENTRY; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_X509_NAME_ENTRY';

function X509_NAME_ENTRY_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'X509_NAME_ENTRY_it';

function X509_NAME_new(): PX509_NAME; cdecl;
  external LIB_CRYPTO name _PU + 'X509_NAME_new';

procedure X509_NAME_free(a: PX509_NAME); cdecl;
  external LIB_CRYPTO name _PU + 'X509_NAME_free';

function X509_NAME_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'X509_NAME_it';

function X509_NAME_set(xn: PPX509_NAME; name: PX509_NAME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_NAME_set';

function X509_CINF_new(): PX509_CINF; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CINF_new';

procedure X509_CINF_free(a: PX509_CINF); cdecl;
  external LIB_CRYPTO name _PU + 'X509_CINF_free';

function d2i_X509_CINF(a: PPX509_CINF; _in: PPByte; len: integer): PX509_CINF; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_X509_CINF';

function i2d_X509_CINF(a: PX509_CINF; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_X509_CINF';

function X509_CINF_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CINF_it';

function d2i_X509(a: PPX509; _in: PPByte; len: integer): PX509; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_X509';

function i2d_X509(a: PX509; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_X509';

function X509_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'X509_it';

function X509_CERT_AUX_new(): PX509_CERT_AUX; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CERT_AUX_new';

procedure X509_CERT_AUX_free(a: PX509_CERT_AUX); cdecl;
  external LIB_CRYPTO name _PU + 'X509_CERT_AUX_free';

function d2i_X509_CERT_AUX(a: PPX509_CERT_AUX; _in: PPByte; len: integer): PX509_CERT_AUX; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_X509_CERT_AUX';

function i2d_X509_CERT_AUX(a: PX509_CERT_AUX; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_X509_CERT_AUX';

function X509_CERT_AUX_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CERT_AUX_it';

function X509_set_ex_data(r: PX509; idx: integer; arg: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_set_ex_data';

function X509_get_ex_data(r: PX509; idx: integer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get_ex_data';

function i2d_X509_AUX(a: PX509; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_X509_AUX';

function d2i_X509_AUX(a: PPX509; pp: PPByte; length: integer): PX509; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_X509_AUX';

function i2d_re_X509_tbs(x: PX509; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_re_X509_tbs';

function X509_SIG_INFO_get(siginf: PX509_SIG_INFO; mdnid: PInteger; pknid: PInteger; secbits: PInteger; flags: PCardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_SIG_INFO_get';

procedure X509_SIG_INFO_set(siginf: PX509_SIG_INFO; mdnid: integer; pknid: integer; secbits: integer; flags: cardinal); cdecl;
  external LIB_CRYPTO name _PU + 'X509_SIG_INFO_set';

procedure X509_get0_signature(psig: PPASN1_BIT_STRING; palg: PPX509_ALGOR; x: PX509); cdecl;
  external LIB_CRYPTO name _PU + 'X509_get0_signature';

function X509_trusted(x: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_trusted';

function X509_alias_set1(x: PX509; name: PByte; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_alias_set1';

function X509_keyid_set1(x: PX509; id: PByte; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_keyid_set1';

function X509_alias_get0(x: PX509; len: PInteger): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'X509_alias_get0';

function X509_keyid_get0(x: PX509; len: PInteger): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'X509_keyid_get0';

//function X509_TRUST_set_default(p1: Integerp2: PX509p3: Integertrust: X509_TRUST_set_default_trust): integer { TODO : Cannot convert original type "int (*)(int, X509 *, int)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'X509_TRUST_set_default';

function X509_TRUST_set(t: PInteger; trust: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_TRUST_set';

function X509_add1_trust_object(x: PX509; obj: PASN1_OBJECT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_add1_trust_object';

function X509_add1_reject_object(x: PX509; obj: PASN1_OBJECT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_add1_reject_object';

procedure X509_trust_clear(x: PX509); cdecl;
  external LIB_CRYPTO name _PU + 'X509_trust_clear';

procedure X509_reject_clear(x: PX509); cdecl;
  external LIB_CRYPTO name _PU + 'X509_reject_clear';

function X509_get0_trust_objects(x: PX509): Pstack_st_ASN1_OBJECT; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get0_trust_objects';

function X509_get0_reject_objects(x: PX509): Pstack_st_ASN1_OBJECT; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get0_reject_objects';

function X509_REVOKED_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REVOKED_it';

function X509_CRL_INFO_new(): PX509_CRL_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_INFO_new';

procedure X509_CRL_INFO_free(a: PX509_CRL_INFO); cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_INFO_free';

function d2i_X509_CRL_INFO(a: PPX509_CRL_INFO; _in: PPByte; len: integer): PX509_CRL_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_X509_CRL_INFO';

function i2d_X509_CRL_INFO(a: PX509_CRL_INFO; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_X509_CRL_INFO';

function X509_CRL_INFO_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_INFO_it';

function d2i_X509_CRL_fp(fp: PPointer; crl: PPX509_CRL): PX509_CRL; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_X509_CRL_fp';

function i2d_X509_CRL_fp(fp: PPointer; crl: PX509_CRL): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_X509_CRL_fp';

function d2i_X509_CRL(a: PPX509_CRL; _in: PPByte; len: integer): PX509_CRL; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_X509_CRL';

function i2d_X509_CRL(a: PX509_CRL; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_X509_CRL';

function X509_CRL_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_it';

function X509_CRL_get0_by_serial(crl: PX509_CRL; ret: PPX509_REVOKED; serial: PASN1_INTEGER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_get0_by_serial';

function X509_CRL_get0_by_cert(crl: PX509_CRL; ret: PPX509_REVOKED; x: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_get0_by_cert';

function X509_PKEY_new(): PX509_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'X509_PKEY_new';

procedure X509_PKEY_free(a: PX509_PKEY); cdecl;
  external LIB_CRYPTO name _PU + 'X509_PKEY_free';

function NETSCAPE_SPKI_new(): PNETSCAPE_SPKI; cdecl;
  external LIB_CRYPTO name _PU + 'NETSCAPE_SPKI_new';

procedure NETSCAPE_SPKI_free(a: PNETSCAPE_SPKI); cdecl;
  external LIB_CRYPTO name _PU + 'NETSCAPE_SPKI_free';

function d2i_NETSCAPE_SPKI(a: PPNETSCAPE_SPKI; _in: PPByte; len: integer): PNETSCAPE_SPKI; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_NETSCAPE_SPKI';

function i2d_NETSCAPE_SPKI(a: PNETSCAPE_SPKI; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_NETSCAPE_SPKI';

function NETSCAPE_SPKI_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'NETSCAPE_SPKI_it';

function NETSCAPE_SPKAC_new(): PNETSCAPE_SPKAC; cdecl;
  external LIB_CRYPTO name _PU + 'NETSCAPE_SPKAC_new';

procedure NETSCAPE_SPKAC_free(a: PNETSCAPE_SPKAC); cdecl;
  external LIB_CRYPTO name _PU + 'NETSCAPE_SPKAC_free';

function d2i_NETSCAPE_SPKAC(a: PPNETSCAPE_SPKAC; _in: PPByte; len: integer): PNETSCAPE_SPKAC; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_NETSCAPE_SPKAC';

function i2d_NETSCAPE_SPKAC(a: PNETSCAPE_SPKAC; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_NETSCAPE_SPKAC';

function NETSCAPE_SPKAC_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'NETSCAPE_SPKAC_it';

function NETSCAPE_CERT_SEQUENCE_new(): PNETSCAPE_CERT_SEQUENCE; cdecl;
  external LIB_CRYPTO name _PU + 'NETSCAPE_CERT_SEQUENCE_new';

procedure NETSCAPE_CERT_SEQUENCE_free(a: PNETSCAPE_CERT_SEQUENCE); cdecl;
  external LIB_CRYPTO name _PU + 'NETSCAPE_CERT_SEQUENCE_free';

function d2i_NETSCAPE_CERT_SEQUENCE(a: PPNETSCAPE_CERT_SEQUENCE; _in: PPByte; len: integer): PNETSCAPE_CERT_SEQUENCE; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_NETSCAPE_CERT_SEQUENCE';

function i2d_NETSCAPE_CERT_SEQUENCE(a: PNETSCAPE_CERT_SEQUENCE; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_NETSCAPE_CERT_SEQUENCE';

function NETSCAPE_CERT_SEQUENCE_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'NETSCAPE_CERT_SEQUENCE_it';

function X509_INFO_new(): PX509_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'X509_INFO_new';

procedure X509_INFO_free(a: PX509_INFO); cdecl;
  external LIB_CRYPTO name _PU + 'X509_INFO_free';

function ASN1_verify(i2d: Pi2d_of_void; algor1: PX509_ALGOR; signature: PASN1_BIT_STRING; data: PUtf8Char; pkey: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_verify';

function ASN1_digest(i2d: Pi2d_of_void; typ: PEVP_MD; data: PUtf8Char; md: PByte; len: PCardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_digest';

function ASN1_sign(i2d: Pi2d_of_void; algor1: PX509_ALGOR; algor2: PX509_ALGOR; signature: PASN1_BIT_STRING; data: PUtf8Char; pkey: PEVP_PKEY; typ: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_sign';

function ASN1_item_digest(it: PASN1_ITEM; typ: PEVP_MD; data: pointer; md: PByte; len: PCardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_item_digest';

function ASN1_item_verify(it: PASN1_ITEM; algor1: PX509_ALGOR; signature: PASN1_BIT_STRING; data: pointer; pkey: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_item_verify';

function ASN1_item_sign(it: PASN1_ITEM; algor1: PX509_ALGOR; algor2: PX509_ALGOR; signature: PASN1_BIT_STRING; data: pointer; pkey: PEVP_PKEY; typ: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_item_sign';

function ASN1_item_sign_ctx(it: PASN1_ITEM; algor1: PX509_ALGOR; algor2: PX509_ALGOR; signature: PASN1_BIT_STRING; asn: pointer; ctx: PEVP_MD_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ASN1_item_sign_ctx';

function X509_get0_serialNumber(x: PX509): PASN1_INTEGER; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get0_serialNumber';

function X509_get_notBefore(x: PX509): PASN1_TIME; cdecl;
  external LIB_CRYPTO name _PU + 'X509_getm_notBefore';

function X509_set1_notBefore(x: PX509; tm: PASN1_TIME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_set1_notBefore';

function X509_set_notBefore(x: PX509; tm: PASN1_TIME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_set1_notBefore';

function X509_get_notAfter(x: PX509): PASN1_TIME; cdecl;
  external LIB_CRYPTO name _PU + 'X509_getm_notAfter';

function X509_set1_notAfter(x: PX509; tm: PASN1_TIME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_set1_notAfter';

function X509_set_notAfter(x: PX509; tm: PASN1_TIME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_set1_notAfter';

function X509_get_signature_type(x: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get_signature_type';

function X509_get_X509_PUBKEY(x: PX509): PX509_PUBKEY; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get_X509_PUBKEY';

function X509_get0_extensions(x: PX509): Pstack_st_X509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get0_extensions';

procedure X509_get0_uids(x: PX509; piuid: PPASN1_BIT_STRING; psuid: PPASN1_BIT_STRING); cdecl;
  external LIB_CRYPTO name _PU + 'X509_get0_uids';

function X509_get0_tbs_sigalg(x: PX509): PX509_ALGOR; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get0_tbs_sigalg';

function X509_get0_pubkey(x: PX509): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get0_pubkey';

function X509_get0_pubkey_bitstr(x: PX509): PASN1_BIT_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get0_pubkey_bitstr';

function X509_certificate_type(x: PX509; pubkey: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_certificate_type';

function X509_REQ_get_version(req: PX509_REQ): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_get_version';

function X509_REQ_set_subject_name(req: PX509_REQ; name: PX509_NAME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_set_subject_name';

procedure X509_REQ_get0_signature(req: PX509_REQ; psig: PPASN1_BIT_STRING; palg: PPX509_ALGOR); cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_get0_signature';

function X509_REQ_get_signature_nid(req: PX509_REQ): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_get_signature_nid';

function i2d_re_X509_REQ_tbs(req: PX509_REQ; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_re_X509_REQ_tbs';

function X509_REQ_set_pubkey(x: PX509_REQ; pkey: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_set_pubkey';

function X509_REQ_get0_pubkey(req: PX509_REQ): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_get0_pubkey';

function X509_REQ_get_X509_PUBKEY(req: PX509_REQ): PX509_PUBKEY; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_get_X509_PUBKEY';

function X509_REQ_extension_nid(nid: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_extension_nid';

function X509_REQ_get_extension_nids(): PInteger; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_get_extension_nids';

procedure X509_REQ_set_extension_nids(nids: PInteger); cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_set_extension_nids';

function X509_REQ_get_extensions(req: PX509_REQ): Pstack_st_X509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_get_extensions';

function X509_REQ_add_extensions_nid(req: PX509_REQ; exts: Pstack_st_X509_EXTENSION; nid: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_add_extensions_nid';

function X509_REQ_add_extensions(req: PX509_REQ; exts: Pstack_st_X509_EXTENSION): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_add_extensions';

function X509_REQ_get_attr_count(req: PX509_REQ): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_get_attr_count';

function X509_REQ_get_attr_by_NID(req: PX509_REQ; nid: integer; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_get_attr_by_NID';

function X509_REQ_get_attr_by_OBJ(req: PX509_REQ; obj: PASN1_OBJECT; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_get_attr_by_OBJ';

function X509_REQ_get_attr(req: PX509_REQ; loc: integer): PX509_ATTRIBUTE; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_get_attr';

function X509_REQ_delete_attr(req: PX509_REQ; loc: integer): PX509_ATTRIBUTE; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_delete_attr';

function X509_REQ_add1_attr(req: PX509_REQ; attr: PX509_ATTRIBUTE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_add1_attr';

function X509_REQ_add1_attr_by_OBJ(req: PX509_REQ; obj: PASN1_OBJECT; typ: integer; bytes: PByte; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_add1_attr_by_OBJ';

function X509_REQ_add1_attr_by_NID(req: PX509_REQ; nid: integer; typ: integer; bytes: PByte; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_add1_attr_by_NID';

function X509_REQ_add1_attr_by_txt(req: PX509_REQ; attrname: PUtf8Char; typ: integer; bytes: PByte; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_add1_attr_by_txt';

function X509_CRL_set1_lastUpdate(x: PX509_CRL; tm: PASN1_TIME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_set1_lastUpdate';

function X509_CRL_set1_nextUpdate(x: PX509_CRL; tm: PASN1_TIME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_set1_nextUpdate';

function X509_CRL_get0_lastUpdate(crl: PX509_CRL): PASN1_TIME; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_get0_lastUpdate';

function X509_CRL_get0_nextUpdate(crl: PX509_CRL): PASN1_TIME; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_get0_nextUpdate';

procedure X509_CRL_get0_signature(crl: PX509_CRL; psig: PPASN1_BIT_STRING; palg: PPX509_ALGOR); cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_get0_signature';

function X509_CRL_get_signature_nid(crl: PX509_CRL): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_get_signature_nid';

function i2d_re_X509_CRL_tbs(req: PX509_CRL; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_re_X509_CRL_tbs';

function X509_REVOKED_get0_extensions(r: PX509_REVOKED): Pstack_st_X509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REVOKED_get0_extensions';

function X509_CRL_diff(base: PX509_CRL; newer: PX509_CRL; skey: PEVP_PKEY; md: PEVP_MD; flags: cardinal): PX509_CRL; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_diff';

function X509_REQ_check_private_key(x509: PX509_REQ; pkey: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_check_private_key';

function X509_chain_check_suiteb(perror_depth: PInteger; x: PX509; chain: Pstack_st_X509; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_chain_check_suiteb';

function X509_CRL_check_suiteb(crl: PX509_CRL; pk: PEVP_PKEY; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_check_suiteb';

function X509_chain_up_ref(chain: Pstack_st_X509): Pstack_st_X509; cdecl;
  external LIB_CRYPTO name _PU + 'X509_chain_up_ref';

function X509_issuer_and_serial_cmp(a: PX509; b: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_issuer_and_serial_cmp';

function X509_issuer_and_serial_hash(a: PX509): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'X509_issuer_and_serial_hash';

function X509_issuer_name_cmp(a: PX509; b: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_issuer_name_cmp';

function X509_issuer_name_hash(a: PX509): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'X509_issuer_name_hash';

function X509_subject_name_cmp(a: PX509; b: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_subject_name_cmp';

function X509_subject_name_hash(x: PX509): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'X509_subject_name_hash';

function X509_issuer_name_hash_old(a: PX509): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'X509_issuer_name_hash_old';

function X509_subject_name_hash_old(x: PX509): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'X509_subject_name_hash_old';

function X509_cmp(a: PX509; b: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_cmp';

function X509_NAME_hash_old(x: PX509_NAME): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'X509_NAME_hash_old';

function X509_CRL_cmp(a: PX509_CRL; b: PX509_CRL): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_cmp';

function X509_CRL_match(a: PX509_CRL; b: PX509_CRL): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_match';

function X509_aux_print(_out: PBIO; x: PX509; indent: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_aux_print';

function X509_print_ex_fp(bp: PPointer; x: PX509; nmflag: cardinal; cflag: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_print_ex_fp';

function X509_CRL_print_fp(bp: PPointer; x: PX509_CRL): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_print_fp';

function X509_REQ_print_fp(bp: PPointer; req: PX509_REQ): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_print_fp';

function X509_NAME_print(bp: PBIO; name: PX509_NAME; obase: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_NAME_print';

function X509_print_ex(bp: PBIO; x: PX509; nmflag: cardinal; cflag: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_print_ex';

function X509_print_fp(bp: PPointer; x: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_print_fp';

function X509_ocspid_print(bp: PBIO; x: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_ocspid_print';

function X509_CRL_print_ex(_out: PBIO; x: PX509_CRL; nmflag: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_print_ex';

function X509_CRL_print(bp: PBIO; x: PX509_CRL): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_print';

function X509_REQ_print_ex(bp: PBIO; x: PX509_REQ; nmflag: cardinal; cflag: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_print_ex';

function X509_REQ_print(bp: PBIO; req: PX509_REQ): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_print';

function X509_NAME_get_text_by_OBJ(name: PX509_NAME; obj: PASN1_OBJECT; buf: PUtf8Char; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_NAME_get_text_by_OBJ';

function X509_NAME_get_index_by_OBJ(name: PX509_NAME; obj: PASN1_OBJECT; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_NAME_get_index_by_OBJ';

function X509_NAME_add_entry(name: PX509_NAME; ne: PX509_NAME_ENTRY; loc: integer; _set: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_NAME_add_entry';

function X509_NAME_add_entry_by_OBJ(name: PX509_NAME; obj: PASN1_OBJECT; typ: integer; bytes: PAnsiChar; len: integer; loc: integer; _set: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_NAME_add_entry_by_OBJ';

function X509_NAME_add_entry_by_NID(name: PX509_NAME; nid: integer; typ: integer; bytes: PAnsiChar; len: integer; loc: integer; _set: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_NAME_add_entry_by_NID';

function X509_NAME_ENTRY_create_by_txt(ne: PPX509_NAME_ENTRY; field: PUtf8Char; typ: integer; bytes: PAnsiChar; len: integer): PX509_NAME_ENTRY; cdecl;
  external LIB_CRYPTO name _PU + 'X509_NAME_ENTRY_create_by_txt';

function X509_NAME_ENTRY_create_by_NID(ne: PPX509_NAME_ENTRY; nid: integer; typ: integer; bytes: PAnsiChar; len: integer): PX509_NAME_ENTRY; cdecl;
  external LIB_CRYPTO name _PU + 'X509_NAME_ENTRY_create_by_NID';

function X509_NAME_add_entry_by_txt(name: PX509_NAME; field: PUtf8Char; typ: integer; bytes: PAnsiChar; len: integer; loc: integer; _set: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_NAME_add_entry_by_txt';

function X509_NAME_ENTRY_create_by_OBJ(ne: PPX509_NAME_ENTRY; obj: PASN1_OBJECT; typ: integer; bytes: PAnsiChar; len: integer): PX509_NAME_ENTRY; cdecl;
  external LIB_CRYPTO name _PU + 'X509_NAME_ENTRY_create_by_OBJ';

function X509_NAME_ENTRY_set_object(ne: PX509_NAME_ENTRY; obj: PASN1_OBJECT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_NAME_ENTRY_set_object';

function X509_NAME_ENTRY_set_data(ne: PX509_NAME_ENTRY; typ: integer; bytes: PAnsiChar; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_NAME_ENTRY_set_data';

function X509_NAME_ENTRY_set(ne: PX509_NAME_ENTRY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_NAME_ENTRY_set';

function X509_NAME_get0_der(nm: PX509_NAME; pder: PPByte; pderlen: PPtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_NAME_get0_der';

function X509v3_get_ext_count(x: Pstack_st_X509_EXTENSION): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_get_ext_count';

function X509v3_get_ext_by_NID(x: Pstack_st_X509_EXTENSION; nid: integer; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_get_ext_by_NID';

function X509v3_get_ext_by_OBJ(x: Pstack_st_X509_EXTENSION; obj: PASN1_OBJECT; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_get_ext_by_OBJ';

function X509v3_get_ext_by_critical(x: Pstack_st_X509_EXTENSION; crit: integer; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_get_ext_by_critical';

function X509v3_get_ext(x: Pstack_st_X509_EXTENSION; loc: integer): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_get_ext';

function X509v3_delete_ext(x: Pstack_st_X509_EXTENSION; loc: integer): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_delete_ext';

function X509v3_add_ext(x: PPstack_st_X509_EXTENSION; ex: PX509_EXTENSION; loc: integer): Pstack_st_X509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_add_ext';

function X509_get_ext_by_OBJ(x: PX509; obj: PASN1_OBJECT; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get_ext_by_OBJ';

function X509_get_ext_by_critical(x: PX509; crit: integer; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get_ext_by_critical';

function X509_get_ext_d2i(x: PX509; nid: integer; crit: PInteger; idx: PInteger): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get_ext_d2i';

function X509_add1_ext_i2d(x: PX509; nid: integer; value: pointer; crit: integer; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_add1_ext_i2d';

function X509_CRL_get_ext_count(x: PX509_CRL): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_get_ext_count';

function X509_CRL_get_ext_by_NID(x: PX509_CRL; nid: integer; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_get_ext_by_NID';

function X509_CRL_get_ext_by_OBJ(x: PX509_CRL; obj: PASN1_OBJECT; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_get_ext_by_OBJ';

function X509_CRL_get_ext_by_critical(x: PX509_CRL; crit: integer; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_get_ext_by_critical';

function X509_CRL_get_ext(x: PX509_CRL; loc: integer): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_get_ext';

function X509_CRL_add_ext(x: PX509_CRL; ex: PX509_EXTENSION; loc: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_CRL_add_ext';

function X509_REVOKED_get_ext_count(x: PX509_REVOKED): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REVOKED_get_ext_count';

function X509_REVOKED_get_ext_by_NID(x: PX509_REVOKED; nid: integer; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REVOKED_get_ext_by_NID';

function X509_REVOKED_get_ext_by_OBJ(x: PX509_REVOKED; obj: PASN1_OBJECT; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REVOKED_get_ext_by_OBJ';

function X509_REVOKED_get_ext_by_critical(x: PX509_REVOKED; crit: integer; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REVOKED_get_ext_by_critical';

function X509_REVOKED_get_ext(x: PX509_REVOKED; loc: integer): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REVOKED_get_ext';

function X509_REVOKED_delete_ext(x: PX509_REVOKED; loc: integer): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REVOKED_delete_ext';

function X509_EXTENSION_create_by_NID(ex: PPX509_EXTENSION; nid: integer; crit: integer; data: PASN1_OCTET_STRING): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'X509_EXTENSION_create_by_NID';

function X509_EXTENSION_create_by_OBJ(ex: PPX509_EXTENSION; obj: PASN1_OBJECT; crit: integer; data: PASN1_OCTET_STRING): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'X509_EXTENSION_create_by_OBJ';

function X509at_get_attr_count(x: Pstack_st_X509_ATTRIBUTE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509at_get_attr_count';

function X509at_get_attr_by_NID(x: Pstack_st_X509_ATTRIBUTE; nid: integer; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509at_get_attr_by_NID';

function X509at_get_attr_by_OBJ(sk: Pstack_st_X509_ATTRIBUTE; obj: PASN1_OBJECT; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509at_get_attr_by_OBJ';

function X509at_get_attr(x: Pstack_st_X509_ATTRIBUTE; loc: integer): PX509_ATTRIBUTE; cdecl;
  external LIB_CRYPTO name _PU + 'X509at_get_attr';

function X509at_delete_attr(x: Pstack_st_X509_ATTRIBUTE; loc: integer): PX509_ATTRIBUTE; cdecl;
  external LIB_CRYPTO name _PU + 'X509at_delete_attr';

function X509at_add1_attr(x: PPstack_st_X509_ATTRIBUTE; attr: PX509_ATTRIBUTE): Pstack_st_X509_ATTRIBUTE; cdecl;
  external LIB_CRYPTO name _PU + 'X509at_add1_attr';

function X509at_add1_attr_by_OBJ(x: PPstack_st_X509_ATTRIBUTE; obj: PASN1_OBJECT; typ: integer; bytes: PByte; len: integer): Pstack_st_X509_ATTRIBUTE; cdecl;
  external LIB_CRYPTO name _PU + 'X509at_add1_attr_by_OBJ';

function X509at_add1_attr_by_NID(x: PPstack_st_X509_ATTRIBUTE; nid: integer; typ: integer; bytes: PByte; len: integer): Pstack_st_X509_ATTRIBUTE; cdecl;
  external LIB_CRYPTO name _PU + 'X509at_add1_attr_by_NID';

function X509at_add1_attr_by_txt(x: PPstack_st_X509_ATTRIBUTE; attrname: PUtf8Char; typ: integer; bytes: PByte; len: integer): Pstack_st_X509_ATTRIBUTE; cdecl;
  external LIB_CRYPTO name _PU + 'X509at_add1_attr_by_txt';

function X509at_get0_data_by_OBJ(x: Pstack_st_X509_ATTRIBUTE; obj: PASN1_OBJECT; lastpos: integer; typ: integer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'X509at_get0_data_by_OBJ';

function X509_ATTRIBUTE_create_by_NID(attr: PPX509_ATTRIBUTE; nid: integer; atrtype: integer; data: pointer; len: integer): PX509_ATTRIBUTE; cdecl;
  external LIB_CRYPTO name _PU + 'X509_ATTRIBUTE_create_by_NID';

function X509_ATTRIBUTE_create_by_OBJ(attr: PPX509_ATTRIBUTE; obj: PASN1_OBJECT; atrtype: integer; data: pointer; len: integer): PX509_ATTRIBUTE; cdecl;
  external LIB_CRYPTO name _PU + 'X509_ATTRIBUTE_create_by_OBJ';

function X509_ATTRIBUTE_create_by_txt(attr: PPX509_ATTRIBUTE; atrname: PUtf8Char; typ: integer; bytes: PByte; len: integer): PX509_ATTRIBUTE; cdecl;
  external LIB_CRYPTO name _PU + 'X509_ATTRIBUTE_create_by_txt';

function X509_ATTRIBUTE_set1_object(attr: PX509_ATTRIBUTE; obj: PASN1_OBJECT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_ATTRIBUTE_set1_object';

function X509_ATTRIBUTE_set1_data(attr: PX509_ATTRIBUTE; attrtype: integer; data: pointer; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_ATTRIBUTE_set1_data';

function X509_ATTRIBUTE_get0_data(attr: PX509_ATTRIBUTE; idx: integer; atrtype: integer; data: pointer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_ATTRIBUTE_get0_data';

function X509_ATTRIBUTE_count(attr: PX509_ATTRIBUTE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_ATTRIBUTE_count';

function X509_ATTRIBUTE_get0_object(attr: PX509_ATTRIBUTE): PASN1_OBJECT; cdecl;
  external LIB_CRYPTO name _PU + 'X509_ATTRIBUTE_get0_object';

function X509_ATTRIBUTE_get0_type(attr: PX509_ATTRIBUTE; idx: integer): PASN1_TYPE; cdecl;
  external LIB_CRYPTO name _PU + 'X509_ATTRIBUTE_get0_type';

function EVP_PKEY_get_attr_count(key: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_get_attr_count';

function EVP_PKEY_get_attr_by_NID(key: PEVP_PKEY; nid: integer; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_get_attr_by_NID';

function EVP_PKEY_get_attr_by_OBJ(key: PEVP_PKEY; obj: PASN1_OBJECT; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_get_attr_by_OBJ';

function EVP_PKEY_get_attr(key: PEVP_PKEY; loc: integer): PX509_ATTRIBUTE; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_get_attr';

function EVP_PKEY_delete_attr(key: PEVP_PKEY; loc: integer): PX509_ATTRIBUTE; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_delete_attr';

function EVP_PKEY_add1_attr(key: PEVP_PKEY; attr: PX509_ATTRIBUTE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_add1_attr';

function EVP_PKEY_add1_attr_by_OBJ(key: PEVP_PKEY; obj: PASN1_OBJECT; typ: integer; bytes: PByte; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_add1_attr_by_OBJ';

function EVP_PKEY_add1_attr_by_NID(key: PEVP_PKEY; nid: integer; typ: integer; bytes: PByte; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_add1_attr_by_NID';

function EVP_PKEY_add1_attr_by_txt(key: PEVP_PKEY; attrname: PUtf8Char; typ: integer; bytes: PByte; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY_add1_attr_by_txt';

function X509_find_by_issuer_and_serial(sk: Pstack_st_X509; name: PX509_NAME; serial: PASN1_INTEGER): PX509; cdecl;
  external LIB_CRYPTO name _PU + 'X509_find_by_issuer_and_serial';

function X509_find_by_subject(sk: Pstack_st_X509; name: PX509_NAME): PX509; cdecl;
  external LIB_CRYPTO name _PU + 'X509_find_by_subject';

function PBEPARAM_new(): PPBEPARAM; cdecl;
  external LIB_CRYPTO name _PU + 'PBEPARAM_new';

procedure PBEPARAM_free(a: PPBEPARAM); cdecl;
  external LIB_CRYPTO name _PU + 'PBEPARAM_free';

function d2i_PBEPARAM(a: PPPBEPARAM; _in: PPByte; len: integer): PPBEPARAM; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PBEPARAM';

function i2d_PBEPARAM(a: PPBEPARAM; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PBEPARAM';

function PBEPARAM_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PBEPARAM_it';

function PBE2PARAM_new(): PPBE2PARAM; cdecl;
  external LIB_CRYPTO name _PU + 'PBE2PARAM_new';

procedure PBE2PARAM_free(a: PPBE2PARAM); cdecl;
  external LIB_CRYPTO name _PU + 'PBE2PARAM_free';

function d2i_PBE2PARAM(a: PPPBE2PARAM; _in: PPByte; len: integer): PPBE2PARAM; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PBE2PARAM';

function i2d_PBE2PARAM(a: PPBE2PARAM; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PBE2PARAM';

function PBE2PARAM_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PBE2PARAM_it';

function PBKDF2PARAM_new(): PPBKDF2PARAM; cdecl;
  external LIB_CRYPTO name _PU + 'PBKDF2PARAM_new';

procedure PBKDF2PARAM_free(a: PPBKDF2PARAM); cdecl;
  external LIB_CRYPTO name _PU + 'PBKDF2PARAM_free';

function d2i_PBKDF2PARAM(a: PPPBKDF2PARAM; _in: PPByte; len: integer): PPBKDF2PARAM; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PBKDF2PARAM';

function i2d_PBKDF2PARAM(a: PPBKDF2PARAM; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PBKDF2PARAM';

function PBKDF2PARAM_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PBKDF2PARAM_it';

function SCRYPT_PARAMS_new(): PSCRYPT_PARAMS; cdecl;
  external LIB_CRYPTO name _PU + 'SCRYPT_PARAMS_new';

procedure SCRYPT_PARAMS_free(a: PSCRYPT_PARAMS); cdecl;
  external LIB_CRYPTO name _PU + 'SCRYPT_PARAMS_free';

function d2i_SCRYPT_PARAMS(a: PPSCRYPT_PARAMS; _in: PPByte; len: integer): PSCRYPT_PARAMS; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_SCRYPT_PARAMS';

function i2d_SCRYPT_PARAMS(a: PSCRYPT_PARAMS; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_SCRYPT_PARAMS';

function SCRYPT_PARAMS_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'SCRYPT_PARAMS_it';

function PKCS5_pbe_set0_algor(algor: PX509_ALGOR; alg: integer; iter: integer; salt: PByte; saltlen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS5_pbe_set0_algor';

function PKCS5_pbe_set(alg: integer; iter: integer; salt: PByte; saltlen: integer): PX509_ALGOR; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS5_pbe_set';

function PKCS5_pbe2_set(cipher: PEVP_CIPHER; iter: integer; salt: PByte; saltlen: integer): PX509_ALGOR; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS5_pbe2_set';

function PKCS5_pbe2_set_iv(cipher: PEVP_CIPHER; iter: integer; salt: PByte; saltlen: integer; aiv: PByte; prf_nid: integer): PX509_ALGOR; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS5_pbe2_set_iv';

function PKCS5_pbe2_set_scrypt(cipher: PEVP_CIPHER; salt: PByte; saltlen: integer; aiv: PByte; N: Qword; r: Qword; p: Qword): PX509_ALGOR; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS5_pbe2_set_scrypt';

function PKCS5_pbkdf2_set(iter: integer; salt: PByte; saltlen: integer; prf_nid: integer; keylen: integer): PX509_ALGOR; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS5_pbkdf2_set';

function PKCS8_PRIV_KEY_INFO_new(): PPKCS8_PRIV_KEY_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS8_PRIV_KEY_INFO_new';

procedure PKCS8_PRIV_KEY_INFO_free(a: PPKCS8_PRIV_KEY_INFO); cdecl;
  external LIB_CRYPTO name _PU + 'PKCS8_PRIV_KEY_INFO_free';

function d2i_PKCS8_PRIV_KEY_INFO(a: PPPKCS8_PRIV_KEY_INFO; _in: PPByte; len: integer): PPKCS8_PRIV_KEY_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PKCS8_PRIV_KEY_INFO';

function i2d_PKCS8_PRIV_KEY_INFO(a: PPKCS8_PRIV_KEY_INFO; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS8_PRIV_KEY_INFO';

function PKCS8_PRIV_KEY_INFO_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS8_PRIV_KEY_INFO_it';

function EVP_PKCS82PKEY(p8: PPKCS8_PRIV_KEY_INFO): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKCS82PKEY';

function EVP_PKEY2PKCS8(pkey: PEVP_PKEY): PPKCS8_PRIV_KEY_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'EVP_PKEY2PKCS8';

function PKCS8_pkey_set0(priv: PPKCS8_PRIV_KEY_INFO; aobj: PASN1_OBJECT; version: integer; ptype: integer; pval: pointer; penc: PByte; penclen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS8_pkey_set0';

function PKCS8_pkey_get0(ppkalg: PPASN1_OBJECT; pk: PPByte; ppklen: PInteger; pa: PPX509_ALGOR; p8: PPKCS8_PRIV_KEY_INFO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS8_pkey_get0';

function PKCS8_pkey_get0_attrs(p8: PPKCS8_PRIV_KEY_INFO): Pstack_st_X509_ATTRIBUTE; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS8_pkey_get0_attrs';

function PKCS8_pkey_add1_attr_by_NID(p8: PPKCS8_PRIV_KEY_INFO; nid: integer; typ: integer; bytes: PByte; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS8_pkey_add1_attr_by_NID';

function X509_PUBKEY_set0_param(pub: PX509_PUBKEY; aobj: PASN1_OBJECT; ptype: integer; pval: pointer; penc: PByte; penclen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_PUBKEY_set0_param';

function X509_PUBKEY_get0_param(ppkalg: PPASN1_OBJECT; pk: PPByte; ppklen: PInteger; pa: PPX509_ALGOR; pub: PX509_PUBKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_PUBKEY_get0_param';

function X509_check_trust(x: PX509; id: integer; flags: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_check_trust';

function X509_TRUST_get_count(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_TRUST_get_count';

function X509_TRUST_get0(idx: integer): PX509_TRUST; cdecl;
  external LIB_CRYPTO name _PU + 'X509_TRUST_get0';

function X509_TRUST_get_by_id(id: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_TRUST_get_by_id';

function X509_TRUST_add(id: integer; flags: integer; ck: X509_TRUST_add_ck; name: PUtf8Char; arg1: integer; arg2: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_TRUST_add';

procedure X509_TRUST_cleanup(); cdecl;
  external LIB_CRYPTO name _PU + 'X509_TRUST_cleanup';

function X509_TRUST_get_flags(xp: PX509_TRUST): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_TRUST_get_flags';

function X509_TRUST_get0_name(xp: PX509_TRUST): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'X509_TRUST_get0_name';

function X509_TRUST_get_trust(xp: PX509_TRUST): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_TRUST_get_trust';

function ERR_load_CONF_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_CONF_strings';

function CONF_set_default_method(meth: PCONF_METHOD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CONF_set_default_method';

procedure CONF_set_nconf(conf: PCONF; hash: Plhash_st_CONF_VALUE); cdecl;
  external LIB_CRYPTO name _PU + 'CONF_set_nconf';

function CONF_load(conf: Plhash_st_CONF_VALUE; _file: PUtf8Char; eline: PInteger): Plhash_st_CONF_VALUE; cdecl;
  external LIB_CRYPTO name _PU + 'CONF_load';

function CONF_load_fp(conf: Plhash_st_CONF_VALUE; fp: PPointer; eline: PInteger): Plhash_st_CONF_VALUE; cdecl;
  external LIB_CRYPTO name _PU + 'CONF_load_fp';

function CONF_load_bio(conf: Plhash_st_CONF_VALUE; bp: PBIO; eline: PInteger): Plhash_st_CONF_VALUE; cdecl;
  external LIB_CRYPTO name _PU + 'CONF_load_bio';

function CONF_get_section(conf: Plhash_st_CONF_VALUE; section: PUtf8Char): Pstack_st_CONF_VALUE; cdecl;
  external LIB_CRYPTO name _PU + 'CONF_get_section';

function CONF_get_string(conf: Plhash_st_CONF_VALUE; group: PUtf8Char; name: PUtf8Char): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'CONF_get_string';

function CONF_get_number(conf: Plhash_st_CONF_VALUE; group: PUtf8Char; name: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CONF_get_number';

procedure CONF_free(conf: Plhash_st_CONF_VALUE); cdecl;
  external LIB_CRYPTO name _PU + 'CONF_free';

function CONF_dump_fp(conf: Plhash_st_CONF_VALUE; _out: PPointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CONF_dump_fp';

function CONF_dump_bio(conf: Plhash_st_CONF_VALUE; _out: PBIO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CONF_dump_bio';

procedure OPENSSL_config(config_name: PUtf8Char); cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_config';

function NCONF_new(meth: PCONF_METHOD): PCONF; cdecl;
  external LIB_CRYPTO name _PU + 'NCONF_new';

function NCONF_default(): PCONF_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'NCONF_default';

function NCONF_WIN32(): PCONF_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'NCONF_WIN32';

procedure NCONF_free(conf: PCONF); cdecl;
  external LIB_CRYPTO name _PU + 'NCONF_free';

procedure NCONF_free_data(conf: PCONF); cdecl;
  external LIB_CRYPTO name _PU + 'NCONF_free_data';

function NCONF_load(conf: PCONF; _file: PUtf8Char; eline: PInteger): integer; cdecl;
  external LIB_CRYPTO name _PU + 'NCONF_load';

function NCONF_load_fp(conf: PCONF; fp: PPointer; eline: PInteger): integer; cdecl;
  external LIB_CRYPTO name _PU + 'NCONF_load_fp';

function NCONF_load_bio(conf: PCONF; bp: PBIO; eline: PInteger): integer; cdecl;
  external LIB_CRYPTO name _PU + 'NCONF_load_bio';

function NCONF_get_section(conf: PCONF; section: PUtf8Char): Pstack_st_CONF_VALUE; cdecl;
  external LIB_CRYPTO name _PU + 'NCONF_get_section';

function NCONF_get_string(conf: PCONF; group: PUtf8Char; name: PUtf8Char): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'NCONF_get_string';

function NCONF_get_number_e(conf: PCONF; group: PUtf8Char; name: PUtf8Char; result: PInteger): integer; cdecl;
  external LIB_CRYPTO name _PU + 'NCONF_get_number_e';

function NCONF_dump_fp(conf: PCONF; _out: PPointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'NCONF_dump_fp';

function NCONF_dump_bio(conf: PCONF; _out: PBIO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'NCONF_dump_bio';

function CONF_modules_load(cnf: PCONF; appname: PUtf8Char; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CONF_modules_load';

function CONF_modules_load_file(filename: PUtf8Char; appname: PUtf8Char; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CONF_modules_load_file';

procedure CONF_modules_unload(all: integer); cdecl;
  external LIB_CRYPTO name _PU + 'CONF_modules_unload';

procedure CONF_modules_finish(); cdecl;
  external LIB_CRYPTO name _PU + 'CONF_modules_finish';

function CONF_module_add(name: PUtf8Char; ifunc: Pconf_init_func; ffunc: Pconf_finish_func): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CONF_module_add';

function CONF_imodule_get_name(md: PCONF_IMODULE): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'CONF_imodule_get_name';

function CONF_imodule_get_value(md: PCONF_IMODULE): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'CONF_imodule_get_value';

function CONF_imodule_get_usr_data(md: PCONF_IMODULE): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'CONF_imodule_get_usr_data';

procedure CONF_imodule_set_usr_data(md: PCONF_IMODULE; usr_data: pointer); cdecl;
  external LIB_CRYPTO name _PU + 'CONF_imodule_set_usr_data';

function CONF_imodule_get_module(md: PCONF_IMODULE): PCONF_MODULE; cdecl;
  external LIB_CRYPTO name _PU + 'CONF_imodule_get_module';

function CONF_imodule_get_flags(md: PCONF_IMODULE): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'CONF_imodule_get_flags';

procedure CONF_imodule_set_flags(md: PCONF_IMODULE; flags: cardinal); cdecl;
  external LIB_CRYPTO name _PU + 'CONF_imodule_set_flags';

function CONF_module_get_usr_data(pmod: PCONF_MODULE): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'CONF_module_get_usr_data';

procedure CONF_module_set_usr_data(pmod: PCONF_MODULE; usr_data: pointer); cdecl;
  external LIB_CRYPTO name _PU + 'CONF_module_set_usr_data';

function CONF_get1_default_config_file(): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'CONF_get1_default_config_file';

function CONF_parse_list(list: PUtf8Char; sep: integer; nospc: integer; list_cb: CONF_parse_list_list_cb; arg: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CONF_parse_list';

procedure OPENSSL_load_builtin_modules(); cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_load_builtin_modules';

function ERR_load_X509V3_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_X509V3_strings';

function PROXY_POLICY_new(): PPROXY_POLICY; cdecl;
  external LIB_CRYPTO name _PU + 'PROXY_POLICY_new';

procedure PROXY_POLICY_free(a: PPROXY_POLICY); cdecl;
  external LIB_CRYPTO name _PU + 'PROXY_POLICY_free';

function d2i_PROXY_POLICY(a: PPPROXY_POLICY; _in: PPByte; len: integer): PPROXY_POLICY; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PROXY_POLICY';

function i2d_PROXY_POLICY(a: PPROXY_POLICY; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PROXY_POLICY';

function PROXY_POLICY_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PROXY_POLICY_it';

function PROXY_CERT_INFO_EXTENSION_new(): PPROXY_CERT_INFO_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'PROXY_CERT_INFO_EXTENSION_new';

procedure PROXY_CERT_INFO_EXTENSION_free(a: PPROXY_CERT_INFO_EXTENSION); cdecl;
  external LIB_CRYPTO name _PU + 'PROXY_CERT_INFO_EXTENSION_free';

function d2i_PROXY_CERT_INFO_EXTENSION(a: PPPROXY_CERT_INFO_EXTENSION; _in: PPByte; len: integer): PPROXY_CERT_INFO_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PROXY_CERT_INFO_EXTENSION';

function i2d_PROXY_CERT_INFO_EXTENSION(a: PPROXY_CERT_INFO_EXTENSION; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PROXY_CERT_INFO_EXTENSION';

function PROXY_CERT_INFO_EXTENSION_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PROXY_CERT_INFO_EXTENSION_it';

function BASIC_CONSTRAINTS_new(): PBASIC_CONSTRAINTS; cdecl;
  external LIB_CRYPTO name _PU + 'BASIC_CONSTRAINTS_new';

function i2d_BASIC_CONSTRAINTS(a: PBASIC_CONSTRAINTS; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_BASIC_CONSTRAINTS';

function BASIC_CONSTRAINTS_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'BASIC_CONSTRAINTS_it';

function SXNET_new(): PSXNET; cdecl;
  external LIB_CRYPTO name _PU + 'SXNET_new';

procedure SXNET_free(a: PSXNET); cdecl;
  external LIB_CRYPTO name _PU + 'SXNET_free';

function d2i_SXNET(a: PPSXNET; _in: PPByte; len: integer): PSXNET; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_SXNET';

function i2d_SXNET(a: PSXNET; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_SXNET';

function SXNET_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'SXNET_it';

function SXNETID_new(): PSXNETID; cdecl;
  external LIB_CRYPTO name _PU + 'SXNETID_new';

procedure SXNETID_free(a: PSXNETID); cdecl;
  external LIB_CRYPTO name _PU + 'SXNETID_free';

function d2i_SXNETID(a: PPSXNETID; _in: PPByte; len: integer): PSXNETID; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_SXNETID';

function i2d_SXNETID(a: PSXNETID; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_SXNETID';

function SXNETID_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'SXNETID_it';

function SXNET_add_id_asc(psx: PPSXNET; zone: PUtf8Char; user: PUtf8Char; userlen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SXNET_add_id_asc';

function SXNET_add_id_ulong(psx: PPSXNET; lzone: cardinal; user: PUtf8Char; userlen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SXNET_add_id_ulong';

function SXNET_add_id_INTEGER(psx: PPSXNET; izone: PASN1_INTEGER; user: PUtf8Char; userlen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SXNET_add_id_INTEGER';

function SXNET_get_id_asc(sx: PSXNET; zone: PUtf8Char): PASN1_OCTET_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'SXNET_get_id_asc';

function SXNET_get_id_ulong(sx: PSXNET; lzone: cardinal): PASN1_OCTET_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'SXNET_get_id_ulong';

function SXNET_get_id_INTEGER(sx: PSXNET; zone: PASN1_INTEGER): PASN1_OCTET_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'SXNET_get_id_INTEGER';

function AUTHORITY_KEYID_new(): PAUTHORITY_KEYID; cdecl;
  external LIB_CRYPTO name _PU + 'AUTHORITY_KEYID_new';

procedure AUTHORITY_KEYID_free(a: PAUTHORITY_KEYID); cdecl;
  external LIB_CRYPTO name _PU + 'AUTHORITY_KEYID_free';

function d2i_AUTHORITY_KEYID(a: PPAUTHORITY_KEYID; _in: PPByte; len: integer): PAUTHORITY_KEYID; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_AUTHORITY_KEYID';

function i2d_AUTHORITY_KEYID(a: PAUTHORITY_KEYID; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_AUTHORITY_KEYID';

function AUTHORITY_KEYID_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'AUTHORITY_KEYID_it';

function PKEY_USAGE_PERIOD_new(): PPKEY_USAGE_PERIOD; cdecl;
  external LIB_CRYPTO name _PU + 'PKEY_USAGE_PERIOD_new';

procedure PKEY_USAGE_PERIOD_free(a: PPKEY_USAGE_PERIOD); cdecl;
  external LIB_CRYPTO name _PU + 'PKEY_USAGE_PERIOD_free';

function d2i_PKEY_USAGE_PERIOD(a: PPPKEY_USAGE_PERIOD; _in: PPByte; len: integer): PPKEY_USAGE_PERIOD; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PKEY_USAGE_PERIOD';

function i2d_PKEY_USAGE_PERIOD(a: PPKEY_USAGE_PERIOD; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKEY_USAGE_PERIOD';

function PKEY_USAGE_PERIOD_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PKEY_USAGE_PERIOD_it';

function GENERAL_NAME_new(): PGENERAL_NAME; cdecl;
  external LIB_CRYPTO name _PU + 'GENERAL_NAME_new';

procedure GENERAL_NAME_free(a: PGENERAL_NAME); cdecl;
  external LIB_CRYPTO name _PU + 'GENERAL_NAME_free';

function d2i_GENERAL_NAME(a: PPGENERAL_NAME; _in: PPByte; len: integer): PGENERAL_NAME; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_GENERAL_NAME';

function i2d_GENERAL_NAME(a: PGENERAL_NAME; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_GENERAL_NAME';

function GENERAL_NAME_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'GENERAL_NAME_it';

function GENERAL_NAME_dup(a: PGENERAL_NAME): PGENERAL_NAME; cdecl;
  external LIB_CRYPTO name _PU + 'GENERAL_NAME_dup';

function GENERAL_NAME_cmp(a: PGENERAL_NAME; b: PGENERAL_NAME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'GENERAL_NAME_cmp';

function v2i_ASN1_BIT_STRING(method: PX509V3_EXT_METHOD; ctx: PX509V3_CTX; nval: Pstack_st_CONF_VALUE): PASN1_BIT_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'v2i_ASN1_BIT_STRING';

function i2v_ASN1_BIT_STRING(method: PX509V3_EXT_METHOD; bits: PASN1_BIT_STRING; extlist: Pstack_st_CONF_VALUE): Pstack_st_CONF_VALUE; cdecl;
  external LIB_CRYPTO name _PU + 'i2v_ASN1_BIT_STRING';

function i2s_ASN1_IA5STRING(method: PX509V3_EXT_METHOD; ia5: PASN1_IA5STRING): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'i2s_ASN1_IA5STRING';

function s2i_ASN1_IA5STRING(method: PX509V3_EXT_METHOD; ctx: PX509V3_CTX; str: PUtf8Char): PASN1_IA5STRING; cdecl;
  external LIB_CRYPTO name _PU + 's2i_ASN1_IA5STRING';

function i2v_GENERAL_NAME(method: PX509V3_EXT_METHOD; gen: PGENERAL_NAME; ret: Pstack_st_CONF_VALUE): Pstack_st_CONF_VALUE; cdecl;
  external LIB_CRYPTO name _PU + 'i2v_GENERAL_NAME';

function GENERAL_NAME_print(_out: PBIO; gen: PGENERAL_NAME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'GENERAL_NAME_print';

function GENERAL_NAMES_new(): PGENERAL_NAMES; cdecl;
  external LIB_CRYPTO name _PU + 'GENERAL_NAMES_new';

procedure GENERAL_NAMES_free(a: PGENERAL_NAMES); cdecl;
  external LIB_CRYPTO name _PU + 'GENERAL_NAMES_free';

function d2i_GENERAL_NAMES(a: PPGENERAL_NAMES; _in: PPByte; len: integer): PGENERAL_NAMES; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_GENERAL_NAMES';

function i2d_GENERAL_NAMES(a: PGENERAL_NAMES; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_GENERAL_NAMES';

function GENERAL_NAMES_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'GENERAL_NAMES_it';

function i2v_GENERAL_NAMES(method: PX509V3_EXT_METHOD; gen: PGENERAL_NAMES; extlist: Pstack_st_CONF_VALUE): Pstack_st_CONF_VALUE; cdecl;
  external LIB_CRYPTO name _PU + 'i2v_GENERAL_NAMES';

function v2i_GENERAL_NAMES(method: PX509V3_EXT_METHOD; ctx: PX509V3_CTX; nval: Pstack_st_CONF_VALUE): PGENERAL_NAMES; cdecl;
  external LIB_CRYPTO name _PU + 'v2i_GENERAL_NAMES';

function OTHERNAME_new(): POTHERNAME; cdecl;
  external LIB_CRYPTO name _PU + 'OTHERNAME_new';

procedure OTHERNAME_free(a: POTHERNAME); cdecl;
  external LIB_CRYPTO name _PU + 'OTHERNAME_free';

function d2i_OTHERNAME(a: PPOTHERNAME; _in: PPByte; len: integer): POTHERNAME; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_OTHERNAME';

function i2d_OTHERNAME(a: POTHERNAME; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_OTHERNAME';

function OTHERNAME_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'OTHERNAME_it';

function EDIPARTYNAME_new(): PEDIPARTYNAME; cdecl;
  external LIB_CRYPTO name _PU + 'EDIPARTYNAME_new';

procedure EDIPARTYNAME_free(a: PEDIPARTYNAME); cdecl;
  external LIB_CRYPTO name _PU + 'EDIPARTYNAME_free';

function d2i_EDIPARTYNAME(a: PPEDIPARTYNAME; _in: PPByte; len: integer): PEDIPARTYNAME; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_EDIPARTYNAME';

function i2d_EDIPARTYNAME(a: PEDIPARTYNAME; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_EDIPARTYNAME';

function EDIPARTYNAME_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'EDIPARTYNAME_it';

function OTHERNAME_cmp(a: POTHERNAME; b: POTHERNAME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OTHERNAME_cmp';

procedure GENERAL_NAME_set0_value(a: PGENERAL_NAME; typ: integer; value: pointer); cdecl;
  external LIB_CRYPTO name _PU + 'GENERAL_NAME_set0_value';

function GENERAL_NAME_get0_value(a: PGENERAL_NAME; ptype: PInteger): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'GENERAL_NAME_get0_value';

function GENERAL_NAME_set0_othername(gen: PGENERAL_NAME; oid: PASN1_OBJECT; value: PASN1_TYPE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'GENERAL_NAME_set0_othername';

function GENERAL_NAME_get0_otherName(gen: PGENERAL_NAME; poid: PPASN1_OBJECT; pvalue: PPASN1_TYPE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'GENERAL_NAME_get0_otherName';

function i2s_ASN1_OCTET_STRING(method: PX509V3_EXT_METHOD; ia5: PASN1_OCTET_STRING): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'i2s_ASN1_OCTET_STRING';

function s2i_ASN1_OCTET_STRING(method: PX509V3_EXT_METHOD; ctx: PX509V3_CTX; str: PUtf8Char): PASN1_OCTET_STRING; cdecl;
  external LIB_CRYPTO name _PU + 's2i_ASN1_OCTET_STRING';

function EXTENDED_KEY_USAGE_new(): PEXTENDED_KEY_USAGE; cdecl;
  external LIB_CRYPTO name _PU + 'EXTENDED_KEY_USAGE_new';

procedure EXTENDED_KEY_USAGE_free(a: PEXTENDED_KEY_USAGE); cdecl;
  external LIB_CRYPTO name _PU + 'EXTENDED_KEY_USAGE_free';

function d2i_EXTENDED_KEY_USAGE(a: PPEXTENDED_KEY_USAGE; _in: PPByte; len: integer): PEXTENDED_KEY_USAGE; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_EXTENDED_KEY_USAGE';

function i2d_EXTENDED_KEY_USAGE(a: PEXTENDED_KEY_USAGE; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_EXTENDED_KEY_USAGE';

function EXTENDED_KEY_USAGE_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'EXTENDED_KEY_USAGE_it';

function i2a_ACCESS_DESCRIPTION(bp: PBIO; a: PACCESS_DESCRIPTION): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2a_ACCESS_DESCRIPTION';

function TLS_FEATURE_new(): PTLS_FEATURE; cdecl;
  external LIB_CRYPTO name _PU + 'TLS_FEATURE_new';

procedure TLS_FEATURE_free(a: PTLS_FEATURE); cdecl;
  external LIB_CRYPTO name _PU + 'TLS_FEATURE_free';

function CERTIFICATEPOLICIES_new(): PCERTIFICATEPOLICIES; cdecl;
  external LIB_CRYPTO name _PU + 'CERTIFICATEPOLICIES_new';

procedure CERTIFICATEPOLICIES_free(a: PCERTIFICATEPOLICIES); cdecl;
  external LIB_CRYPTO name _PU + 'CERTIFICATEPOLICIES_free';

function d2i_CERTIFICATEPOLICIES(a: PPCERTIFICATEPOLICIES; _in: PPByte; len: integer): PCERTIFICATEPOLICIES; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_CERTIFICATEPOLICIES';

function i2d_CERTIFICATEPOLICIES(a: PCERTIFICATEPOLICIES; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_CERTIFICATEPOLICIES';

function CERTIFICATEPOLICIES_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'CERTIFICATEPOLICIES_it';

function POLICYINFO_new(): PPOLICYINFO; cdecl;
  external LIB_CRYPTO name _PU + 'POLICYINFO_new';

procedure POLICYINFO_free(a: PPOLICYINFO); cdecl;
  external LIB_CRYPTO name _PU + 'POLICYINFO_free';

function d2i_POLICYINFO(a: PPPOLICYINFO; _in: PPByte; len: integer): PPOLICYINFO; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_POLICYINFO';

function i2d_POLICYINFO(a: PPOLICYINFO; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_POLICYINFO';

function POLICYINFO_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'POLICYINFO_it';

function POLICYQUALINFO_new(): PPOLICYQUALINFO; cdecl;
  external LIB_CRYPTO name _PU + 'POLICYQUALINFO_new';

procedure POLICYQUALINFO_free(a: PPOLICYQUALINFO); cdecl;
  external LIB_CRYPTO name _PU + 'POLICYQUALINFO_free';

function d2i_POLICYQUALINFO(a: PPPOLICYQUALINFO; _in: PPByte; len: integer): PPOLICYQUALINFO; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_POLICYQUALINFO';

function i2d_POLICYQUALINFO(a: PPOLICYQUALINFO; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_POLICYQUALINFO';

function POLICYQUALINFO_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'POLICYQUALINFO_it';

function USERNOTICE_new(): PUSERNOTICE; cdecl;
  external LIB_CRYPTO name _PU + 'USERNOTICE_new';

procedure USERNOTICE_free(a: PUSERNOTICE); cdecl;
  external LIB_CRYPTO name _PU + 'USERNOTICE_free';

function d2i_USERNOTICE(a: PPUSERNOTICE; _in: PPByte; len: integer): PUSERNOTICE; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_USERNOTICE';

function i2d_USERNOTICE(a: PUSERNOTICE; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_USERNOTICE';

function USERNOTICE_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'USERNOTICE_it';

function NOTICEREF_new(): PNOTICEREF; cdecl;
  external LIB_CRYPTO name _PU + 'NOTICEREF_new';

procedure NOTICEREF_free(a: PNOTICEREF); cdecl;
  external LIB_CRYPTO name _PU + 'NOTICEREF_free';

function d2i_NOTICEREF(a: PPNOTICEREF; _in: PPByte; len: integer): PNOTICEREF; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_NOTICEREF';

function i2d_NOTICEREF(a: PNOTICEREF; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_NOTICEREF';

function NOTICEREF_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'NOTICEREF_it';

function CRL_DIST_POINTS_new(): PCRL_DIST_POINTS; cdecl;
  external LIB_CRYPTO name _PU + 'CRL_DIST_POINTS_new';

procedure CRL_DIST_POINTS_free(a: PCRL_DIST_POINTS); cdecl;
  external LIB_CRYPTO name _PU + 'CRL_DIST_POINTS_free';

function d2i_CRL_DIST_POINTS(a: PPCRL_DIST_POINTS; _in: PPByte; len: integer): PCRL_DIST_POINTS; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_CRL_DIST_POINTS';

function i2d_CRL_DIST_POINTS(a: PCRL_DIST_POINTS; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_CRL_DIST_POINTS';

function CRL_DIST_POINTS_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'CRL_DIST_POINTS_it';

function DIST_POINT_new(): PDIST_POINT; cdecl;
  external LIB_CRYPTO name _PU + 'DIST_POINT_new';

procedure DIST_POINT_free(a: PDIST_POINT); cdecl;
  external LIB_CRYPTO name _PU + 'DIST_POINT_free';

function d2i_DIST_POINT(a: PPDIST_POINT; _in: PPByte; len: integer): PDIST_POINT; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_DIST_POINT';

function i2d_DIST_POINT(a: PDIST_POINT; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_DIST_POINT';

function DIST_POINT_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'DIST_POINT_it';

function DIST_POINT_NAME_new(): PDIST_POINT_NAME; cdecl;
  external LIB_CRYPTO name _PU + 'DIST_POINT_NAME_new';

procedure DIST_POINT_NAME_free(a: PDIST_POINT_NAME); cdecl;
  external LIB_CRYPTO name _PU + 'DIST_POINT_NAME_free';

function d2i_DIST_POINT_NAME(a: PPDIST_POINT_NAME; _in: PPByte; len: integer): PDIST_POINT_NAME; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_DIST_POINT_NAME';

function i2d_DIST_POINT_NAME(a: PDIST_POINT_NAME; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_DIST_POINT_NAME';

function DIST_POINT_NAME_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'DIST_POINT_NAME_it';

function ISSUING_DIST_POINT_new(): PISSUING_DIST_POINT; cdecl;
  external LIB_CRYPTO name _PU + 'ISSUING_DIST_POINT_new';

procedure ISSUING_DIST_POINT_free(a: PISSUING_DIST_POINT); cdecl;
  external LIB_CRYPTO name _PU + 'ISSUING_DIST_POINT_free';

function d2i_ISSUING_DIST_POINT(a: PPISSUING_DIST_POINT; _in: PPByte; len: integer): PISSUING_DIST_POINT; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ISSUING_DIST_POINT';

function i2d_ISSUING_DIST_POINT(a: PISSUING_DIST_POINT; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ISSUING_DIST_POINT';

function ISSUING_DIST_POINT_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ISSUING_DIST_POINT_it';

function DIST_POINT_set_dpname(dpn: PDIST_POINT_NAME; iname: PX509_NAME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DIST_POINT_set_dpname';

function NAME_CONSTRAINTS_check(x: PX509; nc: PNAME_CONSTRAINTS): integer; cdecl;
  external LIB_CRYPTO name _PU + 'NAME_CONSTRAINTS_check';

function NAME_CONSTRAINTS_check_CN(x: PX509; nc: PNAME_CONSTRAINTS): integer; cdecl;
  external LIB_CRYPTO name _PU + 'NAME_CONSTRAINTS_check_CN';

function ACCESS_DESCRIPTION_new(): PACCESS_DESCRIPTION; cdecl;
  external LIB_CRYPTO name _PU + 'ACCESS_DESCRIPTION_new';

procedure ACCESS_DESCRIPTION_free(a: PACCESS_DESCRIPTION); cdecl;
  external LIB_CRYPTO name _PU + 'ACCESS_DESCRIPTION_free';

function d2i_ACCESS_DESCRIPTION(a: PPACCESS_DESCRIPTION; _in: PPByte; len: integer): PACCESS_DESCRIPTION; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ACCESS_DESCRIPTION';

function i2d_ACCESS_DESCRIPTION(a: PACCESS_DESCRIPTION; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ACCESS_DESCRIPTION';

function ACCESS_DESCRIPTION_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ACCESS_DESCRIPTION_it';

function AUTHORITY_INFO_ACCESS_new(): PAUTHORITY_INFO_ACCESS; cdecl;
  external LIB_CRYPTO name _PU + 'AUTHORITY_INFO_ACCESS_new';

procedure AUTHORITY_INFO_ACCESS_free(a: PAUTHORITY_INFO_ACCESS); cdecl;
  external LIB_CRYPTO name _PU + 'AUTHORITY_INFO_ACCESS_free';

function d2i_AUTHORITY_INFO_ACCESS(a: PPAUTHORITY_INFO_ACCESS; _in: PPByte; len: integer): PAUTHORITY_INFO_ACCESS; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_AUTHORITY_INFO_ACCESS';

function i2d_AUTHORITY_INFO_ACCESS(a: PAUTHORITY_INFO_ACCESS; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_AUTHORITY_INFO_ACCESS';

function AUTHORITY_INFO_ACCESS_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'AUTHORITY_INFO_ACCESS_it';

function POLICY_MAPPING_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'POLICY_MAPPING_it';

function POLICY_MAPPING_new(): PPOLICY_MAPPING; cdecl;
  external LIB_CRYPTO name _PU + 'POLICY_MAPPING_new';

procedure POLICY_MAPPING_free(a: PPOLICY_MAPPING); cdecl;
  external LIB_CRYPTO name _PU + 'POLICY_MAPPING_free';

function POLICY_MAPPINGS_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'POLICY_MAPPINGS_it';

function GENERAL_SUBTREE_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'GENERAL_SUBTREE_it';

function GENERAL_SUBTREE_new(): PGENERAL_SUBTREE; cdecl;
  external LIB_CRYPTO name _PU + 'GENERAL_SUBTREE_new';

procedure GENERAL_SUBTREE_free(a: PGENERAL_SUBTREE); cdecl;
  external LIB_CRYPTO name _PU + 'GENERAL_SUBTREE_free';

function NAME_CONSTRAINTS_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'NAME_CONSTRAINTS_it';

function NAME_CONSTRAINTS_new(): PNAME_CONSTRAINTS; cdecl;
  external LIB_CRYPTO name _PU + 'NAME_CONSTRAINTS_new';

procedure NAME_CONSTRAINTS_free(a: PNAME_CONSTRAINTS); cdecl;
  external LIB_CRYPTO name _PU + 'NAME_CONSTRAINTS_free';

function POLICY_CONSTRAINTS_new(): PPOLICY_CONSTRAINTS; cdecl;
  external LIB_CRYPTO name _PU + 'POLICY_CONSTRAINTS_new';

procedure POLICY_CONSTRAINTS_free(a: PPOLICY_CONSTRAINTS); cdecl;
  external LIB_CRYPTO name _PU + 'POLICY_CONSTRAINTS_free';

function POLICY_CONSTRAINTS_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'POLICY_CONSTRAINTS_it';

function a2i_GENERAL_NAME(_out: PGENERAL_NAME; method: PX509V3_EXT_METHOD; ctx: PX509V3_CTX; gen_type: integer; value: PUtf8Char; is_nc: integer): PGENERAL_NAME; cdecl;
  external LIB_CRYPTO name _PU + 'a2i_GENERAL_NAME';

function v2i_GENERAL_NAME(method: PX509V3_EXT_METHOD; ctx: PX509V3_CTX; cnf: PCONF_VALUE): PGENERAL_NAME; cdecl;
  external LIB_CRYPTO name _PU + 'v2i_GENERAL_NAME';

function v2i_GENERAL_NAME_ex(_out: PGENERAL_NAME; method: PX509V3_EXT_METHOD; ctx: PX509V3_CTX; cnf: PCONF_VALUE; is_nc: integer): PGENERAL_NAME; cdecl;
  external LIB_CRYPTO name _PU + 'v2i_GENERAL_NAME_ex';

procedure X509V3_conf_free(val: PCONF_VALUE); cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_conf_free';

function X509V3_EXT_nconf_nid(conf: PCONF; ctx: PX509V3_CTX; ext_nid: integer; value: PUtf8Char): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_EXT_nconf_nid';

function X509V3_EXT_nconf(conf: PCONF; ctx: PX509V3_CTX; name: PUtf8Char; value: PUtf8Char): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_EXT_nconf';

function X509V3_EXT_add_nconf_sk(conf: PCONF; ctx: PX509V3_CTX; section: PUtf8Char; sk: PPstack_st_X509_EXTENSION): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_EXT_add_nconf_sk';

function X509V3_EXT_add_nconf(conf: PCONF; ctx: PX509V3_CTX; section: PUtf8Char; cert: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_EXT_add_nconf';

function X509V3_EXT_REQ_add_nconf(conf: PCONF; ctx: PX509V3_CTX; section: PUtf8Char; req: PX509_REQ): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_EXT_REQ_add_nconf';

function X509V3_EXT_CRL_add_nconf(conf: PCONF; ctx: PX509V3_CTX; section: PUtf8Char; crl: PX509_CRL): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_EXT_CRL_add_nconf';

function X509V3_EXT_conf(conf: Plhash_st_CONF_VALUE; ctx: PX509V3_CTX; name: PUtf8Char; value: PUtf8Char): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_EXT_conf';

function X509V3_EXT_add_conf(conf: Plhash_st_CONF_VALUE; ctx: PX509V3_CTX; section: PUtf8Char; cert: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_EXT_add_conf';

function X509V3_EXT_REQ_add_conf(conf: Plhash_st_CONF_VALUE; ctx: PX509V3_CTX; section: PUtf8Char; req: PX509_REQ): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_EXT_REQ_add_conf';

function X509V3_EXT_CRL_add_conf(conf: Plhash_st_CONF_VALUE; ctx: PX509V3_CTX; section: PUtf8Char; crl: PX509_CRL): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_EXT_CRL_add_conf';

function X509V3_add_value_bool_nf(name: PUtf8Char; asn1_bool: integer; extlist: PPstack_st_CONF_VALUE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_add_value_bool_nf';

function X509V3_get_value_bool(value: PCONF_VALUE; asn1_bool: PInteger): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_get_value_bool';

function X509V3_get_value_int(value: PCONF_VALUE; aint: PPASN1_INTEGER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_get_value_int';

procedure X509V3_set_nconf(ctx: PX509V3_CTX; conf: PCONF); cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_set_nconf';

procedure X509V3_set_conf_lhash(ctx: PX509V3_CTX; lhash: Plhash_st_CONF_VALUE); cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_set_conf_lhash';

function X509V3_get_string(ctx: PX509V3_CTX; name: PUtf8Char; section: PUtf8Char): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_get_string';

function X509V3_get_section(ctx: PX509V3_CTX; section: PUtf8Char): Pstack_st_CONF_VALUE; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_get_section';

procedure X509V3_string_free(ctx: PX509V3_CTX; str: PUtf8Char); cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_string_free';

procedure X509V3_section_free(ctx: PX509V3_CTX; section: Pstack_st_CONF_VALUE); cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_section_free';

function X509V3_add_value(name: PUtf8Char; value: PUtf8Char; extlist: PPstack_st_CONF_VALUE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_add_value';

function X509V3_add_value_uchar(name: PUtf8Char; value: PByte; extlist: PPstack_st_CONF_VALUE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_add_value_uchar';

function X509V3_add_value_bool(name: PUtf8Char; asn1_bool: integer; extlist: PPstack_st_CONF_VALUE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_add_value_bool';

function X509V3_add_value_int(name: PUtf8Char; aint: PASN1_INTEGER; extlist: PPstack_st_CONF_VALUE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_add_value_int';

function i2s_ASN1_INTEGER(meth: PX509V3_EXT_METHOD; aint: PASN1_INTEGER): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'i2s_ASN1_INTEGER';

function s2i_ASN1_INTEGER(meth: PX509V3_EXT_METHOD; value: PUtf8Char): PASN1_INTEGER; cdecl;
  external LIB_CRYPTO name _PU + 's2i_ASN1_INTEGER';

function i2s_ASN1_ENUMERATED(meth: PX509V3_EXT_METHOD; aint: PASN1_ENUMERATED): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'i2s_ASN1_ENUMERATED';

function i2s_ASN1_ENUMERATED_TABLE(meth: PX509V3_EXT_METHOD; aint: PASN1_ENUMERATED): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'i2s_ASN1_ENUMERATED_TABLE';

function X509V3_EXT_add(ext: PX509V3_EXT_METHOD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_EXT_add';

function X509V3_EXT_add_list(extlist: PX509V3_EXT_METHOD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_EXT_add_list';

function X509V3_EXT_add_alias(nid_to: integer; nid_from: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_EXT_add_alias';

procedure X509V3_EXT_cleanup(); cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_EXT_cleanup';

function X509V3_EXT_get(ext: PX509_EXTENSION): PX509V3_EXT_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_EXT_get';

function X509V3_EXT_get_nid(nid: integer): PX509V3_EXT_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_EXT_get_nid';

function X509V3_add_standard_extensions(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_add_standard_extensions';

function X509V3_parse_list(line: PUtf8Char): Pstack_st_CONF_VALUE; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_parse_list';

function X509V3_EXT_d2i(ext: PX509_EXTENSION): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_EXT_d2i';

function X509V3_get_d2i(x: Pstack_st_X509_EXTENSION; nid: integer; crit: PInteger; idx: PInteger): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_get_d2i';

function X509V3_EXT_i2d(ext_nid: integer; crit: integer; ext_struc: pointer): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_EXT_i2d';

function X509V3_add1_i2d(x: PPstack_st_X509_EXTENSION; nid: integer; value: pointer; crit: integer; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_add1_i2d';

procedure X509V3_EXT_val_prn(_out: PBIO; val: Pstack_st_CONF_VALUE; indent: integer; ml: integer); cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_EXT_val_prn';

function X509V3_EXT_print_fp(_out: PPointer; ext: PX509_EXTENSION; flag: integer; indent: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_EXT_print_fp';

function X509V3_extensions_print(_out: PBIO; title: PUtf8Char; exts: Pstack_st_X509_EXTENSION; flag: cardinal; indent: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_extensions_print';

function X509_check_ca(x: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_check_ca';

function X509_check_purpose(x: PX509; id: integer; ca: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_check_purpose';

function X509_supported_extension(ex: PX509_EXTENSION): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_supported_extension';

function X509_PURPOSE_set(p: PInteger; purpose: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_PURPOSE_set';

function X509_check_issued(issuer: PX509; subject: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_check_issued';

function X509_check_akid(issuer: PX509; akid: PAUTHORITY_KEYID): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_check_akid';

procedure X509_set_proxy_flag(x: PX509); cdecl;
  external LIB_CRYPTO name _PU + 'X509_set_proxy_flag';

procedure X509_set_proxy_pathlen(x: PX509; l: integer); cdecl;
  external LIB_CRYPTO name _PU + 'X509_set_proxy_pathlen';

function X509_get_proxy_pathlen(x: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get_proxy_pathlen';

function X509_get0_subject_key_id(x: PX509): PASN1_OCTET_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get0_subject_key_id';

function X509_get0_authority_key_id(x: PX509): PASN1_OCTET_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get0_authority_key_id';

function X509_get0_authority_issuer(x: PX509): PGENERAL_NAMES; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get0_authority_issuer';

function X509_get0_authority_serial(x: PX509): PASN1_INTEGER; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get0_authority_serial';

function X509_PURPOSE_get_count(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_PURPOSE_get_count';

function X509_PURPOSE_get0(idx: integer): PX509_PURPOSE; cdecl;
  external LIB_CRYPTO name _PU + 'X509_PURPOSE_get0';

function X509_PURPOSE_get_by_sname(sname: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_PURPOSE_get_by_sname';

function X509_PURPOSE_get_by_id(id: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_PURPOSE_get_by_id';

function X509_PURPOSE_add(id: integer; trust: integer; flags: integer; ck: X509_PURPOSE_add_ck; name: PUtf8Char; sname: PUtf8Char; arg: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_PURPOSE_add';

function X509_PURPOSE_get0_name(xp: PX509_PURPOSE): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'X509_PURPOSE_get0_name';

function X509_PURPOSE_get0_sname(xp: PX509_PURPOSE): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'X509_PURPOSE_get0_sname';

function X509_PURPOSE_get_trust(xp: PX509_PURPOSE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_PURPOSE_get_trust';

procedure X509_PURPOSE_cleanup(); cdecl;
  external LIB_CRYPTO name _PU + 'X509_PURPOSE_cleanup';

function X509_PURPOSE_get_id(p1: PX509_PURPOSE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_PURPOSE_get_id';

function X509_get1_email(x: PX509): Pstack_st_OPENSSL_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get1_email';

function X509_REQ_get1_email(x: PX509_REQ): Pstack_st_OPENSSL_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'X509_REQ_get1_email';

procedure X509_email_free(sk: Pstack_st_OPENSSL_STRING); cdecl;
  external LIB_CRYPTO name _PU + 'X509_email_free';

function X509_get1_ocsp(x: PX509): Pstack_st_OPENSSL_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'X509_get1_ocsp';

function X509_check_host(x: PX509; chk: PUtf8Char; chklen: PtrUInt; flags: cardinal; peername: PPUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_check_host';

function X509_check_email(x: PX509; chk: PUtf8Char; chklen: PtrUInt; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_check_email';

function X509_check_ip(x: PX509; chk: PByte; chklen: PtrUInt; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_check_ip';

function X509_check_ip_asc(x: PX509; ipasc: PUtf8Char; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509_check_ip_asc';

function a2i_IPADDRESS(ipasc: PUtf8Char): PASN1_OCTET_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'a2i_IPADDRESS';

function a2i_IPADDRESS_NC(ipasc: PUtf8Char): PASN1_OCTET_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'a2i_IPADDRESS_NC';

function X509V3_NAME_from_section(nm: PX509_NAME; dn_sk: Pstack_st_CONF_VALUE; chtype: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509V3_NAME_from_section';

procedure X509_POLICY_NODE_print(_out: PBIO; node: PX509_POLICY_NODE; indent: integer); cdecl;
  external LIB_CRYPTO name _PU + 'X509_POLICY_NODE_print';

function ASRange_new(): PASRange; cdecl;
  external LIB_CRYPTO name _PU + 'ASRange_new';

procedure ASRange_free(a: PASRange); cdecl;
  external LIB_CRYPTO name _PU + 'ASRange_free';

function d2i_ASRange(a: PPASRange; _in: PPByte; len: integer): PASRange; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASRange';

function i2d_ASRange(a: PASRange; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASRange';

function ASRange_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASRange_it';

function ASIdOrRange_new(): PASIdOrRange; cdecl;
  external LIB_CRYPTO name _PU + 'ASIdOrRange_new';

procedure ASIdOrRange_free(a: PASIdOrRange); cdecl;
  external LIB_CRYPTO name _PU + 'ASIdOrRange_free';

function d2i_ASIdOrRange(a: PPASIdOrRange; _in: PPByte; len: integer): PASIdOrRange; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASIdOrRange';

function i2d_ASIdOrRange(a: PASIdOrRange; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASIdOrRange';

function ASIdOrRange_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASIdOrRange_it';

function ASIdentifierChoice_new(): PASIdentifierChoice; cdecl;
  external LIB_CRYPTO name _PU + 'ASIdentifierChoice_new';

procedure ASIdentifierChoice_free(a: PASIdentifierChoice); cdecl;
  external LIB_CRYPTO name _PU + 'ASIdentifierChoice_free';

function d2i_ASIdentifierChoice(a: PPASIdentifierChoice; _in: PPByte; len: integer): PASIdentifierChoice; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASIdentifierChoice';

function i2d_ASIdentifierChoice(a: PASIdentifierChoice; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASIdentifierChoice';

function ASIdentifierChoice_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASIdentifierChoice_it';

function ASIdentifiers_new(): PASIdentifiers; cdecl;
  external LIB_CRYPTO name _PU + 'ASIdentifiers_new';

procedure ASIdentifiers_free(a: PASIdentifiers); cdecl;
  external LIB_CRYPTO name _PU + 'ASIdentifiers_free';

function d2i_ASIdentifiers(a: PPASIdentifiers; _in: PPByte; len: integer): PASIdentifiers; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ASIdentifiers';

function i2d_ASIdentifiers(a: PASIdentifiers; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ASIdentifiers';

function ASIdentifiers_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ASIdentifiers_it';

function IPAddressRange_new(): PIPAddressRange; cdecl;
  external LIB_CRYPTO name _PU + 'IPAddressRange_new';

procedure IPAddressRange_free(a: PIPAddressRange); cdecl;
  external LIB_CRYPTO name _PU + 'IPAddressRange_free';

function d2i_IPAddressRange(a: PPIPAddressRange; _in: PPByte; len: integer): PIPAddressRange; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_IPAddressRange';

function i2d_IPAddressRange(a: PIPAddressRange; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_IPAddressRange';

function IPAddressRange_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'IPAddressRange_it';

function IPAddressOrRange_new(): PIPAddressOrRange; cdecl;
  external LIB_CRYPTO name _PU + 'IPAddressOrRange_new';

procedure IPAddressOrRange_free(a: PIPAddressOrRange); cdecl;
  external LIB_CRYPTO name _PU + 'IPAddressOrRange_free';

function d2i_IPAddressOrRange(a: PPIPAddressOrRange; _in: PPByte; len: integer): PIPAddressOrRange; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_IPAddressOrRange';

function i2d_IPAddressOrRange(a: PIPAddressOrRange; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_IPAddressOrRange';

function IPAddressOrRange_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'IPAddressOrRange_it';

function IPAddressChoice_new(): PIPAddressChoice; cdecl;
  external LIB_CRYPTO name _PU + 'IPAddressChoice_new';

procedure IPAddressChoice_free(a: PIPAddressChoice); cdecl;
  external LIB_CRYPTO name _PU + 'IPAddressChoice_free';

function d2i_IPAddressChoice(a: PPIPAddressChoice; _in: PPByte; len: integer): PIPAddressChoice; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_IPAddressChoice';

function i2d_IPAddressChoice(a: PIPAddressChoice; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_IPAddressChoice';

function IPAddressChoice_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'IPAddressChoice_it';

function IPAddressFamily_new(): PIPAddressFamily; cdecl;
  external LIB_CRYPTO name _PU + 'IPAddressFamily_new';

procedure IPAddressFamily_free(a: PIPAddressFamily); cdecl;
  external LIB_CRYPTO name _PU + 'IPAddressFamily_free';

function d2i_IPAddressFamily(a: PPIPAddressFamily; _in: PPByte; len: integer): PIPAddressFamily; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_IPAddressFamily';

function i2d_IPAddressFamily(a: PIPAddressFamily; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_IPAddressFamily';

function IPAddressFamily_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'IPAddressFamily_it';

function X509v3_asid_add_inherit(asid: PASIdentifiers; which: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_asid_add_inherit';

function X509v3_asid_add_id_or_range(asid: PASIdentifiers; which: integer; min: PASN1_INTEGER; max: PASN1_INTEGER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_asid_add_id_or_range';

function X509v3_addr_add_inherit(addr: PIPAddrBlocks; afi: cardinal; safi: PCardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_addr_add_inherit';

function X509v3_addr_add_prefix(addr: PIPAddrBlocks; afi: cardinal; safi: PCardinal; a: PByte; prefixlen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_addr_add_prefix';

function X509v3_addr_add_range(addr: PIPAddrBlocks; afi: cardinal; safi: PCardinal; min: PByte; max: PByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_addr_add_range';

function X509v3_addr_get_afi(f: PIPAddressFamily): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_addr_get_afi';

function X509v3_addr_get_range(aor: PIPAddressOrRange; afi: cardinal; min: PByte; max: PByte; length: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_addr_get_range';

function X509v3_asid_is_canonical(asid: PASIdentifiers): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_asid_is_canonical';

function X509v3_addr_is_canonical(addr: PIPAddrBlocks): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_addr_is_canonical';

function X509v3_asid_canonize(asid: PASIdentifiers): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_asid_canonize';

function X509v3_addr_canonize(addr: PIPAddrBlocks): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_addr_canonize';

function X509v3_asid_inherits(asid: PASIdentifiers): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_asid_inherits';

function X509v3_addr_inherits(addr: PIPAddrBlocks): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_addr_inherits';

function X509v3_asid_subset(a: PASIdentifiers; b: PASIdentifiers): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_asid_subset';

function X509v3_addr_subset(a: PIPAddrBlocks; b: PIPAddrBlocks): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_addr_subset';

function X509v3_asid_validate_path(p1: PX509_STORE_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_asid_validate_path';

function X509v3_addr_validate_path(p1: PX509_STORE_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_addr_validate_path';

function X509v3_asid_validate_resource_set(chain: Pstack_st_X509; ext: PASIdentifiers; allow_inheritance: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_asid_validate_resource_set';

function X509v3_addr_validate_resource_set(chain: Pstack_st_X509; ext: PIPAddrBlocks; allow_inheritance: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'X509v3_addr_validate_resource_set';

function NAMING_AUTHORITY_new(): PNAMING_AUTHORITY; cdecl;
  external LIB_CRYPTO name _PU + 'NAMING_AUTHORITY_new';

procedure NAMING_AUTHORITY_free(a: PNAMING_AUTHORITY); cdecl;
  external LIB_CRYPTO name _PU + 'NAMING_AUTHORITY_free';

function d2i_NAMING_AUTHORITY(a: PPNAMING_AUTHORITY; _in: PPByte; len: integer): PNAMING_AUTHORITY; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_NAMING_AUTHORITY';

function i2d_NAMING_AUTHORITY(a: PNAMING_AUTHORITY; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_NAMING_AUTHORITY';

function NAMING_AUTHORITY_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'NAMING_AUTHORITY_it';

function PROFESSION_INFO_new(): PPROFESSION_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'PROFESSION_INFO_new';

procedure PROFESSION_INFO_free(a: PPROFESSION_INFO); cdecl;
  external LIB_CRYPTO name _PU + 'PROFESSION_INFO_free';

function d2i_PROFESSION_INFO(a: PPPROFESSION_INFO; _in: PPByte; len: integer): PPROFESSION_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PROFESSION_INFO';

function i2d_PROFESSION_INFO(a: PPROFESSION_INFO; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PROFESSION_INFO';

function PROFESSION_INFO_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PROFESSION_INFO_it';

function ADMISSIONS_new(): PADMISSIONS; cdecl;
  external LIB_CRYPTO name _PU + 'ADMISSIONS_new';

procedure ADMISSIONS_free(a: PADMISSIONS); cdecl;
  external LIB_CRYPTO name _PU + 'ADMISSIONS_free';

function d2i_ADMISSIONS(a: PPADMISSIONS; _in: PPByte; len: integer): PADMISSIONS; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ADMISSIONS';

function i2d_ADMISSIONS(a: PADMISSIONS; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ADMISSIONS';

function ADMISSIONS_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ADMISSIONS_it';

function ADMISSION_SYNTAX_new(): PADMISSION_SYNTAX; cdecl;
  external LIB_CRYPTO name _PU + 'ADMISSION_SYNTAX_new';

procedure ADMISSION_SYNTAX_free(a: PADMISSION_SYNTAX); cdecl;
  external LIB_CRYPTO name _PU + 'ADMISSION_SYNTAX_free';

function d2i_ADMISSION_SYNTAX(a: PPADMISSION_SYNTAX; _in: PPByte; len: integer): PADMISSION_SYNTAX; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ADMISSION_SYNTAX';

function i2d_ADMISSION_SYNTAX(a: PADMISSION_SYNTAX; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ADMISSION_SYNTAX';

function ADMISSION_SYNTAX_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'ADMISSION_SYNTAX_it';

function NAMING_AUTHORITY_get0_authorityId(n: PNAMING_AUTHORITY): PASN1_OBJECT; cdecl;
  external LIB_CRYPTO name _PU + 'NAMING_AUTHORITY_get0_authorityId';

function NAMING_AUTHORITY_get0_authorityURL(n: PNAMING_AUTHORITY): PASN1_IA5STRING; cdecl;
  external LIB_CRYPTO name _PU + 'NAMING_AUTHORITY_get0_authorityURL';

function NAMING_AUTHORITY_get0_authorityText(n: PNAMING_AUTHORITY): PASN1_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'NAMING_AUTHORITY_get0_authorityText';

procedure NAMING_AUTHORITY_set0_authorityId(n: PNAMING_AUTHORITY; namingAuthorityId: PASN1_OBJECT); cdecl;
  external LIB_CRYPTO name _PU + 'NAMING_AUTHORITY_set0_authorityId';

procedure NAMING_AUTHORITY_set0_authorityURL(n: PNAMING_AUTHORITY; namingAuthorityUrl: PASN1_IA5STRING); cdecl;
  external LIB_CRYPTO name _PU + 'NAMING_AUTHORITY_set0_authorityURL';

procedure NAMING_AUTHORITY_set0_authorityText(n: PNAMING_AUTHORITY; namingAuthorityText: PASN1_STRING); cdecl;
  external LIB_CRYPTO name _PU + 'NAMING_AUTHORITY_set0_authorityText';

function ADMISSION_SYNTAX_get0_admissionAuthority(_as: PADMISSION_SYNTAX): PGENERAL_NAME; cdecl;
  external LIB_CRYPTO name _PU + 'ADMISSION_SYNTAX_get0_admissionAuthority';

procedure ADMISSION_SYNTAX_set0_admissionAuthority(_as: PADMISSION_SYNTAX; aa: PGENERAL_NAME); cdecl;
  external LIB_CRYPTO name _PU + 'ADMISSION_SYNTAX_set0_admissionAuthority';

function ADMISSION_SYNTAX_get0_contentsOfAdmissions(_as: PADMISSION_SYNTAX): Pstack_st_ADMISSIONS; cdecl;
  external LIB_CRYPTO name _PU + 'ADMISSION_SYNTAX_get0_contentsOfAdmissions';

procedure ADMISSION_SYNTAX_set0_contentsOfAdmissions(_as: PADMISSION_SYNTAX; a: Pstack_st_ADMISSIONS); cdecl;
  external LIB_CRYPTO name _PU + 'ADMISSION_SYNTAX_set0_contentsOfAdmissions';

function ADMISSIONS_get0_admissionAuthority(a: PADMISSIONS): PGENERAL_NAME; cdecl;
  external LIB_CRYPTO name _PU + 'ADMISSIONS_get0_admissionAuthority';

procedure ADMISSIONS_set0_admissionAuthority(a: PADMISSIONS; aa: PGENERAL_NAME); cdecl;
  external LIB_CRYPTO name _PU + 'ADMISSIONS_set0_admissionAuthority';

function ADMISSIONS_get0_namingAuthority(a: PADMISSIONS): PNAMING_AUTHORITY; cdecl;
  external LIB_CRYPTO name _PU + 'ADMISSIONS_get0_namingAuthority';

procedure ADMISSIONS_set0_namingAuthority(a: PADMISSIONS; na: PNAMING_AUTHORITY); cdecl;
  external LIB_CRYPTO name _PU + 'ADMISSIONS_set0_namingAuthority';

function ADMISSIONS_get0_professionInfos(a: PADMISSIONS): PPROFESSION_INFOS; cdecl;
  external LIB_CRYPTO name _PU + 'ADMISSIONS_get0_professionInfos';

procedure ADMISSIONS_set0_professionInfos(a: PADMISSIONS; pi: PPROFESSION_INFOS); cdecl;
  external LIB_CRYPTO name _PU + 'ADMISSIONS_set0_professionInfos';

function PROFESSION_INFO_get0_addProfessionInfo(pi: PPROFESSION_INFO): PASN1_OCTET_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'PROFESSION_INFO_get0_addProfessionInfo';

procedure PROFESSION_INFO_set0_addProfessionInfo(pi: PPROFESSION_INFO; aos: PASN1_OCTET_STRING); cdecl;
  external LIB_CRYPTO name _PU + 'PROFESSION_INFO_set0_addProfessionInfo';

function PROFESSION_INFO_get0_namingAuthority(pi: PPROFESSION_INFO): PNAMING_AUTHORITY; cdecl;
  external LIB_CRYPTO name _PU + 'PROFESSION_INFO_get0_namingAuthority';

procedure PROFESSION_INFO_set0_namingAuthority(pi: PPROFESSION_INFO; na: PNAMING_AUTHORITY); cdecl;
  external LIB_CRYPTO name _PU + 'PROFESSION_INFO_set0_namingAuthority';

function PROFESSION_INFO_get0_professionItems(pi: PPROFESSION_INFO): Pstack_st_ASN1_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'PROFESSION_INFO_get0_professionItems';

procedure PROFESSION_INFO_set0_professionItems(pi: PPROFESSION_INFO; _as: Pstack_st_ASN1_STRING); cdecl;
  external LIB_CRYPTO name _PU + 'PROFESSION_INFO_set0_professionItems';

function PROFESSION_INFO_get0_professionOIDs(pi: PPROFESSION_INFO): Pstack_st_ASN1_OBJECT; cdecl;
  external LIB_CRYPTO name _PU + 'PROFESSION_INFO_get0_professionOIDs';

procedure PROFESSION_INFO_set0_professionOIDs(pi: PPROFESSION_INFO; po: Pstack_st_ASN1_OBJECT); cdecl;
  external LIB_CRYPTO name _PU + 'PROFESSION_INFO_set0_professionOIDs';

function PROFESSION_INFO_get0_registrationNumber(pi: PPROFESSION_INFO): PASN1_PRINTABLESTRING; cdecl;
  external LIB_CRYPTO name _PU + 'PROFESSION_INFO_get0_registrationNumber';

procedure PROFESSION_INFO_set0_registrationNumber(pi: PPROFESSION_INFO; rn: PASN1_PRINTABLESTRING); cdecl;
  external LIB_CRYPTO name _PU + 'PROFESSION_INFO_set0_registrationNumber';

function ERR_load_CMS_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_CMS_strings';

function CMS_ContentInfo_new(): PCMS_ContentInfo; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_ContentInfo_new';

procedure CMS_ContentInfo_free(a: PCMS_ContentInfo); cdecl;
  external LIB_CRYPTO name _PU + 'CMS_ContentInfo_free';

function d2i_CMS_ContentInfo(a: PPCMS_ContentInfo; _in: PPByte; len: integer): PCMS_ContentInfo; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_CMS_ContentInfo';

function i2d_CMS_ContentInfo(a: PCMS_ContentInfo; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_CMS_ContentInfo';

function CMS_ContentInfo_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_ContentInfo_it';

function CMS_ReceiptRequest_new(): PCMS_ReceiptRequest; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_ReceiptRequest_new';

procedure CMS_ReceiptRequest_free(a: PCMS_ReceiptRequest); cdecl;
  external LIB_CRYPTO name _PU + 'CMS_ReceiptRequest_free';

function d2i_CMS_ReceiptRequest(a: PPCMS_ReceiptRequest; _in: PPByte; len: integer): PCMS_ReceiptRequest; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_CMS_ReceiptRequest';

function i2d_CMS_ReceiptRequest(a: PCMS_ReceiptRequest; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_CMS_ReceiptRequest';

function CMS_ReceiptRequest_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_ReceiptRequest_it';

function CMS_ContentInfo_print_ctx(_out: PBIO; x: PCMS_ContentInfo; indent: integer; pctx: PASN1_PCTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_ContentInfo_print_ctx';

function CMS_get0_type(cms: PCMS_ContentInfo): PASN1_OBJECT; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_get0_type';

function CMS_dataInit(cms: PCMS_ContentInfo; icont: PBIO): PBIO; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_dataInit';

function CMS_dataFinal(cms: PCMS_ContentInfo; bio: PBIO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_dataFinal';

function CMS_get0_content(cms: PCMS_ContentInfo): PPASN1_OCTET_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_get0_content';

function CMS_is_detached(cms: PCMS_ContentInfo): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_is_detached';

function CMS_set_detached(cms: PCMS_ContentInfo; detached: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_set_detached';

function CMS_stream(boundary: PPPByte; cms: PCMS_ContentInfo): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_stream';

function d2i_CMS_bio(bp: PBIO; cms: PPCMS_ContentInfo): PCMS_ContentInfo; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_CMS_bio';

function i2d_CMS_bio(bp: PBIO; cms: PCMS_ContentInfo): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_CMS_bio';

function BIO_new_CMS(_out: PBIO; cms: PCMS_ContentInfo): PBIO; cdecl;
  external LIB_CRYPTO name _PU + 'BIO_new_CMS';

function i2d_CMS_bio_stream(_out: PBIO; cms: PCMS_ContentInfo; _in: PBIO; flags: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_CMS_bio_stream';

function PEM_write_bio_CMS_stream(_out: PBIO; cms: PCMS_ContentInfo; _in: PBIO; flags: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_bio_CMS_stream';

function SMIME_read_CMS(bio: PBIO; bcont: PPBIO): PCMS_ContentInfo; cdecl;
  external LIB_CRYPTO name _PU + 'SMIME_read_CMS';

function SMIME_write_CMS(bio: PBIO; cms: PCMS_ContentInfo; data: PBIO; flags: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SMIME_write_CMS';

function CMS_final(cms: PCMS_ContentInfo; data: PBIO; dcont: PBIO; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_final';

function CMS_sign(signcert: PX509; pkey: PEVP_PKEY; certs: Pstack_st_X509; data: PBIO; flags: cardinal): PCMS_ContentInfo; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_sign';

function CMS_sign_receipt(si: PCMS_SignerInfo; signcert: PX509; pkey: PEVP_PKEY; certs: Pstack_st_X509; flags: cardinal): PCMS_ContentInfo; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_sign_receipt';

function CMS_data(cms: PCMS_ContentInfo; _out: PBIO; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_data';

function CMS_data_create(_in: PBIO; flags: cardinal): PCMS_ContentInfo; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_data_create';

function CMS_digest_verify(cms: PCMS_ContentInfo; dcont: PBIO; _out: PBIO; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_digest_verify';

function CMS_digest_create(_in: PBIO; md: PEVP_MD; flags: cardinal): PCMS_ContentInfo; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_digest_create';

function CMS_EncryptedData_decrypt(cms: PCMS_ContentInfo; key: PByte; keylen: PtrUInt; dcont: PBIO; _out: PBIO; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_EncryptedData_decrypt';

function CMS_EncryptedData_encrypt(_in: PBIO; cipher: PEVP_CIPHER; key: PByte; keylen: PtrUInt; flags: cardinal): PCMS_ContentInfo; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_EncryptedData_encrypt';

function CMS_EncryptedData_set1_key(cms: PCMS_ContentInfo; ciph: PEVP_CIPHER; key: PByte; keylen: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_EncryptedData_set1_key';

function CMS_verify(cms: PCMS_ContentInfo; certs: Pstack_st_X509; store: PX509_STORE; dcont: PBIO; _out: PBIO; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_verify';

function CMS_verify_receipt(rcms: PCMS_ContentInfo; ocms: PCMS_ContentInfo; certs: Pstack_st_X509; store: PX509_STORE; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_verify_receipt';

function CMS_get0_signers(cms: PCMS_ContentInfo): Pstack_st_X509; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_get0_signers';

function CMS_encrypt(certs: Pstack_st_X509; _in: PBIO; cipher: PEVP_CIPHER; flags: cardinal): PCMS_ContentInfo; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_encrypt';

function CMS_decrypt(cms: PCMS_ContentInfo; pkey: PEVP_PKEY; cert: PX509; dcont: PBIO; _out: PBIO; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_decrypt';

function CMS_decrypt_set1_pkey(cms: PCMS_ContentInfo; pk: PEVP_PKEY; cert: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_decrypt_set1_pkey';

function CMS_decrypt_set1_key(cms: PCMS_ContentInfo; key: PByte; keylen: PtrUInt; id: PByte; idlen: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_decrypt_set1_key';

function CMS_decrypt_set1_password(cms: PCMS_ContentInfo; pass: PByte; passlen: Int64): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_decrypt_set1_password';

function CMS_get0_RecipientInfos(cms: PCMS_ContentInfo): Pstack_st_CMS_RecipientInfo; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_get0_RecipientInfos';

function CMS_RecipientInfo_type(ri: PCMS_RecipientInfo): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_RecipientInfo_type';

function CMS_RecipientInfo_get0_pkey_ctx(ri: PCMS_RecipientInfo): PEVP_PKEY_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_RecipientInfo_get0_pkey_ctx';

function CMS_EnvelopedData_create(cipher: PEVP_CIPHER): PCMS_ContentInfo; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_EnvelopedData_create';

function CMS_add1_recipient_cert(cms: PCMS_ContentInfo; recip: PX509; flags: cardinal): PCMS_RecipientInfo; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_add1_recipient_cert';

function CMS_RecipientInfo_set0_pkey(ri: PCMS_RecipientInfo; pkey: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_RecipientInfo_set0_pkey';

function CMS_RecipientInfo_ktri_cert_cmp(ri: PCMS_RecipientInfo; cert: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_RecipientInfo_ktri_cert_cmp';

function CMS_RecipientInfo_ktri_get0_algs(ri: PCMS_RecipientInfo; pk: PPEVP_PKEY; recip: PPX509; palg: PPX509_ALGOR): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_RecipientInfo_ktri_get0_algs';

function CMS_RecipientInfo_ktri_get0_signer_id(ri: PCMS_RecipientInfo; keyid: PPASN1_OCTET_STRING; issuer: PPX509_NAME; sno: PPASN1_INTEGER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_RecipientInfo_ktri_get0_signer_id';

function CMS_add0_recipient_key(cms: PCMS_ContentInfo; nid: integer; key: PByte; keylen: PtrUInt; id: PByte; idlen: PtrUInt; date: PASN1_GENERALIZEDTIME; otherTypeId: PASN1_OBJECT; otherType: PASN1_TYPE): PCMS_RecipientInfo; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_add0_recipient_key';

function CMS_RecipientInfo_kekri_get0_id(ri: PCMS_RecipientInfo; palg: PPX509_ALGOR; pid: PPASN1_OCTET_STRING; pdate: PPASN1_GENERALIZEDTIME; potherid: PPASN1_OBJECT; pothertype: PPASN1_TYPE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_RecipientInfo_kekri_get0_id';

function CMS_RecipientInfo_set0_key(ri: PCMS_RecipientInfo; key: PByte; keylen: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_RecipientInfo_set0_key';

function CMS_RecipientInfo_kekri_id_cmp(ri: PCMS_RecipientInfo; id: PByte; idlen: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_RecipientInfo_kekri_id_cmp';

function CMS_RecipientInfo_set0_password(ri: PCMS_RecipientInfo; pass: PByte; passlen: Int64): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_RecipientInfo_set0_password';

function CMS_add0_recipient_password(cms: PCMS_ContentInfo; iter: integer; wrap_nid: integer; pbe_nid: integer; pass: PByte; passlen: Int64; kekciph: PEVP_CIPHER): PCMS_RecipientInfo; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_add0_recipient_password';

function CMS_RecipientInfo_decrypt(cms: PCMS_ContentInfo; ri: PCMS_RecipientInfo): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_RecipientInfo_decrypt';

function CMS_RecipientInfo_encrypt(cms: PCMS_ContentInfo; ri: PCMS_RecipientInfo): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_RecipientInfo_encrypt';

function CMS_uncompress(cms: PCMS_ContentInfo; dcont: PBIO; _out: PBIO; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_uncompress';

function CMS_compress(_in: PBIO; comp_nid: integer; flags: cardinal): PCMS_ContentInfo; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_compress';

function CMS_set1_eContentType(cms: PCMS_ContentInfo; oid: PASN1_OBJECT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_set1_eContentType';

function CMS_get0_eContentType(cms: PCMS_ContentInfo): PASN1_OBJECT; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_get0_eContentType';

function CMS_add0_CertificateChoices(cms: PCMS_ContentInfo): PCMS_CertificateChoices; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_add0_CertificateChoices';

function CMS_add0_cert(cms: PCMS_ContentInfo; cert: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_add0_cert';

function CMS_add1_cert(cms: PCMS_ContentInfo; cert: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_add1_cert';

function CMS_get1_certs(cms: PCMS_ContentInfo): Pstack_st_X509; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_get1_certs';

function CMS_add0_RevocationInfoChoice(cms: PCMS_ContentInfo): PCMS_RevocationInfoChoice; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_add0_RevocationInfoChoice';

function CMS_add0_crl(cms: PCMS_ContentInfo; crl: PX509_CRL): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_add0_crl';

function CMS_add1_crl(cms: PCMS_ContentInfo; crl: PX509_CRL): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_add1_crl';

function CMS_get1_crls(cms: PCMS_ContentInfo): Pstack_st_X509_CRL; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_get1_crls';

function CMS_SignedData_init(cms: PCMS_ContentInfo): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_SignedData_init';

function CMS_add1_signer(cms: PCMS_ContentInfo; signer: PX509; pk: PEVP_PKEY; md: PEVP_MD; flags: cardinal): PCMS_SignerInfo; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_add1_signer';

function CMS_SignerInfo_get0_pkey_ctx(si: PCMS_SignerInfo): PEVP_PKEY_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_SignerInfo_get0_pkey_ctx';

function CMS_SignerInfo_get0_md_ctx(si: PCMS_SignerInfo): PEVP_MD_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_SignerInfo_get0_md_ctx';

function CMS_get0_SignerInfos(cms: PCMS_ContentInfo): Pstack_st_CMS_SignerInfo; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_get0_SignerInfos';

procedure CMS_SignerInfo_set1_signer_cert(si: PCMS_SignerInfo; signer: PX509); cdecl;
  external LIB_CRYPTO name _PU + 'CMS_SignerInfo_set1_signer_cert';

function CMS_SignerInfo_get0_signer_id(si: PCMS_SignerInfo; keyid: PPASN1_OCTET_STRING; issuer: PPX509_NAME; sno: PPASN1_INTEGER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_SignerInfo_get0_signer_id';

function CMS_SignerInfo_cert_cmp(si: PCMS_SignerInfo; cert: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_SignerInfo_cert_cmp';

function CMS_set1_signers_certs(cms: PCMS_ContentInfo; certs: Pstack_st_X509; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_set1_signers_certs';

procedure CMS_SignerInfo_get0_algs(si: PCMS_SignerInfo; pk: PPEVP_PKEY; signer: PPX509; pdig: PPX509_ALGOR; psig: PPX509_ALGOR); cdecl;
  external LIB_CRYPTO name _PU + 'CMS_SignerInfo_get0_algs';

function CMS_SignerInfo_get0_signature(si: PCMS_SignerInfo): PASN1_OCTET_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_SignerInfo_get0_signature';

function CMS_SignerInfo_sign(si: PCMS_SignerInfo): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_SignerInfo_sign';

function CMS_SignerInfo_verify(si: PCMS_SignerInfo): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_SignerInfo_verify';

function CMS_SignerInfo_verify_content(si: PCMS_SignerInfo; chain: PBIO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_SignerInfo_verify_content';

function CMS_add_smimecap(si: PCMS_SignerInfo; algs: Pstack_st_X509_ALGOR): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_add_smimecap';

function CMS_add_simple_smimecap(algs: PPstack_st_X509_ALGOR; algnid: integer; keysize: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_add_simple_smimecap';

function CMS_add_standard_smimecap(smcap: PPstack_st_X509_ALGOR): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_add_standard_smimecap';

function CMS_signed_get_attr_count(si: PCMS_SignerInfo): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_signed_get_attr_count';

function CMS_signed_get_attr_by_NID(si: PCMS_SignerInfo; nid: integer; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_signed_get_attr_by_NID';

function CMS_signed_get_attr_by_OBJ(si: PCMS_SignerInfo; obj: PASN1_OBJECT; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_signed_get_attr_by_OBJ';

function CMS_signed_get_attr(si: PCMS_SignerInfo; loc: integer): PX509_ATTRIBUTE; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_signed_get_attr';

function CMS_signed_delete_attr(si: PCMS_SignerInfo; loc: integer): PX509_ATTRIBUTE; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_signed_delete_attr';

function CMS_signed_add1_attr(si: PCMS_SignerInfo; attr: PX509_ATTRIBUTE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_signed_add1_attr';

function CMS_signed_add1_attr_by_OBJ(si: PCMS_SignerInfo; obj: PASN1_OBJECT; typ: integer; bytes: pointer; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_signed_add1_attr_by_OBJ';

function CMS_signed_add1_attr_by_NID(si: PCMS_SignerInfo; nid: integer; typ: integer; bytes: pointer; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_signed_add1_attr_by_NID';

function CMS_signed_add1_attr_by_txt(si: PCMS_SignerInfo; attrname: PUtf8Char; typ: integer; bytes: pointer; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_signed_add1_attr_by_txt';

function CMS_signed_get0_data_by_OBJ(si: PCMS_SignerInfo; oid: PASN1_OBJECT; lastpos: integer; typ: integer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_signed_get0_data_by_OBJ';

function CMS_unsigned_get_attr_count(si: PCMS_SignerInfo): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_unsigned_get_attr_count';

function CMS_unsigned_get_attr_by_NID(si: PCMS_SignerInfo; nid: integer; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_unsigned_get_attr_by_NID';

function CMS_unsigned_get_attr_by_OBJ(si: PCMS_SignerInfo; obj: PASN1_OBJECT; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_unsigned_get_attr_by_OBJ';

function CMS_unsigned_get_attr(si: PCMS_SignerInfo; loc: integer): PX509_ATTRIBUTE; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_unsigned_get_attr';

function CMS_unsigned_delete_attr(si: PCMS_SignerInfo; loc: integer): PX509_ATTRIBUTE; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_unsigned_delete_attr';

function CMS_unsigned_add1_attr(si: PCMS_SignerInfo; attr: PX509_ATTRIBUTE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_unsigned_add1_attr';

function CMS_unsigned_add1_attr_by_OBJ(si: PCMS_SignerInfo; obj: PASN1_OBJECT; typ: integer; bytes: pointer; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_unsigned_add1_attr_by_OBJ';

function CMS_unsigned_add1_attr_by_NID(si: PCMS_SignerInfo; nid: integer; typ: integer; bytes: pointer; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_unsigned_add1_attr_by_NID';

function CMS_unsigned_add1_attr_by_txt(si: PCMS_SignerInfo; attrname: PUtf8Char; typ: integer; bytes: pointer; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_unsigned_add1_attr_by_txt';

function CMS_unsigned_get0_data_by_OBJ(si: PCMS_SignerInfo; oid: PASN1_OBJECT; lastpos: integer; typ: integer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_unsigned_get0_data_by_OBJ';

function CMS_get1_ReceiptRequest(si: PCMS_SignerInfo; prr: PPCMS_ReceiptRequest): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_get1_ReceiptRequest';

function CMS_ReceiptRequest_create0(id: PByte; idlen: integer; allorfirst: integer; receiptList: Pstack_st_GENERAL_NAMES; receiptsTo: Pstack_st_GENERAL_NAMES): PCMS_ReceiptRequest; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_ReceiptRequest_create0';

function CMS_add1_ReceiptRequest(si: PCMS_SignerInfo; rr: PCMS_ReceiptRequest): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_add1_ReceiptRequest';

procedure CMS_ReceiptRequest_get0_values(rr: PCMS_ReceiptRequest; pcid: PPASN1_STRING; pallorfirst: PInteger; plist: PPstack_st_GENERAL_NAMES; prto: PPstack_st_GENERAL_NAMES); cdecl;
  external LIB_CRYPTO name _PU + 'CMS_ReceiptRequest_get0_values';

function CMS_RecipientInfo_kari_get0_alg(ri: PCMS_RecipientInfo; palg: PPX509_ALGOR; pukm: PPASN1_OCTET_STRING): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_RecipientInfo_kari_get0_alg';

function CMS_RecipientInfo_kari_get0_reks(ri: PCMS_RecipientInfo): Pstack_st_CMS_RecipientEncryptedKey; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_RecipientInfo_kari_get0_reks';

function CMS_RecipientInfo_kari_get0_orig_id(ri: PCMS_RecipientInfo; pubalg: PPX509_ALGOR; pubkey: PPASN1_BIT_STRING; keyid: PPASN1_OCTET_STRING; issuer: PPX509_NAME; sno: PPASN1_INTEGER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_RecipientInfo_kari_get0_orig_id';

function CMS_RecipientInfo_kari_orig_id_cmp(ri: PCMS_RecipientInfo; cert: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_RecipientInfo_kari_orig_id_cmp';

function CMS_RecipientEncryptedKey_get0_id(rek: PCMS_RecipientEncryptedKey; keyid: PPASN1_OCTET_STRING; tm: PPASN1_GENERALIZEDTIME; other: PPCMS_OtherKeyAttribute; issuer: PPX509_NAME; sno: PPASN1_INTEGER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_RecipientEncryptedKey_get0_id';

function CMS_RecipientEncryptedKey_cert_cmp(rek: PCMS_RecipientEncryptedKey; cert: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_RecipientEncryptedKey_cert_cmp';

function CMS_RecipientInfo_kari_set0_pkey(ri: PCMS_RecipientInfo; pk: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_RecipientInfo_kari_set0_pkey';

function CMS_RecipientInfo_kari_get0_ctx(ri: PCMS_RecipientInfo): PEVP_CIPHER_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_RecipientInfo_kari_get0_ctx';

function CMS_RecipientInfo_kari_decrypt(cms: PCMS_ContentInfo; ri: PCMS_RecipientInfo; rek: PCMS_RecipientEncryptedKey): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_RecipientInfo_kari_decrypt';

function CMS_SharedInfo_encode(pder: PPByte; kekalg: PX509_ALGOR; ukm: PASN1_OCTET_STRING; keylen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CMS_SharedInfo_encode';

function ERR_load_COMP_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_COMP_strings';

function COMP_CTX_new(meth: PCOMP_METHOD): PCOMP_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'COMP_CTX_new';

function COMP_CTX_get_method(ctx: PCOMP_CTX): PCOMP_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'COMP_CTX_get_method';

function COMP_CTX_get_type(comp: PCOMP_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'COMP_CTX_get_type';

function COMP_get_type(meth: PCOMP_METHOD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'COMP_get_type';

function COMP_get_name(meth: PCOMP_METHOD): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'COMP_get_name';

procedure COMP_CTX_free(ctx: PCOMP_CTX); cdecl;
  external LIB_CRYPTO name _PU + 'COMP_CTX_free';

function COMP_compress_block(ctx: PCOMP_CTX; _out: PByte; olen: integer; _in: PByte; ilen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'COMP_compress_block';

function COMP_expand_block(ctx: PCOMP_CTX; _out: PByte; olen: integer; _in: PByte; ilen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'COMP_expand_block';

function COMP_zlib(): PCOMP_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'COMP_zlib';

function _CONF_new_section(conf: PCONF; section: PUtf8Char): PCONF_VALUE; cdecl;
  external LIB_CRYPTO name _PU + '_CONF_new_section';

function _CONF_get_section(conf: PCONF; section: PUtf8Char): PCONF_VALUE; cdecl;
  external LIB_CRYPTO name _PU + '_CONF_get_section';

function _CONF_get_section_values(conf: PCONF; section: PUtf8Char): Pstack_st_CONF_VALUE; cdecl;
  external LIB_CRYPTO name _PU + '_CONF_get_section_values';

function _CONF_add_string(conf: PCONF; section: PCONF_VALUE; value: PCONF_VALUE): integer; cdecl;
  external LIB_CRYPTO name _PU + '_CONF_add_string';

function _CONF_get_string(conf: PCONF; section: PUtf8Char; name: PUtf8Char): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + '_CONF_get_string';

function _CONF_get_number(conf: PCONF; section: PUtf8Char; name: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + '_CONF_get_number';

function _CONF_new_data(conf: PCONF): integer; cdecl;
  external LIB_CRYPTO name _PU + '_CONF_new_data';

procedure _CONF_free_data(conf: PCONF); cdecl;
  external LIB_CRYPTO name _PU + '_CONF_free_data';

function ERR_load_CT_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_CT_strings';

function CT_POLICY_EVAL_CTX_new(): PCT_POLICY_EVAL_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'CT_POLICY_EVAL_CTX_new';

procedure CT_POLICY_EVAL_CTX_free(ctx: PCT_POLICY_EVAL_CTX); cdecl;
  external LIB_CRYPTO name _PU + 'CT_POLICY_EVAL_CTX_free';

function CT_POLICY_EVAL_CTX_get0_cert(ctx: PCT_POLICY_EVAL_CTX): PX509; cdecl;
  external LIB_CRYPTO name _PU + 'CT_POLICY_EVAL_CTX_get0_cert';

function CT_POLICY_EVAL_CTX_set1_cert(ctx: PCT_POLICY_EVAL_CTX; cert: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CT_POLICY_EVAL_CTX_set1_cert';

function CT_POLICY_EVAL_CTX_get0_issuer(ctx: PCT_POLICY_EVAL_CTX): PX509; cdecl;
  external LIB_CRYPTO name _PU + 'CT_POLICY_EVAL_CTX_get0_issuer';

function CT_POLICY_EVAL_CTX_set1_issuer(ctx: PCT_POLICY_EVAL_CTX; issuer: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CT_POLICY_EVAL_CTX_set1_issuer';

function CT_POLICY_EVAL_CTX_get0_log_store(ctx: PCT_POLICY_EVAL_CTX): PCTLOG_STORE; cdecl;
  external LIB_CRYPTO name _PU + 'CT_POLICY_EVAL_CTX_get0_log_store';

procedure CT_POLICY_EVAL_CTX_set_shared_CTLOG_STORE(ctx: PCT_POLICY_EVAL_CTX; log_store: PCTLOG_STORE); cdecl;
  external LIB_CRYPTO name _PU + 'CT_POLICY_EVAL_CTX_set_shared_CTLOG_STORE';

function CT_POLICY_EVAL_CTX_get_time(ctx: PCT_POLICY_EVAL_CTX): Qword; cdecl;
  external LIB_CRYPTO name _PU + 'CT_POLICY_EVAL_CTX_get_time';

procedure CT_POLICY_EVAL_CTX_set_time(ctx: PCT_POLICY_EVAL_CTX; time_in_ms: Qword); cdecl;
  external LIB_CRYPTO name _PU + 'CT_POLICY_EVAL_CTX_set_time';

function SCT_new(): PSCT; cdecl;
  external LIB_CRYPTO name _PU + 'SCT_new';

function SCT_new_from_base64(version: Byte; logid_base64: PUtf8Char; entry_type: ct_log_entry_type_t; timestamp: Qword; extensions_base64: PUtf8Char; signature_base64: PUtf8Char): PSCT; cdecl;
  external LIB_CRYPTO name _PU + 'SCT_new_from_base64';

procedure SCT_free(sct: PSCT); cdecl;
  external LIB_CRYPTO name _PU + 'SCT_free';

procedure SCT_LIST_free(a: Pstack_st_SCT); cdecl;
  external LIB_CRYPTO name _PU + 'SCT_LIST_free';

function SCT_get_version(sct: PSCT): sct_version_t; cdecl;
  external LIB_CRYPTO name _PU + 'SCT_get_version';

function SCT_set_version(sct: PSCT; version: sct_version_t): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SCT_set_version';

function SCT_get_log_entry_type(sct: PSCT): ct_log_entry_type_t; cdecl;
  external LIB_CRYPTO name _PU + 'SCT_get_log_entry_type';

function SCT_set_log_entry_type(sct: PSCT; entry_type: ct_log_entry_type_t): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SCT_set_log_entry_type';

function SCT_get0_log_id(sct: PSCT; log_id: PPByte): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'SCT_get0_log_id';

function SCT_set0_log_id(sct: PSCT; log_id: PByte; log_id_len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SCT_set0_log_id';

function SCT_set1_log_id(sct: PSCT; log_id: PByte; log_id_len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SCT_set1_log_id';

function SCT_get_timestamp(sct: PSCT): Qword; cdecl;
  external LIB_CRYPTO name _PU + 'SCT_get_timestamp';

procedure SCT_set_timestamp(sct: PSCT; timestamp: Qword); cdecl;
  external LIB_CRYPTO name _PU + 'SCT_set_timestamp';

function SCT_get_signature_nid(sct: PSCT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SCT_get_signature_nid';

function SCT_set_signature_nid(sct: PSCT; nid: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SCT_set_signature_nid';

function SCT_get0_extensions(sct: PSCT; ext: PPByte): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'SCT_get0_extensions';

procedure SCT_set0_extensions(sct: PSCT; ext: PByte; ext_len: PtrUInt); cdecl;
  external LIB_CRYPTO name _PU + 'SCT_set0_extensions';

function SCT_set1_extensions(sct: PSCT; ext: PByte; ext_len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SCT_set1_extensions';

function SCT_get0_signature(sct: PSCT; sig: PPByte): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'SCT_get0_signature';

procedure SCT_set0_signature(sct: PSCT; sig: PByte; sig_len: PtrUInt); cdecl;
  external LIB_CRYPTO name _PU + 'SCT_set0_signature';

function SCT_set1_signature(sct: PSCT; sig: PByte; sig_len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SCT_set1_signature';

function SCT_get_source(sct: PSCT): sct_source_t; cdecl;
  external LIB_CRYPTO name _PU + 'SCT_get_source';

function SCT_set_source(sct: PSCT; source: sct_source_t): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SCT_set_source';

function SCT_validation_status_string(sct: PSCT): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'SCT_validation_status_string';

procedure SCT_print(sct: PSCT; _out: PBIO; indent: integer; logs: PCTLOG_STORE); cdecl;
  external LIB_CRYPTO name _PU + 'SCT_print';

procedure SCT_LIST_print(sct_list: Pstack_st_SCT; _out: PBIO; indent: integer; separator: PUtf8Char; logs: PCTLOG_STORE); cdecl;
  external LIB_CRYPTO name _PU + 'SCT_LIST_print';

function SCT_get_validation_status(sct: PSCT): sct_validation_status_t; cdecl;
  external LIB_CRYPTO name _PU + 'SCT_get_validation_status';

function SCT_validate(sct: PSCT; ctx: PCT_POLICY_EVAL_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SCT_validate';

function SCT_LIST_validate(scts: Pstack_st_SCT; ctx: PCT_POLICY_EVAL_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SCT_LIST_validate';

function i2o_SCT_LIST(a: Pstack_st_SCT; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2o_SCT_LIST';

function o2i_SCT_LIST(a: PPstack_st_SCT; pp: PPByte; len: PtrUInt): Pstack_st_SCT; cdecl;
  external LIB_CRYPTO name _PU + 'o2i_SCT_LIST';

function i2d_SCT_LIST(a: Pstack_st_SCT; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_SCT_LIST';

function d2i_SCT_LIST(a: PPstack_st_SCT; pp: PPByte; len: integer): Pstack_st_SCT; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_SCT_LIST';

function i2o_SCT(sct: PSCT; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2o_SCT';

function o2i_SCT(psct: PPSCT; _in: PPByte; len: PtrUInt): PSCT; cdecl;
  external LIB_CRYPTO name _PU + 'o2i_SCT';

function CTLOG_new(public_key: PEVP_PKEY; name: PUtf8Char): PCTLOG; cdecl;
  external LIB_CRYPTO name _PU + 'CTLOG_new';

function CTLOG_new_from_base64(ct_log: PPCTLOG; pkey_base64: PUtf8Char; name: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CTLOG_new_from_base64';

procedure CTLOG_free(log: PCTLOG); cdecl;
  external LIB_CRYPTO name _PU + 'CTLOG_free';

function CTLOG_get0_name(log: PCTLOG): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'CTLOG_get0_name';

procedure CTLOG_get0_log_id(log: PCTLOG; log_id: PPByte; log_id_len: PPtrUInt); cdecl;
  external LIB_CRYPTO name _PU + 'CTLOG_get0_log_id';

function CTLOG_get0_public_key(log: PCTLOG): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'CTLOG_get0_public_key';

function CTLOG_STORE_new(): PCTLOG_STORE; cdecl;
  external LIB_CRYPTO name _PU + 'CTLOG_STORE_new';

procedure CTLOG_STORE_free(store: PCTLOG_STORE); cdecl;
  external LIB_CRYPTO name _PU + 'CTLOG_STORE_free';

function CTLOG_STORE_get0_log_by_id(store: PCTLOG_STORE; log_id: PByte; log_id_len: PtrUInt): PCTLOG; cdecl;
  external LIB_CRYPTO name _PU + 'CTLOG_STORE_get0_log_by_id';

function CTLOG_STORE_load_file(store: PCTLOG_STORE; _file: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CTLOG_STORE_load_file';

function CTLOG_STORE_load_default_file(store: PCTLOG_STORE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CTLOG_STORE_load_default_file';

function _shadow_DES_check_key(): PInteger; cdecl;
  external LIB_CRYPTO name _PU + '_shadow_DES_check_key';

function DES_options(): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'DES_options';

procedure DES_ecb3_encrypt(input: Pconst_DES_cblock; output: PDES_cblock; ks1: PDES_key_schedule; ks2: PDES_key_schedule; ks3: PDES_key_schedule; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'DES_ecb3_encrypt';

function DES_cbc_cksum(input: PByte; output: PDES_cblock; length: integer; schedule: PDES_key_schedule; ivec: Pconst_DES_cblock): DES_LONG; cdecl;
  external LIB_CRYPTO name _PU + 'DES_cbc_cksum';

procedure DES_cbc_encrypt(input: PByte; output: PByte; length: integer; schedule: PDES_key_schedule; ivec: PDES_cblock; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'DES_cbc_encrypt';

procedure DES_ncbc_encrypt(input: PByte; output: PByte; length: integer; schedule: PDES_key_schedule; ivec: PDES_cblock; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'DES_ncbc_encrypt';

procedure DES_xcbc_encrypt(input: PByte; output: PByte; length: integer; schedule: PDES_key_schedule; ivec: PDES_cblock; inw: Pconst_DES_cblock; outw: Pconst_DES_cblock; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'DES_xcbc_encrypt';

procedure DES_cfb_encrypt(_in: PByte; _out: PByte; numbits: integer; length: integer; schedule: PDES_key_schedule; ivec: PDES_cblock; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'DES_cfb_encrypt';

procedure DES_ecb_encrypt(input: Pconst_DES_cblock; output: PDES_cblock; ks: PDES_key_schedule; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'DES_ecb_encrypt';

procedure DES_encrypt1(data: PDES_LONG; ks: PDES_key_schedule; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'DES_encrypt1';

procedure DES_encrypt2(data: PDES_LONG; ks: PDES_key_schedule; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'DES_encrypt2';

procedure DES_encrypt3(data: PDES_LONG; ks1: PDES_key_schedule; ks2: PDES_key_schedule; ks3: PDES_key_schedule); cdecl;
  external LIB_CRYPTO name _PU + 'DES_encrypt3';

procedure DES_decrypt3(data: PDES_LONG; ks1: PDES_key_schedule; ks2: PDES_key_schedule; ks3: PDES_key_schedule); cdecl;
  external LIB_CRYPTO name _PU + 'DES_decrypt3';

procedure DES_ede3_cbc_encrypt(input: PByte; output: PByte; length: integer; ks1: PDES_key_schedule; ks2: PDES_key_schedule; ks3: PDES_key_schedule; ivec: PDES_cblock; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'DES_ede3_cbc_encrypt';

procedure DES_ede3_cfb64_encrypt(_in: PByte; _out: PByte; length: integer; ks1: PDES_key_schedule; ks2: PDES_key_schedule; ks3: PDES_key_schedule; ivec: PDES_cblock; num: PInteger; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'DES_ede3_cfb64_encrypt';

procedure DES_ede3_cfb_encrypt(_in: PByte; _out: PByte; numbits: integer; length: integer; ks1: PDES_key_schedule; ks2: PDES_key_schedule; ks3: PDES_key_schedule; ivec: PDES_cblock; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'DES_ede3_cfb_encrypt';

procedure DES_ede3_ofb64_encrypt(_in: PByte; _out: PByte; length: integer; ks1: PDES_key_schedule; ks2: PDES_key_schedule; ks3: PDES_key_schedule; ivec: PDES_cblock; num: PInteger); cdecl;
  external LIB_CRYPTO name _PU + 'DES_ede3_ofb64_encrypt';

function DES_fcrypt(buf: PUtf8Char; salt: PUtf8Char; ret: PUtf8Char): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'DES_fcrypt';

function DES_crypt(buf: PUtf8Char; salt: PUtf8Char): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'DES_crypt';

procedure DES_ofb_encrypt(_in: PByte; _out: PByte; numbits: integer; length: integer; schedule: PDES_key_schedule; ivec: PDES_cblock); cdecl;
  external LIB_CRYPTO name _PU + 'DES_ofb_encrypt';

procedure DES_pcbc_encrypt(input: PByte; output: PByte; length: integer; schedule: PDES_key_schedule; ivec: PDES_cblock; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'DES_pcbc_encrypt';

function DES_quad_cksum(input: PByte; output: PDES_cblock; length: integer; out_count: integer; seed: PDES_cblock): DES_LONG; cdecl;
  external LIB_CRYPTO name _PU + 'DES_quad_cksum';

function DES_random_key(ret: PDES_cblock): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DES_random_key';

procedure DES_set_odd_parity(key: PDES_cblock); cdecl;
  external LIB_CRYPTO name _PU + 'DES_set_odd_parity';
procedure DES_fixup_key_parity(key: PDES_cblock); cdecl;
  external LIB_CRYPTO name _PU + 'DES_set_odd_parity';

function DES_check_key_parity(key: Pconst_DES_cblock): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DES_check_key_parity';

function DES_is_weak_key(key: Pconst_DES_cblock): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DES_is_weak_key';

function DES_set_key(key: Pconst_DES_cblock; schedule: PDES_key_schedule): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DES_set_key';

function DES_key_sched(key: Pconst_DES_cblock; schedule: PDES_key_schedule): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DES_key_sched';

function DES_set_key_checked(key: Pconst_DES_cblock; schedule: PDES_key_schedule): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DES_set_key_checked';

procedure DES_set_key_unchecked(key: Pconst_DES_cblock; schedule: PDES_key_schedule); cdecl;
  external LIB_CRYPTO name _PU + 'DES_set_key_unchecked';

procedure DES_string_to_key(str: PUtf8Char; key: PDES_cblock); cdecl;
  external LIB_CRYPTO name _PU + 'DES_string_to_key';

procedure DES_string_to_2keys(str: PUtf8Char; key1: PDES_cblock; key2: PDES_cblock); cdecl;
  external LIB_CRYPTO name _PU + 'DES_string_to_2keys';

procedure DES_cfb64_encrypt(_in: PByte; _out: PByte; length: integer; schedule: PDES_key_schedule; ivec: PDES_cblock; num: PInteger; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'DES_cfb64_encrypt';

procedure DES_ofb64_encrypt(_in: PByte; _out: PByte; length: integer; schedule: PDES_key_schedule; ivec: PDES_cblock; num: PInteger); cdecl;
  external LIB_CRYPTO name _PU + 'DES_ofb64_encrypt';

function _openssl_ebcdic2ascii(dest: pointer; srce: pointer; count: PtrUInt): pointer; cdecl;
  external LIB_CRYPTO name _PU + '_openssl_ebcdic2ascii';

function _openssl_ascii2ebcdic(dest: pointer; srce: pointer; count: PtrUInt): pointer; cdecl;
  external LIB_CRYPTO name _PU + '_openssl_ascii2ebcdic';

function ERR_load_RAND_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_RAND_strings';

function RAND_set_rand_method(meth: PRAND_METHOD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_set_rand_method';

function RAND_get_rand_method(): PRAND_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_get_rand_method';

function RAND_set_rand_engine(engine: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_set_rand_engine';

function RAND_OpenSSL(): PRAND_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_OpenSSL';

function RAND_priv_bytes(buf: PByte; num: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_priv_bytes';

function RAND_pseudo_bytes(buf: PByte; num: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_pseudo_bytes';

procedure RAND_seed(buf: pointer; num: integer); cdecl;
  external LIB_CRYPTO name _PU + 'RAND_seed';

procedure RAND_keep_random_devices_open(keep: integer); cdecl;
  external LIB_CRYPTO name _PU + 'RAND_keep_random_devices_open';

procedure RAND_add(buf: pointer; num: integer; randomness: Double); cdecl;
  external LIB_CRYPTO name _PU + 'RAND_add';

function RAND_load_file(_file: PUtf8Char; max_bytes: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_load_file';

function RAND_write_file(_file: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_write_file';

function RAND_file_name(_file: PUtf8Char; num: PtrUInt): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_file_name';

function RAND_status(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_status';

function RAND_poll(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_poll';

function ERR_load_PEM_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_PEM_strings';

function PEM_get_EVP_CIPHER_INFO(header: PUtf8Char; cipher: PEVP_CIPHER_INFO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_get_EVP_CIPHER_INFO';

function PEM_do_header(cipher: PEVP_CIPHER_INFO; data: PByte; len: PInteger; callback: Ppem_password_cb; u: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_do_header';

function PEM_read_bio(bp: PBIO; name: PPUtf8Char; header: PPUtf8Char; data: PPByte; len: PInteger): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_bio';

function PEM_read_bio_ex(bp: PBIO; name: PPUtf8Char; header: PPUtf8Char; data: PPByte; len: PInteger; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_bio_ex';

function PEM_bytes_read_bio_secmem(pdata: PPByte; plen: PInteger; pnm: PPUtf8Char; name: PUtf8Char; bp: PBIO; cb: Ppem_password_cb; u: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_bytes_read_bio_secmem';

function PEM_write_bio(bp: PBIO; name: PUtf8Char; hdr: PUtf8Char; data: PByte; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_bio';

function PEM_bytes_read_bio(pdata: PPByte; plen: PInteger; pnm: PPUtf8Char; name: PUtf8Char; bp: PBIO; cb: Ppem_password_cb; u: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_bytes_read_bio';

function PEM_ASN1_read_bio(d2i: Pd2i_of_void; name: PUtf8Char; bp: PBIO; x: PPointer; cb: Ppem_password_cb; u: pointer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_ASN1_read_bio';

function PEM_ASN1_write_bio(i2d: Pi2d_of_void; name: PUtf8Char; bp: PBIO; x: pointer; enc: PEVP_CIPHER; kstr: PByte; klen: integer; cb: Ppem_password_cb; u: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_ASN1_write_bio';

function PEM_X509_INFO_read_bio(bp: PBIO; sk: Pstack_st_X509_INFO; cb: Ppem_password_cb; u: pointer): Pstack_st_X509_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_X509_INFO_read_bio';

function PEM_X509_INFO_write_bio(bp: PBIO; xi: PX509_INFO; enc: PEVP_CIPHER; kstr: PByte; klen: integer; cd: Ppem_password_cb; u: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_X509_INFO_write_bio';

function PEM_read(fp: PPointer; name: PPUtf8Char; header: PPUtf8Char; data: PPByte; len: PInteger): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read';

function PEM_write(fp: PPointer; name: PUtf8Char; hdr: PUtf8Char; data: PByte; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write';

function PEM_ASN1_read(d2i: Pd2i_of_void; name: PUtf8Char; fp: PPointer; x: PPointer; cb: Ppem_password_cb; u: pointer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_ASN1_read';

function PEM_ASN1_write(i2d: Pi2d_of_void; name: PUtf8Char; fp: PPointer; x: pointer; enc: PEVP_CIPHER; kstr: PByte; klen: integer; callback: Ppem_password_cb; u: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_ASN1_write';

function PEM_X509_INFO_read(fp: PPointer; sk: Pstack_st_X509_INFO; cb: Ppem_password_cb; u: pointer): Pstack_st_X509_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_X509_INFO_read';

function PEM_SignInit(ctx: PEVP_MD_CTX; typ: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_SignInit';

function PEM_SignUpdate(ctx: PEVP_MD_CTX; d: PByte; cnt: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_SignUpdate';

function PEM_SignFinal(ctx: PEVP_MD_CTX; sigret: PByte; siglen: PCardinal; pkey: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_SignFinal';

function PEM_def_callback(buf: PUtf8Char; num: integer; rwflag: integer; userdata: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_def_callback';

procedure PEM_proc_type(buf: PUtf8Char; typ: integer); cdecl;
  external LIB_CRYPTO name _PU + 'PEM_proc_type';

procedure PEM_dek_info(buf: PUtf8Char; typ: PUtf8Char; len: integer; str: PUtf8Char); cdecl;
  external LIB_CRYPTO name _PU + 'PEM_dek_info';

function PEM_read_X509(fp: PPointer; x: PPX509; cb: Ppem_password_cb; u: pointer): PX509; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_X509';

function PEM_write_X509(fp: PPointer; x: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_X509';

function PEM_read_X509_AUX(fp: PPointer; x: PPX509; cb: Ppem_password_cb; u: pointer): PX509; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_X509_AUX';

function PEM_write_bio_X509_AUX(bp: PBIO; x: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_bio_X509_AUX';

function PEM_write_X509_AUX(fp: PPointer; x: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_X509_AUX';

function PEM_read_bio_X509_REQ(bp: PBIO; x: PPX509_REQ; cb: Ppem_password_cb; u: pointer): PX509_REQ; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_bio_X509_REQ';

function PEM_read_X509_REQ(fp: PPointer; x: PPX509_REQ; cb: Ppem_password_cb; u: pointer): PX509_REQ; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_X509_REQ';

function PEM_write_X509_REQ(fp: PPointer; x: PX509_REQ): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_X509_REQ';

function PEM_write_bio_X509_REQ_NEW(bp: PBIO; x: PX509_REQ): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_bio_X509_REQ_NEW';

function PEM_write_X509_REQ_NEW(fp: PPointer; x: PX509_REQ): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_X509_REQ_NEW';

function PEM_read_X509_CRL(fp: PPointer; x: PPX509_CRL; cb: Ppem_password_cb; u: pointer): PX509_CRL; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_X509_CRL';

function PEM_write_X509_CRL(fp: PPointer; x: PX509_CRL): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_X509_CRL';

function PEM_read_bio_PKCS7(bp: PBIO; x: PPPKCS7; cb: Ppem_password_cb; u: pointer): PPKCS7; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_bio_PKCS7';

function PEM_read_PKCS7(fp: PPointer; x: PPPKCS7; cb: Ppem_password_cb; u: pointer): PPKCS7; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_PKCS7';

function PEM_write_bio_PKCS7(bp: PBIO; x: PPKCS7): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_bio_PKCS7';

function PEM_write_PKCS7(fp: PPointer; x: PPKCS7): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_PKCS7';

function PEM_read_bio_NETSCAPE_CERT_SEQUENCE(bp: PBIO; x: PPNETSCAPE_CERT_SEQUENCE; cb: Ppem_password_cb; u: pointer): PNETSCAPE_CERT_SEQUENCE; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_bio_NETSCAPE_CERT_SEQUENCE';

function PEM_read_NETSCAPE_CERT_SEQUENCE(fp: PPointer; x: PPNETSCAPE_CERT_SEQUENCE; cb: Ppem_password_cb; u: pointer): PNETSCAPE_CERT_SEQUENCE; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_NETSCAPE_CERT_SEQUENCE';

function PEM_write_bio_NETSCAPE_CERT_SEQUENCE(bp: PBIO; x: PNETSCAPE_CERT_SEQUENCE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_bio_NETSCAPE_CERT_SEQUENCE';

function PEM_write_NETSCAPE_CERT_SEQUENCE(fp: PPointer; x: PNETSCAPE_CERT_SEQUENCE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_NETSCAPE_CERT_SEQUENCE';

function PEM_read_bio_PKCS8(bp: PBIO; x: PPX509_SIG; cb: Ppem_password_cb; u: pointer): PX509_SIG; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_bio_PKCS8';

function PEM_read_PKCS8(fp: PPointer; x: PPX509_SIG; cb: Ppem_password_cb; u: pointer): PX509_SIG; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_PKCS8';

function PEM_write_bio_PKCS8(bp: PBIO; x: PX509_SIG): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_bio_PKCS8';

function PEM_write_PKCS8(fp: PPointer; x: PX509_SIG): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_PKCS8';

function PEM_read_bio_PKCS8_PRIV_KEY_INFO(bp: PBIO; x: PPPKCS8_PRIV_KEY_INFO; cb: Ppem_password_cb; u: pointer): PPKCS8_PRIV_KEY_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_bio_PKCS8_PRIV_KEY_INFO';

function PEM_read_PKCS8_PRIV_KEY_INFO(fp: PPointer; x: PPPKCS8_PRIV_KEY_INFO; cb: Ppem_password_cb; u: pointer): PPKCS8_PRIV_KEY_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_PKCS8_PRIV_KEY_INFO';

function PEM_write_bio_PKCS8_PRIV_KEY_INFO(bp: PBIO; x: PPKCS8_PRIV_KEY_INFO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_bio_PKCS8_PRIV_KEY_INFO';

function PEM_write_PKCS8_PRIV_KEY_INFO(fp: PPointer; x: PPKCS8_PRIV_KEY_INFO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_PKCS8_PRIV_KEY_INFO';

function PEM_read_RSAPrivateKey(fp: PPointer; x: PPRSA; cb: Ppem_password_cb; u: pointer): PRSA; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_RSAPrivateKey';

function PEM_write_bio_RSAPrivateKey(bp: PBIO; x: PRSA; enc: PEVP_CIPHER; kstr: PByte; klen: integer; cb: Ppem_password_cb; u: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_bio_RSAPrivateKey';

function PEM_write_RSAPrivateKey(fp: PPointer; x: PRSA; enc: PEVP_CIPHER; kstr: PByte; klen: integer; cb: Ppem_password_cb; u: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_RSAPrivateKey';

function PEM_read_RSAPublicKey(fp: PPointer; x: PPRSA; cb: Ppem_password_cb; u: pointer): PRSA; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_RSAPublicKey';

function PEM_write_bio_RSAPublicKey(bp: PBIO; x: PRSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_bio_RSAPublicKey';

function PEM_write_RSAPublicKey(fp: PPointer; x: PRSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_RSAPublicKey';

function PEM_read_bio_RSA_PUBKEY(bp: PBIO; x: PPRSA; cb: Ppem_password_cb; u: pointer): PRSA; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_bio_RSA_PUBKEY';

function PEM_read_RSA_PUBKEY(fp: PPointer; x: PPRSA; cb: Ppem_password_cb; u: pointer): PRSA; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_RSA_PUBKEY';

function PEM_write_bio_RSA_PUBKEY(bp: PBIO; x: PRSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_bio_RSA_PUBKEY';

function PEM_write_RSA_PUBKEY(fp: PPointer; x: PRSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_RSA_PUBKEY';

function PEM_read_bio_DSAPrivateKey(bp: PBIO; x: PPDSA; cb: Ppem_password_cb; u: pointer): PDSA; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_bio_DSAPrivateKey';

function PEM_read_DSAPrivateKey(fp: PPointer; x: PPDSA; cb: Ppem_password_cb; u: pointer): PDSA; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_DSAPrivateKey';

function PEM_write_bio_DSAPrivateKey(bp: PBIO; x: PDSA; enc: PEVP_CIPHER; kstr: PByte; klen: integer; cb: Ppem_password_cb; u: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_bio_DSAPrivateKey';

function PEM_write_DSAPrivateKey(fp: PPointer; x: PDSA; enc: PEVP_CIPHER; kstr: PByte; klen: integer; cb: Ppem_password_cb; u: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_DSAPrivateKey';

function PEM_read_bio_DSA_PUBKEY(bp: PBIO; x: PPDSA; cb: Ppem_password_cb; u: pointer): PDSA; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_bio_DSA_PUBKEY';

function PEM_read_DSA_PUBKEY(fp: PPointer; x: PPDSA; cb: Ppem_password_cb; u: pointer): PDSA; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_DSA_PUBKEY';

function PEM_write_bio_DSA_PUBKEY(bp: PBIO; x: PDSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_bio_DSA_PUBKEY';

function PEM_write_DSA_PUBKEY(fp: PPointer; x: PDSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_DSA_PUBKEY';

function PEM_read_bio_DSAparams(bp: PBIO; x: PPDSA; cb: Ppem_password_cb; u: pointer): PDSA; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_bio_DSAparams';

function PEM_read_DSAparams(fp: PPointer; x: PPDSA; cb: Ppem_password_cb; u: pointer): PDSA; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_DSAparams';

function PEM_write_bio_DSAparams(bp: PBIO; x: PDSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_bio_DSAparams';

function PEM_write_DSAparams(fp: PPointer; x: PDSA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_DSAparams';

function PEM_read_bio_ECPKParameters(bp: PBIO; x: PPEC_GROUP; cb: Ppem_password_cb; u: pointer): PEC_GROUP; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_bio_ECPKParameters';

function PEM_read_ECPKParameters(fp: PPointer; x: PPEC_GROUP; cb: Ppem_password_cb; u: pointer): PEC_GROUP; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_ECPKParameters';

function PEM_write_bio_ECPKParameters(bp: PBIO; x: PEC_GROUP): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_bio_ECPKParameters';

function PEM_write_ECPKParameters(fp: PPointer; x: PEC_GROUP): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_ECPKParameters';

function PEM_read_bio_ECPrivateKey(bp: PBIO; x: PPEC_KEY; cb: Ppem_password_cb; u: pointer): PEC_KEY; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_bio_ECPrivateKey';

function PEM_read_ECPrivateKey(fp: PPointer; x: PPEC_KEY; cb: Ppem_password_cb; u: pointer): PEC_KEY; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_ECPrivateKey';

function PEM_write_bio_ECPrivateKey(bp: PBIO; x: PEC_KEY; enc: PEVP_CIPHER; kstr: PByte; klen: integer; cb: Ppem_password_cb; u: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_bio_ECPrivateKey';

function PEM_write_ECPrivateKey(fp: PPointer; x: PEC_KEY; enc: PEVP_CIPHER; kstr: PByte; klen: integer; cb: Ppem_password_cb; u: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_ECPrivateKey';

function PEM_read_bio_EC_PUBKEY(bp: PBIO; x: PPEC_KEY; cb: Ppem_password_cb; u: pointer): PEC_KEY; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_bio_EC_PUBKEY';

function PEM_read_EC_PUBKEY(fp: PPointer; x: PPEC_KEY; cb: Ppem_password_cb; u: pointer): PEC_KEY; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_EC_PUBKEY';

function PEM_write_bio_EC_PUBKEY(bp: PBIO; x: PEC_KEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_bio_EC_PUBKEY';

function PEM_write_EC_PUBKEY(fp: PPointer; x: PEC_KEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_EC_PUBKEY';

function PEM_read_bio_DHparams(bp: PBIO; x: PPDH; cb: Ppem_password_cb; u: pointer): PDH; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_bio_DHparams';

function PEM_read_DHparams(fp: PPointer; x: PPDH; cb: Ppem_password_cb; u: pointer): PDH; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_DHparams';

function PEM_write_bio_DHparams(bp: PBIO; x: PDH): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_bio_DHparams';

function PEM_write_DHparams(fp: PPointer; x: PDH): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_DHparams';

function PEM_write_bio_DHxparams(bp: PBIO; x: PDH): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_bio_DHxparams';

function PEM_write_DHxparams(fp: PPointer; x: PDH): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_DHxparams';

function PEM_read_PrivateKey(fp: PPointer; x: PPEVP_PKEY; cb: Ppem_password_cb; u: pointer): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_PrivateKey';

function PEM_write_PrivateKey(fp: PPointer; x: PEVP_PKEY; enc: PEVP_CIPHER; kstr: PByte; klen: integer; cb: Ppem_password_cb; u: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_PrivateKey';

function PEM_read_PUBKEY(fp: PPointer; x: PPEVP_PKEY; cb: Ppem_password_cb; u: pointer): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_PUBKEY';

function PEM_write_PUBKEY(fp: PPointer; x: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_PUBKEY';

function PEM_write_bio_PrivateKey_traditional(bp: PBIO; x: PEVP_PKEY; enc: PEVP_CIPHER; kstr: PByte; klen: integer; cb: Ppem_password_cb; u: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_bio_PrivateKey_traditional';

function PEM_write_bio_PKCS8PrivateKey_nid(bp: PBIO; x: PEVP_PKEY; nid: integer; kstr: PUtf8Char; klen: integer; cb: Ppem_password_cb; u: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_bio_PKCS8PrivateKey_nid';

function i2d_PKCS8PrivateKey_nid_bio(bp: PBIO; x: PEVP_PKEY; nid: integer; kstr: PUtf8Char; klen: integer; cb: Ppem_password_cb; u: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS8PrivateKey_nid_bio';

function i2d_PKCS8PrivateKey_fp(fp: PPointer; x: PEVP_PKEY; enc: PEVP_CIPHER; kstr: PUtf8Char; klen: integer; cb: Ppem_password_cb; u: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS8PrivateKey_fp';

function i2d_PKCS8PrivateKey_nid_fp(fp: PPointer; x: PEVP_PKEY; nid: integer; kstr: PUtf8Char; klen: integer; cb: Ppem_password_cb; u: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS8PrivateKey_nid_fp';

function PEM_write_PKCS8PrivateKey_nid(fp: PPointer; x: PEVP_PKEY; nid: integer; kstr: PUtf8Char; klen: integer; cb: Ppem_password_cb; u: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_PKCS8PrivateKey_nid';

function d2i_PKCS8PrivateKey_fp(fp: PPointer; x: PPEVP_PKEY; cb: Ppem_password_cb; u: pointer): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PKCS8PrivateKey_fp';

function PEM_write_PKCS8PrivateKey(fp: PPointer; x: PEVP_PKEY; enc: PEVP_CIPHER; kstr: PUtf8Char; klen: integer; cd: Ppem_password_cb; u: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_PKCS8PrivateKey';

function PEM_read_bio_Parameters(bp: PBIO; x: PPEVP_PKEY): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_read_bio_Parameters';

function PEM_write_bio_Parameters(bp: PBIO; x: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PEM_write_bio_Parameters';

function b2i_PrivateKey(_in: PPByte; length: integer): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'b2i_PrivateKey';

function b2i_PublicKey(_in: PPByte; length: integer): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'b2i_PublicKey';

function b2i_PrivateKey_bio(_in: PBIO): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'b2i_PrivateKey_bio';

function b2i_PublicKey_bio(_in: PBIO): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'b2i_PublicKey_bio';

function i2b_PrivateKey_bio(_out: PBIO; pk: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2b_PrivateKey_bio';

function i2b_PublicKey_bio(_out: PBIO; pk: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2b_PublicKey_bio';

function b2i_PVK_bio(_in: PBIO; cb: Ppem_password_cb; u: pointer): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'b2i_PVK_bio';

function i2b_PVK_bio(_out: PBIO; pk: PEVP_PKEY; enclevel: integer; cb: Ppem_password_cb; u: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2b_PVK_bio';

function ERR_load_UI_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_UI_strings';

function UI_new(): PUI; cdecl;
  external LIB_CRYPTO name _PU + 'UI_new';

function UI_new_method(method: PUI_METHOD): PUI; cdecl;
  external LIB_CRYPTO name _PU + 'UI_new_method';

procedure UI_free(ui: PUI); cdecl;
  external LIB_CRYPTO name _PU + 'UI_free';

function UI_add_input_string(ui: PUI; prompt: PUtf8Char; flags: integer; result_buf: PUtf8Char; minsize: integer; maxsize: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_add_input_string';

function UI_dup_input_string(ui: PUI; prompt: PUtf8Char; flags: integer; result_buf: PUtf8Char; minsize: integer; maxsize: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_dup_input_string';

function UI_add_verify_string(ui: PUI; prompt: PUtf8Char; flags: integer; result_buf: PUtf8Char; minsize: integer; maxsize: integer; test_buf: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_add_verify_string';

function UI_dup_verify_string(ui: PUI; prompt: PUtf8Char; flags: integer; result_buf: PUtf8Char; minsize: integer; maxsize: integer; test_buf: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_dup_verify_string';

function UI_add_input_boolean(ui: PUI; prompt: PUtf8Char; action_desc: PUtf8Char; ok_chars: PUtf8Char; cancel_chars: PUtf8Char; flags: integer; result_buf: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_add_input_boolean';

function UI_dup_input_boolean(ui: PUI; prompt: PUtf8Char; action_desc: PUtf8Char; ok_chars: PUtf8Char; cancel_chars: PUtf8Char; flags: integer; result_buf: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_dup_input_boolean';

function UI_add_info_string(ui: PUI; text: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_add_info_string';

function UI_dup_info_string(ui: PUI; text: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_dup_info_string';

function UI_add_error_string(ui: PUI; text: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_add_error_string';

function UI_dup_error_string(ui: PUI; text: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_dup_error_string';

function UI_construct_prompt(ui_method: PUI; object_desc: PUtf8Char; object_name: PUtf8Char): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'UI_construct_prompt';

function UI_add_user_data(ui: PUI; user_data: pointer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_add_user_data';

function UI_dup_user_data(ui: PUI; user_data: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_dup_user_data';

function UI_get0_user_data(ui: PUI): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_get0_user_data';

function UI_get0_result(ui: PUI; i: integer): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'UI_get0_result';

function UI_get_result_length(ui: PUI; i: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_get_result_length';

function UI_process(ui: PUI): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_process';

function UI_ctrl(ui: PUI; cmd: integer; i: integer; p: pointer; f: UI_ctrl_f): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_ctrl';

function UI_set_ex_data(r: PUI; idx: integer; arg: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_set_ex_data';

function UI_get_ex_data(r: PUI; idx: integer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_get_ex_data';

procedure UI_set_default_method(meth: PUI_METHOD); cdecl;
  external LIB_CRYPTO name _PU + 'UI_set_default_method';

function UI_get_default_method(): PUI_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'UI_get_default_method';

function UI_get_method(ui: PUI): PUI_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'UI_get_method';

function UI_set_method(ui: PUI; meth: PUI_METHOD): PUI_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'UI_set_method';

function UI_OpenSSL(): PUI_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'UI_OpenSSL';

function UI_null(): PUI_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'UI_null';

function UI_create_method(name: PUtf8Char): PUI_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'UI_create_method';

procedure UI_destroy_method(ui_method: PUI_METHOD); cdecl;
  external LIB_CRYPTO name _PU + 'UI_destroy_method';

function UI_method_set_opener(method: PUI_METHOD; opener: UI_method_set_opener_opener): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_method_set_opener';

function UI_method_set_writer(method: PUI_METHOD; writer: UI_method_set_writer_writer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_method_set_writer';

function UI_method_set_flusher(method: PUI_METHOD; flusher: UI_method_set_flusher_flusher): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_method_set_flusher';

function UI_method_set_reader(method: PUI_METHOD; reader: UI_method_set_reader_reader): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_method_set_reader';

function UI_method_set_closer(method: PUI_METHOD; closer: UI_method_set_closer_closer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_method_set_closer';

function UI_method_set_data_duplicator(method: PUI_METHOD; duplicator: UI_method_set_data_duplicator_duplicator; _destructor: UI_method_set_data_duplicator_destructor): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_method_set_data_duplicator';

function UI_method_set_prompt_constructor(method: PUI_METHOD; prompt_constructor: UI_method_set_prompt_constructor_prompt_constructor): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_method_set_prompt_constructor';

function UI_method_set_ex_data(method: PUI_METHOD; idx: integer; data: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_method_set_ex_data';

//function UI_method_get_opener(p1: PUImethod: PUI_METHOD): integer { TODO : Cannot convert original type "int (*)(UI *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'UI_method_get_opener';

//function UI_method_get_writer(p1: PUIp2: PUI_STRINGmethod: PUI_METHOD): integer { TODO : Cannot convert original type "int (*)(UI *, UI_STRING *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'UI_method_get_writer';

//function UI_method_get_flusher(p1: PUImethod: PUI_METHOD): integer { TODO : Cannot convert original type "int (*)(UI *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'UI_method_get_flusher';

//function UI_method_get_reader(p1: PUIp2: PUI_STRINGmethod: PUI_METHOD): integer { TODO : Cannot convert original type "int (*)(UI *, UI_STRING *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'UI_method_get_reader';

//function UI_method_get_closer(p1: PUImethod: PUI_METHOD): integer { TODO : Cannot convert original type "int (*)(UI *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'UI_method_get_closer';

//function UI_method_get_prompt_constructor(p1: PUIp2: PUTF8Charp3: PUTF8Charmethod: PUI_METHOD): integer { TODO : Cannot convert original type "char *(*)(UI *, const char *, const char *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'UI_method_get_prompt_constructor';

//function UI_method_get_data_duplicator(p1: PUIp2: Pointermethod: PUI_METHOD): integer { TODO : Cannot convert original type "void *(*)(UI *, void *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'UI_method_get_data_duplicator';

//function UI_method_get_data_destructor(p1: PUIp2: Pointermethod: PUI_METHOD): integer { TODO : Cannot convert original type "void (*)(UI *, void *)" }; cdecl;
//  external LIB_CRYPTO name _PU + 'UI_method_get_data_destructor';

function UI_method_get_ex_data(method: PUI_METHOD; idx: integer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_method_get_ex_data';

function UI_get_string_type(uis: PUI_STRING): UI_string_types; cdecl;
  external LIB_CRYPTO name _PU + 'UI_get_string_type';

function UI_get_input_flags(uis: PUI_STRING): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_get_input_flags';

function UI_get0_output_string(uis: PUI_STRING): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'UI_get0_output_string';

function UI_get0_action_string(uis: PUI_STRING): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'UI_get0_action_string';

function UI_get0_result_string(uis: PUI_STRING): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'UI_get0_result_string';

function UI_get_result_string_length(uis: PUI_STRING): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_get_result_string_length';

function UI_get0_test_string(uis: PUI_STRING): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'UI_get0_test_string';

function UI_get_result_minsize(uis: PUI_STRING): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_get_result_minsize';

function UI_get_result_maxsize(uis: PUI_STRING): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_get_result_maxsize';

function UI_set_result(ui: PUI; uis: PUI_STRING; result: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_set_result';

function UI_set_result_ex(ui: PUI; uis: PUI_STRING; result: PUtf8Char; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_set_result_ex';

function UI_UTIL_read_pw_string(buf: PUtf8Char; length: integer; prompt: PUtf8Char; verify: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_UTIL_read_pw_string';

function UI_UTIL_read_pw(buf: PUtf8Char; buff: PUtf8Char; size: integer; prompt: PUtf8Char; verify: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'UI_UTIL_read_pw';

function UI_UTIL_wrap_read_pem_callback(cb: Ppem_password_cb; rwflag: integer): PUI_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'UI_UTIL_wrap_read_pem_callback';

procedure ERR_put_error(lib: integer; func: integer; reason: integer; _file: PUtf8Char; line: integer); cdecl;
  external LIB_CRYPTO name _PU + 'ERR_put_error';

procedure ERR_set_error_data(data: PUtf8Char; flags: integer); cdecl;
  external LIB_CRYPTO name _PU + 'ERR_set_error_data';

function ERR_get_error_line(_file: PPUtf8Char; line: PInteger): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_get_error_line';

function ERR_get_error_line_data(_file: PPUtf8Char; line: PInteger; data: PPUtf8Char; flags: PInteger): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_get_error_line_data';

function ERR_peek_error(): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_peek_error';

function ERR_peek_error_line(_file: PPUtf8Char; line: PInteger): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_peek_error_line';

function ERR_peek_error_line_data(_file: PPUtf8Char; line: PInteger; data: PPUtf8Char; flags: PInteger): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_peek_error_line_data';

function ERR_peek_last_error(): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_peek_last_error';

function ERR_peek_last_error_line(_file: PPUtf8Char; line: PInteger): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_peek_last_error_line';

function ERR_peek_last_error_line_data(_file: PPUtf8Char; line: PInteger; data: PPUtf8Char; flags: PInteger): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_peek_last_error_line_data';

procedure ERR_clear_error(); cdecl;
  external LIB_CRYPTO name _PU + 'ERR_clear_error';

function ERR_error_string(e: cardinal; buf: PUtf8Char): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_error_string';

function ERR_lib_error_string(e: cardinal): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_lib_error_string';

function ERR_func_error_string(e: cardinal): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_func_error_string';

function ERR_reason_error_string(e: cardinal): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_reason_error_string';

procedure ERR_print_errors_cb(cb: ERR_print_errors_cb_cb; u: pointer); cdecl;
  external LIB_CRYPTO name _PU + 'ERR_print_errors_cb';

procedure ERR_print_errors_fp(fp: PPointer); cdecl;
  external LIB_CRYPTO name _PU + 'ERR_print_errors_fp';

procedure ERR_print_errors(bp: PBIO); cdecl;
  external LIB_CRYPTO name _PU + 'ERR_print_errors';

procedure ERR_add_error_data(num: integer) varargs; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_add_error_data';

procedure ERR_add_error_vdata(num: integer; args: pointer); cdecl;
  external LIB_CRYPTO name _PU + 'ERR_add_error_vdata';

function ERR_load_strings(lib: integer; str: PERR_STRING_DATA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_strings';

function ERR_load_strings_const(str: PERR_STRING_DATA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_strings_const';

function ERR_unload_strings(lib: integer; str: PERR_STRING_DATA): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_unload_strings';

function ERR_load_ERR_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_ERR_strings';

function ERR_get_state(): PERR_STATE; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_get_state';

function ERR_get_next_error_library(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_get_next_error_library';

function ERR_set_mark(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_set_mark';

function ERR_pop_to_mark(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_pop_to_mark';

function ERR_clear_last_mark(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_clear_last_mark';

function ERR_load_ENGINE_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_ENGINE_strings';

function ENGINE_get_first(): PENGINE; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_first';

function ENGINE_get_last(): PENGINE; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_last';

function ENGINE_get_next(e: PENGINE): PENGINE; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_next';

function ENGINE_get_prev(e: PENGINE): PENGINE; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_prev';

function ENGINE_add(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_add';

function ENGINE_remove(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_remove';

function ENGINE_by_id(id: PUtf8Char): PENGINE; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_by_id';

procedure ENGINE_load_builtin_engines(); cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_load_builtin_engines';

function ENGINE_get_table_flags(): cardinal; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_table_flags';

procedure ENGINE_set_table_flags(flags: cardinal); cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_table_flags';

function ENGINE_register_RSA(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_register_RSA';

procedure ENGINE_unregister_RSA(e: PENGINE); cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_unregister_RSA';

procedure ENGINE_register_all_RSA(); cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_register_all_RSA';

function ENGINE_register_DSA(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_register_DSA';

procedure ENGINE_unregister_DSA(e: PENGINE); cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_unregister_DSA';

procedure ENGINE_register_all_DSA(); cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_register_all_DSA';

function ENGINE_register_EC(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_register_EC';

procedure ENGINE_unregister_EC(e: PENGINE); cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_unregister_EC';

procedure ENGINE_register_all_EC(); cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_register_all_EC';

function ENGINE_register_DH(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_register_DH';

procedure ENGINE_unregister_DH(e: PENGINE); cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_unregister_DH';

procedure ENGINE_register_all_DH(); cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_register_all_DH';

function ENGINE_register_RAND(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_register_RAND';

procedure ENGINE_unregister_RAND(e: PENGINE); cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_unregister_RAND';

procedure ENGINE_register_all_RAND(); cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_register_all_RAND';

function ENGINE_register_ciphers(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_register_ciphers';

procedure ENGINE_unregister_ciphers(e: PENGINE); cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_unregister_ciphers';

procedure ENGINE_register_all_ciphers(); cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_register_all_ciphers';

function ENGINE_register_digests(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_register_digests';

procedure ENGINE_unregister_digests(e: PENGINE); cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_unregister_digests';

procedure ENGINE_register_all_digests(); cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_register_all_digests';

function ENGINE_register_pkey_meths(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_register_pkey_meths';

procedure ENGINE_unregister_pkey_meths(e: PENGINE); cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_unregister_pkey_meths';

procedure ENGINE_register_all_pkey_meths(); cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_register_all_pkey_meths';

function ENGINE_register_pkey_asn1_meths(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_register_pkey_asn1_meths';

procedure ENGINE_unregister_pkey_asn1_meths(e: PENGINE); cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_unregister_pkey_asn1_meths';

procedure ENGINE_register_all_pkey_asn1_meths(); cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_register_all_pkey_asn1_meths';

function ENGINE_register_complete(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_register_complete';

function ENGINE_register_all_complete(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_register_all_complete';

function ENGINE_ctrl(e: PENGINE; cmd: integer; i: integer; p: pointer; f: ENGINE_ctrl_f): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_ctrl';

function ENGINE_cmd_is_executable(e: PENGINE; cmd: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_cmd_is_executable';

function ENGINE_ctrl_cmd(e: PENGINE; cmd_name: PUtf8Char; i: integer; p: pointer; f: ENGINE_ctrl_cmd_f; cmd_optional: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_ctrl_cmd';

function ENGINE_ctrl_cmd_string(e: PENGINE; cmd_name: PUtf8Char; arg: PUtf8Char; cmd_optional: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_ctrl_cmd_string';

function ENGINE_new(): PENGINE; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_new';

function ENGINE_free(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_free';

function ENGINE_up_ref(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_up_ref';

function ENGINE_set_id(e: PENGINE; id: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_id';

function ENGINE_set_name(e: PENGINE; name: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_name';

function ENGINE_set_RSA(e: PENGINE; rsa_meth: PRSA_METHOD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_RSA';

function ENGINE_set_DSA(e: PENGINE; dsa_meth: PDSA_METHOD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_DSA';

function ENGINE_set_EC(e: PENGINE; ecdsa_meth: PEC_KEY_METHOD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_EC';

function ENGINE_set_DH(e: PENGINE; dh_meth: PDH_METHOD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_DH';

function ENGINE_set_RAND(e: PENGINE; rand_meth: PRAND_METHOD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_RAND';

function ENGINE_set_destroy_function(e: PENGINE; destroy_f: ENGINE_GEN_INT_FUNC_PTR): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_destroy_function';

function ENGINE_set_init_function(e: PENGINE; init_f: ENGINE_GEN_INT_FUNC_PTR): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_init_function';

function ENGINE_set_finish_function(e: PENGINE; finish_f: ENGINE_GEN_INT_FUNC_PTR): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_finish_function';

function ENGINE_set_ctrl_function(e: PENGINE; ctrl_f: ENGINE_CTRL_FUNC_PTR): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_ctrl_function';

function ENGINE_set_load_privkey_function(e: PENGINE; loadpriv_f: ENGINE_LOAD_KEY_PTR): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_load_privkey_function';

function ENGINE_set_load_pubkey_function(e: PENGINE; loadpub_f: ENGINE_LOAD_KEY_PTR): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_load_pubkey_function';

function ENGINE_set_load_ssl_client_cert_function(e: PENGINE; loadssl_f: ENGINE_SSL_CLIENT_CERT_PTR): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_load_ssl_client_cert_function';

function ENGINE_set_ciphers(e: PENGINE; f: ENGINE_CIPHERS_PTR): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_ciphers';

function ENGINE_set_digests(e: PENGINE; f: ENGINE_DIGESTS_PTR): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_digests';

function ENGINE_set_pkey_meths(e: PENGINE; f: ENGINE_PKEY_METHS_PTR): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_pkey_meths';

function ENGINE_set_pkey_asn1_meths(e: PENGINE; f: ENGINE_PKEY_ASN1_METHS_PTR): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_pkey_asn1_meths';

function ENGINE_set_flags(e: PENGINE; flags: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_flags';

function ENGINE_set_cmd_defns(e: PENGINE; defns: PENGINE_CMD_DEFN): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_cmd_defns';

function ENGINE_set_ex_data(e: PENGINE; idx: integer; arg: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_ex_data';

function ENGINE_get_ex_data(e: PENGINE; idx: integer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_ex_data';

function ENGINE_get_id(e: PENGINE): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_id';

function ENGINE_get_name(e: PENGINE): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_name';

function ENGINE_get_RSA(e: PENGINE): PRSA_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_RSA';

function ENGINE_get_DSA(e: PENGINE): PDSA_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_DSA';

function ENGINE_get_EC(e: PENGINE): PEC_KEY_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_EC';

function ENGINE_get_DH(e: PENGINE): PDH_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_DH';

function ENGINE_get_RAND(e: PENGINE): PRAND_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_RAND';

function ENGINE_get_destroy_function(e: PENGINE): ENGINE_GEN_INT_FUNC_PTR; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_destroy_function';

function ENGINE_get_init_function(e: PENGINE): ENGINE_GEN_INT_FUNC_PTR; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_init_function';

function ENGINE_get_finish_function(e: PENGINE): ENGINE_GEN_INT_FUNC_PTR; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_finish_function';

function ENGINE_get_ctrl_function(e: PENGINE): ENGINE_CTRL_FUNC_PTR; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_ctrl_function';

function ENGINE_get_load_privkey_function(e: PENGINE): ENGINE_LOAD_KEY_PTR; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_load_privkey_function';

function ENGINE_get_load_pubkey_function(e: PENGINE): ENGINE_LOAD_KEY_PTR; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_load_pubkey_function';

function ENGINE_get_ssl_client_cert_function(e: PENGINE): ENGINE_SSL_CLIENT_CERT_PTR; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_ssl_client_cert_function';

function ENGINE_get_ciphers(e: PENGINE): ENGINE_CIPHERS_PTR; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_ciphers';

function ENGINE_get_digests(e: PENGINE): ENGINE_DIGESTS_PTR; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_digests';

function ENGINE_get_pkey_meths(e: PENGINE): ENGINE_PKEY_METHS_PTR; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_pkey_meths';

function ENGINE_get_pkey_asn1_meths(e: PENGINE): ENGINE_PKEY_ASN1_METHS_PTR; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_pkey_asn1_meths';

function ENGINE_get_cipher(e: PENGINE; nid: integer): PEVP_CIPHER; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_cipher';

function ENGINE_get_digest(e: PENGINE; nid: integer): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_digest';

function ENGINE_get_pkey_meth(e: PENGINE; nid: integer): PEVP_PKEY_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_pkey_meth';

function ENGINE_get_pkey_asn1_meth(e: PENGINE; nid: integer): PEVP_PKEY_ASN1_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_pkey_asn1_meth';

function ENGINE_get_pkey_asn1_meth_str(e: PENGINE; str: PUtf8Char; len: integer): PEVP_PKEY_ASN1_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_pkey_asn1_meth_str';

function ENGINE_pkey_asn1_find_str(pe: PPENGINE; str: PUtf8Char; len: integer): PEVP_PKEY_ASN1_METHOD; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_pkey_asn1_find_str';

function ENGINE_get_cmd_defns(e: PENGINE): PENGINE_CMD_DEFN; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_cmd_defns';

function ENGINE_get_flags(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_flags';

function ENGINE_init(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_init';

function ENGINE_finish(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_finish';

function ENGINE_load_private_key(e: PENGINE; key_id: PUtf8Char; ui_method: PUI_METHOD; callback_data: pointer): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_load_private_key';

function ENGINE_load_public_key(e: PENGINE; key_id: PUtf8Char; ui_method: PUI_METHOD; callback_data: pointer): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_load_public_key';

function ENGINE_load_ssl_client_cert(e: PENGINE; s: PSSL; ca_dn: Pstack_st_X509_NAME; pcert: PPX509; ppkey: PPEVP_PKEY; pother: PPstack_st_X509; ui_method: PUI_METHOD; callback_data: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_load_ssl_client_cert';

function ENGINE_get_default_RSA(): PENGINE; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_default_RSA';

function ENGINE_get_default_DSA(): PENGINE; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_default_DSA';

function ENGINE_get_default_EC(): PENGINE; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_default_EC';

function ENGINE_get_default_DH(): PENGINE; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_default_DH';

function ENGINE_get_default_RAND(): PENGINE; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_default_RAND';

function ENGINE_get_cipher_engine(nid: integer): PENGINE; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_cipher_engine';

function ENGINE_get_digest_engine(nid: integer): PENGINE; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_digest_engine';

function ENGINE_get_pkey_meth_engine(nid: integer): PENGINE; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_pkey_meth_engine';

function ENGINE_get_pkey_asn1_meth_engine(nid: integer): PENGINE; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_pkey_asn1_meth_engine';

function ENGINE_set_default_RSA(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_default_RSA';

function ENGINE_set_default_string(e: PENGINE; def_list: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_default_string';

function ENGINE_set_default_DSA(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_default_DSA';

function ENGINE_set_default_EC(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_default_EC';

function ENGINE_set_default_DH(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_default_DH';

function ENGINE_set_default_RAND(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_default_RAND';

function ENGINE_set_default_ciphers(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_default_ciphers';

function ENGINE_set_default_digests(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_default_digests';

function ENGINE_set_default_pkey_meths(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_default_pkey_meths';

function ENGINE_set_default_pkey_asn1_meths(e: PENGINE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_default_pkey_asn1_meths';

function ENGINE_set_default(e: PENGINE; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_set_default';

procedure ENGINE_add_conf_module(); cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_add_conf_module';

function ENGINE_get_static_state(): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'ENGINE_get_static_state';

function HMAC_size(e: PHMAC_CTX): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'HMAC_size';

function HMAC_CTX_reset(ctx: PHMAC_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'HMAC_CTX_reset';

function HMAC_Init(ctx: PHMAC_CTX; key: pointer; len: integer; md: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'HMAC_Init';

function HMAC_CTX_copy(dctx: PHMAC_CTX; sctx: PHMAC_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'HMAC_CTX_copy';

procedure HMAC_CTX_set_flags(ctx: PHMAC_CTX; flags: cardinal); cdecl;
  external LIB_CRYPTO name _PU + 'HMAC_CTX_set_flags';

function HMAC_CTX_get_md(ctx: PHMAC_CTX): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'HMAC_CTX_get_md';

function IDEA_options(): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'IDEA_options';

procedure IDEA_ecb_encrypt(_in: PByte; _out: PByte; ks: PIDEA_KEY_SCHEDULE); cdecl;
  external LIB_CRYPTO name _PU + 'IDEA_ecb_encrypt';

procedure IDEA_set_encrypt_key(key: PByte; ks: PIDEA_KEY_SCHEDULE); cdecl;
  external LIB_CRYPTO name _PU + 'IDEA_set_encrypt_key';

procedure IDEA_set_decrypt_key(ek: PIDEA_KEY_SCHEDULE; dk: PIDEA_KEY_SCHEDULE); cdecl;
  external LIB_CRYPTO name _PU + 'IDEA_set_decrypt_key';

procedure IDEA_cbc_encrypt(_in: PByte; _out: PByte; length: integer; ks: PIDEA_KEY_SCHEDULE; iv: PByte; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'IDEA_cbc_encrypt';

procedure IDEA_cfb64_encrypt(_in: PByte; _out: PByte; length: integer; ks: PIDEA_KEY_SCHEDULE; iv: PByte; num: PInteger; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'IDEA_cfb64_encrypt';

procedure IDEA_ofb64_encrypt(_in: PByte; _out: PByte; length: integer; ks: PIDEA_KEY_SCHEDULE; iv: PByte; num: PInteger); cdecl;
  external LIB_CRYPTO name _PU + 'IDEA_ofb64_encrypt';

procedure IDEA_encrypt(_in: PCardinal; ks: PIDEA_KEY_SCHEDULE); cdecl;
  external LIB_CRYPTO name _PU + 'IDEA_encrypt';

function ERR_load_KDF_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_KDF_strings';

function MD4_Init(c: PMD4_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'MD4_Init';

function MD4_Update(c: PMD4_CTX; data: pointer; len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'MD4_Update';

function MD4_Final(md: PByte; c: PMD4_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'MD4_Final';

function MD4(d: PByte; n: PtrUInt; md: PByte): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'MD4';

procedure MD4_Transform(c: PMD4_CTX; b: PByte); cdecl;
  external LIB_CRYPTO name _PU + 'MD4_Transform';

function MD5_Init(c: PMD5_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'MD5_Init';

function MD5_Update(c: PMD5_CTX; data: pointer; len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'MD5_Update';

function MD5_Final(md: PByte; c: PMD5_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'MD5_Final';

function MD5(d: PByte; n: PtrUInt; md: PByte): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'MD5';

procedure MD5_Transform(c: PMD5_CTX; b: PByte); cdecl;
  external LIB_CRYPTO name _PU + 'MD5_Transform';

function MDC2_Init(c: PMDC2_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'MDC2_Init';

function MDC2_Update(c: PMDC2_CTX; data: PByte; len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'MDC2_Update';

function MDC2_Final(md: PByte; c: PMDC2_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'MDC2_Final';

function MDC2(d: PByte; n: PtrUInt; md: PByte): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'MDC2';

procedure CRYPTO_cbc128_encrypt(_in: PByte; _out: PByte; len: PtrUInt; key: pointer; ivec: PByte; block: block128_f); cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_cbc128_encrypt';

procedure CRYPTO_cbc128_decrypt(_in: PByte; _out: PByte; len: PtrUInt; key: pointer; ivec: PByte; block: block128_f); cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_cbc128_decrypt';

procedure CRYPTO_ctr128_encrypt(_in: PByte; _out: PByte; len: PtrUInt; key: pointer; ivec: PByte; ecount_buf: PByte; num: PCardinal; block: block128_f); cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_ctr128_encrypt';

procedure CRYPTO_ctr128_encrypt_ctr32(_in: PByte; _out: PByte; len: PtrUInt; key: pointer; ivec: PByte; ecount_buf: PByte; num: PCardinal; ctr: ctr128_f); cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_ctr128_encrypt_ctr32';

procedure CRYPTO_ofb128_encrypt(_in: PByte; _out: PByte; len: PtrUInt; key: pointer; ivec: PByte; num: PInteger; block: block128_f); cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_ofb128_encrypt';

procedure CRYPTO_cfb128_encrypt(_in: PByte; _out: PByte; len: PtrUInt; key: pointer; ivec: PByte; num: PInteger; enc: integer; block: block128_f); cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_cfb128_encrypt';

procedure CRYPTO_cfb128_8_encrypt(_in: PByte; _out: PByte; length: PtrUInt; key: pointer; ivec: PByte; num: PInteger; enc: integer; block: block128_f); cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_cfb128_8_encrypt';

procedure CRYPTO_cfb128_1_encrypt(_in: PByte; _out: PByte; bits: PtrUInt; key: pointer; ivec: PByte; num: PInteger; enc: integer; block: block128_f); cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_cfb128_1_encrypt';

function CRYPTO_cts128_encrypt_block(_in: PByte; _out: PByte; len: PtrUInt; key: pointer; ivec: PByte; block: block128_f): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_cts128_encrypt_block';

function CRYPTO_cts128_encrypt(_in: PByte; _out: PByte; len: PtrUInt; key: pointer; ivec: PByte; cbc: cbc128_f): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_cts128_encrypt';

function CRYPTO_cts128_decrypt_block(_in: PByte; _out: PByte; len: PtrUInt; key: pointer; ivec: PByte; block: block128_f): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_cts128_decrypt_block';

function CRYPTO_cts128_decrypt(_in: PByte; _out: PByte; len: PtrUInt; key: pointer; ivec: PByte; cbc: cbc128_f): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_cts128_decrypt';

function CRYPTO_nistcts128_encrypt_block(_in: PByte; _out: PByte; len: PtrUInt; key: pointer; ivec: PByte; block: block128_f): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_nistcts128_encrypt_block';

function CRYPTO_nistcts128_encrypt(_in: PByte; _out: PByte; len: PtrUInt; key: pointer; ivec: PByte; cbc: cbc128_f): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_nistcts128_encrypt';

function CRYPTO_nistcts128_decrypt_block(_in: PByte; _out: PByte; len: PtrUInt; key: pointer; ivec: PByte; block: block128_f): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_nistcts128_decrypt_block';

function CRYPTO_nistcts128_decrypt(_in: PByte; _out: PByte; len: PtrUInt; key: pointer; ivec: PByte; cbc: cbc128_f): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_nistcts128_decrypt';

function CRYPTO_gcm128_new(key: pointer; block: block128_f): PGCM128_CONTEXT; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_gcm128_new';

procedure CRYPTO_gcm128_init(ctx: PGCM128_CONTEXT; key: pointer; block: block128_f); cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_gcm128_init';

procedure CRYPTO_gcm128_setiv(ctx: PGCM128_CONTEXT; iv: PByte; len: PtrUInt); cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_gcm128_setiv';

function CRYPTO_gcm128_aad(ctx: PGCM128_CONTEXT; aad: PByte; len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_gcm128_aad';

function CRYPTO_gcm128_encrypt(ctx: PGCM128_CONTEXT; _in: PByte; _out: PByte; len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_gcm128_encrypt';

function CRYPTO_gcm128_decrypt(ctx: PGCM128_CONTEXT; _in: PByte; _out: PByte; len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_gcm128_decrypt';

function CRYPTO_gcm128_encrypt_ctr32(ctx: PGCM128_CONTEXT; _in: PByte; _out: PByte; len: PtrUInt; stream: ctr128_f): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_gcm128_encrypt_ctr32';

function CRYPTO_gcm128_decrypt_ctr32(ctx: PGCM128_CONTEXT; _in: PByte; _out: PByte; len: PtrUInt; stream: ctr128_f): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_gcm128_decrypt_ctr32';

function CRYPTO_gcm128_finish(ctx: PGCM128_CONTEXT; tag: PByte; len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_gcm128_finish';

procedure CRYPTO_gcm128_tag(ctx: PGCM128_CONTEXT; tag: PByte; len: PtrUInt); cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_gcm128_tag';

procedure CRYPTO_gcm128_release(ctx: PGCM128_CONTEXT); cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_gcm128_release';

procedure CRYPTO_ccm128_init(ctx: PCCM128_CONTEXT; M: cardinal; L: cardinal; key: pointer; block: block128_f); cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_ccm128_init';

function CRYPTO_ccm128_setiv(ctx: PCCM128_CONTEXT; nonce: PByte; nlen: PtrUInt; mlen: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_ccm128_setiv';

procedure CRYPTO_ccm128_aad(ctx: PCCM128_CONTEXT; aad: PByte; alen: PtrUInt); cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_ccm128_aad';

function CRYPTO_ccm128_encrypt(ctx: PCCM128_CONTEXT; inp: PByte; _out: PByte; len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_ccm128_encrypt';

function CRYPTO_ccm128_decrypt(ctx: PCCM128_CONTEXT; inp: PByte; _out: PByte; len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_ccm128_decrypt';

function CRYPTO_ccm128_encrypt_ccm64(ctx: PCCM128_CONTEXT; inp: PByte; _out: PByte; len: PtrUInt; stream: ccm128_f): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_ccm128_encrypt_ccm64';

function CRYPTO_ccm128_decrypt_ccm64(ctx: PCCM128_CONTEXT; inp: PByte; _out: PByte; len: PtrUInt; stream: ccm128_f): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_ccm128_decrypt_ccm64';

function CRYPTO_ccm128_tag(ctx: PCCM128_CONTEXT; tag: PByte; len: PtrUInt): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_ccm128_tag';

function CRYPTO_xts128_encrypt(ctx: PXTS128_CONTEXT; iv: PByte; inp: PByte; _out: PByte; len: PtrUInt; enc: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_xts128_encrypt';

function CRYPTO_128_wrap(key: pointer; iv: PByte; _out: PByte; _in: PByte; inlen: PtrUInt; block: block128_f): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_128_wrap';

function CRYPTO_128_unwrap(key: pointer; iv: PByte; _out: PByte; _in: PByte; inlen: PtrUInt; block: block128_f): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_128_unwrap';

function CRYPTO_128_wrap_pad(key: pointer; icv: PByte; _out: PByte; _in: PByte; inlen: PtrUInt; block: block128_f): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_128_wrap_pad';

function CRYPTO_128_unwrap_pad(key: pointer; icv: PByte; _out: PByte; _in: PByte; inlen: PtrUInt; block: block128_f): PtrUInt; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_128_unwrap_pad';

function CRYPTO_ocb128_new(keyenc: pointer; keydec: pointer; encrypt: block128_f; decrypt: block128_f; stream: ocb128_f): POCB128_CONTEXT; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_ocb128_new';

function CRYPTO_ocb128_init(ctx: POCB128_CONTEXT; keyenc: pointer; keydec: pointer; encrypt: block128_f; decrypt: block128_f; stream: ocb128_f): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_ocb128_init';

function CRYPTO_ocb128_copy_ctx(dest: POCB128_CONTEXT; src: POCB128_CONTEXT; keyenc: pointer; keydec: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_ocb128_copy_ctx';

function CRYPTO_ocb128_setiv(ctx: POCB128_CONTEXT; iv: PByte; len: PtrUInt; taglen: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_ocb128_setiv';

function CRYPTO_ocb128_aad(ctx: POCB128_CONTEXT; aad: PByte; len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_ocb128_aad';

function CRYPTO_ocb128_encrypt(ctx: POCB128_CONTEXT; _in: PByte; _out: PByte; len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_ocb128_encrypt';

function CRYPTO_ocb128_decrypt(ctx: POCB128_CONTEXT; _in: PByte; _out: PByte; len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_ocb128_decrypt';

function CRYPTO_ocb128_finish(ctx: POCB128_CONTEXT; tag: PByte; len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_ocb128_finish';

function CRYPTO_ocb128_tag(ctx: POCB128_CONTEXT; tag: PByte; len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_ocb128_tag';

procedure CRYPTO_ocb128_cleanup(ctx: POCB128_CONTEXT); cdecl;
  external LIB_CRYPTO name _PU + 'CRYPTO_ocb128_cleanup';

function ERR_load_OCSP_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_OCSP_strings';

function OCSP_CERTID_dup(id: POCSP_CERTID): POCSP_CERTID; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_CERTID_dup';

function OCSP_sendreq_bio(b: PBIO; path: PUtf8Char; req: POCSP_REQUEST): POCSP_RESPONSE; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_sendreq_bio';

function OCSP_sendreq_new(io: PBIO; path: PUtf8Char; req: POCSP_REQUEST; maxline: integer): POCSP_REQ_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_sendreq_new';

function OCSP_REQ_CTX_nbio(rctx: POCSP_REQ_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REQ_CTX_nbio';

function OCSP_sendreq_nbio(presp: PPOCSP_RESPONSE; rctx: POCSP_REQ_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_sendreq_nbio';

function OCSP_REQ_CTX_new(io: PBIO; maxline: integer): POCSP_REQ_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REQ_CTX_new';

procedure OCSP_REQ_CTX_free(rctx: POCSP_REQ_CTX); cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REQ_CTX_free';

procedure OCSP_set_max_response_length(rctx: POCSP_REQ_CTX; len: cardinal); cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_set_max_response_length';

function OCSP_REQ_CTX_i2d(rctx: POCSP_REQ_CTX; it: PASN1_ITEM; val: PASN1_VALUE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REQ_CTX_i2d';

function OCSP_REQ_CTX_nbio_d2i(rctx: POCSP_REQ_CTX; pval: PPASN1_VALUE; it: PASN1_ITEM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REQ_CTX_nbio_d2i';

function OCSP_REQ_CTX_get0_mem_bio(rctx: POCSP_REQ_CTX): PBIO; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REQ_CTX_get0_mem_bio';

function OCSP_REQ_CTX_http(rctx: POCSP_REQ_CTX; op: PUtf8Char; path: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REQ_CTX_http';

function OCSP_REQ_CTX_set1_req(rctx: POCSP_REQ_CTX; req: POCSP_REQUEST): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REQ_CTX_set1_req';

function OCSP_REQ_CTX_add1_header(rctx: POCSP_REQ_CTX; name: PUtf8Char; value: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REQ_CTX_add1_header';

function OCSP_cert_to_id(dgst: PEVP_MD; subject: PX509; issuer: PX509): POCSP_CERTID; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_cert_to_id';

function OCSP_cert_id_new(dgst: PEVP_MD; issuerName: PX509_NAME; issuerKey: PASN1_BIT_STRING; serialNumber: PASN1_INTEGER): POCSP_CERTID; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_cert_id_new';

function OCSP_request_add0_id(req: POCSP_REQUEST; cid: POCSP_CERTID): POCSP_ONEREQ; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_request_add0_id';

function OCSP_request_add1_nonce(req: POCSP_REQUEST; val: PByte; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_request_add1_nonce';

function OCSP_basic_add1_nonce(resp: POCSP_BASICRESP; val: PByte; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_basic_add1_nonce';

function OCSP_check_nonce(req: POCSP_REQUEST; bs: POCSP_BASICRESP): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_check_nonce';

function OCSP_copy_nonce(resp: POCSP_BASICRESP; req: POCSP_REQUEST): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_copy_nonce';

function OCSP_request_set1_name(req: POCSP_REQUEST; nm: PX509_NAME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_request_set1_name';

function OCSP_request_add1_cert(req: POCSP_REQUEST; cert: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_request_add1_cert';

function OCSP_request_sign(req: POCSP_REQUEST; signer: PX509; key: PEVP_PKEY; dgst: PEVP_MD; certs: Pstack_st_X509; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_request_sign';

function OCSP_response_status(resp: POCSP_RESPONSE): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_response_status';

function OCSP_response_get1_basic(resp: POCSP_RESPONSE): POCSP_BASICRESP; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_response_get1_basic';

function OCSP_resp_get0_signature(bs: POCSP_BASICRESP): PASN1_OCTET_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_resp_get0_signature';

function OCSP_resp_get0_tbs_sigalg(bs: POCSP_BASICRESP): PX509_ALGOR; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_resp_get0_tbs_sigalg';

function OCSP_resp_get0_respdata(bs: POCSP_BASICRESP): POCSP_RESPDATA; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_resp_get0_respdata';

function OCSP_resp_get0_signer(bs: POCSP_BASICRESP; signer: PPX509; extra_certs: Pstack_st_X509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_resp_get0_signer';

function OCSP_resp_count(bs: POCSP_BASICRESP): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_resp_count';

function OCSP_resp_get0(bs: POCSP_BASICRESP; idx: integer): POCSP_SINGLERESP; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_resp_get0';

function OCSP_resp_get0_produced_at(bs: POCSP_BASICRESP): PASN1_GENERALIZEDTIME; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_resp_get0_produced_at';

function OCSP_resp_get0_certs(bs: POCSP_BASICRESP): Pstack_st_X509; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_resp_get0_certs';

function OCSP_resp_get0_id(bs: POCSP_BASICRESP; pid: PPASN1_OCTET_STRING; pname: PPX509_NAME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_resp_get0_id';

function OCSP_resp_get1_id(bs: POCSP_BASICRESP; pid: PPASN1_OCTET_STRING; pname: PPX509_NAME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_resp_get1_id';

function OCSP_resp_find(bs: POCSP_BASICRESP; id: POCSP_CERTID; last: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_resp_find';

function OCSP_single_get0_status(single: POCSP_SINGLERESP; reason: PInteger; revtime: PPASN1_GENERALIZEDTIME; thisupd: PPASN1_GENERALIZEDTIME; nextupd: PPASN1_GENERALIZEDTIME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_single_get0_status';

function OCSP_resp_find_status(bs: POCSP_BASICRESP; id: POCSP_CERTID; status: PInteger; reason: PInteger; revtime: PPASN1_GENERALIZEDTIME; thisupd: PPASN1_GENERALIZEDTIME; nextupd: PPASN1_GENERALIZEDTIME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_resp_find_status';

function OCSP_check_validity(thisupd: PASN1_GENERALIZEDTIME; nextupd: PASN1_GENERALIZEDTIME; sec: integer; maxsec: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_check_validity';

function OCSP_request_verify(req: POCSP_REQUEST; certs: Pstack_st_X509; store: PX509_STORE; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_request_verify';

function OCSP_parse_url(url: PUtf8Char; phost: PPUtf8Char; pport: PPUtf8Char; ppath: PPUtf8Char; pssl: PInteger): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_parse_url';

function OCSP_id_issuer_cmp(a: POCSP_CERTID; b: POCSP_CERTID): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_id_issuer_cmp';

function OCSP_id_cmp(a: POCSP_CERTID; b: POCSP_CERTID): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_id_cmp';

function OCSP_request_onereq_count(req: POCSP_REQUEST): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_request_onereq_count';

function OCSP_request_onereq_get0(req: POCSP_REQUEST; i: integer): POCSP_ONEREQ; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_request_onereq_get0';

function OCSP_onereq_get0_id(one: POCSP_ONEREQ): POCSP_CERTID; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_onereq_get0_id';

function OCSP_id_get0_info(piNameHash: PPASN1_OCTET_STRING; pmd: PPASN1_OBJECT; pikeyHash: PPASN1_OCTET_STRING; pserial: PPASN1_INTEGER; cid: POCSP_CERTID): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_id_get0_info';

function OCSP_request_is_signed(req: POCSP_REQUEST): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_request_is_signed';

function OCSP_response_create(status: integer; bs: POCSP_BASICRESP): POCSP_RESPONSE; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_response_create';

function OCSP_basic_add1_status(rsp: POCSP_BASICRESP; cid: POCSP_CERTID; status: integer; reason: integer; revtime: PASN1_TIME; thisupd: PASN1_TIME; nextupd: PASN1_TIME): POCSP_SINGLERESP; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_basic_add1_status';

function OCSP_basic_add1_cert(resp: POCSP_BASICRESP; cert: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_basic_add1_cert';

function OCSP_basic_sign(brsp: POCSP_BASICRESP; signer: PX509; key: PEVP_PKEY; dgst: PEVP_MD; certs: Pstack_st_X509; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_basic_sign';

function OCSP_basic_sign_ctx(brsp: POCSP_BASICRESP; signer: PX509; ctx: PEVP_MD_CTX; certs: Pstack_st_X509; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_basic_sign_ctx';

function OCSP_RESPID_set_by_name(respid: POCSP_RESPID; cert: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_RESPID_set_by_name';

function OCSP_RESPID_set_by_key(respid: POCSP_RESPID; cert: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_RESPID_set_by_key';

function OCSP_RESPID_match(respid: POCSP_RESPID; cert: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_RESPID_match';

function OCSP_crlID_new(url: PUtf8Char; n: PInteger; tim: PUtf8Char): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_crlID_new';

function OCSP_accept_responses_new(oids: PPUtf8Char): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_accept_responses_new';

function OCSP_archive_cutoff_new(tim: PUtf8Char): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_archive_cutoff_new';

function OCSP_url_svcloc_new(issuer: PX509_NAME; urls: PPUtf8Char): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_url_svcloc_new';

function OCSP_REQUEST_get_ext_count(x: POCSP_REQUEST): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REQUEST_get_ext_count';

function OCSP_REQUEST_get_ext_by_NID(x: POCSP_REQUEST; nid: integer; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REQUEST_get_ext_by_NID';

function OCSP_REQUEST_get_ext_by_OBJ(x: POCSP_REQUEST; obj: PASN1_OBJECT; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REQUEST_get_ext_by_OBJ';

function OCSP_REQUEST_get_ext_by_critical(x: POCSP_REQUEST; crit: integer; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REQUEST_get_ext_by_critical';

function OCSP_REQUEST_get_ext(x: POCSP_REQUEST; loc: integer): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REQUEST_get_ext';

function OCSP_REQUEST_delete_ext(x: POCSP_REQUEST; loc: integer): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REQUEST_delete_ext';

function OCSP_REQUEST_get1_ext_d2i(x: POCSP_REQUEST; nid: integer; crit: PInteger; idx: PInteger): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REQUEST_get1_ext_d2i';

function OCSP_REQUEST_add1_ext_i2d(x: POCSP_REQUEST; nid: integer; value: pointer; crit: integer; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REQUEST_add1_ext_i2d';

function OCSP_REQUEST_add_ext(x: POCSP_REQUEST; ex: PX509_EXTENSION; loc: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REQUEST_add_ext';

function OCSP_ONEREQ_get_ext_count(x: POCSP_ONEREQ): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_ONEREQ_get_ext_count';

function OCSP_ONEREQ_get_ext_by_NID(x: POCSP_ONEREQ; nid: integer; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_ONEREQ_get_ext_by_NID';

function OCSP_ONEREQ_get_ext_by_OBJ(x: POCSP_ONEREQ; obj: PASN1_OBJECT; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_ONEREQ_get_ext_by_OBJ';

function OCSP_ONEREQ_get_ext_by_critical(x: POCSP_ONEREQ; crit: integer; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_ONEREQ_get_ext_by_critical';

function OCSP_ONEREQ_get_ext(x: POCSP_ONEREQ; loc: integer): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_ONEREQ_get_ext';

function OCSP_ONEREQ_delete_ext(x: POCSP_ONEREQ; loc: integer): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_ONEREQ_delete_ext';

function OCSP_ONEREQ_get1_ext_d2i(x: POCSP_ONEREQ; nid: integer; crit: PInteger; idx: PInteger): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_ONEREQ_get1_ext_d2i';

function OCSP_ONEREQ_add1_ext_i2d(x: POCSP_ONEREQ; nid: integer; value: pointer; crit: integer; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_ONEREQ_add1_ext_i2d';

function OCSP_ONEREQ_add_ext(x: POCSP_ONEREQ; ex: PX509_EXTENSION; loc: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_ONEREQ_add_ext';

function OCSP_BASICRESP_get_ext_count(x: POCSP_BASICRESP): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_BASICRESP_get_ext_count';

function OCSP_BASICRESP_get_ext_by_NID(x: POCSP_BASICRESP; nid: integer; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_BASICRESP_get_ext_by_NID';

function OCSP_BASICRESP_get_ext_by_OBJ(x: POCSP_BASICRESP; obj: PASN1_OBJECT; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_BASICRESP_get_ext_by_OBJ';

function OCSP_BASICRESP_get_ext_by_critical(x: POCSP_BASICRESP; crit: integer; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_BASICRESP_get_ext_by_critical';

function OCSP_BASICRESP_get_ext(x: POCSP_BASICRESP; loc: integer): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_BASICRESP_get_ext';

function OCSP_BASICRESP_delete_ext(x: POCSP_BASICRESP; loc: integer): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_BASICRESP_delete_ext';

function OCSP_BASICRESP_get1_ext_d2i(x: POCSP_BASICRESP; nid: integer; crit: PInteger; idx: PInteger): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_BASICRESP_get1_ext_d2i';

function OCSP_BASICRESP_add1_ext_i2d(x: POCSP_BASICRESP; nid: integer; value: pointer; crit: integer; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_BASICRESP_add1_ext_i2d';

function OCSP_BASICRESP_add_ext(x: POCSP_BASICRESP; ex: PX509_EXTENSION; loc: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_BASICRESP_add_ext';

function OCSP_SINGLERESP_get_ext_count(x: POCSP_SINGLERESP): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_SINGLERESP_get_ext_count';

function OCSP_SINGLERESP_get_ext_by_NID(x: POCSP_SINGLERESP; nid: integer; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_SINGLERESP_get_ext_by_NID';

function OCSP_SINGLERESP_get_ext_by_OBJ(x: POCSP_SINGLERESP; obj: PASN1_OBJECT; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_SINGLERESP_get_ext_by_OBJ';

function OCSP_SINGLERESP_get_ext_by_critical(x: POCSP_SINGLERESP; crit: integer; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_SINGLERESP_get_ext_by_critical';

function OCSP_SINGLERESP_get_ext(x: POCSP_SINGLERESP; loc: integer): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_SINGLERESP_get_ext';

function OCSP_SINGLERESP_delete_ext(x: POCSP_SINGLERESP; loc: integer): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_SINGLERESP_delete_ext';

function OCSP_SINGLERESP_get1_ext_d2i(x: POCSP_SINGLERESP; nid: integer; crit: PInteger; idx: PInteger): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_SINGLERESP_get1_ext_d2i';

function OCSP_SINGLERESP_add1_ext_i2d(x: POCSP_SINGLERESP; nid: integer; value: pointer; crit: integer; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_SINGLERESP_add1_ext_i2d';

function OCSP_SINGLERESP_add_ext(x: POCSP_SINGLERESP; ex: PX509_EXTENSION; loc: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_SINGLERESP_add_ext';

function OCSP_SINGLERESP_get0_id(x: POCSP_SINGLERESP): POCSP_CERTID; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_SINGLERESP_get0_id';

function OCSP_SINGLERESP_new(): POCSP_SINGLERESP; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_SINGLERESP_new';

procedure OCSP_SINGLERESP_free(a: POCSP_SINGLERESP); cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_SINGLERESP_free';

function d2i_OCSP_SINGLERESP(a: PPOCSP_SINGLERESP; _in: PPByte; len: integer): POCSP_SINGLERESP; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_OCSP_SINGLERESP';

function i2d_OCSP_SINGLERESP(a: POCSP_SINGLERESP; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_OCSP_SINGLERESP';

function OCSP_SINGLERESP_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_SINGLERESP_it';

function OCSP_CERTSTATUS_new(): POCSP_CERTSTATUS; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_CERTSTATUS_new';

procedure OCSP_CERTSTATUS_free(a: POCSP_CERTSTATUS); cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_CERTSTATUS_free';

function d2i_OCSP_CERTSTATUS(a: PPOCSP_CERTSTATUS; _in: PPByte; len: integer): POCSP_CERTSTATUS; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_OCSP_CERTSTATUS';

function i2d_OCSP_CERTSTATUS(a: POCSP_CERTSTATUS; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_OCSP_CERTSTATUS';

function OCSP_CERTSTATUS_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_CERTSTATUS_it';

function OCSP_REVOKEDINFO_new(): POCSP_REVOKEDINFO; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REVOKEDINFO_new';

procedure OCSP_REVOKEDINFO_free(a: POCSP_REVOKEDINFO); cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REVOKEDINFO_free';

function d2i_OCSP_REVOKEDINFO(a: PPOCSP_REVOKEDINFO; _in: PPByte; len: integer): POCSP_REVOKEDINFO; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_OCSP_REVOKEDINFO';

function i2d_OCSP_REVOKEDINFO(a: POCSP_REVOKEDINFO; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_OCSP_REVOKEDINFO';

function OCSP_REVOKEDINFO_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REVOKEDINFO_it';

function OCSP_BASICRESP_new(): POCSP_BASICRESP; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_BASICRESP_new';

procedure OCSP_BASICRESP_free(a: POCSP_BASICRESP); cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_BASICRESP_free';

function d2i_OCSP_BASICRESP(a: PPOCSP_BASICRESP; _in: PPByte; len: integer): POCSP_BASICRESP; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_OCSP_BASICRESP';

function i2d_OCSP_BASICRESP(a: POCSP_BASICRESP; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_OCSP_BASICRESP';

function OCSP_BASICRESP_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_BASICRESP_it';

function OCSP_RESPDATA_new(): POCSP_RESPDATA; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_RESPDATA_new';

procedure OCSP_RESPDATA_free(a: POCSP_RESPDATA); cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_RESPDATA_free';

function d2i_OCSP_RESPDATA(a: PPOCSP_RESPDATA; _in: PPByte; len: integer): POCSP_RESPDATA; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_OCSP_RESPDATA';

function i2d_OCSP_RESPDATA(a: POCSP_RESPDATA; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_OCSP_RESPDATA';

function OCSP_RESPDATA_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_RESPDATA_it';

function OCSP_RESPID_new(): POCSP_RESPID; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_RESPID_new';

procedure OCSP_RESPID_free(a: POCSP_RESPID); cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_RESPID_free';

function d2i_OCSP_RESPID(a: PPOCSP_RESPID; _in: PPByte; len: integer): POCSP_RESPID; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_OCSP_RESPID';

function i2d_OCSP_RESPID(a: POCSP_RESPID; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_OCSP_RESPID';

function OCSP_RESPID_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_RESPID_it';

function OCSP_RESPONSE_new(): POCSP_RESPONSE; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_RESPONSE_new';

procedure OCSP_RESPONSE_free(a: POCSP_RESPONSE); cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_RESPONSE_free';

function d2i_OCSP_RESPONSE(a: PPOCSP_RESPONSE; _in: PPByte; len: integer): POCSP_RESPONSE; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_OCSP_RESPONSE';

function i2d_OCSP_RESPONSE(a: POCSP_RESPONSE; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_OCSP_RESPONSE';

function OCSP_RESPONSE_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_RESPONSE_it';

function OCSP_RESPBYTES_new(): POCSP_RESPBYTES; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_RESPBYTES_new';

procedure OCSP_RESPBYTES_free(a: POCSP_RESPBYTES); cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_RESPBYTES_free';

function d2i_OCSP_RESPBYTES(a: PPOCSP_RESPBYTES; _in: PPByte; len: integer): POCSP_RESPBYTES; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_OCSP_RESPBYTES';

function i2d_OCSP_RESPBYTES(a: POCSP_RESPBYTES; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_OCSP_RESPBYTES';

function OCSP_RESPBYTES_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_RESPBYTES_it';

function OCSP_ONEREQ_new(): POCSP_ONEREQ; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_ONEREQ_new';

procedure OCSP_ONEREQ_free(a: POCSP_ONEREQ); cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_ONEREQ_free';

function d2i_OCSP_ONEREQ(a: PPOCSP_ONEREQ; _in: PPByte; len: integer): POCSP_ONEREQ; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_OCSP_ONEREQ';

function i2d_OCSP_ONEREQ(a: POCSP_ONEREQ; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_OCSP_ONEREQ';

function OCSP_ONEREQ_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_ONEREQ_it';

function OCSP_CERTID_new(): POCSP_CERTID; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_CERTID_new';

procedure OCSP_CERTID_free(a: POCSP_CERTID); cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_CERTID_free';

function d2i_OCSP_CERTID(a: PPOCSP_CERTID; _in: PPByte; len: integer): POCSP_CERTID; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_OCSP_CERTID';

function i2d_OCSP_CERTID(a: POCSP_CERTID; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_OCSP_CERTID';

function OCSP_CERTID_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_CERTID_it';

function OCSP_REQUEST_new(): POCSP_REQUEST; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REQUEST_new';

procedure OCSP_REQUEST_free(a: POCSP_REQUEST); cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REQUEST_free';

function d2i_OCSP_REQUEST(a: PPOCSP_REQUEST; _in: PPByte; len: integer): POCSP_REQUEST; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_OCSP_REQUEST';

function i2d_OCSP_REQUEST(a: POCSP_REQUEST; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_OCSP_REQUEST';

function OCSP_REQUEST_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REQUEST_it';

function OCSP_SIGNATURE_new(): POCSP_SIGNATURE; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_SIGNATURE_new';

procedure OCSP_SIGNATURE_free(a: POCSP_SIGNATURE); cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_SIGNATURE_free';

function d2i_OCSP_SIGNATURE(a: PPOCSP_SIGNATURE; _in: PPByte; len: integer): POCSP_SIGNATURE; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_OCSP_SIGNATURE';

function i2d_OCSP_SIGNATURE(a: POCSP_SIGNATURE; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_OCSP_SIGNATURE';

function OCSP_SIGNATURE_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_SIGNATURE_it';

function OCSP_REQINFO_new(): POCSP_REQINFO; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REQINFO_new';

procedure OCSP_REQINFO_free(a: POCSP_REQINFO); cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REQINFO_free';

function d2i_OCSP_REQINFO(a: PPOCSP_REQINFO; _in: PPByte; len: integer): POCSP_REQINFO; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_OCSP_REQINFO';

function i2d_OCSP_REQINFO(a: POCSP_REQINFO; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_OCSP_REQINFO';

function OCSP_REQINFO_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REQINFO_it';

//function OCSP_CRLID_new(): POCSP_CRLID; cdecl;
//  external LIB_CRYPTO name _PU + 'OCSP_CRLID_new';

procedure OCSP_CRLID_free(a: POCSP_CRLID); cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_CRLID_free';

function d2i_OCSP_CRLID(a: PPOCSP_CRLID; _in: PPByte; len: integer): POCSP_CRLID; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_OCSP_CRLID';

function i2d_OCSP_CRLID(a: POCSP_CRLID; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_OCSP_CRLID';

function OCSP_CRLID_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_CRLID_it';

function OCSP_SERVICELOC_new(): POCSP_SERVICELOC; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_SERVICELOC_new';

procedure OCSP_SERVICELOC_free(a: POCSP_SERVICELOC); cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_SERVICELOC_free';

function d2i_OCSP_SERVICELOC(a: PPOCSP_SERVICELOC; _in: PPByte; len: integer): POCSP_SERVICELOC; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_OCSP_SERVICELOC';

function i2d_OCSP_SERVICELOC(a: POCSP_SERVICELOC; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_OCSP_SERVICELOC';

function OCSP_SERVICELOC_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_SERVICELOC_it';

function OCSP_response_status_str(s: integer): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_response_status_str';

function OCSP_cert_status_str(s: integer): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_cert_status_str';

function OCSP_crl_reason_str(s: integer): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_crl_reason_str';

function OCSP_REQUEST_print(bp: PBIO; a: POCSP_REQUEST; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_REQUEST_print';

function OCSP_RESPONSE_print(bp: PBIO; o: POCSP_RESPONSE; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_RESPONSE_print';

function OCSP_basic_verify(bs: POCSP_BASICRESP; certs: Pstack_st_X509; st: PX509_STORE; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OCSP_basic_verify';

function ERR_load_PKCS12_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_PKCS12_strings';

function PKCS12_get_attr(bag: PPKCS12_SAFEBAG; attr_nid: integer): PASN1_TYPE; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_get_attr';

function PKCS8_get_attr(p8: PPKCS8_PRIV_KEY_INFO; attr_nid: integer): PASN1_TYPE; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS8_get_attr';

function PKCS12_mac_present(p12: PPKCS12): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_mac_present';

procedure PKCS12_get0_mac(pmac: PPASN1_OCTET_STRING; pmacalg: PPX509_ALGOR; psalt: PPASN1_OCTET_STRING; piter: PPASN1_INTEGER; p12: PPKCS12); cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_get0_mac';

function PKCS12_SAFEBAG_get0_attr(bag: PPKCS12_SAFEBAG; attr_nid: integer): PASN1_TYPE; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_get0_attr';

function PKCS12_SAFEBAG_get0_type(bag: PPKCS12_SAFEBAG): PASN1_OBJECT; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_get0_type';

function PKCS12_SAFEBAG_get_nid(bag: PPKCS12_SAFEBAG): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_get_nid';

function PKCS12_bag_type(bag: PPKCS12_SAFEBAG): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_get_nid';

function M_PKCS12_bag_type(bag: PPKCS12_SAFEBAG): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_get_nid';

function PKCS12_SAFEBAG_get_bag_nid(bag: PPKCS12_SAFEBAG): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_get_bag_nid';

function M_PKCS12_crl_bag_type(bag: PPKCS12_SAFEBAG): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_get_bag_nid';

function PKCS12_cert_bag_type(bag: PPKCS12_SAFEBAG): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_get_bag_nid';

function PKCS12_SAFEBAG_get1_cert(bag: PPKCS12_SAFEBAG): PX509; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_get1_cert';

function PKCS12_certbag2x509(bag: PPKCS12_SAFEBAG): PX509; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_get1_cert';

function PKCS12_SAFEBAG_get1_crl(bag: PPKCS12_SAFEBAG): PX509_CRL; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_get1_crl';

function PKCS12_certbag2scrl(bag: PPKCS12_SAFEBAG): PX509_CRL; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_get1_crl';

function PKCS12_SAFEBAG_get0_safes(bag: PPKCS12_SAFEBAG): Pstack_st_PKCS12_SAFEBAG; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_get0_safes';

function PKCS12_SAFEBAG_get0_p8inf(bag: PPKCS12_SAFEBAG): PPKCS8_PRIV_KEY_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_get0_p8inf';

function PKCS12_SAFEBAG_get0_pkcs8(bag: PPKCS12_SAFEBAG): PX509_SIG; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_get0_pkcs8';

function PKCS12_SAFEBAG_create_cert(x509: PX509): PPKCS12_SAFEBAG; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_create_cert';

function PKCS12_x5092certbag(x509: PX509): PPKCS12_SAFEBAG; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_create_cert';

function PKCS12_SAFEBAG_create_crl(crl: PX509_CRL): PPKCS12_SAFEBAG; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_create_crl';

function PKCS12_x509crl2certbag(crl: PX509_CRL): PPKCS12_SAFEBAG; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_create_crl';

function PKCS12_SAFEBAG_create0_p8inf(p8: PPKCS8_PRIV_KEY_INFO): PPKCS12_SAFEBAG; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_create0_p8inf';

function PKCS12_SAFEBAG_create0_pkcs8(p8: PX509_SIG): PPKCS12_SAFEBAG; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_create0_pkcs8';

function PKCS12_SAFEBAG_create_pkcs8_encrypt(pbe_nid: integer; pass: PUtf8Char; passlen: integer; salt: PByte; saltlen: integer; iter: integer; p8inf: PPKCS8_PRIV_KEY_INFO): PPKCS12_SAFEBAG; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_create_pkcs8_encrypt';

function PKCS12_MAKE_SHKEYBAG(pbe_nid: integer; pass: PUtf8Char; passlen: integer; salt: PByte; saltlen: integer; iter: integer; p8inf: PPKCS8_PRIV_KEY_INFO): PPKCS12_SAFEBAG; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_create_pkcs8_encrypt';

function PKCS12_item_pack_safebag(obj: pointer; it: PASN1_ITEM; nid1: integer; nid2: integer): PPKCS12_SAFEBAG; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_item_pack_safebag';

function PKCS8_decrypt(p8: PX509_SIG; pass: PUtf8Char; passlen: integer): PPKCS8_PRIV_KEY_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS8_decrypt';

function PKCS12_decrypt_skey(bag: PPKCS12_SAFEBAG; pass: PUtf8Char; passlen: integer): PPKCS8_PRIV_KEY_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_decrypt_skey';

function PKCS8_encrypt(pbe_nid: integer; cipher: PEVP_CIPHER; pass: PUtf8Char; passlen: integer; salt: PByte; saltlen: integer; iter: integer; p8: PPKCS8_PRIV_KEY_INFO): PX509_SIG; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS8_encrypt';

function PKCS8_set0_pbe(pass: PUtf8Char; passlen: integer; p8inf: PPKCS8_PRIV_KEY_INFO; pbe: PX509_ALGOR): PX509_SIG; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS8_set0_pbe';

function PKCS12_pack_p7data(sk: Pstack_st_PKCS12_SAFEBAG): PPKCS7; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_pack_p7data';

function PKCS12_unpack_p7data(p7: PPKCS7): Pstack_st_PKCS12_SAFEBAG; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_unpack_p7data';

function PKCS12_pack_p7encdata(pbe_nid: integer; pass: PUtf8Char; passlen: integer; salt: PByte; saltlen: integer; iter: integer; bags: Pstack_st_PKCS12_SAFEBAG): PPKCS7; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_pack_p7encdata';

function PKCS12_unpack_p7encdata(p7: PPKCS7; pass: PUtf8Char; passlen: integer): Pstack_st_PKCS12_SAFEBAG; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_unpack_p7encdata';

function PKCS12_pack_authsafes(p12: PPKCS12; safes: Pstack_st_PKCS7): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_pack_authsafes';

function PKCS12_unpack_authsafes(p12: PPKCS12): Pstack_st_PKCS7; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_unpack_authsafes';

function PKCS12_add_localkeyid(bag: PPKCS12_SAFEBAG; name: PByte; namelen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_add_localkeyid';

function PKCS12_add_friendlyname_asc(bag: PPKCS12_SAFEBAG; name: PUtf8Char; namelen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_add_friendlyname_asc';

function PKCS12_add_friendlyname_utf8(bag: PPKCS12_SAFEBAG; name: PUtf8Char; namelen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_add_friendlyname_utf8';

function PKCS12_add_friendlyname(bag: PPKCS12_SAFEBAG; name: PUtf8Char; namelen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_add_friendlyname_utf8';

function PKCS12_add_CSPName_asc(bag: PPKCS12_SAFEBAG; name: PUtf8Char; namelen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_add_CSPName_asc';

function PKCS12_add_friendlyname_uni(bag: PPKCS12_SAFEBAG; name: PByte; namelen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_add_friendlyname_uni';

function PKCS8_add_keyusage(p8: PPKCS8_PRIV_KEY_INFO; usage: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS8_add_keyusage';

function PKCS12_get_attr_gen(attrs: Pstack_st_X509_ATTRIBUTE; attr_nid: integer): PASN1_TYPE; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_get_attr_gen';

function PKCS12_get_friendlyname(bag: PPKCS12_SAFEBAG): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_get_friendlyname';

function PKCS12_SAFEBAG_get0_attrs(bag: PPKCS12_SAFEBAG): Pstack_st_X509_ATTRIBUTE; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_get0_attrs';

function PKCS12_pbe_crypt(algor: PX509_ALGOR; pass: PUtf8Char; passlen: integer; _in: PByte; inlen: integer; data: PPByte; datalen: PInteger; en_de: integer): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_pbe_crypt';

function PKCS12_item_decrypt_d2i(algor: PX509_ALGOR; it: PASN1_ITEM; pass: PUtf8Char; passlen: integer; oct: PASN1_OCTET_STRING; zbuf: integer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_item_decrypt_d2i';

function PKCS12_item_i2d_encrypt(algor: PX509_ALGOR; it: PASN1_ITEM; pass: PUtf8Char; passlen: integer; obj: pointer; zbuf: integer): PASN1_OCTET_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_item_i2d_encrypt';

function PKCS12_init(mode: integer): PPKCS12; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_init';

function PKCS12_key_gen_asc(pass: PUtf8Char; passlen: integer; salt: PByte; saltlen: integer; id: integer; iter: integer; n: integer; _out: PByte; md_type: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_key_gen_asc';

function PKCS12_key_gen_uni(pass: PByte; passlen: integer; salt: PByte; saltlen: integer; id: integer; iter: integer; n: integer; _out: PByte; md_type: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_key_gen_uni';

function PKCS12_key_gen_utf8(pass: PUtf8Char; passlen: integer; salt: PByte; saltlen: integer; id: integer; iter: integer; n: integer; _out: PByte; md_type: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_key_gen_utf8';

function PKCS12_key_gen(pass: PUtf8Char; passlen: integer; salt: PByte; saltlen: integer; id: integer; iter: integer; n: integer; _out: PByte; md_type: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_key_gen_utf8';

function PKCS12_PBE_keyivgen(ctx: PEVP_CIPHER_CTX; pass: PUtf8Char; passlen: integer; param: PASN1_TYPE; cipher: PEVP_CIPHER; md_type: PEVP_MD; en_de: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_PBE_keyivgen';

function PKCS12_gen_mac(p12: PPKCS12; pass: PUtf8Char; passlen: integer; mac: PByte; maclen: PCardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_gen_mac';

function PKCS12_verify_mac(p12: PPKCS12; pass: PUtf8Char; passlen: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_verify_mac';

function PKCS12_set_mac(p12: PPKCS12; pass: PUtf8Char; passlen: integer; salt: PByte; saltlen: integer; iter: integer; md_type: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_set_mac';

function PKCS12_setup_mac(p12: PPKCS12; iter: integer; salt: PByte; saltlen: integer; md_type: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_setup_mac';

function OPENSSL_asc2uni(asc: PUtf8Char; asclen: integer; uni: PPByte; unilen: PInteger): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_asc2uni';

function OPENSSL_uni2asc(uni: PByte; unilen: integer): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_uni2asc';

function OPENSSL_utf82uni(asc: PUtf8Char; asclen: integer; uni: PPByte; unilen: PInteger): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_utf82uni';

function OPENSSL_uni2utf8(uni: PByte; unilen: integer): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'OPENSSL_uni2utf8';

function PKCS12_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_it';

function PKCS12_MAC_DATA_new(): PPKCS12_MAC_DATA; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_MAC_DATA_new';

procedure PKCS12_MAC_DATA_free(a: PPKCS12_MAC_DATA); cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_MAC_DATA_free';

function d2i_PKCS12_MAC_DATA(a: PPPKCS12_MAC_DATA; _in: PPByte; len: integer): PPKCS12_MAC_DATA; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PKCS12_MAC_DATA';

function i2d_PKCS12_MAC_DATA(a: PPKCS12_MAC_DATA; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS12_MAC_DATA';

function PKCS12_MAC_DATA_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_MAC_DATA_it';

function PKCS12_SAFEBAG_new(): PPKCS12_SAFEBAG; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_new';

procedure PKCS12_SAFEBAG_free(a: PPKCS12_SAFEBAG); cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_free';

function d2i_PKCS12_SAFEBAG(a: PPPKCS12_SAFEBAG; _in: PPByte; len: integer): PPKCS12_SAFEBAG; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PKCS12_SAFEBAG';

function i2d_PKCS12_SAFEBAG(a: PPKCS12_SAFEBAG; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS12_SAFEBAG';

function PKCS12_SAFEBAG_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAG_it';

function PKCS12_BAGS_new(): PPKCS12_BAGS; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_BAGS_new';

procedure PKCS12_BAGS_free(a: PPKCS12_BAGS); cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_BAGS_free';

function d2i_PKCS12_BAGS(a: PPPKCS12_BAGS; _in: PPByte; len: integer): PPKCS12_BAGS; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PKCS12_BAGS';

function i2d_PKCS12_BAGS(a: PPKCS12_BAGS; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS12_BAGS';

function PKCS12_BAGS_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_BAGS_it';

function PKCS12_SAFEBAGS_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_SAFEBAGS_it';

function PKCS12_AUTHSAFES_it(): PASN1_ITEM; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_AUTHSAFES_it';

procedure PKCS12_PBE_add(); cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_PBE_add';

function PKCS12_add_safe(psafes: PPstack_st_PKCS7; bags: Pstack_st_PKCS12_SAFEBAG; safe_nid: integer; iter: integer; pass: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_add_safe';

function PKCS12_add_safes(safes: Pstack_st_PKCS7; p7_nid: integer): PPKCS12; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS12_add_safes';

function d2i_PKCS12(a: PPPKCS12; _in: PPByte; len: integer): PPKCS12; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PKCS12';

function i2d_PKCS12(a: PPKCS12; _out: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS12';

function i2d_PKCS12_fp(fp: PPointer; p12: PPKCS12): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_PKCS12_fp';

function d2i_PKCS12_fp(fp: PPointer; p12: PPPKCS12): PPKCS12; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_PKCS12_fp';

function RAND_DRBG_new(typ: integer; flags: cardinal; parent: PRAND_DRBG): PRAND_DRBG; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_DRBG_new';

function RAND_DRBG_secure_new(typ: integer; flags: cardinal; parent: PRAND_DRBG): PRAND_DRBG; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_DRBG_secure_new';

function RAND_DRBG_set(drbg: PRAND_DRBG; typ: integer; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_DRBG_set';

function RAND_DRBG_set_defaults(typ: integer; flags: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_DRBG_set_defaults';

function RAND_DRBG_instantiate(drbg: PRAND_DRBG; pers: PByte; perslen: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_DRBG_instantiate';

function RAND_DRBG_uninstantiate(drbg: PRAND_DRBG): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_DRBG_uninstantiate';

procedure RAND_DRBG_free(drbg: PRAND_DRBG); cdecl;
  external LIB_CRYPTO name _PU + 'RAND_DRBG_free';

function RAND_DRBG_reseed(drbg: PRAND_DRBG; adin: PByte; adinlen: PtrUInt; prediction_resistance: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_DRBG_reseed';

function RAND_DRBG_generate(drbg: PRAND_DRBG; _out: PByte; outlen: PtrUInt; prediction_resistance: integer; adin: PByte; adinlen: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_DRBG_generate';

function RAND_DRBG_bytes(drbg: PRAND_DRBG; _out: PByte; outlen: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_DRBG_bytes';

function RAND_DRBG_set_reseed_interval(drbg: PRAND_DRBG; interval: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_DRBG_set_reseed_interval';

function RAND_DRBG_set_reseed_time_interval(drbg: PRAND_DRBG; interval: time_t): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_DRBG_set_reseed_time_interval';

function RAND_DRBG_set_reseed_defaults(master_reseed_interval: cardinal; slave_reseed_interval: cardinal; master_reseed_time_interval: time_t; slave_reseed_time_interval: time_t): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_DRBG_set_reseed_defaults';

function RAND_DRBG_get0_master(): PRAND_DRBG; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_DRBG_get0_master';

function RAND_DRBG_get0_public(): PRAND_DRBG; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_DRBG_get0_public';

function RAND_DRBG_get0_private(): PRAND_DRBG; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_DRBG_get0_private';

function RAND_DRBG_set_ex_data(drbg: PRAND_DRBG; idx: integer; arg: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_DRBG_set_ex_data';

function RAND_DRBG_get_ex_data(drbg: PRAND_DRBG; idx: integer): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_DRBG_get_ex_data';

function RAND_DRBG_set_callbacks(drbg: PRAND_DRBG; get_entropy: RAND_DRBG_get_entropy_fn; cleanup_entropy: RAND_DRBG_cleanup_entropy_fn; get_nonce: RAND_DRBG_get_nonce_fn; cleanup_nonce: RAND_DRBG_cleanup_nonce_fn): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RAND_DRBG_set_callbacks';

procedure RC2_set_key(key: PRC2_KEY; len: integer; data: PByte; bits: integer); cdecl;
  external LIB_CRYPTO name _PU + 'RC2_set_key';

procedure RC2_ecb_encrypt(_in: PByte; _out: PByte; key: PRC2_KEY; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'RC2_ecb_encrypt';

procedure RC2_encrypt(data: PCardinal; key: PRC2_KEY); cdecl;
  external LIB_CRYPTO name _PU + 'RC2_encrypt';

procedure RC2_decrypt(data: PCardinal; key: PRC2_KEY); cdecl;
  external LIB_CRYPTO name _PU + 'RC2_decrypt';

procedure RC2_cbc_encrypt(_in: PByte; _out: PByte; length: integer; ks: PRC2_KEY; iv: PByte; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'RC2_cbc_encrypt';

procedure RC2_cfb64_encrypt(_in: PByte; _out: PByte; length: integer; schedule: PRC2_KEY; ivec: PByte; num: PInteger; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'RC2_cfb64_encrypt';

procedure RC2_ofb64_encrypt(_in: PByte; _out: PByte; length: integer; schedule: PRC2_KEY; ivec: PByte; num: PInteger); cdecl;
  external LIB_CRYPTO name _PU + 'RC2_ofb64_encrypt';

function RC4_options(): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'RC4_options';

procedure RC4_set_key(key: PRC4_KEY; len: integer; data: PByte); cdecl;
  external LIB_CRYPTO name _PU + 'RC4_set_key';

procedure RC4(key: PRC4_KEY; len: PtrUInt; indata: PByte; outdata: PByte); cdecl;
  external LIB_CRYPTO name _PU + 'RC4';

function RIPEMD160_Init(c: PRIPEMD160_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RIPEMD160_Init';

function RIPEMD160_Update(c: PRIPEMD160_CTX; data: pointer; len: PtrUInt): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RIPEMD160_Update';

function RIPEMD160_Final(md: PByte; c: PRIPEMD160_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'RIPEMD160_Final';

function RIPEMD160(d: PByte; n: PtrUInt; md: PByte): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'RIPEMD160';

procedure RIPEMD160_Transform(c: PRIPEMD160_CTX; b: PByte); cdecl;
  external LIB_CRYPTO name _PU + 'RIPEMD160_Transform';

procedure SEED_set_key(rawkey: PByte; ks: PSEED_KEY_SCHEDULE); cdecl;
  external LIB_CRYPTO name _PU + 'SEED_set_key';

procedure SEED_encrypt(s: PByte; d: PByte; ks: PSEED_KEY_SCHEDULE); cdecl;
  external LIB_CRYPTO name _PU + 'SEED_encrypt';

procedure SEED_decrypt(s: PByte; d: PByte; ks: PSEED_KEY_SCHEDULE); cdecl;
  external LIB_CRYPTO name _PU + 'SEED_decrypt';

procedure SEED_ecb_encrypt(_in: PByte; _out: PByte; ks: PSEED_KEY_SCHEDULE; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'SEED_ecb_encrypt';

procedure SEED_cbc_encrypt(_in: PByte; _out: PByte; len: PtrUInt; ks: PSEED_KEY_SCHEDULE; ivec: PByte; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'SEED_cbc_encrypt';

procedure SEED_cfb128_encrypt(_in: PByte; _out: PByte; len: PtrUInt; ks: PSEED_KEY_SCHEDULE; ivec: PByte; num: PInteger; enc: integer); cdecl;
  external LIB_CRYPTO name _PU + 'SEED_cfb128_encrypt';

procedure SEED_ofb128_encrypt(_in: PByte; _out: PByte; len: PtrUInt; ks: PSEED_KEY_SCHEDULE; ivec: PByte; num: PInteger); cdecl;
  external LIB_CRYPTO name _PU + 'SEED_ofb128_encrypt';

procedure SRP_user_pwd_free(user_pwd: PSRP_user_pwd); cdecl;
  external LIB_CRYPTO name _PU + 'SRP_user_pwd_free';

function SRP_VBASE_new(seed_key: PUtf8Char): PSRP_VBASE; cdecl;
  external LIB_CRYPTO name _PU + 'SRP_VBASE_new';

procedure SRP_VBASE_free(vb: PSRP_VBASE); cdecl;
  external LIB_CRYPTO name _PU + 'SRP_VBASE_free';

function SRP_VBASE_init(vb: PSRP_VBASE; verifier_file: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SRP_VBASE_init';

function SRP_VBASE_get_by_user(vb: PSRP_VBASE; username: PUtf8Char): PSRP_user_pwd; cdecl;
  external LIB_CRYPTO name _PU + 'SRP_VBASE_get_by_user';

function SRP_VBASE_get1_by_user(vb: PSRP_VBASE; username: PUtf8Char): PSRP_user_pwd; cdecl;
  external LIB_CRYPTO name _PU + 'SRP_VBASE_get1_by_user';

function SRP_create_verifier(user: PUtf8Char; pass: PUtf8Char; salt: PPUtf8Char; verifier: PPUtf8Char; N: PUtf8Char; g: PUtf8Char): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'SRP_create_verifier';

function SRP_create_verifier_BN(user: PUtf8Char; pass: PUtf8Char; salt: PPBIGNUM; verifier: PPBIGNUM; N: PBIGNUM; g: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SRP_create_verifier_BN';

function SRP_check_known_gN_param(g: PBIGNUM; N: PBIGNUM): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'SRP_check_known_gN_param';

function SRP_get_default_gN(id: PUtf8Char): PSRP_gN; cdecl;
  external LIB_CRYPTO name _PU + 'SRP_get_default_gN';

function SRP_Calc_server_key(A: PBIGNUM; v: PBIGNUM; u: PBIGNUM; b: PBIGNUM; N: PBIGNUM): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'SRP_Calc_server_key';

function SRP_Calc_B(b: PBIGNUM; N: PBIGNUM; g: PBIGNUM; v: PBIGNUM): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'SRP_Calc_B';

function SRP_Verify_A_mod_N(A: PBIGNUM; N: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SRP_Verify_A_mod_N';

function SRP_Calc_u(A: PBIGNUM; B: PBIGNUM; N: PBIGNUM): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'SRP_Calc_u';

function SRP_Calc_x(s: PBIGNUM; user: PUtf8Char; pass: PUtf8Char): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'SRP_Calc_x';

function SRP_Calc_A(a: PBIGNUM; N: PBIGNUM; g: PBIGNUM): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'SRP_Calc_A';

function SRP_Calc_client_key(N: PBIGNUM; B: PBIGNUM; g: PBIGNUM; x: PBIGNUM; a: PBIGNUM; u: PBIGNUM): PBIGNUM; cdecl;
  external LIB_CRYPTO name _PU + 'SRP_Calc_client_key';

function SRP_Verify_B_mod_N(B: PBIGNUM; N: PBIGNUM): integer; cdecl;
  external LIB_CRYPTO name _PU + 'SRP_Verify_B_mod_N';

function DTLSv1_listen(s: PSSL; client: PBIO_ADDR): integer; cdecl;
  external LIB_CRYPTO name _PU + 'DTLSv1_listen';

procedure DTLS_set_timer_cb(s: PSSL; cb: DTLS_timer_cb); cdecl;
  external LIB_CRYPTO name _PU + 'DTLS_set_timer_cb';

function ERR_load_OSSL_STORE_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_OSSL_STORE_strings';

function OSSL_STORE_open(uri: PUtf8Char; ui_method: PUI_METHOD; ui_data: pointer; post_process: OSSL_STORE_post_process_info_fn; post_process_data: pointer): POSSL_STORE_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_open';

function OSSL_STORE_ctrl(ctx: POSSL_STORE_CTX; cmd: integer): integer varargs; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_ctrl';

function OSSL_STORE_vctrl(ctx: POSSL_STORE_CTX; cmd: integer; args: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_vctrl';

function OSSL_STORE_load(ctx: POSSL_STORE_CTX): POSSL_STORE_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_load';

function OSSL_STORE_eof(ctx: POSSL_STORE_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_eof';

function OSSL_STORE_error(ctx: POSSL_STORE_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_error';

function OSSL_STORE_close(ctx: POSSL_STORE_CTX): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_close';

function OSSL_STORE_INFO_new_NAME(name: PUtf8Char): POSSL_STORE_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_INFO_new_NAME';

function OSSL_STORE_INFO_set0_NAME_description(info: POSSL_STORE_INFO; desc: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_INFO_set0_NAME_description';

function OSSL_STORE_INFO_new_PARAMS(params: PEVP_PKEY): POSSL_STORE_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_INFO_new_PARAMS';

function OSSL_STORE_INFO_new_PKEY(pkey: PEVP_PKEY): POSSL_STORE_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_INFO_new_PKEY';

function OSSL_STORE_INFO_new_CERT(x509: PX509): POSSL_STORE_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_INFO_new_CERT';

function OSSL_STORE_INFO_new_CRL(crl: PX509_CRL): POSSL_STORE_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_INFO_new_CRL';

function OSSL_STORE_INFO_get_type(info: POSSL_STORE_INFO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_INFO_get_type';

function OSSL_STORE_INFO_get0_NAME(info: POSSL_STORE_INFO): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_INFO_get0_NAME';

function OSSL_STORE_INFO_get1_NAME(info: POSSL_STORE_INFO): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_INFO_get1_NAME';

function OSSL_STORE_INFO_get0_NAME_description(info: POSSL_STORE_INFO): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_INFO_get0_NAME_description';

function OSSL_STORE_INFO_get1_NAME_description(info: POSSL_STORE_INFO): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_INFO_get1_NAME_description';

function OSSL_STORE_INFO_get0_PARAMS(info: POSSL_STORE_INFO): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_INFO_get0_PARAMS';

function OSSL_STORE_INFO_get1_PARAMS(info: POSSL_STORE_INFO): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_INFO_get1_PARAMS';

function OSSL_STORE_INFO_get0_PKEY(info: POSSL_STORE_INFO): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_INFO_get0_PKEY';

function OSSL_STORE_INFO_get1_PKEY(info: POSSL_STORE_INFO): PEVP_PKEY; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_INFO_get1_PKEY';

function OSSL_STORE_INFO_get0_CERT(info: POSSL_STORE_INFO): PX509; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_INFO_get0_CERT';

function OSSL_STORE_INFO_get1_CERT(info: POSSL_STORE_INFO): PX509; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_INFO_get1_CERT';

function OSSL_STORE_INFO_get0_CRL(info: POSSL_STORE_INFO): PX509_CRL; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_INFO_get0_CRL';

function OSSL_STORE_INFO_get1_CRL(info: POSSL_STORE_INFO): PX509_CRL; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_INFO_get1_CRL';

function OSSL_STORE_INFO_type_string(typ: integer): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_INFO_type_string';

procedure OSSL_STORE_INFO_free(info: POSSL_STORE_INFO); cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_INFO_free';

function OSSL_STORE_supports_search(ctx: POSSL_STORE_CTX; search_type: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_supports_search';

function OSSL_STORE_SEARCH_by_name(name: PX509_NAME): POSSL_STORE_SEARCH; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_SEARCH_by_name';

function OSSL_STORE_SEARCH_by_issuer_serial(name: PX509_NAME; serial: PASN1_INTEGER): POSSL_STORE_SEARCH; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_SEARCH_by_issuer_serial';

function OSSL_STORE_SEARCH_by_key_fingerprint(digest: PEVP_MD; bytes: PByte; len: PtrUInt): POSSL_STORE_SEARCH; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_SEARCH_by_key_fingerprint';

function OSSL_STORE_SEARCH_by_alias(alias: PUtf8Char): POSSL_STORE_SEARCH; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_SEARCH_by_alias';

procedure OSSL_STORE_SEARCH_free(search: POSSL_STORE_SEARCH); cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_SEARCH_free';

function OSSL_STORE_SEARCH_get_type(criterion: POSSL_STORE_SEARCH): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_SEARCH_get_type';

function OSSL_STORE_SEARCH_get0_name(criterion: POSSL_STORE_SEARCH): PX509_NAME; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_SEARCH_get0_name';

function OSSL_STORE_SEARCH_get0_serial(criterion: POSSL_STORE_SEARCH): PASN1_INTEGER; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_SEARCH_get0_serial';

function OSSL_STORE_SEARCH_get0_bytes(criterion: POSSL_STORE_SEARCH; length: PPtrUInt): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_SEARCH_get0_bytes';

function OSSL_STORE_SEARCH_get0_string(criterion: POSSL_STORE_SEARCH): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_SEARCH_get0_string';

function OSSL_STORE_SEARCH_get0_digest(criterion: POSSL_STORE_SEARCH): PEVP_MD; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_SEARCH_get0_digest';

function OSSL_STORE_expect(ctx: POSSL_STORE_CTX; expected_type: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_expect';

function OSSL_STORE_find(ctx: POSSL_STORE_CTX; search: POSSL_STORE_SEARCH): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_find';

function OSSL_STORE_LOADER_new(e: PENGINE; scheme: PUtf8Char): POSSL_STORE_LOADER; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_LOADER_new';

function OSSL_STORE_LOADER_get0_engine(loader: POSSL_STORE_LOADER): PENGINE; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_LOADER_get0_engine';

function OSSL_STORE_LOADER_get0_scheme(loader: POSSL_STORE_LOADER): PUtf8Char; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_LOADER_get0_scheme';

function OSSL_STORE_LOADER_set_open(loader: POSSL_STORE_LOADER; open_function: OSSL_STORE_open_fn): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_LOADER_set_open';

function OSSL_STORE_LOADER_set_ctrl(loader: POSSL_STORE_LOADER; ctrl_function: OSSL_STORE_ctrl_fn): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_LOADER_set_ctrl';

function OSSL_STORE_LOADER_set_expect(loader: POSSL_STORE_LOADER; expect_function: OSSL_STORE_expect_fn): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_LOADER_set_expect';

function OSSL_STORE_LOADER_set_find(loader: POSSL_STORE_LOADER; find_function: OSSL_STORE_find_fn): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_LOADER_set_find';

function OSSL_STORE_LOADER_set_load(loader: POSSL_STORE_LOADER; load_function: OSSL_STORE_load_fn): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_LOADER_set_load';

function OSSL_STORE_LOADER_set_eof(loader: POSSL_STORE_LOADER; eof_function: OSSL_STORE_eof_fn): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_LOADER_set_eof';

function OSSL_STORE_LOADER_set_error(loader: POSSL_STORE_LOADER; error_function: OSSL_STORE_error_fn): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_LOADER_set_error';

function OSSL_STORE_LOADER_set_close(loader: POSSL_STORE_LOADER; close_function: OSSL_STORE_close_fn): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_LOADER_set_close';

procedure OSSL_STORE_LOADER_free(loader: POSSL_STORE_LOADER); cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_LOADER_free';

function OSSL_STORE_register_loader(loader: POSSL_STORE_LOADER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_register_loader';

function OSSL_STORE_unregister_loader(scheme: PUtf8Char): POSSL_STORE_LOADER; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_unregister_loader';

function OSSL_STORE_do_all_loaders(do_function: OSSL_STORE_do_all_loaders_do_function; do_arg: pointer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'OSSL_STORE_do_all_loaders';

function ERR_load_TS_strings(): integer; cdecl;
  external LIB_CRYPTO name _PU + 'ERR_load_TS_strings';

function TS_REQ_new(): PTS_REQ; cdecl;
  external LIB_CRYPTO name _PU + 'TS_REQ_new';

procedure TS_REQ_free(a: PTS_REQ); cdecl;
  external LIB_CRYPTO name _PU + 'TS_REQ_free';

function i2d_TS_REQ(a: PTS_REQ; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_TS_REQ';

function d2i_TS_REQ(a: PPTS_REQ; pp: PPByte; length: integer): PTS_REQ; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_TS_REQ';

function TS_REQ_dup(a: PTS_REQ): PTS_REQ; cdecl;
  external LIB_CRYPTO name _PU + 'TS_REQ_dup';

function d2i_TS_REQ_fp(fp: PPointer; a: PPTS_REQ): PTS_REQ; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_TS_REQ_fp';

function i2d_TS_REQ_fp(fp: PPointer; a: PTS_REQ): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_TS_REQ_fp';

function d2i_TS_REQ_bio(fp: PBIO; a: PPTS_REQ): PTS_REQ; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_TS_REQ_bio';

function i2d_TS_REQ_bio(fp: PBIO; a: PTS_REQ): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_TS_REQ_bio';

function TS_MSG_IMPRINT_new(): PTS_MSG_IMPRINT; cdecl;
  external LIB_CRYPTO name _PU + 'TS_MSG_IMPRINT_new';

procedure TS_MSG_IMPRINT_free(a: PTS_MSG_IMPRINT); cdecl;
  external LIB_CRYPTO name _PU + 'TS_MSG_IMPRINT_free';

function i2d_TS_MSG_IMPRINT(a: PTS_MSG_IMPRINT; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_TS_MSG_IMPRINT';

function d2i_TS_MSG_IMPRINT(a: PPTS_MSG_IMPRINT; pp: PPByte; length: integer): PTS_MSG_IMPRINT; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_TS_MSG_IMPRINT';

function TS_MSG_IMPRINT_dup(a: PTS_MSG_IMPRINT): PTS_MSG_IMPRINT; cdecl;
  external LIB_CRYPTO name _PU + 'TS_MSG_IMPRINT_dup';

function d2i_TS_MSG_IMPRINT_fp(fp: PPointer; a: PPTS_MSG_IMPRINT): PTS_MSG_IMPRINT; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_TS_MSG_IMPRINT_fp';

function i2d_TS_MSG_IMPRINT_fp(fp: PPointer; a: PTS_MSG_IMPRINT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_TS_MSG_IMPRINT_fp';

function d2i_TS_MSG_IMPRINT_bio(bio: PBIO; a: PPTS_MSG_IMPRINT): PTS_MSG_IMPRINT; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_TS_MSG_IMPRINT_bio';

function i2d_TS_MSG_IMPRINT_bio(bio: PBIO; a: PTS_MSG_IMPRINT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_TS_MSG_IMPRINT_bio';

function TS_RESP_new(): PTS_RESP; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_new';

procedure TS_RESP_free(a: PTS_RESP); cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_free';

function i2d_TS_RESP(a: PTS_RESP; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_TS_RESP';

function d2i_TS_RESP(a: PPTS_RESP; pp: PPByte; length: integer): PTS_RESP; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_TS_RESP';

function PKCS7_to_TS_TST_INFO(token: PPKCS7): PTS_TST_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'PKCS7_to_TS_TST_INFO';

function TS_RESP_dup(a: PTS_RESP): PTS_RESP; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_dup';

function d2i_TS_RESP_fp(fp: PPointer; a: PPTS_RESP): PTS_RESP; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_TS_RESP_fp';

function i2d_TS_RESP_fp(fp: PPointer; a: PTS_RESP): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_TS_RESP_fp';

function d2i_TS_RESP_bio(bio: PBIO; a: PPTS_RESP): PTS_RESP; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_TS_RESP_bio';

function i2d_TS_RESP_bio(bio: PBIO; a: PTS_RESP): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_TS_RESP_bio';

function TS_STATUS_INFO_new(): PTS_STATUS_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'TS_STATUS_INFO_new';

procedure TS_STATUS_INFO_free(a: PTS_STATUS_INFO); cdecl;
  external LIB_CRYPTO name _PU + 'TS_STATUS_INFO_free';

function i2d_TS_STATUS_INFO(a: PTS_STATUS_INFO; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_TS_STATUS_INFO';

function d2i_TS_STATUS_INFO(a: PPTS_STATUS_INFO; pp: PPByte; length: integer): PTS_STATUS_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_TS_STATUS_INFO';

function TS_STATUS_INFO_dup(a: PTS_STATUS_INFO): PTS_STATUS_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'TS_STATUS_INFO_dup';

function TS_TST_INFO_new(): PTS_TST_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_new';

procedure TS_TST_INFO_free(a: PTS_TST_INFO); cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_free';

function i2d_TS_TST_INFO(a: PTS_TST_INFO; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_TS_TST_INFO';

function d2i_TS_TST_INFO(a: PPTS_TST_INFO; pp: PPByte; length: integer): PTS_TST_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_TS_TST_INFO';

function TS_TST_INFO_dup(a: PTS_TST_INFO): PTS_TST_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_dup';

function d2i_TS_TST_INFO_fp(fp: PPointer; a: PPTS_TST_INFO): PTS_TST_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_TS_TST_INFO_fp';

function i2d_TS_TST_INFO_fp(fp: PPointer; a: PTS_TST_INFO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_TS_TST_INFO_fp';

function d2i_TS_TST_INFO_bio(bio: PBIO; a: PPTS_TST_INFO): PTS_TST_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_TS_TST_INFO_bio';

function i2d_TS_TST_INFO_bio(bio: PBIO; a: PTS_TST_INFO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_TS_TST_INFO_bio';

function TS_ACCURACY_new(): PTS_ACCURACY; cdecl;
  external LIB_CRYPTO name _PU + 'TS_ACCURACY_new';

procedure TS_ACCURACY_free(a: PTS_ACCURACY); cdecl;
  external LIB_CRYPTO name _PU + 'TS_ACCURACY_free';

function i2d_TS_ACCURACY(a: PTS_ACCURACY; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_TS_ACCURACY';

function d2i_TS_ACCURACY(a: PPTS_ACCURACY; pp: PPByte; length: integer): PTS_ACCURACY; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_TS_ACCURACY';

function TS_ACCURACY_dup(a: PTS_ACCURACY): PTS_ACCURACY; cdecl;
  external LIB_CRYPTO name _PU + 'TS_ACCURACY_dup';

function ESS_ISSUER_SERIAL_new(): PESS_ISSUER_SERIAL; cdecl;
  external LIB_CRYPTO name _PU + 'ESS_ISSUER_SERIAL_new';

procedure ESS_ISSUER_SERIAL_free(a: PESS_ISSUER_SERIAL); cdecl;
  external LIB_CRYPTO name _PU + 'ESS_ISSUER_SERIAL_free';

function i2d_ESS_ISSUER_SERIAL(a: PESS_ISSUER_SERIAL; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ESS_ISSUER_SERIAL';

function d2i_ESS_ISSUER_SERIAL(a: PPESS_ISSUER_SERIAL; pp: PPByte; length: integer): PESS_ISSUER_SERIAL; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ESS_ISSUER_SERIAL';

function ESS_ISSUER_SERIAL_dup(a: PESS_ISSUER_SERIAL): PESS_ISSUER_SERIAL; cdecl;
  external LIB_CRYPTO name _PU + 'ESS_ISSUER_SERIAL_dup';

function ESS_CERT_ID_new(): PESS_CERT_ID; cdecl;
  external LIB_CRYPTO name _PU + 'ESS_CERT_ID_new';

procedure ESS_CERT_ID_free(a: PESS_CERT_ID); cdecl;
  external LIB_CRYPTO name _PU + 'ESS_CERT_ID_free';

function i2d_ESS_CERT_ID(a: PESS_CERT_ID; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ESS_CERT_ID';

function d2i_ESS_CERT_ID(a: PPESS_CERT_ID; pp: PPByte; length: integer): PESS_CERT_ID; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ESS_CERT_ID';

function ESS_CERT_ID_dup(a: PESS_CERT_ID): PESS_CERT_ID; cdecl;
  external LIB_CRYPTO name _PU + 'ESS_CERT_ID_dup';

function ESS_SIGNING_CERT_new(): PESS_SIGNING_CERT; cdecl;
  external LIB_CRYPTO name _PU + 'ESS_SIGNING_CERT_new';

procedure ESS_SIGNING_CERT_free(a: PESS_SIGNING_CERT); cdecl;
  external LIB_CRYPTO name _PU + 'ESS_SIGNING_CERT_free';

function i2d_ESS_SIGNING_CERT(a: PESS_SIGNING_CERT; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ESS_SIGNING_CERT';

function d2i_ESS_SIGNING_CERT(a: PPESS_SIGNING_CERT; pp: PPByte; length: integer): PESS_SIGNING_CERT; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ESS_SIGNING_CERT';

function ESS_SIGNING_CERT_dup(a: PESS_SIGNING_CERT): PESS_SIGNING_CERT; cdecl;
  external LIB_CRYPTO name _PU + 'ESS_SIGNING_CERT_dup';

function ESS_CERT_ID_V2_new(): PESS_CERT_ID_V2; cdecl;
  external LIB_CRYPTO name _PU + 'ESS_CERT_ID_V2_new';

procedure ESS_CERT_ID_V2_free(a: PESS_CERT_ID_V2); cdecl;
  external LIB_CRYPTO name _PU + 'ESS_CERT_ID_V2_free';

function i2d_ESS_CERT_ID_V2(a: PESS_CERT_ID_V2; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ESS_CERT_ID_V2';

function d2i_ESS_CERT_ID_V2(a: PPESS_CERT_ID_V2; pp: PPByte; length: integer): PESS_CERT_ID_V2; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ESS_CERT_ID_V2';

function ESS_CERT_ID_V2_dup(a: PESS_CERT_ID_V2): PESS_CERT_ID_V2; cdecl;
  external LIB_CRYPTO name _PU + 'ESS_CERT_ID_V2_dup';

function ESS_SIGNING_CERT_V2_new(): PESS_SIGNING_CERT_V2; cdecl;
  external LIB_CRYPTO name _PU + 'ESS_SIGNING_CERT_V2_new';

procedure ESS_SIGNING_CERT_V2_free(a: PESS_SIGNING_CERT_V2); cdecl;
  external LIB_CRYPTO name _PU + 'ESS_SIGNING_CERT_V2_free';

function i2d_ESS_SIGNING_CERT_V2(a: PESS_SIGNING_CERT_V2; pp: PPByte): integer; cdecl;
  external LIB_CRYPTO name _PU + 'i2d_ESS_SIGNING_CERT_V2';

function d2i_ESS_SIGNING_CERT_V2(a: PPESS_SIGNING_CERT_V2; pp: PPByte; length: integer): PESS_SIGNING_CERT_V2; cdecl;
  external LIB_CRYPTO name _PU + 'd2i_ESS_SIGNING_CERT_V2';

function ESS_SIGNING_CERT_V2_dup(a: PESS_SIGNING_CERT_V2): PESS_SIGNING_CERT_V2; cdecl;
  external LIB_CRYPTO name _PU + 'ESS_SIGNING_CERT_V2_dup';

function TS_REQ_set_version(a: PTS_REQ; version: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_REQ_set_version';

function TS_REQ_get_version(a: PTS_REQ): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_REQ_get_version';

function TS_STATUS_INFO_set_status(a: PTS_STATUS_INFO; i: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_STATUS_INFO_set_status';

function TS_STATUS_INFO_get0_status(a: PTS_STATUS_INFO): PASN1_INTEGER; cdecl;
  external LIB_CRYPTO name _PU + 'TS_STATUS_INFO_get0_status';

function TS_STATUS_INFO_get0_text(a: PTS_STATUS_INFO): Pstack_st_ASN1_UTF8STRING; cdecl;
  external LIB_CRYPTO name _PU + 'TS_STATUS_INFO_get0_text';

function TS_STATUS_INFO_get0_failure_info(a: PTS_STATUS_INFO): PASN1_BIT_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'TS_STATUS_INFO_get0_failure_info';

function TS_REQ_set_msg_imprint(a: PTS_REQ; msg_imprint: PTS_MSG_IMPRINT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_REQ_set_msg_imprint';

function TS_REQ_get_msg_imprint(a: PTS_REQ): PTS_MSG_IMPRINT; cdecl;
  external LIB_CRYPTO name _PU + 'TS_REQ_get_msg_imprint';

function TS_MSG_IMPRINT_set_algo(a: PTS_MSG_IMPRINT; alg: PX509_ALGOR): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_MSG_IMPRINT_set_algo';

function TS_MSG_IMPRINT_get_algo(a: PTS_MSG_IMPRINT): PX509_ALGOR; cdecl;
  external LIB_CRYPTO name _PU + 'TS_MSG_IMPRINT_get_algo';

function TS_MSG_IMPRINT_set_msg(a: PTS_MSG_IMPRINT; d: PByte; len: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_MSG_IMPRINT_set_msg';

function TS_MSG_IMPRINT_get_msg(a: PTS_MSG_IMPRINT): PASN1_OCTET_STRING; cdecl;
  external LIB_CRYPTO name _PU + 'TS_MSG_IMPRINT_get_msg';

function TS_REQ_set_policy_id(a: PTS_REQ; policy: PASN1_OBJECT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_REQ_set_policy_id';

function TS_REQ_get_policy_id(a: PTS_REQ): PASN1_OBJECT; cdecl;
  external LIB_CRYPTO name _PU + 'TS_REQ_get_policy_id';

function TS_REQ_set_nonce(a: PTS_REQ; nonce: PASN1_INTEGER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_REQ_set_nonce';

function TS_REQ_get_nonce(a: PTS_REQ): PASN1_INTEGER; cdecl;
  external LIB_CRYPTO name _PU + 'TS_REQ_get_nonce';

function TS_REQ_set_cert_req(a: PTS_REQ; cert_req: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_REQ_set_cert_req';

function TS_REQ_get_cert_req(a: PTS_REQ): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_REQ_get_cert_req';

function TS_REQ_get_exts(a: PTS_REQ): Pstack_st_X509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'TS_REQ_get_exts';

procedure TS_REQ_ext_free(a: PTS_REQ); cdecl;
  external LIB_CRYPTO name _PU + 'TS_REQ_ext_free';

function TS_REQ_get_ext_count(a: PTS_REQ): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_REQ_get_ext_count';

function TS_REQ_get_ext_by_NID(a: PTS_REQ; nid: integer; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_REQ_get_ext_by_NID';

function TS_REQ_get_ext_by_OBJ(a: PTS_REQ; obj: PASN1_OBJECT; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_REQ_get_ext_by_OBJ';

function TS_REQ_get_ext_by_critical(a: PTS_REQ; crit: integer; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_REQ_get_ext_by_critical';

function TS_REQ_get_ext(a: PTS_REQ; loc: integer): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'TS_REQ_get_ext';

function TS_REQ_delete_ext(a: PTS_REQ; loc: integer): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'TS_REQ_delete_ext';

function TS_REQ_add_ext(a: PTS_REQ; ex: PX509_EXTENSION; loc: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_REQ_add_ext';

function TS_REQ_get_ext_d2i(a: PTS_REQ; nid: integer; crit: PInteger; idx: PInteger): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_REQ_get_ext_d2i';

function TS_REQ_print_bio(bio: PBIO; a: PTS_REQ): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_REQ_print_bio';

function TS_RESP_set_status_info(a: PTS_RESP; info: PTS_STATUS_INFO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_set_status_info';

function TS_RESP_get_status_info(a: PTS_RESP): PTS_STATUS_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_get_status_info';

procedure TS_RESP_set_tst_info(a: PTS_RESP; p7: PPKCS7; tst_info: PTS_TST_INFO); cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_set_tst_info';

function TS_RESP_get_token(a: PTS_RESP): PPKCS7; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_get_token';

function TS_RESP_get_tst_info(a: PTS_RESP): PTS_TST_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_get_tst_info';

function TS_TST_INFO_set_version(a: PTS_TST_INFO; version: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_set_version';

function TS_TST_INFO_get_version(a: PTS_TST_INFO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_get_version';

function TS_TST_INFO_set_policy_id(a: PTS_TST_INFO; policy_id: PASN1_OBJECT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_set_policy_id';

function TS_TST_INFO_get_policy_id(a: PTS_TST_INFO): PASN1_OBJECT; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_get_policy_id';

function TS_TST_INFO_set_msg_imprint(a: PTS_TST_INFO; msg_imprint: PTS_MSG_IMPRINT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_set_msg_imprint';

function TS_TST_INFO_get_msg_imprint(a: PTS_TST_INFO): PTS_MSG_IMPRINT; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_get_msg_imprint';

function TS_TST_INFO_set_serial(a: PTS_TST_INFO; serial: PASN1_INTEGER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_set_serial';

function TS_TST_INFO_get_serial(a: PTS_TST_INFO): PASN1_INTEGER; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_get_serial';

function TS_TST_INFO_set_time(a: PTS_TST_INFO; gtime: PASN1_GENERALIZEDTIME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_set_time';

function TS_TST_INFO_get_time(a: PTS_TST_INFO): PASN1_GENERALIZEDTIME; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_get_time';

function TS_TST_INFO_set_accuracy(a: PTS_TST_INFO; accuracy: PTS_ACCURACY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_set_accuracy';

function TS_TST_INFO_get_accuracy(a: PTS_TST_INFO): PTS_ACCURACY; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_get_accuracy';

function TS_ACCURACY_set_seconds(a: PTS_ACCURACY; seconds: PASN1_INTEGER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_ACCURACY_set_seconds';

function TS_ACCURACY_get_seconds(a: PTS_ACCURACY): PASN1_INTEGER; cdecl;
  external LIB_CRYPTO name _PU + 'TS_ACCURACY_get_seconds';

function TS_ACCURACY_set_millis(a: PTS_ACCURACY; millis: PASN1_INTEGER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_ACCURACY_set_millis';

function TS_ACCURACY_get_millis(a: PTS_ACCURACY): PASN1_INTEGER; cdecl;
  external LIB_CRYPTO name _PU + 'TS_ACCURACY_get_millis';

function TS_ACCURACY_set_micros(a: PTS_ACCURACY; micros: PASN1_INTEGER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_ACCURACY_set_micros';

function TS_ACCURACY_get_micros(a: PTS_ACCURACY): PASN1_INTEGER; cdecl;
  external LIB_CRYPTO name _PU + 'TS_ACCURACY_get_micros';

function TS_TST_INFO_set_ordering(a: PTS_TST_INFO; ordering: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_set_ordering';

function TS_TST_INFO_get_ordering(a: PTS_TST_INFO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_get_ordering';

function TS_TST_INFO_set_nonce(a: PTS_TST_INFO; nonce: PASN1_INTEGER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_set_nonce';

function TS_TST_INFO_get_nonce(a: PTS_TST_INFO): PASN1_INTEGER; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_get_nonce';

function TS_TST_INFO_set_tsa(a: PTS_TST_INFO; tsa: PGENERAL_NAME): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_set_tsa';

function TS_TST_INFO_get_tsa(a: PTS_TST_INFO): PGENERAL_NAME; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_get_tsa';

function TS_TST_INFO_get_exts(a: PTS_TST_INFO): Pstack_st_X509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_get_exts';

procedure TS_TST_INFO_ext_free(a: PTS_TST_INFO); cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_ext_free';

function TS_TST_INFO_get_ext_count(a: PTS_TST_INFO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_get_ext_count';

function TS_TST_INFO_get_ext_by_NID(a: PTS_TST_INFO; nid: integer; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_get_ext_by_NID';

function TS_TST_INFO_get_ext_by_OBJ(a: PTS_TST_INFO; obj: PASN1_OBJECT; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_get_ext_by_OBJ';

function TS_TST_INFO_get_ext_by_critical(a: PTS_TST_INFO; crit: integer; lastpos: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_get_ext_by_critical';

function TS_TST_INFO_get_ext(a: PTS_TST_INFO; loc: integer): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_get_ext';

function TS_TST_INFO_delete_ext(a: PTS_TST_INFO; loc: integer): PX509_EXTENSION; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_delete_ext';

function TS_TST_INFO_add_ext(a: PTS_TST_INFO; ex: PX509_EXTENSION; loc: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_add_ext';

function TS_TST_INFO_get_ext_d2i(a: PTS_TST_INFO; nid: integer; crit: PInteger; idx: PInteger): pointer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_get_ext_d2i';

function TS_RESP_CTX_new(): PTS_RESP_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_CTX_new';

procedure TS_RESP_CTX_free(ctx: PTS_RESP_CTX); cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_CTX_free';

function TS_RESP_CTX_set_signer_cert(ctx: PTS_RESP_CTX; signer: PX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_CTX_set_signer_cert';

function TS_RESP_CTX_set_signer_key(ctx: PTS_RESP_CTX; key: PEVP_PKEY): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_CTX_set_signer_key';

function TS_RESP_CTX_set_signer_digest(ctx: PTS_RESP_CTX; signer_digest: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_CTX_set_signer_digest';

function TS_RESP_CTX_set_ess_cert_id_digest(ctx: PTS_RESP_CTX; md: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_CTX_set_ess_cert_id_digest';

function TS_RESP_CTX_set_def_policy(ctx: PTS_RESP_CTX; def_policy: PASN1_OBJECT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_CTX_set_def_policy';

function TS_RESP_CTX_set_certs(ctx: PTS_RESP_CTX; certs: Pstack_st_X509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_CTX_set_certs';

function TS_RESP_CTX_add_policy(ctx: PTS_RESP_CTX; policy: PASN1_OBJECT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_CTX_add_policy';

function TS_RESP_CTX_add_md(ctx: PTS_RESP_CTX; md: PEVP_MD): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_CTX_add_md';

function TS_RESP_CTX_set_accuracy(ctx: PTS_RESP_CTX; secs: integer; millis: integer; micros: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_CTX_set_accuracy';

function TS_RESP_CTX_set_clock_precision_digits(ctx: PTS_RESP_CTX; clock_precision_digits: cardinal): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_CTX_set_clock_precision_digits';

procedure TS_RESP_CTX_add_flags(ctx: PTS_RESP_CTX; flags: integer); cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_CTX_add_flags';

procedure TS_RESP_CTX_set_serial_cb(ctx: PTS_RESP_CTX; cb: TS_serial_cb; data: pointer); cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_CTX_set_serial_cb';

procedure TS_RESP_CTX_set_time_cb(ctx: PTS_RESP_CTX; cb: TS_time_cb; data: pointer); cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_CTX_set_time_cb';

procedure TS_RESP_CTX_set_extension_cb(ctx: PTS_RESP_CTX; cb: TS_extension_cb; data: pointer); cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_CTX_set_extension_cb';

function TS_RESP_CTX_set_status_info(ctx: PTS_RESP_CTX; status: integer; text: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_CTX_set_status_info';

function TS_RESP_CTX_set_status_info_cond(ctx: PTS_RESP_CTX; status: integer; text: PUtf8Char): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_CTX_set_status_info_cond';

function TS_RESP_CTX_add_failure_info(ctx: PTS_RESP_CTX; failure: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_CTX_add_failure_info';

function TS_RESP_CTX_get_request(ctx: PTS_RESP_CTX): PTS_REQ; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_CTX_get_request';

function TS_RESP_CTX_get_tst_info(ctx: PTS_RESP_CTX): PTS_TST_INFO; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_CTX_get_tst_info';

function TS_RESP_create_response(ctx: PTS_RESP_CTX; req_bio: PBIO): PTS_RESP; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_create_response';

function TS_RESP_verify_signature(token: PPKCS7; certs: Pstack_st_X509; store: PX509_STORE; signer_out: PPX509): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_verify_signature';

function TS_RESP_verify_response(ctx: PTS_VERIFY_CTX; response: PTS_RESP): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_verify_response';

function TS_RESP_verify_token(ctx: PTS_VERIFY_CTX; token: PPKCS7): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_verify_token';

function TS_VERIFY_CTX_new(): PTS_VERIFY_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'TS_VERIFY_CTX_new';

procedure TS_VERIFY_CTX_init(ctx: PTS_VERIFY_CTX); cdecl;
  external LIB_CRYPTO name _PU + 'TS_VERIFY_CTX_init';

procedure TS_VERIFY_CTX_free(ctx: PTS_VERIFY_CTX); cdecl;
  external LIB_CRYPTO name _PU + 'TS_VERIFY_CTX_free';

procedure TS_VERIFY_CTX_cleanup(ctx: PTS_VERIFY_CTX); cdecl;
  external LIB_CRYPTO name _PU + 'TS_VERIFY_CTX_cleanup';

function TS_VERIFY_CTX_set_flags(ctx: PTS_VERIFY_CTX; f: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_VERIFY_CTX_set_flags';

function TS_VERIFY_CTX_add_flags(ctx: PTS_VERIFY_CTX; f: integer): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_VERIFY_CTX_add_flags';

function TS_VERIFY_CTX_set_data(ctx: PTS_VERIFY_CTX; b: PBIO): PBIO; cdecl;
  external LIB_CRYPTO name _PU + 'TS_VERIFY_CTX_set_data';

function TS_VERIFY_CTX_set_imprint(ctx: PTS_VERIFY_CTX; hexstr: PByte; len: integer): PByte; cdecl;
  external LIB_CRYPTO name _PU + 'TS_VERIFY_CTX_set_imprint';

function TS_VERIFY_CTX_set_store(ctx: PTS_VERIFY_CTX; s: PX509_STORE): PX509_STORE; cdecl;
  external LIB_CRYPTO name _PU + 'TS_VERIFY_CTX_set_store';

function TS_VERIFY_CTS_set_certs(ctx: PTS_VERIFY_CTX; certs: Pstack_st_X509): Pstack_st_X509; cdecl;
  external LIB_CRYPTO name _PU + 'TS_VERIFY_CTS_set_certs';

function TS_REQ_to_TS_VERIFY_CTX(req: PTS_REQ; ctx: PTS_VERIFY_CTX): PTS_VERIFY_CTX; cdecl;
  external LIB_CRYPTO name _PU + 'TS_REQ_to_TS_VERIFY_CTX';

function TS_RESP_print_bio(bio: PBIO; a: PTS_RESP): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_RESP_print_bio';

function TS_STATUS_INFO_print_bio(bio: PBIO; a: PTS_STATUS_INFO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_STATUS_INFO_print_bio';

function TS_TST_INFO_print_bio(bio: PBIO; a: PTS_TST_INFO): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_TST_INFO_print_bio';

function TS_ASN1_INTEGER_print_bio(bio: PBIO; num: PASN1_INTEGER): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_ASN1_INTEGER_print_bio';

function TS_OBJ_print_bio(bio: PBIO; obj: PASN1_OBJECT): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_OBJ_print_bio';

function TS_ext_print_bio(bio: PBIO; extensions: Pstack_st_X509_EXTENSION): integer; cdecl;
  external LIB_CRYPTO name _PU + 'TS_ext_print_bio';

function TS_X509_ALGOR_print_bio(bio: PBIO; alg: PX