import type { BackendInterface } from '../Backend/Backend';
import type BackendRequest from '../Backend/BackendRequest';
import BackendResponse from '../Backend/BackendResponse';
import type { ElementDriver } from './ElementDriver';
import ValueStore from './ValueStore';
import type { PluginInterface } from './plugins/PluginInterface';
type MaybePromise<T = void> = T | Promise<T>;
export type ComponentHooks = {
    connect: (component: Component) => MaybePromise;
    disconnect: (component: Component) => MaybePromise;
    'request:started': (requestConfig: any) => MaybePromise;
    'render:finished': (component: Component) => MaybePromise;
    'response:error': (backendResponse: BackendResponse, controls: {
        displayError: boolean;
    }) => MaybePromise;
    'loading.state:started': (element: HTMLElement, request: BackendRequest) => MaybePromise;
    'loading.state:finished': (element: HTMLElement) => MaybePromise;
    'model:set': (model: string, value: any, component: Component) => MaybePromise;
};
export type ComponentHookName = keyof ComponentHooks;
export type ComponentHookCallback<T extends string = ComponentHookName> = T extends ComponentHookName ? ComponentHooks[T] : (...args: any[]) => MaybePromise;
export default class Component {
    readonly element: HTMLElement;
    readonly name: string;
    readonly listeners: Map<string, string[]>;
    private backend;
    readonly elementDriver: ElementDriver;
    id: string | null;
    fingerprint: string;
    readonly valueStore: ValueStore;
    private readonly unsyncedInputsTracker;
    private hooks;
    defaultDebounce: number;
    private backendRequest;
    private pendingActions;
    private pendingFiles;
    private isRequestPending;
    private requestDebounceTimeout;
    private nextRequestPromise;
    private nextRequestPromiseResolve;
    private externalMutationTracker;
    constructor(element: HTMLElement, name: string, props: any, listeners: Array<{
        event: string;
        action: string;
    }>, id: string | null, backend: BackendInterface, elementDriver: ElementDriver);
    addPlugin(plugin: PluginInterface): void;
    connect(): void;
    disconnect(): void;
    on<T extends string | ComponentHookName = ComponentHookName>(hookName: T, callback: ComponentHookCallback<T>): void;
    off<T extends string | ComponentHookName = ComponentHookName>(hookName: T, callback: ComponentHookCallback<T>): void;
    set(model: string, value: any, reRender?: boolean, debounce?: number | boolean): Promise<BackendResponse>;
    getData(model: string): any;
    action(name: string, args?: any, debounce?: number | boolean): Promise<BackendResponse>;
    files(key: string, input: HTMLInputElement): void;
    render(): Promise<BackendResponse>;
    getUnsyncedModels(): string[];
    emit(name: string, data: any, onlyMatchingComponentsNamed?: string | null): void;
    emitUp(name: string, data: any, onlyMatchingComponentsNamed?: string | null): void;
    emitSelf(name: string, data: any): void;
    private performEmit;
    private doEmit;
    private isTurboEnabled;
    private tryStartingRequest;
    private performRequest;
    private processRerender;
    private calculateDebounce;
    private clearRequestDebounceTimeout;
    private debouncedStartRequest;
    private renderError;
    private resetPromise;
    _updateFromParentProps(props: any): void;
}
export declare function proxifyComponent(component: Component): Component;
export {};
