# Applications

This directory contains a number of example applications for building SwimOS applications and also contains example
binaries for their corresponding client applications. Each directory contains details about running the binaries.

- [aggregations](aggregations): Reference code for
  the [Group and Aggregate Agents](https://www.swimos.org/server/rust/aggregations/) guide.
- [command_lane](command_lane): Application demonstrating Command Lanes.
- [demand_lane](demand_lane): Application demonstrating Demand Lanes.
- [demand_map_lane](demand_map_lane): Application demonstrating Demand Map Lanes.
- [devguide](devguide): Reference code for the [Developer Guide](https://www.swimos.org/server/rust/developer-guide/).
- [event_downlink](event_downlink): Application demonstrating Event Downlinks.
- [http_lane](http_lane): Application demonstrating HTTP Lanes.
- [join_map](join_map): Application demonstrating Join Map Lanes.
- [join_value](join_value): Application demonstrating Join Value Lanes.
- [kafka_connector](kafka_connector): Application demonstrating consuming data from Apache Kafka.
- [local_downlink](local_downlink): Application demonstrating Downlinks.
- [map_downlink](map_downlink): Application demonstrating Map Downlinks.
- [map_lane](map_lane): Application demonstrating Map Lanes.
- [map_lane_persistence](map_lane_persistence): Application demonstrating Map Lanes with persistence.
- [map_store](map_store): Application demonstrating Map Stores.
- [map_store_persistence](map_store_persistence): Application demonstrating Map Stores with persistence.
- [ripple](ripple): Real-time synchronous shared multiplayer experience.
- [supply_lane](supply_lane): Application demonstrating Supply Lanes.
- [stocks_simulated](stocks_simulated): Application demonstrating simulated stock market data.
- [time_series](time_series): Reference code for the [Time Series](https://www.swimos.org/server/rust/time-series/)
  guide.
- [transit](transit): Rust port of the [Transit](https://github.com/swimos/transit) application.
- [value_downlink](value_downlink): Application demonstrating Value Downlinks.
- [value_lane](value_lane): Application demonstrating Value Lanes.
- [value_lane_persistence](value_lane_persistence): Application demonstrating Value Lanes with persistence.
- [value_store](value_store): Application demonstrating Value Stores.
- [value_store_persistence](value_store_persistence): Application demonstrating Value Stores with persistence.