

# Contributing to Sweep AI

First off, thank you for considering contributing to Sweep AI. It's people like you that make Sweep AI such a great tool.

## Creating Issues

Before you submit an issue, please do a search in [open issues](https://github.com/sweepai/sweep/issues) to see if the issue or feature request has already been filed.
Use the provided issue template when creating a new issue. Fill in the template with as much detail as possible. The more detail you provide, the more likely that someone can help you.
Alternatively, you can use Sweep to create a ticket for the problem first. Simply describe the issue or feature request, and Sweep will create a ticket for it. This can help you understand the problem better and guide you in manually solving it.
You can also use Sweep to create tickets. Simply describe the issue or feature request, and Sweep will create a ticket for it.

## Submitting Pull Requests

If you're working on an existing issue, respond to the issue and express interest in working on it. This helps other people know that the issue is active, and hopefully prevents duplicated efforts.

To submit a pull request, follow the following steps:

1. Clone the repository.
2. Create a new branch from `main`.
3. Make your changes.
4. Push your branch and submit a pull request to the `main` branch.
5. Await review. Respond to any comments or requests made by reviewers.

## Important Notes
1. Please do not edit the structure of the repo. Sweep is constantly changing, and we want to make sure that we can easily integrate your changes into our codebase.

## Coding Standards

Please ensure your code adheres to the coding standards used throughout the project. This includes proper indentation, accurate comments, and clear, concise code.

## Community

Please be respectful and considerate of others. We're all here to learn and grow, so constructive, respectful communication is encouraged.
