/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.bind;

import javax.portlet.PortletRequest;
import org.springframework.web.portlet.bind.MissingPortletRequestParameterException;
import org.springframework.web.portlet.bind.PortletRequestBindingException;

public abstract class PortletRequestUtils {
    private static final IntParser INT_PARSER = new IntParser();
    private static final LongParser LONG_PARSER = new LongParser();
    private static final FloatParser FLOAT_PARSER = new FloatParser();
    private static final DoubleParser DOUBLE_PARSER = new DoubleParser();
    private static final BooleanParser BOOLEAN_PARSER = new BooleanParser();
    private static final StringParser STRING_PARSER = new StringParser();

    public static Integer getIntParameter(PortletRequest request, String name) throws PortletRequestBindingException {
        if (request.getParameter(name) == null) {
            return null;
        }
        return PortletRequestUtils.getRequiredIntParameter(request, name);
    }

    public static int getIntParameter(PortletRequest request, String name, int defaultVal) {
        if (request.getParameter(name) == null) {
            return defaultVal;
        }
        try {
            return PortletRequestUtils.getRequiredIntParameter(request, name);
        }
        catch (PortletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static int[] getIntParameters(PortletRequest request, String name) {
        try {
            return PortletRequestUtils.getRequiredIntParameters(request, name);
        }
        catch (PortletRequestBindingException ex) {
            return new int[0];
        }
    }

    public static int getRequiredIntParameter(PortletRequest request, String name) throws PortletRequestBindingException {
        return INT_PARSER.parseInt(name, request.getParameter(name));
    }

    public static int[] getRequiredIntParameters(PortletRequest request, String name) throws PortletRequestBindingException {
        return INT_PARSER.parseInts(name, request.getParameterValues(name));
    }

    public static Long getLongParameter(PortletRequest request, String name) throws PortletRequestBindingException {
        if (request.getParameter(name) == null) {
            return null;
        }
        return PortletRequestUtils.getRequiredLongParameter(request, name);
    }

    public static long getLongParameter(PortletRequest request, String name, long defaultVal) {
        if (request.getParameter(name) == null) {
            return defaultVal;
        }
        try {
            return PortletRequestUtils.getRequiredLongParameter(request, name);
        }
        catch (PortletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static long[] getLongParameters(PortletRequest request, String name) {
        try {
            return PortletRequestUtils.getRequiredLongParameters(request, name);
        }
        catch (PortletRequestBindingException ex) {
            return new long[0];
        }
    }

    public static long getRequiredLongParameter(PortletRequest request, String name) throws PortletRequestBindingException {
        return LONG_PARSER.parseLong(name, request.getParameter(name));
    }

    public static long[] getRequiredLongParameters(PortletRequest request, String name) throws PortletRequestBindingException {
        return LONG_PARSER.parseLongs(name, request.getParameterValues(name));
    }

    public static Float getFloatParameter(PortletRequest request, String name) throws PortletRequestBindingException {
        if (request.getParameter(name) == null) {
            return null;
        }
        return Float.valueOf(PortletRequestUtils.getRequiredFloatParameter(request, name));
    }

    public static float getFloatParameter(PortletRequest request, String name, float defaultVal) {
        if (request.getParameter(name) == null) {
            return defaultVal;
        }
        try {
            return PortletRequestUtils.getRequiredFloatParameter(request, name);
        }
        catch (PortletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static float[] getFloatParameters(PortletRequest request, String name) {
        try {
            return PortletRequestUtils.getRequiredFloatParameters(request, name);
        }
        catch (PortletRequestBindingException ex) {
            return new float[0];
        }
    }

    public static float getRequiredFloatParameter(PortletRequest request, String name) throws PortletRequestBindingException {
        return FLOAT_PARSER.parseFloat(name, request.getParameter(name));
    }

    public static float[] getRequiredFloatParameters(PortletRequest request, String name) throws PortletRequestBindingException {
        return FLOAT_PARSER.parseFloats(name, request.getParameterValues(name));
    }

    public static Double getDoubleParameter(PortletRequest request, String name) throws PortletRequestBindingException {
        if (request.getParameter(name) == null) {
            return null;
        }
        return PortletRequestUtils.getRequiredDoubleParameter(request, name);
    }

    public static double getDoubleParameter(PortletRequest request, String name, double defaultVal) {
        if (request.getParameter(name) == null) {
            return defaultVal;
        }
        try {
            return PortletRequestUtils.getRequiredDoubleParameter(request, name);
        }
        catch (PortletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static double[] getDoubleParameters(PortletRequest request, String name) {
        try {
            return PortletRequestUtils.getRequiredDoubleParameters(request, name);
        }
        catch (PortletRequestBindingException ex) {
            return new double[0];
        }
    }

    public static double getRequiredDoubleParameter(PortletRequest request, String name) throws PortletRequestBindingException {
        return DOUBLE_PARSER.parseDouble(name, request.getParameter(name));
    }

    public static double[] getRequiredDoubleParameters(PortletRequest request, String name) throws PortletRequestBindingException {
        return DOUBLE_PARSER.parseDoubles(name, request.getParameterValues(name));
    }

    public static Boolean getBooleanParameter(PortletRequest request, String name) throws PortletRequestBindingException {
        if (request.getParameter(name) == null) {
            return null;
        }
        return PortletRequestUtils.getRequiredBooleanParameter(request, name);
    }

    public static boolean getBooleanParameter(PortletRequest request, String name, boolean defaultVal) {
        if (request.getParameter(name) == null) {
            return defaultVal;
        }
        try {
            return PortletRequestUtils.getRequiredBooleanParameter(request, name);
        }
        catch (PortletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static boolean[] getBooleanParameters(PortletRequest request, String name) {
        try {
            return PortletRequestUtils.getRequiredBooleanParameters(request, name);
        }
        catch (PortletRequestBindingException ex) {
            return new boolean[0];
        }
    }

    public static boolean getRequiredBooleanParameter(PortletRequest request, String name) throws PortletRequestBindingException {
        return BOOLEAN_PARSER.parseBoolean(name, request.getParameter(name));
    }

    public static boolean[] getRequiredBooleanParameters(PortletRequest request, String name) throws PortletRequestBindingException {
        return BOOLEAN_PARSER.parseBooleans(name, request.getParameterValues(name));
    }

    public static String getStringParameter(PortletRequest request, String name) throws PortletRequestBindingException {
        if (request.getParameter(name) == null) {
            return null;
        }
        return PortletRequestUtils.getRequiredStringParameter(request, name);
    }

    public static String getStringParameter(PortletRequest request, String name, String defaultVal) {
        String val = request.getParameter(name);
        return val != null ? val : defaultVal;
    }

    public static String[] getStringParameters(PortletRequest request, String name) {
        try {
            return PortletRequestUtils.getRequiredStringParameters(request, name);
        }
        catch (PortletRequestBindingException ex) {
            return new String[0];
        }
    }

    public static String getRequiredStringParameter(PortletRequest request, String name) throws PortletRequestBindingException {
        return STRING_PARSER.validateRequiredString(name, request.getParameter(name));
    }

    public static String[] getRequiredStringParameters(PortletRequest request, String name) throws PortletRequestBindingException {
        return STRING_PARSER.validateRequiredStrings(name, request.getParameterValues(name));
    }

    private static class BooleanParser
    extends ParameterParser<Boolean> {
        private BooleanParser() {
        }

        @Override
        protected String getType() {
            return "boolean";
        }

        @Override
        protected Boolean doParse(String parameter) throws NumberFormatException {
            return parameter.equalsIgnoreCase("true") || parameter.equalsIgnoreCase("on") || parameter.equalsIgnoreCase("yes") || parameter.equals("1");
        }

        public boolean parseBoolean(String name, String parameter) throws PortletRequestBindingException {
            return (Boolean)this.parse(name, parameter);
        }

        public boolean[] parseBooleans(String name, String[] values) throws PortletRequestBindingException {
            this.validateRequiredParameter(name, values);
            boolean[] parameters = new boolean[values.length];
            for (int i = 0; i < values.length; ++i) {
                parameters[i] = this.parseBoolean(name, values[i]);
            }
            return parameters;
        }
    }

    private static class DoubleParser
    extends ParameterParser<Double> {
        private DoubleParser() {
        }

        @Override
        protected String getType() {
            return "double";
        }

        @Override
        protected Double doParse(String parameter) throws NumberFormatException {
            return Double.valueOf(parameter);
        }

        public double parseDouble(String name, String parameter) throws PortletRequestBindingException {
            return (Double)this.parse(name, parameter);
        }

        public double[] parseDoubles(String name, String[] values) throws PortletRequestBindingException {
            this.validateRequiredParameter(name, values);
            double[] parameters = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                parameters[i] = this.parseDouble(name, values[i]);
            }
            return parameters;
        }
    }

    private static class FloatParser
    extends ParameterParser<Float> {
        private FloatParser() {
        }

        @Override
        protected String getType() {
            return "float";
        }

        @Override
        protected Float doParse(String parameter) throws NumberFormatException {
            return Float.valueOf(parameter);
        }

        public float parseFloat(String name, String parameter) throws PortletRequestBindingException {
            return ((Float)this.parse(name, parameter)).floatValue();
        }

        public float[] parseFloats(String name, String[] values) throws PortletRequestBindingException {
            this.validateRequiredParameter(name, values);
            float[] parameters = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                parameters[i] = this.parseFloat(name, values[i]);
            }
            return parameters;
        }
    }

    private static class IntParser
    extends ParameterParser<Integer> {
        private IntParser() {
        }

        @Override
        protected String getType() {
            return "int";
        }

        @Override
        protected Integer doParse(String s) throws NumberFormatException {
            return Integer.valueOf(s);
        }

        public int parseInt(String name, String parameter) throws PortletRequestBindingException {
            return (Integer)this.parse(name, parameter);
        }

        public int[] parseInts(String name, String[] values) throws PortletRequestBindingException {
            this.validateRequiredParameter(name, values);
            int[] parameters = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                parameters[i] = this.parseInt(name, values[i]);
            }
            return parameters;
        }
    }

    private static class LongParser
    extends ParameterParser<Long> {
        private LongParser() {
        }

        @Override
        protected String getType() {
            return "long";
        }

        @Override
        protected Long doParse(String parameter) throws NumberFormatException {
            return Long.valueOf(parameter);
        }

        public long parseLong(String name, String parameter) throws PortletRequestBindingException {
            return (Long)this.parse(name, parameter);
        }

        public long[] parseLongs(String name, String[] values) throws PortletRequestBindingException {
            this.validateRequiredParameter(name, values);
            long[] parameters = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                parameters[i] = this.parseLong(name, values[i]);
            }
            return parameters;
        }
    }

    private static abstract class ParameterParser<T> {
        private ParameterParser() {
        }

        protected final T parse(String name, String parameter) throws PortletRequestBindingException {
            this.validateRequiredParameter(name, parameter);
            try {
                return this.doParse(parameter);
            }
            catch (NumberFormatException ex) {
                throw new PortletRequestBindingException("Required " + this.getType() + " parameter '" + name + "' with value of '" + parameter + "' is not a valid number", ex);
            }
        }

        protected final void validateRequiredParameter(String name, Object parameter) throws PortletRequestBindingException {
            if (parameter == null) {
                throw new MissingPortletRequestParameterException(name, this.getType());
            }
        }

        protected abstract String getType();

        protected abstract T doParse(String var1) throws NumberFormatException;
    }

    private static class StringParser
    extends ParameterParser<String> {
        private StringParser() {
        }

        @Override
        protected String getType() {
            return "string";
        }

        @Override
        protected String doParse(String parameter) throws NumberFormatException {
            return parameter;
        }

        public String validateRequiredString(String name, String value) throws PortletRequestBindingException {
            this.validateRequiredParameter(name, value);
            return value;
        }

        public String[] validateRequiredStrings(String name, String[] values) throws PortletRequestBindingException {
            this.validateRequiredParameter(name, values);
            for (String value : values) {
                this.validateRequiredParameter(name, value);
            }
            return values;
        }
    }
}

