/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.expression;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;

public class BeanFactoryAccessor
implements PropertyAccessor {
    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        return ((BeanFactory)target).containsBean(name);
    }

    public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
        return new TypedValue(((BeanFactory)target).getBean(name));
    }

    public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
        return false;
    }

    public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
        throw new AccessException("Beans in a BeanFactory are read-only");
    }

    public Class<?>[] getSpecificTargetClasses() {
        return new Class[]{BeanFactory.class};
    }
}

