/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener.endpoint;

import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.jms.listener.endpoint.JmsActivationSpecConfig;
import org.springframework.jms.listener.endpoint.JmsActivationSpecFactory;
import org.springframework.jms.support.destination.DestinationResolutionException;
import org.springframework.jms.support.destination.DestinationResolver;

public class StandardJmsActivationSpecFactory
implements JmsActivationSpecFactory {
    private Class<?> activationSpecClass;
    private Map<String, String> defaultProperties;
    private DestinationResolver destinationResolver;

    public void setActivationSpecClass(Class<?> activationSpecClass) {
        this.activationSpecClass = activationSpecClass;
    }

    public void setDefaultProperties(Map<String, String> defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    @Override
    public ActivationSpec createActivationSpec(ResourceAdapter adapter, JmsActivationSpecConfig config) {
        Class<?> activationSpecClassToUse = this.activationSpecClass;
        if (activationSpecClassToUse == null && (activationSpecClassToUse = this.determineActivationSpecClass(adapter)) == null) {
            throw new IllegalStateException("Property 'activationSpecClass' is required");
        }
        ActivationSpec spec = (ActivationSpec)BeanUtils.instantiateClass(activationSpecClassToUse);
        BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)spec);
        if (this.defaultProperties != null) {
            bw.setPropertyValues(this.defaultProperties);
        }
        this.populateActivationSpecProperties(bw, config);
        return spec;
    }

    protected Class<?> determineActivationSpecClass(ResourceAdapter adapter) {
        return null;
    }

    protected void populateActivationSpecProperties(BeanWrapper bw, JmsActivationSpecConfig config) {
        String destinationName = config.getDestinationName();
        boolean pubSubDomain = config.isPubSubDomain();
        String destination = destinationName;
        if (this.destinationResolver != null) {
            try {
                destination = this.destinationResolver.resolveDestinationName(null, destinationName, pubSubDomain);
            }
            catch (JMSException ex) {
                throw new DestinationResolutionException("Cannot resolve destination name [" + destinationName + "]", ex);
            }
        }
        bw.setPropertyValue("destination", (Object)destination);
        bw.setPropertyValue("destinationType", (Object)(pubSubDomain ? Topic.class.getName() : Queue.class.getName()));
        if (bw.isWritableProperty("subscriptionDurability")) {
            bw.setPropertyValue("subscriptionDurability", (Object)(config.isSubscriptionDurable() ? "Durable" : "NonDurable"));
        } else if (config.isSubscriptionDurable()) {
            throw new IllegalArgumentException("Durable subscriptions not supported by underlying provider: " + this.activationSpecClass.getName());
        }
        if (config.getDurableSubscriptionName() != null) {
            bw.setPropertyValue("subscriptionName", (Object)config.getDurableSubscriptionName());
        }
        if (config.getClientId() != null) {
            bw.setPropertyValue("clientId", (Object)config.getClientId());
        }
        if (config.getMessageSelector() != null) {
            bw.setPropertyValue("messageSelector", (Object)config.getMessageSelector());
        }
        this.applyAcknowledgeMode(bw, config.getAcknowledgeMode());
    }

    protected void applyAcknowledgeMode(BeanWrapper bw, int ackMode) {
        if (ackMode == 0) {
            throw new IllegalArgumentException("No support for SESSION_TRANSACTED: Only \"Auto-acknowledge\" and \"Dups-ok-acknowledge\" supported in standard JCA 1.5");
        }
        if (ackMode == 2) {
            throw new IllegalArgumentException("No support for CLIENT_ACKNOWLEDGE: Only \"Auto-acknowledge\" and \"Dups-ok-acknowledge\" supported in standard JCA 1.5");
        }
        if (bw.isWritableProperty("acknowledgeMode")) {
            bw.setPropertyValue("acknowledgeMode", (Object)(ackMode == 3 ? "Dups-ok-acknowledge" : "Auto-acknowledge"));
        } else if (ackMode == 3) {
            throw new IllegalArgumentException("Dups-ok-acknowledge not supported by underlying provider: " + this.activationSpecClass.getName());
        }
    }
}

