# How to contribute to Sveltin

## Did you

### Find a bug?

- **Ensure the bug was not already reported** by searching on GitHub under [Issues](https://github.com/sveltinio/sveltin/issues).

- If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/sveltinio/sveltin/issues/new). Be sure to include a **title and clear description**, as much relevant information as possible, and a **code sample** or an **executable test case** demonstrating the expected behavior that is not occurring.

### Write a patch that fixes a bug?

- Open a new GitHub pull request with the patch.

- Ensure the PR description clearly describes the problem and solution. Include the relevant issue number if applicable.

### Fix whitespace, format code, or make a purely cosmetic patch?

Changes that are cosmetic in nature and do not add anything substantial to the stability, functionality, or testability of Sveltin will be accepted too. Thanks for that.

### Intend to add a new feature or change an existing one?

- Open a new GitHub pull request.

## Do you have questions about the source code?

- Ask any question about how to use Sveltin reaching me out on one of the social networks you find on my profile.

Sveltin is a volunteer effort.

Thanks! :heart:

indaco
