<?php
use Restserver\Libraries\REST_Controller;
defined('BASEPATH') OR exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
/** @noinspection PhpIncludeInspection */
//To Solve File REST_Controller not found
require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

/**
 * This is an example of a few basic user interaction methods you could use
 * all done with a hardcoded array
 *
 * @package         CodeIgniter
 * @subpackage      Rest Server
 * @category        Controller
 * @author          Phil Sturgeon, Chris Kacerguis
 * @license         MIT
 * @link            https://github.com/chriskacerguis/codeigniter-restserver
 */
class Items extends REST_Controller {

    function __construct()
    {
        // Construct the parent class
        parent::__construct();

        // Configure limits on our controller methods
        // Ensure you have created the 'limits' table and enabled 'limits' within application/config/rest.php
        $this->methods['items_get']['limit'] = 500; // 500 requests per hour per user/key
        $this->methods['items_post']['limit'] = 100; // 100 requests per hour per user/key
        $this->methods['items_delete']['limit'] = 50; // 50 requests per hour per user/key
        $this->load->model('items_model');
    }

    public function items_get(){
        
        $fromto = $this->get('fromto');
        // If the fromto parameter doesn't exist return all the items
        if($fromto === NULL){
            // Users from a data store e.g. database
            $items = $this->items_model->getAllItems();
            // Check if the items data store contains items (in case the database result returns NULL)
            if($items){
                // Set the response and exit
                $this->response($items, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
            }else{
                // Set the response and exit
                $this->response([
                    'status' => FALSE,
                    'message' => 'No users were found'
                ], REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
            }
        }else if($fromto){
            $values = explode("-",$fromto);
            for ($i=0; $i < sizeof($values); $i++) { 
                $values[$i] = (int)$values[$i];
            }
            $items = $this->items_model->getItemsByRange($values[0], $values[1]);
            $this->response($items, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
        }
    }

    public function items_post(){
        $lastid = $this->items_model->AddItem($this->post('name'));
        $message = [
            'id' => $lastid, // Automatically generated by the model
            'name' => $this->post('name'),
            'message' => 'Added a resource'
        ];

        $this->set_response($message, REST_Controller::HTTP_CREATED); // CREATED (201) being the HTTP response code
    }

    public function items_delete(){
        $name = $_GET['name'];
        // Validate the name.
        if(!$name){
            // Set the response and exit
            $this->response(NULL, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
        }

        $flag = $this->items_model->RemoveItem($name);
        $message = [
            'flag' => $flag,
            'name' => $name,
            'message' => 'Deleted the resource'
        ];

        $this->set_response($message, REST_Controller::HTTP_NO_CONTENT); // NO_CONTENT (204) being the HTTP response code
    }

    public function items_put(){
        $name = $this->put('name');
        $action = $this->put('action');
        // Validate the name.
        if(!$name){
            // Set the response and exit
            $this->response(NULL, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
        }

        if($action==1){
            $flag = $this->items_model->DecrementItem($name);
            $message = [
                'flag' => $flag,
                'name' => $name,
                'message' => 'Decremented the resource'
            ];
        }elseif($action==2){
            $flag = $this->items_model->IncrementItem($name);
            $message = [
                'flag' => $flag,
                'name' => $name,
                'message' => 'Incremented the resource'
            ];
        }
        elseif($action==3){
            $flag = $this->items_model->EditItem($name);
            $message = [
                'flag' => $flag,
                'name' => $name,
                'message' => 'Edited the resource'
            ];
        }
        $this->set_response($message, REST_Controller::HTTP_NO_CONTENT); // NO_CONTENT (204) being the HTTP response code
    }

}
