﻿package  {
	import flash.events.Event;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.display.MovieClip;

	public class Vcam extends MovieClip{
		
		//PUBLIC PROPERTIES
		public var xPos, yPos:Number;
		//position of the camera
		public var wide, high:Number;
		//width and height dimensions of the camera
		
		public var xSpeed, ySpeed:Number;
		//current speed of the vCam
		
		//PRIVATE PROPERTIES
		private var mcTarget:MovieClip;
		//target that the camera is supposed to track
		private var targetOffset:Point;
		//x and y offsets such that the target being tracked is not directly in the middle of the camera
		private var followFactor:Number;
		//number between 0 and 1 that determines how tightly the camera is to track
		
		private var moveRoom:Rectangle;
		//rectangle that represents the space that the vCam can move in
		
		public var shaking:Number = 0;
		//magnitude of shaking of the camera
		
		public function Vcam(xPos:Number, yPos:Number, wide:Number, high:Number) {
			this.xPos = xPos;
			this.yPos = yPos;
			this.wide = wide;
			this.high = high;
			
			//Set others as default
			targetOffset = new Point();
			followFactor = 1;
			
			//Add tracking event
			addEventListener(Event.ENTER_FRAME, trackCam, false, -1);
		}
		
		public function swapTarget(newTarget:MovieClip, newOffset:Point = null):void{
			/*
			PARAMETERS:
			newTarget = new MovieCip that becomes the object that this vCam tracks
			newOffset = new offset of the object as it is being tracked by the vCam
			DO:
			Switches the target that the vCam follows.
			*/
			
			mcTarget = newTarget;
			if(newOffset != null){
				targetOffset = newOffset;
			}else{
				targetOffset = new Point();
			}
			
		}
		
		public function swapFactor(newFactor:Number):void{
			/*
			PARAMETERS:
			newFactor = new follow factor that will be applied
			DO:
			If 'newFactor' is between 0 and 1, apply it as the new followFactor.
			Otherwise, print an error message.
			*/
			if(followFactor >= 0 && followFactor <= 1){
				followFactor = newFactor;
			}else{
				trace("ERROR: Follow Factor must be between 0 and 1!");
			}
		}
		
		public function swapBox(newRoom:Rectangle, newOffset:Point = null):void{
			/*
			PARAMETERS:
			newRoom = rectangle that represents the location and dimensions of the new room
			DO:
			Change the room dimensions for the vCam so it knows the end boundaries.
			*/
			moveRoom = newRoom;
			if(newOffset != null){
				targetOffset = newOffset;
			}
		}
		
		public function incShaking(magnitude:Number):void{
			shaking += magnitude;
		}
		
		public function setShaking(magnitude:Number):void{
			shaking = magnitude;
			//trace(magnitude);
		}
		
		public function trackCam(event:Event):void{
			/*
			DO:
			Tracks the mcTarget (if it exists) and stops tracking upon reaching room boundaries.
			*/
			if(mcTarget != null){
				var xPredict:Number = mcTarget.x + targetOffset.x - wide/2;
				var yPredict:Number = mcTarget.y + targetOffset.y - high/2;
				
				if(moveRoom != null){
					//Boundaries due to moveBox
					if(xPredict < moveRoom.x){
						//left bound
						xPredict = moveRoom.x;
					}
					if(xPredict + wide > moveRoom.x + moveRoom.width){
						//right bound
						xPredict = moveRoom.x + moveRoom.width - wide;
					}
					if(yPredict < moveRoom.y){
						//top bound
						yPredict = moveRoom.y;
					}
					if(yPredict + high > moveRoom.y + moveRoom.height){
						//bottom bound
						yPredict = moveRoom.y + moveRoom.height - high;
					}
				}
				//trace((Math.random()*shaking - shaking/2));
				//Track the target, taking into account the offset
				xSpeed = (xPredict - xPos)*followFactor + (Math.random()*shaking - shaking/2);
				ySpeed = (yPredict - yPos)*followFactor + (Math.random()*shaking - shaking/2);
				
				xPos += xSpeed;
				yPos += ySpeed;
			}
			Main.menuHandler.gameHandler.x = -xPos;
			Main.menuHandler.gameHandler.y = -yPos;
			
			//Main.main.backCanvas.updateScrollable();
		}
		
		public function unfollow():void{
			removeEventListener(Event.ENTER_FRAME, trackCam);
		}
		
		public function correct(){
			if(mcTarget != null){
				//Track the target, taking into account the offset
				xPos += (mcTarget.x + targetOffset.x - (xPos + wide/2));
				yPos += (mcTarget.y + targetOffset.y - (yPos + high/2));
				
				if(moveRoom != null){
					//Boundaries due to moveBox
					if(xPos < moveRoom.x){
						//left bound
						xPos = moveRoom.x;
					}
					if(xPos + wide > moveRoom.x + moveRoom.width){
						//right bound
						xPos = moveRoom.x + moveRoom.width - wide;
					}
					if(yPos < moveRoom.y){
						//top bound
						yPos = moveRoom.y;
					}
					if(yPos + high > moveRoom.y + moveRoom.height){
						//bottom bound
						yPos = moveRoom.y + moveRoom.height - high;
					}
				}
			}
		}
		public function getAsRect():Rectangle{
			return new Rectangle(xPos, yPos, wide, high);
		}
		
		public function refreshCamera():void{
			removeEventListener(Event.ENTER_FRAME, trackCam);
			addEventListener(Event.ENTER_FRAME, trackCam, false, -1);
			//vCam is readded to refresh last in order for enemy movement to be perfect!!!
		}

	}
	
}
