# Security Policy

## Overview

This project is designed to simplify and accelerate everyday tasks, making your work life smoother and more efficient. It is crafted with the utmost care and attention to detail, ensuring that no security vulnerabilities or exceptions occur during its runtime.

I am deeply committed to making the web a better, safer place. This project is **not malware**, and any attempt to misuse it as such is highly condemnable and goes against its core purpose. Let’s work together to create a positive impact and enhance our digital experiences.

## Supported Versions

The following table lists the versions of the project that are currently receiving security updates.

| Version      | Supported          |
|--------------|--------------------|
| 5.0.0        | ✅                 |
| 4.0.0        | ✅                 |
| < 3.x        | :x:                |

Please make sure to keep your installation up to date to receive the latest security patches and improvements.

## Reporting a Vulnerability

If you find any security vulnerabilities, please report them immediately so we can address them promptly. To report a vulnerability:

- **Contact**: [Email](mailto:mail@subhrachakraborti.com)
- **Issue Tracker**: [GitHub Issues](https://github.com/subhrachakraborti/PyCersi/issues)

### Guidelines for Reporting

1. **Provide a Clear Description**: Make sure to describe the vulnerability with as much detail as possible, including potential attack vectors.
2. **Proof of Concept**: If applicable, provide a proof of concept (PoC) to demonstrate how the vulnerability can be exploited.
3. **Environment**: Share details about the environment in which you discovered the issue (OS, Python version, etc.).

## Safety Certification

This project has undergone a security check and has been certified safe by [SafetyCLI](https://data.safetycli.com/packages/pypi/pycersi/).

- [SafetyCLI Certificate](https://data.safetycli.com/packages/pypi/pycersi/)

## Security Best Practices

Please ensure that you follow general security best practices when using this project:

1. **Keep Dependencies Up to Date**: Regularly check for new updates to this package and its dependencies.
2. **Use Secure Channels**: Always download the project from a trusted source (e.g., PyPI or the official GitHub repository).
3. **Regularly Audit Your Codebase**: Integrate security audits in your CI/CD pipeline to identify potential vulnerabilities.
4. **Environment Configuration**: Make sure your environment is secure, and avoid running the package with elevated privileges unless absolutely necessary.

---

By using this project, you agree to adhere to its intended use and help create a safer web for everyone. Thank you for your support and contributions.
