# ONIX-ZETA
<h1 align="center"> 🎃 HacktoberFest-2022 🎃</h1>

![Opensource](https://img.shields.io/badge/openSource-%E2%9D%A4-blue) ![PR](https://img.shields.io/badge/PRs-welcome-green) ![hacktoberfest](https://img.shields.io/badge/Hacktoberfest-2022-red) ![friendly](https://img.shields.io/badge/beginner-friendly-l)

# What is HacktoberFest?

Hacktoberfest is a month long event where people are awarded for contributing to open source projects 🙌, and we're joining the party .Hosted by DigitalOcean for the 8th year in a row, Hacktoberfest encourages participation in giving back to the open source community by completing pull requests, participating in events, and donating to open source projects.

# More details

Hacktoberfest is open to everyone in our global community. Whether you’re a seasoned contributor or looking for projects to contribute to for the first time, you’re welcome to participate.

Pull requests can be made in any participating GitHub or GitLab hosted repository/project. Look for the 'hacktoberfest' topic to know if a repository/project is participating in Hacktoberfest. Pull requests must be approved by a maintainer of the repository/project to count.

You can sign up anytime between October 1 and October 31. Just be sure to sign up on the official Hacktoberfest website for your pull requests to count.

# Rules for participation

* Pull requests can be submitted to any opted-in repository on GitHub or GitLab.
* The pull request must contain commits you made yourself.
* If a maintainer reports your pull request as spam, it will not be counted toward your participation in Hacktoberfest.
* If a maintainer reports behavior that’s not in line with the project’s code of conduct, you will be ineligible to participate.
* To get a shirt, you must make four approved pull requests (PRs) on opted-in projects between October 1-31 in any time zone.
* This year, the first 55,000 participants can earn a T-shirt.

# Quality Guidelines

* Pull requests that are automated e.g. scripted opening pull requests to remove whitespace / fix typos / optimize images.
* Pull requests that are disruptive e.g. taking someone else's branch/commits and making a pull request.
* Pull requests that are regarded by a project maintainer as a hindrance vs. helping.
* Something that's clearly an attempt to simply +1 your pull request count for October.
* Last but not least, one pull request to fix a typo is fine, but 5 pull requests to remove a stray whitespace is not.

### Note

**A pull request is considered approved once it has an overall approving review from maintainers, or has been merged by maintainers, or has been given the 'hacktoberfest-accepted' label. A pull request with any label containing the word 'spam' or 'invalid' will be considered ineligible for Hacktoberfest.**
Collecting dataset for training my model for recognizing and Identifying Various Objects






## Why should you take part?

- Chance to contribute to awesome open source projects 
- Engage with reputed communities
- Free swags and T-Shirts from Digital Ocean
- Chance to get a tree planted and make Earth greener


## Contribution Rules📚:

- You are allowed to make pull requests that break the rules. We just merge it :)
- Do NOT add any build steps e.g npm install (we want to keep this a simple static site)
- Do NOT remove others content.
- Styling/code can be pretty, ugly or stupid, big or small as long as it works.


## Getting Started 🤩🤗:

- Star this Repository(Must thing).
- Fork this repo. (Both button on top left)
- Clone on your local machine.

```terminal
git clone https://github.com/subhamgcon/Fight-game.git
```
- Navigate to project directory.
```terminal
cd Fight-game
```

- Create a new Branch

```markdown
git checkout -b my-new-branch
```
- Add your file/folder in your stack folder and if folder of your stack is not present add it.
```markdown
git add .
```
- Commit your changes.

```markdown
git commit -m "Relevant message"
```
- Then push 
```markdown
git push origin my-new-branch
```


- Create a new pull request from your forked repository

<br>

## Swags of Hacktoberfest:
- Many of the candidates get attracted towards hacktoberfest to get swags . So, after 4 successfully merged pull request as for 2021 you will be eligible to get a Hacktoberfest T-shirt and Some stickers on your doorstep.
 
     <li><B><p><img src="https://miro.medium.com/max/1050/1*4JctIO7irt8hFxBmTvUpiQ.jpeg" width="400" height="225" style="width: 400px; height: 225px;" alt="tshirt image"></a></p><p><img src="https://miro.medium.com/max/1050/1*jkffr74bq5RsQ_xqDhgqYQ.jpeg" width="400" height="225" style="width: 400px; height: 225px;" alt="stickers image"></p>
</b></li>







---

```javascript
  _____ _                 _     __   __
 |_   _| |__   __ _ _ __ | | __ \ \ / /__  _   _
   | | | '_ \ / _` | '_ \| |/ /  \ V / _ \| | | |
   | | | | | | (_| | | | |   <    | | (_) | |_| |
   |_| |_| |_|\__,_|_| |_|_|\_\   |_|\___/ \__,_|
```
---
