import { graphql } from 'gatsby'

/**
* These so called fragments are the fields we query on each template.
* A fragment make queries a bit more reuseable, so instead of typing and
* remembering every possible field, you can just use
*   ...GhostPostFields
* for example to load all post fields into your GraphQL query.
*
* Further info 👉🏼 https://www.gatsbyjs.org/docs/graphql-reference/#fragments
*
*/

// Used for single pages
export const tagsPageFields = graphql`
    fragment TagsPageFields on TagsPage {
        # Main fields
        id
        title
        slug
        url
        showIcon
    }
`
