# Contributors welcome!

As the interest in this project is rising, I want to list some ideas on how you can easily make a contribution. Just pick one area where you feel most skilled and don't forget to [coordinate with me](https://atmolabs.org/contact/), so your contribution receives full recognition.

# Write a blog article

Once you start using `gatsby-theme-try-ghost` or one of its addons, you'll naturally build some knowledge about how to use it. You may also come across some hurdles, see things you like or dislike, find out new things etc. Why not share your experience with others?

You can help this project tremendously by writing a blog article about your experience using this repo, or you make a speed comparison with other blog solutions, or show others how to overcome the hurdles you came across. I'm sure you have even more ideas, as you are most likely already running a blog!

# Test in different scenarios

Sourcing in your own content is a first test, as your content may contain elements which are not in our standard demo pages. The build should always succeed, but you may notice something on your site which doesn't quite come through as expected. It might be a wrong meta tag, it might be a displaced image or a colour glitch. 

Please open an [issue on Github](https://github.com/styxlab/gatsby-theme-try-ghost/issues), so this can be corrected in one of the next releases. If you know how to solve it yourself, you can of course also issue a pull request. There are also very different scenarios, where we rely on you reporting an issue. Make tests on different browsers, on desktop or mobile or with different screen sizes to name a few.

# Improve existing plugins

When you start using the plugins, you might feel that an important feature or configuration option is missing. Adding a new option to an existing plugin is usually easier than writing something from scratch. So, this is also a good place for first time contributors.

For example, the [gatsby-rehype-prismjs](https://github.com/styxlab/gatsby-theme-try-ghost/tree/master/packages/gatsby-rehype-prismjs) plugin could be improved to better support dark mode, font sizing, code highlighting and code numbering. This is just *one* starting point, start by improving plugins you need most in *your own* projects.

# Make a new plugin

It's always rewarding to write a new plugin as you really see your own accomplishments. Again, choose something that is missing in your own project. Some obvious plugins that are currently missing are:

- Social link plugin (social links can be more easily added and configured)
- Google AMP pages
- Search plugin (UI and backend)
- About page (similar to [gatsby-theme-ghost-contact](https://github.com/styxlab/gatsby-theme-try-ghost/tree/master/packages/gatsby-theme-ghost-contact))
- Gatsby images within content areas

# Write unit tests

In order to make this repository more robust and to being able to handle more contributions, unit tests would be a great addition. If you have some prior experience about writing unit tests you are very welcome to add unit tests to this repository.

# Where to go from here?

If you have picked your area, a specific task or an idea where you want to contribute, just [get in contact](https://atmolabs.org/contact/), so we can coordinate.
