# Dependency checking

In short the checking is done by comparing a current list of dependencies to a list saved previously.

Each project uses the `check_dependencies.cmd` script from obs-studio-node repository in their build process. 

If there any changes it will fail building, preventing unknown dependencies from being merged and released. 

The list is generated by `dumpbin /DEPENDENTS` tool. An example of a saved list can be found at `obs-studio-server\dependencies\obs64.exe.txt`

## Usage 

When a check fails, the script will print in the console the following information:
* The name of the binary file for which the dependencies have changed
* The list of the new dependencies added
* Information regarding the dependency files involved

To resolve the issue, you first need to review the difference found in the list of dependencies.

If the changes were not intentional or not needed then try to fix it by updating cmake.

If changes were intentional then copy the updated list into the saved list and include this change in your PR.

The entire dependency check will be skipped for Debug targets as it can have different names of linked libraries and we are primarily interested in changes in Release mode.

## Integration
The simplest way is to add a custom post build command.

Example:
https://github.com/stream-labs/a-files-updater/blob/5ef0900cd05c330988a95a87053fe0bf29e0bddf/CMakeLists.txt#L123

## Advanced way: additional build target

If there are too many binaries to check it will take noticeable amount of time, in this case it is better to move the script to a separate target.

Example:
https://github.com/stream-labs/obs-studio/blob/03442ce67f35566963bc73a1ad00be2ccb9e50e5/CMakeLists.txt#L320

It can then be ran by executing the following `cmake --build build --target check_dependencies --config RelWithDebInfo`