# PHP开发知识结构

- Architecture
  - 架构基础
    * [参考资料](Architecture/架构基础/参考资料.md)
    * [分布式架构 Broker](Architecture/架构基础/分布式架构 Broker.md)
    * [高可用](Architecture/架构基础/高可用.md)
    * [高性能](Architecture/架构基础/高性能.md)
    * [架构设计原则](Architecture/架构基础/架构设计原则.md)
    * [架构原则](Architecture/架构基础/架构原则.md)
    * [可扩展](Architecture/架构基础/可扩展.md)
    * [模块化](Architecture/架构基础/模块化.md)
    * [业务架构](Architecture/架构基础/业务架构.md)
  - 建模
    * [PERM](Architecture/建模/PERM.md)
  - 网关
    * [微服务与API网关](Architecture/网关/微服务与API网关.md)
  - DDD
    * [1.基础](Architecture/DDD/1.基础.md)
    * [参考资料](Architecture/DDD/参考资料.md)
  - JOB
    * [设计](Architecture/JOB/设计.md)
  - MQ
    - Kafka
      * [常见问题](Architecture/MQ/Kafka/常见问题.md)
      * [架构](Architecture/MQ/Kafka/架构.md)
      * [kafka介绍](Architecture/MQ/Kafka/kafka介绍.md)
    - Notes
      * [RabbitMQ和Kafka的比较](Architecture/MQ/Notes/RabbitMQ和Kafka的比较.md)
    - Rabbit Mq
      - Notes
        * [常见问题](Architecture/MQ/RabbitMq/Notes/常见问题.md)
        * [存储机制](Architecture/MQ/RabbitMq/Notes/存储机制.md)
        * [错误问题处理](Architecture/MQ/RabbitMq/Notes/错误问题处理.md)
        * [消息持久化](Architecture/MQ/RabbitMq/Notes/消息持久化.md)
        * [消息确认机制](Architecture/MQ/RabbitMq/Notes/消息确认机制.md)
      * [1. RabbitMq的基础](Architecture/MQ/RabbitMq/1. RabbitMq的基础.md)
      * [2. RabbitMq的概念](Architecture/MQ/RabbitMq/2. RabbitMq的概念.md)
      * [x1. RabbitMQ与Redis队列对比](Architecture/MQ/RabbitMq/x1. RabbitMQ与Redis队列对比.md)
    * [消息队列](Architecture/MQ/消息队列.md)
- Base
  - 架构
    * [1.如何保证缓存与数据双写一致性](Base/架构/1.如何保证缓存与数据双写一致性.md)
  - 文件系统
    * [文件系统原理](Base/文件系统/文件系统原理.md)
  - 性能
    * [1.缓存](Base/性能/1.缓存.md)
  - 异步编程
    * [基于任务的异步编程](Base/异步编程/基于任务的异步编程.md)
  - Networks
    - 常见问题
      * [跨域](Base/Networks/常见问题/跨域.md)
      * [三次握手和四次分手](Base/Networks/常见问题/三次握手和四次分手.md)
      * [RPC和REST](Base/Networks/常见问题/RPC和REST.md)
      * [RPC框架](Base/Networks/常见问题/RPC框架.md)
    - 进程和线程
      * [多线程和多线程](Base/Networks/进程和线程/多线程和多线程.md)
      * [进程、线程、协程](Base/Networks/进程和线程/进程、线程、协程.md)
      * [进程间通信方式有哪些](Base/Networks/进程和线程/进程间通信方式有哪些.md)
      * [进程切换](Base/Networks/进程和线程/进程切换.md)
      * [通道 Chan](Base/Networks/进程和线程/通道 Chan.md)
      * [同步异步、阻塞非阻塞](Base/Networks/进程和线程/同步异步、阻塞非阻塞.md)
      * [协程](Base/Networks/进程和线程/协程.md)
    - 执行体
      * [协同](Base/Networks/执行体/协同.md)
    - HTTP
      * [1. 互联网协议入门](Base/Networks/HTTP/1. 互联网协议入门.md)
      * [2. HTTP协议入门](Base/Networks/HTTP/2. HTTP协议入门.md)
      * [3. HTTP报文内的HTTP信息](Base/Networks/HTTP/3. HTTP报文内的HTTP信息.md)
      * [4. HTTP状态码](Base/Networks/HTTP/4. HTTP状态码.md)
      * [6. HTTPS](Base/Networks/HTTP/6. HTTPS.md)
      * [7. 用户身份的认证](Base/Networks/HTTP/7. 用户身份的认证.md)
      * [Untitled](Base/Networks/HTTP/Untitled.md)
    - [IO编程](Base/Networks/IO编程/IO编程.md)
      * [IO](Base/Networks/IO编程/IO.md)
      * [IO定义](Base/Networks/IO编程/IO定义.md)
      * [IO模型](Base/Networks/IO编程/IO模型.md)
    - Notes
      * [多进程共用数据库连接问题](Base/Networks/Notes/多进程共用数据库连接问题.md)
  - OOAD
    - 面向对象
      * [抽象类和接口](Base/OOAD/面向对象/抽象类和接口.md)
      * [对象](Base/OOAD/面向对象/对象.md)
      * [多态](Base/OOAD/面向对象/多态.md)
      * [封装](Base/OOAD/面向对象/封装.md)
      * [克隆](Base/OOAD/面向对象/克隆.md)
      * [控制反转](Base/OOAD/面向对象/控制反转.md)
      * [类的变量](Base/OOAD/面向对象/类的变量.md)
      * [依赖注入](Base/OOAD/面向对象/依赖注入.md)
      * [MVC](Base/OOAD/面向对象/MVC.md)
      * [ORM](Base/OOAD/面向对象/ORM.md)
- Business
  - 权限
    * [Casbin](Business/权限/Casbin.md)
  - 注册登录
    * [单点登录](Business/注册登录/单点登录.md)
  * [1.服务端接口版本问题](Business/1.服务端接口版本问题.md)
  * [2.一致性问题](Business/2.一致性问题.md)
  * [3.if else 太多](Business/3.if else 太多.md)
  * [4.如何做监控统计](Business/4.如何做监控统计.md)
  * [5.规则引擎](Business/5.规则引擎.md)
  * [6.滑块验证码](Business/6.滑块验证码.md)
  * [7.大规模上报一致性问题](Business/7.大规模上报一致性问题.md)
  * [8.状态机](Business/8.状态机.md)
- Cloud
  - [云存储](Cloud/云存储/云存储.md)
  - [Docker](Cloud/Docker/README.md)
    - [常见问题](Cloud/Docker/常见问题/常见问题.md)
      * [Certificate Signed By Unknown Authority](Cloud/Docker/常见问题/certificate signed by unknown authority.md)
      * [No Route To Host](Cloud/Docker/常见问题/no route to host.md)
    * [0. 简介](Cloud/Docker/0. 简介.md)
    * [1. 安装](Cloud/Docker/1. 安装.md)
    * [2. 基本概念](Cloud/Docker/2. 基本概念.md)
    * [3. 镜像操作](Cloud/Docker/3. 镜像操作.md)
    * [4. 容器操作](Cloud/Docker/4. 容器操作.md)
    * [5. 仓库操作](Cloud/Docker/5. 仓库操作.md)
    * [6. 数据卷](Cloud/Docker/6. 数据卷.md)
    * [7. 资源列表](Cloud/Docker/7. 资源列表.md)
    * [8. 应用](Cloud/Docker/8. 应用.md)
  - Kubernetes
    * [安装](Cloud/Kubernetes/安装.md)
    * [基础知识](Cloud/Kubernetes/基础知识.md)
    * [说明](Cloud/Kubernetes/说明.md)
  - [Micro Services](Cloud/MicroServices/README.md)
    * [1. 服务框架](Cloud/MicroServices/1. 服务框架.md)
    * [3. 服务安全](Cloud/MicroServices/3. 服务安全.md)
    * [4. 后台服务](Cloud/MicroServices/4. 后台服务.md)
    * [5. 服务容错](Cloud/MicroServices/5. 服务容错.md)
    * [6. 服务监控](Cloud/MicroServices/6. 服务监控.md)
    * [7. 服务部署平台](Cloud/MicroServices/7. 服务部署平台.md)
    * [8. 服务化](Cloud/MicroServices/8. 服务化.md)
    * [参考资料](Cloud/MicroServices/参考资料.md)
    * [HTTP](Cloud/MicroServices/HTTP.md)
    * [RPC](Cloud/MicroServices/RPC.md)
    * [x1. API网关](Cloud/MicroServices/x1. API网关.md)
    * [x2. 服务发现](Cloud/MicroServices/x2. 服务发现.md)
    * [x3 监控](Cloud/MicroServices/x3 监控.md)
- Concept
  * [Etcd](Concept/etcd.md)
  * [Swoole](Concept/Swoole.md)
- Data
  - [Algorithm](Data/Algorithm/README.md)
    - 排序
      * [插入排序](Data/Algorithm/排序/插入排序.md)
      * [快速排序](Data/Algorithm/排序/快速排序.md)
      * [冒泡排序](Data/Algorithm/排序/冒泡排序.md)
      * [选择排序](Data/Algorithm/排序/选择排序.md)
      * [直接插入排序](Data/Algorithm/排序/直接插入排序.md)
    * [参考资料](Data/Algorithm/参考资料.md)
    * [哈希算法](Data/Algorithm/哈希算法.md)
    * [一致性hash](Data/Algorithm/一致性hash.md)
  - Data Structure
    - 数据结构
      * [1. 什么是数据结构](Data/DataStructure/数据结构/1. 什么是数据结构.md)
      * [2. 线性表](Data/DataStructure/数据结构/2. 线性表.md)
      * [3. 链表](Data/DataStructure/数据结构/3. 链表.md)
      * [4. 数组](Data/DataStructure/数据结构/4. 数组.md)
      * [5. 栈](Data/DataStructure/数据结构/5. 栈.md)
      * [6. 队列](Data/DataStructure/数据结构/6. 队列.md)
      * [7. 哈希表](Data/DataStructure/数据结构/7. 哈希表.md)
      * [8. 堆](Data/DataStructure/数据结构/8. 堆.md)
      * [9. 二叉查找树](Data/DataStructure/数据结构/9. 二叉查找树.md)
    - Notes
      * [Hash表的时间复杂度为什么是O(1)](Data/DataStructure/Notes/Hash表的时间复杂度为什么是O(1).md)
    * [1 简介](Data/DataStructure/1 简介.md)
    * [2 时间复杂度](Data/DataStructure/2 时间复杂度.md)
- Data Base
  - [Cache](DataBase/Cache/README.md)
    * [如何保证缓存与数据库的双写一致性](DataBase/Cache/如何保证缓存与数据库的双写一致性.md)
    * [Memcached和Redis对比](DataBase/Cache/Memcached和Redis对比.md)
  - ES
    * [倒排索引](DataBase/ES/倒排索引.md)
    * [概念](DataBase/ES/概念.md)
    * [入门](DataBase/ES/入门.md)
  - Memcached
    * [Memcached介绍](DataBase/Memcached/Memcached介绍.md)
    * [Memcached使用](DataBase/Memcached/Memcached使用.md)
  - Mongo DB
    * [安装](DataBase/MongoDB/安装.md)
    * [MongoDB查询](DataBase/MongoDB/MongoDB查询.md)
    * [MongoDB连接](DataBase/MongoDB/MongoDB连接.md)
    * [MongoDB入门](DataBase/MongoDB/MongoDB入门.md)
  - My Cat
    * [原理](DataBase/MyCat/原理.md)
    * [Mycat中的概念](DataBase/MyCat/Mycat中的概念.md)
  - My SQL
    - 基础篇
      * [1. Mysql](DataBase/MySQL/基础篇/1. Mysql.md)
      * [2. 数据库操作](DataBase/MySQL/基础篇/2. 数据库操作.md)
      * [3. 数据类型](DataBase/MySQL/基础篇/3. 数据类型.md)
      * [4. 数据库设计](DataBase/MySQL/基础篇/4. 数据库设计.md)
      * [5. 索引](DataBase/MySQL/基础篇/5. 索引.md)
      * [6. 事务](DataBase/MySQL/基础篇/6. 事务.md)
      * [编码](DataBase/MySQL/基础篇/编码.md)
      * [范式](DataBase/MySQL/基础篇/范式.md)
      * [一条SQL查询语句是如何执行的？](DataBase/MySQL/基础篇/一条SQL查询语句是如何执行的？.md)
    - 实践篇
      * [1. 事务回滚](DataBase/MySQL/实践篇/1. 事务回滚.md)
      * [2. 隐式转换](DataBase/MySQL/实践篇/2. 隐式转换.md)
      * [3. 分库分表](DataBase/MySQL/实践篇/3. 分库分表.md)
    - 事务和锁
      * [表锁&行锁](DataBase/MySQL/事务和锁/表锁&行锁.md)
      * [乐观锁&悲观锁](DataBase/MySQL/事务和锁/乐观锁&悲观锁.md)
      * [事务](DataBase/MySQL/事务和锁/事务.md)
      * [数据库锁](DataBase/MySQL/事务和锁/数据库锁.md)
      * [mysql死锁的条件及应对措施](DataBase/MySQL/事务和锁/mysql死锁的条件及应对措施.md)
    - 性能优化
      * [0. 性能优化](DataBase/MySQL/性能优化/0. 性能优化.md)
      * [1. 执行优化](DataBase/MySQL/性能优化/1. 执行优化.md)
      * [2. 架构优化](DataBase/MySQL/性能优化/2. 架构优化.md)
    - Note
      * [如何进行分库分表](DataBase/MySQL/Note/如何进行分库分表.md)
      * [如何选择主库和从库](DataBase/MySQL/Note/如何选择主库和从库.md)
      * [如何做数据恢复](DataBase/MySQL/Note/如何做数据恢复.md)
      * [删除和添加索引，为什么要先加后删](DataBase/MySQL/Note/删除和添加索引，为什么要先加后删.md)
      * [什么是关系表](DataBase/MySQL/Note/什么是关系表.md)
      * [数据库单表由万级变成亿级，怎么处理](DataBase/MySQL/Note/数据库单表由万级变成亿级，怎么处理.md)
      * [索引失效的场景](DataBase/MySQL/Note/索引失效的场景.md)
      * [一条SQL查询语句是如何执行的](DataBase/MySQL/Note/一条SQL查询语句是如何执行的.md)
      * [count查询为什么会慢](DataBase/MySQL/Note/count查询为什么会慢.md)
      * [MySQL 意外宕机，如何数据恢复](DataBase/MySQL/Note/MySQL 意外宕机，如何数据恢复.md)
      * [Mysql安装](DataBase/MySQL/Note/Mysql安装.md)
      * [mysql查询语句怎么做性能分析？](DataBase/MySQL/Note/mysql查询语句怎么做性能分析？.md)
      * [mysql批量删除表名符合条件的表](DataBase/MySQL/Note/mysql批量删除表名符合条件的表.md)
      * [MySQL数据库规范](DataBase/MySQL/Note/MySQL数据库规范.md)
      * [Pt Online Schema Change](DataBase/MySQL/Note/pt-online-schema-change.md)
      * [SQL慢查优化方案](DataBase/MySQL/Note/SQL慢查优化方案.md)
      * [Warning PDO Statementexecute SQLSTATE HY 093 Invalid Parameter Number Number Of Bound Variables Does Not Match Number Of Tokens](DataBase/MySQL/Note/Warning PDOStatementexecute() SQLSTATE[HY093] Invalid parameter number number of bound variables does not match number of tokens.md)
    * [x1. 常见问题](DataBase/MySQL/x1. 常见问题.md)
    * [x2 参考资料](DataBase/MySQL/x2 参考资料.md)
    * [x3 资料推荐](DataBase/MySQL/x3 资料推荐.md)
  - Redis
    - 多线程
      * [KeyDB实现](DataBase/Redis/多线程/KeyDB实现.md)
      * [Redis 多线程](DataBase/Redis/多线程/Redis 多线程.md)
    - 分布式
      * [集群](DataBase/Redis/分布式/集群.md)
      * [清理集群](DataBase/Redis/分布式/清理集群.md)
      * [哨兵机制](DataBase/Redis/分布式/哨兵机制.md)
      * [主从复制](DataBase/Redis/分布式/主从复制.md)
      * [Redis分布式锁](DataBase/Redis/分布式/Redis分布式锁.md)
    - 基础知识
      * [1. 简介](DataBase/Redis/基础知识/1. 简介.md)
      * [2. 数据结构](DataBase/Redis/基础知识/2. 数据结构.md)
      * [配置说明](DataBase/Redis/基础知识/配置说明.md)
      * [问题画像](DataBase/Redis/基础知识/问题画像.md)
      * [知识图](DataBase/Redis/基础知识/知识图.md)
    - 进阶
      * [管道](DataBase/Redis/进阶/管道.md)
      * [消息队列](DataBase/Redis/进阶/消息队列.md)
      * [性能调优](DataBase/Redis/进阶/性能调优.md)
      * [性能分析](DataBase/Redis/进阶/性能分析.md)
      * [优化建议](DataBase/Redis/进阶/优化建议.md)
      * [redis升级](DataBase/Redis/进阶/redis升级.md)
    - [使用场景](DataBase/Redis/使用场景/使用场景.md)
      * [数据类型适用场景](DataBase/Redis/使用场景/数据类型适用场景.md)
      * [Redis的问题](DataBase/Redis/使用场景/Redis的问题.md)
    - 数据结构
      * [底层的数据结构](DataBase/Redis/数据结构/底层的数据结构.md)
      * [复杂度](DataBase/Redis/数据结构/复杂度.md)
      * [键值](DataBase/Redis/数据结构/键值.md)
      * [内存分配](DataBase/Redis/数据结构/内存分配.md)
    - Notes
      * [缓存特征、介质](DataBase/Redis/Notes/缓存特征、介质.md)
      * [如果有大量的key需要设置同一时间过期，一般需要注意什么？](DataBase/Redis/Notes/如果有大量的key需要设置同一时间过期，一般需要注意什么？.md)
      * [如何查找key](DataBase/Redis/Notes/如何查找key.md)
      * [如何应对缓存穿透和缓存雪崩问题？](DataBase/Redis/Notes/如何应对缓存穿透和缓存雪崩问题？.md)
      * [如何找到最大值对应的key](DataBase/Redis/Notes/如何找到最大值对应的key.md)
      * [为什么要使用Nosql](DataBase/Redis/Notes/为什么要使用Nosql.md)
      * [为什么Redis 是单线程却能支撑高并发](DataBase/Redis/Notes/为什么Redis 是单线程却能支撑高并发.md)
      * [应用场景](DataBase/Redis/Notes/应用场景.md)
      * [Redis 字典遍历](DataBase/Redis/Notes/Redis 字典遍历.md)
      * [Redis Cluster请求路由原理](DataBase/Redis/Notes/Redis Cluster请求路由原理.md)
      * [Redis的监控](DataBase/Redis/Notes/Redis的监控.md)
      * [Redis的同步机制](DataBase/Redis/Notes/Redis的同步机制.md)
      * [redis的hash怎么实现的？](DataBase/Redis/Notes/redis的hash怎么实现的？.md)
      * [redis过期策略和缓存置换策略](DataBase/Redis/Notes/redis过期策略和缓存置换策略.md)
      * [Redis缓存数据类型的选择 ](DataBase/Redis/Notes/Redis缓存数据类型的选择 .md)
      * [Redis集群之间是如何复制？](DataBase/Redis/Notes/Redis集群之间是如何复制？.md)
      * [Redis迁移](DataBase/Redis/Notes/Redis迁移.md)
      * [Redis如何做持久化的](DataBase/Redis/Notes/Redis如何做持久化的.md)
      * [Redis写入大量数据后，为什么变慢了](DataBase/Redis/Notes/Redis写入大量数据后，为什么变慢了.md)
      * [redis有哪些危险的命令？怎么避免](DataBase/Redis/Notes/redis有哪些危险的命令？怎么避免.md)
    * [参考资料](DataBase/Redis/参考资料.md)
- Distributed
  - Zookeeper
    * [常见问题](Distributed/Zookeeper/常见问题.md)
  * [多线程环境解决方案](Distributed/多线程环境解决方案.md)
  * [分布式链路追踪](Distributed/分布式链路追踪.md)
  * [分布式事务](Distributed/分布式事务.md)
  * [分布式系统原理以及常用解决方案](Distributed/分布式系统原理以及常用解决方案.md)
  * [分布式最终一致性](Distributed/分布式最终一致性.md)
  * [数据一致性](Distributed/数据一致性.md)
  * [一致性哈希](Distributed/一致性哈希.md)
  * [CAP定理](Distributed/CAP定理.md)
  * [Map Reduce](Distributed/MapReduce.md)
  * [Untitled](Distributed/Untitled.md)
- [Front End](FrontEnd/README.md)
  - [01 前端工具](FrontEnd/01 前端工具/README.md)
    * [Apidoc](FrontEnd/01 前端工具/Apidoc.md)
    * [Sublime](FrontEnd/01 前端工具/Sublime.md)
    * [Webpack](FrontEnd/01 前端工具/Webpack.md)
    * [Web Storm](FrontEnd/01 前端工具/WebStorm.md)
  - 04 Java Script
    * [javascript上传图片检测宽度高度文件大小](FrontEnd/04 JavaScript/javascript上传图片检测宽度高度文件大小.md)
    * [js中iframe的使用](FrontEnd/04 JavaScript/js中iframe的使用.md)
  - 10 Vue
    * [开源项目库汇总](FrontEnd/10 Vue/开源项目库汇总.md)
    * [学习步骤](FrontEnd/10 Vue/学习步骤.md)
    * [Awesome](FrontEnd/10 Vue/awesome.md)
    * [My Vue](FrontEnd/10 Vue/MyVue.md)
    * [Vue](FrontEnd/10 Vue/Vue.md)
    * [Vuejs入门](FrontEnd/10 Vue/Vuejs入门.md)
  - x1 资源
    * [博客推荐](FrontEnd/x1 资源/博客推荐.md)
  - x2 常见问题
    * [Cross Domain](FrontEnd/x2 常见问题/Cross-domain.md)
- Notes
  - 1.Shell
    * [常用命令](Notes/1.Shell/常用命令.md)
    * [替换功能](Notes/1.Shell/替换功能.md)
    * [Gocron处理Docker进程的问题](Notes/1.Shell/Gocron处理Docker进程的问题.md)
    * [Shell中date命令用法](Notes/1.Shell/Shell中date命令用法.md)
    * [shell字符串](Notes/1.Shell/shell字符串.md)
  - 编码
    * [参考资料](Notes/编码/参考资料.md)
    * [代码调试](Notes/编码/代码调试.md)
    * [代码规范](Notes/编码/代码规范.md)
    * [代码简洁之道](Notes/编码/代码简洁之道.md)
    * [代码质量](Notes/编码/代码质量.md)
    * [代码走查](Notes/编码/代码走查.md)
  - 监控
    * [Prometheus](Notes/监控/Prometheus.md)
  - 开发
    * [脚本常见问题](Notes/开发/脚本常见问题.md)
  - 开发流程
    * [持续集成](Notes/开发流程/持续集成.md)
  - 其他
    * [Gitbook自动生成SUMMARY](Notes/其他/Gitbook自动生成SUMMARY.md)
  - [API](Notes/API/API.md)
    * [API加密方案](Notes/API/API加密方案.md)
    * [api设计](Notes/API/api设计.md)
  - Git
    * [常见问题](Notes/Git/常见问题.md)
    * [代码回滚](Notes/Git/代码回滚.md)
    * [多版本工作流](Notes/Git/多版本工作流.md)
    * [工作流](Notes/Git/工作流.md)
    * [快速入门Git](Notes/Git/快速入门Git.md)
    * [三路合并](Notes/Git/三路合并.md)
    * [git blame出现的人员不一致](Notes/Git/git blame出现的人员不一致.md)
    * [Git撤销merge合并](Notes/Git/Git撤销merge合并.md)
    * [Git忽略.gitignore](Notes/Git/Git忽略.gitignore.md)
    * [Git远程分支](Notes/Git/Git远程分支.md)
  - HTTP
    * [499问题处理](Notes/HTTP/499问题处理.md)
    * [HTTP状态码](Notes/HTTP/HTTP状态码.md)
  - Linux
    * [安装扩展](Notes/Linux/安装扩展.md)
    * [回收站](Notes/Linux/回收站.md)
    * [解析配置](Notes/Linux/解析配置.md)
    * [命令](Notes/Linux/命令.md)
    * [文件权限问题](Notes/Linux/文件权限问题.md)
    * [Apache 和 nginx](Notes/Linux/Apache 和 nginx.md)
    * [Linux 防止rm误删文件，将rm配置成mv到.trash ](Notes/Linux/Linux 防止rm误删文件，将rm配置成mv到.trash .md)
    * [Linux 中 Crontab 定时任务执行时的环境变量问题](Notes/Linux/Linux 中 Crontab 定时任务执行时的环境变量问题.md)
    * [Linux下执行shell脚本，提示No such file or directory](Notes/Linux/Linux下执行shell脚本，提示No such file or directory.md)
    * [linux压缩和解压缩命令大全](Notes/Linux/linux压缩和解压缩命令大全.md)
    * [Untitled](Notes/Linux/Untitled.md)
    * [Vim批量替换](Notes/Linux/Vim批量替换.md)
  - [Nginx](Notes/Nginx/nginx.md)
    * [ERR_CONTENT_LENGTH_MISMATCH解决方法](Notes/Nginx/ERR_CONTENT_LENGTH_MISMATCH解决方法.md)
    * [Nginx 和 Apache 各有什么优缺点？](Notes/Nginx/Nginx 和 Apache 各有什么优缺点？.md)
    * [windows下安装LNMP](Notes/Nginx/windows下安装LNMP.md)
- Ops
  * [软件和架构标准化](Ops/软件和架构标准化.md)
- PHP
  - 0.原理
    * [php的四种运行模式](PHP/0.原理/php的四种运行模式.md)
  - 1.语言参考
    * [命名空间](PHP/1.语言参考/命名空间.md)
    * [事件系统](PHP/1.语言参考/事件系统.md)
    * [数组](PHP/1.语言参考/数组.md)
    * [注解](PHP/1.语言参考/注解.md)
    * [Collection](PHP/1.语言参考/Collection.md)
  - 2.编码
    * [代码分析](PHP/2.编码/代码分析.md)
    * [事务和锁代码优化](PHP/2.编码/事务和锁代码优化.md)
    * [Sonar Qube](PHP/2.编码/SonarQube.md)
    * [Validate](PHP/2.编码/Validate.md)
  - 3.框架
    - 基础
      * [Swoole高效跟传统的web开发区别](PHP/3.框架/基础/Swoole高效跟传统的web开发区别.md)
    - [Codeigniter](PHP/3.框架/Codeigniter/README.md)
      * [安全性](PHP/3.框架/Codeigniter/安全性.md)
      * [钩子](PHP/3.框架/Codeigniter/钩子.md)
      * [缓存机制](PHP/3.框架/Codeigniter/缓存机制.md)
      * [路由](PHP/3.框架/Codeigniter/路由.md)
      * [配置管理](PHP/3.框架/Codeigniter/配置管理.md)
      * [Common](PHP/3.框架/Codeigniter/Common.md)
      * [MVC](PHP/3.框架/Codeigniter/MVC.md)
      * [ORM的接口](PHP/3.框架/Codeigniter/ORM的接口.md)
    - Laravel
      * [介绍](PHP/3.框架/Laravel/介绍.md)
      * [最佳实践](PHP/3.框架/Laravel/最佳实践.md)
    - Laravel Admin
      * [介绍](PHP/3.框架/Laravel-admin/介绍.md)
    - Lumen
      * [脚本](PHP/3.框架/Lumen/脚本.md)
      * [入门](PHP/3.框架/Lumen/入门.md)
    - Slim
      * [如何编写Cron脚本](PHP/3.框架/Slim/如何编写Cron脚本.md)
    - [Swoft](PHP/3.框架/Swoft/README.md)
      - [数据库操作](PHP/3.框架/Swoft/数据库操作/数据库操作.md)
        * [Dao](PHP/3.框架/Swoft/数据库操作/Dao.md)
        * [x0 学习资料](PHP/3.框架/Swoft/数据库操作/x0 学习资料.md)
      * [0. 安装](PHP/3.框架/Swoft/0. 安装.md)
      * [1. 目录结构](PHP/3.框架/Swoft/1. 目录结构.md)
      * [2. 生命周期](PHP/3.框架/Swoft/2. 生命周期.md)
      * [3. HTTP服务](PHP/3.框架/Swoft/3. HTTP服务.md)
      * [4. 缓存](PHP/3.框架/Swoft/4. 缓存.md)
      * [6. 视图](PHP/3.框架/Swoft/6. 视图.md)
      * [注解](PHP/3.框架/Swoft/注解.md)
      * [Task](PHP/3.框架/Swoft/Task.md)
      * [x1. 问题](PHP/3.框架/Swoft/x1. 问题.md)
    - Swoole
      * [swoole协程](PHP/3.框架/Swoole/swoole协程.md)
    - Tars
      * [安装后台](PHP/3.框架/tars/安装后台.md)
  - 4.进阶
    - 加密
      * [AES](PHP/4.进阶/加密/AES.md)
    - [进程](PHP/4.进阶/进程/进程.md)
      * [管道](PHP/4.进阶/进程/管道.md)
      * [进程间通信](PHP/4.进阶/进程/进程间通信.md)
    - 扩展
      * [如何编写一个PHP的C扩展](PHP/4.进阶/扩展/如何编写一个PHP的C扩展.md)
    - 内核
      * [参考资料](PHP/4.进阶/内核/参考资料.md)
      * [看源码原则](PHP/4.进阶/内核/看源码原则.md)
    - Composer
      * [参数](PHP/4.进阶/Composer/参数.md)
      * [钩子](PHP/4.进阶/Composer/钩子.md)
      * [类加载优化](PHP/4.进阶/Composer/类加载优化.md)
      * [PSR](PHP/4.进阶/Composer/PSR.md)
  - 5.性能
    - 调用链
      * [跟踪系统](PHP/5.性能/调用链/跟踪系统.md)
    - 性能分析
      * [非侵入式监控平台](PHP/5.性能/性能分析/非侵入式监控平台.md)
      * [接口性能分析实践](PHP/5.性能/性能分析/接口性能分析实践.md)
      * [Xhprof](PHP/5.性能/性能分析/xhprof.md)
    - Notes
      * [Opcache 和 APCu的关系](PHP/5.性能/Notes/Opcache 和 APCu的关系.md)
    * [并发和异步](PHP/5.性能/并发和异步.md)
    * [APCU](PHP/5.性能/APCU.md)
    * [Xdebug](PHP/5.性能/Xdebug.md)
  - 6.常见问题
    * [常见问题](PHP/6.常见问题/常见问题.md)
    * [常用函数](PHP/6.常见问题/常用函数.md)
    * [反射类](PHP/6.常见问题/反射类.md)
    * [浮点数的精度](PHP/6.常见问题/浮点数的精度.md)
    * [环境搭建常见问题](PHP/6.常见问题/环境搭建常见问题.md)
    * [获取当前客户端的 IP 地址](PHP/6.常见问题/获取当前客户端的 IP 地址.md)
    * [垃圾回收机制](PHP/6.常见问题/垃圾回收机制.md)
    * [敏感词过滤](PHP/6.常见问题/敏感词过滤.md)
    * [魔术方法](PHP/6.常见问题/魔术方法.md)
    * [内网和外网](PHP/6.常见问题/内网和外网.md)
    * [生成器](PHP/6.常见问题/生成器.md)
    * [事务处理](PHP/6.常见问题/事务处理.md)
    * [无法常驻内存](PHP/6.常见问题/无法常驻内存.md)
    * [析构函数](PHP/6.常见问题/析构函数.md)
    * [字符串加密解密](PHP/6.常见问题/字符串加密解密.md)
    * [AOP](PHP/6.常见问题/AOP.md)
    * [Curl](PHP/6.常见问题/Curl.md)
    * [GET与POST的区别](PHP/6.常见问题/GET与POST的区别.md)
    * [include和require的区别](PHP/6.常见问题/include和require的区别.md)
    * [IP地址函数ip2long](PHP/6.常见问题/IP地址函数ip2long.md)
    * [Iterator](PHP/6.常见问题/Iterator.md)
    * [JSON](PHP/6.常见问题/JSON.md)
    * [JSON解密的问题](PHP/6.常见问题/JSON解密的问题.md)
    * [Nginx 设置 PHP_VALUE 的灵异问题](PHP/6.常见问题/Nginx 设置 PHP_VALUE 的灵异问题.md)
    * [Nginx和PHP-fpm的关系](PHP/6.常见问题/Nginx和PHP-fpm的关系.md)
    * [php 后端实现JWT认证方法](PHP/6.常见问题/php 后端实现JWT认证方法.md)
    * [PHP Jit](PHP/6.常见问题/PHP jit.md)
    * [PHP程序如何debug](PHP/6.常见问题/PHP程序如何debug.md)
    * [PHP升级可能导致的坑](PHP/6.常见问题/PHP升级可能导致的坑.md)
    * [php数组](PHP/6.常见问题/php数组.md)
    * [PHP注解的实现](PHP/6.常见问题/PHP注解的实现.md)
    * [Session 和 Cookie](PHP/6.常见问题/Session 和 Cookie.md)
    * [xdebug的使用](PHP/6.常见问题/xdebug的使用.md)
  - 7.不足
    * [无法常驻内存](PHP/7.不足/无法常驻内存.md)
  - 8.面试题
    * [参考资料](PHP/8.面试题/参考资料.md)
    * [面试题](PHP/8.面试题/面试题.md)
  - 9. 文件操作
    * [大文件读取](PHP/9. 文件操作/大文件读取.md)
    * [文件锁](PHP/9. 文件操作/文件锁.md)
- [Resource](Resource/README.md)
  - Github
    * [Github项目推荐](Resource/Github/Github项目推荐.md)
  - Interview
    * [腾讯面试](Resource/Interview/腾讯面试.md)
  - [Tools](Resource/Tools/README.md)
    - Git
      * [代码回滚](Resource/Tools/Git/代码回滚.md)
      * [多版本工作流](Resource/Tools/Git/多版本工作流.md)
      * [工作流](Resource/Tools/Git/工作流.md)
      * [Git忽略.gitignore](Resource/Tools/Git/Git忽略.gitignore.md)
      * [Source Tree](Resource/Tools/Git/SourceTree.md)
    * [流程图](Resource/Tools/流程图.md)
    * [思维导图](Resource/Tools/思维导图.md)
    * [Markdown](Resource/Tools/Markdown.md)
    * [Other](Resource/Tools/Other.md)
    * [Postman](Resource/Tools/Postman.md)
    * [Sublime](Resource/Tools/Sublime.md)
  - [Website](Resource/Website/README.md)
- Team
  - 研发效能
    * [持续开发](Team/研发效能/持续开发.md)
    * [定义](Team/研发效能/定义.md)
    * [度量](Team/研发效能/度量.md)
  * [工作总结](Team/工作总结.md)
  * [研发体系](Team/研发体系.md)
- Web
  * [多环境测试方案](Web/多环境测试方案.md)
  * [应用框架](Web/应用框架.md)
  * [Web测试](Web/Web测试.md)
  * [Web基础开发](Web/Web基础开发.md)
