# Git 分支管理最佳实践

## TBD：单主干
单主干的分支实践（Trunk-based development，TBD）在 SVN 中比较流行。Google 和 Facebook 都使用这种方式。trunk 是 SVN 中主干分支的名称，对应到 Git 中则是 master 分支。TBD 的特点是所有团队成员都在单个主干分支上进行开发。当需要发布时，先考虑使用标签（tag），即 tag 某个 commit 来作为发布的版本。如果仅靠 tag 不能满足要求，则从主干分支创建发布分支。bug 修复在主干分支中进行，再 cherry-pick 到发布分支。
![TBD 中的分支流程的示意图](https://www.ibm.com/developerworks/cn/java/j-lo-git-mange/img001.png)

## GitHub flow
1. 任何开发人员都不允许把未测试或未审查的代码直接提交到 master 分支。

## Gitlab flow

## Git flow


## 常见问题
#### Release 和 Tag 的区别
> Releases are first-class objects with changelogs and binary assets that present a full project history beyond Git artifacts.
翻译：Release是具有changelogs和二进制文件的一级对象，它可以代表超出Git架构本身的一个特定时间点之前的所有项目历史。

1. 标签是git中的概念，而release则是Github、码云等源码托管商所提供的更高层的概念。也就是说git本身是没有release这个概念的，只有tag。
2. 两者之间的关系则是，release基于tag，为tag添加更丰富的信息，一般是编译好的文件。

## 参考资料
* [Git 分支管理最佳实践](https://www.ibm.com/developerworks/cn/java/j-lo-git-mange/index.html)
* [git cherry-pick 使用指南](https://www.jianshu.com/p/08c3f1804b36)
* [GitHub Flow](http://scottchacon.com/2011/08/31/github-flow.html)
* [What's the difference between tag and release?
](https://stackoverflow.com/questions/18506508/whats-the-difference-between-tag-and-release)
* [A successful Git branching model](http://nvie.com/posts/a-successful-git-branching-model/)