# 生成器

生成器函数的核心是**yield**关键字。它最简单的调用形式看起来像一个return申明，不同之处在于普通return会返回值并终止函数的执行，而yield会返回一个值给循环调用此生成器的代码并且只是暂停执行生成器函数。

## 目的

解决内存问题

## 解释

1. 一个生成器函数看起来像一个普通的函数，不同的是：普通函数返回一个值，而一个生成器可以yield生成许多它所需要的值。生成器函数被调用时，返回的是一个可以被遍历的对象。
2. yield和return有点类似，不过不同的是，return会返回值并且终止代码的执行，而yield会返回一个值给循环调用此生成器的代码并且只是暂停执行生成器函数。

3. PHP 会要求 Generator 实例计算并提供下一个要迭代的值。生成器的优雅体现在每次产出一个值之后，生成器的内部状态都会停顿；向生成器请求下一个值时，内部状态又会恢复。生成器内部的状态会一直在停顿和恢复之间切换，直到抵达函数定义体的末尾或遇到空的return语句为止。

## 相关文档
* [生成器](http://php.net/manual/zh/language.generators.syntax.php)
* [在PHP中使用协程实现多任务调度](http://www.laruence.com/2015/05/28/3038.html)
* [php之Generator生成器及yield](https://www.jianshu.com/p/86fefb0aacd9)