
## 接口加密/解密
```
/**
 * 功    能: 字符串加解密
 * 修改日期: 2018-08-27
 * @param string/array $data 用户数据
 * @param string $key 密钥
 * @param int $decrypt 0 加密 1解密
 * @param int $return_array 0 返回字符串 1 返回数据
 * @return mixed|string
 */
function encryptDecrypt($data, $key, $decrypt = 0, $return_array = 1)
{
    $data = is_array($data) ? json_encode($data) : $data;
    $encryption_key = base64_decode($key);
    if ($decrypt)
    {
        list($encrypted_data, $iv) = explode('::', base64_decode($data), 2);
        $return = openssl_decrypt($encrypted_data, 'aes-256-cbc', $encryption_key, 0, $iv);
    } else {
        $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length('aes-256-cbc'));
        $encrypted = openssl_encrypt($data, 'aes-256-cbc', $encryption_key, 0, $iv);
        $return = base64_encode($encrypted . '::' . $iv);
    }
    return $return_array ? json_decode($return, 1) : $return;
}
```

## 生成验证字段
### 其他检验字段：appid、expire
```
function makeSign($params, $key)
{
    if (isset($params['sign']))
    {
        unset($params['sign']);
    }
    //签名步骤一：按字典序排序参数
    ksort($params);
    $string = http_build_query($params);
    //签名步骤二：在string后加入KEY
    $string = $string . "&key=" . $key;
    //签名步骤三：MD5加密
    $string = md5($string);
    //签名步骤四：所有字符转为大写
    $result = strtoupper($string);
    return $result;
}
```

## 其他说明
对于不同用户的请求，最好根据用户生成不同的密钥

## 更多
http://php.net/manual/zh/openssl.installation.php

