## 引言
进程是一个具有独立功能的程序关于某个数据集合的一次运行活动。换句话说就是，在系统调度多个cpu的时候，一个程序的基本单元。

## 简介
php中的进程是以扩展的形式来完成。通过这些扩展，我们能够很轻松的完成进程的一系列动作。

pcntl扩展：主要的进程扩展，完成进程创建于等待操作。 （`yum install php-process`）
posix扩展：完成posix兼容机通用api,如获取进程id,杀死进程等。
sysvmsg扩展：实现system v方式的进程间通信之消息队列。
sysvsem扩展：实现system v方式的信号量。
sysvshm扩展：实现system v方式的共享内存。
sockets扩展：实现socket通信。

## 例子
```
$parentPid = posix_getpid();
echo "parent progress pid:{$parentPid}\n";
$childList = array();
$pid = pcntl_fork();
if ( $pid == -1) {
    // 创建失败
    exit("fork progress error!\n");
} else if ($pid == 0) {
    // 子进程执行程序
    $pid = posix_getpid();
    $repeatNum = 5;
    for ( $i = 1; $i <= $repeatNum; $i++) {
        echo "({$pid})child progress is running! {$i} \n";
        $rand = rand(1,3);
        sleep($rand);
    }
    exit("({$pid})child progress end!\n");
} else {
    // 父进程执行程序
    $childList[$pid] = 1;
}
// 等待子进程结束
pcntl_wait($status);
echo "({$parentPid})main progress end!";
```