## 匿名管道（pipe）
管道是IPC最基本的一种实现机制。我们都知道在Linux下“一切皆文件”，其实这里的管道就是一个文件。管道实现进程通信就是让两个进程都能访问该文件。 

#### 管道的特征： 
1. 只提供单向通信，也就是说，两个进程都能访问这个文件，假设进程1往文件内写东西，那么进程2 就只能读取文件的内容。 
2. 只能用于具有血缘关系的进程间通信，通常用于父子进程建通信 
3. 管道是基于字节流来通信的 
4. 依赖于文件系统，它的生命周期随进程的结束结束（随进程） 
5. 其本身自带同步互斥效果


## 命名管道（FIFO）
管道没有名字，因此它们的最大的劣势就是只能用于有一个共同祖先进程的各个进程之间的通信。我们无法在无亲缘关系的两个进程之间创建一个管道并将它作为IPC通道（不考虑描述符的传递）。管道的缺点就是只能在有亲缘关系的进程间进行通信，针对这个缺陷，又提出来了命名管道（FIFO）的概念。FIFO不同于管道之处在于它提供一个路径名与之关联,以FIFO的文件形式存储于文件系统中。命名管道是一个设备文件,因此,即使进程与创建FIFO的进程不存在亲缘关系,只要可以访问该路径,就能够通过FIFO相互通信。

FIFO指的就是先进先出（first in,first on），Unix中的FIFO类似管道。他是一个单向（半双工）的数据流。不同于管道的是，每个FIFO有一个路径与之相连，从而允许无亲缘关系之间的进程访问同一个FIFO。FIFO也称为有名管道（named pipe）。  

#### FIFO两个属性
1. FIFO是一个设备文件，在文件系统中以文件名的形式存在，因此即使进程与创建FIFO的进程不存在血缘关系也依然可以通信，前提是可以访问该路径。 
2. FIFO(first input first output)总是遵循先进先出的原则，即第一个进来的数据会第一个被读走。

## 命名管道与匿名管道使用的区别： 
命名管道创建完成后就可以使用，其使用方法与管道一样； 区别在于： 
1. 命名管道使用之前需要使用open()打开。这是因为：命名管道是设备文件，它是存储在硬盘上的，而管道是存在内存中的特殊文件。 
2. 但是需要注意的是，命名管道调用open()打开有可能会阻塞，但是如果以读写方式（O_RDWR）打开则一定不会阻塞； 
3. 命名管道以只读（O_RDONLY）方式打开时，调用open()的函数会被阻塞直到有数据可读； 
4. 命名管道如果以只写方式（O_WRONLY）打开时同样也会被阻塞，知道有以读方式打开该管道。

