
#### 配置获取
```
function &get_config(Array $replace = array())
{
    static $config;
    if (empty($config))
    {
        $file_path = APPPATH.'config/config.php';
        $found = FALSE;
        if (file_exists($file_path))
        {
            $found = TRUE;
            require($file_path);
        }
        // Is the config file in the environment folder?
        if (file_exists($file_path = APPPATH.'config/'.ENVIRONMENT.'/config.php'))
        {
            require($file_path);
        }
        elseif ( ! $found)
        {
            set_status_header(503);
            echo 'The configuration file does not exist.';
            exit(3); // EXIT_CONFIG
        }
        // Does the $config array exist in the file?
        if ( ! isset($config) OR ! is_array($config))
        {
            set_status_header(503);
            echo 'Your config file does not appear to be formatted correctly.';
            exit(3); // EXIT_CONFIG
        }
    }
    // Are any values being dynamically added or replaced?
    foreach ($replace as $key => $val)
    {
        $config[$key] = $val;
    }
    return $config;
}
```    