### PHP高可读处理事务

```
// 基本数据库查询及其他数据依赖
try {
    $db->begin(); // 开启事务
    // 逻辑处理一
    if (逻辑一处理结果不符合预期) {
        throw new DBException('message1', 'code1');
    }
 
 
    // 逻辑处理二
    if (逻辑二处理结果不符合预期) {
        throw new DBException('message2', 'code2');
    }
    ......
    $db->commit();
} catch (DBException $dbException) {
    if ($dbException->getCode() == '某个特定值') {
        $db->commit();// 如果存在某种特殊情况就算上面的处理结果不合预期也要提交数据库操作
    } else {
        $this->rollback();
        $logger->warning(logData);
    }
} catch (\Exception $exception) {
    ...
}
// 好的地方，commit永远在try代码块的最后一行，所有异常都是throw到catch中取处理
```

### PHP高可读处理锁

```
// 基本数据库查询及其他数据依赖
if (false === $redis->setnx($key)) {
    // 锁不可用，应该要退出后面的操作
}
try {
    $redis->expire($key, $ttl);
    // 逻辑处理一
    if (逻辑一处理结果不符合预期) {
        throw new Exception('message1', 'code1');
    }
 
 
    // 逻辑处理二
    if (逻辑二处理结果不符合预期) {
        throw new Exception('message2', 'code2');
    }
    ......
} catch (\Exception $exception) {
    // 获取到锁执行了操作，但是操作未成功
    ...
    $logger->error(logData);
} finally {
    $redis->del($key);
}
// 好的地方，在finally中进行锁释放，不用担心忘记释放
// 注意点 不能在finally之前任何地方使用exit die这类停止操作
```

