服务器运行一段时间后，可能突然会需求添加某个扩展，如curl、pdo、xmlrpc等，这就需要在不重新编译PHP的情况下独立添加扩展。
下面以安装curl及tidy为例，介绍具体安装步骤。

## 1.安装crul
wget http://curl.haxx.se/download/curl-7.19.6.tar.gz
tar -zxvf curl-7.19.6.tar.gz
cd curl-7.19.6
./configure --prefix=/usr/local/curl
make
make install

## 2.编译生成扩展
进入php源程序目录中的ext目录中，这里存放着各个扩展模块的源代码，选择你需要的模块，比如curl模块：
cd curl
执行phpize生成编译文件，phpize在PHP安装目录的bin目录下
/usr/local/php5/bin/phpize
运行时，可能会报错：Cannot find autoconf. Please check your autoconf installation and the $PHP_AUTOCONF
environment variable is set correctly and then rerun this script.“，需要安装autoconf：
yum install autoconf（RedHat或者CentOS）、apt-get install autoconf（Ubuntu Linux）

生成配置文件，并编译生成模块：
/usr/local/php5/bin/phpize
./configure --with-curl=/usr/local/curl --with-php-config=/usr/local/php5/bin/php-config
make
make install
这样，curl.so就被复制到PHP对应目录（如：/usr/local/php5/lib/php/extensions/no-debug-non-zts-20090626/）

## 3.修改配置
在php.ini里，设置扩展目录：
extension_dir = "/usr/local/php5/lib/php/extensions/no-debug-non-zts-20090626/"
并添加扩展模块引用：
extension = curl.so

## 4.检查并重启Apache
/usr/local/php/bin/php -v
执行这个命令时，php会去检查配置文件是否正确，如果有配置错误，这里会报错，可以根据错误信息去排查
 
同样的，安装tidy扩展也是按这样的步骤。
不过libtidy的安装包比较验证下载到，提供如下地址下载：http://anduin.linuxfromscratch.org/files/BLFS/sources/tidy-cvs_20070326.tar.bz2。
安装方式也一样：
```
#tar zxvf tidy-cvs_20070326.tar.bz2 
#cd tidy-cvs_20070326
#./configure --prefix=/usr/local/tidy
#make
#make install 
```

## 来源
https://my.oschina.net/u/853108/blog/118296