# HTTP状态码

## 定义

HTTP状态码（英语：HTTP Status Code）是用以表示网页服务器超文本传输协议响应状态的3位数字代码

## HTTP状态码分类

|分类|  分类描述|
|--|--|
|1**| 信息，服务器收到请求，需要请求者继续执行操作|
|2**| 成功，操作被成功接收并处理|
|3**| 重定向，需要进一步的操作以完成请求|
|4**| 客户端错误，请求包含语法错误或无法完成请求|
|5**| 服务器错误，服务器在处理请求的过程中发生了错误|

## 常见问题
1. HTTP返回码中301与302的区别
301 redirect: 301 代表永久性转移(Permanently Moved)。
302 redirect: 302 代表暂时性转移(Temporarily Moved )。

2. 304状态码是怎么样，怎么产生的？Etag值怎么产生的？

        1.客户端请求一个页面（A）。 
        2.服务器返回页面A，并在给A加上一个ETag。 
        3.客户端展现该页面，并将页面连同ETag一起缓存。 
        4.客户再次请求页面A，并将上次请求时服务器返回的ETag一起传递给服务器。 
        5.服务器检查该ETag，并判断出该页面自上次客户端请求之后还未被修改，直接返回响应304（未修改——Not Modified）和一个空的响应体。

ETag是一个不透明的标识符，由Web服务器根据URL上的资源的特定版本而指定。如果那个URL上的资源内容改变，一个新的不一样的ETag就会被分配。用这种方法使用ETag即类似于指纹，并且他们能够被快速地被比较，以确定两个版本的资源是否相同。ETag的比较只对同一个URL有意义——不同URL上的资源的ETag值可能相同也可能不同，从他们的ETag的比较中无从推断。

