## **定义**

**强一致**

当更新操作完成之后，任何多个后续进程或者线程的访问都会返回最新的更新过的值。这种是对用户最友好的，就是用户上一次写什么，下一次就保证能读到什么。根据 CAP 理论，这种实现需要牺牲可用性。

**弱一致性**

系统并不保证续进程或者线程的访问都会返回最新的更新过的值。系统在数据写入成功之后，不承诺立即可以读到最新写入的值，也不会具体的承诺多久之后可以读到。

**最终一致性**

弱一致性的特定形式。系统保证在没有后续更新的前提下，系统最终返回上一次更新操作的值。在没有故障发生的前提下，不一致窗口的时间主要受通信延迟，系统负载和复制副本的个数影响。DNS 是一个典型的最终一致性系统。 在工程实践上，为了保障系统的可用性，互联网系统大多将强一致性需求转换成最终一致性的需求，并通过系统执行幂等性的保证，保证数据的最终一致性。



最终一致：事务处理过程中，会有短暂不一致的情况，但通过恢复系统，可以让事务的数据达到最终一致的目标。



## **考虑**

**强一致性**

回滚的成本有点高，所以要看下是否有强一致性的要求？



**逻辑简单：异步处理**

保证服务接口的幂等性，消息日志可以存储到本地文本、数据库或消息队列，再通过业务规则自动或人工发起重试



**多个事务：分布式事务转换为多个本地事务，然后依靠重试等方式达到最终一致性**

业务逻辑无法保证幂等，则要增加一个去重表或者类似的实现：发消息的时候消息并不立即发出，而是向消息库插入一条消息记录，然后在事务提交的时候再异步将消息发出，发送消息如果成功则将消息库里的消息删除



## 方案

#### 两阶段

#### 补偿型：重试 或 回滚

WS-BusinessActivity提供了一种基于补偿的long-running的事务处理模型。还是上面的例子，服务器A的事务如果执行顺利，那么事务A就先行提交，如果事务B也执行顺利，则事务B也提交，整个事务就算完成。但是如果事务B执行失败，事务B本身回滚，这时事务A已经被提交，所以需要执行一个补偿操作，将已经提交的事务A执行的操作作反操作，恢复到未执行前事务A的状态。这样的SAGA事务模型，是牺牲了一定的隔离性和一致性的，但是提高了long-running事务的可用性。



#### 异步确保型

将一些同步阻塞的事务操作变为异步的操作，避免对数据库事务的争用，典型例子是热点账户异步记账、批量记账的处理。



## **流程**

一个完整的业务活动由一个主业务服务与若干从业务服务组成。

主业务服务负责发起并完成整个业务活动。

从业务服务提供 TCC（Try-Confirm-Cancel）型业务操作。

业务活动管理器控制业务活动的一致性，它登记业务活动中的操作，并在活动提交时确认所有的两阶段事务的 confirm 操作，在业务活动取消时调用所有两阶段事务的 cancel 操作。”

## **其他**

流程和事务别搞混，可以强一致，可以弱一致。