## 背景
Redis的管道机制，其实是为了批量读写而设计的，如果进行多次的读和写数据到redis，每次都建立一个链接，这样是比较消耗资源的，而且也比较忙，于是想到了管道机制（pipeline），只建立一个连接，然后批量执行读或写。 

## 优点
可以将多次IO往返的时间缩减为一次

## 测试结果
正常push，5w条数据，用时7.476s，
用MULTI，5w条数据，用时6.8639s。
用管道，5w条数据，用时0.0947s。

## 示例代码

```
$redis = new redis();
$redis->connect('127.0.0.1',6379);
$handle = $redis->multi();
$handle->incr('a');
$handle->incr('b');
$handle->exec();
```

## redis的MULTI与PIPELINE区别
1. Redis::MULTI方式会将命令逐条发给redis服务端。只有在需要使用事物时才选择Redis::MULTI方式，它可以保证发给redis的一系列命令以原子方式执行。但效率相应也是最低的。
2. Redis::PIPELINE方式，可以将一系列命令打包发给redis服务端。如果只是为了一下执行多条redis命令，无需事物和原子性，那么应该选用