## 优点
1. 松耦合
生产者和消费者无需知道彼此的实现细节
2. 易于扩展
消费者可以有多个，而且可以分布在不同服务器中

### 使用过Redis做异步队列么，你是怎么用的？

1. 一般使用list结构作为队列，rpush生产消息，lpop消费消息。当lpop没有消息的时候，要适当sleep一会再重试。
2. 可不可以不用sleep呢？list还有个指令叫blpop，在没有消息的时候，它会阻塞住直到消息到来。
3. 能不能生产一次消费多次呢？使用pub/sub主题订阅者模式，可以实现1:N的消息队列。
4. 如果对方追问pub/sub有什么缺点？在消费者下线的情况下，生产的消息会丢失，得使用专业的消息队列如rabbitmq等。
5. 如果对方追问redis如何实现延时队列？使用sorted set，拿时间戳作为score，消息内容作为key调用zadd来生产消息，消费者用zrangebyscore指令获取N秒之前的数据轮询进行处理。

## 遇到的问题
1. 在与每次订阅到内容后，都会把 Redis 对象进行释放，处理完订阅信息后再次去连接 Redis.
   redis连接是不可用的，需要重新连接，数据库连接还要及时释放掉。

2. 会丢数据

