```
# yes：后台运行；no：不是后台运行（老版本默认）
daemonize yes
# redis的进程文件pidfile /var/run/redis.pid# 端口
port 6379
# bind_address 绑定地址的设置，和MySQL的一样，一般设置为本地地址，这样就需要指定IP访问了。如：redis -h 192.168.200.202；默认所有地址都可以连接。
# bind 127.0.0.1# Redis 的 套接字 文件
# unixsocket /tmp/redis.sock
# unixsocketperm 755

# 该连接多少秒之内没有响应，则关闭，默认300s，0表示不关闭。
timeout 0
# 日志等级
loglevel notice

# log文件的目录，默认打印到终端（stdout）
logfile /var/log/redis/redis.log

# 数据库的个数，默认使用的是0数据库，用select <dbid> 切换
databases 16

################################ SNAPSHOTTING  #################################
#                                   快照配置
#  注释掉“save”这一行配置项就可以让保存数据库功能失效
#  设置sedis进行数据库镜像的频率。
#  900秒（15分钟）内至少1个key值改变（则进行数据库保存--持久化）  #  300秒（5分钟）内至少10个key值改变（则进行数据库保存--持久化）  #  60秒（1分钟）内至少10000个key值改变（则进行数据库保存--持久化）
save 900 1
save 300 10
save 60 10000
# 快照功能开启，后台持久化操作失败，Redis则会停止接受更新操作，否则没人注意到数据不会写磁盘持久化。# 如果后台持久化操作进程再次工作，Redis会自动允许更新操作（yes）；后台持久化操作出错,redis也仍然# 可以继续像平常一样工作（no）
stop-writes-on-bgsave-error yes
# 在进行镜像备份时,是否进行压缩。yes：压缩，但是需要一些cpu的消耗。no：不压缩，需要更多的磁盘空间
rdbcompression yes
#从版本RDB版本5开始，一个CRC64的校验就被放在了文件末尾。#这会让格式更加耐攻击，但是当存储或者加载rbd文件的时候会有一个10%左右的性能下降，  #所以，为了达到性能的最大化，你可以关掉这个配置项。  #没有校验的RDB文件会有一个0校验位，来告诉加载代码跳过校验检查。  
rdbchecksum yes

# 数据库文件的文件名
dbfilename dump.rdb
# 数据目录
dir /var/lib/redis

################################# REPLICATION #################################
#                                   复制
# 复制选项
# slaveof <masterip> <masterport>

# 指定与主数据库连接时需要的密码验证
# masterauth <master-password>
slave-serve-stale-data yes
# 作为从服务器，默认情况下是只读的（yes），可以修改成NO，用于写（不建议）。
slave-read-only yes
# slave根据指定的时间间隔向服务器发送ping请求。时间间隔可以通过 repl_ping_slave_period 来设置，默认10秒。
# repl-ping-slave-period 10
# 下面的选项设置了大块数据I/O、向master请求数据和ping响应的过期时间。默认值60秒。# 一个很重要的事情是：确保这个值比 repl-ping-slave-period 大，否则master和slave之间的传输过期时间比预想的要短。
# repl-timeout 60
# 优先级
slave-priority 100
################################## SECURITY ####################################                                     安全# requirepass foobared# rename-command CONFIG ""
################################### LIMITS ####################################
#                                     限制
# 设置最多同时连接客户端数量。默认没有限制，这个关系到Redis进程能够打开的文件描述符数量。特殊值"0"表示没有限制。# 一旦达到这个限制，Redis会关闭所有新连接并发送错误"达到最大用户数上限（max number of clients reached）"
# maxclients 10000
# 设置redis能够使用的最大内存。# 当内存满了的时候,如果还接收到set命令,redis将先尝试剔除设置过expire信息的key,而不管该key的过期时间还没有到达。# 在删除时,将按照过期时间进行删除,最早将要被过期的key将最先被删除。如果带有expire信息的key都删光了,那么将返回错误。# 这样,redis将不再接收写请求,只接收get请求。
# maxmemory <bytes>
# 内存策略：如果达到内存限制了，Redis如何删除key。你可以在下面五个策略里面选：
# volatile-lru -> 根据LRU算法生成的过期时间来删除。# allkeys-lru -> 根据LRU算法删除任何key。# volatile-random -> 根据过期设置来随机删除key。# allkeys->random -> 无差别随机删。# volatile-ttl -> 根据最近过期时间来删除（辅以TTL）# noeviction -> 谁也不删，直接在写操作时返回错误。# 注意：对所有策略来说，如果Redis找不到合适的可以删除的key都会在写操作时返回一个错误。# maxmemory-policy volatile-lru
# LRU和minimal TTL是近似算法（为了节省内存），它们会在一个有3个键值的样本中选择较没用的那个。
# maxmemory-samples 3

############################## APPEND ONLY MODE ###############################
#                                 追加模式
# 默认情况下，Redis是异步的把数据导出到磁盘上。这种情况下，当Redis挂掉的时候，最新的数据就丢了。# 如果不希望丢掉任何一条数据的话就该用追加模式：一旦开启这个模式，Redis会把每次写入的数据在接收后都写入 appendonly.aof 文件。# 每次启动时Redis都会把这个文件的数据读入内存里。# 注意，异步导出的数据库文件和纯累加文件可以并存（你得把上面所有"save"设置都注释掉，关掉导出机制）。# 如果纯累加模式开启了，那么Redis会在启动时载入日志文件而忽略导出的 dump.rdb 文件。# 重要：查看 BGREWRITEAOF 来了解当累加日志文件太大了之后，怎么在后台重新处理这个日志文件
appendonly no

# 定义AOF文件的名称
# appendfilename appendonly.aof
# Redis支持三种不同的刷写模式：# no：不要立刻刷，只有在操作系统需要刷的时候再刷。比较快。IO消耗最小，最不安全# always：每次写操作都立刻写入到aof文件。慢，但是最安全。# everysec：每秒写一次。折衷方案。# 默认的 "everysec" 通常来说能在速度和数据安全性之间取得比较好的平衡。

# appendfsync always
appendfsync everysec
# appendfsync no

# 如果你有延迟的问题那就把这个设为 "yes"，否则就保持 "no"，这是保存持久数据的最安全的方式。
no-appendfsync-on-rewrite no
# 自动重写AOF文件，指定百分比为0会禁用AOF自动重写特性。# 如果AOF日志文件大到指定百分比，Redis能够通过 BGREWRITEAOF 自动重写AOF日志文件。如果当前大小超过指定比例，就会触发重写操作。# 你还需要指定被重写日志的最小尺寸，这样避免了达到约定百分比但尺寸仍然很小的情况还要重写。
auto-aof-rewrite-percentage 100
auto-aof-rewrite-min-size 64mb

################################ LUA SCRIPTING  ###############################
lua-time-limit 5000
################################## SLOW LOG ###################################
#                                    慢查询
# 下面的时间单位是微秒，所以1000000就是1秒。注意，负数时间会禁用慢查询日志，而0则会强制记录所有命令。
slowlog-log-slower-than 10000
# 慢查询日志长度。当一个新的命令被写进日志的时候，最老的那个记录会被删掉。这个长度没有限制。只要有足够的内存就行。你可以通过 SLOWLOG RESET 来释放内存。
slowlog-max-len 128

############################### ADVANCED CONFIG ###############################
#                                   高级配置
# 当有大量数据时，适合用哈希编码（需要更多的内存），元素数量上限不能超过给定限制。你可以通过下面的选项来设定这些限制：
hash-max-ziplist-entries 512
hash-max-ziplist-value 64

# 与哈希相类似，数据元素较少的情况下，可以用另一种方式来编码从而节省大量空间。这种方式只有在符合下面限制的时候才可以用：list-max-ziplist-entries 512
list-max-ziplist-value 64

# 数据全是64位无符号整型数字构成的字符串。下面这个配置项就是用来限制这种情况下使用这种编码的最大上限的。
set-max-intset-entries 512

# 与第一、第二种情况相似，有序序列也可以用一种特别的编码方式来处理，可节省大量空间。这种编码只适合长度和元素都符合下面限制的有序序列：zset-max-ziplist-entries 128
zset-max-ziplist-value 64

# 默认是每秒钟进行10次哈希表刷新，用来刷新字典，然后尽快释放内存。# 建议：如果你对延迟比较在意的话就用 "activerehashing no";如果你不太在意延迟而希望尽快释放内存的话就设置 "activerehashing yes"。
activerehashing yes
# 对客户端输出缓冲进行限制可以强迫那些不从服务器读取数据的客户端断开连接。# 对于normal client，第一个0表示取消hard limit，第二个0和第三个0表示取消soft limit，normal client默认取消限制，因为如果没有寻问，他们是不会接收数据的。
client-output-buffer-limit normal 0 0 0# 对于slave client和MONITER client，如果client-output-buffer一旦超过256mb，又或者超过64mb持续60秒，那么服务器就会立即断开客户端连接。
client-output-buffer-limit slave 256mb 64mb 60# 对于pubsub client，如果client-output-buffer一旦超过32mb，又或者超过8mb持续60秒，那么服务器就会立即断开客户端连接。
client-output-buffer-limit pubsub 32mb 8mb 60

################################## INCLUDES ####################################                                    包含#这在你有标准配置模板但是每个redis服务器又需要个性设置的时候很有用。# include /path/to/local.conf
# include /path/to/other.conf
```