### 一、概念

MySQL提供了不同级别的设置，包括server级、database级、table级、column级，可以提供非常精准的设置。

什么是字符集、字符序？简单的来说：

1. 字符集（character set）：定义了字符以及字符的编码。
2. 字符序（collation）：定义了字符的比较规则。



### 二、server的字符集、字符序

1、查看server字符集、字符序

```
mysql> SHOW VARIABLES LIKE "character_set_server"; 
mysql> SHOW VARIABLES LIKE "collation_server";
```



2、database的字符集、字符序

- 创建数据库时，指定了`CHARACTER SET`或`COLLATE`，则以对应的字符集、排序规则为准。
- 创建数据库时，如果没有指定字符集、排序规则，则以`character_set_server`、`collation_server`为准。



### 三、客户端字符编码

默认驱动程序自动使用服务器指定的编码

要覆盖客户端自动检测到的编码，请使用`characterEncoding`服务器连接URL中的属性

characterEncoding 指定字符编码

characterSetResults 告诉服务器返回结果的字符集

1、当你配置了client的default_character_set之后，characterEncoding和characterSetResults这两个变量你设置与否都不重要了。

### 四、乱码问题

要统一字符集

SHOW VARIABLES LIKE 'collation_%';

a、要保证数据库中存的数据与数据库编码一致，即数据编码与character_set_database一致；
b、要保证通讯的字符集与数据库的字符集一致，即character_set_client, character_set_connection与character_set_database一致；
c、要保证SELECT的返回与程序的编码一致，即character_set_results与程序编码一致；



\- character_set_client：客户端请求数据的字符集

\- character_set_connection：从客户端接收到数据，然后传输的字符集

\- character_set_database：默认数据库的字符集；如果没有默认数据库，使用character_set_server字段

\- character_set_results：结果集的字符集

\- character_set_server：数据库服务器的默认字符集



### 五、参考链接

1. https://dev.mysql.com/doc/connector-j/8.0/en/connector-j-reference-charsets.html
2. https://www.cnblogs.com/chyingp/p/mysql-character-set-collation.html

### 六、附录

| MySQL字符集名称                                              | Java样式字符编码名称 |
| ------------------------------------------------------------ | -------------------- |
| `ascii`                                                      | `US-ASCII`           |
| `big5`                                                       | `Big5`               |
| `gbk`                                                        | `GBK`                |
| `sjis`                                                       | `SJIS or Cp932`      |
| `cp932`                                                      | `Cp932 or MS932`     |
| `gb2312`                                                     | `EUC_CN`             |
| `ujis`                                                       | `EUC_JP`             |
| `euckr`                                                      | `EUC_KR`             |
| `latin1`                                                     | `Cp1252`             |
| `latin2`                                                     | `ISO8859_2`          |
| `greek`                                                      | `ISO8859_7`          |
| `hebrew`                                                     | `ISO8859_8`          |
| `cp866`                                                      | `Cp866`              |
| `tis620`                                                     | `TIS620`             |
| `cp1250`                                                     | `Cp1250`             |
| `cp1251`                                                     | `Cp1251`             |
| `cp1257`                                                     | `Cp1257`             |
| `macroman`                                                   | `MacRoman`           |
| `macce`                                                      | `MacCentralEurope`   |
| *对于8.0.12及更早版本*： `utf8`*对于8.0.13及更高版本*： `utf8mb4` | `UTF-8`              |
| `ucs2`                                                       | `UnicodeBig`         |





