## 行锁

InnoDB 实现了以下两种类型的**行锁**：

- 共享锁（S）：允许一个事务去读一行，阻止其他事务获得相同数据集的排他锁。
- 排他锁（X）：允许获得排他锁的事务更新数据，阻止其他事务取得相同数据集的共享读锁和排他写锁。

## 锁的分类

## 全局锁

备份

### 行锁

锁定一行数据，即上面所说的共享锁和排他锁

InnoDB是基于索引来完成行锁



## 行锁的模式

锁的模式有：共享锁，排他锁，意向共享锁，意向排他锁

#### 共享锁

共享锁又称读锁 (read lock)，是读取操作创建的锁。其他用户可以并发读取数据，但任何事务都不能对数据进行修改（获取数据上的排他锁），直到已释放所有共享锁。当如果事务对读锁进行修改操作，很可能会造成死锁。如下图所示。

#### 排它锁

排他锁 exclusive lock（也叫writer lock）又称写锁。
 名词解释：若某个事物对某一行加上了排他锁，只能这个事务对其进行读写，在此事务结束之前，其他事务不能对其进行加任何锁，其他进程可以读取,不能进行写操作，需等待其释放。 **排它锁是悲观锁的一种实现**，在上面悲观锁也介绍过。



#### **意向共享锁（IS）：**

事务打算给数据行加行共享锁，事务在给一个数据行加共享锁前必须先取得该表的IS锁。

#### **意向排他锁（IX）：**

事务打算给数据行加行排他锁，事务在给一个数据行加排他锁前必须先取得该表的IX锁。



## 锁的应用

insert 插入记录时，需要获取行锁

update 更新一条记录时，如果记录存在，需要行锁；如果记录不存在，行锁 + 间隙锁

delete 删除一条记录时，如果记录存在，需要行锁；如果记录不存在，行锁 + 间隙锁

select 查询记录时，不会存在锁，除非显示的调用lock in share mode或者for update，如下所示。为什么查询不存在锁呢？因为InnoDB引擎select查询返回的是数据的快照版本，这也是为什么在许多mysql书中，事务的select查询需要锁时，要显示的使用加锁语法。参见MySQL查询不需要锁，了解更多有关InnoDB查询的机制。
