## 事务

事务是一组连续的操作集合,它需要`SET AUTOCOMMIT = 0;(默认为1)`,以`START TRANSACTION;`或`BEGIN;`开始,以`COMMIT;`结束一次事务,或者以`ROLLBACK;`回滚事务操作并结束事务.

## 事务隔离级别

#### 读未提交

事务最低隔离级别，事务对数据只是修改了还没提交，其他事务就可以读出来。

脏读、不可重复读、幻读都可能发生

#### 读已提交

事务对数据的修改提交了，其他事务就可以看到。

解决了脏读问题，但是会产生不可重复读、幻读的问题

#### 可重复读

事务开始的时候，会创建一个对数据库对应记录的视图，保存了开始时数据库中数据的状态，这样即使其他事务修改了数据，本事务也读取不到改变。

解决了脏读、不可重复读问题，但是仍然会产生幻读（因为视图只是对应行的）

#### 串行化

事务只能一个个来，不能并行执行