## 分库分表的方式方法

### 垂直拆分

#### 垂直拆分后特点

​    1）每个库（表）的结构都不一样

​    2）一般来说，每个库（表）的属性至少有一列交集，一般是主键

​    3）所有库（表）的并集是全量数据

### 水平拆分

1. #### 范围法

   从0到10000一个表，10001到20000一个表；

2. #### HASH取模

   一个商场系统，一般都是将用户，订单作为主表，然后将和它们相关的作为附表，这样不会造成跨库事务之类的问题。 取用户id，然后hash取模，分配到不同的数据库上。

   哈希法的优点是：

   - 切分策略简单，根据uid，按照hash，user-center很快能够定位到数据在哪个库上
   - 数据量均衡，只要uid是均匀的，数据在各个库上的分布一定是均衡的
   - 请求量均衡，只要uid是均匀的，负载在各个库上的分布一定是均衡的

   哈希法的不足是：

   - 扩容麻烦，如果容量不够，要增加一个库，重新hash可能会导致数据迁移，如何平滑的进行数据迁移，是一个需要解决的问题

3. #### 地理区域

   比如按照华东，华南，华北这样来区分业务。

4. #### 时间

   按照时间切分，就是将6个月前，甚至一年前的数据切出去放到另外的一张表，因为随着时间流逝，这些表的数据 被查询的概率变小，所以没必要和“热数据”放在一起，这个也是“冷热数据分离”。

#### 水平拆分后特点

​    1）每个库（表）的结构都一样

​    2）每个库（表）的数据都不一样，没有交集

​    3）所有库（表）的并集是全量数据

## 分库分表后面临的问题

### 事务支持

分库分表后，就成了分布式事务了。如果依赖数据库本身的分布式事务管理功能去执行事务，将付出高昂的性能代价； 如果由应用程序去协助控制，形成程序逻辑上的事务，又会造成编程方面的负担。



## 参考资料

[单KEY业务，数据库水平切分架构实践](https://mp.weixin.qq.com/s?__biz=MjM5ODYxMDA5OQ==&mid=2651960212&idx=1&sn=ab4c52ab0309f7380f7e0207fa357128&chksm=bd2d06488a5a8f5e3b7c9de0cc5936818bd9a6ed4058679ae8d819175e0693c6fbd9cdea0c87&scene=21#wechat_redirect)