# **一、基础规范**
1. 没有特殊要求，必须使用InnoDB存储引擎
2. 手机/积分项目使用gbk字符集
3. 数据表、数据字段必须加入中文注释
4. 禁止使用存储过程、视图、触发器、Event
5. 禁止存储大文件或者大照片
# 二、**命名规范**
1. 库名，表名，列名必须用**小写**，采用下划线分隔
2. 库名，表名，列名必须见名知义，长度不要超过32字符
3. 库名、表名、字段名、索引名禁止使用MySQL保留字段
# 三、库**表设计规范**
1. 表必须有主键
2. 禁止使用外键
3. 禁止在表中建立预留字段
4. 禁止在数据库中存储明文密码
5. 必须把字段定义为NOT NULL
6. 使用TINYINT来代替ENUM
7. 用DECIMAL代替FLOAT和DOUBLE存储精确浮点数
# 四、**索引规范**
1. 唯一索引使用uniq_[字段名]来命名
2. 非唯一索引使用idx_[字段名]来命名
1. 不使用UUID，MD5，HASH，字符串列作为主键，建议选择使用自增ID
2. 避免建立冗余索引和重复索引
# **五、SQL规范**
1. insert必须指定字段，禁止使用insert into Table values()
2. 同一个字段上的OR必须改用IN
3. 禁止使用order by rand()
4. 禁止单条sql语句同时更新多个表  
# 六、建议
1. 创建时间：create_time 格式为 datetime
2. 更新时间：update_time 格式为 timestamp 并设置默认值为 CURRENT_TIMESTAMP


