# Memcached和Redis对比

### 数据结构：
- Memcached仅限于字符串，但Redis是可以提供多种不同数据类型的数据结构服务器。

### 内存效率
- 内存使用效率对比：使用简单的key-value存储的话，Memcached的内存利用率更高，而如果Redis采用hash结构来做key-value存储，由于其组合式的压缩，其内存利用率会高于Memcached。

### 持久性
- 如果您使用的是Memcached，那么数据会随着重新启动而丢失，重建缓存是一个代价高昂的过程。另一方面，Redis可以处理持久数据。默认情况下，Redis至少每2秒钟将数据同步到磁盘。

### 复制：
- Memcached不支持复制。而Redis支持主从复制。

### 密钥长度：
- Memcached密钥长度最多为250个字节，而Redis密钥长度最多为2GB。

### 性能对比
- Memcached是多线程的
- Redis是典型的单线程架构，所有的读写操作都是在一条主线程中完成的。
- Redis只使用单核，而Memcached可以使用多核，所以平均每一个核上Redis在存储小数据时比Memcached性能更高。而在100k以上的数据中，Memcached性能要高于Redis，虽然Redis最近也在存储大数据的性能上进行优化，但是比起Memcached，还是稍有逊色。

### 安全性
- Memcached以root权限运行，而且Memcached本身没有任何权限管理和认证功能，安 全性不足

### 参考资料
* [Redis 和 Memcached 各有什么优缺点，主要的应用场景是什么样的？](https://www.zhihu.com/question/19829601)