## 快速排序（Quick Sort）

快速排序（Quicksort）是对冒泡排序的一种改进，借用了分治的思想，由C. A. R. Hoare在1962年提出。

- 基本思想

  快速排序的基本思想：挖坑填数+分治法。

  首先选一个轴值(pivot，也有叫基准的)，通过一趟排序将待排记录分隔成独立的两部分，其中一部分记录的关键字均比另一部分的关键字小，则可分别对这两部分记录继续进行排序，以达到整个序列有序。

  ![quick.gif](https://i.loli.net/2017/10/20/59e9f54756f84.gif)

- 算法描述

  快速排序使用分治策略来把一个序列（list）分为两个子序列（sub-lists）。步骤为：

  1. 从数列中挑出一个元素，称为"基准"（pivot）。
  2. 重新排序数列，所有比基准值小的元素摆放在基准前面，所有比基准值大的元素摆在基准后面（相同的数可以到任一边）。在这个分区结束之后，该基准就处于数列的中间位置。这个称为分区（partition）操作。
  3. 递归地（recursively）把小于基准值元素的子数列和大于基准值元素的子数列排序。

  递归到最底部时，数列的大小是零或一，也就是已经排序好了。这个算法一定会结束，因为在每次的迭代（iteration）中，它至少会把一个元素摆到它最后的位置去。

  ![](https://camo.githubusercontent.com/9cb8c34e660405d200c427ad58643e8bb2ff8e5e/68747470733a2f2f692e696d6775722e636f6d2f575476517549412e706e67)

- 代码实现

  ```java
  /**
   * 快速排序（递归）
   *
   * 1. 从数列中挑出一个元素，称为"基准"（pivot）。
   * 2. 重新排序数列，所有比基准值小的元素摆放在基准前面，所有比基准值大的元素摆在基准后面（相同的数可以到任一边）。在这个分区结束之后，该基准就处于数列的中间位置。这个称为分区（partition）操作。
   * 3. 递归地（recursively）把小于基准值元素的子数列和大于基准值元素的子数列排序。
   * @param arr   待排序数组
   * @param low   左边界
   * @param high  右边界
   */
  public static void quickSort(int[] arr, int low, int high){
      if(arr.length <= 0) return;
      if(low >= high) return;
      int left = low;
      int right = high;

      int temp = arr[left];   //挖坑1：保存基准的值
      while (left < right){
          while(left < right && arr[right] >= temp){  //坑2：从后向前找到比基准小的元素，插入到基准位置坑1中
              right--;
          }
          arr[left] = arr[right];
          while(left < right && arr[left] <= temp){   //坑3：从前往后找到比基准大的元素，放到刚才挖的坑2中
              left++;
          }
          arr[right] = arr[left];
      }
      arr[left] = temp;   //基准值填补到坑3中，准备分治递归快排
      System.out.println("Sorting: " + Arrays.toString(arr));
      quickSort(arr, low, left-1);
      quickSort(arr, left+1, high);
  }
  ```

- 小结

  快速排序是通常被认为在同数量级（O(nlog₂n)）的排序方法中平均性能最好的。但若初始序列按关键码有序或基本有序时，快排序反而蜕化为冒泡排序。为改进之，通常以“三者取中法”来选取基准记录，即将排序区间的两个端点与中点三个记录关键码居中的调整为支点记录。快速排序是一个不稳定的排序方法。

  以下是快速排序算法复杂度:

  | 平均时间复杂度   | 最好情况      | 最坏情况  | 空间复杂度         |
  | --------- | --------- | ----- | ------------- |
  | O(nlog₂n) | O(nlog₂n) | O(n²) | O(1)（原地分区递归版） |

  快速排序排序效率非常高。 虽然它运行最糟糕时将达到 `O(n²)` 的时间复杂度, 但通常平均来看, 它的时间复杂为 `O(nlog₂n)` ，比同样为 `O(nlog₂n)` 时间复杂度的归并排序还要快。快速排序似乎更偏爱乱序的数列， 越是乱序的数列， 它相比其他排序而言，相对效率更高。

  > 注意：同选择排序相似, 快速排序每次交换的元素都有可能不是相邻的, 因此它有可能打破原来值为相同的元素之间的顺序. 因此, 快速排序并不稳定.