# 常见问题

### 如何实时调试开发？
1. 代码不放入镜像，使用volume挂载放入容器。
2. docker环境代码挂载到本地

### windows下docker挂载有问题
命令：
winpty docker run -it  -p 80:80 -v //d/xampp/htdocs/swoft:/var/www/swoft2 zhubing/swoft  bash
其中 /var/www/swoft2为文件目录

1. 权限问题：Setting => Shared Drives
2. windows下路径，要使用双斜杠开头

### Docker端口映射实现网络访问
ip:hostport:containerport   #指定ip、指定主机port、指定容器port
ip::containerport           #指定ip、未指定主机port、指定容器port
hostport:container          #未指定ip port、指定主机port、指定容器port 

### Docker安装mysql
http://www.andrewchen.tw/2017/05/05/20170505_NOTE_DOCKER_MYSQL/
    
1. docker run --name mysql -e MYSQL_ROOT_PASSWORD=MY_PASSWORD -p 127.0.0.1:3306:3306 -d mysql/mysql-server:5.7

2. docker exec -it mysql mysql -u root -p  
USE mysql;  
UPDATE user SET host = '%' WHERE user = 'root';  
FLUSH PRIVILEGES;  
   
3. docker run --name phpadmin --link mysql:db -p 9998:80 -d phpmyadmin/phpmyadmin

### 报错：lient.Timeout exceeded while awaiting headers

Get https://registry-1.docker.io/v2/: net/http: request canceled while waiting for connection (Client.Timeout exceeded while awaiting headers)

阿里云加速器有问题，更换加速器DaoCloud

### docker-compose vs docker run
1. https://beginor.github.io/2017/06/08/use-compose-instead-of-run.html

### Docker参数问题 以及 环境变量设置
1. docker build --build-arg
2. docker run
3. env_file

###　pcel安装redis失败
采取下载包安装解压的方式

### How to prevent Dockerfile caching git clone
ARG CACHE_DATE=2016-01-01
RUN git clone ...

docker build --build-arg CACHE_DATE=$(date) ....
问题链接：https://stackoverflow.com/questions/36996046/

### core-dump磁盘报警
RUN echo 'ulimit -S -c 0 > /dev/null 2>&1' >> /root/.bashrc
RUN /bin/bash -c "source /root/.bashrc"
参考资料：http://blog.51cto.com/buranle/1677642

### 在分配的测试机（Docker容器）上启了Docker服务，测试机挂掉。
原因：在Docker容器上不能直接启用Docker服务
解决方案是：Docker in Docker，实现在Docker容器中启动一个子容器。



## 参考资料
* [docker错误一览](https://www.jianshu.com/p/605a7c0e1d0f)