## 理解

**抽象用于**`不同的事物`，而**接口用于**`事物的行为。`

**接口是对动作的抽象，而抽象类是对根源的抽象**。

对于抽象类，比如男人，女人这两个类，那我们可以为这两个类设计一个更高级别的抽象类--人。

对于接口，我们可以坐着吃饭，可以站着吃饭，可以用筷子吃饭，可以用叉子吃饭。

## 例子

```
abstract class Bird {
  // ...
  abstract function getSpeed();
  // ...
}

class European extends Bird {
  public function getSpeed() {
    return $this->getBaseSpeed();
  }
}
class African extends Bird {
  public function getSpeed() {
    return $this->getBaseSpeed() - $this->getLoadFactor() * $this->numberOfCoconuts;
  }
}
class NorwegianBlue extends Bird {
  public function getSpeed() {
    return ($this->isNailed) ? 0 : $this->getBaseSpeed($this->voltage);
  }
}

// Somewhere in Client code.
$speed = $bird->getSpeed();
```



## 总结

- 抽象类和接口都不能被**直接**实例化。如果抽象类要实例化，那么抽象类定义的变量必须指向一个子类对象，这个子类继承了这个抽象类并实现了这个抽象类的所有抽象方法。如果接口要实例化，那么这个接口定义的变量要指向一个子类对象，这个子类必须实现了这个接口所有的方法。
- 抽象类要被子类继承，接口要被子类实现。
- 接口里面只能对方法进行声明，抽象类既可以对方法进行声明也可以对方法进行实现。
- 接口（类）可以继承接口，甚至可以继承多个接口。但是类只能继承一个类。