# 定义

多态是指在面向对象中能够根据使用类的上下文来重新定义或改变类的性质和行为。

## 例子

```
 <?php
interface IEat {
  function eatFish();
  function eatMoss();
}

class Whale implements IEat {
  public function eatFish() {
    echo "Whale eats fish.\n";
  }
  public function eatMoss() {
    echo "Whale doesn't eat fish\n";
  }
}

class Carp implements IEat {
  public function eatFish() {
    echo "Carp doesn't eat moss.\n";
  }
  public function eatMoss() {
    echo "Carp eats moss.\n";
  }
}
```

# 参考资料

https://sourcemaking.com/refactoring/replace-conditional-with-polymorphism