## 什么是线程
线程是操作系统能够进行运算调度的最小单位，它被包含在进程之中，是进程中的实际运作单位。

进程（process）和线程（thread）是操作系统的基本概念，主要出现在CPU中

## 理解

有些进程还不止同时干一件事，比如Word，它可以同时进行打字、拼写检查、打印等事情。在一个进程内部，要同时干多件事，就需要同时运行多个“子任务”，我们把进程内的这些“子任务”称为线程（Thread）

## 线程和进程有什么区别？
线程是进程的子集，一个进程可以有很多线程，每条线程并行执行不同的任务。不同的进程使用不同的内存空间，而所有的线程共享一片相同的内存空间。

## PHP如何实现多线程？
1. pcntl_fork
2. stream_socket_client
3. 扩展：pthreads
## 对比
|    | 多进程   | 多线程   | 协程   |
|:----|:----|:----|:----|
| 创建   | fork   | pthread_create   | go   |
| 回收   | wait   | pthread_join   | -   |
| 通信方式   | IPC进程间通信   | 数据同步/锁   | array/channel   |
| 资源消耗   | 进程切换开销   | 进程切换开销   | 非常低   |
| 并发能力   | 数百   | 数千   | 50万   |
| 编程难度   | 困难   | 非常困难   | 容易   |

## 注意事项

1. 多线程模式致命的缺点就是任何一个线程挂掉都可能直接造成整个进程崩溃，因为所有线程共享进程的内存。

- [进程与线程的一个简单解释](

