## 什么是rpc框架

先回答第一个问题：`什么是RPC框架`？ 如果用一句话概括RPC就是：远程调用框架（Remote Procedure Call）

那什么是`远程调用`？

通常我们调用一个php中的方法，比如这样一个函数方法: localAdd(10, 20)，localAdd方法的具体实现要么是用户自己定义的，要么是php库函数中自带的，也就说在localAdd方法的代码实现在本地，它是一个本地调用！

`远程调用`意思就是：被调用方法的具体实现`不在`程序运行本地，而是在别的某个远程地方。

## 远程调用原理

比如 A (client) 调用 B (server) 提供的`remoteAdd`方法：

1. 首先A与B之间建立一个TCP连接；
2. 然后A把需要调用的方法名（这里是remoteAdd）以及方法参数（10， 20）序列化成字节流发送出去；
3. B接受A发送过来的字节流，然后反序列化得到目标方法名，方法参数，接着执行相应的方法调用（可能是localAdd）并把结果30返回；
4. A接受远程调用结果,输出30。

**RPC框架就是把我刚才说的这几点些细节给封装起来，给用户暴露简单友好的API使用**。

## 远程调用的好处

**解耦**：当server需要对方法内实现修改时，client完全感知不到，不用做任何变更；这种方式在跨部门，跨公司合作的时候经常用到，并且方法的提供者我们通常称为：**服务的暴露**。



## RPC与REST有什么区别？

通过了解RPC后，我们知道是RPC是client/server模式的，调用远程的方法，REST也是我们熟悉的一套API调用协议方法，它也是基于client/server模式的，调用远程的方法的，那他俩又有啥区别呢？

REST API 和 RPC 都是在 `Server端` 把一个个函数封装成接口暴露出去，以供 `Client端` 调用，不过 REST API 是基于 `HTTP协议`的，REST致力于通过http协议中的POST/GET/PUT/DELETE等方法和一个可读性强的URL来提供一个http请求。而 RPC 则可以不基于 HTTP协议
因此，如果是后端两种语言互相调用，用 RPC 可以获得更好的性能（省去了 HTTP 报头等一系列东西），应该也更容易配置。如果是前端通过 AJAX 调用后端，那么用 REST API 的形式比较好（因为无论如何也避不开 HTTP 这道坎）。

