# Blazor Server samples for Stimulsoft Reports.BLAZOR

#### This repository contains the source code of the examples of usage Stimulsoft Reports.BLAZOR reporting tool in the Blazor Server applications, using C# code and Razor Pages components. Stimulsoft Reports.BLAZOR report generator and examples are compatible with .NET 6.0, .NET 7.0, and .NET 8.0 frameworks.

## Overview
This repository has a set of examples (Visual Studio projects), each in different folders:
* [Adding Custom Function from Referenced Assembly](https://github.com/stimulsoft/Samples-Reports.WEB-for-Blazor-Server/tree/main/NET%208.0/Adding%20a%20Custom%20Function%20to%20the%20Designer)
* [Creating a Custom Button on the Viewer Toolbar](https://github.com/stimulsoft/Samples-Reports.WEB-for-Blazor-Server/tree/main/NET%208.0/Creating%20a%20Custom%20Button%20on%20the%20Viewer%20Toolbar)
* [Changing the Designer Options](https://github.com/stimulsoft/Samples-Reports.WEB-for-Blazor-Server/tree/main/NET%208.0/Changing%20the%20Designer%20Options)
* [Changing the Viewer Options](https://github.com/stimulsoft/Samples-Reports.WEB-for-Blazor-Server/tree/main/NET%208.0/Changing%20the%20Viewer%20Options)
* [Connecting to Data from Code](https://github.com/stimulsoft/Samples-Reports.WEB-for-Blazor-Server/tree/main/NET%208.0/Connecting%20to%20Data%20from%20Code)
* [Editing a Report Template in the Designer](https://github.com/stimulsoft/Samples-Reports.WEB-for-Blazor-Server/tree/main/NET%208.0/Editing%20a%20Report%20Template%20in%20the%20Designer)
* [Exporting a Report from Code](https://github.com/stimulsoft/Samples-Reports.WEB-for-Blazor-Server/tree/main/NET%208.0/Exporting%20a%20Report%20from%20Code)
* [Loading and Saving a Report Template](https://github.com/stimulsoft/Samples-Reports.WEB-for-Blazor-Server/tree/main/NET%208.0/Loading%20and%20Saving%20a%20Report%20Template)
* [Localizing the Viewer](https://github.com/stimulsoft/Samples-Reports.WEB-for-Blazor-Server/tree/main/NET%208.0/Localizing%20the%20Viewer)
* [Showing a Report in the Viewer](https://github.com/stimulsoft/Samples-Reports.WEB-for-Blazor-Server/tree/main/NET%208.0/Showing%20a%20Report%20in%20the%20Viewer)
* [Showing a Viewer without Toolbar](https://github.com/stimulsoft/Samples-Reports.WEB-for-Blazor-Server/tree/main/NET%208.0/Showing%20a%20Viewer%20without%20Toolbar)
* [Using Business Objects in the Report](https://github.com/stimulsoft/Samples-Reports.WEB-for-Blazor-Server/tree/main/NET%208.0/Using%20business%20objects%20in%20the%20report)
* [Using Report Variables in Code](https://github.com/stimulsoft/Samples-Reports.WEB-for-Blazor-Server/tree/main/NET%208.0/Using%20Report%20Variables%20in%20Code)
* [Using User Data in Reports](https://github.com/stimulsoft/Samples-Reports.WEB-for-Blazor-Server/tree/main/NET%208.0/Using%20User%20Data%20in%20Reports)

All examples are combined into Visual Studio solutions (.sln files). They are prepared only for LTS frameworks, any compatible ones can be selected in the project settings. Currently, projects are prepared for these frameworks:

* [.NET 6.0](https://github.com/stimulsoft/Samples-Reports.WEB-for-Blazor-Server/tree/main/NET%206.0)
* [.NET 8.0](https://github.com/stimulsoft/Samples-Reports.WEB-for-Blazor-Server/tree/main/NET%208.0)

## Running samples
In order to start simply open the Visual Studio solution file in the IDE and run the required project as Startup Project. The required libraries will be automatically downloaded from the NuGet repository.

## Other Web reporting components
* [ASP.NET](https://github.com/stimulsoft/Samples-Reports.WEB-for-ASP.NET)
* [ASP.NET MVC](https://github.com/stimulsoft/Samples-Reports.WEB-for-ASP.NET-MVC)
* [ASP.NET Core](https://github.com/stimulsoft/Samples-Reports.WEB-for-ASP.NET-Core)
* [ASP.NET Razor](https://github.com/stimulsoft/Samples-Reports.WEB-for-ASP.NET-Razor)
* [ASP.NET Angular](https://github.com/stimulsoft/Samples-Reports.WEB-for-ASP.NET-Angular)
* [Blazor WebAssembly](https://github.com/stimulsoft/Samples-Reports.WEB-for-Blazor-WebAssembly)

## About Stimulsoft Reports.BLAZOR
Stimulsoft Reports.BLAZOR is a cross-platform reporting tool created for integration in applications, which works using the Blazor framework. Our components support all the main capabilities of Blazor. They can work both on the .NET server-side and the client-side with the use of WebAssembly technology. All you need to work with the product is a modern Web browser!

## Useful links
* [Live Demo](http://demo.stimulsoft.com/#Net)
* [Product Page](https://www.stimulsoft.com/en/products/reports-blazor)
* [Free Download](https://www.stimulsoft.com/en/downloads)
* [NuGet](https://www.nuget.org/packages/Stimulsoft.Reports.Blazor)
* [Documentation](https://www.stimulsoft.com/en/documentation/online/programming-manual/reports_web_blazor.htm)
* [License](LICENSE.md)
