# Microns

![npm](https://img.shields.io/npm/v/microns)
![GitHub Repo stars](https://img.shields.io/github/stars/stephenhutchings/microns)
![NPM](https://img.shields.io/npm/l/microns)

The universal icon set for user interfaces. [Read more](https://www.s-ings.com/projects/microns-icon-font/).

Have suggestions for new icons? [Add them here](https://github.com/stephenhutchings/microns/issues/21).

```
npm install microns
```

Microns are a no-nonsense set of icons designed specifically for user
interfaces. Rather than provide a large library of unnecessary glyphs,
microns provide a sensible baseline of well-drawn icons that will cover
99% of your use cases for less than 10kb.

![Microns icon set](https://stephenhutchings.github.io/microns/fonts/preview.svg)

## Using Microns

Microns can be consumed as icon fonts or SVG files. Import the fonts with the provided CSS or Sass files.

A JSON dictionary provides a list of icon classes and corresponding unicode points.

```
icons.json

fonts/
  microns.css
  microns.scss
  microns.woff2
  microns.woff
  microns.ttf
  microns.otf
  microns.svg

svg/
  align-center.svg
  align-left.svg
  align-right.svg
  arrow-down.svg
  arrow-left.svg
  arrow-right.svg
  ...
```

## License

### Icons/Artwork

Distributed under
[CC BY-SA](http://creativecommons.org/licenses/by-sa/3.0/) licence.

### Font

Distributed under
[SIL Open Font Licence](http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web) licence.
