import type { SVGProps } from 'react'

const SvgTopbarIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={20}
    height={20}
    fill="none"
    viewBox="0 0 20 20"
    aria-hidden={true}
    focusable={false}
    {...props}
  >
    <path
      fill="currentColor"
      fillRule="evenodd"
      d="M17.313 6.5c-.506-3.387-2.223-4-7.313-4s-6.807.613-7.313 4h14.626Z"
      clipRule="evenodd"
      opacity={0.12}
    />
    <path
      fill="currentColor"
      fillRule="evenodd"
      d="m3.266 6.066.015-.101c.148-.978.4-1.548.768-1.916.368-.368.938-.62 1.916-.768.98-.149 2.28-.181 4.035-.181 1.755 0 3.055.032 4.035.18.978.149 1.547.4 1.916.77.368.368.62.937.768 1.915l.015.1c-.176-.049-.376-.1-.604-.15C14.952 5.652 13.032 5.4 10 5.4c-3.031 0-4.952.253-6.13.514-.228.051-.428.102-.604.152ZM3.15 7.363C3.11 8.105 3.1 8.975 3.1 10c0 1.755.032 3.055.18 4.035.149.978.4 1.547.77 1.916.367.368.937.62 1.915.768.98.149 2.28.18 4.035.18 1.755 0 3.055-.031 4.035-.18.978-.148 1.547-.4 1.916-.768.368-.369.62-.939.768-1.916.149-.98.18-2.28.18-4.035 0-1.025-.01-1.895-.049-2.637a7.64 7.64 0 0 0-.98-.277C14.798 6.848 12.969 6.6 10 6.6c-2.968 0-4.798.248-5.87.486-.456.101-.773.2-.98.277ZM10 1.9c-1.745 0-3.133.03-4.215.194C4.7 2.26 3.832 2.57 3.2 3.201c-.632.631-.942 1.499-1.107 2.584C1.93 6.867 1.9 8.255 1.9 10c0 1.745.03 3.133.194 4.215.165 1.085.475 1.953 1.107 2.584.631.632 1.499.942 2.584 1.107 1.082.164 2.47.194 4.215.194 1.745 0 3.133-.03 4.215-.194 1.085-.165 1.953-.475 2.584-1.107.632-.632.942-1.5 1.107-2.584.164-1.083.194-2.47.194-4.215 0-1.745-.03-3.132-.194-4.215-.165-1.085-.475-1.953-1.107-2.584-.631-.632-1.5-.942-2.584-1.107C13.133 1.93 11.745 1.9 10 1.9Z"
      clipRule="evenodd"
    />
  </svg>
)
export default SvgTopbarIcon
