import type { SVGProps } from 'react'

const SvgToggleIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={20}
    height={20}
    fill="none"
    viewBox="0 0 20 20"
    aria-hidden={true}
    focusable={false}
    {...props}
  >
    <path
      fill="currentColor"
      fillRule="evenodd"
      d="M4.1 5.5c0-.625.035-1.032.138-1.324.087-.248.229-.426.53-.577.337-.168.873-.3 1.743-.385C7.37 3.131 8.504 3.1 10 3.1c1.496 0 2.629.031 3.49.114.87.084 1.405.217 1.742.385.301.151.443.329.53.577.103.292.138.7.138 1.324 0 .625-.035 1.032-.138 1.324-.087.248-.229.426-.53.577-.337.168-.873.3-1.743.385-.86.083-1.993.114-3.49.114-1.495 0-2.628-.031-3.488-.114-.87-.084-1.406-.217-1.743-.385-.301-.151-.443-.329-.53-.577-.103-.292-.138-.7-.138-1.324ZM10 1.9c-1.504 0-2.684.031-3.605.12-.911.088-1.625.237-2.163.506-.574.287-.932.702-1.126 1.25C2.928 4.283 2.9 4.876 2.9 5.5s.028 1.218.206 1.723c.194.549.552.965 1.126 1.251.538.27 1.252.418 2.163.506.921.089 2.101.12 3.605.12s2.684-.031 3.604-.12c.912-.088 1.626-.237 2.164-.506.574-.286.932-.702 1.126-1.25.178-.506.206-1.099.206-1.724s-.028-1.218-.206-1.723c-.194-.549-.552-.964-1.126-1.251-.538-.27-1.252-.418-2.164-.506-.92-.089-2.1-.12-3.604-.12ZM6.5 4c-.255 0-.483.013-.677.058-.2.045-.395.13-.545.298a1.05 1.05 0 0 0-.243.544c-.03.18-.035.385-.035.6 0 .215.005.42.035.6.031.184.095.38.243.544.15.167.345.253.545.298.194.045.422.058.677.058.255 0 .483-.013.677-.058.2-.045.395-.13.545-.298a1.05 1.05 0 0 0 .243-.544c.03-.18.035-.385.035-.6 0-.215-.005-.42-.035-.6a1.05 1.05 0 0 0-.243-.544 1.014 1.014 0 0 0-.545-.298A3.116 3.116 0 0 0 6.5 4Zm6.323 9.058c.194-.045.422-.058.677-.058.255 0 .483.013.677.058.2.045.395.13.545.298.148.164.212.36.243.544.03.18.035.385.035.6 0 .215-.005.42-.035.6a1.05 1.05 0 0 1-.243.544c-.15.167-.345.253-.545.298A3.116 3.116 0 0 1 13.5 16c-.255 0-.483-.013-.677-.058a1.014 1.014 0 0 1-.545-.298 1.05 1.05 0 0 1-.243-.544 3.729 3.729 0 0 1-.035-.6c0-.215.005-.42.035-.6.031-.184.095-.38.243-.544.15-.167.345-.253.545-.298ZM4.1 14.5c0-.625.035-1.032.138-1.324.087-.248.229-.426.53-.577.337-.168.873-.3 1.743-.385.86-.083 1.993-.114 3.489-.114 1.496 0 2.629.031 3.49.114.87.084 1.405.217 1.742.385.301.151.443.329.53.577.103.292.138.7.138 1.324 0 .625-.035 1.032-.138 1.324-.087.248-.229.426-.53.577-.337.168-.873.3-1.743.385-.86.083-1.993.114-3.49.114-1.495 0-2.628-.031-3.488-.114-.87-.084-1.406-.217-1.743-.385-.301-.151-.443-.329-.53-.577-.103-.292-.138-.7-.138-1.324Zm5.9-3.6c-1.504 0-2.684.031-3.605.12-.911.088-1.625.237-2.163.506-.574.287-.932.702-1.126 1.25-.178.506-.206 1.099-.206 1.724s.028 1.218.206 1.723c.194.549.552.965 1.126 1.251.538.27 1.252.418 2.163.506.921.089 2.101.12 3.605.12s2.684-.031 3.604-.12c.912-.088 1.626-.237 2.164-.506.573-.287.932-.702 1.126-1.25.178-.506.206-1.099.206-1.724s-.028-1.218-.206-1.723c-.194-.549-.552-.964-1.126-1.251-.538-.27-1.252-.418-2.164-.506-.92-.089-2.1-.12-3.604-.12Z"
      clipRule="evenodd"
    />
  </svg>
)
export default SvgToggleIcon
