import type { SVGProps } from 'react'

const SvgHourglassIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={20}
    height={20}
    fill="none"
    viewBox="0 0 20 20"
    aria-hidden={true}
    focusable={false}
    {...props}
  >
    <path fill="currentColor" d="M6 5h8V3H6v2ZM6 17h8v-2H6v2Z" opacity={0.12} />
    <path
      fill="currentColor"
      fillRule="evenodd"
      d="M16 2.4H4v1.2h.925c.01.16.026.349.049.558.073.68.22 1.599.517 2.526C5.882 7.9 6.58 9.245 7.797 10c-1.218.755-1.915 2.1-2.306 3.316a12.9 12.9 0 0 0-.517 2.526c-.023.21-.038.397-.05.558H4v1.2h12v-1.2h-.925c-.01-.16-.026-.349-.049-.558-.073-.68-.22-1.599-.517-2.526-.392-1.216-1.088-2.561-2.306-3.316 1.218-.755 1.915-2.1 2.306-3.316.297-.927.444-1.845.517-2.526.023-.21.038-.397.049-.558H16V2.4Zm-2.128 1.2H6.128a13.2 13.2 0 0 0 .084.8h7.576a13.332 13.332 0 0 0 .084-.8Zm-.306 2H6.434c.057.236.123.477.2.716C7.175 8.001 8.16 9.4 10 9.4c1.839 0 2.825-1.4 3.366-3.084.077-.24.143-.48.2-.716Zm.306 10.8a12.792 12.792 0 0 0-.084-.8H6.212a13.382 13.382 0 0 0-.084.8h7.744Zm-.506-2.716c.077.24.143.48.2.716H6.434c.057-.236.123-.477.2-.716C7.175 11.999 8.16 10.6 10 10.6c1.839 0 2.825 1.4 3.366 3.084Z"
      clipRule="evenodd"
    />
  </svg>
)
export default SvgHourglassIcon
