import type { SVGProps } from 'react'

const SvgExpandLsIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={20}
    height={20}
    fill="none"
    viewBox="0 0 20 20"
    aria-hidden={true}
    focusable={false}
    {...props}
  >
    <path
      fill="currentColor"
      fillRule="evenodd"
      d="M6.966 17.373C6.853 16.906 6.5 15.042 6.5 10s.353-6.906.466-7.373C3.169 3.047 2.5 4.685 2.5 10s.669 6.953 4.466 7.373Z"
      clipRule="evenodd"
      opacity={0.12}
    />
    <path
      fill="currentColor"
      fillRule="evenodd"
      d="M3.1 10c0-1.619.063-2.852.247-3.8.182-.942.474-1.547.89-1.963.415-.416 1.021-.708 1.963-.89l.028-.006c-.024.172-.05.368-.074.593C6.026 5.086 5.9 6.984 5.9 10c0 3.015.126 4.914.254 6.066.025.225.05.421.074.593l-.028-.006c-.942-.182-1.548-.474-1.963-.89-.416-.416-.708-1.021-.89-1.963-.184-.948-.247-2.181-.247-3.8Zm4.367 6.818a15.732 15.732 0 0 1-.12-.884C7.223 14.836 7.1 12.984 7.1 10s.124-4.836.246-5.934c.043-.382.085-.671.12-.884A31.766 31.766 0 0 1 10 3.1c1.619 0 2.852.063 3.8.247.942.182 1.547.474 1.963.89.416.416.708 1.021.89 1.963.184.948.247 2.181.247 3.8 0 1.619-.063 2.852-.247 3.8-.182.942-.474 1.547-.89 1.963-.416.416-1.021.708-1.963.89-.948.184-2.181.247-3.8.247-.978 0-1.815-.023-2.533-.082ZM10 1.9c-1.631 0-2.96.062-4.028.269-1.074.208-1.937.573-2.584 1.22-.647.646-1.011 1.51-1.22 2.583C1.963 7.039 1.9 8.369 1.9 10c0 1.631.062 2.96.269 4.028.208 1.074.572 1.937 1.22 2.584.646.646 1.509 1.011 2.583 1.22 1.067.206 2.397.268 4.028.268 1.63 0 2.96-.062 4.028-.269 1.074-.208 1.937-.573 2.584-1.22.646-.646 1.011-1.51 1.22-2.583.206-1.067.268-2.397.268-4.028 0-1.631-.062-2.96-.269-4.028-.208-1.074-.573-1.937-1.22-2.584-.646-.646-1.51-1.011-2.583-1.22C12.961 1.963 11.631 1.9 10 1.9Zm5.348 8.1-.424.424-2.5 2.5-.848-.848 1.476-1.476H9V9.4h4.052l-1.476-1.476.848-.848 2.5 2.5.425.424Z"
      clipRule="evenodd"
    />
  </svg>
)
export default SvgExpandLsIcon
